/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.preferences;

import com.banknet.core.CorePlugin;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReportDownloadPreferenceInitializer {
    private static Document doc;
    private String[] optionprefs;
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);

    public String[] getPreferenceDefaults(Document doc) {
        ReportDownloadPreferenceInitializer.doc = doc;
        this.getReportNodes();
        return this.optionprefs;
    }

    private void getReportNodes() {
        String rptid = "";
        String prefs = "";
        String options = "";
        NodeList childNodes2 = doc.getElementsByTagName("report");
        int ii = 0;
        while (ii < childNodes2.getLength()) {
            Node item2 = childNodes2.item(ii);
            String nodeName2 = item2.getNodeName();
            if (nodeName2.equals("report")) {
                NamedNodeMap atrs = item2.getAttributes();
                rptid = ((Attr)atrs.item(0)).getNodeValue();
                options = this.getReportOptions(item2);
                if (options.length() > 0) {
                    prefs = String.valueOf(prefs) + rptid + ":" + options + "|";
                }
            }
            ++ii;
        }
        prefs = prefs.substring(0, prefs.length() - 1);
        this.optionprefs = this.s1.split(prefs, -1);
    }

    private String getReportOptions(Node node) {
        String options = "";
        NodeList childNodes2 = node.getChildNodes();
        int ii = 0;
        while (ii < childNodes2.getLength()) {
            Node item2 = childNodes2.item(ii);
            String nodeName2 = item2.getNodeName();
            if (nodeName2.equals("reportOption")) {
                NamedNodeMap atrs = item2.getAttributes();
                int jj = 0;
                while (jj < atrs.getLength()) {
                    if (((Attr)atrs.item(jj)).getNodeName().equals("value")) {
                        String option = ((Attr)atrs.item(jj)).getNodeValue();
                        String val = this.getOptionValue(item2);
                        options = String.valueOf(options) + option + "=" + val + ",";
                    }
                    ++jj;
                }
            }
            ++ii;
        }
        if (options.length() > 0) {
            options = options.substring(0, options.length() - 1);
        }
        return options;
    }

    private String getOptionValue(Node node) {
        String val = "";
        NodeList childNodes2 = node.getChildNodes();
        int ii = 0;
        while (ii < childNodes2.getLength()) {
            Node item2 = childNodes2.item(ii);
            String nodeName2 = item2.getNodeName();
            if (nodeName2.equals("optionValue")) {
                NamedNodeMap atrs = item2.getAttributes();
                Node valatr = atrs.getNamedItem("value");
                Node dfltatr = atrs.getNamedItem("default");
                val = valatr.getNodeValue();
                if (dfltatr.getNodeValue().equals("1")) {
                    return val;
                }
            }
            ++ii;
        }
        return val;
    }

    public void checkNewReport(Document doc) {
        String dfltoptions = "";
        String prefoptions = "";
        String rptid = "";
        ReportDownloadPreferenceInitializer.doc = doc;
        this.getReportNodes();
        int i = 0;
        while (i < this.optionprefs.length) {
            String[] optionpref = this.optionprefs[i].split(":");
            rptid = optionpref[0];
            if (optionpref.length > 1) {
                dfltoptions = optionpref[1];
                String[] dfltoptionsarr = dfltoptions.split(",");
                if (CorePlugin.getDefault().getPreferenceStore().getString(rptid).length() > 0) {
                    prefoptions = CorePlugin.getDefault().getPreferenceStore().getString(rptid);
                    String[] prefoptionsarr = prefoptions.split(",");
                    this.checkNewOptions(rptid, dfltoptionsarr, prefoptionsarr);
                    this.checkDelOptions(rptid, dfltoptionsarr, prefoptionsarr);
                } else {
                    String newprefoptions = dfltoptions;
                    CorePlugin.getDefault().getPreferenceStore().setValue(rptid, newprefoptions);
                    String logstr = "checkNewReport:  New report " + rptid + ": " + newprefoptions;
                    System.out.println("ReportDownloadPreferenceInitializer - " + logstr);
                    CorePlugin.getDefault().log.debug(logstr);
                }
            }
            ++i;
        }
    }

    private void checkNewOptions(String rptid, String[] dfltoptions, String[] prefoptions) {
        String dfltopt = "";
        String prefopt = "";
        String dfltval = "";
        boolean optfound = false;
        int i = 0;
        while (i < dfltoptions.length) {
            dfltopt = dfltoptions[i].substring(0, dfltoptions[i].indexOf("="));
            dfltval = dfltoptions[i].substring(dfltoptions[i].indexOf("=") + 1, dfltoptions[i].length());
            optfound = false;
            int j = 0;
            while (j < prefoptions.length) {
                prefopt = prefoptions[j].substring(0, prefoptions[j].indexOf("="));
                if (prefopt.equalsIgnoreCase(dfltopt)) {
                    optfound = true;
                    break;
                }
                ++j;
            }
            if (!optfound) {
                String newprefoptions = String.valueOf(CorePlugin.getDefault().getPreferenceStore().getString(rptid)) + "," + dfltopt + "=" + dfltval;
                CorePlugin.getDefault().getPreferenceStore().setValue(rptid, newprefoptions);
                String logstr = "checkNewOptions:  New report " + rptid + ": " + newprefoptions;
                System.out.println("ReportDownloadPreferenceInitializer - " + logstr);
                CorePlugin.getDefault().log.debug(logstr);
            }
            ++i;
        }
    }

    private void checkDelOptions(String rptid, String[] dfltoptions, String[] prefoptions) {
        String dfltopt = "";
        String prefopt = "";
        String prefval = "";
        boolean optfound = false;
        int i = 0;
        while (i < prefoptions.length) {
            prefopt = prefoptions[i].substring(0, prefoptions[i].indexOf("="));
            prefval = prefoptions[i].substring(prefoptions[i].indexOf("=") + 1, prefoptions[i].length());
            optfound = false;
            int j = 0;
            while (j < dfltoptions.length) {
                dfltopt = dfltoptions[j].substring(0, dfltoptions[j].indexOf("="));
                if (prefopt.equalsIgnoreCase(dfltopt)) {
                    optfound = true;
                    break;
                }
                ++j;
            }
            if (!optfound) {
                String delprefoption = String.valueOf(prefopt) + "=" + prefval;
                String delprefoptions = CorePlugin.getDefault().getPreferenceStore().getString(rptid).replace(delprefoption, "");
                if (delprefoptions.endsWith(",")) {
                    delprefoptions = delprefoptions.substring(0, delprefoptions.length() - 1);
                }
                CorePlugin.getDefault().getPreferenceStore().setValue(rptid, delprefoptions);
                String logstr = "checkDelOptions:  Delete report " + rptid + ": " + delprefoption;
                System.out.println("ReportDownloadPreferenceInitializer - " + logstr);
                CorePlugin.getDefault().log.debug(logstr);
            }
            ++i;
        }
    }
}

