/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.preferences;

import com.banknet.core.CorePlugin;
import com.banknet.core.preferences.Messages;
import com.banknet.core.preferences.PreferencesConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ObservationsListPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    PreferencesConstants pconstants = new PreferencesConstants();
    private Button confirmDelete;
    private Button confirmNotesDelete;
    private Combo sortSeq;
    private Button launchXml;
    private Button launchPdf;
    private Button obsListDoubleClick;
    private Table colstable;
    private Button upButton;
    private Button downButton;
    Shell shell;
    List<String> colprefs = new ArrayList<String>();
    List<String> colslist = new ArrayList<String>();
    String obscolsprefs = "";

    protected Control createContents(Composite parent) {
        this.shell = this.getShell();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".preferences_GeneralContext");
        Composite generalComp = new Composite(parent, 0);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        generalComp.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        generalComp.setLayout((Layout)layout);
        Group g3 = new Group(generalComp, 0);
        g3.setText(Messages.getString("ObservationsListPreferencePage.GroupLabel.ObsListColumns"));
        g3.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        g3.setLayout((Layout)new GridLayout(2, false));
        this.colstable = new Table((Composite)g3, 2848);
        this.initColsList("pref");
        this.loadColsTable();
        this.colstable.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int selcnt = 0;
                TableItem[] items = ObservationsListPreferencePage.this.colstable.getItems();
                int i = 0;
                while (i < items.length) {
                    String colkey = (String)items[i].getData();
                    if (colkey.equalsIgnoreCase("Reqnum") || colkey.equalsIgnoreCase("Reports")) {
                        items[i].setChecked(true);
                    }
                    if (items[i].getChecked()) {
                        ++selcnt;
                    }
                    ++i;
                }
                String sortseq = (String)ObservationsListPreferencePage.this.sortSeq.getData(String.valueOf(ObservationsListPreferencePage.this.sortSeq.getSelectionIndex()));
                ObservationsListPreferencePage.this.loadSortSeq();
                ObservationsListPreferencePage.this.setSortSeq(sortseq);
            }
        });
        GridData gd4 = new GridData(4, 4, true, false, 1, 1);
        this.colstable.setLayoutData((Object)gd4);
        int listHeight = this.colstable.getItemHeight() * 4;
        Rectangle trim2 = this.colstable.computeTrim(0, 0, 0, listHeight);
        gd4 = (GridData)this.colstable.getLayoutData();
        double tmph = trim2.height / 1;
        gd4.heightHint = (int)tmph;
        Composite buttonsComposite = new Composite((Composite)g3, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttonsComposite.setLayout((Layout)gridLayout);
        buttonsComposite.setLayoutData((Object)new GridData(4, 1, false, false));
        this.upButton = new Button(buttonsComposite, 8);
        this.upButton.setText("Up");
        this.upButton.setEnabled(true);
        GridData gdb = new GridData(4, 1, true, false);
        gdb.minimumWidth = 75;
        this.upButton.setLayoutData((Object)gdb);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selidx = ObservationsListPreferencePage.this.colstable.getSelectionIndex();
                int newselidx = 0;
                ArrayList<String> tmplist = new ArrayList<String>();
                if (selidx <= 2) {
                    return;
                }
                ObservationsListPreferencePage.this.buildcolprefs();
                int i = 0;
                while (i < ObservationsListPreferencePage.this.colslist.size()) {
                    if (i == selidx - 1) {
                        tmplist.add(ObservationsListPreferencePage.this.colslist.get(selidx));
                        newselidx = i;
                        tmplist.add(ObservationsListPreferencePage.this.colslist.get(i));
                    } else if (i != selidx) {
                        tmplist.add(ObservationsListPreferencePage.this.colslist.get(i));
                    }
                    ++i;
                }
                ObservationsListPreferencePage.this.colslist = tmplist;
                tmplist = null;
                ObservationsListPreferencePage.this.loadColsTable();
                ObservationsListPreferencePage.this.colstable.setSelection(newselidx);
            }
        });
        this.downButton = new Button(buttonsComposite, 8);
        this.downButton.setText("Down");
        this.downButton.setEnabled(true);
        gdb = new GridData(4, 1, true, false);
        gdb.minimumWidth = 75;
        this.downButton.setLayoutData((Object)gdb);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selidx = ObservationsListPreferencePage.this.colstable.getSelectionIndex();
                int newselidx = 0;
                ArrayList<String> tmplist = new ArrayList<String>();
                if (selidx >= ObservationsListPreferencePage.this.colslist.size() - 1 || selidx <= 1) {
                    return;
                }
                ObservationsListPreferencePage.this.buildcolprefs();
                int i = 0;
                while (i < ObservationsListPreferencePage.this.colslist.size()) {
                    if (i == selidx + 1) {
                        tmplist.add(ObservationsListPreferencePage.this.colslist.get(i));
                        newselidx = i;
                        tmplist.add(ObservationsListPreferencePage.this.colslist.get(selidx));
                    } else if (i != selidx) {
                        tmplist.add(ObservationsListPreferencePage.this.colslist.get(i));
                    }
                    ++i;
                }
                ObservationsListPreferencePage.this.colslist = tmplist;
                tmplist = null;
                ObservationsListPreferencePage.this.loadColsTable();
                ObservationsListPreferencePage.this.colstable.setSelection(newselidx);
            }
        });
        Group g2 = new Group(generalComp, 0);
        g2.setText(Messages.getString("ObservationsListPreferencePage.GroupLabel.Observations"));
        g2.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        g2.setLayout((Layout)new GridLayout(2, false));
        Label sortseqLabel = new Label((Composite)g2, 0);
        sortseqLabel.setText(Messages.getString("ObservationsListPreferencePage.Label.DfltSortSeq"));
        GridData gd = new GridData(1, 128, false, false);
        this.sortSeq = new Combo((Composite)g2, 8);
        this.loadSortSeq();
        this.setSortSeq(CorePlugin.getDefault().getPreferenceStore().getString("sortSeq").toLowerCase());
        this.confirmDelete = new Button((Composite)g2, 32);
        this.confirmDelete.setText(Messages.getString("ObservationsListPreferencePage.Checkbox.DelPrompt"));
        this.confirmDelete.setSelection(CorePlugin.getDefault().getPreferenceStore().getBoolean("confirmDelete"));
        gd = new GridData(1, 0x1000000, false, false, 2, 1);
        gd.heightHint = 20;
        this.confirmDelete.setLayoutData((Object)gd);
        this.confirmNotesDelete = new Button((Composite)g2, 32);
        this.confirmNotesDelete.setText(Messages.getString("ObservationsListPreferencePage.Checkbox.NotesDelPrompt"));
        this.confirmNotesDelete.setSelection(CorePlugin.getDefault().getPreferenceStore().getBoolean("confirmNotesDelete"));
        gd = new GridData(1, 0x1000000, false, false, 2, 1);
        gd.heightHint = 20;
        this.confirmNotesDelete.setLayoutData((Object)gd);
        this.launchXml = new Button((Composite)g2, 32);
        this.launchXml.setText(Messages.getString("ObservationsListPreferencePage.Checkbox.LaunchXml"));
        this.launchXml.setSelection(CorePlugin.getDefault().getPreferenceStore().getBoolean("launchXml"));
        gd = new GridData(1, 0x1000000, false, false, 2, 1);
        gd.heightHint = 20;
        this.launchXml.setLayoutData((Object)gd);
        this.launchPdf = new Button((Composite)g2, 32);
        this.launchPdf.setText(Messages.getString("ObservationsListPreferencePage.Checkbox.LaunchPdf"));
        this.launchPdf.setSelection(CorePlugin.getDefault().getPreferenceStore().getBoolean("launchPdf"));
        gd = new GridData(1, 0x1000000, false, false, 2, 1);
        gd.heightHint = 20;
        this.launchPdf.setLayoutData((Object)gd);
        this.obsListDoubleClick = new Button((Composite)g2, 32);
        this.obsListDoubleClick.setText(Messages.getString("ObservationsListPreferencePage.Checkbox.ObsListDoubleClick"));
        this.obsListDoubleClick.setSelection(CorePlugin.getDefault().getPreferenceStore().getBoolean("obsListDoubleClick"));
        gd = new GridData(1, 0x1000000, false, false, 2, 1);
        gd.heightHint = 20;
        this.obsListDoubleClick.setLayoutData((Object)gd);
        return generalComp;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(CorePlugin.getDefault().getPreferenceStore());
    }

    protected void performDefaults() {
        this.initColsList("default");
        this.loadColsTable();
        this.loadSortSeq();
        this.setSortSeq(CorePlugin.getDefault().getPreferenceStore().getDefaultString("sortSeq"));
        this.launchXml.setSelection(CorePlugin.getDefault().getPreferenceStore().getDefaultBoolean("launchXml"));
        this.launchPdf.setSelection(CorePlugin.getDefault().getPreferenceStore().getDefaultBoolean("launchPdf"));
        this.confirmDelete.setSelection(CorePlugin.getDefault().getPreferenceStore().getDefaultBoolean("confirmDelete"));
        this.confirmNotesDelete.setSelection(CorePlugin.getDefault().getPreferenceStore().getDefaultBoolean("confirmNotesDelete"));
        this.obsListDoubleClick.setSelection(CorePlugin.getDefault().getPreferenceStore().getDefaultBoolean("obsListDoubleClick"));
    }

    public boolean performOk() {
        this.updatePrefs();
        return super.performOk();
    }

    public void performApply() {
        this.updatePrefs();
    }

    private void initColsList(String pref) {
        this.colprefs = pref.equalsIgnoreCase("pref") ? Arrays.asList(CorePlugin.getDefault().getPreferenceStore().getString("obsListColumns").split(",")) : Arrays.asList(CorePlugin.getDefault().getPreferenceStore().getDefaultString("obsListColumns").split(","));
        String[] obscolsarr = CorePlugin.getDefault().constants.OBSLIST_COLUMNS.split(",");
        String[] obscolstextarr = CorePlugin.getDefault().constants.OBSLIST_COLTEXT.split(",");
        this.colslist = new ArrayList<String>();
        int i = 0;
        while (i < obscolsarr.length) {
            this.colslist.add(String.valueOf(obscolsarr[i]) + "," + obscolstextarr[i]);
            ++i;
        }
    }

    private void updatePrefs() {
        this.updateColsListPrefs();
        CorePlugin.getDefault().getPreferenceStore().setValue("sortSeq", (String)this.sortSeq.getData(String.valueOf(this.sortSeq.getSelectionIndex())));
        CorePlugin.getDefault().getPreferenceStore().setValue("confirmDelete", this.confirmDelete.getSelection());
        CorePlugin.getDefault().getPreferenceStore().setValue("launchXml", this.launchXml.getSelection());
        CorePlugin.getDefault().getPreferenceStore().setValue("launchPdf", this.launchPdf.getSelection());
        CorePlugin.getDefault().getPreferenceStore().setValue("obsListDoubleClick", this.obsListDoubleClick.getSelection());
        CorePlugin.getDefault().getPreferenceStore().setValue("confirmNotesDelete", this.confirmNotesDelete.getSelection());
    }

    private int updateColsListPrefs() {
        int rc = 0;
        this.buildcolprefs();
        if (this.colprefs.size() <= 4) {
            this.showMessage("error", Messages.getString("ObservationsListPreferencePage.MessageDialog.ColumnErrorTitle"), Messages.getString("ObservationsListPreferencePage.chkSelection.Minimum"));
            rc = -1;
        }
        CorePlugin.getDefault().getPreferenceStore().setValue("obsListColumns", this.obscolsprefs);
        return rc;
    }

    private void buildcolprefs() {
        this.obscolsprefs = "";
        TableItem[] items = this.colstable.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                this.obscolsprefs = String.valueOf(this.obscolsprefs) + (String)items[i].getData() + ",";
            }
            ++i;
        }
        if (this.obscolsprefs.length() > 0) {
            this.obscolsprefs = this.obscolsprefs.substring(0, this.obscolsprefs.length() - 1);
            this.colprefs = Arrays.asList(this.obscolsprefs.split(","));
        }
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
        }
    }

    private void loadColsTable() {
        int cnt = 0;
        this.colstable.setRedraw(false);
        this.colstable.removeAll();
        int i = 0;
        while (i < this.colslist.size()) {
            ++cnt;
            String[] colarr = this.colslist.get(i).split(",");
            TableItem item = new TableItem(this.colstable, 0);
            item.setText(colarr[1]);
            item.setData((Object)colarr[0]);
            if (this.colprefs.indexOf(colarr[0]) >= 0 || i <= 1) {
                item.setChecked(true);
            }
            ++i;
        }
        if (this.colstable.getSelectionIndex() < 0) {
            int selidx = 0;
            this.colstable.setSelection(selidx);
        }
        this.colstable.setRedraw(true);
        i = 1;
        while (i < this.colstable.getColumnCount()) {
            this.colstable.getColumn(i).pack();
            ++i;
        }
    }

    private void loadSortSeq() {
        this.sortSeq.setRedraw(false);
        this.sortSeq.removeAll();
        TableItem[] items = this.colstable.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                String coldata = (String)items[i].getData();
                this.sortSeq.setData(String.valueOf(this.sortSeq.getItemCount()), (Object)coldata.trim().toLowerCase());
                this.sortSeq.add(items[i].getText());
            }
            ++i;
        }
        if (this.sortSeq.getSelectionIndex() < 0) {
            this.sortSeq.select(0);
        }
        this.sortSeq.setRedraw(true);
    }

    private void setSortSeq(String sortseq) {
        if (sortseq != null) {
            int i = 0;
            while (i < this.sortSeq.getItemCount()) {
                if (sortseq.indexOf((String)this.sortSeq.getData(String.valueOf(i))) != -1) {
                    this.sortSeq.select(i);
                }
                ++i;
            }
        }
    }
}

