/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.preferences;

import com.banknet.core.CorePlugin;
import com.banknet.core.preferences.Messages;
import com.banknet.core.preferences.PreferencesConstants;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class EnvironmentPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    PreferencesConstants pconstants = new PreferencesConstants();
    Shell shell;
    private Button codePageDefault;
    private Button otherCodePage;
    private Combo codePageList;
    private Button autoUpdates;
    private Button showInactiveStcs;
    private Button addRepositoryButton;
    private Button removeRepositoryButton;
    private Table repositoryTable;
    private Button untrustedHostWarning;
    private Button colorMonochrome;
    private static String GLOBALBUFSIZE_LABEL = Messages.getString("EnvironmentPreferencePage.Label.GlobalBufSize");
    private String[] codePagePrefs;
    private String codePage;
    String[] repositoryLocations;
    private List<String> repositoryList;
    private String repositoryLocation;
    private String errmsg;

    public EnvironmentPreferencePage() {
        this.codePagePrefs = this.pconstants.CODEPAGE_PREFS.split(",");
        this.codePage = "";
        this.repositoryList = new ArrayList<String>();
        this.repositoryLocation = "";
        this.errmsg = "";
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(CorePlugin.getDefault().getPreferenceStore());
        this.loadRepositoryLocations();
    }

    protected Control createContents(Composite parent) {
        this.codePage = CorePlugin.getDefault().getPreferenceStore().getString("codePage");
        this.shell = parent.getShell();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".preferences_EnvironmentContext");
        Composite repositoryComp = new Composite(parent, 0);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        repositoryComp.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        repositoryComp.setLayout((Layout)layout);
        Group repositoryGroup = new Group(repositoryComp, 0);
        String msgstr = Messages.getString("EnvironmentPreferencePage.GroupLabel.Repository");
        msgstr = msgstr.replace("#productname", CorePlugin.getDefault().productextension.getProductName());
        repositoryGroup.setText(msgstr);
        repositoryGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        repositoryGroup.setLayout((Layout)new GridLayout(2, false));
        this.repositoryTable = new Table((Composite)repositoryGroup, 2848);
        this.loadRepositoryTable();
        this.repositoryTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int cfr_ignored_0 = event.index;
                TableItem[] tabitems = EnvironmentPreferencePage.this.repositoryTable.getItems();
                TableItem item = (TableItem)event.item;
                if (item != null) {
                    if (item.getChecked()) {
                        EnvironmentPreferencePage.this.repositoryLocation = item.getText();
                    } else if (item.getText().equals(EnvironmentPreferencePage.this.repositoryLocation)) {
                        EnvironmentPreferencePage.this.repositoryLocation = (String)EnvironmentPreferencePage.this.repositoryList.get(0);
                    }
                    int i = 0;
                    while (i < tabitems.length) {
                        if (tabitems.length == 1) {
                            tabitems[i].setChecked(true);
                            EnvironmentPreferencePage.this.repositoryLocation = tabitems[i].getText();
                        } else if (!tabitems[i].getText().equals(EnvironmentPreferencePage.this.repositoryLocation)) {
                            tabitems[i].setChecked(false);
                        }
                        ++i;
                    }
                }
            }
        });
        this.repositoryTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        GridData gd4 = new GridData(4, 4, true, false, 1, 1);
        this.repositoryTable.setLayoutData((Object)gd4);
        int listHeight = this.repositoryTable.getItemHeight() * 4;
        Rectangle trim2 = this.repositoryTable.computeTrim(0, 0, 0, listHeight);
        gd4 = (GridData)this.repositoryTable.getLayoutData();
        double tmph = trim2.height / 1;
        gd4.heightHint = (int)tmph;
        Composite buttonsComp = new Composite((Composite)repositoryGroup, 0);
        buttonsComp.setLayoutData((Object)new GridData(1, 4, true, false, 1, 1));
        buttonsComp.setLayout((Layout)new GridLayout(1, false));
        this.addRepositoryButton = new Button(buttonsComp, 8);
        this.addRepositoryButton.setText(Messages.getString("EnvironmentPreferencePage.Button.AddRepository"));
        GridData gdb = new GridData(4, 1, true, false, 1, 1);
        gdb.minimumWidth = 70;
        this.addRepositoryButton.setLayoutData((Object)gdb);
        this.addRepositoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String repository = EnvironmentPreferencePage.this.getRepositoryLocation();
                if (repository.length() > 0) {
                    EnvironmentPreferencePage.this.repositoryList.add(repository);
                    EnvironmentPreferencePage.this.loadRepositoryTable();
                }
            }
        });
        this.removeRepositoryButton = new Button(buttonsComp, 8);
        this.removeRepositoryButton.setText(Messages.getString("EnvironmentPreferencePage.Button.RemoveRepository"));
        gdb = new GridData(4, 1, true, false, 1, 1);
        gdb.minimumWidth = 70;
        this.removeRepositoryButton.setLayoutData((Object)gdb);
        this.removeRepositoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EnvironmentPreferencePage.this.repositoryTable.getSelection().length > 0) {
                    TableItem item = EnvironmentPreferencePage.this.repositoryTable.getSelection()[0];
                    if (item.getText().equals(EnvironmentPreferencePage.this.repositoryList.get(0)) & EnvironmentPreferencePage.this.repositoryList.size() <= 1) {
                        EnvironmentPreferencePage.this.repositoryLocation = (String)EnvironmentPreferencePage.this.repositoryList.get(0);
                        item.setChecked(true);
                    } else {
                        int i = 0;
                        while (i < EnvironmentPreferencePage.this.repositoryList.size()) {
                            if (item.getText().equals(EnvironmentPreferencePage.this.repositoryList.get(i))) {
                                if (item.getText().equals(EnvironmentPreferencePage.this.repositoryLocation)) {
                                    EnvironmentPreferencePage.this.repositoryLocation = "";
                                }
                                EnvironmentPreferencePage.this.repositoryList.remove(i);
                                break;
                            }
                            ++i;
                        }
                    }
                    EnvironmentPreferencePage.this.loadRepositoryTable();
                }
            }
        });
        Group g3 = new Group(repositoryComp, 0);
        g3.setText(Messages.getString("EnvironmentPreferencePage.GroupLabel.DataLoading"));
        g3.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        g3.setLayout((Layout)new GridLayout(1, false));
        this.showInactiveStcs = new Button((Composite)g3, 32);
        this.showInactiveStcs.setText(Messages.getString("EnvironmentPreferencePage.Checkbox.ShowInactiveStcs"));
        this.showInactiveStcs.setSelection(CorePlugin.getDefault().getPreferenceStore().getBoolean("showInactiveStcs"));
        GridData gd2 = new GridData(1, 0x1000000, false, false, 1, 1);
        this.showInactiveStcs.setLayoutData((Object)gd2);
        if (CorePlugin.getDefault().productextension.showAutoUpdates()) {
            this.autoUpdates = new Button((Composite)g3, 32);
            this.autoUpdates.setText(Messages.getString("EnvironmentPreferencePage.Checkbox.AutoUpdates"));
            this.autoUpdates.setSelection(CorePlugin.getDefault().getPreferenceStore().getBoolean("autoUpdates"));
            gd2 = new GridData(1, 0x1000000, false, false, 1, 1);
            this.autoUpdates.setLayoutData((Object)gd2);
        }
        this.untrustedHostWarning = new Button((Composite)g3, 32);
        this.untrustedHostWarning.setText(Messages.getString("EnvironmentPreferencePage.Checkbox.UntrustedHostWarning"));
        this.untrustedHostWarning.setSelection(CorePlugin.getDefault().getPreferenceStore().getBoolean("untrustedHostWarning"));
        gd2 = new GridData(1, 0x1000000, false, false, 1, 1);
        this.untrustedHostWarning.setLayoutData((Object)gd2);
        Group g2 = new Group(repositoryComp, 0);
        g2.setText(Messages.getString("EnvironmentPreferencePage.GroupLabel.TextEncoding"));
        g2.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        g2.setLayout((Layout)new GridLayout(2, false));
        this.codePageDefault = new Button((Composite)g2, 16);
        this.codePageDefault.setText(Messages.getString("EnvironmentPreferencePage.Radio.Default"));
        this.codePageDefault.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        if (this.codePage.equals(CorePlugin.getDefault().getPreferenceStore().getDefaultString("codePage"))) {
            this.codePageDefault.setSelection(true);
        }
        this.codePageDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnvironmentPreferencePage.this.codePageDefault.setSelection(true);
                EnvironmentPreferencePage.this.codePage = CorePlugin.getDefault().getPreferenceStore().getDefaultString("codePage");
                EnvironmentPreferencePage.this.otherCodePage.setSelection(false);
                EnvironmentPreferencePage.this.codePageList.setEnabled(false);
                EnvironmentPreferencePage.this.setCodePageSelect();
            }
        });
        Label codePageDefaultLabel = new Label((Composite)g2, 0);
        codePageDefaultLabel.setText("(" + CorePlugin.getDefault().getPreferenceStore().getDefaultString("codePage") + ")");
        codePageDefaultLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        this.otherCodePage = new Button((Composite)g2, 16);
        this.otherCodePage.setText(Messages.getString("EnvironmentPreferencePage.Radio.Other"));
        this.otherCodePage.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        this.otherCodePage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnvironmentPreferencePage.this.codePageDefault.setSelection(false);
                EnvironmentPreferencePage.this.otherCodePage.setSelection(true);
                EnvironmentPreferencePage.this.codePageList.setEnabled(true);
            }
        });
        this.codePageList = new Combo((Composite)g2, 8);
        this.codePageList.setEnabled(false);
        int i = 0;
        while (i < this.codePagePrefs.length) {
            this.codePageList.add(this.codePagePrefs[i]);
            ++i;
        }
        this.setCodePageSelect();
        this.codePageList.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        this.codePageList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnvironmentPreferencePage.this.codePage = (String)EnvironmentPreferencePage.this.codePageList.getData(String.valueOf(EnvironmentPreferencePage.this.codePageList.getSelection()));
            }
        });
        if (!this.codePage.equals(CorePlugin.getDefault().getPreferenceStore().getDefaultString("codePage"))) {
            this.codePageDefault.setSelection(false);
            this.otherCodePage.setSelection(true);
            this.codePageList.setEnabled(true);
        }
        Group g4 = new Group(repositoryComp, 0);
        g4.setText(Messages.getString("EnvironmentPreferencePage.GroupLabel.Coloring"));
        g4.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        g4.setLayout((Layout)new GridLayout(1, false));
        this.colorMonochrome = new Button((Composite)g4, 32);
        this.colorMonochrome.setText(Messages.getString("EnvironmentPreferencePage.Checkbox.ColorMonochrome"));
        this.colorMonochrome.setSelection(CorePlugin.getDefault().getPreferenceStore().getBoolean("colorMonochrome"));
        gd2 = new GridData(1, 0x1000000, false, false, 1, 1);
        this.colorMonochrome.setLayoutData((Object)gd2);
        return repositoryComp;
    }

    public boolean chkComplete() {
        boolean isComplete = true;
        this.errmsg = "";
        if (this.errmsg.length() > 0) {
            this.showMessage("error", Messages.getString("EnvironmentPreferencePage.MessageDialog.errorTitle"), this.errmsg);
        }
        return isComplete;
    }

    protected void performDefaults() {
        if (CorePlugin.getDefault().productextension.showAutoUpdates()) {
            this.autoUpdates.setSelection(CorePlugin.getDefault().getPreferenceStore().getDefaultBoolean("autoUpdates"));
        }
        this.untrustedHostWarning.setSelection(CorePlugin.getDefault().getPreferenceStore().getDefaultBoolean("untrustedHostWarning"));
        this.codePageDefault.setSelection(true);
        this.codePage = CorePlugin.getDefault().getPreferenceStore().getDefaultString("codePage");
        this.codePageDefault.setSelection(true);
        this.otherCodePage.setSelection(false);
        this.codePageList.setEnabled(false);
        this.setCodePageSelect();
        this.colorMonochrome.setEnabled(false);
        this.showInactiveStcs.setSelection(CorePlugin.getDefault().getPreferenceStore().getDefaultBoolean("showInactiveStcs"));
        this.repositoryList = null;
        this.repositoryList = new ArrayList<String>();
        this.repositoryLocation = CorePlugin.getDefault().getPreferenceStore().getDefaultString("coreDataPath");
        this.repositoryList.add(this.repositoryLocation);
        this.loadRepositoryTable();
    }

    public boolean performOk() {
        if (this.chkComplete()) {
            this.updatePrefs();
            return super.performOk();
        }
        return false;
    }

    public void performApply() {
        if (this.chkComplete()) {
            this.updatePrefs();
        }
    }

    private void updatePrefs() {
        CorePlugin.getDefault().getPreferenceStore().setValue("codePage", this.codePageList.getItem(this.codePageList.getSelectionIndex()));
        if (CorePlugin.getDefault().productextension.showAutoUpdates()) {
            CorePlugin.getDefault().getPreferenceStore().setValue("autoUpdates", this.autoUpdates.getSelection());
        }
        CorePlugin.getDefault().getPreferenceStore().setValue("untrustedHostWarning", this.untrustedHostWarning.getSelection());
        CorePlugin.getDefault().getPreferenceStore().setValue("coreDataPath", this.repositoryLocation);
        StringBuilder wrkstr = new StringBuilder();
        int i = 0;
        while (i < this.repositoryList.size()) {
            if (wrkstr.length() > 0) {
                wrkstr.append(",");
            }
            wrkstr.append(this.repositoryList.get(i));
            ++i;
        }
        CorePlugin.getDefault().getPreferenceStore().setValue("workspaceLocations", wrkstr.toString());
        CorePlugin.getDefault().getPreferenceStore().setValue("showInactiveStcs", this.showInactiveStcs.getSelection());
        CorePlugin.getDefault().getPreferenceStore().setValue("colorMonochrome", this.colorMonochrome.getSelection());
    }

    private void setCodePageSelect() {
        int i = 0;
        while (i < this.codePageList.getItemCount()) {
            if (this.codePage.equals(this.codePageList.getItem(i))) {
                this.codePageList.select(i);
            }
            ++i;
        }
    }

    public String getRepositoryLocation() {
        String foldername = "";
        DirectoryDialog dialog = null;
        dialog = new DirectoryDialog(this.shell, 4096);
        dialog.setFilterPath(this.repositoryLocation);
        dialog.setText(Messages.getString("EnvironmentPreferencePage.Dialog.Text.Repository"));
        foldername = dialog.open();
        if (foldername.length() > 0 && !foldername.substring(foldername.length(), foldername.length()).equals(Character.valueOf(File.separatorChar))) {
            foldername = String.valueOf(foldername) + File.separator;
        }
        dialog = null;
        return foldername;
    }

    private void loadRepositoryLocations() {
        this.repositoryLocations = CorePlugin.getDefault().getPreferenceStore().getString("workspaceLocations").split(",");
        int i = 0;
        while (i < this.repositoryLocations.length) {
            this.repositoryList.add(this.repositoryLocations[i]);
            ++i;
        }
        this.repositoryLocation = CorePlugin.getDefault().getPreferenceStore().getString("coreDataPath");
    }

    private void loadRepositoryTable() {
        this.repositoryTable.setRedraw(false);
        this.repositoryTable.removeAll();
        int i = 0;
        while (i < this.repositoryList.size()) {
            TableItem item = new TableItem(this.repositoryTable, 0);
            item.setText(this.repositoryList.get(i));
            if (this.repositoryList.get(i).equals(this.repositoryLocation)) {
                item.setChecked(true);
            } else if (this.repositoryLocation.length() <= 0) {
                this.repositoryLocation = this.repositoryList.get(i);
                item.setChecked(true);
            }
            ++i;
        }
        this.repositoryTable.setRedraw(true);
        i = 1;
        while (i < this.repositoryTable.getColumnCount()) {
            this.repositoryTable.getColumn(i).pack();
            ++i;
        }
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }
}

