/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.preferences;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.dialogs.connection.ConnectionSettingsDialog;
import com.banknet.core.dialogs.connection.CredentialSettingsDialog;
import com.banknet.core.preferences.Messages;
import com.banknet.core.preferences.PreferencesUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConnectionsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    ZosConnect zosconnect = new ZosConnect();
    Shell shell;
    PreferencesUtilities prefutils;
    ConnectionSettingsDialog csd;
    CredentialSettingsDialog rsd;
    Table connectionsTable;
    Table credentialsTable;
    private Button addConnectionButton;
    private Button editConnectionButton;
    private Button removeConnectionButton;
    private Button upButton;
    private Button downButton;
    private Button importButton;
    private Button exportButton;
    private Button addCredentialButton;
    private Button editCredentialButton;
    private Button removeCredentialButton;
    private List<String> credentialskeys = new ArrayList<String>();
    Hashtable credentialsdata = new Hashtable();
    private List<String> connectionskeys = new ArrayList<String>();
    Hashtable connectionsdata = new Hashtable();
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);
    String connectionid = "";
    String credentialid = "";
    IEclipsePreferences connprefs;
    IEclipsePreferences credprefs;
    String xmlfilename;
    String xmlfilter;
    String errmsg;
    String port;
    String host;
    String configid;
    String configname;
    String sslconnection;
    NamedNodeMap importatrs;
    int importcnt;
    final String XMLELEMENT_CONFIGID = "configID";
    final String XMLELEMENT_TYPE = "type";
    final String XMLATTRIB_TYPE = "type";
    final String XMLATTRIB_CONFIGID = "configID";
    final String XMLATTRIB_CONN_NAME = "name";
    final String XMLATTRIB_SERVER_NAME = "host";
    final String XMLATTRIB_PORT_NAME = "port";
    final String XMLATTRIB_SSL_CONNECTION = "SSL_CONNECTION";

    public ConnectionsPreferencePage() {
        StringBuilder stringBuilder = new StringBuilder("/instance/");
        CorePlugin.getDefault();
        this.connprefs = InstanceScope.INSTANCE.getNode(stringBuilder.append("com.banknet.core").append("/connections").toString());
        StringBuilder stringBuilder2 = new StringBuilder("/instance/");
        CorePlugin.getDefault();
        this.credprefs = InstanceScope.INSTANCE.getNode(stringBuilder2.append("com.banknet.core").append("/credentials").toString());
        this.xmlfilename = "";
        this.xmlfilter = "c:\\";
        this.errmsg = "";
        this.port = "";
        this.host = "";
        this.configid = "";
        this.configname = "";
        this.sslconnection = "true";
        this.importcnt = 0;
        this.XMLELEMENT_CONFIGID = "configID";
        this.XMLELEMENT_TYPE = "type";
        this.XMLATTRIB_TYPE = "type";
        this.XMLATTRIB_CONFIGID = "configID";
        this.XMLATTRIB_CONN_NAME = "name";
        this.XMLATTRIB_SERVER_NAME = "host";
        this.XMLATTRIB_PORT_NAME = "port";
        this.XMLATTRIB_SSL_CONNECTION = "SSL_CONNECTION";
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(CorePlugin.getDefault().getPreferenceStore());
        this.loadConnectionsList();
        this.loadCredentialsList();
    }

    protected Control createContents(Composite parent) {
        this.setValid(false);
        this.shell = parent.getShell();
        this.prefutils = new PreferencesUtilities(this.shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".preferences_NetworkContext");
        Composite connectionsComp = new Composite(parent, 0);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        connectionsComp.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        connectionsComp.setLayout((Layout)layout);
        Group connectionsgroup = new Group(connectionsComp, 0);
        connectionsgroup.setText(Messages.getString("ConnectionsPreferencePage.GroupLabel.Connections"));
        connectionsgroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        connectionsgroup.setLayout((Layout)new GridLayout(2, false));
        this.connectionsTable = new Table((Composite)connectionsgroup, 67588);
        this.connectionsTable.setHeaderVisible(true);
        this.connectionsTable.setLinesVisible(false);
        this.connectionsTable.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.connectionsTable.getLayoutData()).heightHint = 100;
        TableColumn column = new TableColumn(this.connectionsTable, 0);
        column.setWidth(0);
        column.setResizable(false);
        column = new TableColumn(this.connectionsTable, 16384);
        column.setText(Messages.getString("ConnectionsPreferencePage.Column.Connection"));
        column = new TableColumn(this.connectionsTable, 16384);
        column.setText(Messages.getString("ConnectionsPreferencePage.Column.Credential"));
        int i = 1;
        while (i < this.connectionsTable.getColumnCount()) {
            this.connectionsTable.getColumn(i).pack();
            ++i;
        }
        this.connectionsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.connectionsTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (ConnectionsPreferencePage.this.connectionsTable.getItem(new Point(e.x, e.y)) == null) {
                    ConnectionsPreferencePage.this.connectionsTable.deselectAll();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                ConnectionsPreferencePage.this.editConnection();
            }
        });
        Composite buttonsComposite = new Composite((Composite)connectionsgroup, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttonsComposite.setLayout((Layout)gridLayout);
        buttonsComposite.setLayoutData((Object)new GridData(4, 1, false, false));
        this.addConnectionButton = new Button(buttonsComposite, 8);
        this.addConnectionButton.setText(Messages.getString("ConnectionsPreferencePage.Button.Add"));
        GridData gdb = new GridData(4, 1, true, false);
        gdb.minimumWidth = 85;
        this.addConnectionButton.setLayoutData((Object)gdb);
        this.addConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionsPreferencePage.this.csd = new ConnectionSettingsDialog(ConnectionsPreferencePage.this.credentialsTable.getShell());
                ConnectionsPreferencePage.this.csd.credentialskeys = ConnectionsPreferencePage.this.credentialskeys;
                ConnectionsPreferencePage.this.csd.credentialsdata = ConnectionsPreferencePage.this.credentialsdata;
                int connrc = ConnectionsPreferencePage.this.csd.open();
                if (connrc == 0) {
                    ConnectionsPreferencePage.this.connectionid = ConnectionsPreferencePage.this.csd.connectionid;
                    ConnectionsPreferencePage.this.connectionskeys.add(ConnectionsPreferencePage.this.connectionid);
                    ConnectionsPreferencePage.this.updateConnectionsList();
                    ConnectionsPreferencePage.this.updateCredentialsList();
                }
                ConnectionsPreferencePage.this.csd = null;
            }
        });
        this.addConnectionButton.setEnabled(true);
        this.editConnectionButton = new Button(buttonsComposite, 8);
        this.editConnectionButton.setText(Messages.getString("ConnectionsPreferencePage.Button.Edit"));
        gdb = new GridData(4, 1, true, false);
        gdb.minimumWidth = 85;
        this.editConnectionButton.setLayoutData((Object)gdb);
        this.editConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionsPreferencePage.this.editConnection();
            }
        });
        this.removeConnectionButton = new Button(buttonsComposite, 8);
        this.removeConnectionButton.setText(Messages.getString("ConnectionsPreferencePage.Button.Remove"));
        gdb = new GridData(4, 1, true, false);
        gdb.minimumWidth = 85;
        this.removeConnectionButton.setLayoutData((Object)gdb);
        this.removeConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selidx = ConnectionsPreferencePage.this.connectionsTable.getSelectionIndex();
                String selkey = (String)ConnectionsPreferencePage.this.connectionskeys.get(selidx);
                ConnectionsPreferencePage.this.connectionid = "";
                ConnectionsPreferencePage.this.connectionsdata.remove(String.valueOf(selkey) + "/" + CorePlugin.getDefault().constants.CONNPREF_CONN_NAME);
                ConnectionsPreferencePage.this.connectionsdata.remove(String.valueOf(selkey) + "/" + CorePlugin.getDefault().constants.CONNPREF_CREDENTIAL_ID);
                ConnectionsPreferencePage.this.connectionsdata.remove(String.valueOf(selkey) + "/" + CorePlugin.getDefault().constants.CONNPREF_SERVER_NAME);
                ConnectionsPreferencePage.this.connectionsdata.remove(String.valueOf(selkey) + "/" + CorePlugin.getDefault().constants.CONNPREF_PORT_NAME);
                ConnectionsPreferencePage.this.connectionsdata.remove(String.valueOf(selkey) + "/" + CorePlugin.getDefault().constants.CONNPREF_OVERRIDE_SSL);
                ConnectionsPreferencePage.this.connectionsdata.remove(String.valueOf(selkey) + "/" + CorePlugin.getDefault().constants.CONNPREF_DEFAULT_STC);
                ConnectionsPreferencePage.this.connectionskeys.remove(selidx);
                ConnectionsPreferencePage.this.loadConnectionsTable();
            }
        });
        Composite importExportComposite = new Composite((Composite)connectionsgroup, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        importExportComposite.setLayout((Layout)gridLayout);
        importExportComposite.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        this.importButton = new Button(importExportComposite, 8);
        this.importButton.setText(Messages.getString("ConnectionsPreferencePage.Button.Import"));
        this.importButton.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/import_wiz.gif").createImage());
        this.importButton.setToolTipText(Messages.getString("ConnectionsPreferencePage.Button.Import"));
        GridData gd = new GridData(1, 0x1000000, false, false, 1, 1);
        gd.minimumWidth = 85;
        this.importButton.setLayoutData((Object)gd);
        this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionsPreferencePage.this.importConnection();
            }
        });
        this.exportButton = new Button(importExportComposite, 8);
        this.exportButton.setText(Messages.getString("ConnectionsPreferencePage.Button.Export"));
        this.exportButton.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/export_wiz.gif").createImage());
        this.exportButton.setToolTipText(Messages.getString("ConnectionsPreferencePage.Button.Export"));
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        gd.horizontalIndent = 20;
        gd.minimumWidth = 85;
        this.exportButton.setLayoutData((Object)gd);
        this.exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConnectionsPreferencePage.this.connectionskeys.size() > 0) {
                    ConnectionsPreferencePage.this.exportConnection();
                }
            }
        });
        Group credentialsgroup = new Group(connectionsComp, 0);
        credentialsgroup.setText(Messages.getString("ConnectionsPreferencePage.GroupLabel.Credentials"));
        credentialsgroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        credentialsgroup.setLayout((Layout)new GridLayout(2, false));
        this.credentialsTable = new Table((Composite)credentialsgroup, 67588);
        this.credentialsTable.setHeaderVisible(true);
        this.credentialsTable.setLinesVisible(false);
        this.credentialsTable.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.credentialsTable.getLayoutData()).heightHint = 100;
        column = new TableColumn(this.credentialsTable, 0);
        column.setWidth(0);
        column.setResizable(false);
        column = new TableColumn(this.credentialsTable, 16384);
        column.setText(Messages.getString("ConnectionsPreferencePage.Column.Credential"));
        column = new TableColumn(this.credentialsTable, 16384);
        column.setText(Messages.getString("ConnectionsPreferencePage.Column.Userid"));
        int i2 = 1;
        while (i2 < this.credentialsTable.getColumnCount()) {
            this.credentialsTable.getColumn(i2).pack();
            ++i2;
        }
        this.credentialsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.credentialsTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ConnectionsPreferencePage.this.credentialsTable.getItem(new Point(e.x, e.y));
            }

            public void mouseDoubleClick(MouseEvent e) {
                ConnectionsPreferencePage.this.editCredential();
            }
        });
        Composite buttonsComposite2 = new Composite((Composite)credentialsgroup, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttonsComposite2.setLayout((Layout)gridLayout);
        buttonsComposite2.setLayoutData((Object)new GridData(4, 1, false, false));
        this.addCredentialButton = new Button(buttonsComposite2, 8);
        this.addCredentialButton.setText(Messages.getString("ConnectionsPreferencePage.Button.Add"));
        gdb = new GridData(4, 1, true, false);
        gdb.minimumWidth = 85;
        this.addCredentialButton.setLayoutData((Object)gdb);
        this.addCredentialButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionsPreferencePage.this.rsd = new CredentialSettingsDialog(ConnectionsPreferencePage.this.credentialsTable.getShell());
                ConnectionsPreferencePage.this.rsd.showPsw = false;
                int credrc = ConnectionsPreferencePage.this.rsd.open();
                if (credrc == 0) {
                    ConnectionsPreferencePage.this.credentialid = ConnectionsPreferencePage.this.rsd.credentialid;
                    ConnectionsPreferencePage.this.credentialskeys.add(ConnectionsPreferencePage.this.credentialid);
                    ConnectionsPreferencePage.this.credentialsdata.put(ConnectionsPreferencePage.this.credentialid, ConnectionsPreferencePage.this.rsd.credential);
                    ConnectionsPreferencePage.this.loadCredentialsTable();
                }
                ConnectionsPreferencePage.this.rsd = null;
            }
        });
        this.addCredentialButton.setEnabled(true);
        this.editCredentialButton = new Button(buttonsComposite2, 8);
        this.editCredentialButton.setText(Messages.getString("ConnectionsPreferencePage.Button.Edit"));
        gdb = new GridData(4, 1, true, false);
        gdb.minimumWidth = 85;
        this.editCredentialButton.setLayoutData((Object)gdb);
        this.editCredentialButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionsPreferencePage.this.editCredential();
            }
        });
        this.removeCredentialButton = new Button(buttonsComposite2, 8);
        this.removeCredentialButton.setText(Messages.getString("ConnectionsPreferencePage.Button.Remove"));
        gdb = new GridData(4, 1, true, false);
        gdb.minimumWidth = 85;
        this.removeCredentialButton.setLayoutData((Object)gdb);
        this.removeCredentialButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selidx = ConnectionsPreferencePage.this.credentialsTable.getSelectionIndex();
                if (ConnectionsPreferencePage.this.chkRemoveCredential(selidx)) {
                    ConnectionsPreferencePage.this.credentialid = "";
                    ConnectionsPreferencePage.this.credentialsdata.remove(ConnectionsPreferencePage.this.credentialskeys.get(selidx));
                    ConnectionsPreferencePage.this.credentialskeys.remove(selidx);
                    ConnectionsPreferencePage.this.loadCredentialsTable();
                }
            }
        });
        this.loadConnectionsTable();
        this.loadCredentialsTable();
        this.chkComplete();
        return connectionsComp;
    }

    protected void performDefaults() {
        this.loadConnectionsList();
        this.loadCredentialsList();
        this.loadConnectionsTable();
        this.loadCredentialsTable();
    }

    public boolean performOk() {
        this.updatePrefs();
        return super.performOk();
    }

    public void performApply() {
        this.updatePrefs();
    }

    public boolean chkComplete() {
        boolean isComplete = true;
        this.setValid(false);
        this.setErrorMessage(null);
        if (isComplete) {
            this.setValid(true);
        }
        return isComplete;
    }

    private void loadConnectionsList() {
        String connkey = "";
        try {
            int i = 0;
            while (i < this.connprefs.childrenNames().length) {
                connkey = this.connprefs.childrenNames()[i];
                StringBuilder stringBuilder = new StringBuilder("/instance/");
                CorePlugin.getDefault();
                IEclipsePreferences childprefs = InstanceScope.INSTANCE.getNode(stringBuilder.append("com.banknet.core").append("/connections/").append(connkey).toString());
                if (childprefs.keys().length > 1) {
                    this.connectionskeys.add(connkey);
                    int j = 0;
                    while (j < childprefs.keys().length) {
                        this.connectionsdata.put(String.valueOf(connkey) + "/" + childprefs.keys()[j], childprefs.get(childprefs.keys()[j], ""));
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    private void loadCredentialsList() {
        try {
            int i = 0;
            while (i < this.credprefs.keys().length) {
                this.credentialskeys.add(this.credprefs.keys()[i]);
                this.credentialsdata.put(this.credprefs.keys()[i], this.credprefs.get(this.credprefs.keys()[i], ""));
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    private void loadConnectionsTable() {
        this.connectionsTable.setRedraw(false);
        this.connectionsTable.removeAll();
        if (this.connectionskeys.size() > 0) {
            int i = 0;
            while (i < this.connectionskeys.size()) {
                String connkey;
                String credkey = (String)this.connectionsdata.get(String.valueOf(this.connectionskeys.get(i)) + "/" + CorePlugin.getDefault().constants.CONNPREF_CREDENTIAL_ID);
                String conncredential = "";
                if (credkey != null && credkey.length() > 0) {
                    String[] credentialArr = this.s1.split((String)this.credentialsdata.get(credkey), -1);
                    conncredential = credentialArr[0];
                }
                if ((connkey = (String)this.connectionsdata.get(String.valueOf(this.connectionskeys.get(i)) + "/" + CorePlugin.getDefault().constants.CONNPREF_CONN_NAME)) != null && connkey.length() > 0) {
                    TableItem connectionItem = new TableItem(this.connectionsTable, 0);
                    connectionItem.setText(1, (String)this.connectionsdata.get(String.valueOf(this.connectionskeys.get(i)) + "/" + CorePlugin.getDefault().constants.CONNPREF_CONN_NAME));
                    connectionItem.setText(2, conncredential);
                    connectionItem.setData((Object)this.connectionskeys.get(i));
                    if (this.connectionid.length() <= 0 && i == 0) {
                        this.connectionsTable.setSelection(0);
                    } else if (this.connectionid.equalsIgnoreCase(this.connectionskeys.get(i))) {
                        this.connectionsTable.setSelection(i);
                    }
                }
                ++i;
            }
        }
        this.connectionsTable.setRedraw(true);
    }

    private void loadCredentialsTable() {
        this.credentialsTable.setRedraw(false);
        this.credentialsTable.removeAll();
        if (this.credentialskeys.size() > 0) {
            int i = 0;
            while (i < this.credentialskeys.size()) {
                String[] credentialArr = this.s1.split((String)this.credentialsdata.get(this.credentialskeys.get(i)), -1);
                TableItem credentialsItem = new TableItem(this.credentialsTable, 0);
                credentialsItem.setText(1, credentialArr[0]);
                credentialsItem.setText(2, credentialArr[1]);
                credentialsItem.setData((Object)this.credentialskeys.get(i));
                if (this.credentialid.length() <= 0 && i == 0) {
                    this.credentialsTable.setSelection(0);
                } else if (this.credentialid.equalsIgnoreCase(this.credentialskeys.get(i))) {
                    this.credentialsTable.setSelection(i);
                }
                ++i;
            }
        }
        this.credentialsTable.setRedraw(true);
    }

    private void editConnection() {
        int connrc;
        int selidx = this.connectionsTable.getSelectionIndex();
        this.connectionid = this.connectionskeys.get(selidx);
        this.csd = new ConnectionSettingsDialog(this.connectionsTable.getShell());
        this.csd.credentialskeys = this.credentialskeys;
        this.csd.credentialsdata = this.credentialsdata;
        this.csd.connectionid = this.connectionid;
        if ((String)this.connectionsdata.get(String.valueOf(this.connectionid) + "/" + CorePlugin.getDefault().constants.CONNPREF_CONN_NAME) != null) {
            this.csd.sconnName = (String)this.connectionsdata.get(String.valueOf(this.connectionid) + "/" + CorePlugin.getDefault().constants.CONNPREF_CONN_NAME);
        }
        if ((String)this.connectionsdata.get(String.valueOf(this.connectionid) + "/" + CorePlugin.getDefault().constants.CONNPREF_SERVER_NAME) != null) {
            this.csd.shostAddress = (String)this.connectionsdata.get(String.valueOf(this.connectionid) + "/" + CorePlugin.getDefault().constants.CONNPREF_SERVER_NAME);
        }
        if ((String)this.connectionsdata.get(String.valueOf(this.connectionid) + "/" + CorePlugin.getDefault().constants.CONNPREF_PORT_NAME) != null) {
            this.csd.scpuPort = (String)this.connectionsdata.get(String.valueOf(this.connectionid) + "/" + CorePlugin.getDefault().constants.CONNPREF_PORT_NAME);
        }
        if ((String)this.connectionsdata.get(String.valueOf(this.connectionid) + "/" + CorePlugin.getDefault().constants.CONNPREF_OVERRIDE_SSL) != null) {
            this.csd.sSslConnect = (String)this.connectionsdata.get(String.valueOf(this.connectionid) + "/" + CorePlugin.getDefault().constants.CONNPREF_OVERRIDE_SSL);
        }
        if ((String)this.connectionsdata.get(String.valueOf(this.connectionid) + "/" + CorePlugin.getDefault().constants.CONNPREF_CREDENTIAL_ID) != null) {
            this.csd.scredentialid = (String)this.connectionsdata.get(String.valueOf(this.connectionid) + "/" + CorePlugin.getDefault().constants.CONNPREF_CREDENTIAL_ID);
        }
        if ((connrc = this.csd.open()) == 0) {
            this.updateConnectionsList();
            this.updateCredentialsList();
        }
        this.csd = null;
    }

    private void updateConnectionsList() {
        this.connectionsdata.put(String.valueOf(this.connectionid) + "/" + CorePlugin.getDefault().constants.CONNPREF_CONN_NAME, this.csd.sconnName);
        this.connectionsdata.put(String.valueOf(this.connectionid) + "/" + CorePlugin.getDefault().constants.CONNPREF_SERVER_NAME, this.csd.shostAddress);
        this.connectionsdata.put(String.valueOf(this.connectionid) + "/" + CorePlugin.getDefault().constants.CONNPREF_PORT_NAME, this.csd.scpuPort);
        this.connectionsdata.put(String.valueOf(this.connectionid) + "/" + CorePlugin.getDefault().constants.CONNPREF_OVERRIDE_SSL, this.csd.sSslConnect);
        this.connectionsdata.put(String.valueOf(this.connectionid) + "/" + CorePlugin.getDefault().constants.CONNPREF_CREDENTIAL_ID, this.csd.scredentialid);
        this.loadConnectionsTable();
    }

    private void updateCredentialsList() {
        this.credentialskeys = this.csd.credentialskeys;
        this.credentialsdata = this.csd.credentialsdata;
        this.loadCredentialsTable();
    }

    private void editCredential() {
        int selidx = this.credentialsTable.getSelectionIndex();
        this.credentialid = this.credentialskeys.get(selidx);
        this.rsd = new CredentialSettingsDialog(this.credentialsTable.getShell());
        this.rsd.credentialid = this.credentialid;
        String[] credentialArr = this.s1.split((String)this.credentialsdata.get(this.credentialid), -1);
        this.rsd.credentialName = credentialArr[0];
        this.rsd.userId = credentialArr[1];
        String tmppsw = "";
        int i = 3;
        while (i < credentialArr.length) {
            if (tmppsw.length() > 0) {
                tmppsw = String.valueOf(tmppsw) + "|";
            }
            tmppsw = String.valueOf(tmppsw) + credentialArr[i];
            ++i;
        }
        this.rsd.encodedPsw = tmppsw;
        this.rsd.showPsw = false;
        int credrc = this.rsd.open();
        if (credrc == 0) {
            this.credentialsdata.put(this.credentialid, this.rsd.credential);
            this.loadCredentialsTable();
        }
        this.csd = null;
    }

    private void updatePrefs() {
        this.updateConnectionPrefs();
        this.updateCredentialPrefs();
        this.zosconnect.loadModelsJob();
    }

    private void updateConnectionPrefs() {
        String connectionkey = "";
        boolean keyfound = false;
        try {
            this.connprefs.clear();
            this.connprefs.flush();
            StringBuilder stringBuilder = new StringBuilder("/instance/");
            CorePlugin.getDefault();
            this.connprefs = InstanceScope.INSTANCE.getNode(stringBuilder.append("com.banknet.core").append("/connections").toString());
            int i = 0;
            while (i < this.connectionskeys.size()) {
                connectionkey = this.connectionskeys.get(i);
                StringBuilder stringBuilder2 = new StringBuilder("/instance/");
                CorePlugin.getDefault();
                IEclipsePreferences connpref = InstanceScope.INSTANCE.getNode(stringBuilder2.append("com.banknet.core").append("/connections/").append(connectionkey).toString());
                connpref.put(CorePlugin.getDefault().constants.CONNPREF_CONN_NAME, (String)this.connectionsdata.get(String.valueOf(connectionkey) + "/" + CorePlugin.getDefault().constants.CONNPREF_CONN_NAME));
                connpref.put(CorePlugin.getDefault().constants.CONNPREF_CREDENTIAL_ID, (String)this.connectionsdata.get(String.valueOf(connectionkey) + "/" + CorePlugin.getDefault().constants.CONNPREF_CREDENTIAL_ID));
                connpref.put(CorePlugin.getDefault().constants.CONNPREF_SERVER_NAME, (String)this.connectionsdata.get(String.valueOf(connectionkey) + "/" + CorePlugin.getDefault().constants.CONNPREF_SERVER_NAME));
                connpref.put(CorePlugin.getDefault().constants.CONNPREF_PORT_NAME, (String)this.connectionsdata.get(String.valueOf(connectionkey) + "/" + CorePlugin.getDefault().constants.CONNPREF_PORT_NAME));
                connpref.put(CorePlugin.getDefault().constants.CONNPREF_OVERRIDE_SSL, (String)this.connectionsdata.get(String.valueOf(connectionkey) + "/" + CorePlugin.getDefault().constants.CONNPREF_OVERRIDE_SSL));
                connpref.flush();
                ++i;
            }
            StringBuilder stringBuilder3 = new StringBuilder("/instance/");
            CorePlugin.getDefault();
            this.connprefs = InstanceScope.INSTANCE.getNode(stringBuilder3.append("com.banknet.core").append("/connections").toString());
            i = 0;
            while (i < this.connprefs.childrenNames().length) {
                keyfound = false;
                connectionkey = this.connprefs.childrenNames()[i];
                int j = 0;
                while (j < this.connectionskeys.size()) {
                    if (connectionkey.equalsIgnoreCase(this.connectionskeys.get(j))) {
                        keyfound = true;
                    }
                    ++j;
                }
                if (!keyfound) {
                    try {
                        StringBuilder stringBuilder4 = new StringBuilder("/instance/");
                        CorePlugin.getDefault();
                        IEclipsePreferences connpref = InstanceScope.INSTANCE.getNode(stringBuilder4.append("com.banknet.core").append("/connections/").append(connectionkey).toString());
                        connpref.clear();
                        connpref.removeNode();
                        this.connprefs.flush();
                        if (connectionkey.equalsIgnoreCase(CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId"))) {
                            CorePlugin.getDefault().getPreferenceStore().setValue("activeConnectionId", "");
                        }
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
            StringBuilder stringBuilder5 = new StringBuilder("/instance/");
            CorePlugin.getDefault();
            IEclipsePreferences connpref = InstanceScope.INSTANCE.getNode(stringBuilder5.append("com.banknet.core").append("/connections/").append(CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId")).toString());
            if (connpref.keys().length <= 0) {
                CorePlugin.getDefault().getPreferenceStore().setValue("activeConnectionId", this.connprefs.childrenNames()[0]);
            }
        }
        catch (BackingStoreException backingStoreException) {
        }
        catch (Exception exception) {}
    }

    private void updateCredentialPrefs() {
        try {
            this.credprefs.clear();
            int i = 0;
            while (i < this.credentialskeys.size()) {
                this.credprefs.put(this.credentialskeys.get(i), (String)this.credentialsdata.get(this.credentialskeys.get(i)));
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    private boolean chkRemoveCredential(int selidx) {
        boolean removeCredential = true;
        String conncredential = "";
        String credentialkey = this.credentialskeys.get(selidx);
        int i = 0;
        while (i < this.connectionskeys.size()) {
            conncredential = (String)this.connectionsdata.get(String.valueOf(this.connectionskeys.get(i)) + "/" + CorePlugin.getDefault().constants.CONNPREF_CREDENTIAL_ID);
            if (conncredential.equalsIgnoreCase(credentialkey)) {
                this.showMessage("error", Messages.getString("ConnectionsPreferencePage.MessageDialog.errorTitle.NetworkConnections"), Messages.getString("ConnectionsPreferencePage.chkRemoveCredential.ConnectionCredentials"));
                return false;
            }
            ++i;
        }
        return removeCredential;
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    private void exportConnection() {
        String exportXml = this.buildExportXml();
        try {
            File exportfile = this.getExportFile();
            if (exportfile != null) {
                FileOutputStream outputStream = new FileOutputStream(exportfile);
                PrintStream sysout = new PrintStream((OutputStream)outputStream, true, "UTF-8");
                sysout.print(exportXml);
                outputStream.close();
                outputStream = null;
                sysout = null;
                exportfile = null;
            }
        }
        catch (Exception e) {
            String logstr = "exportConnection:  exception " + e;
            System.out.println("ConnectionsPreferencePage " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            MessageDialog.openError((Shell)this.shell, (String)Messages.getString("ConnectionsPreferencePage.MessageDialog.errorTitle.SaveError"), (String)e.getLocalizedMessage());
        }
    }

    private String buildExportXml() {
        String connkey = "";
        StringBuilder xmlsb = new StringBuilder();
        xmlsb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xmlsb.append("  <connections>\n");
        int i = 0;
        while (i < this.connectionskeys.size()) {
            connkey = this.connectionskeys.get(i);
            xmlsb.append("    <type type=\"com.banknet.core.connection\">\n");
            xmlsb.append("      <configID");
            xmlsb.append(" configID=\"" + connkey + "\"");
            xmlsb.append(" name=\"" + (String)this.connectionsdata.get(String.valueOf(connkey) + "/" + CorePlugin.getDefault().constants.CONNPREF_CONN_NAME) + "\"");
            xmlsb.append(" SSL_CONNECTION=\"" + (String)this.connectionsdata.get(String.valueOf(connkey) + "/" + CorePlugin.getDefault().constants.CONNPREF_OVERRIDE_SSL) + "\"");
            xmlsb.append(" host=\"" + (String)this.connectionsdata.get(String.valueOf(connkey) + "/" + CorePlugin.getDefault().constants.CONNPREF_SERVER_NAME) + "\"");
            xmlsb.append(" port=\"" + (String)this.connectionsdata.get(String.valueOf(connkey) + "/" + CorePlugin.getDefault().constants.CONNPREF_PORT_NAME) + "\"");
            xmlsb.append(" />\n");
            xmlsb.append("    </type>\n");
            ++i;
        }
        xmlsb.append("  </connections>\n");
        return xmlsb.toString();
    }

    private File getExportFile() {
        boolean runSaveDialog = true;
        this.xmlfilename = String.valueOf(CorePlugin.getDefault().productextension.getProductPrefix()) + "_Connection.xml";
        File file = null;
        FileDialog dialog = null;
        while (runSaveDialog) {
            dialog = new FileDialog(this.shell, 8192);
            dialog.setFilterNames(new String[]{"Xml Documents (*.xml)"});
            dialog.setFilterExtensions(new String[]{"*.xml"});
            dialog.setFilterPath(this.xmlfilter);
            dialog.setFileName(this.xmlfilename);
            dialog.setText(Messages.getString("ConnectionsPreferencePage.Dialog.Text.SaveAs"));
            this.xmlfilename = dialog.open();
            if (this.xmlfilename != null) {
                if (!this.xmlfilename.contains(".")) {
                    this.xmlfilename = String.valueOf(this.xmlfilename) + ".xml";
                }
                if ((file = new File(this.xmlfilename)).exists()) {
                    if (MessageDialog.openConfirm((Shell)this.shell, (String)Messages.getString("ConnectionsPreferencePage.ConfirmDialog.ConfirmTitle.ReplaceFile"), (String)(String.valueOf(Messages.getString("ConnectionsPreferencePage.ConfirmDialog.ConfirmMessage.Replace")) + this.xmlfilename + "?"))) {
                        runSaveDialog = false;
                        continue;
                    }
                    file = null;
                    dialog = null;
                    continue;
                }
                runSaveDialog = false;
                continue;
            }
            runSaveDialog = false;
        }
        dialog = null;
        return file;
    }

    private void importConnection() {
        try {
            File importfile = this.getImportFile();
            if (importfile != null) {
                Document importxml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(importfile);
                this.parseImportXml(importxml);
            }
        }
        catch (Exception e) {
            String logstr = "importConnection:  exception " + e;
            System.out.println("ConnectionsPreferencePage " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            MessageDialog.openError((Shell)this.shell, (String)Messages.getString("ConnectionsPreferencePage.MessageDialog.errorTitle.OpenError"), (String)e.getMessage());
        }
    }

    private File getImportFile() {
        this.xmlfilename = String.valueOf(CorePlugin.getDefault().productextension.getProductPrefix()) + "_Connection";
        File file = null;
        FileDialog dialog = null;
        dialog = new FileDialog(this.shell, 4096);
        dialog.setFilterNames(new String[]{"Xml Documents (*.xml)", "Pref Files (*.pref)", "All Files (*.*)"});
        dialog.setFilterExtensions(new String[]{"*.xml", "*.pref*", "*.*"});
        dialog.setFileName(String.valueOf(this.xmlfilename) + ".xml");
        dialog.setFilterPath(this.xmlfilter);
        dialog.setText(Messages.getString("ConnectionsPreferencePage.Dialog.Text.Open"));
        String filename = dialog.open();
        dialog = null;
        if (filename != null) {
            file = new File(filename);
        }
        return file;
    }

    private void parseImportXml(Document importxml) {
        this.importcnt = 0;
        String importerrs = "";
        NodeList childNodes = importxml.getElementsByTagName("type");
        int ii = 0;
        while (ii < childNodes.getLength()) {
            Node item = childNodes.item(ii);
            NamedNodeMap atrs = item.getAttributes();
            if (((Attr)atrs.getNamedItem("type")).getValue().contains("com.banknet")) {
                NodeList childNodes2 = childNodes.item(ii).getChildNodes();
                int jj = 0;
                while (jj < childNodes2.getLength()) {
                    Node item2 = childNodes2.item(jj);
                    String nodeName2 = item2.getNodeName();
                    if (nodeName2.equals("configID")) {
                        this.importatrs = item2.getAttributes();
                        if (this.chkImportPrefs(ii)) {
                            this.insertImportPref();
                        } else {
                            importerrs = String.valueOf(importerrs) + "\n" + this.errmsg;
                        }
                    }
                    ++jj;
                }
            }
            ++ii;
        }
        if (this.importcnt > 0) {
            MessageDialog.openInformation((Shell)this.shell, (String)Messages.getString("ConnectionsPreferencePage.MessageDialog.infoTitle.ImportConnection"), (String)Messages.getString("ConnectionsPreferencePage.MessageDialog.ImportOk"));
        } else {
            MessageDialog.openError((Shell)this.shell, (String)Messages.getString("ConnectionsPreferencePage.MessageDialog.errorTitle.ImportError"), (String)Messages.getString("ConnectionsPreferencePage.MessageDialog.errorMessage.ImportErrorsFound"));
            String logstr = "parseImportXml: Errors inserting preferences: \n" + importerrs;
            System.out.println("ConnectionsPreferencePage: " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    private boolean chkImportPrefs(int itemnum) {
        boolean isComplete = true;
        this.errmsg = "";
        if (!this.chkHostAddress()) {
            isComplete = false;
        } else if (!this.chkCpuPort()) {
            isComplete = false;
        } else if (!this.chkConnectionId(itemnum)) {
            isComplete = false;
        }
        if (isComplete) {
            this.getConnectionNamePref();
            this.getSslPrefs();
        }
        return isComplete;
    }

    private boolean chkHostAddress() {
        boolean isValid = true;
        this.host = "";
        if ((Attr)this.importatrs.getNamedItem("host") != null) {
            this.host = ((Attr)this.importatrs.getNamedItem("host")).getValue();
        } else {
            this.errmsg = String.valueOf(Messages.getString("ConnectionsPreferencePage.ErrorMessage.Mandatory")) + Messages.getString("ConnectionsPreferencePage.Label.HostAddress");
        }
        if (this.errmsg.length() <= 0) {
            this.errmsg = this.chkMandatory(this.host, Messages.getString("ConnectionsPreferencePage.Label.HostAddress"));
        }
        if (this.errmsg.length() > 0) {
            isValid = false;
        }
        return isValid;
    }

    private boolean chkCpuPort() {
        boolean isValid = true;
        this.port = "";
        if ((Attr)this.importatrs.getNamedItem("port") != null) {
            this.port = ((Attr)this.importatrs.getNamedItem("port")).getValue();
        } else {
            this.errmsg = String.valueOf(Messages.getString("ConnectionsPreferencePage.ErrorMessage.Mandatory")) + Messages.getString("ConnectionsPreferencePage.Label.HostPort");
        }
        if (this.errmsg.length() <= 0 && this.port.length() > 5) {
            this.errmsg = Messages.getString("ConnectionsPreferencePage.chkCpuPort.ValueTooLong");
        }
        if (this.errmsg.length() <= 0) {
            this.errmsg = this.chkMandatory(this.port, Messages.getString("ConnectionsPreferencePage.Label.HostPort"));
        }
        if (this.errmsg.length() <= 0) {
            this.errmsg = this.chkInteger(this.port, Messages.getString("ConnectionsPreferencePage.Label.HostPort"));
        }
        if (this.errmsg.length() > 0) {
            isValid = false;
        }
        return isValid;
    }

    private boolean chkConnectionId(int itemnum) {
        boolean isValid = true;
        this.configid = "";
        this.configid = (Attr)this.importatrs.getNamedItem("configID") != null ? ((Attr)this.importatrs.getNamedItem("configID")).getValue() : String.valueOf(Math.abs(((Object)((Object)this)).hashCode())) + "_" + itemnum;
        int i = 0;
        while (i < this.connectionskeys.size()) {
            if (this.connectionskeys.get(i).equalsIgnoreCase(this.configid)) {
                this.errmsg = String.valueOf(Messages.getString("ConnectionsPreferencePage.MessageDialog.errorMessage.DuplicateConfigID")) + " " + this.configid;
            }
            ++i;
        }
        if (this.errmsg.length() > 0) {
            isValid = false;
        }
        return isValid;
    }

    private void getConnectionNamePref() {
        this.configname = "";
        if ((Attr)this.importatrs.getNamedItem("name") != null) {
            this.configname = ((Attr)this.importatrs.getNamedItem("name")).getValue();
        } else {
            String addr = this.host;
            if (this.host.indexOf(".") >= 0) {
                addr = this.host.substring(0, this.host.indexOf("."));
            }
            this.configname = String.valueOf(addr) + ":" + this.port;
        }
    }

    private void getSslPrefs() {
        this.sslconnection = "false";
        if ((Attr)this.importatrs.getNamedItem("SSL_CONNECTION") != null) {
            this.sslconnection = ((Attr)this.importatrs.getNamedItem("SSL_CONNECTION")).getValue();
        }
    }

    private String chkMandatory(String val, String varname) {
        if (val.length() <= 0) {
            this.errmsg = String.valueOf(Messages.getString("ConnectionsPreferencePage.ErrorMessage.Mandatory")) + varname;
        }
        return this.errmsg;
    }

    private String chkInteger(String val, String varname) {
        Integer ival = 0;
        String errmsg = "";
        try {
            ival = new Integer(val);
        }
        catch (NumberFormatException numberFormatException) {
            errmsg = String.valueOf(varname) + Messages.getString("ConnectionsPreferencePage.chkInteger.NotNumeric");
            return errmsg;
        }
        if (ival <= 0) {
            errmsg = String.valueOf(varname) + Messages.getString("ConnectionsPreferencePage.chkInteger.ValueTooSmall");
            return errmsg;
        }
        return errmsg;
    }

    private void insertImportPref() {
        String credkey = "";
        try {
            this.connectionid = this.configid;
            this.connectionskeys.add(this.connectionid);
            this.connectionsdata.put(String.valueOf(this.connectionid) + "/" + CorePlugin.getDefault().constants.CONNPREF_CONN_NAME, this.configname);
            this.connectionsdata.put(String.valueOf(this.connectionid) + "/" + CorePlugin.getDefault().constants.CONNPREF_SERVER_NAME, this.host);
            this.connectionsdata.put(String.valueOf(this.connectionid) + "/" + CorePlugin.getDefault().constants.CONNPREF_PORT_NAME, this.port);
            this.connectionsdata.put(String.valueOf(this.connectionid) + "/" + CorePlugin.getDefault().constants.CONNPREF_OVERRIDE_SSL, this.sslconnection);
            if (this.credentialskeys.size() > 0) {
                credkey = this.credentialskeys.get(0);
            }
            this.connectionsdata.put(String.valueOf(this.connectionid) + "/" + CorePlugin.getDefault().constants.CONNPREF_CREDENTIAL_ID, credkey);
            this.loadConnectionsTable();
            ++this.importcnt;
            String logstr = "insertImportPref: Imported " + this.connectionid;
            System.out.println("ConnectionsPreferencePage: " + logstr);
            CorePlugin.getDefault().log.info(logstr);
        }
        catch (Exception ex) {
            String logstr = "insertImportPref: Error inserting prefs: " + ex;
            System.out.println("ConnectionsPreferencePage: " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }
}

