/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.preferences;

import com.banknet.core.CorePlugin;
import com.banknet.core.preferences.Messages;
import com.banknet.core.preferences.PreferencesConstants;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class AppearancePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    PreferencesConstants pconstants = new PreferencesConstants();
    private Group statusLineGroup;
    private Table statusLineTable;
    public TableViewer statusLineViewer;
    String[] statusLineOptions;
    String[] statusLineOptionsText;
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(CorePlugin.getDefault().getPreferenceStore());
        this.statusLineOptions = CorePlugin.getDefault().getPreferenceStore().getString("statusLineOpts").split(",");
        this.statusLineOptionsText = Messages.getString("AppearancePreferencePage.Text.StatusLine.Options").split(",");
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".preferences_AppearanceContext");
        Composite appearanceComp = new Composite(parent, 0);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        appearanceComp.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        appearanceComp.setLayout((Layout)layout);
        this.statusLineGroup = new Group(appearanceComp, 0);
        this.statusLineGroup.setText(Messages.getString("AppearancePreferencePage.GroupLabel.StatusLine"));
        this.statusLineGroup.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.statusLineGroup.setLayout((Layout)new GridLayout(2, false));
        this.statusLineTable = new Table((Composite)this.statusLineGroup, 2848);
        this.loadStatusLineTable();
        this.statusLineTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        GridData gd4 = new GridData(4, 4, true, false, 2, 1);
        this.statusLineTable.setLayoutData((Object)gd4);
        int listHeight = this.statusLineTable.getItemHeight() * 8;
        Rectangle trim2 = this.statusLineTable.computeTrim(0, 0, 0, listHeight);
        gd4 = (GridData)this.statusLineTable.getLayoutData();
        double tmph = trim2.height / 1;
        gd4.heightHint = (int)tmph;
        return appearanceComp;
    }

    protected void performDefaults() {
        this.statusLineOptions = CorePlugin.getDefault().getPreferenceStore().getDefaultString("statusLineOpts").split(",");
        this.loadStatusLineTable();
    }

    public boolean performOk() {
        this.updatePrefs();
        CorePlugin.getDefault().getPreferenceStore().setValue("stcRefresh", true);
        return super.performOk();
    }

    public void performApply() {
        this.updatePrefs();
    }

    private void updatePrefs() {
        String statusOptions = "";
        TableItem[] items = this.statusLineTable.getItems();
        int i = 0;
        while (i < items.length) {
            statusOptions = String.valueOf(statusOptions) + (String)items[i].getData() + "|" + items[i].getChecked() + ",";
            ++i;
        }
        statusOptions = statusOptions.substring(0, statusOptions.length() - 1);
        CorePlugin.getDefault().getPreferenceStore().setValue("statusLineOpts", statusOptions);
    }

    private void loadStatusLineTable() {
        this.statusLineTable.setRedraw(false);
        this.statusLineTable.removeAll();
        int i = 0;
        while (i < this.statusLineOptions.length) {
            String[] options = this.s1.split(this.statusLineOptions[i], -1);
            TableItem item = new TableItem(this.statusLineTable, 0);
            item.setText(this.statusLineOptionsText[i]);
            if (options[1].equalsIgnoreCase("true")) {
                item.setChecked(true);
            }
            item.setData((Object)options[0]);
            ++i;
        }
        this.statusLineTable.setRedraw(true);
        i = 1;
        while (i < this.statusLineTable.getColumnCount()) {
            this.statusLineTable.getColumn(i).pack();
            ++i;
        }
    }
}

