/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.models;

import com.banknet.core.CorePlugin;
import com.banknet.core.dialogs.Messages;
import com.banknet.core.internal.Constants;
import com.banknet.core.models.ObservationsModel;
import com.banknet.core.models.ObservationsSearchItem;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ObservationsSearchItems {
    Constants constants = new Constants();
    public String searchText;
    public String searchFor;
    public Integer isearchText = null;
    public String searchTextLC;
    public Date fromDate;
    public Date toDate;
    private boolean caseSensitive;
    private boolean daterangeCheck;
    private boolean reqnumCheck;
    private boolean samplesCheck;
    private Integer fromReqnum = null;
    private Integer toReqnum = null;
    private Integer fromSamples = null;
    private Integer toSamples = null;
    final SimpleDateFormat yyyymmddhhmm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private List results;
    int modelsize = 0;
    int counter = 0;

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public void loadSearchList() {
        this.searchModel();
    }

    public void searchModel() {
        this.getSearchVars();
        this.results = new ArrayList();
        try {
            ObservationsModel observations = CorePlugin.getDefault().getObservationsModel();
            this.modelsize = observations.getChildren().size();
            int i = 0;
            while (i < observations.getChildren().size()) {
                ObservationsModel child = observations.getChildren().get(i);
                this.modelsize += child.getChildren().size();
                this.checkNode(child);
                if (child.getChildren().size() > 0) {
                    this.childLoop(child);
                }
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    private void getSearchVars() {
        this.searchText = CorePlugin.getDefault().getPreferenceStore().getString("SEARCHTEXT");
        this.searchTextLC = this.searchText.toLowerCase();
        this.searchFor = CorePlugin.getDefault().getPreferenceStore().getString("SEARCHFOR");
        this.caseSensitive = CorePlugin.getDefault().getPreferenceStore().getBoolean("CASESENSITIVE");
        this.daterangeCheck = CorePlugin.getDefault().getPreferenceStore().getBoolean("DATERANGECHECK");
        this.reqnumCheck = CorePlugin.getDefault().getPreferenceStore().getBoolean("REQNUMCHECK");
        this.samplesCheck = CorePlugin.getDefault().getPreferenceStore().getBoolean("SAMPLESCHECK");
        if (this.searchFor.equalsIgnoreCase(Messages.getString("ObservationsSearchDialog.All")) | this.searchFor.equalsIgnoreCase(Messages.getString("ObservationsSearchDialog.ReqNum")) | this.searchFor.equalsIgnoreCase(Messages.getString("ObservationsSearchDialog.Samples"))) {
            try {
                this.isearchText = new Integer(CorePlugin.getDefault().getPreferenceStore().getString("SEARCHTEXT"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (this.daterangeCheck) {
            try {
                this.fromDate = this.yyyymmddhhmm.parse(CorePlugin.getDefault().getPreferenceStore().getString("FROMDATE"));
                this.toDate = this.yyyymmddhhmm.parse(CorePlugin.getDefault().getPreferenceStore().getString("TODATE"));
            }
            catch (ParseException ex) {
                String logstr = "getSearchVars:  Error Parsing ObservationsSearchItems fromDate/toDate. " + ex;
                System.out.println("ObservationsSearchItems: " + logstr);
                CorePlugin.getDefault().log.error(logstr);
            }
        }
        if (this.reqnumCheck) {
            try {
                if (CorePlugin.getDefault().getPreferenceStore().getString("FROMREQNUM") != null) {
                    this.fromReqnum = new Integer(CorePlugin.getDefault().getPreferenceStore().getString("FROMREQNUM"));
                }
                if (CorePlugin.getDefault().getPreferenceStore().getString("TOREQNUM") != null) {
                    this.toReqnum = new Integer(CorePlugin.getDefault().getPreferenceStore().getString("TOREQNUM"));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (this.samplesCheck) {
            try {
                if (CorePlugin.getDefault().getPreferenceStore().getString("FROMSAMPLES") != null) {
                    this.fromSamples = new Integer(CorePlugin.getDefault().getPreferenceStore().getString("FROMSAMPLES"));
                }
                if (CorePlugin.getDefault().getPreferenceStore().getString("TOSAMPLES") != null) {
                    this.toSamples = new Integer(CorePlugin.getDefault().getPreferenceStore().getString("TOSAMPLES"));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private void childLoop(ObservationsModel tree) {
        int j = 0;
        while (j < tree.getChildren().size()) {
            ObservationsModel child = tree.getChildren().get(j);
            this.modelsize += child.getChildren().size();
            this.checkNode(child);
            if (child.getChildren().size() > 0) {
                this.child2Loop(child);
            }
            ++j;
        }
    }

    private void child2Loop(ObservationsModel tree) {
        int j = 0;
        while (j < tree.getChildren().size()) {
            ObservationsModel child = tree.getChildren().get(j);
            this.modelsize += child.getChildren().size();
            this.checkNode(child);
            if (child.getChildren().size() > 0) {
                this.child3Loop(child);
            }
            ++j;
        }
    }

    private void child3Loop(ObservationsModel tree) {
        int j = 0;
        while (j < tree.getChildren().size()) {
            ObservationsModel child = tree.getChildren().get(j);
            this.modelsize += child.getChildren().size();
            this.checkNode(child);
            if (child.getChildren().size() > 0) {
                this.child4Loop(child);
            }
            ++j;
        }
    }

    private void child4Loop(ObservationsModel tree) {
        int j = 0;
        while (j < tree.getChildren().size()) {
            ObservationsModel child = tree.getChildren().get(j);
            this.modelsize += child.getChildren().size();
            this.checkNode(child);
            if (child.getChildren().size() > 0) {
                this.child5Loop(child);
            }
            ++j;
        }
    }

    private void child5Loop(ObservationsModel tree) {
        int j = 0;
        while (j < tree.getChildren().size()) {
            ObservationsModel child = tree.getChildren().get(j);
            this.modelsize += child.getChildren().size();
            this.checkNode(child);
            ++j;
        }
    }

    private void checkNode(ObservationsModel node) {
        boolean additem = false;
        if (this.searchText.length() <= 0) {
            additem = true;
        } else if (this.searchFor.equalsIgnoreCase(Messages.getString("ObservationsSearchDialog.All"))) {
            if (this.isearchText != null) {
                additem = this.matchInteger(node.reqnum);
            }
            if (!additem) {
                additem = this.matchString(node.ownedby);
            }
            if (!additem) {
                additem = this.matchString(node.r02Description);
            }
            if (!additem) {
                additem = this.matchString(node.jobname);
            }
            if (!additem && this.isearchText != null) {
                additem = this.matchInteger(node.samples);
            }
            if (!additem) {
                additem = this.matchString(node.statusShort);
            }
        } else if (this.isearchText != null && this.searchFor.equalsIgnoreCase(Messages.getString("ObservationsSearchDialog.ReqNum"))) {
            additem = this.matchInteger(node.reqnum);
        } else if (this.searchFor.equalsIgnoreCase(Messages.getString("ObservationsSearchDialog.OwnedBy"))) {
            additem = this.matchString(node.ownedby);
        } else if (this.searchFor.equalsIgnoreCase(Messages.getString("ObservationsSearchDialog.Description"))) {
            additem = this.matchString(node.r02Description);
        } else if (this.searchFor.equalsIgnoreCase(Messages.getString("ObservationsSearchDialog.DateTime"))) {
            additem = this.matchDate(node.reqdate);
        } else if (this.isearchText != null && this.searchFor.equalsIgnoreCase(Messages.getString("ObservationsSearchDialog.Samples"))) {
            additem = this.matchInteger(node.samples);
        } else if (this.searchFor.equalsIgnoreCase(Messages.getString("ObservationsSearchDialog.JobName"))) {
            additem = this.matchString(node.jobname);
        } else if (this.searchFor.equalsIgnoreCase(Messages.getString("ObservationsSearchDialog.Status"))) {
            additem = this.matchString(node.statusShort);
        }
        if (additem && this.daterangeCheck) {
            additem = this.matchDate(node.reqdate);
        }
        if (additem && this.reqnumCheck) {
            additem = this.matchIntegerRange(node.reqnum, this.fromReqnum, this.toReqnum);
        }
        if (additem && this.samplesCheck) {
            additem = this.matchIntegerRange(node.samples, this.fromSamples, this.toSamples);
        }
        if (additem) {
            ++this.counter;
            ObservationsSearchItem item = new ObservationsSearchItem();
            item.setReqnum(node.reqnum);
            item.setDescription(node.r02Description);
            item.setJobname(node.jobname);
            item.setCounter(this.counter);
            this.results.add(item);
        }
    }

    private boolean matchString(String itemString) {
        boolean matchfound = false;
        if (itemString == null) {
            return matchfound;
        }
        String itemStringLC = itemString.toLowerCase();
        if (this.caseSensitive) {
            if (itemString.indexOf(this.searchText) >= 0) {
                matchfound = true;
            }
        } else if (itemStringLC.indexOf(this.searchTextLC) >= 0) {
            matchfound = true;
        }
        return matchfound;
    }

    private boolean matchDate(Date itemDatetime) {
        boolean inBetween;
        boolean matchfound = false;
        if (itemDatetime == null) {
            return matchfound;
        }
        boolean bl = inBetween = this.fromDate.before(itemDatetime) && this.toDate.after(itemDatetime);
        if (inBetween) {
            matchfound = true;
        }
        return matchfound;
    }

    private boolean matchInteger(Integer itemInt) {
        boolean matchfound = false;
        if (itemInt == null) {
            return matchfound;
        }
        if (itemInt.equals(this.isearchText)) {
            matchfound = true;
        }
        return matchfound;
    }

    private boolean matchIntegerRange(Integer itemInt, Integer fromInt, Integer toInt) {
        boolean matchfound = false;
        boolean isBefore = false;
        boolean isAfter = false;
        if (itemInt == null) {
            return matchfound;
        }
        if (fromInt != null) {
            if (itemInt >= fromInt) {
                isBefore = true;
            }
        } else {
            isBefore = true;
        }
        if (toInt != null) {
            if (itemInt <= toInt) {
                isAfter = true;
            }
        } else {
            isAfter = true;
        }
        if (isBefore && isAfter) {
            matchfound = true;
        }
        return matchfound;
    }

    private void walkObservations() {
        int i = 0;
        while (i < CorePlugin.getDefault().observations.size()) {
            ObservationsModel temp = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(CorePlugin.getDefault().observationId.get(i)));
            this.checkNode(temp);
            ++i;
        }
    }

    public List getResults() {
        return this.results;
    }
}

