/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.models;

import com.banknet.core.CorePlugin;
import com.banknet.core.models.Messages;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;

public class ObservationsModel {
    public ObservationsModel parent;
    public ArrayList child = new ArrayList();
    public Integer reqnum = null;
    public Integer reqlink = null;
    public String variant = null;
    public String ownedby = null;
    public String description = null;
    public String jobname = null;
    public Date reqdate = null;
    public Integer samplesDone = null;
    public String statusCode = null;
    public String notes1 = "";
    public String notes2 = "";
    public String notes3 = "";
    public String dsname = null;
    public Integer samples = null;
    public String asid = null;
    public String jobid = null;
    public String system = null;
    public Integer interval = null;
    public Integer duration = null;
    public Date sessionStart = null;
    public Date sessionEnd = null;
    public Long sessionDuration = null;
    public Date sessionDeleteDate = null;
    public Integer repeatTimes = null;
    public Date repeatBeforeDate = null;
    public boolean cicsExtractor = false;
    public boolean cicsiExtractor = false;
    public boolean imsExtractor = false;
    public boolean imsiExtractor = false;
    public boolean db2Extractor = false;
    public boolean db2iExtractor = false;
    public boolean db2vExtractor = false;
    public boolean db2xExtractor = false;
    public boolean cdb2Extractor = false;
    public boolean mqseriesExtractor = false;
    public boolean javaExtractor = false;
    public boolean naturalExtractor = false;
    public boolean adabasExtractor = false;
    public boolean wasExtractor = false;
    public boolean srbExtractor = false;
    public boolean mqiExtractor = false;
    public boolean sysExtractor = false;
    public boolean wlpExtractor = false;
    public String thresSettings = null;
    public String statusLong = null;
    public String statusShort = null;
    public byte[] deleteFlag;
    public Integer reasonCode = null;
    public Integer r02Samples = null;
    public Date sessionDateTime = null;
    public Integer stepNum = null;
    public String stepName = null;
    public String procStep = null;
    public String progName = null;
    public String selectMstep = null;
    public Integer stepsSched = null;
    public Integer itemsSched = null;
    public String[] stepInfo = null;
    public String[] schedInfo = null;
    public List<String> listSchedInfo = new ArrayList<String>();
    public String db2Type = null;
    public String db2Subsystem = null;
    public String db2Schema = null;
    public String db2Name = null;
    public boolean db2IsGroup = false;
    public boolean cdb2 = false;
    public String imsSubsystemId = null;
    public String imsTranCode = null;
    public String imsTxnCode = null;
    public String imsProgramName = null;
    public String imsUserId = null;
    public String parentVariant = "";
    public String validateSystem = null;
    public Integer triggers = null;
    public Integer triggeredBy = null;
    public String r02Description = null;
    public String flags3Type = null;
    public boolean reportsAvail = false;
    public String reportsDownloaded = "";
    public boolean tagObservation = false;
    public boolean importedObservation = false;
    public Integer deleteDays;
    public Color deleteDaysColor = null;
    public Integer runAgainCtr = 0;
    public Integer runAgainMins = 0;
    public Integer runAgainFor = 0;
    public boolean stickyNotes = false;
    public boolean udsn = false;
    public int counter;
    public int treeLevel = -1;
    public int pmexReqnum = 0;
    public boolean wasServantSampling = false;
    public String wasServantObsDsname = "";
    public boolean ltbe64 = false;
    public String templateName = "";
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);
    SimpleDateFormat dtfmt = new SimpleDateFormat("EEEE MMM dd yyyy HH:mm:ss.SS");

    public ObservationsModel(ObservationsModel parent) {
        this.parent = parent;
    }

    public Integer getReqnum() {
        return this.reqnum;
    }

    public Integer getReqlink() {
        return this.reqlink;
    }

    public String getVariant() {
        return this.variant;
    }

    public String getOwnedby() {
        return this.ownedby;
    }

    public String getDescription() {
        return this.description;
    }

    public String getJobname() {
        return this.jobname;
    }

    public Date getReqdate() {
        return this.reqdate;
    }

    public Integer getSamplesDone() {
        return this.samplesDone;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public String getNotes1() {
        return this.notes1;
    }

    public String getNotes2() {
        return this.notes2;
    }

    public String getNotes3() {
        return this.notes3;
    }

    public String getDsname() {
        return this.dsname;
    }

    public boolean getUDSN() {
        return this.udsn;
    }

    public Integer getSamples() {
        return this.samples;
    }

    public String getAsid() {
        return this.asid;
    }

    public String getJobid() {
        return this.jobid;
    }

    public String getSystem() {
        return this.system;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public Date getSessionStart() {
        return this.sessionStart;
    }

    public Date getSessionEnd() {
        return this.sessionEnd;
    }

    public Long getSessionDuration() {
        return this.sessionDuration;
    }

    public Date getSessionDeleteDate() {
        return this.sessionDeleteDate;
    }

    public Integer getRepeatTimes() {
        return this.repeatTimes;
    }

    public Date getRepeatBeforeDate() {
        return this.repeatBeforeDate;
    }

    public boolean getCicsExtractor() {
        return this.cicsExtractor;
    }

    public boolean getCicsiExtractor() {
        return this.cicsiExtractor;
    }

    public boolean getImsExtractor() {
        return this.imsExtractor;
    }

    public boolean getImsiExtractor() {
        return this.imsiExtractor;
    }

    public boolean getDb2Extractor() {
        return this.db2Extractor;
    }

    public boolean getDb2iExtractor() {
        return this.db2iExtractor;
    }

    public boolean getDb2vExtractor() {
        return this.db2vExtractor;
    }

    public boolean getDb2xExtractor() {
        return this.db2xExtractor;
    }

    public boolean getCdb2Extractor() {
        return this.cdb2Extractor;
    }

    public boolean getMqseriesExtractor() {
        return this.mqseriesExtractor;
    }

    public boolean getJavaExtractor() {
        return this.javaExtractor;
    }

    public boolean getNaturalExtractor() {
        return this.naturalExtractor;
    }

    public boolean getAdabasExtractor() {
        return this.adabasExtractor;
    }

    public boolean getSrbExtractor() {
        return this.srbExtractor;
    }

    public String getThresSettings() {
        return this.thresSettings;
    }

    public Integer getStepNum() {
        return this.stepNum;
    }

    public String getStepName() {
        return this.stepName;
    }

    public String getProcStep() {
        return this.procStep;
    }

    public String getProgName() {
        return this.progName;
    }

    public String getSelectMstep() {
        return this.selectMstep;
    }

    public Integer getStepsSched() {
        return this.stepsSched;
    }

    public Integer getItemsSched() {
        return this.itemsSched;
    }

    public String getStatusLong() {
        return this.statusLong;
    }

    public String getStatusShort() {
        return this.statusShort;
    }

    public byte[] getDeleteFlag() {
        return this.deleteFlag;
    }

    public Integer getReasonCode() {
        return this.reasonCode;
    }

    public Integer getR02Samples() {
        return this.r02Samples;
    }

    public Date getSessionDateTime() {
        return this.sessionDateTime;
    }

    public String getR02Description() {
        return this.r02Description;
    }

    public String getFlags3Type() {
        return this.flags3Type;
    }

    public String[] getStepInfo() {
        return this.stepInfo;
    }

    public String[] getSchedInfo() {
        String logstr;
        int listidx = 0;
        String[] list = null;
        String[] scheditem = null;
        ArrayList<Date> listdates = new ArrayList<Date>();
        ArrayList<String> displaySched = new ArrayList<String>();
        if (this.variant.equalsIgnoreCase("P")) {
            return list;
        }
        if (this.schedInfo != null) {
            int i = 0;
            while (i < this.schedInfo.length) {
                scheditem = this.s1.split(this.schedInfo[i], -1);
                if (scheditem[1].trim().length() <= 0 || scheditem[1].equalsIgnoreCase(Messages.getString("ObservationsModel.Schedflag.Expired"))) {
                    displaySched.add(this.schedInfo[i]);
                    try {
                        listdates.add(this.dtfmt.parse(scheditem[0]));
                    }
                    catch (ParseException ex) {
                        logstr = "getSchedInfo:  Error Parsing schedInfo Date. " + ex;
                        System.out.println("ObservationsModel: " + logstr);
                        CorePlugin.getDefault().log.error(logstr);
                    }
                }
                ++i;
            }
        }
        if (this.listSchedInfo.size() > 0) {
            int j = 0;
            while (j < this.listSchedInfo.size()) {
                scheditem = this.s1.split(this.listSchedInfo.get(j), -1);
                displaySched.add(this.listSchedInfo.get(j));
                try {
                    listdates.add(this.dtfmt.parse(scheditem[0]));
                }
                catch (ParseException ex) {
                    logstr = "getSchedInfo:  Error Parsing listSchedInfo Date. " + ex;
                    System.out.println("ObservationsModel: " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                }
                ++j;
            }
        }
        if (listdates.size() > 0) {
            Collections.sort(listdates);
            list = new String[listdates.size()];
            block6: for (Date dt : listdates) {
                String sortedDate = this.dtfmt.format(dt);
                int j = 0;
                while (j < displaySched.size()) {
                    scheditem = this.s1.split((CharSequence)displaySched.get(j), -1);
                    if (sortedDate.equals(scheditem[0])) {
                        list[listidx] = (String)displaySched.get(j);
                        ++listidx;
                        continue block6;
                    }
                    ++j;
                }
            }
        }
        return list;
    }

    public String getSchedGroupTitle() {
        String title = "";
        if (this.variant.equalsIgnoreCase("J")) {
            title = Messages.getString("ObservationsModel.SchedGroupTitle.MultiJob");
        } else if (this.variant.equalsIgnoreCase("I")) {
            title = Messages.getString("ObservationsModel.SchedGroupTitle.ImsMassInfo");
        } else if (this.variant.equalsIgnoreCase("M")) {
            title = this.statusShort.equalsIgnoreCase(Messages.getString("ObservationsModel.Status.Steps")) ? Messages.getString("ObservationsModel.SchedGroupTitle.StepInfo") : Messages.getString("ObservationsModel.SchedGroupTitle.ScheduleInfo");
        } else if (this.variant.equalsIgnoreCase("T")) {
            title = Messages.getString("ObservationsModel.SchedGroupTitle.ThresholdInfo");
        } else if (this.variant.equalsIgnoreCase("U")) {
            title = Messages.getString("ObservationsModel.SchedGroupTitle.UssInfo");
        }
        return title;
    }

    public String getValidateSystem() {
        return this.validateSystem;
    }

    public boolean getReportsAvail() {
        return this.reportsAvail;
    }

    public boolean getStickyNotes() {
        return this.stickyNotes;
    }

    public String getDataExtractors() {
        String extractors = "";
        if (this.cicsExtractor) {
            extractors = String.valueOf(extractors) + ", " + CorePlugin.getDefault().constants.EXTRACTORTYPE_CICS;
        }
        if (this.cicsiExtractor) {
            extractors = String.valueOf(extractors) + ", " + CorePlugin.getDefault().constants.EXTRACTORTYPE_CICSI;
        }
        if (this.imsExtractor) {
            extractors = String.valueOf(extractors) + ", " + CorePlugin.getDefault().constants.EXTRACTORTYPE_IMS;
        }
        if (this.imsiExtractor) {
            extractors = String.valueOf(extractors) + ", " + CorePlugin.getDefault().constants.EXTRACTORTYPE_IMSI;
        }
        if (this.db2Extractor) {
            extractors = String.valueOf(extractors) + ", " + CorePlugin.getDefault().constants.EXTRACTORDESC_DB2;
        }
        if (this.db2iExtractor) {
            extractors = String.valueOf(extractors) + ", " + CorePlugin.getDefault().constants.EXTRACTORDESC_DB2I;
        }
        if (this.db2vExtractor) {
            extractors = String.valueOf(extractors) + ", " + CorePlugin.getDefault().constants.EXTRACTORDESC_DB2V;
        }
        if (this.db2xExtractor) {
            extractors = String.valueOf(extractors) + ", " + CorePlugin.getDefault().constants.EXTRACTORDESC_DB2X;
        }
        if (this.cdb2Extractor) {
            extractors = String.valueOf(extractors) + ", " + CorePlugin.getDefault().constants.EXTRACTORDESC_CDB2;
        }
        if (this.mqseriesExtractor) {
            extractors = String.valueOf(extractors) + ", " + CorePlugin.getDefault().constants.EXTRACTORDESC_MQSERIES;
        }
        if (this.javaExtractor) {
            extractors = String.valueOf(extractors) + ", " + CorePlugin.getDefault().constants.EXTRACTORTYPE_JAVA;
        }
        if (this.naturalExtractor) {
            extractors = String.valueOf(extractors) + ", " + CorePlugin.getDefault().constants.EXTRACTORDESC_NATURAL;
        }
        if (this.adabasExtractor) {
            extractors = String.valueOf(extractors) + ", " + CorePlugin.getDefault().constants.EXTRACTORDESC_ADABAS;
        }
        if (this.wasExtractor) {
            extractors = String.valueOf(extractors) + ", " + CorePlugin.getDefault().constants.EXTRACTORTYPE_WAS;
        }
        if (this.srbExtractor) {
            extractors = String.valueOf(extractors) + ", " + CorePlugin.getDefault().constants.EXTRACTORTYPE_SRB;
        }
        if (this.mqiExtractor) {
            extractors = String.valueOf(extractors) + ", " + CorePlugin.getDefault().constants.EXTRACTORTYPE_MQI;
        }
        if (this.sysExtractor) {
            extractors = String.valueOf(extractors) + ", " + CorePlugin.getDefault().constants.EXTRACTORTYPE_SYS;
        }
        if (this.wlpExtractor) {
            extractors = String.valueOf(extractors) + ", " + CorePlugin.getDefault().constants.EXTRACTORTYPE_WLP;
        }
        if (extractors.length() > 0) {
            extractors = extractors.substring(2);
        } else if (extractors.length() <= 0) {
            extractors = Messages.getString("ObservationsModel.Extractors.NoExtractors");
        }
        return extractors;
    }

    public String getDb2GroupTitle() {
        String db2Title = "";
        if (this.cdb2) {
            db2Title = Messages.getString("ObservationsModel.Db2Title.Cdb2");
        } else if (this.db2Type.length() > 0) {
            db2Title = Messages.getString("ObservationsModel.Db2Title.SpecificDb2");
            db2Title = this.db2Type.equalsIgnoreCase("F") ? String.valueOf(db2Title) + Messages.getString("ObservationsModel.Db2Title.UserFunction") : String.valueOf(db2Title) + Messages.getString("ObservationsModel.Db2Title.StoredProcedure");
            db2Title = String.valueOf(db2Title) + Messages.getString("ObservationsModel.Db2Title.Parameters");
        }
        return db2Title;
    }

    public String getDb2Type() {
        return this.db2Type;
    }

    public String getDb2Subsystem() {
        return this.db2Subsystem;
    }

    public String getDb2Schema() {
        return this.db2Schema;
    }

    public String getDb2Name() {
        return this.db2Name;
    }

    public boolean getDb2IsGroup() {
        return this.db2IsGroup;
    }

    public boolean getCdb2() {
        return this.cdb2;
    }

    public String getTriggerInfo() {
        ObservationsModel obs;
        String triggerInfo = null;
        if (this.triggeredBy != 0) {
            obs = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(this.triggeredBy));
            String trigstat = obs.statusShort;
            if (trigstat.equalsIgnoreCase(Messages.getString("ObservationsModel.Status.REPEAT"))) {
                trigstat = Messages.getString("ObservationsModel.Status.Sched");
            }
            triggerInfo = String.valueOf(this.dtfmt.format(obs.getReqdate())) + "|" + trigstat + "|Triggered by|Req " + this.triggeredBy;
        } else if (this.triggers != 0) {
            obs = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(this.triggers));
            String trigstat = this.statusShort;
            if (trigstat.equalsIgnoreCase(Messages.getString("ObservationsModel.Status.REPEAT"))) {
                trigstat = Messages.getString("ObservationsModel.Status.Sched");
            }
            triggerInfo = String.valueOf(this.dtfmt.format(obs.getReqdate())) + "|" + trigstat + "|Triggers|Req " + this.triggers;
        }
        obs = null;
        return triggerInfo;
    }

    public Integer getTriggers() {
        return this.triggers;
    }

    public Integer getTriggeredBy() {
        return this.triggeredBy;
    }

    public Long getSessionDurationMin() {
        Long minutes = new Long(0L);
        if (this.sessionDuration > 0L) {
            minutes = this.sessionDuration / 60000L;
        }
        return minutes;
    }

    public Double getSessionDurationSec() {
        Double seconds = new Double(0.0);
        if (this.sessionDuration > 0L) {
            seconds = new Double(this.sessionDuration.longValue()) % 60000.0 / 1000.0;
        }
        return seconds;
    }

    public String getDisplaySessionDeleteDate() {
        String deleteDate = null;
        if (this.deleteFlag[0] == 1) {
            deleteDate = Messages.getString("ObservationsModel.DoNotDelete");
        } else if (this.sessionDeleteDate != null) {
            deleteDate = CorePlugin.getDefault().constants.dtfmt.format(this.sessionDeleteDate);
        }
        return deleteDate;
    }

    public String getDisplayStepsSched() {
        String strStepsSched = CorePlugin.getDefault().constants.decfmt.format(this.stepsSched);
        if (this.stepsSched.equals(-1)) {
            strStepsSched = Messages.getString("ObservationsModel.StepsSched.All");
        }
        return strStepsSched;
    }

    public String getFailedReason() {
        String failedReason = null;
        String DELIM = "|";
        int cnt = 0;
        if (this.statusCode.equalsIgnoreCase("X") || this.statusCode.equalsIgnoreCase("F") || this.statusCode.equalsIgnoreCase("I")) {
            StringTokenizer st = new StringTokenizer(Messages.getString("ObservationsModel.Reason.Descriptions"), DELIM);
            while (st.hasMoreTokens()) {
                String reason = st.nextToken();
                if (this.reasonCode != ++cnt) continue;
                failedReason = reason;
                break;
            }
        }
        return failedReason;
    }

    public boolean getTagObservation() {
        return this.tagObservation;
    }

    public boolean getImportedObservation() {
        return this.importedObservation;
    }

    public String getImsSubsystemId() {
        return this.imsSubsystemId;
    }

    public String getImsTranCode() {
        return this.imsTranCode;
    }

    public String getImsTxnCode() {
        return this.imsTxnCode;
    }

    public String getImsProgramName() {
        return this.imsProgramName;
    }

    public String getImsUserId() {
        return this.imsUserId;
    }

    public Integer getDeleteDays() {
        return this.deleteDays;
    }

    public int getPmexReqnum() {
        return this.pmexReqnum;
    }

    public boolean getWasServantSampling() {
        return this.wasServantSampling;
    }

    public String getWasServantObsDsname() {
        return this.wasServantObsDsname;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setReqnum(Integer reqnum) {
        this.reqnum = reqnum;
    }

    public void setReqlink(Integer reqlink) {
        this.reqlink = reqlink;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public void setOwnedby(String ownedby) {
        this.ownedby = ownedby;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setJobname(String jobname) {
        this.jobname = jobname;
    }

    public void setReqdate(Date reqdate) {
        this.reqdate = reqdate;
    }

    public void setSamplesDone(Integer samplesDone) {
        this.samplesDone = samplesDone;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public void setDsname(String dsname) {
        this.dsname = dsname;
    }

    public void setUDSN(boolean udsn) {
        this.udsn = udsn;
    }

    public void setSamples(Integer samples) {
        this.samples = samples;
    }

    public void setAsid(String asid) {
        this.asid = asid;
    }

    public void setJobid(String jobid) {
        this.jobid = jobid;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public void setSessionStart(Date sessionStart) {
        this.sessionStart = sessionStart;
    }

    public void setSessionEnd(Date sessionEnd) {
        this.sessionEnd = sessionEnd;
    }

    public void setSessionDuration(Long sessionDuration) {
        this.sessionDuration = sessionDuration;
    }

    public void setSessionDeleteDate(Date sessionDeleteDate) {
        this.sessionDeleteDate = sessionDeleteDate;
    }

    public void setRepeatTimes(Integer repeatTimes) {
        this.repeatTimes = repeatTimes;
    }

    public void setRepeatBeforeDate(Date repeatBeforeDate) {
        this.repeatBeforeDate = repeatBeforeDate;
    }

    public Integer getRunAgainCtr() {
        return this.runAgainCtr;
    }

    public Integer getRunAgainMins() {
        return this.runAgainMins;
    }

    public Integer getRunAgainFor() {
        return this.runAgainFor;
    }

    public void setCicsExtractor(boolean cicsExtractor) {
        this.cicsExtractor = cicsExtractor;
    }

    public void setCicsiExtractor(boolean cicsiExtractor) {
        this.cicsiExtractor = cicsiExtractor;
    }

    public void setImsExtractor(boolean imsExtractor) {
        this.imsExtractor = imsExtractor;
    }

    public void setImsiExtractor(boolean imsiExtractor) {
        this.imsiExtractor = imsiExtractor;
    }

    public void setDb2Extractor(boolean db2Extractor) {
        this.db2Extractor = db2Extractor;
    }

    public void setDb2iExtractor(boolean db2iExtractor) {
        this.db2iExtractor = db2iExtractor;
    }

    public void setDb2vExtractor(boolean db2vExtractor) {
        this.db2vExtractor = db2vExtractor;
    }

    public void setDb2xExtractor(boolean db2xExtractor) {
        this.db2xExtractor = db2xExtractor;
    }

    public void setCdb2Extractor(boolean cdb2Extractor) {
        this.cdb2Extractor = cdb2Extractor;
    }

    public void setMqseriesExtractor(boolean mqseriesExtractor) {
        this.mqseriesExtractor = mqseriesExtractor;
    }

    public void setJavaExtractor(boolean javaExtractor) {
        this.javaExtractor = javaExtractor;
    }

    public void setNaturalExtractor(boolean naturalExtractor) {
        this.naturalExtractor = naturalExtractor;
    }

    public void setAdabasExtractor(boolean adabasExtractor) {
        this.adabasExtractor = adabasExtractor;
    }

    public void setWasExtractor(boolean wasExtractor) {
        this.wasExtractor = wasExtractor;
    }

    public void setSrbExtractor(boolean srbExtractor) {
        this.srbExtractor = srbExtractor;
    }

    public void setMqiExtractor(boolean mqiExtractor) {
        this.mqiExtractor = mqiExtractor;
    }

    public void setThresSettings(String thresSettings) {
        this.thresSettings = thresSettings;
    }

    public void setStepNum(Integer stepNum) {
        this.stepNum = stepNum;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    public void setProcStep(String procStep) {
        this.procStep = procStep;
    }

    public void setProgName(String progName) {
        this.progName = progName;
    }

    public void setSelectMstep(String selectMstep) {
        this.selectMstep = selectMstep;
    }

    public void setStepsSched(Integer stepsSched) {
        this.stepsSched = stepsSched;
    }

    public void setItemsSched(Integer itemsSched) {
        this.itemsSched = itemsSched;
    }

    public void setStatusLong(String statusLong) {
        this.statusLong = statusLong;
    }

    public void setStatusShort(String statusShort) {
        this.statusShort = statusShort;
    }

    public void setDeleteFlag(byte[] deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public void setReasonCode(Integer reasonCode) {
        this.reasonCode = reasonCode;
    }

    public void setR02Samples(Integer r02Samples) {
        this.r02Samples = r02Samples;
    }

    public void setSessionDateTime(Date sessionDateTime) {
        this.sessionDateTime = sessionDateTime;
    }

    public void setR02Description(String r02Description) {
        this.r02Description = r02Description;
    }

    public void setFlags3Type(String flags3Type) {
        this.flags3Type = flags3Type;
    }

    public void setStepInfo(String[] stepInfo) {
        this.stepInfo = stepInfo;
    }

    public void setImportedObservation(boolean importedObservation) {
        this.importedObservation = importedObservation;
    }

    public void walkUpTree() {
        ObservationsModel obs;
        String listInfo = "";
        String listJob = "";
        listInfo = String.valueOf(this.dtfmt.format(this.getSessionDateTime())) + "|" + this.statusShort + "|Req " + this.reqnum + "|";
        int parent = this.reqlink;
        while (parent > 0) {
            obs = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(parent));
            listJob = " ";
            if (obs.variant.equalsIgnoreCase("J") || obs.variant.equalsIgnoreCase("I")) {
                this.parentVariant = obs.variant;
                listJob = this.jobname;
            }
            if (this.variant.equalsIgnoreCase("U") && this.getStatusCode().equalsIgnoreCase("C") && this.sessionEnd == null) {
                obs.listSchedInfo.add(String.valueOf(listInfo) + Messages.getString("ObservationsModel.IncompleteSample"));
            }
            if (this.variant.equalsIgnoreCase("P")) {
                obs.listSchedInfo.add(String.valueOf(listInfo) + listJob);
            }
            if (this.deleteDaysColor != null) {
                if (obs.deleteDaysColor == null) {
                    obs.deleteDaysColor = this.deleteDaysColor;
                } else if (obs.deleteDaysColor.equals((Object)CorePlugin.getDefault().constants.COLOR_DELDAYS_GREEN)) {
                    obs.deleteDaysColor = this.deleteDaysColor;
                } else if (this.deleteDaysColor.equals((Object)CorePlugin.getDefault().constants.COLOR_RED)) {
                    obs.deleteDaysColor = this.deleteDaysColor;
                }
            }
            parent = obs.reqlink;
        }
        obs = null;
    }

    public void setSchedInfo(String[] schedInfo) {
        this.schedInfo = schedInfo;
    }

    public void setValidateSystem(String validateSystem) {
        this.validateSystem = validateSystem;
    }

    public void setReportsAvail() {
        this.reportsAvail = false;
        this.reportsDownloaded = "unavail";
        IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
        CorePlugin.getDefault();
        File dir = new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + this.reqnum + File.separator + Platform.getNL());
        if (dir.listFiles() != null) {
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].getName().indexOf("-base") > 0) {
                    this.setReportsAvail(true);
                    return;
                }
                ++i;
            }
        }
    }

    public void setReportsAvail(boolean reportsAvail) {
        this.reportsAvail = reportsAvail;
        this.reportsDownloaded = "unavail";
        if (reportsAvail) {
            this.reportsDownloaded = "avail";
        }
        if (this.reqlink > 0) {
            int parent = this.reqlink;
            while (parent > 0) {
                ObservationsModel obs = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(parent));
                if (reportsAvail) {
                    obs.reportsAvail = true;
                    obs.reportsDownloaded = "avail";
                } else {
                    obs.reportsAvail = false;
                    obs.reportsDownloaded = "unavail";
                    int i = 0;
                    while (i < obs.child.size()) {
                        ObservationsModel obschild = (ObservationsModel)obs.child.get(i);
                        if (obschild.reportsAvail) {
                            obs.reportsAvail = true;
                            obs.reportsDownloaded = "avail";
                            break;
                        }
                        ++i;
                    }
                    Object var4_4 = null;
                }
                parent = obs.reqlink;
            }
            Object var3_3 = null;
        }
    }

    public void setStickyNotes() {
        this.stickyNotes = false;
        IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
        CorePlugin.getDefault();
        File stickyFile = new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + this.reqnum + File.separator + Platform.getNL() + File.separator + this.reqnum + "-stickyNotes.txt");
        if (stickyFile.exists()) {
            this.stickyNotes = true;
        }
    }

    public void setDb2Type(String db2Type) {
        this.db2Type = db2Type;
    }

    public void setDb2Subsystem(String db2Subsystem) {
        this.db2Subsystem = db2Subsystem;
    }

    public void setDb2Schema(String db2Schema) {
        this.db2Schema = db2Schema;
    }

    public void setDb2Name(String db2Name) {
        this.db2Name = db2Name;
    }

    public void setDb2IsGroup(boolean db2IsGroup) {
        this.db2IsGroup = db2IsGroup;
    }

    public void setCdb2(boolean cdb2) {
        this.cdb2 = cdb2;
    }

    public void setTriggers(Integer triggers) {
        this.triggers = triggers;
    }

    public void setTriggeredBy(Integer triggeredBy) {
        this.triggeredBy = triggeredBy;
    }

    public void setTagObservation(boolean tagObservation) {
        this.tagObservation = tagObservation;
    }

    public void setImsSubsystemId(String imsSubsystemId) {
        this.imsSubsystemId = imsSubsystemId;
    }

    public void setImsTranCode(String imsTranCode) {
        this.imsTranCode = imsTranCode;
    }

    public void setImsTxnCode(String imsTxnCode) {
        this.imsTxnCode = imsTxnCode;
    }

    public void setImsProgramName(String imsProgramName) {
        this.imsProgramName = imsProgramName;
    }

    public void setImsUserId(String imsUserId) {
        this.imsUserId = imsUserId;
    }

    public void setDeleteDays() {
        Date today = new Date();
        this.deleteDays = 0;
        this.deleteDaysColor = null;
        if (this.sessionDeleteDate == null) {
            this.deleteDays = null;
            if (CorePlugin.getDefault().expWarnDays != 255) {
                this.deleteDaysColor = CorePlugin.getDefault().constants.COLOR_DELDAYS_GREEN;
            }
        } else if (this.deleteFlag[0] == 1) {
            this.deleteDays = null;
            if (CorePlugin.getDefault().expWarnDays != 255) {
                this.deleteDaysColor = CorePlugin.getDefault().constants.COLOR_DELDAYS_GREEN;
            }
        } else {
            double d1 = this.sessionDeleteDate.getTime();
            double d2 = today.getTime();
            double daysDivisor = 8.64E7;
            double dateDiff = (d1 - d2) / daysDivisor;
            this.deleteDays = (int)(dateDiff + 0.5);
            boolean colorEligible = false;
            if (this.getStatusCode().equalsIgnoreCase("C") || this.getStatusCode().equalsIgnoreCase("X") || this.getStatusCode().equalsIgnoreCase("F")) {
                colorEligible = true;
            }
            if (CorePlugin.getDefault().expWarnDays != 255 && colorEligible && dateDiff < (double)CorePlugin.getDefault().expWarnDays.intValue()) {
                this.deleteDaysColor = dateDiff < 1.0 ? CorePlugin.getDefault().constants.COLOR_RED : CorePlugin.getDefault().constants.COLOR_DELDAYS_YELLOW;
            }
        }
    }

    public void setPmexReqnum(int pmexReqnum) {
        this.pmexReqnum = pmexReqnum;
    }

    public void setWasServantSampling(boolean wasServantSampling) {
        this.wasServantSampling = wasServantSampling;
    }

    public void setWasServantObsDsname() {
        this.wasServantObsDsname = "";
        if (this.wasServantSampling && this.reqlink != null) {
            ObservationsModel obs = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(this.reqlink));
            this.wasServantObsDsname = obs.dsname;
        }
    }

    public void setTemplateName() {
        this.templateName = this.templateName;
    }

    public void setTreeLevel() {
        this.treeLevel = this.parent.treeLevel + 1;
    }

    public ObservationsModel getParent() {
        return this.parent;
    }

    public String toString() {
        String rv = Messages.getString("ObservationsModel.ToString.Item");
        if (this.parent != null) {
            rv = String.valueOf(this.parent.toString()) + ".";
        }
        rv = String.valueOf(rv) + this.counter;
        return rv;
    }

    public List<ObservationsModel> getChildren() {
        return this.child;
    }
}

