/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.internal;

import com.banknet.core.CorePlugin;
import com.banknet.core.internal.Messages;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;

public class pvmlSort {
    static File activeFile;
    static File workFile;
    public static SortString ss;
    static RandomAccessFile rBaseFile;
    static PrintStream sysout;
    static BufferedReader active;
    static PrintStream work;
    public IProgressMonitor monitor = null;
    public char rightArrow = (char)8594;
    static String windows1252;
    static String tab;
    static String tabDelimiter;
    static Pattern t1;
    static String spaceDelimiter;
    static Pattern sp1;
    static String[] activeArray;
    static int valueStarts;
    static ArrayList<SortString> sortLine;
    static String sortStringKey;
    static ArrayList<SortNumber> sortNumberLine;
    static Integer sortNumberKey;
    static ArrayList<SortHex> sortHexLine;
    static Integer sortHexKey;
    static ArrayList<SortToken> sortTokenLine;
    static Long sortTokenKey;
    static ArrayList<SortFloat> sortFloatLine;
    static Float sortFloatKey;
    static ArrayList<SortEbcidic> sortEbcidicLine;
    static byte[] sortEbcidicKey;
    static String sAddress;
    static int sortLevel;
    static int saveSortLevel;
    static int offset;
    static String sortBy;
    static String activeLine;
    static int sortStartColumn;
    static int sortStart;
    static int sortLength;
    static char sortOrder;
    String sortReport = "";
    int sortcnt = 0;
    float percentDone;
    int firstDigit = 0;
    int ipercentDone = 0;
    int prevFirstDigit = 0;
    int sortlines = 0;
    String specialInstructions = "";
    static boolean printOn;
    public DecimalFormat decfmt = new DecimalFormat("###,###,###,##0");

    static {
        windows1252 = "Cp1252";
        tab = "\t";
        tabDelimiter = "[" + tab + "]";
        spaceDelimiter = " +";
        activeArray = null;
        valueStarts = 0;
        sortLine = new ArrayList();
        sortStringKey = "";
        sortNumberLine = new ArrayList();
        sortHexLine = new ArrayList();
        sortTokenLine = new ArrayList();
        sortFloatLine = new ArrayList();
        sortEbcidicLine = new ArrayList();
        sAddress = "";
        sortLevel = 0;
        saveSortLevel = 0;
        printOn = false;
    }

    public pvmlSort() {
        if (Messages.getString("pvmlSort.DoubleByte").equalsIgnoreCase("true")) {
            this.rightArrow = (char)9658;
        }
    }

    public void sortPvml(int observation, String reportId, int offsetParm, String sortByParm, String sortPI, String stcid) {
        offset = offsetParm;
        sortBy = sortByParm;
        sortStartColumn = 0;
        sortStart = 0;
        sortLength = 0;
        sortOrder = (char)65;
        this.sortReport = reportId;
        String logstr = "sortPvml:  Observation - " + observation;
        System.out.println("pvmlSort - " + logstr);
        CorePlugin.getDefault().log.debug(logstr);
        logstr = "sortPvml:  Report - " + reportId;
        System.out.println("pvmlSort - " + logstr);
        CorePlugin.getDefault().log.debug(logstr);
        logstr = "sortPvml:  Offset - " + offset;
        System.out.println("pvmlSort - " + logstr);
        CorePlugin.getDefault().log.debug(logstr);
        logstr = "sortPvml:  SortValue - " + sortBy;
        System.out.println("pvmlSort - " + logstr);
        CorePlugin.getDefault().log.debug(logstr);
        logstr = "sortPvml:  SortPI - " + sortPI;
        System.out.println("pvmlSort - " + logstr);
        CorePlugin.getDefault().log.debug(logstr);
        IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
        CorePlugin.getDefault();
        activeFile = new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + stcid + File.separator + observation + File.separator + Platform.getNL() + File.separator + reportId + "-active.txt");
        IPreferenceStore iPreferenceStore2 = CorePlugin.getDefault().getPreferenceStore();
        CorePlugin.getDefault();
        workFile = new File(String.valueOf(iPreferenceStore2.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + stcid + File.separator + observation + File.separator + Platform.getNL() + File.separator + reportId + "-work.txt");
        t1 = Pattern.compile(tabDelimiter);
        sp1 = Pattern.compile(spaceDelimiter);
        try {
            sysout = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception e) {
            logstr = "sortPvml:  Exception allocating sysout print stream. " + e;
            System.out.println("pvmlSort - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        active = null;
        try {
            active = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(activeFile.getAbsolutePath()), "UTF-8"));
        }
        catch (IOException e) {
            logstr = "sortPvml:  Exception allocating streamreader for file '" + activeFile.getAbsolutePath() + ". " + e;
            System.out.println("pvmlSort - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        rBaseFile = null;
        try {
            rBaseFile = new RandomAccessFile(activeFile.getAbsolutePath(), "r");
        }
        catch (Exception e) {
            logstr = "sortPvml:  Exception allocating randomaccessfile '" + activeFile.getAbsolutePath() + ". " + e;
            System.out.println("pvmlSort - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        work = null;
        try {
            FileOutputStream outputStream1 = new FileOutputStream(workFile.getAbsolutePath());
            work = new PrintStream((OutputStream)outputStream1, true, "UTF-8");
        }
        catch (IOException e) {
            logstr = "sortPvml:  Exception allocating file output stream for file '" + workFile.getAbsolutePath() + ". " + e;
            System.out.println("pvmlSort - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        activeLine = null;
        System.out.println("Sort Processing Instructions : " + sortPI);
        String[] piArray = sortPI.split(";");
        if (piArray[0].startsWith("O")) {
            String[] piString = piArray[0].split("[.]");
            sortStart = Integer.parseInt(piString[0].substring(1));
            sortLength = Integer.parseInt(piString[1]);
        }
        if (piArray[0].startsWith("C")) {
            sortStartColumn = Integer.parseInt(piArray[0].substring(1));
        }
        if (piArray[0].startsWith("*")) {
            try {
                int i = 1;
                while (i <= 4) {
                    activeLine = active.readLine();
                    this.writePVMLLine(activeLine);
                    if (activeLine.indexOf("*....1") > 0) {
                        i = 4;
                        String[] tempArray = t1.split(activeLine, -1);
                        sortStart = tempArray[5].indexOf("*") - 6;
                        sortLength = 6;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
        if (piArray.length > 1) {
            if (piArray[1].length() > 0) {
                sortBy = piArray[1];
            }
            if (piArray.length > 2) {
                this.specialInstructions = piArray[2];
            }
        }
        if (sortBy.contains("VALUE") && this.sortReport.equals("Q11")) {
            sortBy = sortBy.replace("VALUE", "DURATION");
            sortOrder = (char)68;
        }
        if (sortBy.startsWith("S-")) {
            this.sortSection();
        } else {
            this.sortDetail();
        }
        try {
            sortLine.clear();
            sortNumberLine.clear();
            sortHexLine.clear();
            sortTokenLine.clear();
            sortFloatLine.clear();
            sortEbcidicLine.clear();
            rBaseFile.close();
            work.flush();
            work.close();
            active.close();
        }
        catch (Exception e) {
            logstr = "sortPvml:  Exception in Close Routing. " + e;
            System.out.println("pvmlSort - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        activeFile.delete();
        workFile.renameTo(activeFile);
    }

    void sortSection() {
        this.setInitialPosition("S");
        if (sortBy.equals("S-NAME")) {
            this.sortSectionString();
        } else if (sortBy.equals("S-LOCATION")) {
            this.sortSectionHybrid();
        } else if (sortBy.equals("S-ADDRESS")) {
            this.sortSectionHex();
        } else if (sortBy.equals("S-DDNAME")) {
            this.sortSectionString();
        } else if (sortBy.equals("S-TOKEN")) {
            this.sortSectionToken();
        } else if (sortBy.equals("S-VALUE")) {
            this.sortSectionFloat();
        } else if (sortBy.equals("S-THREAD")) {
            this.sortSectionString();
        } else if (sortBy.equals("S-DURATION")) {
            this.sortSectionFloat();
        } else if (sortBy.equals("S-CPU")) {
            this.sortSectionFloat();
        } else if (sortBy.equals("S-COUNT")) {
            sortOrder = (char)68;
            this.sortSectionHex();
        } else if (sortBy.equals("S-FILEID")) {
            this.sortSectionString();
        } else if (sortBy.equals("S-REQID")) {
            this.sortSectionString();
        } else if (sortBy.equals("S-REQUEST")) {
            this.sortSectionString();
        } else if (sortBy.equals("S-PATHNAME")) {
            this.sortSectionPath();
        } else if (sortBy.equals("S-DEVID")) {
            this.sortSectionString();
        } else if (sortBy.equals("S-DEVICE")) {
            this.sortSectionNumber();
        } else if (sortBy.equals("S-EXCP")) {
            this.sortSectionNumber();
        } else if (sortBy.equals("S-SIZE")) {
            this.sortSectionNumber();
        } else if (sortBy.equals("S-LIBRARY")) {
            this.sortSectionString();
        } else if (sortBy.equals("S-SERVICE")) {
            this.sortSectionFloat();
        } else if (sortBy.equals("S-SS")) {
            this.sortSectionString();
        }
    }

    void sortDetail() {
        int parentLevel = 0;
        try {
            this.setInitialPosition("|" + offset + ",");
            if (activeLine != null) {
                parentLevel = new Integer(this.getLevel(activeLine));
                this.writePVMLLine(activeLine);
                activeLine = active.readLine();
                int arrowPosition = activeLine.indexOf(this.rightArrow);
                while (arrowPosition == -1) {
                    this.writePVMLLine(activeLine);
                    activeLine = active.readLine();
                    if (activeLine == null) break;
                    arrowPosition = activeLine.indexOf(this.rightArrow);
                }
            }
            if (activeLine != null) {
                if (sortBy.equals("NAME")) {
                    this.sortDetailString(parentLevel);
                }
                if (sortBy.equals("LOCATION")) {
                    this.sortDetailHybrid(parentLevel);
                }
                if (sortBy.equals("ADDRESS")) {
                    this.sortDetailHex(parentLevel);
                }
                if (sortBy.equals("CYLINDER")) {
                    this.sortDetailHex(parentLevel);
                }
                if (sortBy.equals("VALUE")) {
                    this.sortDetailFloat(parentLevel);
                }
                if (sortBy.equals("CPU")) {
                    this.sortDetailFloat(parentLevel);
                }
                if (sortBy.equals("SERVICE")) {
                    this.sortDetailFloat(parentLevel);
                }
                if (sortBy.equals("COUNT")) {
                    sortOrder = (char)68;
                    this.sortDetailHex(parentLevel);
                }
                if (sortBy.equals("SIZE")) {
                    this.sortDetailString(parentLevel);
                }
                if (sortBy.equals("LIBRARY")) {
                    this.sortDetailString(parentLevel);
                }
                if (sortBy.equals("DURATION")) {
                    this.sortDetailFloat(parentLevel);
                }
                if (sortBy.equals("FILEID")) {
                    this.sortDetailString(parentLevel);
                }
                if (sortBy.equals("REQID")) {
                    this.sortDetailString(parentLevel);
                }
                if (sortBy.equals("REQUEST")) {
                    this.sortDetailString(parentLevel);
                }
                if (sortBy.equals("PATHNAME")) {
                    this.sortDetailPath(parentLevel);
                }
                if (sortBy.equals("DEVID")) {
                    this.sortDetailString(parentLevel);
                }
                if (sortBy.equals("DEVICE")) {
                    this.sortDetailString(parentLevel);
                }
                if (sortBy.equals("SS")) {
                    this.sortDetailString(parentLevel);
                }
            }
            System.out.println("restart at " + activeLine);
            if (activeLine != null) {
                this.writePVMLLine(activeLine);
            }
            while ((activeLine = active.readLine()) != null) {
                this.writePVMLLine(activeLine);
            }
        }
        catch (Exception e) {
            String logstr = "sortDetail:  Exception, activeLine - " + activeLine + ". " + e;
            System.out.println("pvmlSort - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    public void sortSectionString() {
        String saveSortStringKey = null;
        try {
            while (activeLine != null) {
                String[] tempArray;
                if ((this.sortReport.equals("I22") || this.sortReport.equals("X06")) && activeLine.contains(" Total ")) {
                    activeLine = activeLine.replace(" Total ", " zzzzz ");
                }
                if (this.sortReport.equals("J03") && activeLine.contains("Note:")) {
                    activeLine = activeLine.replace("0\t0", "0\tA");
                    activeLine = activeLine.replace("Note:", "99999");
                    activeLine = activeLine.replace("e a th", "-000.00");
                }
                if (Integer.parseInt((tempArray = t1.split(activeLine, -1))[1]) == 0 && tempArray[2].equals("A")) {
                    saveSortStringKey = sortStringKey = this.getItem(sortBy, activeLine).toUpperCase();
                    if (this.sortReport.equals("C07") && (saveSortStringKey.equals("NOSYMB") || saveSortStringKey.equals("APPLCN") || saveSortStringKey.equals("SYSTEM"))) break;
                    byte[] sortStringKeyBA = sortStringKey.getBytes(CorePlugin.getDefault().getPreferenceStore().getString("codePage"));
                    sortStringKey = new String(sortStringKeyBA, windows1252);
                    sortLevel = 0;
                    sortLine.add(new SortString(sortStringKey, sAddress, sortLevel));
                }
                activeLine = active.readLine();
            }
            Collections.sort(sortLine);
            this.sortlines = sortLine.size();
            for (SortString sorted : sortLine) {
                String s1 = sorted.sortStringKey.toString().trim();
                String s2 = sorted.sAddress.toString().trim();
                int i1 = sorted.sortLevel;
                this.getBlock(String.valueOf(s1) + tab + s2 + tab + i1);
                ++this.sortcnt;
                if (this.monitor == null) continue;
                this.percentDone = (float)this.sortcnt / (float)this.sortlines * 100.0f;
                this.ipercentDone = (int)this.percentDone;
                this.firstDigit = this.ipercentDone / 5;
                if (this.firstDigit != this.prevFirstDigit) {
                    this.monitor.subTask(String.valueOf(this.ipercentDone) + Messages.getString("pvmlSort.Job.SubTask.PctComplete") + this.decfmt.format(this.sortcnt) + Messages.getString("pvmlSort.Job.SubTask.Of") + this.decfmt.format(this.sortlines) + Messages.getString("pvmlSort.Job.SubTask.RecsSorted"));
                    this.monitor.worked(5);
                    this.prevFirstDigit = this.firstDigit;
                    continue;
                }
                if (this.monitor.isCanceled()) break;
            }
            if (activeLine != null) {
                this.writePVMLLine(activeLine);
            }
            while ((activeLine = active.readLine()) != null) {
                this.writePVMLLine(activeLine);
            }
        }
        catch (Exception e) {
            String logstr = "sortSection:  Exception, activeLine - " + activeLine + ". " + e;
            System.out.println("pvmlSort - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    public void sortSectionPath() {
        try {
            while (activeLine != null) {
                String[] tempArray = t1.split(activeLine, -1);
                if (Integer.parseInt(tempArray[1]) == 0 && tempArray[2].equals("A")) {
                    sortStringKey = this.getItem(sortBy, activeLine).toUpperCase();
                    String sortStringKey2 = "";
                    if (sortStringKey.length() >= 34) {
                        String sAddressSaved = sAddress;
                        activeLine = active.readLine();
                        sortStringKey2 = this.getItem(sortBy, activeLine).toUpperCase();
                        sAddress = sAddressSaved;
                    }
                    sortStringKey = String.valueOf(sortStringKey) + sortStringKey2;
                    Object sortStringKeyBA = sortStringKey.getBytes(CorePlugin.getDefault().getPreferenceStore().getString("codePage"));
                    sortStringKey = new String((byte[])sortStringKeyBA, windows1252);
                    sortLevel = 0;
                    sortLine.add(new SortString(sortStringKey, sAddress, sortLevel));
                }
                activeLine = active.readLine();
            }
            Collections.sort(sortLine);
            for (SortString sorted : sortLine) {
                String s1 = sorted.sortStringKey.toString().trim();
                String s2 = sorted.sAddress.toString().trim();
                int i1 = sorted.sortLevel;
                this.getBlock(String.valueOf(s1) + tab + s2 + tab + i1);
            }
            if (activeLine != null) {
                this.writePVMLLine(activeLine);
            }
            while ((activeLine = active.readLine()) != null) {
                this.writePVMLLine(activeLine);
            }
        }
        catch (Exception e) {
            String logstr = "sortSection:  Exception, activeLine - " + activeLine + ". " + e;
            System.out.println("pvmlSort - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    public void sortSectionNumber() {
        try {
            while (activeLine != null) {
                String[] tempArray = t1.split(activeLine, -1);
                if (Integer.parseInt(tempArray[1]) == 0 && tempArray[2].equals("A")) {
                    String sSortNumberKey = this.getItem(sortBy, activeLine);
                    sortNumberKey = Integer.parseInt(sSortNumberKey);
                    sortLevel = 0;
                    sortNumberLine.add(new SortNumber(sortNumberKey, sAddress, sortLevel));
                }
                activeLine = active.readLine();
            }
            Collections.sort(sortNumberLine);
            this.sortlines = sortNumberLine.size();
            for (SortNumber sorted : sortNumberLine) {
                String s1 = sorted.sortNumberKey.toString().trim();
                String s2 = sorted.sAddress.toString().trim();
                int i1 = sorted.sortLevel;
                this.getBlock(String.valueOf(s1) + tab + s2 + tab + i1);
                ++this.sortcnt;
                if (this.monitor == null) continue;
                this.percentDone = (float)this.sortcnt / (float)this.sortlines * 100.0f;
                this.ipercentDone = (int)this.percentDone;
                this.firstDigit = this.ipercentDone / 5;
                if (this.firstDigit != this.prevFirstDigit) {
                    this.monitor.subTask(String.valueOf(this.ipercentDone) + Messages.getString("pvmlSort.Job.SubTask.PctComplete") + this.decfmt.format(this.sortcnt) + Messages.getString("pvmlSort.Job.SubTask.Of") + this.decfmt.format(this.sortlines) + Messages.getString("pvmlSort.Job.SubTask.RecsSorted"));
                    this.monitor.worked(5);
                    this.prevFirstDigit = this.firstDigit;
                    continue;
                }
                if (this.monitor.isCanceled()) break;
            }
            if (activeLine != null) {
                this.writePVMLLine(activeLine);
            }
            while ((activeLine = active.readLine()) != null) {
                this.writePVMLLine(activeLine);
            }
        }
        catch (Exception e) {
            String logstr = "sortSectionNumber:  Exception, activeLine - " + activeLine + ". " + e;
            System.out.println("pvmlSort - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    public void sortSectionHybrid() {
        try {
            while (activeLine != null) {
                String[] tempArray = t1.split(activeLine, -1);
                if (Integer.parseInt(tempArray[1]) == 0 && tempArray[2].equals("A")) {
                    sortStringKey = this.getItem(sortBy, activeLine);
                    byte[] sortStringKeyBA = sortStringKey.getBytes(CorePlugin.getDefault().getPreferenceStore().getString("codePage"));
                    sortStringKey = new String(sortStringKeyBA, windows1252);
                    sortLevel = 0;
                    sortLine.add(new SortString(sortStringKey, sAddress, sortLevel));
                }
                activeLine = active.readLine();
            }
            Collections.sort(sortLine);
            this.sortlines = sortLine.size();
            for (SortString sorted : sortLine) {
                String s1 = sorted.sortStringKey.toString().trim();
                String s2 = sorted.sAddress.toString().trim();
                int i1 = sorted.sortLevel;
                this.getBlock(String.valueOf(s1) + tab + s2 + tab + i1);
                ++this.sortcnt;
                if (this.monitor == null) continue;
                this.percentDone = (float)this.sortcnt / (float)this.sortlines * 100.0f;
                this.ipercentDone = (int)this.percentDone;
                this.firstDigit = this.ipercentDone / 5;
                if (this.firstDigit != this.prevFirstDigit) {
                    this.monitor.subTask(String.valueOf(this.ipercentDone) + Messages.getString("pvmlSort.Job.SubTask.PctComplete") + this.decfmt.format(this.sortcnt) + Messages.getString("pvmlSort.Job.SubTask.Of") + this.decfmt.format(this.sortlines) + Messages.getString("pvmlSort.Job.SubTask.RecsSorted"));
                    this.monitor.worked(5);
                    this.prevFirstDigit = this.firstDigit;
                    continue;
                }
                if (this.monitor.isCanceled()) break;
            }
            if (activeLine != null) {
                this.writePVMLLine(activeLine);
            }
            while ((activeLine = active.readLine()) != null) {
                this.writePVMLLine(activeLine);
            }
        }
        catch (Exception e) {
            String logstr = "sortSectionHybrid:  Exception, activeLine - " + activeLine + ". " + e;
            System.out.println("pvmlSort - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    public void sortSectionHex() {
        try {
            while (activeLine != null) {
                String[] tempArray = t1.split(activeLine, -1);
                if (Integer.parseInt(tempArray[1]) == 0 && tempArray[2].equals("A")) {
                    tempArray = t1.split(activeLine, -1);
                    sortHexKey = Integer.parseInt(this.getItem(sortBy, activeLine), 16);
                    sortLevel = 0;
                    sortHexLine.add(new SortHex(sortHexKey, sAddress, sortLevel));
                }
                activeLine = active.readLine();
            }
            Collections.sort(sortHexLine);
            this.sortlines = sortHexLine.size();
            for (SortHex sorted : sortHexLine) {
                int i1 = sorted.sortHexKey;
                String s2 = sorted.sAddress.toString().trim();
                int i2 = sorted.sortLevel;
                this.getBlock(String.valueOf(i1) + tab + s2 + tab + i2);
                ++this.sortcnt;
                if (this.monitor == null) continue;
                this.percentDone = (float)this.sortcnt / (float)this.sortlines * 100.0f;
                this.ipercentDone = (int)this.percentDone;
                this.firstDigit = this.ipercentDone / 5;
                if (this.firstDigit != this.prevFirstDigit) {
                    this.monitor.subTask(String.valueOf(this.ipercentDone) + Messages.getString("pvmlSort.Job.SubTask.PctComplete") + this.decfmt.format(this.sortcnt) + Messages.getString("pvmlSort.Job.SubTask.Of") + this.decfmt.format(this.sortlines) + Messages.getString("pvmlSort.Job.SubTask.RecsSorted"));
                    this.monitor.worked(5);
                    this.prevFirstDigit = this.firstDigit;
                    continue;
                }
                if (this.monitor.isCanceled()) break;
            }
            if (activeLine != null) {
                this.writePVMLLine(activeLine);
            }
            while ((activeLine = active.readLine()) != null) {
                this.writePVMLLine(activeLine);
            }
        }
        catch (Exception e) {
            String logstr = "sortSectionHex:  Exception, activeLine - " + activeLine + ". " + e;
            System.out.println("pvmlSort - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    public void sortSectionToken() {
        try {
            while (activeLine != null) {
                String[] tempArray = t1.split(activeLine, -1);
                if (Integer.parseInt(tempArray[1]) == 0 && tempArray[2].equals("A")) {
                    tempArray = t1.split(activeLine, -1);
                    sortTokenKey = Long.parseLong(this.getItem(sortBy, activeLine), 16);
                    sortLevel = 0;
                    sortTokenLine.add(new SortToken(sortTokenKey, sAddress, sortLevel));
                }
                activeLine = active.readLine();
            }
            Collections.sort(sortTokenLine);
            this.sortlines = sortTokenLine.size();
            for (SortToken sorted : sortTokenLine) {
                long i1 = sorted.sortTokenKey;
                String s2 = sorted.sAddress.toString().trim();
                int i2 = sorted.sortLevel;
                this.getBlock(String.valueOf(i1) + tab + s2 + tab + i2);
                ++this.sortcnt;
                if (this.monitor == null) continue;
                this.percentDone = (float)this.sortcnt / (float)this.sortlines * 100.0f;
                this.ipercentDone = (int)this.percentDone;
                this.firstDigit = this.ipercentDone / 5;
                if (this.firstDigit != this.prevFirstDigit) {
                    this.monitor.subTask(String.valueOf(this.ipercentDone) + Messages.getString("pvmlSort.Job.SubTask.PctComplete") + this.sortcnt + Messages.getString("pvmlSort.Job.SubTask.Of") + this.sortlines + Messages.getString("pvmlSort.Job.SubTask.RecsSorted"));
                    this.monitor.worked(5);
                    this.prevFirstDigit = this.firstDigit;
                    continue;
                }
                if (this.monitor.isCanceled()) break;
            }
            if (activeLine != null) {
                this.writePVMLLine(activeLine);
            }
            while ((activeLine = active.readLine()) != null) {
                this.writePVMLLine(activeLine);
            }
        }
        catch (Exception e) {
            String logstr = "sortSectionToken:  Exception, activeLine - " + activeLine + ". " + e;
            System.out.println("pvmlSort - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    public void sortSectionFloat() {
        try {
            while (activeLine != null) {
                String[] tempArray;
                if (this.sortReport.equals("J03") && activeLine.contains("Note:")) {
                    activeLine = activeLine.replace("e a th", "000.00");
                }
                if (activeLine.contains(":")) {
                    activeLine = activeLine.replaceAll(":", "");
                }
                if (Integer.parseInt((tempArray = t1.split(activeLine, -1))[1]) == 0 && tempArray[2].equals("A")) {
                    try {
                        sortFloatKey = Float.valueOf(new Float(this.getItem(sortBy, activeLine)).floatValue());
                        if (this.sortReport.equals("J03") && activeLine.contains("Note:")) {
                            sortFloatKey = Float.valueOf(-0.0f);
                        }
                        if ((this.sortReport.equals("I22") || this.sortReport.equals("X06")) && activeLine.contains(" Total ")) {
                            sortFloatKey = Float.valueOf(-0.0f);
                        }
                        if (this.sortReport.equals("C07")) {
                            if (activeLine.contains("NOSYMB")) {
                                sortFloatKey = Float.valueOf(-0.0f);
                            }
                            if (activeLine.contains("APPLCN")) {
                                sortFloatKey = Float.valueOf(-0.0f);
                            }
                            if (activeLine.contains("SYSTEM")) {
                                sortFloatKey = Float.valueOf(-0.0f);
                            }
                        }
                    }
                    catch (Exception exception) {
                        System.out.println(this.getItem(sortBy, activeLine));
                        sortFloatKey = Float.valueOf(999.99f);
                    }
                    sortLevel = 0;
                    sortFloatLine.add(new SortFloat(sortFloatKey.floatValue(), sAddress, sortLevel));
                }
                activeLine = active.readLine();
            }
            Collections.sort(sortFloatLine);
            this.sortlines = sortFloatLine.size();
            for (SortFloat floatObject : sortFloatLine) {
                float f1 = floatObject.sortFloatKey;
                String s2 = floatObject.sAddress.toString().trim();
                int i1 = floatObject.sortLevel;
                this.getBlock(String.valueOf(f1) + tab + s2 + tab + i1);
                ++this.sortcnt;
                if (this.monitor == null) continue;
                this.percentDone = (float)this.sortcnt / (float)this.sortlines * 100.0f;
                this.ipercentDone = (int)this.percentDone;
                this.firstDigit = this.ipercentDone / 5;
                if (this.firstDigit != this.prevFirstDigit) {
                    this.monitor.subTask(String.valueOf(this.ipercentDone) + Messages.getString("pvmlSort.Job.SubTask.PctComplete") + this.decfmt.format(this.sortcnt) + Messages.getString("pvmlSort.Job.SubTask.Of") + this.decfmt.format(this.sortlines) + Messages.getString("pvmlSort.Job.SubTask.RecsSorted"));
                    this.monitor.worked(5);
                    this.prevFirstDigit = this.firstDigit;
                    continue;
                }
                if (!this.monitor.isCanceled()) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            String logstr = "sortSectionFloat:  Exception, activeLine - " + activeLine + ". " + e;
            System.out.println("pvmlSort - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    public void sortDetailString(int parentLevel) {
        try {
            sortLevel = new Integer(this.getLevel(activeLine));
            sortStringKey = this.getItem(sortBy, activeLine);
            byte[] sortStringKeyBA = sortStringKey.getBytes(CorePlugin.getDefault().getPreferenceStore().getString("codePage"));
            sortStringKey = new String(sortStringKeyBA, windows1252);
            if (sortLevel > parentLevel) {
                saveSortLevel = sortLevel;
                if (sortStringKey.trim() != null) {
                    sortLine.add(new SortString(sortStringKey, sAddress, sortLevel));
                }
            }
            if ((activeLine = active.readLine()) != null) {
                sortLevel = new Integer(this.getLevel(activeLine));
            }
            while (sortLevel > parentLevel && activeLine != null) {
                int arrowPosition = activeLine.indexOf(this.rightArrow);
                sortLevel = new Integer(this.getLevel(activeLine));
                if (sortLevel == saveSortLevel && arrowPosition > 0) {
                    sortStringKey = this.getItem(sortBy, activeLine);
                    sortStringKeyBA = sortStringKey.getBytes(CorePlugin.getDefault().getPreferenceStore().getString("codePage"));
                    if ((sortStringKey = new String(sortStringKeyBA, windows1252)).trim() != null) {
                        sortLine.add(new SortString(sortStringKey, sAddress, sortLevel));
                    }
                }
                if ((activeLine = active.readLine()) == null) continue;
                sortLevel = new Integer(this.getLevel(activeLine));
            }
            Collections.sort(sortLine);
            for (SortString sorted : sortLine) {
                String s1 = sorted.sortStringKey.toString().trim();
                String s2 = sorted.sAddress.toString().trim();
                int i1 = sorted.sortLevel;
                this.getBlock(String.valueOf(s1) + tab + s2 + tab + i1);
            }
        }
        catch (Exception e) {
            String logstr = "sortDetailString:  Exception, activeLine - " + activeLine + ". " + e;
            System.out.println("pvmlSort - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    public void sortDetailPath(int parentLevel) {
        try {
            sortLevel = new Integer(this.getLevel(activeLine));
            sortStringKey = this.getItem(sortBy, activeLine).toUpperCase();
            String sortStringKey2 = "";
            if (sortStringKey.length() >= 31) {
                String sAddressSaved = sAddress;
                activeLine = active.readLine();
                sortStringKey2 = this.getItem(sortBy, activeLine).toUpperCase();
                sAddress = sAddressSaved;
            }
            sortStringKey = String.valueOf(sortStringKey) + sortStringKey2;
            byte[] sortStringKeyBA = sortStringKey.getBytes(CorePlugin.getDefault().getPreferenceStore().getString("codePage"));
            sortStringKey = new String(sortStringKeyBA, windows1252);
            if (sortLevel > parentLevel) {
                saveSortLevel = sortLevel;
                sortLine.add(new SortString(sortStringKey, sAddress, sortLevel));
            }
            if ((activeLine = active.readLine()) != null) {
                sortLevel = new Integer(this.getLevel(activeLine));
            }
            while (sortLevel > parentLevel && activeLine != null) {
                int arrowPosition = activeLine.indexOf(this.rightArrow);
                sortLevel = new Integer(this.getLevel(activeLine));
                if (sortLevel == saveSortLevel && arrowPosition > 0) {
                    sortStringKey = this.getItem(sortBy, activeLine).toUpperCase();
                    sortStringKey2 = "";
                    if (sortStringKey.trim().length() >= 32) {
                        String sAddressSaved = sAddress;
                        activeLine = active.readLine();
                        sortStringKey2 = this.getItem(sortBy, activeLine).toUpperCase();
                        sAddress = sAddressSaved;
                    }
                    sortStringKey = String.valueOf(sortStringKey) + sortStringKey2;
                    sortStringKeyBA = sortStringKey.getBytes(CorePlugin.getDefault().getPreferenceStore().getString("codePage"));
                    sortStringKey = new String(sortStringKeyBA, windows1252);
                    sortLine.add(new SortString(sortStringKey, sAddress, sortLevel));
                }
                if ((activeLine = active.readLine()) == null) continue;
                sortLevel = new Integer(this.getLevel(activeLine));
            }
            Collections.sort(sortLine);
            for (SortString sorted : sortLine) {
                String s1 = sorted.sortStringKey.toString().trim();
                String s2 = sorted.sAddress.toString().trim();
                int i1 = sorted.sortLevel;
                this.getBlock(String.valueOf(s1) + tab + s2 + tab + i1);
            }
        }
        catch (Exception e) {
            String logstr = "sortDetailString:  Exception, activeLine - " + activeLine + ". " + e;
            System.out.println("pvmlSort - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    public void sortDetailHybrid(int parentLevel) {
        try {
            sortLevel = new Integer(this.getLevel(activeLine));
            sortStringKey = this.getItem(sortBy, activeLine);
            byte[] sortStringKeyBA = sortStringKey.getBytes(CorePlugin.getDefault().getPreferenceStore().getString("codePage"));
            sortStringKey = new String(sortStringKeyBA, windows1252);
            if (sortLevel > parentLevel) {
                saveSortLevel = sortLevel;
                if (sortStringKey.trim() != null) {
                    sortLine.add(new SortString(sortStringKey, sAddress, sortLevel));
                }
            }
            if ((activeLine = active.readLine()) != null) {
                sortLevel = new Integer(this.getLevel(activeLine));
            }
            while (sortLevel > parentLevel && activeLine != null) {
                int arrowPosition = activeLine.indexOf(this.rightArrow);
                sortLevel = new Integer(this.getLevel(activeLine));
                if (sortLevel == saveSortLevel && arrowPosition > 0) {
                    sortStringKey = this.getItem(sortBy, activeLine);
                    sortStringKeyBA = sortStringKey.getBytes(CorePlugin.getDefault().getPreferenceStore().getString("codePage"));
                    if ((sortStringKey = new String(sortStringKeyBA, windows1252)).trim() != null) {
                        sortLine.add(new SortString(sortStringKey, sAddress, sortLevel));
                    }
                }
                if ((activeLine = active.readLine()) == null) continue;
                sortLevel = new Integer(this.getLevel(activeLine));
            }
            Collections.sort(sortLine);
            for (SortString sorted : sortLine) {
                String s1 = sorted.sortStringKey.toString().trim();
                String s2 = sorted.sAddress.toString().trim();
                int i1 = sorted.sortLevel;
                this.getBlock(String.valueOf(s1) + tab + s2 + tab + i1);
            }
        }
        catch (Exception e) {
            String logstr = "sortDetailHybrid:  Exception, activeLine - " + activeLine + ". " + e;
            System.out.println("pvmlSort - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    public void sortDetailFloat(int parentLevel) {
        try {
            sortLevel = new Integer(this.getLevel(activeLine));
            sortFloatKey = Float.valueOf(new Float(this.getItem(sortBy, activeLine)).floatValue());
            if (sortLevel > parentLevel) {
                saveSortLevel = sortLevel;
                sortFloatLine.add(new SortFloat(sortFloatKey.floatValue(), sAddress, sortLevel));
            }
            if ((activeLine = active.readLine()) != null) {
                sortLevel = new Integer(this.getLevel(activeLine));
            }
            while (sortLevel > parentLevel && activeLine != null) {
                int arrowPosition = activeLine.indexOf(this.rightArrow);
                sortLevel = new Integer(this.getLevel(activeLine));
                if (sortLevel == saveSortLevel && arrowPosition > 0) {
                    sortFloatKey = Float.valueOf(new Float(this.getItem(sortBy, activeLine)).floatValue());
                    sortFloatLine.add(new SortFloat(sortFloatKey.floatValue(), sAddress, sortLevel));
                }
                if ((activeLine = active.readLine()) == null) continue;
                sortLevel = new Integer(this.getLevel(activeLine));
            }
            Collections.sort(sortFloatLine);
            for (SortFloat sorted : sortFloatLine) {
                Float f1 = Float.valueOf(sorted.sortFloatKey);
                String s2 = sorted.sAddress.toString().trim();
                int i1 = sorted.sortLevel;
                this.getBlock(f1 + tab + s2 + tab + i1);
            }
        }
        catch (Exception e) {
            String logstr = "sortDetailFloat:  Exception, activeLine - " + activeLine + ". " + e;
            System.out.println("pvmlSort - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    public void sortDetailHex(int parentLevel) {
        try {
            sortLevel = new Integer(this.getLevel(activeLine));
            sortHexKey = Integer.parseInt(this.getItem(sortBy, activeLine), 16);
            if (sortLevel > parentLevel) {
                saveSortLevel = sortLevel;
                sortHexLine.add(new SortHex(sortHexKey, sAddress, sortLevel));
            }
            if ((activeLine = active.readLine()) != null) {
                sortLevel = new Integer(this.getLevel(activeLine));
            }
            while (sortLevel > parentLevel && activeLine != null) {
                int arrowPosition = activeLine.indexOf(this.rightArrow);
                sortLevel = new Integer(this.getLevel(activeLine));
                if (sortLevel == saveSortLevel && arrowPosition > 0) {
                    sortHexKey = Integer.parseInt(this.getItem(sortBy, activeLine), 16);
                    sortHexLine.add(new SortHex(sortHexKey, sAddress, sortLevel));
                }
                if ((activeLine = active.readLine()) == null) continue;
                sortLevel = new Integer(this.getLevel(activeLine));
            }
            Collections.sort(sortHexLine);
            for (SortHex sorted : sortHexLine) {
                Integer i1 = sorted.sortHexKey;
                String s2 = sorted.sAddress.toString().trim();
                int i2 = sorted.sortLevel;
                this.getBlock(i1 + tab + s2 + tab + i2);
            }
        }
        catch (Exception e) {
            String logstr = "sortDetailHex:  Exception, activeLine - " + activeLine + ". " + e;
            System.out.println("pvmlSort - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    public String getLevel(String itemLine) {
        String itemVal = "";
        activeArray = t1.split(itemLine, -1);
        itemVal = activeArray[1];
        return itemVal;
    }

    public String getItem(String itemName, String itemLine) {
        String itemTempVal = "";
        String[] lineArray = null;
        int tempSortStartColumn = sortStartColumn;
        activeArray = t1.split(itemLine, -1);
        if (tempSortStartColumn > 0) {
            lineArray = sp1.split(activeArray[5]);
            if (this.specialInstructions.equals("NC+") && activeArray[5].indexOf(43) < 0) {
                --tempSortStartColumn;
            }
            if (this.specialInstructions.equals("L")) {
                tempSortStartColumn = lineArray.length - sortStartColumn;
            }
            itemTempVal = activeArray[5].indexOf(this.rightArrow) >= 0 ? lineArray[tempSortStartColumn + 1] : lineArray[tempSortStartColumn];
        } else {
            int maxLength;
            int itemLength = activeArray[5].length();
            if (itemLength <= (maxLength = sortStart + sortLength)) {
                itemTempVal = activeArray[5].substring(sortStart);
            } else {
                itemTempVal = activeArray[5].substring(sortStart, sortStart + sortLength);
                itemTempVal = itemTempVal.trim();
            }
        }
        if (this.specialInstructions.startsWith("M")) {
            String formattedString2;
            Integer mergeColumn = Integer.parseInt(this.specialInstructions.substring(1));
            if (this.sortReport.equals("F02")) {
                String formattedString1 = lineArray[tempSortStartColumn];
                int lastCol = lineArray.length;
                formattedString2 = lineArray[lastCol - mergeColumn];
                itemTempVal = String.valueOf(formattedString2) + formattedString1;
            } else {
                String formattedString1 = String.format("%1$-8s", lineArray[tempSortStartColumn]);
                Integer tempInt = Integer.parseInt(lineArray[mergeColumn]);
                formattedString2 = String.format("%08d%n", tempInt);
                itemTempVal = String.valueOf(formattedString1) + formattedString2;
                formattedString1 = null;
                formattedString2 = null;
                tempInt = null;
            }
        }
        if (itemName.equals("CYLINDER")) {
            itemTempVal = itemTempVal.replaceAll("Cyl_", "");
        }
        if (itemName.contains("DDNAME")) {
            String[] itemSplit = itemTempVal.split("-");
            String tempString = "";
            tempString = itemSplit.length > 1 ? pvmlSort.paddString(itemSplit[1], 4, '0', true) : "";
            itemTempVal = String.valueOf(itemSplit[0]) + tempString;
            tempString = null;
        }
        if (itemName.equals("SIZE") || itemName.equals("S-SIZE")) {
            String regex = "(?<=\\d),(?=\\d)";
            itemTempVal = itemTempVal.replaceAll(regex, "");
        }
        if (itemName.equals("COUNT") || itemName.equals("S-COUNT")) {
            String regex = "(?<=\\d),(?=\\d)";
            itemTempVal = itemTempVal.replaceAll(regex, "");
        }
        if (itemName.equals("LOCATION") || itemName.equals("S-LOCATION")) {
            if (itemTempVal.contains("+")) {
                String[] itemSplit = itemTempVal.split("[+]");
                if (itemSplit.length > 1) {
                    String modName = String.format("%1$-8s", itemSplit[0]);
                    Integer hexVal = Integer.parseInt(itemSplit[1], 16);
                    String sHexVal = String.format("%010d", hexVal);
                    itemTempVal = String.valueOf(modName) + sHexVal;
                } else {
                    String sHexVal;
                    Integer hexVal = Integer.parseInt(itemSplit[0], 16);
                    itemTempVal = sHexVal = String.format("%010d", hexVal);
                }
            } else {
                itemTempVal = String.format("%1$-8s", itemTempVal);
            }
        }
        if (itemName.equals("ADDRESS") || itemName.equals("S-ADDRESS") || itemName.equals("S-TOKEN")) {
            if (itemTempVal.contains("-")) {
                String[] itemSplit = itemTempVal.split("[-]");
                if (Integer.parseInt(itemSplit[0], 16) > 0) {
                    itemSplit[1] = Integer.toString(Integer.MAX_VALUE, 16);
                }
                itemTempVal = itemSplit[1];
            }
            if (itemTempVal.contains("_")) {
                String[] itemSplit = itemTempVal.split("[_]");
                if (Integer.parseInt(itemSplit[0], 16) > 0) {
                    itemSplit[1] = Integer.toString(Integer.MAX_VALUE, 16);
                }
                itemTempVal = itemSplit[1];
            }
        }
        if ((itemName.equals("NAME") || itemName.equals("S-NAME")) && itemTempVal.contains("SYSOUT-")) {
            String[] itemSplit = itemTempVal.split("[-]");
            String tempString = pvmlSort.paddString(itemSplit[1], 8, '0', true);
            itemTempVal = String.valueOf(itemSplit[0]) + tempString;
        }
        sAddress = activeArray[6];
        return itemTempVal.trim();
    }

    public void getBlock(String blockID) {
        String directLine = null;
        String[] parmArray = null;
        String[] tempArray = null;
        int saveLevel = 0;
        int level = 99;
        parmArray = blockID.split(tabDelimiter);
        long pointer = Long.parseLong(parmArray[1].trim());
        try {
            boolean nextBlock;
            rBaseFile.seek(pointer);
            directLine = this.readUtfLine();
            if (directLine != null) {
                tempArray = directLine.split(tabDelimiter);
                saveLevel = Integer.parseInt(tempArray[1]);
                nextBlock = false;
            } else {
                nextBlock = true;
                level = saveLevel;
            }
            while (level >= saveLevel && directLine != null) {
                if (level > saveLevel) {
                    this.writePVMLLine(directLine);
                } else if (tempArray[2].equals("0")) {
                    this.writePVMLLine(directLine);
                } else {
                    nextBlock = true;
                }
                if (nextBlock) {
                    level = -1;
                    continue;
                }
                directLine = this.readUtfLine();
                if (directLine == null) {
                    level = saveLevel;
                    continue;
                }
                tempArray = directLine.split(tabDelimiter);
                level = Integer.parseInt(tempArray[1]);
            }
        }
        catch (Exception e) {
            String logstr = "getBlock:  Reset exception, directLine - " + directLine + ". " + e;
            System.out.println("pvmlSort - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    public String readUtfLine() {
        int b = 32;
        byte[] ba = new byte[1000];
        int i = 0;
        boolean eofIndicator = false;
        try {
            b = rBaseFile.readByte();
            while (b != 10) {
                ba[i] = b;
                ++i;
                b = rBaseFile.readByte();
            }
        }
        catch (EOFException eOFException) {
            eofIndicator = true;
        }
        catch (IOException e) {
            String logstr = "readUtfLine:  IO exception. " + e;
            System.out.println("pvmlSort - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        String tempLine = null;
        if (!eofIndicator) {
            byte[] dst = pvmlSort.trimArray(ba, i);
            try {
                tempLine = new String(dst, "UTF-8");
            }
            catch (Exception e) {
                String logstr = "readUtfLine:  Exception. " + e;
                System.out.println("pvmlSort - " + logstr);
                CorePlugin.getDefault().log.error(logstr);
            }
        }
        return tempLine;
    }

    static byte[] trimArray(byte[] input, int newsize) {
        byte[] result = new byte[newsize];
        System.arraycopy(input, 0, result, 0, newsize);
        return result;
    }

    public void writePVMLLine(String outputLine) {
        String[] pvmlArray = t1.split(outputLine);
        StringBuffer pvmlBuffer = new StringBuffer();
        pvmlArray[6] = Long.toString(workFile.length());
        int i = 0;
        while (i < pvmlArray.length - 1) {
            pvmlBuffer.append(pvmlArray[i]);
            pvmlBuffer.append('\t');
            ++i;
        }
        pvmlBuffer.append(pvmlArray[pvmlArray.length - 1]);
        outputLine = pvmlBuffer.toString();
        work.print(String.valueOf(outputLine) + '\n');
        work.flush();
        outputLine = "";
        pvmlArray = null;
    }

    /*
     * Unable to fully structure code
     */
    public void setInitialPosition(String untilPosition) {
        block5: {
            try {
                pvmlSort.activeLine = pvmlSort.active.readLine();
                if (!untilPosition.equals("S")) ** GOTO lbl15
                tempArray = pvmlSort.t1.split(pvmlSort.activeLine);
                while (tempArray[2].equals("S") && pvmlSort.activeLine != null) {
                    if (tempArray[5].indexOf("*....1....2") > 0) {
                        pvmlSort.valueStarts = tempArray[5].indexOf("*....1....2") - 6;
                    }
                    this.writePVMLLine(pvmlSort.activeLine);
                    pvmlSort.activeLine = pvmlSort.active.readLine();
                    tempArray = pvmlSort.t1.split(pvmlSort.activeLine);
                }
                break block5;
lbl-1000:
                // 1 sources

                {
                    this.writePVMLLine(pvmlSort.activeLine);
                    pvmlSort.activeLine = pvmlSort.active.readLine();
lbl15:
                    // 2 sources

                    ** while (pvmlSort.activeLine.indexOf((String)untilPosition) < 0 && pvmlSort.activeLine != null)
                }
lbl16:
                // 1 sources

            }
            catch (Exception e) {
                logstr = "setInitialPosition:  Exception, activeLine - " + pvmlSort.activeLine + ". " + e;
                System.out.println("pvmlSort - " + logstr);
                CorePlugin.getDefault().log.error(logstr);
            }
        }
    }

    public static String paddString(String s, int n, char c, boolean paddingLeft) {
        int add = n - s.length();
        if (add <= 0) {
            return s;
        }
        StringBuffer str = new StringBuffer(s);
        char[] ch = new char[add];
        Arrays.fill(ch, c);
        if (paddingLeft) {
            str.insert(0, ch);
        } else {
            str.append(ch);
        }
        return str.toString();
    }

    class SortEbcidic
    implements Comparable<SortEbcidic> {
        final byte[] sortEbcidicKey;
        final String sAddress;
        final int sortLevel;

        @Override
        public int compareTo(SortEbcidic o) {
            SortEbcidic that = o;
            byte[] b1 = this.sortEbcidicKey;
            int len1 = b1.length;
            byte[] b2 = that.sortEbcidicKey;
            int len2 = b2.length;
            int complen = len1 < len2 ? len1 : len2;
            int j = 0;
            while (j < complen) {
                int diff = b1[j] - b2[j];
                if (diff != 0) {
                    return diff;
                }
                ++j;
            }
            return len1 - len2;
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public String toString() {
            return this.sortEbcidicKey + "  " + this.sAddress + " " + this.sortLevel;
        }

        SortEbcidic(byte[] sortEbcidicKey, String sAddress, int sortLevel) {
            this.sortEbcidicKey = sortEbcidicKey;
            this.sAddress = sAddress;
            this.sortLevel = sortLevel;
        }
    }

    public class SortFloat
    implements Comparable<SortFloat> {
        final float sortFloatKey;
        final String sAddress;
        final int sortLevel;

        @Override
        public int compareTo(SortFloat o) {
            SortFloat that = o;
            if (this.sortFloatKey < that.sortFloatKey) {
                if (sortOrder == 'D') {
                    return -1;
                }
                return 1;
            }
            if (this.sortFloatKey > that.sortFloatKey) {
                if (sortOrder == 'D') {
                    return 1;
                }
                return -1;
            }
            return 0;
        }

        public String toString() {
            return String.valueOf(this.sortFloatKey) + "  " + this.sAddress + " " + this.sortLevel;
        }

        SortFloat(float sortFloatKey, String sAddress, int sortLevel) {
            this.sortFloatKey = sortFloatKey;
            this.sAddress = sAddress;
            this.sortLevel = sortLevel;
        }
    }

    public class SortHex
    implements Comparable<SortHex> {
        final int sortHexKey;
        final String sAddress;
        final int sortLevel;

        @Override
        public int compareTo(SortHex o) {
            SortHex that = o;
            if (this.sortHexKey < that.sortHexKey) {
                if (sortOrder == 'D') {
                    return 1;
                }
                return -1;
            }
            if (this.sortHexKey > that.sortHexKey) {
                if (sortOrder == 'D') {
                    return -1;
                }
                return 1;
            }
            return 0;
        }

        public String toString() {
            return String.valueOf(this.sortHexKey) + "  " + this.sAddress + " " + this.sortLevel;
        }

        SortHex(int sortHexKey, String sAddress, int sortLevel) {
            this.sortHexKey = sortHexKey;
            this.sAddress = sAddress;
            this.sortLevel = sortLevel;
        }
    }

    public class SortNumber
    implements Comparable<SortNumber> {
        final Integer sortNumberKey;
        final String sAddress;
        final int sortLevel;

        @Override
        public int compareTo(SortNumber o) {
            SortNumber that = o;
            if (this.sortNumberKey < that.sortNumberKey) {
                if (sortBy.equals("S-SIZE")) {
                    return 1;
                }
                return -1;
            }
            if (this.sortNumberKey > that.sortNumberKey) {
                if (sortBy.equals("S-SIZE")) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }

        public String toString() {
            return this.sortNumberKey + "  " + this.sAddress + " " + this.sortLevel;
        }

        SortNumber(int sortNumberKey, String sAddress, int sortLevel) {
            this.sortNumberKey = sortNumberKey;
            this.sAddress = sAddress;
            this.sortLevel = sortLevel;
        }
    }

    public class SortString
    implements Comparable<SortString> {
        final String sortStringKey;
        final String sAddress;
        final int sortLevel;

        @Override
        public int compareTo(SortString o) {
            return this.sortStringKey.compareTo(o.sortStringKey);
        }

        public SortString(String sortStringKey, String sAddress, int sortLevel) {
            this.sortStringKey = sortStringKey;
            this.sAddress = sAddress;
            this.sortLevel = sortLevel;
        }

        public String toString() {
            return String.valueOf(this.sortStringKey) + "  " + this.sAddress + " " + this.sortLevel;
        }
    }

    public class SortToken
    implements Comparable<SortToken> {
        final long sortTokenKey;
        final String sAddress;
        final int sortLevel;

        @Override
        public int compareTo(SortToken o) {
            SortToken that = o;
            if (this.sortTokenKey < that.sortTokenKey) {
                if (sortOrder == 'D') {
                    return 1;
                }
                return -1;
            }
            if (this.sortTokenKey > that.sortTokenKey) {
                if (sortOrder == 'D') {
                    return -1;
                }
                return 1;
            }
            return 0;
        }

        public String toString() {
            return String.valueOf(this.sortTokenKey) + "  " + this.sAddress + " " + this.sortLevel;
        }

        SortToken(long sortTokenKey, String sAddress, int sortLevel) {
            this.sortTokenKey = sortTokenKey;
            this.sAddress = sAddress;
            this.sortLevel = sortLevel;
        }
    }
}

