/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.internal;

import com.banknet.core.CorePlugin;
import com.banknet.core.dialogs.reports.ReportDetailDialog;
import com.banknet.core.dialogs.reports.ReportViewerDialog;
import com.banknet.core.internal.Messages;
import com.banknet.core.views.reports.ReportTextView;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;

public class pvmlReader {
    public StringBuilder PVMLHeader = new StringBuilder();
    public StringBuilder PVMLBody = new StringBuilder();
    public StringBuilder PVMLPrint = new StringBuilder();
    public ReportTextView rtv;
    public ReportDetailDialog rdd;
    public ReportViewerDialog rvd;
    public IProgressMonitor monitor = null;
    public String[] tokens;
    String detailOffset = "";
    String tabDelimiter = "[\t]";
    String styleDelimiter1 = "[,]";
    Pattern t1 = Pattern.compile(this.tabDelimiter);
    Pattern s1 = Pattern.compile(this.styleDelimiter1);
    String sectiontype = "";
    int pageOffset = 0;
    int printPageOffset = 0;
    int lineLength = 0;
    boolean headerFound = false;
    public String errmsg = "";
    public DecimalFormat decfmt = new DecimalFormat("###,###,###,##0");

    public static void main(String[] args) {
        try {
            pvmlReader pr = new pvmlReader();
            pr.processReport("c://eclipseworkspace//TestEclipseProjects//pvml//c01Print.txt", "c01", false);
        }
        catch (OutOfMemoryError oem) {
            System.out.println("pvmlReader main processReport out of memory exception " + oem);
        }
        catch (Exception ex) {
            System.out.println("pvmlReader main processReport exception xx " + ex);
        }
    }

    public void processReport(String reportName, String reportTitle, boolean htmlformat) throws Exception, OutOfMemoryError {
        String pvmlLine = null;
        float fileSize = 0.0f;
        float lineSize = 0.0f;
        String sfileSize = "";
        String slineSize = "";
        int percentRead = 0;
        int lastDigit = 0;
        int saveRead = 100;
        int pctincr = 10;
        if (this.monitor != null) {
            this.monitor.worked(0);
        }
        try {
            File fInputFile = new File(reportName);
            fileSize = fInputFile.length();
            sfileSize = this.decfmt.format(fileSize);
            BufferedReader brStyle = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fInputFile), "UTF-8"));
            while ((pvmlLine = brStyle.readLine()) != null) {
                lineSize = (float)pvmlLine.length() + lineSize;
                slineSize = this.decfmt.format(lineSize);
                this.tokens = this.t1.split(pvmlLine);
                if (this.tokens.length > 1) {
                    this.parseLine(pvmlLine);
                } else {
                    this.errmsg = String.valueOf(Messages.getString("pvmlReader.MessageDialog.errorMessage.FileFormat")) + "\n" + pvmlLine;
                }
                percentRead = (int)(lineSize / fileSize * 100.0f);
                lastDigit = percentRead % 10;
                if (lastDigit != 0 || saveRead == percentRead) continue;
                if (this.monitor != null) {
                    if (this.monitor.isCanceled()) break;
                    this.monitor.subTask(String.valueOf(percentRead) + Messages.getString("pvmlReader.Job.SubTask.PctComplete") + slineSize + Messages.getString("pvmlReader.Job.SubTask.Of") + sfileSize + Messages.getString("pvmlReader.Job.SubTask.BytesLoaded"));
                    this.monitor.worked(pctincr);
                }
                saveRead = percentRead;
            }
            brStyle.close();
            fInputFile = null;
        }
        catch (OutOfMemoryError oem) {
            String logstr = "processReport:  Out of Memory exception. pvmlLine: " + pvmlLine + ", percentRead: " + percentRead + ". " + oem;
            System.out.println("pvmlReader - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            throw oem;
        }
        catch (IOException e) {
            String logstr = "processReport:  IO exception. pvmlLine: " + pvmlLine + ", percentRead: " + percentRead + ". " + e;
            System.out.println("pvmlReader - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            throw e;
        }
    }

    private void parseLine(String pvmlLine) throws Exception, OutOfMemoryError {
        this.tokens = this.t1.split(pvmlLine);
        this.sectiontype = this.tokens[2];
        this.lineLength = Integer.parseInt(this.tokens[3]);
        this.PVMLPrint.append(this.tokens[5]);
        this.PVMLPrint.append("\n");
        if (this.sectiontype.equals("S") && this.rtv != null | this.rvd != null) {
            this.headerFound = true;
            this.PVMLHeader.append(this.tokens[5]);
            this.PVMLHeader.append("\n");
        } else {
            if (this.headerFound) {
                this.pageOffset = 0;
                this.headerFound = false;
            }
            this.PVMLBody.append(this.tokens[5]);
            this.PVMLBody.append("\n");
        }
        this.detailOffset = "";
        if (this.tokens.length >= 8) {
            this.detailOffset = this.tokens[7];
        }
        String PVMLStyle = this.tokens[4];
        String styleLine = null;
        String[] styleArray = this.s1.split(PVMLStyle);
        int i = 0;
        while (i < styleArray.length) {
            this.s1.split(styleArray[i]);
            if (styleArray[i].indexOf("|") > 0) {
                styleLine = styleArray[i];
                if (this.rdd != null) {
                    this.rdd.setReportStyleRange(styleLine, this.sectiontype, this.pageOffset, this.printPageOffset);
                } else if (this.rvd != null) {
                    this.rvd.setReportStyleRange(styleLine, this.sectiontype, this.pageOffset, this.printPageOffset, this.detailOffset);
                } else {
                    this.rtv.setReportStyleRange(styleLine, this.sectiontype, this.pageOffset, this.printPageOffset, this.detailOffset);
                }
                styleLine = null;
            }
            ++i;
        }
        this.pageOffset += this.lineLength;
        this.printPageOffset += this.lineLength;
    }
}

