/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.internal;

import com.banknet.core.CorePlugin;
import com.banknet.core.internal.Messages;
import com.banknet.core.internal.Utilities;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;

public class ZosSession {
    Utilities utilities = new Utilities();
    public static int globalReceiveBufSize = 1024;
    public static ByteBuffer headerBuffer = ByteBuffer.allocate(globalReceiveBufSize);
    public static int tcpipHeaderOffset = 14;
    public static int bnetHeaderOffset = 19;
    public static int lseHeaderOffset = 11;
    public static int lseHeaderOffset_len = 6;
    public static int ssloeOffset = 3;
    public IProgressMonitor monitor = null;
    int reqnum;
    public String commandLine = new String();
    public int returnCode;
    public int reasonCode;
    public String reason;
    public String stcIs;
    public int doCmdResp_rc = 0;
    public String doCmdResp_errmsg;
    public String zosErrorMessage = "";
    public String memMsg = "";
    public String zosVersion = "";
    public int keepAliveSecs = 0;
    public DecimalFormat decfmt = new DecimalFormat("###,###,###,##0");
    short reportDescriptor = 0;
    public String COMPATGUI = "";
    public String DLGUI = "";
    public int maxCookies = 1;
    public String rptCookie = "";
    public String CommonServerName = "";
    public String CommonServerVersion = "";
    public String CommonServerRelease = "";
    public String CommonServerPort = "";
    public String ConnectionLastSignon = "";
    public String LSTC_VERSION = "";
    public String LSTC_APAR = "";
    public String LSTC_PAPAR = "";
    public String LSTC_MAPAR = "";
    public String LSTC_4APAR = "";
    public String LSTC_JOBN = "";
    public String LSTC_JOBI = "";
    public InputStream inputstream = null;
    public OutputStream outputstream = null;
    public Socket socket;
    public byte[] responseArray;
    public boolean sslOn = false;
    public boolean enableEmail = false;
    public boolean priorConnect = false;
    public int socketBufferSize;
    String[] sslCiphers;
    String[] sslProtocols;
    public static String delimSpace = " ";
    public String parmDelim = delimSpace;

    public ZosSession() {
        this.logMessage('I', "Constructor:  Heap Size " + Runtime.getRuntime().totalMemory());
        this.logMessage('I', "Constructor:  Heap Max Size " + Runtime.getRuntime().maxMemory());
    }

    public int startSession(String hostName, int port) {
        if (this.priorConnect) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                System.out.println(ie.getMessage());
            }
        } else {
            this.priorConnect = true;
        }
        this.doCmdResp_rc = 0;
        this.logMessage('D', "startSession: SSL : " + this.sslOn);
        if (this.sslOn) {
            CorePlugin.getDefault().connectionextension.establishSSL(hostName, port);
            try {
                this.inputstream = CorePlugin.getDefault().connectionextension.getSslInputStream();
                this.outputstream = CorePlugin.getDefault().connectionextension.getSslOutputStream();
                this.socketBufferSize = CorePlugin.getDefault().connectionextension.getSslReceiveBufferSize();
                this.logMessage('D', "startSession: sslSocket created " + hostName + " " + port);
                this.logMessage('D', "startSession: receive buffer size : " + this.socketBufferSize);
            }
            catch (Exception e) {
                this.logMessage('E', "Method: startSession - Unable to create ssl socket. " + e.getLocalizedMessage());
                this.doCmdResp_rc = 1015;
            }
        } else {
            try {
                this.socket = new Socket(hostName, port);
                this.inputstream = this.socket.getInputStream();
                this.outputstream = this.socket.getOutputStream();
                this.socketBufferSize = this.socket.getReceiveBufferSize() * 4;
                this.logMessage('D', "startSession: socket created " + hostName + " " + port);
                this.logMessage('D', "startSession: receive buffer size : " + this.socketBufferSize);
            }
            catch (Exception exception) {
                this.logMessage('E', "Method: startSession - Unable to create socket.");
                this.doCmdResp_rc = 1007;
            }
        }
        return this.doCmdResp_rc;
    }

    public int sendSystemMessage(String command, char encoding) {
        int rc;
        this.doCmdResp_rc = 0;
        byte[] bCommand = new byte[1024];
        int commandLength = 0;
        if (command.startsWith("HANDSHAKE") && (rc = CorePlugin.getDefault().connectionextension.checkServerExtension(this.monitor)) < 0) {
            this.logMessage('E', "Method: sendSystemMessage - Error receiving APA Ready message from z/OS.");
            this.doCmdResp_rc = 1017;
            return this.doCmdResp_rc;
        }
        if (encoding == 'E') {
            byte[] tempCommand = null;
            try {
                tempCommand = command.getBytes(CorePlugin.getDefault().getPreferenceStore().getString("codePage"));
            }
            catch (Exception exception) {
                this.logMessage('E', "Method: startSession - Command Encoding Error.");
                this.doCmdResp_rc = 1006;
            }
            int i = 0;
            while (i < tempCommand.length) {
                bCommand[i] = tempCommand[i];
                ++i;
            }
            if (command.substring(0, 5).equals("START")) {
                int firstComma = command.indexOf(44);
                int secondComma = command.indexOf(44, firstComma + 1);
                int thirdComma = command.indexOf(44, secondComma + 1);
                int uidPosition = secondComma + 1;
                int pswdPosition = thirdComma + 1;
                int uidLength = thirdComma - secondComma - 1;
                int pswdLength = command.length() - pswdPosition;
                String uid = command.substring(uidPosition, uidPosition + uidLength);
                byte[] encUid = this.hideString(uid);
                String pswd = command.substring(pswdPosition);
                byte[] encPwd = this.hideString(pswd);
                String useridToZos = ZosSession.byteArrayToHexString(encUid);
                byte[] hexUserid = null;
                try {
                    hexUserid = useridToZos.getBytes(CorePlugin.getDefault().getPreferenceStore().getString("codePage"));
                }
                catch (Exception exception) {
                    this.logMessage('E', "Method: startSession - Userid Encoding Error.");
                    this.doCmdResp_rc = 1006;
                }
                int i2 = 0;
                while (i2 < hexUserid.length) {
                    bCommand[uidPosition + i2] = hexUserid[i2];
                    ++i2;
                }
                bCommand[uidPosition + uidLength * 2] = 107;
                int newPosition = uidPosition + uidLength * 2 + 1;
                String passwdToZos = ZosSession.byteArrayToHexString(encPwd);
                byte[] hexPassword = null;
                try {
                    hexPassword = passwdToZos.getBytes(CorePlugin.getDefault().getPreferenceStore().getString("codePage"));
                }
                catch (Exception exception) {
                    this.logMessage('E', "Method: startSession - Password Encoding Error.");
                    this.doCmdResp_rc = 1006;
                }
                int i3 = 0;
                while (i3 < hexPassword.length) {
                    bCommand[newPosition + i3] = hexPassword[i3];
                    ++i3;
                }
                commandLength = command.length() + pswdLength + uidLength;
            }
        } else {
            bCommand = command.getBytes();
            commandLength = command.length();
        }
        int messageLength = commandLength + tcpipHeaderOffset + 1;
        byte[] bSystemMessage = new byte[messageLength];
        int i = 0;
        while (i < messageLength) {
            bSystemMessage[i] = 0;
            ++i;
        }
        String sBNETHeaderLength = String.format("%010d", messageLength);
        String sBNETHeader = String.valueOf(sBNETHeaderLength) + encoding + "000";
        byte[] tempHeader = sBNETHeader.getBytes();
        int startPosition = 0;
        int i4 = 0;
        while (i4 < tempHeader.length) {
            bSystemMessage[i4] = tempHeader[i4];
            startPosition = i4++;
        }
        i4 = 0;
        while (i4 < commandLength) {
            bSystemMessage[i4 + startPosition + 1] = bCommand[i4];
            ++i4;
        }
        int numBytesRead = 0;
        CorePlugin.getDefault().connectionextension.zosWrite(bSystemMessage, this.monitor);
        try {
            String[] commandArray = command.split(" ");
            String fname = commandArray[0];
            numBytesRead = CorePlugin.getDefault().connectionextension.zosRead(fname, this.monitor);
            try {
                String fullFName = this.queueFile(fname);
                File responseFile = new File(fullFName);
                this.responseArray = new byte[(int)responseFile.length()];
                DataInputStream dis = new DataInputStream(new FileInputStream(responseFile));
                dis.readFully(this.responseArray);
                dis.close();
            }
            catch (Exception exception) {}
            this.logMessage('D', "sendSystemMessage: Bytes Received " + numBytesRead);
            if (numBytesRead <= 0) {
                throw new Exception();
            }
        }
        catch (SocketException socketException) {
            this.logMessage('E', "Method: startSession - Error receiving message from z/OS.");
            this.doCmdResp_rc = 1016;
            return this.doCmdResp_rc;
        }
        catch (Exception exception) {
            this.logMessage('E', "Method: startSession - Error receiving message from z/OS.");
            this.doCmdResp_rc = 1006;
            return this.doCmdResp_rc;
        }
        byte[] tempBytes = new byte[numBytesRead];
        int i5 = 0;
        while (i5 < numBytesRead) {
            tempBytes[i5] = this.responseArray[i5];
            if (tempBytes[i5] == -6) {
                tempBytes[i5] = 124;
            }
            ++i5;
        }
        String sBNETResponse = null;
        try {
            sBNETResponse = new String(tempBytes, "UTF-8");
        }
        catch (Exception exception) {}
        int responseStart = tcpipHeaderOffset + 9;
        String command_rc = sBNETResponse.substring(responseStart, responseStart + 4);
        String command_rsn = sBNETResponse.substring(responseStart + 5, responseStart + 4 + 5);
        Integer iCommand_rc = Integer.parseInt(command_rc);
        Integer iCommand_rsn = Integer.parseInt(command_rsn);
        if (command.substring(0, 9).toUpperCase().equals("HANDSHAKE")) {
            this.enableEmail = false;
            int startOfPayload = sBNETResponse.indexOf(124) + 1;
            int endOfPayload = sBNETResponse.indexOf(124, startOfPayload + 1);
            String sPayload = sBNETResponse.substring(startOfPayload, endOfPayload).trim();
            if (iCommand_rc <= 4) {
                String[] payloadParms = sPayload.split("\\s+");
                int i6 = 0;
                while (i6 < payloadParms.length) {
                    this.logMessage('D', "sendSystemMessage:  Payload parameter " + i6 + " " + payloadParms[i6]);
                    String[] payloadParm = payloadParms[i6].split("=");
                    if (payloadParm[0].equalsIgnoreCase("VER")) {
                        this.zosVersion = payloadParm[1];
                    } else if (payloadParm[0].equalsIgnoreCase("COMPATGUI")) {
                        this.COMPATGUI = payloadParm[1];
                    } else if (payloadParm[0].equalsIgnoreCase("DLGUI")) {
                        this.DLGUI = payloadParm[1];
                    } else if (payloadParm[0].equalsIgnoreCase("KCON")) {
                        try {
                            int kcon;
                            this.keepAliveSecs = kcon = new Integer(payloadParm[1]).intValue();
                            if (this.keepAliveSecs == 0) {
                                this.keepAliveSecs = 86400;
                            }
                        }
                        catch (Exception exception) {
                            this.logMessage('E', "Method: startSession - Error parsing handshake (kcon) from z/OS.");
                            this.doCmdResp_rc = 1006;
                        }
                        if (this.keepAliveSecs > 0) {
                            this.logMessage('D', "sendSystemMessage:  Keep Alive every " + this.keepAliveSecs + " seconds");
                        }
                    } else if (payloadParm[0].equalsIgnoreCase("MAXOPENOBS")) {
                        try {
                            int maxOpenObs;
                            this.maxCookies = maxOpenObs = new Integer(payloadParm[1]).intValue();
                        }
                        catch (Exception exception) {
                            this.logMessage('E', "Method: startSession - Error parsing handshake (maxOpenObs) from z/OS.");
                            this.doCmdResp_rc = 1006;
                        }
                    } else if (payloadParm[0].equalsIgnoreCase("LSTC_VERSION")) {
                        this.LSTC_VERSION = payloadParm[1];
                    } else if (payloadParm[0].equalsIgnoreCase("LSTC_PAPAR")) {
                        this.LSTC_PAPAR = payloadParm[1];
                    } else if (payloadParm[0].equalsIgnoreCase("LSTC_MAPAR")) {
                        this.LSTC_MAPAR = payloadParm[1];
                    } else if (payloadParm[0].equalsIgnoreCase("LSTC_4APAR")) {
                        this.LSTC_4APAR = payloadParm[1];
                    } else if (payloadParm[0].equalsIgnoreCase("LSTC_JOBN")) {
                        this.LSTC_JOBN = payloadParm[1];
                    } else if (payloadParm[0].equalsIgnoreCase("LSTC_JOBI")) {
                        this.LSTC_JOBI = payloadParm[1];
                    }
                    this.formatAparList();
                    ++i6;
                }
            } else {
                this.doCmdResp_rc = 1006;
                this.returnCode = iCommand_rc;
                this.reason = sPayload;
                this.logMessage('D', "sendSystemMessage:  Analyze Handshake Payload: " + sPayload);
            }
        }
        if (command.substring(0, 5).toUpperCase().equals("START")) {
            String saf_rc = null;
            String racf_rc = null;
            if (iCommand_rc > 0) {
                if (iCommand_rsn == 28) {
                    int endOfPayload;
                    int startOfPayload = sBNETResponse.indexOf(124) + 1;
                    String sPayload = sBNETResponse.substring(startOfPayload, endOfPayload = sBNETResponse.indexOf(124, startOfPayload + 1)).trim();
                    String[] payloadResponse = sPayload.split(",");
                    if (payloadResponse.length > 2) {
                        int i7 = 0;
                        while (i7 < payloadResponse.length) {
                            System.out.println(payloadResponse[i7]);
                            ++i7;
                        }
                        saf_rc = payloadResponse[0].substring(6);
                        racf_rc = payloadResponse[1].substring(6);
                        payloadResponse[2].substring(6);
                        this.returnCode = new Integer(saf_rc);
                        this.reasonCode = 0;
                        this.reason = this.utilities.getErrorMessage("saf" + saf_rc, racf_rc);
                        this.logMessage('E', "sendSystemMessage:  " + this.reason + "     SAF RC: " + saf_rc + " RACF RC: " + racf_rc);
                        this.doCmdResp_rc = 1006;
                    } else {
                        this.returnCode = new Integer(racf_rc);
                        this.reasonCode = 0;
                        this.reason = this.utilities.getErrorMessage("start", iCommand_rc.toString());
                        this.logMessage('E', "sendSystemMessage:  " + this.reason + " RACF RC: " + racf_rc);
                        this.doCmdResp_rc = 1006;
                    }
                } else {
                    this.returnCode = iCommand_rc;
                    this.reasonCode = iCommand_rsn;
                    this.reason = this.utilities.getErrorMessage("start", iCommand_rsn.toString());
                    this.logMessage('E', "sendSystemMessage: start rc: " + iCommand_rc + " rsn: " + iCommand_rsn + " " + this.reason);
                    this.doCmdResp_rc = 1006;
                }
            } else {
                this.logMessage('D', "sendSystemMessage:  Received: " + numBytesRead);
            }
        }
        return this.doCmdResp_rc;
    }

    public byte[] doCmdResp(String command, String apasource) {
        this.doCmdResp_rc = 0;
        this.returnCode = 0;
        int writeRC = 0;
        int numBytesWritten = 0;
        this.logMessage('D', "In " + apasource + " Mode");
        String[] commandArray = command.split(" ");
        String fname = commandArray[0];
        String fullFName = this.queueFile(fname);
        if (apasource.equalsIgnoreCase("remote")) {
            try {
                byte[] buf = this.buildMessage(command, command.length());
                numBytesWritten = buf.length;
                writeRC = CorePlugin.getDefault().connectionextension.zosWrite(buf, this.monitor);
                this.logMessage('D', "doCmdResp: Bytes Sent " + numBytesWritten);
            }
            catch (Exception exception) {
                this.doCmdResp_rc = 1000;
                this.returnCode = 1000;
                this.doCmdResp_errmsg = this.utilities.getErrorMessage(this.doCmdResp_rc, "core_msg_");
                this.logMessage('E', "doCmdResp: Connection may have been closed, return code: " + this.doCmdResp_rc);
            }
            if (writeRC < 0) {
                this.doCmdResp_rc = 1000;
                this.returnCode = 1000;
                this.doCmdResp_errmsg = this.utilities.getErrorMessage(this.doCmdResp_rc, "core_msg_");
                this.logMessage('E', "doCmdResp: Connection may have been closed, return code: " + this.doCmdResp_rc);
                try {
                    throw new IOException();
                }
                catch (IOException iOException) {}
            }
            if (writeRC >= 0) {
                int numBytesRead = 0;
                try {
                    numBytesRead = CorePlugin.getDefault().connectionextension.zosRead(fname, this.monitor);
                    this.logMessage('D', "doCmdResp: Bytes Received " + numBytesRead);
                    if (numBytesRead <= 0) {
                        throw new IOException();
                    }
                }
                catch (Exception exception) {
                    this.doCmdResp_rc = 1000;
                    this.returnCode = 1000;
                    this.doCmdResp_errmsg = this.utilities.getErrorMessage(this.doCmdResp_rc, "core_msg_");
                    this.logMessage('E', "doCmdResp: Connection may have been closed, return code: " + this.doCmdResp_rc);
                }
            }
        }
        byte[] responseArray = null;
        try {
            File responseFile = new File(fullFName);
            responseArray = new byte[(int)responseFile.length()];
            DataInputStream responseStream = new DataInputStream(new FileInputStream(responseFile));
            responseStream.readFully(responseArray);
            responseStream.close();
        }
        catch (Exception exception) {}
        return responseArray;
    }

    public void runGetObsReports(String command) {
        this.doCmdResp_rc = 0;
        String tempCookie = "";
        int writeRC = 0;
        byte[] buf = this.buildMessage(command, command.length());
        int cfr_ignored_0 = buf.length;
        writeRC = CorePlugin.getDefault().connectionextension.zosWrite(buf, this.monitor);
        if (writeRC < 0) {
            this.doCmdResp_rc = 1001;
            this.returnCode = 1001;
            this.doCmdResp_errmsg = this.utilities.getErrorMessage(this.doCmdResp_rc, "core_msg_");
            this.logMessage('E', "runGetObsReports: Write Error.  Connection may have been closed, return code: " + this.doCmdResp_rc);
            try {
                throw new IOException();
            }
            catch (IOException iOException) {
                return;
            }
        }
        try {
            int numBytesRead = 0;
            numBytesRead = CorePlugin.getDefault().connectionextension.zosRead("GETOBSREPORTS", this.monitor);
            this.logMessage('D', "runGetObsReports: Bytes Received " + numBytesRead);
            if (numBytesRead < 0) {
                throw new Exception("runGetObsReport read error.");
            }
            int byteCounter = numBytesRead;
            short messageType = headerBuffer.getShort(tcpipHeaderOffset + 10);
            String zosReply = null;
            while (messageType == 8) {
                String[] statusSplit;
                zosReply = this.parseNullTerminatedString();
                if (zosReply.substring(0, 6).equals("STATUS") && (statusSplit = zosReply.split(",")).length > 1) {
                    tempCookie = statusSplit[1];
                }
                String subCommand = null;
                subCommand = "OK";
                byte[] buff = this.buildMessage(subCommand, subCommand.length());
                int cfr_ignored_1 = buff.length;
                writeRC = CorePlugin.getDefault().connectionextension.zosWrite(buff, this.monitor);
                if (writeRC < 0) {
                    throw new IOException("runGetObsReport write error.");
                }
                headerBuffer.clear();
                try {
                    numBytesRead = CorePlugin.getDefault().connectionextension.zosRead("GETOBSREPORTS", this.monitor);
                    this.logMessage('D', "runGetObsReports: Wait Loop1 Bytes Received " + numBytesRead);
                    if (numBytesRead <= 0) {
                        if (this.doCmdResp_rc == -99) break;
                        throw new IOException("runGetObsReport read error.");
                    }
                    messageType = headerBuffer.getShort(tcpipHeaderOffset + 10);
                }
                catch (Exception e) {
                    System.out.println("Connection Error : " + e.toString());
                    this.doCmdResp_rc = 1001;
                    break;
                }
            }
            this.logMessage('D', "runGetObsReports: byteCounter: " + byteCounter);
            this.logMessage('D', "runGetObsReports: Done " + headerBuffer.position());
        }
        catch (Exception e) {
            this.doCmdResp_rc = 1001;
            this.doCmdResp_errmsg = this.utilities.getErrorMessage(this.doCmdResp_rc, "core_msg_");
            String logstr = "runGetObsReports: Return Code " + this.doCmdResp_rc + ", Catch error. " + e;
            CorePlugin.getDefault().log.error(logstr);
        }
        this.reportDescriptor = 0;
        try {
            this.reportDescriptor = headerBuffer.getShort(tcpipHeaderOffset + 10);
            if (this.reportDescriptor == 13) {
                this.parsePVMLLog();
            }
        }
        catch (Exception ex) {
            String logstr = "runGetObsReports: Exception extracting error descriptor. " + ex;
            System.out.println("ZosSession - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        this.rptCookie = tempCookie;
    }

    private String parseNullTerminatedString() {
        int offset = tcpipHeaderOffset + bnetHeaderOffset;
        String messageValue = null;
        messageValue = this.byteBufToString(offset, 26);
        this.logMessage('D', "parseNullTerminatedString: messageValue: " + messageValue);
        String[] statusSplit = messageValue.split(",");
        String bytesmsg = statusSplit[0].substring(7, statusSplit[0].length()).trim();
        this.logMessage('D', "parseNullTerminatedString: bytesmsg: " + bytesmsg);
        float fbytesmsg = new Float(bytesmsg).floatValue();
        if (this.monitor != null) {
            this.monitor.subTask(String.valueOf(Messages.getString("ZosSession.Job.SubTask.Step1of3")) + this.decfmt.format(fbytesmsg) + Messages.getString("ZosSession.Job.SubTask.BytesFormatted"));
        }
        return messageValue;
    }

    public void endSession() {
        this.enableEmail = false;
        this.CommonServerName = "";
        this.CommonServerVersion = "";
        this.CommonServerRelease = "";
        this.CommonServerPort = "";
        this.LSTC_VERSION = "";
        this.LSTC_APAR = "";
        this.LSTC_PAPAR = "";
        this.LSTC_MAPAR = "";
        this.LSTC_4APAR = "";
        this.LSTC_JOBN = "";
        this.LSTC_JOBI = "";
        try {
            if (this.sslOn) {
                CorePlugin.getDefault().connectionextension.closeSslSocket();
            } else if (this.socket != null) {
                this.socket.close();
                this.logMessage('D', "endSession: socket closed");
            }
        }
        catch (Exception e) {
            this.logMessage('E', "endSession: Exception error. " + e);
        }
    }

    public byte[] buildMessage(String sPayload, int iPayloadLen) {
        int iHdrBuffSize = sPayload.length() + 1024;
        byte[] bHdrBuf = new byte[iHdrBuffSize];
        ByteBuffer bbHdrBuf = ByteBuffer.wrap(bHdrBuf);
        String sHLQ = "CAZ ";
        byte[] bHLQ = sHLQ.getBytes();
        boolean bExecstccmd = false;
        boolean bValidate = false;
        if (sPayload.length() > 13) {
            if (sPayload.startsWith(CorePlugin.getDefault().constants.ZOSMESSAGE_EXECSTCCMD)) {
                bExecstccmd = true;
            } else if (sPayload.substring(0, 8).equals("VALIDATE") || sPayload.startsWith(CorePlugin.getDefault().constants.ZOSMESSAGE_UPDSPMLIST) || sPayload.startsWith(CorePlugin.getDefault().constants.ZOSMESSAGE_IMPORTOBS)) {
                bValidate = true;
            } else if (sPayload.startsWith(CorePlugin.getDefault().constants.ZOSMESSAGE_GETOBSREPORTS)) {
                iPayloadLen += 2;
                bValidate = true;
            }
        }
        bbHdrBuf.clear();
        bbHdrBuf.position(14);
        bbHdrBuf.put(bHLQ, 0, sHLQ.length());
        bbHdrBuf.putShort(18, (short)1);
        bbHdrBuf.put(20, (byte)0);
        bbHdrBuf.put(21, (byte)0);
        bbHdrBuf.put(22, (byte)2);
        bbHdrBuf.put(23, (byte)1);
        bbHdrBuf.putShort(24, (short)2);
        bbHdrBuf.put(26, (byte)0);
        bbHdrBuf.putInt(27, iPayloadLen);
        bbHdrBuf.put(31, (byte)0);
        bbHdrBuf.put(32, (byte)19);
        bbHdrBuf.position(tcpipHeaderOffset + bnetHeaderOffset);
        if (!bExecstccmd) {
            byte[] bCmd = sPayload.getBytes();
            bbHdrBuf.put(bCmd, 0, sPayload.length());
            if (bValidate) {
                int pipePos1 = sPayload.indexOf("|");
                int pipePos2 = sPayload.indexOf("|", pipePos1 + 1);
                bbHdrBuf.position(tcpipHeaderOffset + bnetHeaderOffset + pipePos1);
                bbHdrBuf.put((byte)-3);
                bbHdrBuf.position(tcpipHeaderOffset + bnetHeaderOffset + pipePos2);
                bbHdrBuf.put((byte)-3);
            }
        } else {
            String sPayload1 = sPayload.trim();
            int posBlank = sPayload1.indexOf(" ");
            String sCmd1 = sPayload1.substring(0, posBlank + 1);
            String sCmd2 = sPayload1.substring(posBlank + 1);
            String newPayload = String.valueOf(sCmd1) + sCmd2;
            int posA = newPayload.indexOf(" ") + 1;
            int pos1 = newPayload.indexOf(" ", posA + 1);
            int pos2 = newPayload.length();
            System.out.println(String.valueOf(pos1) + " ... " + pos2 + " ... " + newPayload);
            byte[] bCmd = newPayload.getBytes();
            bbHdrBuf.put(bCmd, 0, newPayload.length());
            bbHdrBuf.position(tcpipHeaderOffset + bnetHeaderOffset + pos1);
            bbHdrBuf.put((byte)-3);
            bbHdrBuf.position(tcpipHeaderOffset + bnetHeaderOffset + pos2);
            bbHdrBuf.put((byte)-3);
        }
        Integer messageLength = bbHdrBuf.position() + 1;
        String sMessageLength = String.format("%010d", messageLength);
        String sVicHeader = String.valueOf(sMessageLength) + "B" + "000";
        byte[] bVicHeader = sVicHeader.getBytes();
        bbHdrBuf.position(0);
        bbHdrBuf.put(bVicHeader, 0, sVicHeader.length());
        int retBufSize = messageLength;
        byte[] bRetBuf = new byte[retBufSize];
        int i = 0;
        while (i < retBufSize) {
            bRetBuf[i] = bHdrBuf[i];
            ++i;
        }
        return bRetBuf;
    }

    public String byteBufToString(int offset, int length) {
        byte[] ba = new byte[length];
        int j = 0;
        while (j < length) {
            ba[j] = headerBuffer.get(offset + j);
            if (ba[j] == -6) {
                ba[j] = 124;
            }
            ++j;
        }
        String sValue = new String(ba).trim();
        return sValue;
    }

    private void parsePVMLLog() {
        String zosPrint_log = null;
        String logstr = "Start of Parse zosPrint LOG";
        System.out.println(logstr);
        CorePlugin.getDefault().log.error(logstr);
        int offset = tcpipHeaderOffset + bnetHeaderOffset;
        int payloadLength = headerBuffer.getInt(tcpipHeaderOffset + 13);
        byte[] ba = new byte[payloadLength];
        String errorCodePage = "CP1047";
        int j = 0;
        while (j < payloadLength) {
            ba[j] = headerBuffer.get(offset + j);
            ++j;
        }
        try {
            zosPrint_log = new String(ba, errorCodePage);
            String hlqRegex = "CAZ\\d\\d\\d\\d";
            Pattern hlqPattern = Pattern.compile(hlqRegex);
            Matcher matcher = hlqPattern.matcher(zosPrint_log);
            int lastMessageLocation = 0;
            while (matcher.find()) {
                lastMessageLocation = matcher.start();
            }
            if (lastMessageLocation > 0) {
                int newLinePosition = zosPrint_log.indexOf("\r", lastMessageLocation);
                this.zosErrorMessage = zosPrint_log.substring(lastMessageLocation, newLinePosition);
            } else {
                this.zosErrorMessage = "";
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.out.print(zosPrint_log);
        CorePlugin.getDefault().log.error(zosPrint_log);
        logstr = "End of Parse zosPrint LOG";
        System.out.println(logstr);
        CorePlugin.getDefault().log.error(logstr);
    }

    public void checkResponse() {
        this.returnCode = 0;
        this.reasonCode = 0;
        this.reason = "";
        short sDescriptor = 0;
        try {
            sDescriptor = headerBuffer.getShort(tcpipHeaderOffset + 10);
            if (this.reportDescriptor != 0) {
                sDescriptor = this.reportDescriptor;
                this.reportDescriptor = 0;
            }
        }
        catch (Exception ex) {
            String logstr = "checkResponse: Exception extracting error descriptor. " + ex;
            System.out.println("ZosSession - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        if (this.doCmdResp_rc != 0) {
            this.returnCode = this.doCmdResp_rc;
            if (this.returnCode == -98 || this.returnCode == -99) {
                this.monitor = null;
            } else {
                this.reason = this.returnCode >= 1000 ? this.utilities.getErrorMessage(this.doCmdResp_rc, "core_msg_") : this.utilities.getErrorMessage(this.doCmdResp_rc, "core_rsn_");
            }
            String logstr = "checkResponse: Return Code : " + this.returnCode + " Reason: " + this.reason;
            System.out.println("ZosSession - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        } else if (sDescriptor == 3) {
            this.parseStructuredErrorResponse();
        } else if (sDescriptor == 13) {
            int retCode = 13;
            int rsnCode = 132;
            String messageValue = this.utilities.getErrorMessage(rsnCode, "core_rsn_");
            this.returnCode = retCode;
            this.reasonCode = rsnCode;
            this.reason = this.zosErrorMessage == null ? messageValue : this.zosErrorMessage;
            String logstr = "checkResponse: Return Code : " + retCode + "  Reason Code: " + rsnCode + " Reason: " + messageValue;
            System.out.println("ZosSession - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    public void parseStructuredErrorResponse() {
        int offset = tcpipHeaderOffset + bnetHeaderOffset;
        String messageValue = null;
        headerBuffer.get(offset);
        int retCode = headerBuffer.getInt(offset + 1);
        int rsnCode = headerBuffer.getInt(offset + 5);
        int msgLen = headerBuffer.getShort(offset + 9);
        if (msgLen > 0) {
            int iMsgOffset = new Integer(headerBuffer.get(offset + 11));
            int serMsgoffset = offset + iMsgOffset;
            byte[] ba = new byte[msgLen];
            int j = 0;
            while (j < msgLen) {
                ba[j] = headerBuffer.get(serMsgoffset + j);
                if (ba[j] == 0) {
                    ba[j] = 10;
                }
                ++j;
            }
            String messageText = new String(ba);
            if (messageText.length() <= 8) {
                messageText = "";
            }
            messageValue = this.utilities.getErrorMessage(rsnCode, "core_rsn_");
            this.returnCode = retCode;
            this.reasonCode = rsnCode;
            this.reason = String.valueOf(messageValue) + ".\n\n" + messageText;
            if (this.returnCode != 0 || this.reasonCode != 0) {
                String logstr = "parseStructuredErrorResponse: Return Code : " + retCode + "  Reason Code: " + rsnCode + " Reason: " + messageValue;
                System.out.println("ZosSession - " + logstr);
                CorePlugin.getDefault().log.error(logstr);
            }
        } else {
            messageValue = this.utilities.getErrorMessage(rsnCode, "core_rsn_").trim();
            this.returnCode = retCode;
            this.reasonCode = rsnCode;
            this.reason = messageValue;
            if (this.returnCode != 0 || this.reasonCode != 0) {
                String logstr = "parseStructuredErrorResponse: (2) Return Code : " + retCode + "  Reason Code: " + rsnCode + " Reason: " + messageValue;
                System.out.println("ZosSession - " + logstr);
                CorePlugin.getDefault().log.error(logstr);
            }
        }
    }

    public String parsePositiveAck() {
        int offset = tcpipHeaderOffset + bnetHeaderOffset;
        this.stcIs = null;
        int ackLength = Integer.parseInt(this.byteBufToString(0, 10));
        int ackMsgLength = ackLength - offset;
        this.stcIs = this.byteBufToString(offset, ackMsgLength);
        this.stcIs = this.stcIs.trim();
        String logstr = "parsePositiveAck: Connecting to " + this.stcIs;
        System.out.println("ZosSession - " + logstr);
        CorePlugin.getDefault().log.debug(logstr);
        return this.stcIs;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    public String getReason() {
        return this.reason;
    }

    public String getStc() {
        return this.stcIs;
    }

    public Integer getDoCmdRespRc() {
        return this.doCmdResp_rc;
    }

    public String getDoCmdRespErrmsg() {
        return this.doCmdResp_errmsg;
    }

    public String execCommand(String apaCommand, String commandLine) {
        commandLine = " " + apaCommand + " " + commandLine + " ";
        return commandLine;
    }

    public String queueFile(String fName) {
        String qualifiedFName = "";
        if (fName.equalsIgnoreCase("GETSTCLIST") || fName.equalsIgnoreCase("GETHOSTPROPERTIES") || fName.equalsIgnoreCase("HANDSHAKE") || fName.equalsIgnoreCase("START") || fName.equalsIgnoreCase("PING") || fName.equalsIgnoreCase("READY") || fName.equalsIgnoreCase("SIGNON") || fName.equalsIgnoreCase("SHUTDOWN")) {
            IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
            CorePlugin.getDefault();
            qualifiedFName = String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getProductFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + fName + ".txt";
        } else {
            IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
            CorePlugin.getDefault();
            qualifiedFName = String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getProductFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + fName + ".txt";
        }
        File file = new File(qualifiedFName);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        if (fName.equalsIgnoreCase("SIGNON")) {
            SimpleDateFormat dtfmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.ConnectionLastSignon = file.exists() ? dtfmt.format(file.lastModified()) : dtfmt.format(new Date());
        }
        return qualifiedFName;
    }

    public boolean chkFile(String fName) {
        File file;
        boolean fileExists = false;
        if (fName.length() > 0) {
            fName = String.valueOf(fName) + ".txt";
        }
        if (fName.equalsIgnoreCase("GETSTCLIST") || fName.equalsIgnoreCase("GETHOSTPROPERTIES") || fName.equalsIgnoreCase("HANDSHAKE") || fName.equalsIgnoreCase("START") || fName.equalsIgnoreCase("PING") || fName.equalsIgnoreCase("READY") || fName.equalsIgnoreCase("SIGNON") || fName.equalsIgnoreCase("SHUTDOWN")) {
            IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
            CorePlugin.getDefault();
            file = new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getProductFolder() + File.separator + CorePlugin.getDefault().hostproperties.connectionid + File.separator + fName);
        } else {
            IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
            CorePlugin.getDefault();
            file = new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getProductFolder() + File.separator + CorePlugin.getDefault().hostproperties.connectionid + File.separator + CorePlugin.getDefault().activeStc + File.separator + fName);
        }
        if (file.exists()) {
            fileExists = true;
        }
        file = null;
        return fileExists;
    }

    private void logMessage(char loglevel, String logstr) {
        System.out.println("ZosSession - " + logstr);
        switch (loglevel) {
            case 'E': {
                CorePlugin.getDefault().log.error(logstr);
                break;
            }
            case 'I': {
                CorePlugin.getDefault().log.info(logstr);
                break;
            }
            case 'W': {
                CorePlugin.getDefault().log.warn(logstr);
                break;
            }
            default: {
                CorePlugin.getDefault().log.debug(logstr);
            }
        }
    }

    public static String byteArrayToHexString(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        int i = 0;
        while (i < b.length) {
            int v = b[i] & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
            ++i;
        }
        return sb.toString().toUpperCase();
    }

    public short getDescriptor() {
        short sDescriptor = 0;
        try {
            sDescriptor = headerBuffer.getShort(tcpipHeaderOffset + 10);
            if (this.reportDescriptor != 0) {
                sDescriptor = this.reportDescriptor;
                this.reportDescriptor = 0;
            }
        }
        catch (Exception ex) {
            String logstr = "getDescriptor: Exception extracting error descriptor. " + ex;
            System.out.println("ZosSession - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        return sDescriptor;
    }

    public int buildCommandParm(String parmName, String parmVal) {
        String parmWrapper1 = "=(";
        String parmWrapper2 = ")";
        if (parmName.equals("DESCR") || parmName.equals("NOTES1") || parmName.equals("NOTES2") || parmName.equals("NOTES3")) {
            parmWrapper1 = "=\"";
            parmWrapper2 = "\"";
            parmVal = parmVal.replaceAll("\"", "'");
        }
        if (parmName.equals("DIRS") || parmName.equals("TMSEL")) {
            parmWrapper1 = "=(\"";
            parmWrapper2 = "\")";
        }
        String commandParms = String.valueOf(parmName) + parmWrapper1 + parmVal + parmWrapper2;
        this.commandLine = String.valueOf(this.commandLine) + this.parmDelim + commandParms;
        return 0;
    }

    public int buildCommandParm(String parmName, ArrayList<String> parmVal) {
        String parmWrapper1 = "=(";
        String parmWrapper2 = ")";
        int i = 0;
        while (i < parmVal.size()) {
            String commandParms = String.valueOf(parmName) + parmWrapper1 + parmVal.get(i) + parmWrapper2;
            this.commandLine = String.valueOf(this.commandLine) + this.parmDelim + commandParms;
            ++i;
        }
        return 0;
    }

    public int buildCommandParm(String parmName, int min, int times) {
        String parmWrapper1 = "=(";
        String parmWrapper2 = ",FOR=";
        String parmWrapper3 = ")";
        String commandParms = String.valueOf(parmName) + parmWrapper1 + min + parmWrapper2 + times + parmWrapper3;
        this.commandLine = String.valueOf(this.commandLine) + this.parmDelim + commandParms;
        return 0;
    }

    public int buildCommandParm(String parmName, int number) {
        String parmWrapper1 = "=(";
        String parmWrapper2 = ")";
        String commandParms = String.valueOf(parmName) + parmWrapper1 + number + parmWrapper2;
        this.commandLine = String.valueOf(this.commandLine) + this.parmDelim + commandParms;
        return 0;
    }

    private void formatAparList() {
        if (this.LSTC_PAPAR.length() > 0) {
            this.LSTC_APAR = this.LSTC_PAPAR;
        }
        if (this.LSTC_MAPAR.length() > 0) {
            this.LSTC_APAR = this.LSTC_APAR.length() > 0 ? String.valueOf(this.LSTC_APAR) + "," : this.LSTC_APAR;
            this.LSTC_APAR = String.valueOf(this.LSTC_APAR) + this.LSTC_MAPAR;
        }
        if (this.LSTC_4APAR.length() > 0) {
            this.LSTC_APAR = this.LSTC_APAR.length() > 0 ? String.valueOf(this.LSTC_APAR) + "," : this.LSTC_APAR;
            this.LSTC_APAR = String.valueOf(this.LSTC_APAR) + this.LSTC_4APAR;
        }
    }

    public byte[] hideString(String inputString) {
        String ebcidicCodePage = CorePlugin.getDefault().getPreferenceStore().getString("codePage");
        byte[] buf = null;
        byte[] key = new byte[]{1, 33, 33, 1, 33, 33, 1, 33};
        String keyString = null;
        int keyStringLength = 8;
        try {
            keyString = "(!&*)+-";
            keyStringLength = keyString.length();
            key = null;
            buf = inputString.getBytes(ebcidicCodePage);
            key = keyString.getBytes(ebcidicCodePage);
            int j = 0;
            int i = 0;
            while (i < buf.length) {
                int n = i;
                buf[n] = (byte)(buf[n] ^ key[j]);
                j = j >= keyStringLength - 1 ? 0 : ++j;
                ++i;
            }
        }
        catch (Exception exception) {}
        return buf;
    }
}

