/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.internal;

import com.banknet.core.CorePlugin;
import com.banknet.core.internal.ErrorMessages;
import java.lang.reflect.Field;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class Utilities {
    public static Image createSquareImage(Display display, Color color) {
        Image image = new Image((Device)display, 10, 10);
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        gc.fillRectangle(0, 0, 10, 10);
        gc.dispose();
        return image;
    }

    public Image createTransparentColumnSquareImage(Display display, int imgsize) {
        Color white = display.getSystemColor(1);
        Color black = display.getSystemColor(2);
        PaletteData palette = new PaletteData(new RGB[]{white.getRGB(), black.getRGB()});
        ImageData sourceData = new ImageData(imgsize, imgsize, 1, palette);
        sourceData.transparentPixel = 0;
        Image image = new Image((Device)display, sourceData);
        GC gc = new GC((Drawable)image);
        gc.fillRectangle(0, 0, imgsize, imgsize);
        gc.dispose();
        return image;
    }

    public static Image createTransparentSquareImage(Display display) {
        Color white = display.getSystemColor(1);
        Color black = display.getSystemColor(2);
        PaletteData palette = new PaletteData(new RGB[]{white.getRGB(), black.getRGB()});
        ImageData sourceData = new ImageData(16, 16, 1, palette);
        sourceData.transparentPixel = 0;
        Image image = new Image((Device)display, sourceData);
        GC gc = new GC((Drawable)image);
        gc.fillRectangle(0, 0, 10, 10);
        gc.dispose();
        return image;
    }

    public void mysleep(Integer waitTime) {
        try {
            System.out.println("Waiting " + waitTime.toString());
            Thread.sleep(waitTime.intValue());
        }
        catch (Throwable throwable) {
            System.out.println("Wait time interrupted");
        }
    }

    public String padString(String val, String padval, int vallen) {
        String paddedval = val;
        int i = paddedval.length();
        while (i < vallen) {
            paddedval = String.valueOf(padval) + paddedval;
            ++i;
        }
        return paddedval;
    }

    public String getErrorMessage(int rsnCode, String msgprefix) {
        String sErrorMessage = String.valueOf(msgprefix) + rsnCode;
        String messageValue = null;
        ErrorMessages emsg = new ErrorMessages();
        Class<?> cErrMessage = ((Object)((Object)emsg)).getClass();
        try {
            Field messageName = cErrMessage.getField(sErrorMessage);
            messageValue = (String)messageName.get(cErrMessage);
        }
        catch (Exception e) {
            messageValue = "Undefined Error Message for: " + sErrorMessage;
            String logstr = "getErrorMessage:  Message exception, rsnCode - " + rsnCode + ", msgprefix - " + msgprefix + ". " + e;
            System.out.println("Utilities - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        return messageValue.trim();
    }

    public String getErrorMessage(String source, String rsnCode) {
        String sErrorMessage = null;
        sErrorMessage = "core_" + source + "_" + rsnCode;
        String messageValue = null;
        ErrorMessages emsg = new ErrorMessages();
        Class<?> cErrMessage = ((Object)((Object)emsg)).getClass();
        try {
            Field messageName = cErrMessage.getField(sErrorMessage);
            messageValue = (String)messageName.get(cErrMessage);
        }
        catch (Exception e) {
            messageValue = "Undefined Error Message for: " + sErrorMessage;
            String logstr = "getErrorMessage:  Message exception, source = " + source + ", rsnCode - " + rsnCode + ". " + e;
            System.out.println("Utilities - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        return messageValue;
    }
}

