/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.internal;

import com.banknet.core.CorePlugin;
import com.banknet.core.data.reports.ObservationReports;
import com.banknet.core.internal.Messages;
import com.banknet.core.models.ObservationsModel;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ObservationRequestJob {
    public String apaRequest;
    public String apaParms;
    public String apaRequestTitle;
    public Integer reqnum;
    private String sreqnum = "";
    public String ownedby;
    public String dsname;
    public String exportedDsn = "";
    public String validateSystem;
    int modelsize = 0;
    public ByteBuffer bbRespBuffer;
    public Shell shell;
    public TreeViewer v;

    public ObservationRequestJob(TreeViewer tv) {
        this.v = tv;
        this.shell = this.v.getControl().getShell();
    }

    public ObservationRequestJob(Shell shell) {
        this.shell = shell;
    }

    public void runObservationRequestJob() {
        if (this.reqnum != null) {
            this.sreqnum = " " + Integer.toString(this.reqnum);
        }
        Job job0 = new Job(String.valueOf(this.apaRequestTitle) + this.sreqnum + Messages.getString("ObservationRequestJob.Job.Title.ActionRequest")){

            public IStatus run(IProgressMonitor monitor) {
                monitor.subTask(String.valueOf(ObservationRequestJob.this.apaRequestTitle) + ObservationRequestJob.this.sreqnum + Messages.getString("ObservationRequestJob.Job.SubTask.RequestInProgress"));
                try {
                    String commandLine = CorePlugin.getDefault().session.execCommand(ObservationRequestJob.this.apaRequest, ObservationRequestJob.this.apaParms);
                    String command = String.valueOf(CorePlugin.getDefault().constants.ZOSMESSAGE_EXECSTCCMD) + " " + ObservationRequestJob.this.ownedby + "," + ObservationRequestJob.this.validateSystem + "," + ObservationRequestJob.this.apaRequest + "," + commandLine;
                    String logstr = "runObservationRequestJob:  Running " + command;
                    System.out.println("ObservationRequestJob - " + logstr);
                    CorePlugin.getDefault().log.debug(logstr);
                    CorePlugin.getDefault().session.doCmdResp(command, CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
                    CorePlugin.getDefault().session.checkResponse();
                    if (CorePlugin.getDefault().session.getReturnCode() != 0) {
                        return Status.CANCEL_STATUS;
                    }
                }
                catch (Exception ex) {
                    String logstr = "runObservationRequestJob:  Job exception. " + ex;
                    System.out.println("ObservationRequestJob - " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                }
                if (ObservationRequestJob.this.apaRequest.equalsIgnoreCase("delete")) {
                    monitor.worked(25);
                    monitor.subTask(String.valueOf(ObservationRequestJob.this.apaRequestTitle) + ObservationRequestJob.this.sreqnum + Messages.getString("ObservationRequestJob.Job.SubTask.DeleteChildrenInProgress"));
                    ObservationRequestJob.this.delChildren(ObservationRequestJob.this.reqnum);
                    monitor.worked(25);
                    monitor.subTask(String.valueOf(ObservationRequestJob.this.apaRequestTitle) + ObservationRequestJob.this.sreqnum + Messages.getString("ObservationRequestJob.Job.SubTask.DeleteReportsInProgress"));
                    ObservationRequestJob.this.delReports(ObservationRequestJob.this.reqnum);
                    monitor.worked(25);
                } else {
                    monitor.worked(100);
                }
                monitor.done();
                if (CorePlugin.getDefault().session.getReturnCode() == 0) {
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        job0.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println(String.valueOf(ObservationRequestJob.this.apaRequest) + " request completed successfully");
                } else {
                    System.out.println(String.valueOf(ObservationRequestJob.this.apaRequest) + " request failed");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String reqactionmsg = String.valueOf((this).ObservationRequestJob.this.apaRequestTitle) + Messages.getString("ObservationRequestJob.MessageDialog.errorTitle.Action");
                        String msg = String.valueOf((this).ObservationRequestJob.this.apaRequestTitle) + Messages.getString("ObservationRequestJob.MessageDialog.errorMessage.Action");
                        if ((this).ObservationRequestJob.this.reqnum != null) {
                            msg = String.valueOf(msg) + Messages.getString("ObservationRequestJob.MessageDialog.errorMessage.For") + (this).ObservationRequestJob.this.reqnum;
                        }
                        if (CorePlugin.getDefault().session.getReturnCode() != 0) {
                            ObservationRequestJob.this.showMessage("error", reqactionmsg, String.valueOf(msg) + Messages.getString("ObservationRequestJob.MessageDialog.errorMessage.Failed") + CorePlugin.getDefault().session.getReason());
                            String logstr = "runObservationRequest: job failed, error RC - " + CorePlugin.getDefault().session.getReturnCode();
                            System.out.println("ObservationRequestJob - " + logstr);
                            CorePlugin.getDefault().log.error(logstr);
                        }
                    }
                });
            }
        });
        job0.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job0.schedule();
    }

    private void showMessage(String msgtyp, String title, String message) {
        if (msgtyp.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
        }
    }

    private void delReports(Integer ireqnum) {
        ArrayList<String> selreqnums = new ArrayList<String>();
        selreqnums.add(ireqnum.toString());
        ObservationReports obsrpts = new ObservationReports();
        obsrpts.reqnums = selreqnums;
        obsrpts.runDeleteObsReports();
        obsrpts = null;
        selreqnums = null;
    }

    private void delChildren(int ireqnum) {
        ObservationsModel observation = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(ireqnum));
        this.modelsize = observation.getChildren().size();
        int i = 0;
        while (i < observation.getChildren().size()) {
            ObservationsModel child = observation.getChildren().get(i);
            this.modelsize += child.getChildren().size();
            this.deleteNode(child);
            if (child.getChildren().size() > 0) {
                this.delChildren(child.reqnum);
            }
            ++i;
        }
    }

    private int deleteNode(ObservationsModel node) {
        try {
            this.apaParms = "REQNUM=" + node.reqnum;
            String commandLine = CorePlugin.getDefault().session.execCommand(this.apaRequest, this.apaParms);
            String command = String.valueOf(CorePlugin.getDefault().constants.ZOSMESSAGE_EXECSTCCMD) + " " + this.ownedby + "," + this.validateSystem + "," + this.apaRequest + "," + commandLine;
            String logstr = "deleteNode: Running " + command;
            System.out.println("ObservationRequestJob - " + logstr);
            CorePlugin.getDefault().log.debug(logstr);
            CorePlugin.getDefault().session.doCmdResp(command, CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
            CorePlugin.getDefault().session.parseStructuredErrorResponse();
            this.delReports(node.reqnum);
        }
        catch (Exception exception) {
            String logstr = "deleteNode: job failed, error RC - " + CorePlugin.getDefault().session.getReturnCode();
            System.out.println("ObservationRequestJob - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        return CorePlugin.getDefault().session.getReturnCode();
    }
}

