/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.internal;

public class IPValidator {
    public static void main(String[] args) {
        IPValidator ipv = new IPValidator();
        String IPAddress = "223.255.12.255";
        boolean validIP = ipv.validateIP(IPAddress);
        if (validIP) {
            System.out.println(String.valueOf(IPAddress) + " is a valid IP.");
        } else {
            System.out.println(String.valueOf(IPAddress) + " is a not valid IP.");
        }
    }

    public boolean validateIP(String IPAddress) {
        if (IPAddress.indexOf(46) > 0 && IPAddress.startsWith("::")) {
            String[] tempIP = IPAddress.split(":");
            if (IPAddress.startsWith("::FFFF:")) {
                IPAddress = tempIP[tempIP.length - 1];
            } else if (tempIP.length == 3) {
                IPAddress = tempIP[tempIP.length - 1];
            }
        }
        boolean validIP = IPAddress.indexOf(58) >= 0 ? IPValidator.validateIPV6(IPAddress) : (IPAddress.indexOf(46) > 0 ? IPValidator.validateIPV4(IPAddress) : false);
        return validIP;
    }

    static boolean validateIPV6(String ipAddress) {
        String[] octet;
        int octetLength;
        boolean validIPV6 = false;
        boolean wildCard = false;
        boolean doubleColon = false;
        String regexString = "^([01]?\\d\\d?|([A-Fa-f0-9]{1,4}))";
        if (ipAddress.contains("*")) {
            wildCard = true;
        }
        if (ipAddress.contains("::")) {
            doubleColon = true;
            if (wildCard) {
                validIPV6 = false;
                return validIPV6;
            }
            ipAddress = ipAddress.startsWith("::") ? ipAddress.replace("::", "0:") : ipAddress.replace("::", ":0:");
        }
        if (ipAddress.endsWith(":")) {
            validIPV6 = false;
            return validIPV6;
        }
        if (wildCard) {
            String ipTemp = ipAddress;
            int wildCardCount = ipTemp.replaceAll("[^*]", "").length();
            if (wildCardCount > 1) {
                validIPV6 = false;
                return validIPV6;
            }
            if (!ipAddress.endsWith(":*")) {
                validIPV6 = false;
                return validIPV6;
            }
        }
        if ((octetLength = (octet = ipAddress.split("\\:")).length) > 8) {
            validIPV6 = false;
            return validIPV6;
        }
        if (!wildCard && !doubleColon && octetLength != 8) {
            validIPV6 = false;
            return validIPV6;
        }
        if (wildCard) {
            --octetLength;
        }
        int i = 0;
        while (i < octetLength) {
            if (!octet[i].matches(regexString)) {
                validIPV6 = false;
                break;
            }
            validIPV6 = true;
            ++i;
        }
        return validIPV6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean validateIPV4(String ipAddress) {
        boolean validIPV4 = false;
        boolean wildCard = false;
        String ipTemp = ipAddress;
        if (ipAddress.contains("*")) {
            wildCard = true;
            int wildCardCount = ipTemp.replaceAll("[^*]", "").length();
            if (wildCardCount > 1) {
                return false;
            }
            if (!ipAddress.endsWith(".*")) {
                return false;
            }
        }
        if (ipAddress.endsWith(".")) {
            return false;
        }
        String[] octet = ipAddress.split("\\.");
        int octetLength = octet.length;
        if (octetLength > 4) {
            return false;
        }
        if (!wildCard && octetLength != 4) {
            return false;
        }
        int intOctet = 0;
        if (wildCard) {
            --octetLength;
        }
        int i = 0;
        while (i < octetLength) {
            try {
                intOctet = Integer.parseInt(octet[i]);
            }
            catch (Exception exception) {
                return false;
            }
            if (i == 0) {
                if (intOctet > 223) return false;
                validIPV4 = true;
            } else {
                if (intOctet > 255) return false;
                validIPV4 = true;
            }
            ++i;
        }
        return validIPV4;
    }
}

