/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs.templates;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.data.TemplateList;
import com.banknet.core.dialogs.templates.Messages;
import com.banknet.core.dialogs.templates.TemplatesLabelProvider;
import com.banknet.core.internal.ColumnSorter;
import com.banknet.core.models.TemplateModel;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ZosTemplateListDialog
extends TitleAreaDialog {
    ZosConnect zosconnect = new ZosConnect();
    TemplateModel templatemodel;
    List<TemplateModel> templates;
    List templateId;
    int totalTemplates = 0;
    public TemplateModel seltemplate = null;
    Composite content;
    Shell shell;
    Button commonRadio;
    Button userRadio;
    Text userId;
    Label templateCount;
    Button okButton;
    Button settingsButton;
    private Composite templatesGroup;
    TableViewer templatesViewer;
    Table templatesTable;
    private Action findAction;
    static String SCOPE_COMMON = "C";
    static String SCOPE_USER = "U";
    public String templateScope = SCOPE_COMMON;
    public String scopeUser = "";
    private String fileTypeDefault = "L";
    private String repositoryDefault = "O";
    private String fileType = "";
    private String repository = "";
    private ColumnSorter nameSorter;
    private ColumnSorter ownerSorter;
    private ColumnSorter descriptionSorter;
    private ColumnSorter datetimeSorter;
    public static final int ASC = 1;
    public static final int NONE = 0;
    public static final int DESC = -1;
    String errmsg = "";
    FontRegistry registry = new FontRegistry();
    Font boldfont = this.registry.getBold(Display.getCurrent().getSystemFont().getFontData()[0].getName());
    boolean buttonclicked = false;
    private List<String> templatesList = new ArrayList<String>();
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);

    public ZosTemplateListDialog(Shell parentShell) {
        super(parentShell);
        this.shell = parentShell;
    }

    protected void configureShell(Shell dialogShell) {
        super.configureShell(dialogShell);
        dialogShell.setText(Messages.getString("ZosTemplateListDialog.ShellTitle.SelectZosTemplate"));
        dialogShell.setImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE").createImage());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialogShell, String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".dialogs_ZosTemplateListContext");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        String dialogtitle = Messages.getString("ZosTemplateListDialog.Title.ImportZosTemplate");
        this.setTitle(dialogtitle);
        this.setMessage(Messages.getString("ZosTemplateListDialog.Instructions"), 1);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        this.content = parent;
        ((GridLayout)this.content.getLayout()).numColumns = 2;
        Group g1 = new Group(this.content, 0);
        g1.setText(Messages.getString("ZosTemplateListDialog.GroupLabel.TemplateScope"));
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        g1.setLayoutData((Object)gd);
        g1.setLayout((Layout)new GridLayout(3, false));
        this.commonRadio = new Button((Composite)g1, 16);
        this.commonRadio.setText(Messages.getString("ZosTemplateListDialog.Radio.Common"));
        this.commonRadio.setSelection(true);
        gd = new GridData(0x1000000, 0x1000000, false, false, 3, 1);
        this.commonRadio.setLayoutData((Object)gd);
        this.commonRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZosTemplateListDialog.this.templateScope = SCOPE_COMMON;
            }
        });
        this.templatesGroup = new Group(this.content, 0);
        ((Group)this.templatesGroup).setText(Messages.getString("ZosTemplateListDialog.GroupLabel.TemplateList"));
        this.templatesGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.templatesGroup.setLayout((Layout)new GridLayout(1, false));
        this.templatesTable = new Table(this.templatesGroup, 67584);
        this.templatesTable.setHeaderVisible(true);
        this.templatesTable.setLinesVisible(true);
        this.templatesTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        ((GridData)this.templatesTable.getLayoutData()).heightHint = 100;
        this.templatesViewer = new TableViewer(this.templatesTable);
        TableColumn column = new TableColumn(this.templatesTable, 0);
        column.setText("");
        column = new TableColumn(this.templatesTable, 16384);
        column.setText(Messages.getString("ZosTemplateListDialog.Column.Label.TemplateName"));
        column.setWidth(150);
        this.nameSorter = new ColumnSorter(this.templatesViewer, column){

            @Override
            protected int doCompare(Viewer v, Object e1, Object e2) {
                return ((TemplateModel)e1).templateName.compareToIgnoreCase(((TemplateModel)e2).templateName);
            }
        };
        column = new TableColumn(this.templatesTable, 16384);
        column.setText(Messages.getString("ZosTemplateListDialog.Column.Label.Description"));
        column.setWidth(200);
        this.descriptionSorter = new ColumnSorter(this.templatesViewer, column){

            @Override
            protected int doCompare(Viewer v, Object e1, Object e2) {
                return ((TemplateModel)e1).description.compareToIgnoreCase(((TemplateModel)e2).description);
            }
        };
        column = new TableColumn(this.templatesTable, 16384);
        column.setText(Messages.getString("ZosTemplateListDialog.Column.Label.OwnedBy"));
        column.setWidth(75);
        this.ownerSorter = new ColumnSorter(this.templatesViewer, column){

            @Override
            protected int doCompare(Viewer v, Object e1, Object e2) {
                return ((TemplateModel)e1).ownedby.compareToIgnoreCase(((TemplateModel)e2).ownedby);
            }
        };
        column = new TableColumn(this.templatesTable, 16384);
        column.setText(Messages.getString("ZosTemplateListDialog.Column.Label.Date"));
        column.setWidth(125);
        this.datetimeSorter = new ColumnSorter(this.templatesViewer, column){

            @Override
            protected int doCompare(Viewer v, Object e1, Object e2) {
                String key1 = CorePlugin.getDefault().constants.yyyymmddhhmm.format(((TemplateModel)e1).getReqdate()).toString();
                String key2 = CorePlugin.getDefault().constants.yyyymmddhhmm.format(((TemplateModel)e2).getReqdate()).toString();
                return key1.compareTo(key2);
            }
        };
        this.templatesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = ZosTemplateListDialog.this.templatesTable.getSelection();
                if (items != null) {
                    ZosTemplateListDialog.this.seltemplate = (TemplateModel)items[0].getData();
                }
            }
        });
        this.templatesTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int cfr_ignored_0 = event.detail;
            }
        });
        this.templatesTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] items = ZosTemplateListDialog.this.templatesTable.getSelection();
                if (items != null) {
                    ZosTemplateListDialog.this.seltemplate = (TemplateModel)items[0].getData();
                    ZosTemplateListDialog.this.okPressed();
                }
            }
        });
        int listHeight = this.templatesViewer.getTable().getItemHeight() * 10;
        Rectangle trim = this.templatesViewer.getTable().computeTrim(0, 0, 0, listHeight);
        GridData gd3 = (GridData)this.templatesViewer.getTable().getLayoutData();
        gd3.heightHint = trim.height;
        gd3.grabExcessHorizontalSpace = true;
        gd3.horizontalAlignment = 768;
        this.templatesViewer.getTable().setLayoutData((Object)gd3);
        this.templatesGroup.layout(false);
        this.getTemplatesList();
        this.nameSorter.setSorter(this.nameSorter, 1);
        this.templatesViewer.setUseHashlookup(true);
        this.templatesViewer.setLabelProvider((IBaseLabelProvider)new TemplatesLabelProvider());
        this.templatesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.makeActions();
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite client = new Composite(this.content, 0);
        GridLayout layout = new GridLayout(1, false);
        GridData gd = new GridData(131072, 0x1000000, true, true, 1, 1);
        client.setLayoutData((Object)gd);
        client.setLayout((Layout)layout);
        this.okButton = this.createButton(client, 0, Messages.getString("ZosTemplateListDialog.Button.Text.Ok"), true);
        this.createButton(client, 1, Messages.getString("ZosTemplateListDialog.Button.Text.Cancel"), false);
        this.buttonclicked = false;
    }

    public void okPressed() {
        this.setReturnCode(0);
        this.close();
        super.okPressed();
    }

    public void cancelPressed() {
        this.setReturnCode(1);
        this.close();
        super.cancelPressed();
    }

    private void makeActions() {
        this.findAction = new Action(){

            public void run() {
                ZosTemplateListDialog.this.showMessage("", "Find Action", "Find action clicked!!");
                System.out.println("Find Action!!");
            }
        };
        this.findAction.setText(Messages.getString("ZosTemplateListDialog.Button.Text.Find"));
        this.findAction.setEnabled(true);
        this.findAction.setAccelerator(262214);
        this.findAction.setActionDefinitionId("com.banknet.core.dialogs.templates.find");
        this.findAction.setToolTipText(Messages.getString("ZosTemplateListDialog.Button.Text.Find"));
        this.findAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/search_src.gif"));
        this.content.addKeyListener(new KeyListener(){
            boolean ctrlkey = false;

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    public void getTemplatesList() {
        Job job0 = new Job(Messages.getString("ZosTemplateListDialog.Job.Title.TemplatesList")){

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString("ZosTemplateListDialog.Job.Task.GetTemplatesList"), 100);
                monitor.subTask(Messages.getString("ZosTemplateListDialog.Job.SubTask.GetTemplatesList"));
                ZosTemplateListDialog.this.templatemodel = null;
                try {
                    TemplateList templatelist = new TemplateList();
                    ZosTemplateListDialog.this.templatemodel = templatelist.getTemplateList(ZosTemplateListDialog.this.templateScope, "", monitor);
                    ZosTemplateListDialog.this.templates = templatelist.templates;
                    ZosTemplateListDialog.this.templateId = templatelist.templateId;
                    ZosTemplateListDialog.this.totalTemplates = templatelist.totalTemplates;
                }
                catch (Exception ex) {
                    System.out.println("ZosTemplateListDialog, getTemplatesList exception: " + ex);
                    return Status.CANCEL_STATUS;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job0.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("Get Templates List Job completed successfully");
                } else {
                    System.out.println("Get Templates List Job did not complete successfully");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (CorePlugin.getDefault().session.getReturnCode() == 0) {
                            (this).ZosTemplateListDialog.this.templatesViewer.setInput((Object)(this).ZosTemplateListDialog.this.templates.toArray());
                            ((Group)ZosTemplateListDialog.this.templatesGroup).setText(String.valueOf((this).ZosTemplateListDialog.this.templates.size()) + " templates");
                        } else if (CorePlugin.getDefault().session.getReturnCode() > 1000) {
                            ZosTemplateListDialog.this.showMessage("info", Messages.getString("ZosTemplateListDialog.MessageDialog.infoTitle.RemoteTemplates"), String.valueOf(Messages.getString("ZosTemplateListDialog.MessageDialog.infoMessage.RemoteConnectionLost")) + Messages.getString("ZosTemplateListDialog.MessageDialog.infoMessage.ReConnect"));
                            (this).ZosTemplateListDialog.this.zosconnect.setConnectLocal();
                        } else if (CorePlugin.getDefault().session.getReturnCode() == 4 & CorePlugin.getDefault().session.getReasonCode() == 16) {
                            String logstr = "getTemplatesList:  error RC " + CorePlugin.getDefault().session.getReason();
                            System.out.println("ZosTemplateListDialog - " + logstr);
                            CorePlugin.getDefault().log.error(logstr);
                            ZosTemplateListDialog.this.showMessage("error", Messages.getString("ZosTemplateListDialog.MessageDialog.infoTitle.RemoteTemplates"), Messages.getString("ZosTemplateListDialog.MessageDialog.errorMessage.TemplatesNotSupported"));
                        } else {
                            String logstr = "getTemplatesList:  error RC " + CorePlugin.getDefault().session.getReason();
                            System.out.println("ZosTemplateListDialog - " + logstr);
                            CorePlugin.getDefault().log.error(logstr);
                            ZosTemplateListDialog.this.showMessage("error", Messages.getString("ZosTemplateListDialog.MessageDialog.infoTitle.RemoteTemplates"), String.valueOf(Messages.getString("ZosTemplateListDialog.MessageDialog.errorMessage.TemplatesListFailed")) + CorePlugin.getDefault().session.getReason());
                        }
                    }
                });
            }
        });
        job0.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job0.schedule();
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
        }
    }

    public int getShellStyle() {
        return 134384;
    }

    private void logMessage(char loglevel, String logstr) {
        System.out.println("ZosTemplateListDialog - " + logstr);
        switch (loglevel) {
            case 'E': {
                CorePlugin.getDefault().log.error(logstr);
                break;
            }
            case 'I': {
                CorePlugin.getDefault().log.info(logstr);
                break;
            }
            case 'W': {
                CorePlugin.getDefault().log.warn(logstr);
                break;
            }
            default: {
                CorePlugin.getDefault().log.debug(logstr);
            }
        }
    }
}

