/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs.templates;

import com.banknet.core.CorePlugin;
import com.banknet.core.dialogs.templates.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SaveTemplateDialog
extends TitleAreaDialog {
    Composite content;
    Shell shell;
    String commandLine = "";
    Button localRadio;
    Button remoteRadio;
    Label idLabel;
    Text templateId;
    Text fileName;
    Button getFileButton;
    File localFile;
    String remoteDataset;

    public SaveTemplateDialog(Shell parentShell) {
        super(parentShell);
        this.shell = parentShell;
        this.commandLine = CorePlugin.getDefault().session.commandLine;
        this.commandLine = this.zapParm(this.commandLine, "ASID=");
        this.commandLine = this.zapParm(this.commandLine, "PID=");
        this.commandLine = this.commandLine.trim();
        String[] commandArray = this.commandLine.split("\\s+");
        if (!commandArray[0].toLowerCase().contains("new")) {
            this.commandLine = this.commandLine.toLowerCase().contains("tmsel=") ? "TNEW " + this.commandLine : "NEW " + this.commandLine;
        }
        if (this.commandLine.charAt(this.commandLine.length() - 1) != ';') {
            this.commandLine = String.valueOf(this.commandLine) + ";";
        }
    }

    private String zapParm(String commandstr, String reqstr) {
        String tstline = commandstr;
        int sidx = tstline.indexOf(reqstr);
        if (sidx >= 0) {
            String teststr = tstline.substring(sidx);
            teststr = teststr.substring(0, teststr.indexOf(" ") + 1);
            commandstr = tstline.replace(teststr, "");
        }
        return commandstr;
    }

    protected void configureShell(Shell dialogShell) {
        super.configureShell(dialogShell);
        dialogShell.setText(Messages.getString("SaveTemplateDialog.ShellTitle.SaveTemplate"));
        dialogShell.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/saveas_edit.gif").createImage());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialogShell, String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".dialogs_SaveTemplateContext");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        String dialogtitle = Messages.getString("SaveTemplateDialog.Title.SaveTemplate");
        this.setTitle(dialogtitle);
        this.setMessage(Messages.getString("SaveTemplateDialog.Instructions"), 1);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        this.content = parent;
        ((GridLayout)this.content.getLayout()).numColumns = 2;
        Composite client = new Composite(this.content, 4);
        GridData gdc = new GridData(4, 4, true, true, 2, 1);
        gdc.widthHint = 300;
        gdc.minimumWidth = 0;
        client.setLayoutData((Object)gdc);
        client.setLayout((Layout)new GridLayout(1, false));
        Group g1 = new Group(client, 0);
        g1.setText(Messages.getString("SaveTemplateDialog.GroupLabel.TemplateProfile"));
        GridData gd = new GridData(4, 4, true, false);
        g1.setLayoutData((Object)gd);
        g1.setLayout((Layout)new GridLayout(6, false));
        Label fileNameLabel = new Label((Composite)g1, 0);
        fileNameLabel.setText(Messages.getString("SaveTemplateDialog.Label.FileName"));
        gd = new GridData(1, 0x1000000, false, false);
        fileNameLabel.setLayoutData((Object)gd);
        this.fileName = new Text((Composite)g1, 2048);
        this.fileName.setText(CorePlugin.getDefault().getPreferenceStore().getString("saveTemplatePath"));
        gd = new GridData(4, 4, true, false, 4, 1);
        this.fileName.setLayoutData((Object)gd);
        this.fileName.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
            }
        });
        this.getFileButton = new Button((Composite)g1, 8);
        this.getFileButton.setText(Messages.getString("SaveTemplateDialog.Button.GetLocation"));
        gd = new GridData(0x1000000, 0x1000000, false, false);
        gd.widthHint = 100;
        this.getFileButton.setLayoutData((Object)gd);
        this.getFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveTemplateDialog.this.localFile = SaveTemplateDialog.this.getLocalSaveFile();
                SaveTemplateDialog.this.fileName.setText(SaveTemplateDialog.this.localFile.getPath());
            }
        });
        Group g2 = new Group(client, 0);
        g2.setText(Messages.getString("SaveTemplateDialog.GroupLabel.TemplateContents"));
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 100;
        g2.setLayoutData((Object)gd);
        g2.setLayout((Layout)new GridLayout(1, false));
        Text preview = new Text((Composite)g2, 2882);
        preview.setText(this.commandLine);
        preview.setEditable(false);
        preview.setLayoutData((Object)gd);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite client = new Composite(this.content, 0);
        GridLayout layout = new GridLayout(1, false);
        GridData gd = new GridData(131072, 0x1000000, true, true, 1, 1);
        client.setLayoutData((Object)gd);
        client.setLayout((Layout)layout);
        this.createButton(client, 0, Messages.getString("SaveTemplateDialog.Button.Save"), true);
        this.createButton(client, 1, Messages.getString("SaveTemplateDialog.Button.Cancel"), false);
    }

    public void okPressed() {
        int rc = this.saveLocalTemplate();
        if (rc >= 0) {
            this.setReturnCode(0);
            this.close();
            super.okPressed();
        }
    }

    public void cancelPressed() {
        this.setReturnCode(1);
        this.close();
        super.cancelPressed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int saveLocalTemplate() {
        File sfile;
        int rc;
        block3: {
            rc = 0;
            String fname = this.fileName.getText().trim();
            if (fname.length() <= 0) return -1;
            sfile = new File(fname);
            if (!sfile.isDirectory()) break block3;
            return -1;
        }
        try {
            FileOutputStream outputStream2 = new FileOutputStream(sfile);
            PrintStream sysout = new PrintStream(outputStream2, true);
            sysout.print(this.commandLine);
            outputStream2.close();
            outputStream2 = null;
            sysout = null;
            this.localFile = null;
            CorePlugin.getDefault().getPreferenceStore().setValue("saveTemplatePath", sfile.getParent());
            return rc;
        }
        catch (Exception e) {
            rc = -1;
            String logstr = "saveLocal:  exception " + e;
            System.out.println("SaveTemplateDialog " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            MessageDialog.openError((Shell)this.shell, (String)Messages.getString("SaveTemplateDialog.MessageDiaCorePlugin.getDefault().log.errorTitle.SaveError"), (String)e.getLocalizedMessage());
        }
        return rc;
    }

    private File getLocalSaveFile() {
        boolean runSaveDialog = true;
        String filename = "";
        String getfilepath = CorePlugin.getDefault().getPreferenceStore().getString("saveTemplatePath");
        if (this.fileName.getText().trim().length() > 0) {
            getfilepath = this.fileName.getText().trim();
        }
        File file = null;
        FileDialog dialog = null;
        while (runSaveDialog) {
            dialog = new FileDialog(this.shell, 8192);
            dialog.setFilterPath(getfilepath);
            dialog.setFilterNames(new String[]{"Text Documents (*.txt)", "All Files (*.*)"});
            dialog.setFilterExtensions(new String[]{"*.txt", "*.html", "*.*"});
            dialog.setFileName(filename);
            dialog.setText(Messages.getString("SaveTemplateDialog.Dialog.Text.SaveLocal"));
            filename = dialog.open();
            if (filename != null) {
                file = new File(filename);
                String fpath = file.getParent();
                CorePlugin.getDefault().getPreferenceStore().setValue("saveTemplatePath", fpath.endsWith(File.separator) ? fpath : String.valueOf(fpath) + File.separator);
                runSaveDialog = false;
                continue;
            }
            runSaveDialog = false;
        }
        dialog = null;
        return file;
    }

    private void showMessage(String title, String message) {
        MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
    }

    public int getShellStyle() {
        return 3312;
    }
}

