/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs.templates;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.data.ObservationDetail;
import com.banknet.core.data.ObservationUtilities;
import com.banknet.core.dialogs.templates.Messages;
import com.banknet.core.dialogs.templates.ZosTemplateListDialog;
import com.banknet.core.internal.VersionCompatibilityExtension;
import com.banknet.core.models.TemplateModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class LoadTemplateDialog
extends TitleAreaDialog {
    ZosConnect zosconnect = new ZosConnect();
    public ObservationDetail obsdetail;
    VersionCompatibilityExtension compat = new VersionCompatibilityExtension();
    ObservationUtilities obsutils = new ObservationUtilities();
    Composite content;
    Shell shell;
    Button localRadio;
    Button remoteRadio;
    Label locationLabel;
    Label idLabel;
    Text templateId;
    Text fileName;
    Button getFileButton;
    Text preview;
    File localFile;
    String remoteDataset;
    public String reqAction = "";
    HashMap hmParms = new HashMap();
    TemplateModel remoteTemplate;
    String templateScope = "";
    String userId = "";
    String commandLine = "";
    Image imgTemplate = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE").createImage();

    public LoadTemplateDialog(Shell parentShell) {
        super(parentShell);
        this.shell = parentShell;
    }

    protected void configureShell(Shell dialogShell) {
        super.configureShell(dialogShell);
        dialogShell.setText(Messages.getString("LoadTemplateDialog.ShellTitle.LoadTemplate"));
        dialogShell.setImage(this.imgTemplate);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialogShell, String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".dialogs_LoadTemplateContext");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        String dialogtitle = Messages.getString("LoadTemplateDialog.Title.LoadTemplate");
        this.setTitle(dialogtitle);
        this.setMessage(Messages.getString("LoadTemplateDialog.Instructions"), 1);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        this.content = parent;
        ((GridLayout)this.content.getLayout()).numColumns = 2;
        Composite client = new Composite(this.content, 0);
        GridData gdc = new GridData(4, 4, true, true, 2, 1);
        gdc.widthHint = 200;
        gdc.minimumWidth = 0;
        client.setLayoutData((Object)gdc);
        client.setLayout((Layout)new GridLayout(1, false));
        Group g1 = new Group(client, 0);
        g1.setText(Messages.getString("LoadTemplateDialog.GroupLabel.TemplateProfile"));
        GridData gd = new GridData(4, 4, true, false);
        g1.setLayoutData((Object)gd);
        g1.setLayout((Layout)new GridLayout(3, false));
        this.localRadio = new Button((Composite)g1, 16);
        this.localRadio.setText(Messages.getString("LoadTemplateDialog.Radio.Local"));
        this.localRadio.setSelection(true);
        gd = new GridData(0x1000000, 0x1000000, false, false);
        this.localRadio.setLayoutData((Object)gd);
        this.localRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoadTemplateDialog.this.fileName.setText("");
            }
        });
        this.remoteRadio = new Button((Composite)g1, 16);
        this.remoteRadio.setText(Messages.getString("LoadTemplateDialog.Radio.Remote"));
        gd = new GridData(4, 0x1000000, true, false, 1, 1);
        gd.horizontalIndent = 25;
        if (!this.compat.chkZosTemplates()) {
            gd.exclude = true;
        }
        this.remoteRadio.setLayoutData((Object)gd);
        this.remoteRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoadTemplateDialog.this.fileName.setText("");
            }
        });
        this.idLabel = new Label((Composite)g1, 0);
        this.idLabel.setText("");
        gd = new GridData(1, 0x1000000, false, false);
        this.idLabel.setLayoutData((Object)gd);
        this.fileName = new Text((Composite)g1, 2048);
        this.fileName.setText("");
        if (this.localRadio.getSelection()) {
            this.fileName.setText(CorePlugin.getDefault().getPreferenceStore().getString("saveTemplatePath"));
        }
        gd = new GridData(4, 4, true, false, 2, 1);
        this.fileName.setLayoutData((Object)gd);
        this.fileName.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                LoadTemplateDialog.this.commandLine = "";
                if (LoadTemplateDialog.this.localRadio.getSelection() & LoadTemplateDialog.this.fileName.getText().trim().length() > 0) {
                    LoadTemplateDialog.this.readLocalTemplate();
                }
                LoadTemplateDialog.this.preview.setText(LoadTemplateDialog.this.commandLine);
            }
        });
        this.getFileButton = new Button((Composite)g1, 8);
        this.getFileButton.setText(Messages.getString("LoadTemplateDialog.Button.GetLocation"));
        gd = new GridData(0x1000000, 0x1000000, false, false);
        gd.widthHint = 100;
        this.getFileButton.setLayoutData((Object)gd);
        this.getFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoadTemplateDialog.this.commandLine = "";
                LoadTemplateDialog.this.preview.setText(LoadTemplateDialog.this.commandLine);
                if (LoadTemplateDialog.this.localRadio.getSelection()) {
                    LoadTemplateDialog.this.localFile = LoadTemplateDialog.this.getLocalFile();
                    if (LoadTemplateDialog.this.localFile != null) {
                        LoadTemplateDialog.this.fileName.setText(LoadTemplateDialog.this.localFile.getPath());
                        String errmsg = LoadTemplateDialog.this.readLocalTemplate();
                        if (errmsg.length() <= 0) {
                            LoadTemplateDialog.this.preview.setText(LoadTemplateDialog.this.commandLine);
                        } else {
                            LoadTemplateDialog.this.showMessage("error", Messages.getString("LoadTemplateDialog.MessageDialog.infoTitle.LoadTemplate"), Messages.getString("LoadTemplateDialog.MessageDialog.errorMessage.TemplateLoadFailed"));
                        }
                    }
                } else if (LoadTemplateDialog.this.remoteRadio.getSelection()) {
                    ZosTemplateListDialog dlg = new ZosTemplateListDialog(LoadTemplateDialog.this.shell);
                    int rc = dlg.open();
                    if (rc == 0 && dlg.seltemplate != null) {
                        LoadTemplateDialog.this.remoteTemplate = dlg.seltemplate;
                        LoadTemplateDialog.this.templateScope = dlg.templateScope;
                        LoadTemplateDialog.this.userId = dlg.scopeUser;
                        LoadTemplateDialog.this.runObservationDetail();
                    } else {
                        LoadTemplateDialog.this.commandLine = "";
                        LoadTemplateDialog.this.preview.setText(LoadTemplateDialog.this.commandLine);
                        LoadTemplateDialog.this.fileName.setText("");
                    }
                    Object var2_3 = null;
                }
            }
        });
        Group g2 = new Group(client, 0);
        g2.setText(Messages.getString("LoadTemplateDialog.GroupLabel.TemplateContents"));
        gd = new GridData(4, 4, true, true, 3, 1);
        gd.heightHint = 100;
        g2.setLayoutData((Object)gd);
        g2.setLayout((Layout)new GridLayout(1, false));
        this.preview = new Text((Composite)g2, 2882);
        this.preview.setText("");
        this.preview.setEditable(true);
        this.preview.setLayoutData((Object)gd);
        this.preview.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String updCommandLine = LoadTemplateDialog.this.preview.getText().trim();
                if (updCommandLine.length() > 0 && LoadTemplateDialog.this.commandLine != updCommandLine) {
                    LoadTemplateDialog.this.commandLine = updCommandLine;
                }
            }
        });
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite client = new Composite(this.content, 0);
        GridLayout layout = new GridLayout(1, false);
        GridData gd = new GridData(131072, 0x1000000, true, true, 1, 1);
        client.setLayoutData((Object)gd);
        client.setLayout((Layout)layout);
        this.createButton(client, 0, Messages.getString("LoadTemplateDialog.Button.Load"), false);
        this.createButton(client, 1, Messages.getString("LoadTemplateDialog.Button.Cancel"), false);
    }

    public void okPressed() {
        int rc = 0;
        if (this.fileName.getText().trim().length() <= 0 & this.preview.getText().length() <= 0) {
            rc = -1;
        } else if (this.localRadio.getSelection()) {
            String errmsg = "";
            if (this.commandLine.length() <= 0) {
                errmsg = this.readLocalTemplate();
            }
            if (errmsg.length() <= 0) {
                rc = this.loadLocalTemplate();
            } else {
                this.showMessage("error", Messages.getString("LoadTemplateDialog.MessageDialog.infoTitle.LoadTemplate"), Messages.getString("LoadTemplateDialog.MessageDialog.errorMessage.TemplateLoadFailed"));
                rc = -1;
            }
        }
        if (rc == 0) {
            this.dispose();
            this.setReturnCode(0);
            this.close();
            super.okPressed();
        }
    }

    public void cancelPressed() {
        this.dispose();
        this.setReturnCode(1);
        this.close();
        super.cancelPressed();
    }

    private File getLocalFile() {
        String getfilename = "";
        String getfilepath = CorePlugin.getDefault().getPreferenceStore().getString("saveTemplatePath");
        if (this.fileName.getText().trim().length() > 0) {
            getfilepath = this.fileName.getText().trim();
        }
        File file = null;
        FileDialog dialog = null;
        dialog = new FileDialog(this.shell, 4096);
        dialog.setFilterNames(new String[]{"Text Documents (*.txt)", "All Files (*.*)"});
        dialog.setFilterExtensions(new String[]{"*.txt", "*.html", "*.*"});
        dialog.setFilterPath(getfilepath);
        dialog.setFileName(getfilename);
        dialog.setText(Messages.getString("LoadTemplateDialog.Dialog.Text.LoadLocal"));
        getfilename = dialog.open();
        if (getfilename != null) {
            file = new File(getfilename);
            String fpath = file.getParent();
            CorePlugin.getDefault().getPreferenceStore().setValue("saveTemplatePath", fpath.endsWith(File.separator) ? fpath : String.valueOf(fpath) + File.separator);
        }
        dialog = null;
        return file;
    }

    private String readLocalTemplate() {
        File templatefile = null;
        URL templateurl = null;
        this.commandLine = "";
        try {
            templatefile = new File(this.fileName.getText().trim());
            if (templatefile != null && templatefile.exists() && !templatefile.isDirectory()) {
                templateurl = templatefile.toURI().toURL();
            }
        }
        catch (Exception exception) {}
        try {
            if (templateurl == null) {
                String strurl = this.fileName.getText().trim().replace(" ", "%20");
                templateurl = new URL(strurl);
            }
        }
        catch (MalformedURLException e) {
            if (this.preview.getText().length() > 0) {
                this.commandLine = this.preview.getText();
                return "";
            }
            String logstr = "readLocalTemplate: File Error,  Exception " + e;
            System.out.println("LoadTemplateDialog - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            return logstr;
        }
        catch (Exception e) {
            String logstr = "readLocalTemplate: File Error,  Exception " + e;
            System.out.println("LoadTemplateDialog - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            return logstr;
        }
        try {
            int content;
            FileInputStream inputLine = new FileInputStream(templatefile);
            while ((content = ((InputStream)inputLine).read()) != -1) {
                this.commandLine = String.valueOf(this.commandLine) + (char)content;
            }
            ((InputStream)inputLine).close();
        }
        catch (IOException ioe) {
            String logstr = "readLocalTemplate: File Error,  Exception " + ioe;
            System.out.println("LoadTemplateDialog - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            return logstr;
        }
        catch (Exception e) {
            String logstr = "loadLocalTemplate: File Error,  Exception " + e;
            System.out.println("LoadTemplateDialog - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            return logstr;
        }
        return "";
    }

    private int loadLocalTemplate() {
        int rc = 0;
        try {
            this.hmParms = null;
            this.hmParms = new HashMap();
            this.hmParms = ObservationUtilities.mapCommandParms(this.commandLine);
        }
        catch (Exception e) {
            String logstr = "loadLocalTemplate: Template Parameter Mapping Error, Exception " + e;
            System.out.println("LoadTemplateDialog - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            this.showMessage("error", Messages.getString("LoadTemplateDialog.MessageDialog.infoTitle.LoadTemplate"), Messages.getString("LoadTemplateDialog.MessageDialog.errorMessage.TemplateMapError"));
            return -1;
        }
        try {
            this.getTemplateParms();
        }
        catch (Exception e) {
            String logstr = "loadLocalTemplate: Mapping Error, Exception " + e;
            System.out.println("LoadTemplateDialog - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            this.showMessage("error", Messages.getString("LoadTemplateDialog.MessageDialog.infoTitle.LoadTemplate"), Messages.getString("LoadTemplateDialog.MessageDialog.errorMessage.TemplateExtractFailed"));
            return -1;
        }
        return rc;
    }

    private void getTemplateParms() throws Exception {
        this.obsdetail = null;
        this.obsdetail = new ObservationDetail();
        this.getJobParms();
        this.getDb2MassParms();
        this.getImsMassParms();
        this.getGeneralParms();
        this.getOptionsParms();
        this.getExtractorsParms();
        this.getStepsParms();
        this.getCriteriaParms();
        this.getScheduleParms();
    }

    private void getJobParms() throws Exception {
        if (this.hmParms.containsKey("JOBNAME")) {
            this.obsdetail.pme_jobname = (String)((ArrayList)this.hmParms.get("JOBNAME")).get(0);
        }
        System.out.println("getJobParms: Job Name/Pattern: " + this.obsdetail.pme_jobname);
        if (this.hmParms.containsKey("SYSTEMS")) {
            this.obsdetail.pme_systems = (String)((ArrayList)this.hmParms.get("SYSTEMS")).get(0);
        }
        System.out.println("getJobParms: System Name: " + this.obsdetail.pme_systems);
        if (this.hmParms.containsKey("ACTIVE")) {
            String activejob = (String)((ArrayList)this.hmParms.get("ACTIVE")).get(0);
            this.obsdetail.activeJob = activejob.equalsIgnoreCase("Y");
            System.out.println("getJobParms: ACTIVE: " + this.obsdetail.activeJob);
        }
        System.out.println("getJobParms: Successfully Loaded ");
    }

    private void getDb2MassParms() throws Exception {
        if (this.hmParms.containsKey("DB2SP")) {
            String[] db2spparms = ((String)((ArrayList)this.hmParms.get("DB2SP")).get(0)).split(",");
            this.obsdetail.pme_sspr_type = db2spparms[0].trim();
            this.obsdetail.pme_sspr_subsys = db2spparms[1].trim();
            this.obsdetail.pme_sspr_schema = db2spparms[2].trim();
            this.obsdetail.pme_sspr_name = db2spparms[3].trim();
            if (db2spparms.length > 4) {
                this.obsdetail.pme_ssrp_isGroupName = true;
                System.out.println("DB2 Group Name " + this.obsdetail.pme_ssrp_isGroupName);
            }
            System.out.println("getDb2MassParms: DB2MASS DB2SP PARMS (type, group subsys, subsystem subsys, schema, name) " + db2spparms);
        }
        System.out.println("getDb2MassParms: Successfully Loaded ");
    }

    private void getImsMassParms() throws Exception {
        if (this.hmParms.containsKey("IMSID")) {
            this.obsdetail.pme_ims_subsystem = (String)((ArrayList)this.hmParms.get("IMSID")).get(0);
            System.out.println("getImsMassParms: IMSMASS Subsystem Id " + this.obsdetail.pme_ims_subsystem);
        }
        if (this.hmParms.containsKey("JOBNAMES")) {
            String imsjobs = (String)((ArrayList)this.hmParms.get("JOBNAMES")).get(0);
            this.obsdetail.pme_ims_jobnames = imsjobs = imsjobs.replaceAll("\"", "");
            System.out.println("getImsMassParms: IMSMASS Jobnames " + this.obsdetail.pme_ims_jobnames);
        }
        if (this.hmParms.containsKey("ITRAN")) {
            this.obsdetail.pme_imsmass_txncode = this.obsdetail.pme_ims_txncode = (String)((ArrayList)this.hmParms.get("ITRAN")).get(0);
            System.out.println("getImsMassParms: IMSMASS Transaction " + this.obsdetail.pme_ims_txncode);
        }
        System.out.println("getImsMassParms: Successfully Loaded ");
    }

    private void getGeneralParms() throws Exception {
        if (this.hmParms.containsKey("DESCR")) {
            this.obsdetail.pme_desc = ((String)((ArrayList)this.hmParms.get("DESCR")).get(0)).replace("\"", "");
        }
        System.out.println("getGeneralParms: Description: " + this.obsdetail.pme_desc);
        if (this.hmParms.containsKey("SAMPLES")) {
            try {
                this.obsdetail.pme_samples = Integer.parseInt((String)((ArrayList)this.hmParms.get("SAMPLES")).get(0));
                System.out.println("getGeneralParms: Number of Samples: " + this.obsdetail.pme_samples);
            }
            catch (NumberFormatException ex) {
                System.out.println("getGeneralParms: Number of Samples: ** SKIPPED **  NumberFormatException: " + ex);
            }
        }
        if (this.hmParms.containsKey("EXPDAYS")) {
            try {
                this.obsdetail.pme_expdays = Integer.parseInt((String)((ArrayList)this.hmParms.get("EXPDAYS")).get(0));
                System.out.println("getGeneralParms: Retain file for (days): " + this.obsdetail.pme_expdays);
            }
            catch (NumberFormatException ex) {
                System.out.println("getGeneralParms: Retain file for (days): ** SKIPPED **  NumberFormatException: " + ex);
            }
        }
        if (this.hmParms.containsKey("DURATION")) {
            String durval = (String)((ArrayList)this.hmParms.get("DURATION")).get(0);
            String mins = "";
            String secs = "";
            int imins = 0;
            int isecs = 0;
            try {
                if (durval.indexOf(":") < 0) {
                    this.obsdetail.pme_duration = Integer.parseInt(durval);
                } else {
                    mins = durval.substring(0, durval.indexOf(":"));
                    if (mins.length() <= 0) {
                        mins = "0";
                    }
                    imins = Integer.parseInt(mins) * 60;
                    secs = durval.substring(durval.indexOf(":") + 1, durval.length());
                    if (secs.length() <= 0) {
                        secs = "0";
                    }
                    isecs = Integer.parseInt(secs);
                    this.obsdetail.pme_duration = imins + isecs;
                }
                System.out.println("getGeneralParms: Duration (sec): " + this.obsdetail.pme_duration);
            }
            catch (NumberFormatException ex) {
                System.out.println("getGeneralParms: Duration (sec): ** SKIPPED **  NumberFormatException: " + ex);
            }
        }
        if (this.hmParms.containsKey("DELAYSAMPLING")) {
            try {
                this.obsdetail.pme_delay = Integer.parseInt((String)((ArrayList)this.hmParms.get("DELAYSAMPLING")).get(0));
                System.out.println("getGeneralParms: Delay by (secs): " + this.obsdetail.pme_delay);
            }
            catch (NumberFormatException ex) {
                System.out.println("getGeneralParms: Delay by (secs): ** SKIPPED **  NumberFormatException: " + ex);
            }
        }
        if (this.hmParms.containsKey("USSOBS")) {
            try {
                this.obsdetail.pme_ussmaxobs = Integer.parseInt((String)((ArrayList)this.hmParms.get("USSOBS")).get(0));
                System.out.println("getGeneralParms: USS observations: " + this.obsdetail.pme_ussmaxobs);
            }
            catch (NumberFormatException ex) {
                System.out.println("getGeneralParms: USS observations: ** SKIPPED **  NumberFormatException: " + ex);
            }
        }
        if (this.hmParms.containsKey("RUNTOEOS")) {
            String run2eos = (String)((ArrayList)this.hmParms.get("RUNTOEOS")).get(0);
            boolean bl = this.obsdetail.pme_flags_eos = run2eos.equalsIgnoreCase("Y");
        }
        if (this.hmParms.containsKey("NOTES1") || this.hmParms.containsKey("NOTES2") || this.hmParms.containsKey("NOTES3")) {
            if (this.hmParms.containsKey("NOTES1")) {
                this.obsdetail.pme_notes1 = (String)((ArrayList)this.hmParms.get("NOTES1")).get(0);
            }
            System.out.println("getGeneralParms: Notes1: " + this.obsdetail.pme_notes1);
            if (this.hmParms.containsKey("NOTES2")) {
                this.obsdetail.pme_notes2 = (String)((ArrayList)this.hmParms.get("NOTES2")).get(0);
            }
            System.out.println("getGeneralParms: Notes2: " + this.obsdetail.pme_notes2);
            if (this.hmParms.containsKey("NOTES3")) {
                this.obsdetail.pme_notes3 = (String)((ArrayList)this.hmParms.get("NOTES3")).get(0);
            }
            System.out.println("getGeneralParms: Notes3: " + this.obsdetail.pme_notes3);
        }
        System.out.println("getGeneralParms: Measure to step end: " + this.obsdetail.pme_flags_eos);
        System.out.println("getGeneralParms: Successfully Loaded ");
    }

    private void getOptionsParms() throws Exception {
        if (this.hmParms.containsKey("NOTIFY")) {
            this.obsdetail.pme_notify = (String)((ArrayList)this.hmParms.get("NOTIFY")).get(0);
        }
        System.out.println("getOptionsParms: Notify TSO User: " + this.obsdetail.pme_notify);
        if (this.hmParms.containsKey("DB2IMAX")) {
            try {
                Integer idb2imax = Integer.parseInt((String)((ArrayList)this.hmParms.get("DB2IMAX")).get(0)) / 1000;
                this.obsdetail.pme_DB2IMaxTraceSize = idb2imax.shortValue();
                CorePlugin.getDefault().session.buildCommandParm("DB2IMAX", CorePlugin.getDefault().constants.decfmt2.format(idb2imax));
                System.out.println("getOptionsParms: DB2IMax: " + this.obsdetail.pme_DB2IMaxTraceSize);
            }
            catch (NumberFormatException ex) {
                System.out.println("getOptionsParms: DB2IMax: ** SKIPPED **  NumberFormatException: " + ex);
            }
        }
        if (this.hmParms.containsKey("IMSIMAX")) {
            try {
                Integer iimsimax = Integer.parseInt((String)((ArrayList)this.hmParms.get("IMSIMAX")).get(0)) / 1000;
                this.obsdetail.pme_IMSIMaxTraceSize = iimsimax.shortValue();
                System.out.println("getOptionsParms: IMSIMax: " + this.obsdetail.pme_IMSIMaxTraceSize);
            }
            catch (NumberFormatException ex) {
                System.out.println("getOptionsParms: IMSIMax: ** SKIPPED **  NumberFormatException: " + ex);
            }
        }
        if (this.hmParms.containsKey("MQIMAX")) {
            try {
                Integer imqimax = Integer.parseInt((String)((ArrayList)this.hmParms.get("MQIMAX")).get(0)) / 1000;
                this.obsdetail.pme_MQIMaxTraceSize = imqimax.shortValue();
                System.out.println("getOptionsParms: MQIMax: " + this.obsdetail.pme_MQIMaxTraceSize);
            }
            catch (NumberFormatException ex) {
                System.out.println("getOptionsParms: MQIMax: ** SKIPPED **  NumberFormatException: " + ex);
            }
        }
        if (this.hmParms.containsKey("ARGDATA")) {
            String argdata = (String)((ArrayList)this.hmParms.get("ARGDATA")).get(0);
            argdata = argdata.replaceAll("'", "");
            String[] argdataarr = argdata.split(",");
            this.obsdetail.pme_ARGDSN = argdataarr[0];
            System.out.println("getOptionsParms: ARGDSN: " + this.obsdetail.pme_ARGDSN);
            if (argdataarr.length > 1) {
                this.obsdetail.pme_ARGMem = argdataarr[1];
                System.out.println("getOptionsParms: ARGMem: " + this.obsdetail.pme_ARGMem);
            }
        }
        if (this.hmParms.containsKey("DIRS")) {
            this.obsdetail.pme_flags_dirs = true;
            String dirs = (String)((ArrayList)this.hmParms.get("DIRS")).get(0);
            this.obsdetail.pme_dirs = dirs = dirs.replaceAll("\"", "");
            System.out.println("getOptionsParms: hfs dirs: " + this.obsdetail.pme_dirs);
        }
        if (this.hmParms.containsKey("LIBS")) {
            String libNames = (String)((ArrayList)this.hmParms.get("LIBS")).get(0);
            String[] libsarr = libNames.split(" ");
            String lib = "";
            int i = 0;
            while (i < libsarr.length) {
                lib = libsarr[i].trim();
                lib = lib.replaceAll("'", "");
                this.obsdetail.listLibs.add(lib);
                ++i;
            }
            System.out.println("getOptionsParms: load libs: " + libNames);
        }
        System.out.println("getOptionsParms: Successfully Loaded ");
    }

    private void getExtractorsParms() throws Exception {
        int i;
        String featureLine = "";
        if (this.hmParms.containsKey("FEATURES")) {
            featureLine = (String)((ArrayList)this.hmParms.get("FEATURES")).get(0);
            featureLine = featureLine.replace(" ", "");
            String[] featurearr = featureLine.split(",");
            int i2 = 0;
            while (i2 < featurearr.length) {
                if (featurearr[i2].equalsIgnoreCase(CorePlugin.getDefault().constants.EXTRACTORTYPE_CICS)) {
                    this.obsdetail.cicsExtractor = true;
                } else if (featurearr[i2].equalsIgnoreCase(CorePlugin.getDefault().constants.EXTRACTORTYPE_CICSI)) {
                    this.obsdetail.cicsiExtractor = true;
                } else if (featurearr[i2].equalsIgnoreCase(CorePlugin.getDefault().constants.EXTRACTORTYPE_IMS)) {
                    this.obsdetail.imsExtractor = true;
                } else if (featurearr[i2].equalsIgnoreCase(CorePlugin.getDefault().constants.EXTRACTORTYPE_IMSI)) {
                    this.obsdetail.imsiExtractor = true;
                } else if (featurearr[i2].equalsIgnoreCase(CorePlugin.getDefault().constants.EXTRACTORTYPE_DB2)) {
                    this.obsdetail.db2Extractor = true;
                } else if (featurearr[i2].equalsIgnoreCase(CorePlugin.getDefault().constants.EXTRACTORTYPE_DB2I)) {
                    this.obsdetail.db2iExtractor = true;
                } else if (featurearr[i2].equalsIgnoreCase(CorePlugin.getDefault().constants.EXTRACTORTYPE_DB2V)) {
                    this.obsdetail.db2vExtractor = true;
                } else if (featurearr[i2].equalsIgnoreCase(CorePlugin.getDefault().constants.EXTRACTORTYPE_DB2X)) {
                    this.obsdetail.db2xExtractor = true;
                } else if (featurearr[i2].equalsIgnoreCase(CorePlugin.getDefault().constants.EXTRACTORTYPE_CDB2)) {
                    this.obsdetail.cdb2Extractor = true;
                } else if (featurearr[i2].equalsIgnoreCase(CorePlugin.getDefault().constants.EXTRACTORTYPE_MQSERIES)) {
                    this.obsdetail.mqsExtractor = true;
                } else if (featurearr[i2].equalsIgnoreCase(CorePlugin.getDefault().constants.EXTRACTORTYPE_MQI)) {
                    this.obsdetail.mqiExtractor = true;
                } else if (featurearr[i2].equalsIgnoreCase(CorePlugin.getDefault().constants.EXTRACTORTYPE_JAVA)) {
                    this.obsdetail.javaExtractor = true;
                } else if (featurearr[i2].equalsIgnoreCase(CorePlugin.getDefault().constants.EXTRACTORTYPE_ADABAS)) {
                    this.obsdetail.adabasExtractor = true;
                } else if (featurearr[i2].equalsIgnoreCase(CorePlugin.getDefault().constants.EXTRACTORTYPE_NATURAL)) {
                    this.obsdetail.naturalExtractor = true;
                } else if (featurearr[i2].equalsIgnoreCase(CorePlugin.getDefault().constants.EXTRACTORTYPE_WAS)) {
                    this.obsdetail.wasExtractor = true;
                } else if (featurearr[i2].equalsIgnoreCase(CorePlugin.getDefault().constants.EXTRACTORTYPE_WLP)) {
                    this.obsdetail.wlpExtractor = true;
                } else if (featurearr[i2].equalsIgnoreCase(CorePlugin.getDefault().constants.EXTRACTORTYPE_SRB)) {
                    this.obsdetail.srbExtractor = true;
                } else if (featurearr[i2].equalsIgnoreCase(CorePlugin.getDefault().constants.EXTRACTORTYPE_SYS)) {
                    this.obsdetail.sysExtractor = true;
                }
                ++i2;
            }
        }
        System.out.println("getExtractorsParms: Extractors: " + featureLine);
        if (this.hmParms.containsKey("CTRAN")) {
            String pme_cics_trans;
            this.obsdetail.pme_cics_trans = pme_cics_trans = (String)((ArrayList)this.hmParms.get("CTRAN")).get(0);
            System.out.println("getExtractorsParms: CICS transactions: " + pme_cics_trans);
        }
        if (this.hmParms.containsKey("SYSCTRAN")) {
            String sysctran = (String)((ArrayList)this.hmParms.get("SYSCTRAN")).get(0);
            if (sysctran.equalsIgnoreCase("Y")) {
                this.obsdetail.buildCICSY = true;
                System.out.println("getExtractorsParms: sysctran " + this.obsdetail.buildCICSY);
            } else if (sysctran.equalsIgnoreCase("M")) {
                this.obsdetail.pme_cics_trans = "*";
                System.out.println("getExtractorsParms: sysctran " + this.obsdetail.buildCICSY + ", SYSCTRAN=M");
            } else {
                System.out.println("getExtractorsParms: sysctran " + this.obsdetail.buildCICSY);
            }
        }
        if (this.hmParms.containsKey("CTERM")) {
            String pme_cics_termids;
            this.obsdetail.pme_cics_termids = pme_cics_termids = (String)((ArrayList)this.hmParms.get("CTERM")).get(0);
            System.out.println("getExtractorsParms: CICS terminal ids: " + pme_cics_termids);
        }
        if (this.hmParms.containsKey("NONCTERM")) {
            String noncterm = (String)((ArrayList)this.hmParms.get("NONCTERM")).get(0);
            this.obsdetail.noncterm = false;
            if (noncterm.equalsIgnoreCase("Y")) {
                this.obsdetail.noncterm = true;
            }
            System.out.println("getExtractorsParms: Include CICS non-terminal trans: " + noncterm);
        }
        if (this.hmParms.containsKey("CPGM")) {
            String pme_cics_prog;
            this.obsdetail.pme_cics_progs = pme_cics_prog = (String)((ArrayList)this.hmParms.get("CPGM")).get(0);
            System.out.println("getExtractorsParms: CICS programs: " + pme_cics_prog);
        }
        if (this.hmParms.containsKey("ITRAN")) {
            this.obsdetail.pme_ims_txncode = (String)((ArrayList)this.hmParms.get("ITRAN")).get(0);
            System.out.println("getExtractorsParms: IMS Transaction " + this.obsdetail.pme_ims_txncode);
        }
        if (this.hmParms.containsKey("IPROG")) {
            this.obsdetail.pme_ims_progname = (String)((ArrayList)this.hmParms.get("IPROG")).get(0);
            System.out.println("getExtractorsParms: IMS Program " + this.obsdetail.pme_ims_progname);
        }
        if (this.hmParms.containsKey("IUSER")) {
            this.obsdetail.pme_ims_userid = (String)((ArrayList)this.hmParms.get("IUSER")).get(0);
            System.out.println("getExtractorsParms: IMS User " + this.obsdetail.pme_ims_userid);
        }
        if (this.hmParms.containsKey("DDFFILTERS")) {
            this.obsdetail.ddfsel = true;
            String ddfparms = (String)((ArrayList)this.hmParms.get("DDFFILTERS")).get(0);
            ddfparms = ddfparms.replace("(", "");
            ddfparms = ddfparms.substring(0, ddfparms.length() - 1);
            ddfparms = ddfparms.replace("=,NULL", "=NULL");
            String[] ddfparmsarr = ddfparms.split("[),]+");
            i = 0;
            while (i < ddfparmsarr.length) {
                String ddfval;
                if (ddfparmsarr[i].contains("CORRID=")) {
                    ddfval = this.getDdfParm(ddfparmsarr[i]);
                    if (ddfval.equalsIgnoreCase("NULL")) {
                        this.obsdetail.pme_db2_corrid_isnull = true;
                    } else {
                        this.obsdetail.pme_db2_corrid = ddfval;
                    }
                } else if (ddfparmsarr[i].contains("EUSERID=")) {
                    ddfval = this.getDdfParm(ddfparmsarr[i]);
                    if (ddfval.equalsIgnoreCase("NULL")) {
                        this.obsdetail.pme_db2_enduserid_isnull = true;
                    } else {
                        this.obsdetail.pme_db2_enduserid = ddfval;
                    }
                } else if (ddfparmsarr[i].contains("WKSTNID=")) {
                    ddfval = this.getDdfParm(ddfparmsarr[i]);
                    if (ddfval.equalsIgnoreCase("NULL")) {
                        this.obsdetail.pme_db2_wkstnid_isnull = true;
                    } else {
                        this.obsdetail.pme_db2_wkstnid = ddfval;
                    }
                }
                ++i;
            }
            System.out.println("getExtractorsParms: DDFFILTERS PARMS (corrid, euserid, wkstnid) " + ddfparms);
        }
        if (this.hmParms.containsKey("WASFILTERS")) {
            this.obsdetail.wasFilterSel = true;
            String wasCommand = (String)((ArrayList)this.hmParms.get("WASFILTERS")).get(0);
            wasCommand = wasCommand.replaceAll("'", "");
            String[] wasParms = wasCommand.split(",");
            i = 0;
            while (i < wasParms.length) {
                if (wasParms[i].contains("REQNAME=")) {
                    int valStartPosition = wasParms[i].indexOf("=") + 1;
                    this.obsdetail.pme_was_req = wasParms[i].substring(valStartPosition).trim();
                } else if (wasParms[i].contains("APPNAME=")) {
                    int valStartPosition = wasParms[i].indexOf("=") + 1;
                    this.obsdetail.pme_was_app = wasParms[i].substring(valStartPosition).trim();
                } else if (wasParms[i].contains("ORIGIN=")) {
                    int valStartPosition = wasParms[i].indexOf("=") + 2;
                    String was_origType = wasParms[i].substring(valStartPosition).trim();
                    this.obsdetail.pme_was_origHost = false;
                    this.obsdetail.pme_was_origIpadr = false;
                    this.obsdetail.pme_was_origJob = false;
                    if (was_origType.contentEquals("I")) {
                        this.obsdetail.pme_was_origIpadr = true;
                    } else if (was_origType.contentEquals("J")) {
                        this.obsdetail.pme_was_origJob = true;
                    } else if (was_origType.contentEquals("H")) {
                        this.obsdetail.pme_was_origHost = true;
                    }
                    if (wasParms[i + 1].indexOf("=") < 0) {
                        this.obsdetail.pme_was_orig = wasParms[i + 1].trim().replace(")", "");
                    }
                } else if (wasParms[i].contains("NOIMAGES=")) {
                    int valStartPosition = wasParms[i].indexOf("=") + 1;
                    String noImages = wasParms[i].substring(valStartPosition).trim();
                    this.obsdetail.pme_was_img = false;
                    if (noImages.equalsIgnoreCase("Y")) {
                        this.obsdetail.pme_was_img = true;
                    }
                } else if (wasParms[i].contains("FILEEXT=")) {
                    String fileExtensions;
                    int valStartPosition = wasParms[i].indexOf("=") + 1;
                    this.obsdetail.pme_was_fex = fileExtensions = wasParms[i].substring(valStartPosition).trim().replace("^", " ");
                }
                ++i;
            }
        }
        if (this.hmParms.containsKey("WLPFILTERS")) {
            this.obsdetail.wlpFilterSel = true;
            String wlpCommand = (String)((ArrayList)this.hmParms.get("WLPFILTERS")).get(0);
            wlpCommand = wlpCommand.replaceAll("'", "");
            String[] wlpParms = wlpCommand.split(",");
            i = 0;
            while (i < wlpParms.length) {
                if (wlpParms[i].contains("REQNAME=")) {
                    int valStartPosition = wlpParms[i].indexOf("=") + 1;
                    this.obsdetail.pme_wlp_req = wlpParms[i].substring(valStartPosition).trim();
                } else if (wlpParms[i].contains("ORIGIN=")) {
                    int valStartPosition = wlpParms[i].indexOf("=") + 2;
                    String wlp_origType = wlpParms[i].substring(valStartPosition).trim();
                    this.obsdetail.pme_wlp_origHost = false;
                    this.obsdetail.pme_wlp_origIpadr = false;
                    if (wlp_origType.contentEquals("I")) {
                        this.obsdetail.pme_wlp_origIpadr = true;
                    } else if (wlp_origType.contentEquals("H")) {
                        this.obsdetail.pme_wlp_origHost = true;
                    }
                    if (wlpParms[i + 1].indexOf("=") < 0) {
                        this.obsdetail.pme_wlp_orig = wlpParms[i + 1].trim().replace(")", "");
                    }
                }
                ++i;
            }
        }
        System.out.println("getExtractorsParms: Successfully Loaded ");
    }

    private String getDdfParm(String ddfparm) {
        int comaPosition;
        String ddfReturnVal = null;
        int valStartPosition = ddfparm.indexOf("=") + 1;
        String ddfvals = ddfparm.substring(valStartPosition).trim();
        ddfReturnVal = (ddfvals = ddfvals.replaceAll("[( | )]", "")).contains(",NULL") ? "NULL" : ((comaPosition = ddfvals.indexOf(",")) > 0 ? ddfvals.substring(0, ddfvals.length() - 1) : ddfvals);
        return ddfReturnVal;
    }

    private void getStepsParms() throws Exception {
        String allsteps;
        if (this.hmParms.containsKey("ALLSTEPS") && (allsteps = (String)((ArrayList)this.hmParms.get("ALLSTEPS")).get(0)).equalsIgnoreCase("YES")) {
            this.obsdetail.listSteps.add("*,^,^,^");
            System.out.println("getStepsParms: ALLSTEPS:  Steps Scheduled All Steps");
        }
        if (this.hmParms.containsKey("STEP")) {
            ArrayList stepitemsarr = (ArrayList)this.hmParms.get("STEP");
            int i = 0;
            while (i < stepitemsarr.size()) {
                String[] steparr = ((String)stepitemsarr.get(i)).split(",");
                String stepNum = "^";
                String stepProgName = "^";
                String stepStepName = "^";
                String stepProcName = "^";
                if (steparr.length == 1) {
                    stepNum = steparr[0].trim();
                } else if (steparr.length == 2) {
                    stepProgName = steparr[1].trim();
                } else if (steparr.length == 3) {
                    String[] stepnamearr = steparr[2].split("\\.");
                    stepStepName = stepnamearr[0].trim();
                    stepProcName = "^";
                    if (stepnamearr.length > 1) {
                        stepProcName = stepnamearr[1].trim();
                    }
                }
                this.obsdetail.listSteps.add(String.valueOf(stepNum) + "," + stepProgName + "," + stepStepName + "," + stepProcName);
                ++i;
            }
            System.out.println("getStepsParms: STEPS:  Steps Scheduled " + stepitemsarr.size());
        }
        System.out.println("getStepsParms: Successfully Loaded ");
    }

    private void getScheduleParms() throws Exception {
        if (this.hmParms.containsKey("SCHDDATE")) {
            ArrayList schddatearr = (ArrayList)this.hmParms.get("SCHDDATE");
            int i = 0;
            while (i < schddatearr.size()) {
                try {
                    Date dschdDate = CorePlugin.getDefault().constants.yyyymmddhhmm3.parse((String)schddatearr.get(i));
                    if (this.chkSchdDate(dschdDate)) {
                        this.obsdetail.listSchdDate.add(dschdDate);
                        System.out.println("getScheduleParms: schedule date: " + dschdDate);
                    } else {
                        System.out.println("getScheduleParms: schedule date SKIPPED : " + dschdDate);
                    }
                }
                catch (Exception exception) {
                    System.out.println("Date Parsing Error: " + schddatearr.get(i));
                }
                ++i;
            }
        }
        if (this.hmParms.containsKey("SCHDSPAN")) {
            try {
                this.obsdetail.pme_m_schdspan = Short.parseShort((String)((ArrayList)this.hmParms.get("SCHDSPAN")).get(0));
                System.out.println("getScheduleParms: schedule span " + this.obsdetail.pme_m_schdspan);
            }
            catch (NumberFormatException ex) {
                System.out.println("getScheduleParms: schedule span: ** SKIPPED **  NumberFormatException: " + ex);
            }
        }
        if (this.hmParms.containsKey("RUNAGAIN")) {
            String runagain = "";
            try {
                runagain = (String)((ArrayList)this.hmParms.get("RUNAGAIN")).get(0);
                String[] runagainArray = runagain.split(",");
                Short runagainmins = Short.valueOf(runagainArray[0]);
                this.obsdetail.pme_runagainmins = runagainmins;
                String[] runagainforarr = runagainArray[1].split("=");
                Short runagainfor = Short.valueOf(runagainforarr[1]);
                this.obsdetail.pme_runagainfor = runagainfor;
                System.out.println("getScheduleParms: runagainmins " + this.obsdetail.pme_runagainmins + ", runagainfor " + this.obsdetail.pme_runagainfor);
            }
            catch (Exception exception) {
                System.out.println("Error Processing RUNAGAIN Parm " + runagain);
            }
        }
        if (this.hmParms.containsKey("RETRYAFTER")) {
            String retryafter = "";
            try {
                retryafter = (String)((ArrayList)this.hmParms.get("RETRYAFTER")).get(0);
                String[] retryafterArray = retryafter.split(",");
                Short retryaftermins = Short.valueOf(retryafterArray[0]);
                this.obsdetail.pme_retryafter = retryaftermins;
                String[] retryafterforarr = retryafterArray[1].split("=");
                Short retryafterfor = Short.valueOf(retryafterforarr[1]);
                this.obsdetail.pme_retrytimes = retryafterfor;
                System.out.println("getScheduleParms: retryaftermins " + this.obsdetail.pme_retryafter + ", retryafterfor " + this.obsdetail.pme_retrytimes);
            }
            catch (Exception exception) {
                System.out.println("Error Processing RetryAfter " + retryafter);
            }
        }
        System.out.println("getScheduleParms: Successfully Loaded ");
    }

    private void getCriteriaParms() throws Exception {
        if (this.hmParms.containsKey("TMSEL")) {
            String tmparms = (String)((ArrayList)this.hmParms.get("TMSEL")).get(0);
            tmparms = tmparms.replaceAll("\"", "");
            String[] tmparmsarr = tmparms.split(" ");
            int i = 0;
            while (i < tmparmsarr.length) {
                int valStartPosition;
                if (tmparmsarr[i].contains("CPU=")) {
                    valStartPosition = tmparmsarr[i].indexOf("=") + 1;
                    this.obsdetail.tm_sel_cpu = tmparmsarr[i].substring(valStartPosition).trim();
                    System.out.println("getCriteriaParms: tm_sel_cpu is " + this.obsdetail.tm_sel_cpu);
                } else if (tmparmsarr[i].contains("ELAPSEDTIME=")) {
                    valStartPosition = tmparmsarr[i].indexOf("=") + 1;
                    this.obsdetail.tm_sel_elapsedtime = tmparmsarr[i].substring(valStartPosition).trim();
                    System.out.println("getCriteriaParms: tm_sel_elapsedtime is " + this.obsdetail.tm_sel_elapsedtime);
                } else if (tmparmsarr[i].contains("EXCP=")) {
                    valStartPosition = tmparmsarr[i].indexOf("=") + 1;
                    this.obsdetail.tm_sel_excp = tmparmsarr[i].substring(valStartPosition).trim();
                    System.out.println("getCriteriaParms: tm_sel_excp is " + this.obsdetail.tm_sel_excp);
                }
                ++i;
            }
        }
        System.out.println("getCriteriaParms: Successfully Loaded ");
    }

    private boolean chkSchdDate(Date dschdDate) {
        boolean doextract = true;
        try {
            Calendar currDate = Calendar.getInstance();
            String scurrDate = CorePlugin.getDefault().constants.yyyymmddhhmm3.format(new Date());
            Date dcurrDate = CorePlugin.getDefault().constants.yyyymmddhhmm3.parse(scurrDate);
            currDate.setTime(dcurrDate);
            Calendar schdDate = Calendar.getInstance();
            schdDate.setTime(dschdDate);
            long diffMillis = schdDate.getTimeInMillis() - currDate.getTimeInMillis();
            if (diffMillis <= 0L) {
                doextract = false;
            }
        }
        catch (ParseException ex) {
            System.out.println("LoadTemplateDialog: chkSchdDate: Error Parsing Date " + ex);
        }
        return doextract;
    }

    public void runObservationDetail() {
        Job job0 = new Job(Messages.getString("LoadTemplateDialog.Job.Title.ObservationDetail")){

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString("LoadTemplateDialog.Job.Task.GetObservationDetail"), 100);
                monitor.subTask(Messages.getString("LoadTemplateDialog.Job.SubTask.GetObservationDetail"));
                try {
                    LoadTemplateDialog.this.obsdetail = null;
                    LoadTemplateDialog.this.obsdetail = new ObservationDetail();
                    LoadTemplateDialog.this.obsdetail.getTemplateDetail(LoadTemplateDialog.this.remoteTemplate.templateName, LoadTemplateDialog.this.templateScope, monitor);
                    System.out.println("in runObservationDetail, template is " + LoadTemplateDialog.this.remoteTemplate.templateName);
                }
                catch (Exception ex) {
                    String logstr = "runObservationDetail: job exception. " + ex;
                    System.out.println("LoadTemplateDialog " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(100);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job0.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("LoadTemplateDialog runObservationDetail job completed successfully");
                } else {
                    System.out.println("LoadTemplateDialog runObservationDetail job did not complete successfully");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (CorePlugin.getDefault().session.getReturnCode() == 0) {
                            (this).LoadTemplateDialog.this.fileName.setText((this).LoadTemplateDialog.this.remoteTemplate.templateName);
                            (this).LoadTemplateDialog.this.commandLine = CorePlugin.getDefault().session.commandLine;
                            (this).LoadTemplateDialog.this.preview.setText((this).LoadTemplateDialog.this.commandLine);
                        } else if (CorePlugin.getDefault().session.getReturnCode() > 1000) {
                            LoadTemplateDialog.this.showMessage("info", Messages.getString("RemoteTemplatesDialog.MessageDiaCorePlugin.getDefault().log.infoTitle.RemoteTemplates"), String.valueOf(Messages.getString("RemoteTemplatesDialog.MessageDiaCorePlugin.getDefault().log.infoMessage.RemoteConnectionLost")) + Messages.getString("RemoteTemplatesDialog.MessageDiaCorePlugin.getDefault().log.infoMessage.ReConnect"));
                            (this).LoadTemplateDialog.this.zosconnect.setConnectLocal();
                        } else {
                            String logstr = "getTemplatesList:  error RC " + CorePlugin.getDefault().session.getReason();
                            System.out.println("RemoteTemplatesDialog - " + logstr);
                            CorePlugin.getDefault().log.error(logstr);
                            LoadTemplateDialog.this.showMessage("error", Messages.getString("RemoteTemplatesDialog.MessageDiaCorePlugin.getDefault().log.infoTitle.RemoteTemplates"), String.valueOf(Messages.getString("RemoteTemplatesDialog.MessageDiaCorePlugin.getDefault().log.errorMessage.TemplatesListFailed")) + CorePlugin.getDefault().session.getReason());
                        }
                    }
                });
            }
        });
        job0.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job0.schedule();
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
        }
    }

    public int getShellStyle() {
        return 3312;
    }

    private String replaceParmVals(String parmstr) {
        String tmsel;
        String line = parmstr;
        String fileext = this.extractParmVal(line, "FILEEXT='", "'");
        if (fileext.length() > 0) {
            String rfileext = fileext.replace(" ", "^");
            line = line.replace(fileext, rfileext);
        }
        if ((tmsel = this.extractParmVal(line, "TMSEL=(\"", "\"")).length() > 0) {
            String rtmsel = tmsel.replace(" ", "^");
            line = line.replace(tmsel, rtmsel);
        }
        return line;
    }

    private String extractParmVal(String parmstr, String sstr, String estr) {
        String valstr = "";
        int sidx = parmstr.indexOf(sstr);
        if (sidx >= 0) {
            int eidx = parmstr.indexOf(estr, sidx += sstr.length());
            valstr = parmstr.substring(sidx, eidx);
        }
        return valstr;
    }

    public void dispose() {
        this.imgTemplate.dispose();
    }
}

