/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs.spm;

import com.banknet.core.CorePlugin;
import com.banknet.core.dialogs.spm.Messages;
import com.banknet.core.dialogs.spm.SpmSettings;
import com.banknet.core.internal.Constants;
import com.banknet.core.preferences.PreferencesConstants;
import java.util.regex.Pattern;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SpmSettingsDialog
extends Dialog {
    PreferencesConstants pconstants = new PreferencesConstants();
    Constants constants = new Constants();
    SpmSettings pms;
    Composite content;
    Shell shell;
    Button okButton;
    Button restoreButton;
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);
    String styleDelimiter2 = "[,]";
    Pattern s2 = Pattern.compile(this.styleDelimiter2);
    String errmsg = "";

    public SpmSettingsDialog(Shell parentShell) {
        super(parentShell);
        this.shell = parentShell;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("SpmSettingsDialog.ShellTitle"));
        newShell.setImage(CorePlugin.getDefault().productextension.getDialogShellImage());
    }

    protected Control createDialogArea(Composite parent) {
        this.content = parent;
        ((GridLayout)this.content.getLayout()).numColumns = 1;
        GridData gd2 = new GridData(4, 0x1000000, true, false, 1, 1);
        this.content.setLayoutData((Object)gd2);
        this.pms = new SpmSettings(this.shell);
        this.pms.createContents(this.content);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite client = new Composite(this.content, 0);
        GridLayout layout = new GridLayout(1, false);
        GridData gd = new GridData(131072, 1024, true, true, 3, 1);
        client.setLayoutData((Object)gd);
        client.setLayout((Layout)layout);
        this.restoreButton = new Button(client, 8);
        this.restoreButton.setText(Messages.getString("SpmSettings.Button.Text.RestoreDefaults"));
        gd = new GridData(1, 128, true, false, 1, 1);
        gd.minimumWidth = 100;
        this.restoreButton.setLayoutData((Object)gd);
        this.restoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpmSettingsDialog.this.pms.restoreDefaults();
            }
        });
        this.okButton = this.createButton(client, 0, Messages.getString("SpmSettings.Button.Text.Ok"), true);
        this.createButton(client, 1, Messages.getString("SpmSettings.Button.Text.Cancel"), false);
        this.content.layout(false);
    }

    public void okPressed() {
        if (this.pms.chkComplete()) {
            this.updateSpmSettings();
            this.pms = null;
            this.setReturnCode(0);
            this.close();
        }
    }

    private void updateSpmSettings() {
        String[] spmSettings = this.s1.split(CorePlugin.getDefault().getPreferenceStore().getString("spmSettings"), -1);
        this.s2.split(CorePlugin.getDefault().getPreferenceStore().getString("spmP01Args"), -1);
        String spmSettingsParms = "";
        String spmSettingParm = "";
        int i = 0;
        while (i < spmSettings.length) {
            String[] spmSetting = spmSettings[i].split(",");
            spmSettingParm = String.valueOf(spmSetting[0]) + "," + spmSetting[1] + "," + spmSetting[2] + "," + spmSetting[3] + ",";
            if (i == 0) {
                spmSetting[4] = this.pms.numAdjacentLines.getText().trim();
            } else if (i == 1) {
                spmSetting[4] = this.pms.displayAllStmts.getSelection() ? "/" : " ";
            } else if (i == 2) {
                spmSetting[4] = this.pms.includeAsmObjCode.getSelection() ? "/" : " ";
            } else if (i == 3) {
                spmSetting[4] = this.pms.showStmtCntGraph.getSelection() ? "/" : " ";
            } else if (i == 4) {
                spmSetting[4] = this.pms.showHeadingDetailInfo.getSelection() ? "/" : " ";
            } else if (i == 5) {
                spmSetting[4] = this.pms.showCPseudo.getSelection() ? "/" : " ";
            } else if (i == 6) {
                spmSetting[4] = this.pms.displayValuesPct.getSelection() ? "/" : " ";
            }
            spmSettingsParms = i == 0 ? String.valueOf(spmSettingParm) + spmSetting[4] : String.valueOf(spmSettingsParms) + "|" + spmSettingParm + spmSetting[4];
            ++i;
        }
        CorePlugin.getDefault().getPreferenceStore().setValue("spmSettings", spmSettingsParms);
    }

    public void cancelPressed() {
        this.setReturnCode(1);
        this.close();
    }

    private void hookContextMenu() {
    }

    private void fillContextMenu(IMenuManager manager) {
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
        }
    }

    public int getShellStyle() {
        return 134384;
    }

    private void logMessage(char loglevel, String logstr) {
        System.out.println("SpmSettingsDialog - " + logstr);
        switch (loglevel) {
            case 'E': {
                CorePlugin.getDefault().log.error(logstr);
                break;
            }
            case 'I': {
                CorePlugin.getDefault().log.info(logstr);
                break;
            }
            case 'W': {
                CorePlugin.getDefault().log.warn(logstr);
                break;
            }
            default: {
                CorePlugin.getDefault().log.debug(logstr);
            }
        }
    }
}

