/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs.spm;

import com.banknet.core.CorePlugin;
import com.banknet.core.dialogs.spm.Messages;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SpmSettings {
    Composite spmComp;
    private Label numAdjacentLinesLabel;
    public Text numAdjacentLines;
    public Button displayAllStmts;
    public Button includeAsmObjCode;
    public Button showStmtCntGraph;
    public Button showHeadingDetailInfo;
    public Button showCPseudo;
    public Button displayValuesPct;
    String numAdjacentLinesPref = "";
    boolean displayAllStmtsPref = false;
    boolean includeAsmObjCodePref = false;
    boolean showStmtCntGraphPref = false;
    boolean showHeadingDetailInfoPref = false;
    boolean showCPseudoPref = false;
    boolean displayValuesPctPref = false;
    Integer numAdjacentLinesLen = 0;
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);
    String styleDelimiter2 = "[,]";
    Pattern s2 = Pattern.compile(this.styleDelimiter2);
    String errmsg = "";
    Shell shell;

    public SpmSettings(Shell shell) {
        String[] spmSettings = this.s1.split(CorePlugin.getDefault().getPreferenceStore().getString("spmSettings"), -1);
        this.s2.split(CorePlugin.getDefault().getPreferenceStore().getString("spmP01Args"), -1);
        this.shell = shell;
        int i = 0;
        while (i < spmSettings.length) {
            String[] spmSetting = spmSettings[i].split(",");
            if (i == 0) {
                this.numAdjacentLinesLen = new Integer(spmSetting[3]);
                this.numAdjacentLinesPref = spmSetting[4];
            } else if (i == 1 && spmSetting[4].equalsIgnoreCase("/")) {
                this.displayAllStmtsPref = true;
            } else if (i == 2 && spmSetting[4].equalsIgnoreCase("/")) {
                this.includeAsmObjCodePref = true;
            } else if (i == 3 && spmSetting[4].equalsIgnoreCase("/")) {
                this.showStmtCntGraphPref = true;
            } else if (i == 4 && spmSetting[4].equalsIgnoreCase("/")) {
                this.showHeadingDetailInfoPref = true;
            } else if (i == 5 && spmSetting[4].equalsIgnoreCase("/")) {
                this.showCPseudoPref = true;
            } else if (i == 6 && spmSetting[4].equalsIgnoreCase("/")) {
                this.displayValuesPctPref = true;
            }
            ++i;
        }
    }

    public Control createContents(Composite parent) {
        this.spmComp = new Composite(parent, 0);
        GridData data = new GridData(4, 128, true, true, 1, 1);
        this.spmComp.setLayoutData((Object)data);
        this.spmComp.setLayout((Layout)new GridLayout(3, false));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.spmComp, String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".preferences_SpmContext");
        Label numAdjacentLinesLabel = new Label(this.spmComp, 0);
        numAdjacentLinesLabel.setText(Messages.getString("SpmSettings.Label.NumAdjacentLines"));
        GridData gd = new GridData(1, 128, false, false, 1, 1);
        numAdjacentLinesLabel.setLayoutData((Object)gd);
        this.numAdjacentLines = new Text(this.spmComp, 2048);
        this.numAdjacentLines.setText(this.numAdjacentLinesPref);
        this.numAdjacentLines.setTextLimit(this.numAdjacentLinesLen.intValue());
        gd = new GridData(1, 128, false, false, 1, 1);
        gd.widthHint = 35;
        this.numAdjacentLines.setLayoutData((Object)gd);
        this.numAdjacentLines.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.numAdjacentLines.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SpmSettings.this.chkComplete();
            }
        });
        Label numAdjacentLinesInfo = new Label(this.spmComp, 64);
        numAdjacentLinesInfo.setText(Messages.getString("SpmSettings.Label.NumAdjacentLinesInfo"));
        gd = new GridData(1, 128, false, false, 1, 1);
        gd.horizontalIndent = 10;
        numAdjacentLinesInfo.setLayoutData((Object)gd);
        Label spacer = new Label(this.spmComp, 64);
        spacer.setText("");
        gd = new GridData(1, 0x1000000, false, false, 3, 1);
        gd.minimumHeight = 20;
        spacer.setLayoutData((Object)gd);
        this.displayAllStmts = new Button(this.spmComp, 32);
        this.displayAllStmts.setText(Messages.getString("SpmSettings.Checkbox.DisplayAllStmts"));
        this.displayAllStmts.setSelection(this.displayAllStmtsPref);
        gd = new GridData(1, 128, false, false, 2, 1);
        this.displayAllStmts.setLayoutData((Object)gd);
        Label displayAllStmtsInfo = new Label(this.spmComp, 64);
        displayAllStmtsInfo.setText(Messages.getString("SpmSettings.Label.DisplayAllStmtsInfo"));
        gd = new GridData(1, 128, false, false, 1, 1);
        gd.horizontalIndent = 10;
        displayAllStmtsInfo.setLayoutData((Object)gd);
        this.includeAsmObjCode = new Button(this.spmComp, 32);
        this.includeAsmObjCode.setText(Messages.getString("SpmSettings.Checkbox.IncludeAsmObjCode"));
        this.includeAsmObjCode.setSelection(this.includeAsmObjCodePref);
        gd = new GridData(1, 128, false, false, 2, 1);
        this.includeAsmObjCode.setLayoutData((Object)gd);
        Label includeAsmObjCodeInfo = new Label(this.spmComp, 64);
        includeAsmObjCodeInfo.setText(Messages.getString("SpmSettings.Label.IncludeAsmObjCodeInfo"));
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        gd.horizontalIndent = 10;
        includeAsmObjCodeInfo.setLayoutData((Object)gd);
        this.showStmtCntGraph = new Button(this.spmComp, 32);
        this.showStmtCntGraph.setText(Messages.getString("SpmSettings.Checkbox.ShowStmtCntGraph"));
        this.showStmtCntGraph.setSelection(this.showStmtCntGraphPref);
        gd = new GridData(1, 128, false, false, 3, 1);
        this.showStmtCntGraph.setLayoutData((Object)gd);
        this.showHeadingDetailInfo = new Button(this.spmComp, 32);
        this.showHeadingDetailInfo.setText(Messages.getString("SpmSettings.Checkbox.ShowHeadingDetailInfo"));
        this.showHeadingDetailInfo.setSelection(this.showHeadingDetailInfoPref);
        gd = new GridData(1, 128, false, false, 3, 1);
        this.showHeadingDetailInfo.setLayoutData((Object)gd);
        this.showCPseudo = new Button(this.spmComp, 32);
        this.showCPseudo.setText(Messages.getString("SpmSettings.Checkbox.ShowCPseudo"));
        this.showCPseudo.setSelection(this.showCPseudoPref);
        gd = new GridData(1, 128, false, false, 3, 1);
        this.showCPseudo.setLayoutData((Object)gd);
        this.displayValuesPct = new Button(this.spmComp, 32);
        this.displayValuesPct.setText(Messages.getString("SpmSettings.Checkbox.DisplayValuesPct"));
        this.displayValuesPct.setSelection(this.displayValuesPctPref);
        gd = new GridData(1, 128, false, false, 2, 1);
        this.displayValuesPct.setLayoutData((Object)gd);
        Label displayValuesPctInfo = new Label(this.spmComp, 64);
        displayValuesPctInfo.setText(Messages.getString("SpmSettings.Label.DisplayValuesPctInfo"));
        gd = new GridData(1, 128, false, false, 1, 1);
        gd.horizontalIndent = 10;
        displayValuesPctInfo.setLayoutData((Object)gd);
        return parent;
    }

    public boolean chkComplete() {
        boolean isComplete = true;
        this.errmsg = "";
        if (!this.chkNumAdjacentLines()) {
            isComplete = false;
        }
        if (this.errmsg.length() > 0) {
            this.showMessage("error", Messages.getString("SpmSettingsDialog.ShellTitle"), this.errmsg);
        }
        return isComplete;
    }

    private boolean chkNumAdjacentLines() {
        boolean isValid = true;
        String cpuport = this.numAdjacentLines.getText().trim();
        this.errmsg = this.chkMandatory(cpuport, Messages.getString("SpmSettings.Label.NumAdjacentLines"));
        if (this.errmsg.length() <= 0) {
            this.errmsg = this.chkInteger(cpuport, Messages.getString("SpmSettings.Label.NumAdjacentLines"));
        }
        if (this.errmsg.length() > 0) {
            isValid = false;
        }
        return isValid;
    }

    private String chkMandatory(String val, String varname) {
        if (val.length() <= 0) {
            this.errmsg = String.valueOf(Messages.getString("SpmSettingsDialog.errorMessage.Mandatory")) + varname;
        }
        return this.errmsg;
    }

    private String chkInteger(String val, String varname) {
        Integer ival = 0;
        String errmsg = "";
        try {
            ival = new Integer(val);
        }
        catch (NumberFormatException numberFormatException) {
            errmsg = String.valueOf(varname) + Messages.getString("SpmSettingsDialog.chkInteger.NotNumeric");
            return errmsg;
        }
        if (ival <= 0) {
            errmsg = String.valueOf(varname) + Messages.getString("SpmSettingsDialog.chkInteger.ValueTooSmall");
            return errmsg;
        }
        return errmsg;
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
        }
    }

    public void restoreDefaults() {
        String[] spmSettings = this.s1.split(CorePlugin.getDefault().getPreferenceStore().getDefaultString("spmSettings"), -1);
        this.s2.split(CorePlugin.getDefault().getPreferenceStore().getString("spmP01Args"), -1);
        this.shell = this.shell;
        this.displayAllStmts.setSelection(false);
        this.includeAsmObjCode.setSelection(false);
        this.showStmtCntGraph.setSelection(false);
        this.showHeadingDetailInfo.setSelection(false);
        this.showCPseudo.setSelection(false);
        this.displayValuesPct.setSelection(false);
        int i = 0;
        while (i < spmSettings.length) {
            String[] spmSetting = spmSettings[i].split(",");
            if (i == 0) {
                this.numAdjacentLines.setText(spmSetting[4]);
            } else if (i == 1 && spmSetting[4].equalsIgnoreCase("/")) {
                this.displayAllStmts.setSelection(true);
            } else if (i == 2 && spmSetting[4].equalsIgnoreCase("/")) {
                this.includeAsmObjCode.setSelection(true);
            } else if (i == 3 && spmSetting[4].equalsIgnoreCase("/")) {
                this.showStmtCntGraph.setSelection(true);
            } else if (i == 4 && spmSetting[4].equalsIgnoreCase("/")) {
                this.showHeadingDetailInfo.setSelection(true);
            } else if (i == 5 && spmSetting[4].equalsIgnoreCase("/")) {
                this.showCPseudo.setSelection(true);
            } else if (i == 6 && spmSetting[4].equalsIgnoreCase("/")) {
                this.displayValuesPct.setSelection(true);
            }
            ++i;
        }
        this.spmComp.layout(false);
    }
}

