/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs.spm;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.data.reports.ObservationReports;
import com.banknet.core.dialogs.spm.Messages;
import com.banknet.core.dialogs.spm.SpmRepository;
import com.banknet.core.internal.Constants;
import com.banknet.core.preferences.PreferencesConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class SpmRepositoryDialog
extends Dialog {
    PreferencesConstants pconstants = new PreferencesConstants();
    Constants constants = new Constants();
    SpmRepository spr;
    ZosConnect zosconnect = new ZosConnect();
    Composite content;
    Shell shell;
    Button okButton;
    Button settingsButton;
    TableViewer tableviewer;
    Table table;
    TableViewer dirsViewer;
    Table dirsTable;
    private String fileTypeDefault = "L";
    private String repositoryDefault = "O";
    private String fileType = "";
    private String repository = "";
    public String member = "";
    String errmsg = "";
    boolean buttonclicked = false;
    private List<String> datasetsList = new ArrayList<String>();
    private List<String> dirsList = new ArrayList<String>();
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);

    public SpmRepositoryDialog(Shell parentShell) {
        super(parentShell);
        this.shell = parentShell;
        this.fileType = this.fileTypeDefault;
        this.repository = this.repositoryDefault;
        String spmDatasets = CorePlugin.getDefault().getPreferenceStore().getString("spmDatasets");
        if (spmDatasets.length() > 0) {
            String[] spmDatasetsArr = this.s1.split(spmDatasets, -1);
            int i = 0;
            while (i < spmDatasetsArr.length) {
                this.datasetsList.add(spmDatasetsArr[i]);
                ++i;
            }
        }
        this.datasetsList.add("S,O,USR1.IDILANGX");
        this.datasetsList.add("L,O,USR1.COBOL.LISTING");
        this.datasetsList.add("D,O,USR1.TST.COBOL.DEBUG");
        this.datasetsList.add("A,O,USR1.ADATA");
        this.dirsList.add("SST,7544,01,/u/java/src");
        this.dirsList.add("SST,7544,02,/u/jtest/pathOne");
        this.dirsList.add("SST,7537,01,/u/jtest/pathThree/security/Section/src");
        this.dirsList.add("SST,7537,02,/u/java/src");
        this.dirsList.add("SST,7537,03,/u/jtest/pathFive/development/source");
        this.dirsList.add("SST,7537,04,/u/jtest/pathFour");
        this.dirsList.add("SST,7537,05,/u/jtest/pathTwo/alphaAlpha/bravoBravo/charlieCharli");
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("SpmRepositoryDialog.ShellTitle"));
        newShell.setImage(CorePlugin.getDefault().productextension.getDialogShellImage());
    }

    protected Control createDialogArea(Composite parent) {
        this.content = parent;
        ((GridLayout)this.content.getLayout()).numColumns = 1;
        GridData gd2 = new GridData(4, 0x1000000, true, false, 1, 1);
        this.content.setLayoutData((Object)gd2);
        this.spr = new SpmRepository();
        this.spr.createContents(this.content);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite client = new Composite(this.content, 0);
        GridLayout layout = new GridLayout(2, false);
        GridData gd = new GridData(131072, 0x1000000, true, false, 2, 1);
        client.setLayoutData((Object)gd);
        client.setLayout((Layout)layout);
        this.okButton = this.createButton(client, 0, Messages.getString("SpmRepositoryDialog.Button.Text.Ok"), true);
        this.createButton(client, 1, Messages.getString("SpmRepositoryDialog.Button.Text.Cancel"), false);
        this.buttonclicked = false;
    }

    public void okPressed() {
        if (this.spr.updA03 | this.spr.updA04 | this.spr.updA05) {
            this.runUpdSpmList();
        } else {
            this.setReturnCode(0);
            this.close();
        }
    }

    public void cancelPressed() {
        this.setReturnCode(1);
        this.close();
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
        }
    }

    public int getShellStyle() {
        return 134384;
    }

    private void logMessage(char loglevel, String logstr) {
        System.out.println("SpmRepositoryDialog - " + logstr);
        switch (loglevel) {
            case 'E': {
                CorePlugin.getDefault().log.error(logstr);
                break;
            }
            case 'I': {
                CorePlugin.getDefault().log.info(logstr);
                break;
            }
            case 'W': {
                CorePlugin.getDefault().log.warn(logstr);
                break;
            }
            default: {
                CorePlugin.getDefault().log.debug(logstr);
            }
        }
    }

    public void runUpdSpmList() {
        Job job0 = new Job(Messages.getString("SpmRepository.Job.Title.UpdSpmList")){

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString("SpmRepository.Job.Task.UpdSpmList"), 100);
                if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("local") == 0) {
                    return Status.CANCEL_STATUS;
                }
                monitor.subTask(Messages.getString("SpmRepository.Job.SubTask.Ping"));
                SpmRepositoryDialog.this.zosconnect.pingZos(monitor);
                if (SpmRepositoryDialog.this.zosconnect.getConnectRc() != 0) {
                    return Status.CANCEL_STATUS;
                }
                monitor.subTask(Messages.getString("SpmRepository.Job.SubTask.CloseObsReports"));
                ObservationReports obsrpts = new ObservationReports();
                obsrpts.runCloseObsReports("*", monitor);
                obsrpts = null;
                monitor.subTask(Messages.getString("SpmRepository.Job.SubTask.UpdSpmList"));
                SpmRepositoryDialog.this.spr.updSpmList(monitor);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job0.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("Update SpmRepository List Job completed successfully");
                } else {
                    System.out.println("Update SpmRepository List Job did not complete successfully");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("local") == 0 | (this).SpmRepositoryDialog.this.zosconnect.getConnectRc() != 0) {
                            SpmRepositoryDialog.this.showMessage("info", Messages.getString("SpmRepository.MessageDialog.infoTitle.SPM"), String.valueOf(Messages.getString("SpmRepository.MessageDialog.infoMessage.RemoteConnectionLost")) + Messages.getString("SpmRepository.MessageDialog.infoMessage.ReConnect"));
                            (this).SpmRepositoryDialog.this.zosconnect.setConnectLocal();
                        } else if (CorePlugin.getDefault().session.getReturnCode() == 0) {
                            SpmRepositoryDialog.this.setReturnCode(0);
                            SpmRepositoryDialog.this.close();
                        } else if (CorePlugin.getDefault().session.getReturnCode() > 1000) {
                            SpmRepositoryDialog.this.showMessage("info", Messages.getString("SpmRepository.MessageDialog.infoTitle.SPM"), String.valueOf(Messages.getString("SpmRepository.MessageDialog.infoMessage.RemoteConnectionLost")) + Messages.getString("SpmRepository.MessageDialog.infoMessage.ReConnect"));
                            (this).SpmRepositoryDialog.this.zosconnect.setConnectLocal();
                        } else {
                            String logstr = "runUpdSpmList:  error RC " + CorePlugin.getDefault().session.getReason();
                            System.out.println("SpmRepositoryDialog - " + logstr);
                            CorePlugin.getDefault().log.error(logstr);
                            SpmRepositoryDialog.this.showMessage("error", Messages.getString("SpmRepository.MessageDialog.infoTitle.SPM"), String.valueOf(Messages.getString("SpmRepository.MessageDialog.errorMessage.LibsDirsUpdateFailed")) + CorePlugin.getDefault().session.getReason());
                        }
                    }
                });
            }
        });
        job0.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job0.schedule();
    }
}

