/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs.spm;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.dialogs.spm.ISpmConstantsExtension;
import com.banknet.core.dialogs.spm.Messages;
import com.banknet.core.dialogs.spm.SpmConstants;
import com.banknet.core.internal.Constants;
import com.banknet.core.models.ObservationsModel;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PasteMapFilesDialog
extends Dialog {
    Constants constants = new Constants();
    SpmConstants spmconstants = new SpmConstants();
    ZosConnect zosconnect = new ZosConnect();
    ISpmConstantsExtension spmconstantsext;
    Composite content;
    Shell shell;
    Button okButton;
    Button settingsButton;
    TableViewer libsViewer;
    Table libsTable;
    TableViewer dirsViewer;
    Table dirsTable;
    private Composite dirslibsRadios;
    private Composite mappingComp;
    private Group dirsGroup;
    private Group libsGroup;
    public TableViewer filesViewer;
    public Table filesTable;
    private Button measurementDirsRadio;
    private Button globalDirsRadio;
    private Button a04LibsRadio;
    private Button a05LibsRadio;
    public String addFileType;
    public String addRepository;
    public String addDataset;
    public String addMember;
    public boolean addPersonalList;
    public boolean addGlobalDirs;
    public String addDir;
    public String dirsLibsCommand = "";
    public String dirsLibsData = "";
    String errmsg = "";
    boolean buttonclicked = false;
    public List<String> libsList = new ArrayList<String>();
    public List<String> dirsList = new ArrayList<String>();
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);
    String spmListType = "";
    Image imgstoplighttransparent = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"images/stopLightTransparent.gif").createImage();
    Image imgstoplightred = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"images/stopLightRed.gif").createImage();
    public String defaultIdReqnum = "";
    public String defaultDir = "";
    String selReqnum = "";
    String idReqNum = "";
    private List<String> spmList = new ArrayList<String>();
    private List<String> pasteList = new ArrayList<String>();

    public PasteMapFilesDialog(Shell parentShell, String spmListType, List<String> spmList, List<String> pasteList) {
        super(parentShell);
        this.shell = parentShell;
        this.spmconstantsext = CorePlugin.getDefault().getSpmConstantsExtension();
        this.spmListType = spmListType;
        this.spmList = spmList;
        this.pasteList = pasteList;
        ObservationsModel obs = CorePlugin.getDefault().selobs;
        this.selReqnum = CorePlugin.getDefault().constants.reqdecfmt.format(obs.getReqnum());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("PasteMapFilesDialog.ShellTitle"));
        newShell.setImage(CorePlugin.getDefault().productextension.getDialogShellImage());
    }

    protected Control createDialogArea(Composite parent) {
        this.content = parent;
        ((GridLayout)this.content.getLayout()).numColumns = 1;
        GridData gd2 = new GridData(4, 0x1000000, true, false, 1, 1);
        this.content.setLayoutData((Object)gd2);
        this.mappingComp = new Composite(this.content, 0);
        GridData gd = new GridData(4, 128, false, true);
        this.mappingComp.setLayoutData((Object)gd);
        this.mappingComp.setLayout((Layout)new GridLayout(1, false));
        this.createLibsGroup();
        this.createDirsGroup();
        this.initLibsDirs();
        if (this.spmListType.equals(this.spmconstants.SPMLISTTYPE_DIRS)) {
            this.showDirsGroup();
        }
        this.runValidateDirsLibsJob();
        return parent;
    }

    private void showDirsGroup() {
        GridData gd5 = (GridData)this.dirsGroup.getLayoutData();
        gd5.exclude = false;
        this.dirsGroup.setVisible(true);
        gd5 = (GridData)this.libsGroup.getLayoutData();
        gd5.exclude = true;
        this.libsGroup.setVisible(false);
        this.mappingComp.layout(false);
    }

    private void createLibsGroup() {
        String libsGroupText = Messages.getString("AddMapFileDialog.GroupLabel.Libs");
        libsGroupText = libsGroupText.replace("#stc", CorePlugin.getDefault().activeStc);
        this.libsGroup = new Group(this.mappingComp, 0);
        this.libsGroup.setText(libsGroupText);
        GridData gd = new GridData(4, 128, true, false, 1, 1);
        this.libsGroup.setLayoutData((Object)gd);
        this.libsGroup.setLayout((Layout)new GridLayout(5, false));
        Label spmInstructionsLabel = new Label((Composite)this.libsGroup, 64);
        spmInstructionsLabel.setText(Messages.getString("PasteMapFilesDialog.Label.LibsInstructions"));
        gd = new GridData(1, 128, false, false, 5, 1);
        gd.minimumHeight = 5;
        gd.minimumWidth = 250;
        spmInstructionsLabel.setLayoutData((Object)gd);
        Label listSourceLabel = new Label((Composite)this.libsGroup, 64);
        listSourceLabel.setText(Messages.getString("AddMapFileDialog.Label.LibsListSource"));
        gd = new GridData(1, 128, false, false, 1, 1);
        listSourceLabel.setLayoutData((Object)gd);
        this.a04LibsRadio = new Button((Composite)this.libsGroup, 16);
        this.a04LibsRadio.setText(Messages.getString("AddMapFileDialog.Radio.PersonalLibs"));
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        gd.horizontalIndent = 10;
        this.a04LibsRadio.setLayoutData((Object)gd);
        if (this.spmListType.equals(this.spmconstants.SPMLISTTYPE_LIBSPERSONAL)) {
            this.a04LibsRadio.setSelection(true);
        } else {
            this.a04LibsRadio.setEnabled(false);
        }
        this.a05LibsRadio = new Button((Composite)this.libsGroup, 16);
        this.a05LibsRadio.setText(Messages.getString("AddMapFileDialog.Radio.CommonLibs"));
        this.a05LibsRadio.setSelection(false);
        gd = new GridData(1, 0x1000000, false, false, 3, 1);
        gd.horizontalIndent = 10;
        this.a05LibsRadio.setLayoutData((Object)gd);
        if (this.spmListType.equals(this.spmconstants.SPMLISTTYPE_LIBSCOMMON)) {
            this.a05LibsRadio.setSelection(true);
        } else {
            this.a05LibsRadio.setEnabled(false);
        }
        this.libsTable = new Table((Composite)this.libsGroup, 67588);
        this.libsTable.setHeaderVisible(true);
        this.libsTable.setLinesVisible(false);
        this.libsTable.setLayoutData((Object)new GridData(4, 4, true, true, 5, 1));
        ((GridData)this.libsTable.getLayoutData()).heightHint = 100;
        ((GridData)this.libsTable.getLayoutData()).widthHint = 450;
        this.libsViewer = new TableViewer(this.libsTable);
        TableColumn column = new TableColumn(this.libsTable, 0);
        column.setText("");
        column = new TableColumn(this.libsTable, 16384);
        column.setText(Messages.getString("PasteMapFilesDialog.DatasetColumn.FileType"));
        column.setWidth(30);
        column = new TableColumn(this.libsTable, 16384);
        column.setText(Messages.getString("PasteMapFilesDialog.DatasetColumn.Repository"));
        column = new TableColumn(this.libsTable, 16384);
        column.setText(Messages.getString("PasteMapFilesDialog.DatasetColumn.DatasetName"));
        column = new TableColumn(this.libsTable, 16448);
        column.setResizable(true);
        column.setWidth(300);
        column.setText(Messages.getString("PasteMapFilesDialog.DatasetColumn.Errors"));
        int listHeight = this.libsViewer.getTable().getItemHeight() * 5;
        Rectangle trim = this.libsViewer.getTable().computeTrim(0, 0, 0, listHeight);
        GridData gd3 = (GridData)this.libsViewer.getTable().getLayoutData();
        gd3.heightHint = trim.height;
        this.libsViewer.getTable().setLayoutData((Object)gd3);
        this.libsGroup.layout(false);
    }

    private void createDirsGroup() {
        String dirsGroupText = Messages.getString("AddMapFileDialog.GroupLabel.Dirs");
        dirsGroupText = dirsGroupText.replace("#stc", CorePlugin.getDefault().activeStc);
        this.dirsGroup = new Group(this.mappingComp, 0);
        this.dirsGroup.setText(dirsGroupText);
        GridData gd = new GridData(4, 128, true, false, 1, 1);
        gd.exclude = true;
        this.dirsGroup.setLayoutData((Object)gd);
        this.dirsGroup.setLayout((Layout)new GridLayout(5, false));
        Label pathInstructionsLabel = new Label((Composite)this.dirsGroup, 64);
        pathInstructionsLabel.setText(Messages.getString("AddMapFileDialog.Label.DirsInstructions"));
        gd = new GridData(1, 128, false, false, 5, 1);
        gd.minimumHeight = 2;
        pathInstructionsLabel.setLayoutData((Object)gd);
        Label listSourceLabel = new Label((Composite)this.dirsGroup, 64);
        listSourceLabel.setText(Messages.getString("AddMapFileDialog.Label.DirsListSource"));
        gd = new GridData(1, 128, false, false, 1, 1);
        listSourceLabel.setLayoutData((Object)gd);
        this.measurementDirsRadio = new Button((Composite)this.dirsGroup, 16);
        this.measurementDirsRadio.setText(Messages.getString("AddMapFileDialog.Radio.MeasurementDirs"));
        if (!this.defaultIdReqnum.endsWith(CorePlugin.getDefault().constants.reqdefault)) {
            this.measurementDirsRadio.setSelection(true);
        }
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        gd.horizontalIndent = 10;
        this.measurementDirsRadio.setLayoutData((Object)gd);
        this.measurementDirsRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PasteMapFilesDialog.this.initLibsDirs();
                PasteMapFilesDialog.this.runValidateDirsLibsJob();
            }
        });
        this.globalDirsRadio = new Button((Composite)this.dirsGroup, 16);
        this.globalDirsRadio.setText(Messages.getString("AddMapFileDialog.Radio.GlobalDirs"));
        if (this.defaultIdReqnum.endsWith(CorePlugin.getDefault().constants.reqdefault)) {
            this.globalDirsRadio.setSelection(true);
        }
        gd = new GridData(1, 0x1000000, false, false, 3, 1);
        gd.horizontalIndent = 10;
        this.globalDirsRadio.setLayoutData((Object)gd);
        this.globalDirsRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PasteMapFilesDialog.this.initLibsDirs();
                PasteMapFilesDialog.this.runValidateDirsLibsJob();
            }
        });
        this.dirsViewer = new TableViewer((Composite)this.dirsGroup, 68352);
        this.dirsTable = this.dirsViewer.getTable();
        this.dirsTable.setHeaderVisible(true);
        this.dirsTable.setLinesVisible(false);
        this.dirsTable.setLayoutData((Object)new GridData(4, 4, true, true, 5, 1));
        ((GridData)this.dirsTable.getLayoutData()).heightHint = 100;
        ((GridData)this.dirsTable.getLayoutData()).widthHint = 450;
        TableColumn column = new TableColumn(this.dirsTable, 0);
        column.setText("");
        column.setWidth(30);
        column = new TableColumn(this.dirsTable, 16384);
        column.setText(Messages.getString("SpmRepositoryDialog.DatasetColumn.IdReqnum"));
        column = new TableColumn(this.dirsTable, 16384);
        column.setText(Messages.getString("SpmRepositoryDialog.DatasetColumn.SrchSeq"));
        column = new TableColumn(this.dirsTable, 16384);
        column.setText(Messages.getString("SpmRepositoryDialog.DatasetColumn.Path"));
        column = new TableColumn(this.dirsTable, 16448);
        column.setResizable(true);
        column.setWidth(300);
        column.setText(Messages.getString("PasteMapFilesDialog.DatasetColumn.Errors"));
        int listHeight2 = this.dirsViewer.getTable().getItemHeight() * 7;
        Rectangle trim2 = this.dirsViewer.getTable().computeTrim(0, 0, 0, listHeight2);
        GridData gd4 = (GridData)this.dirsViewer.getTable().getLayoutData();
        gd4.heightHint = trim2.height;
        this.dirsViewer.getTable().setLayoutData((Object)gd4);
        this.dirsGroup.layout(false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite client = new Composite(this.content, 0);
        GridLayout layout = new GridLayout(2, false);
        GridData gd = new GridData(131072, 0x1000000, true, false, 2, 1);
        client.setLayoutData((Object)gd);
        client.setLayout((Layout)layout);
        this.okButton = this.createButton(client, 0, Messages.getString("AddMapFileDialog.Button.Text.Ok"), true);
        this.createButton(client, 1, Messages.getString("AddMapFileDialog.Button.Text.Cancel"), false);
        this.buttonclicked = false;
    }

    public void okPressed() {
        this.dispose();
        this.setReturnCode(0);
        this.close();
    }

    public void cancelPressed() {
        this.dispose();
        this.setReturnCode(1);
        this.close();
    }

    private void loadLibs() {
        String fileTypeLabel = "";
        String repositoryLabel = "";
        Integer cnt = 0;
        String itemerrmsg = "";
        this.libsTable.setRedraw(false);
        this.libsTable.removeAll();
        int i = 0;
        while (i < this.libsList.size()) {
            cnt = cnt + 1;
            String[] libArr = this.libsList.get(i).split(",");
            fileTypeLabel = libArr[0];
            int j = 0;
            while (j < this.spmconstantsext.getFileTypes().length) {
                if (libArr[0].equals(this.spmconstantsext.getFileTypes()[j])) {
                    fileTypeLabel = this.spmconstantsext.getFileTypeLabels()[j];
                    break;
                }
                ++j;
            }
            repositoryLabel = libArr[1];
            j = 0;
            while (j < this.spmconstantsext.getRepositories().length) {
                if (libArr[1].equals(this.spmconstantsext.getRepositories()[j])) {
                    repositoryLabel = this.spmconstantsext.getRepositoryLabels()[j];
                    break;
                }
                ++j;
            }
            TableItem libsTableItem = new TableItem(this.libsTable, 0);
            libsTableItem.setText(0, cnt.toString());
            if (libArr.length <= 3) {
                libsTableItem.setImage(0, this.imgstoplighttransparent);
                itemerrmsg = "";
            } else {
                libsTableItem.setImage(0, this.imgstoplightred);
                itemerrmsg = libArr[3].trim();
            }
            libsTableItem.setText(1, fileTypeLabel);
            libsTableItem.setText(2, repositoryLabel);
            libsTableItem.setText(3, libArr[2]);
            libsTableItem.setText(4, itemerrmsg);
            ++i;
        }
        this.libsTable.setRedraw(true);
    }

    private void loadDirs() {
        Integer cnt = 0;
        String itemerrmsg = "";
        this.dirsTable.setRedraw(false);
        this.dirsTable.removeAll();
        int i = 0;
        while (i < this.dirsList.size()) {
            cnt = cnt + 1;
            String[] dirsArr = this.dirsList.get(i).split(",");
            TableItem dirsTableItem = new TableItem(this.dirsTable, 0);
            dirsTableItem.setText(0, cnt.toString());
            if (dirsArr.length <= 3) {
                dirsTableItem.setImage(0, this.imgstoplighttransparent);
                itemerrmsg = "";
            } else {
                dirsTableItem.setImage(0, this.imgstoplightred);
                itemerrmsg = dirsArr[3].trim();
            }
            dirsTableItem.setText(1, dirsArr[0]);
            dirsTableItem.setText(2, dirsArr[1]);
            dirsTableItem.setText(3, dirsArr[2]);
            dirsTableItem.setText(4, itemerrmsg);
            ++i;
        }
        this.dirsTable.setRedraw(true);
    }

    private void chkDir(String addDir) {
        addDir = addDir.replace("\r", "").trim();
        addDir = addDir.replace("\n", "").trim();
        addDir = addDir.replace("'", "").trim();
        this.errmsg = this.chkMandatory(addDir, Messages.getString("PasteMapFilesDialog.Label.Directory"));
        if (this.errmsg.length() > 0) {
            return;
        }
        if (addDir.length() > 150) {
            this.errmsg = Messages.getString("PasteMapFilesDialog.errorMessage.DirectoryTooLong");
            return;
        }
        int i = 0;
        while (i < this.spmList.size()) {
            String[] spmitem = this.spmList.get(i).split(",");
            String spmidReqNum = spmitem[0];
            String spmdir = spmitem[2];
            if (this.idReqNum.equals(spmidReqNum) && addDir.equals(spmdir)) {
                this.errmsg = Messages.getString("PasteMapFilesDialog.errorMessage.DuplicateDirectory");
                break;
            }
            ++i;
        }
    }

    private void chkFileType(String fileType) {
        int j = 0;
        while (j < this.spmconstantsext.getFileTypes().length) {
            if (fileType.equals(this.spmconstantsext.getFileTypes()[j])) {
                String cfr_ignored_0 = this.spmconstantsext.getFileTypeLabels()[j];
                return;
            }
            ++j;
        }
        this.errmsg = Messages.getString("PasteMapFilesDialog.errorMessage.UnknownFileType");
    }

    private void chkRepository(String repository) {
        int j = 0;
        while (j < this.spmconstantsext.getRepositories().length) {
            if (repository.equals(this.spmconstantsext.getRepositories()[j])) {
                String cfr_ignored_0 = this.spmconstantsext.getRepositoryLabels()[j];
                return;
            }
            ++j;
        }
        this.errmsg = Messages.getString("PasteMapFilesDialog.errorMessage.UnknownRepository");
    }

    private void chkLib(String addDataset, String addFileType, String addRepository) {
        String[] spmitem;
        this.errmsg = "";
        String fileType = "";
        String repository = "";
        String dataset = "";
        this.errmsg = this.chkMandatory(addDataset, Messages.getString("AddMapFileDialog.Label.DatasetName"));
        if (this.errmsg.length() > 0) {
            return;
        }
        if (addDataset.indexOf("\"") >= 0) {
            this.errmsg = Messages.getString("AddMapFileDialog.chkLib.InvalidDsn");
            return;
        }
        if (addDataset.endsWith(".") || addDataset.indexOf("..") > 0) {
            this.errmsg = Messages.getString("AddMapFileDialog.chkLib.InvalidDsn");
            return;
        }
        addDataset = addDataset.replace("'", "").trim();
        String tok = ".";
        if (addDataset.contains(" ")) {
            tok = " ";
        }
        StringTokenizer st = new StringTokenizer(addDataset, tok);
        String libext = "";
        while (st.hasMoreTokens()) {
            libext = st.nextToken();
            if (libext.length() > 8) {
                this.errmsg = Messages.getString("AddMapFileDialog.chkLib.InvalidDsn");
                return;
            }
            this.errmsg = this.chkIbmName(libext, Messages.getString("AddMapFileDialog.Label.DatasetName"));
            if (this.errmsg.length() <= 0) continue;
            this.errmsg = Messages.getString("AddMapFileDialog.chkLib.InvalidDsn");
            return;
        }
        int cnt = 0;
        int i = 0;
        while (i < this.pasteList.size()) {
            spmitem = this.pasteList.get(i).split(",");
            fileType = spmitem[0];
            repository = spmitem[1];
            dataset = spmitem[2];
            if (addFileType.equals(fileType) && addRepository.equals(repository) && addDataset.equals(dataset)) {
                ++cnt;
            }
            ++i;
        }
        if (cnt > 1) {
            this.errmsg = Messages.getString("PasteMapFilesDialog.errorMessage.DuplicateDataset");
            return;
        }
        i = 0;
        while (i < this.spmList.size()) {
            spmitem = this.spmList.get(i).split(",");
            fileType = spmitem[0];
            repository = spmitem[1];
            dataset = spmitem[2];
            if (addFileType.equals(fileType) && addRepository.equals(repository) && addDataset.equals(dataset)) {
                this.errmsg = Messages.getString("PasteMapFilesDialog.errorMessage.DuplicateDataset");
                return;
            }
            ++i;
        }
    }

    private String chkIbmName(String val, String varname) {
        String errmsg = "";
        char[] chars = val.toCharArray();
        int x = 0;
        while (x < chars.length) {
            char c = chars[x];
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                if (c >= '0' && c <= '9') {
                    if (x <= 0) {
                        errmsg = String.valueOf(Messages.getString("AddMapFileDialog.chkIbmName.Invalid")) + varname;
                        return errmsg;
                    }
                } else if (c != '$' && c != '#' && c != '@') {
                    errmsg = String.valueOf(Messages.getString("AddMapFileDialog.chkIbmName.Invalid")) + varname;
                    return errmsg;
                }
            }
            ++x;
        }
        return errmsg;
    }

    private String chkMandatory(String val, String varname) {
        if (val.length() <= 0) {
            this.errmsg = String.valueOf(Messages.getString("AddMapFileDialog.errorMessage.Mandatory")) + varname;
        }
        return this.errmsg;
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
        }
    }

    public int getShellStyle() {
        return 134384;
    }

    private void logMessage(char loglevel, String logstr) {
        System.out.println("PasteMapFilesDialog - " + logstr);
        switch (loglevel) {
            case 'E': {
                CorePlugin.getDefault().log.error(logstr);
                break;
            }
            case 'I': {
                CorePlugin.getDefault().log.info(logstr);
                break;
            }
            case 'W': {
                CorePlugin.getDefault().log.warn(logstr);
                break;
            }
            default: {
                CorePlugin.getDefault().log.debug(logstr);
            }
        }
    }

    public void runValidateDirsLibsJob() {
        Job job0 = new Job(Messages.getString("PasteMapFilesDialog.Job.Title.ValidateDirsLibs")){

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString("PasteMapFilesDialog.Job.Task.DirsLIbs"), 100);
                try {
                    String[] commandarr = new String[1];
                    monitor.subTask(Messages.getString("PasteMapFilesDialog.Job.SubTask.ValidateDirsLibs"));
                    if (PasteMapFilesDialog.this.spmListType.equals(PasteMapFilesDialog.this.spmconstants.SPMLISTTYPE_DIRS)) {
                        int i = 0;
                        while (i < PasteMapFilesDialog.this.dirsList.size()) {
                            String[] itemArr = PasteMapFilesDialog.this.dirsList.get(i).split(",");
                            if (itemArr.length <= 3) {
                                PasteMapFilesDialog.this.dirsLibsData = itemArr[2];
                                PasteMapFilesDialog.this.dirsLibsCommand = PasteMapFilesDialog.this.constants.ZOSMESSAGE_VALIDATE_HFSDIRS;
                                commandarr[0] = String.valueOf(PasteMapFilesDialog.this.dirsLibsCommand) + ",|" + PasteMapFilesDialog.this.dirsLibsData + "|";
                                System.out.println("Running " + commandarr[0]);
                                byte[] bRespBuffer = CorePlugin.getDefault().session.doCmdResp(commandarr[0], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
                                ByteBuffer.wrap(bRespBuffer);
                                CorePlugin.getDefault().session.checkResponse();
                                if (CorePlugin.getDefault().session.getReturnCode() != 0) {
                                    PasteMapFilesDialog.this.dirsList.set(i, String.valueOf(itemArr[0]) + "," + itemArr[1] + "," + itemArr[2] + "," + CorePlugin.getDefault().session.getReason().substring(0, CorePlugin.getDefault().session.getReason().indexOf("\n")));
                                }
                            }
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < PasteMapFilesDialog.this.libsList.size()) {
                            String[] itemArr = PasteMapFilesDialog.this.libsList.get(i).split(",");
                            if (itemArr.length <= 3) {
                                PasteMapFilesDialog.this.dirsLibsCommand = PasteMapFilesDialog.this.constants.ZOSMESSAGE_VALIDATE_SPM;
                                String dirDataset = itemArr[2].trim();
                                String zosDatasetType = SpmConstants.ZOSDATASETTYPE_DIRSLIBS;
                                if (dirDataset.contains(" ")) {
                                    zosDatasetType = SpmConstants.ZOSDATASETTYPE_VPAM;
                                    dirDataset = dirDataset.replaceFirst(" ", "/");
                                    dirDataset = dirDataset.replace(" ", "");
                                } else {
                                    dirDataset = "'" + dirDataset + "'";
                                }
                                PasteMapFilesDialog.this.dirsLibsData = " " + zosDatasetType + "=" + dirDataset + " ";
                                commandarr[0] = String.valueOf(PasteMapFilesDialog.this.dirsLibsCommand) + ",|" + PasteMapFilesDialog.this.dirsLibsData + "|";
                                System.out.println("Running " + commandarr[0]);
                                byte[] bRespBuffer = CorePlugin.getDefault().session.doCmdResp(commandarr[0], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
                                ByteBuffer.wrap(bRespBuffer);
                                CorePlugin.getDefault().session.checkResponse();
                                if (CorePlugin.getDefault().session.getReturnCode() != 0) {
                                    PasteMapFilesDialog.this.libsList.set(i, String.valueOf(itemArr[0]) + "," + itemArr[1] + "," + itemArr[2] + "," + CorePlugin.getDefault().session.getReason().substring(0, CorePlugin.getDefault().session.getReason().indexOf("\n")));
                                }
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception ex) {
                    System.out.println("Directories/Libraries Validate Exception: " + ex);
                }
                monitor.worked(100);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job0.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("Job completed successfully");
                } else {
                    System.out.println("Job did not complete successfully");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("SPM Validate rc is " + (this).PasteMapFilesDialog.this.zosconnect.getConnectRc());
                        if ((this).PasteMapFilesDialog.this.spmListType.equals((this).PasteMapFilesDialog.this.spmconstants.SPMLISTTYPE_DIRS)) {
                            PasteMapFilesDialog.this.loadDirs();
                        } else {
                            PasteMapFilesDialog.this.loadLibs();
                        }
                    }
                });
            }
        });
        job0.schedule();
    }

    private void initLibsDirs() {
        this.dirsList = null;
        this.libsList = null;
        this.dirsList = new ArrayList<String>();
        this.libsList = new ArrayList<String>();
        if (this.spmListType.equals(this.spmconstants.SPMLISTTYPE_DIRS)) {
            this.idReqNum = String.valueOf(CorePlugin.getDefault().activeStc) + "-";
            this.idReqNum = this.globalDirsRadio.getSelection() ? String.valueOf(this.idReqNum) + CorePlugin.getDefault().constants.reqdefault : String.valueOf(this.idReqNum) + this.selReqnum;
        }
        int i = 0;
        while (i < this.pasteList.size()) {
            this.errmsg = "";
            if (this.spmListType.equals(this.spmconstants.SPMLISTTYPE_DIRS)) {
                String[] dirArr = this.pasteList.get(i).split(",");
                this.chkDir(dirArr[2]);
                this.dirsList.add(String.valueOf(this.idReqNum) + ",00," + dirArr[2] + "," + this.errmsg);
            } else {
                String[] libArr = this.pasteList.get(i).split(",");
                this.chkFileType(libArr[0]);
                if (this.errmsg.length() <= 0) {
                    this.chkRepository(libArr[1]);
                }
                if (this.errmsg.length() <= 0) {
                    this.chkLib(libArr[2], libArr[0], libArr[1]);
                }
                this.libsList.add(String.valueOf(this.pasteList.get(i).toUpperCase()) + "," + this.errmsg);
            }
            ++i;
        }
    }

    public void dispose() {
        this.imgstoplighttransparent.dispose();
        this.imgstoplightred.dispose();
    }
}

