/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs.spm;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.dialogs.spm.ISpmConstantsExtension;
import com.banknet.core.dialogs.spm.Messages;
import com.banknet.core.dialogs.spm.SpmConstants;
import com.banknet.core.internal.Constants;
import com.banknet.core.models.ObservationsModel;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class AddMapFileDialog
extends Dialog {
    Constants constants = new Constants();
    SpmConstants spmconstants = new SpmConstants();
    ZosConnect zosconnect = new ZosConnect();
    ISpmConstantsExtension spmconstantsext;
    Composite content;
    Shell shell;
    Button okButton;
    Button settingsButton;
    TableViewer tableviewer;
    Table table;
    TableViewer dirsViewer;
    Table dirsTable;
    private Composite dirslibsRadios;
    private Composite mappingComp;
    private Group dirsGroup;
    private Group libsGroup;
    private Button measurementDirsRadio;
    private Button globalDirsRadio;
    private Button listSource;
    private Text dirText;
    private Text charCount;
    private Combo fileTypeList;
    private Combo repositoryList;
    private Text datasetText;
    private Text memberText;
    private Button a04LibsRadio;
    private Button a05LibsRadio;
    public String addFileType;
    public String addRepository;
    public String addDataset;
    public String addMember;
    public boolean addPersonalList;
    public boolean addGlobalDirs;
    public String addDir;
    public String defaultFileType;
    public String defaultRepository;
    public String defaultDataset;
    private String fileType;
    private String repository;
    public String member;
    public String dirsLibsCommand;
    public String dirsLibsData;
    String errmsg;
    boolean buttonclicked;
    private List<String> datasetsList;
    private List<String> dirsList;
    String styleDelimiter1;
    Pattern s1;
    String spmListType;
    public String defaultIdReqnum;
    public String defaultDir;
    private List<String> spmList;

    public AddMapFileDialog(Shell parentShell, String spmListType, List spmList) {
        super(parentShell);
        this.defaultFileType = this.spmconstants.FILETYPE_LISTING;
        this.defaultRepository = this.spmconstants.REPOSITORY_OTHER;
        this.defaultDataset = "";
        this.fileType = "";
        this.repository = "";
        this.member = "";
        this.dirsLibsCommand = "";
        this.dirsLibsData = "";
        this.errmsg = "";
        this.buttonclicked = false;
        this.datasetsList = new ArrayList<String>();
        this.dirsList = new ArrayList<String>();
        this.styleDelimiter1 = "[|]";
        this.s1 = Pattern.compile(this.styleDelimiter1);
        this.spmListType = "";
        this.defaultIdReqnum = "";
        this.defaultDir = "";
        this.spmList = new ArrayList<String>();
        this.shell = parentShell;
        this.spmconstantsext = CorePlugin.getDefault().getSpmConstantsExtension();
        this.defaultFileType = this.spmconstantsext.getFileTypes()[0];
        this.defaultRepository = this.spmconstantsext.getRepositories()[0];
        this.spmListType = spmListType;
        this.spmList = spmList;
        this.fileType = this.defaultFileType;
        this.repository = this.defaultRepository;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("AddMapFileDialog.ShellTitle"));
        newShell.setImage(CorePlugin.getDefault().productextension.getDialogShellImage());
    }

    protected Control createDialogArea(Composite parent) {
        this.content = parent;
        ((GridLayout)this.content.getLayout()).numColumns = 1;
        GridData gd2 = new GridData(4, 0x1000000, true, false, 1, 1);
        this.content.setLayoutData((Object)gd2);
        this.fileType = this.defaultFileType;
        this.repository = this.defaultRepository;
        this.mappingComp = new Composite(this.content, 0);
        GridData gd = new GridData(4, 128, false, true);
        this.mappingComp.setLayoutData((Object)gd);
        this.mappingComp.setLayout((Layout)new GridLayout(1, false));
        this.createLibsGroup();
        this.createDirsGroup();
        if (this.spmListType.equals(this.spmconstants.SPMLISTTYPE_DIRS)) {
            this.showDirsGroup();
        } else {
            this.datasetText.setFocus();
        }
        return parent;
    }

    private void showDirsGroup() {
        GridData gd5 = (GridData)this.dirsGroup.getLayoutData();
        gd5.exclude = false;
        this.dirsGroup.setVisible(true);
        gd5 = (GridData)this.libsGroup.getLayoutData();
        gd5.exclude = true;
        this.libsGroup.setVisible(false);
        this.mappingComp.layout(false);
    }

    private void createLibsGroup() {
        String libsGroupText = Messages.getString("AddMapFileDialog.GroupLabel.Libs");
        libsGroupText = libsGroupText.replace("#stc", CorePlugin.getDefault().activeStc);
        this.libsGroup = new Group(this.mappingComp, 0);
        this.libsGroup.setText(libsGroupText);
        GridData gd = new GridData(4, 128, true, false, 1, 1);
        this.libsGroup.setLayoutData((Object)gd);
        this.libsGroup.setLayout((Layout)new GridLayout(5, false));
        Label spmInstructionsLabel = new Label((Composite)this.libsGroup, 64);
        spmInstructionsLabel.setText(Messages.getString("AddMapFileDialog.Label.LibsInstructions"));
        gd = new GridData(1, 128, false, false, 5, 1);
        gd.minimumHeight = 5;
        gd.minimumWidth = 250;
        spmInstructionsLabel.setLayoutData((Object)gd);
        Label listSourceLabel = new Label((Composite)this.libsGroup, 64);
        listSourceLabel.setText(Messages.getString("AddMapFileDialog.Label.LibsListSource"));
        gd = new GridData(1, 128, false, false, 1, 1);
        listSourceLabel.setLayoutData((Object)gd);
        this.a04LibsRadio = new Button((Composite)this.libsGroup, 16);
        this.a04LibsRadio.setText(Messages.getString("AddMapFileDialog.Radio.PersonalLibs"));
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        this.a04LibsRadio.setLayoutData((Object)gd);
        this.a04LibsRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        if (this.spmListType.equals(this.spmconstants.SPMLISTTYPE_LIBSPERSONAL)) {
            this.a04LibsRadio.setSelection(true);
        } else {
            this.a04LibsRadio.setEnabled(false);
        }
        this.a05LibsRadio = new Button((Composite)this.libsGroup, 16);
        this.a05LibsRadio.setText(Messages.getString("AddMapFileDialog.Radio.CommonLibs"));
        this.a05LibsRadio.setSelection(false);
        gd = new GridData(1, 0x1000000, false, false, 3, 1);
        gd.horizontalIndent = 10;
        this.a05LibsRadio.setLayoutData((Object)gd);
        this.a05LibsRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        if (this.spmListType.equals(this.spmconstants.SPMLISTTYPE_LIBSCOMMON)) {
            this.a05LibsRadio.setSelection(true);
        } else {
            this.a05LibsRadio.setEnabled(false);
        }
        Label fileTypeLabel = new Label((Composite)this.libsGroup, 0);
        fileTypeLabel.setText(Messages.getString("AddMapFileDialog.Label.FileType"));
        gd = new GridData(1, 0x1000000, false, false);
        fileTypeLabel.setLayoutData((Object)gd);
        this.fileTypeList = new Combo((Composite)this.libsGroup, 8);
        int i = 0;
        while (i < this.spmconstantsext.getFileTypes().length) {
            this.fileTypeList.setData(String.valueOf(i), (Object)this.spmconstantsext.getFileTypes()[i]);
            this.fileTypeList.add(this.spmconstantsext.getFileTypeLabels()[i]);
            ++i;
        }
        this.setFileTypeSelect();
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        this.fileTypeList.setLayoutData((Object)gd);
        Label repositoryLabel = new Label((Composite)this.libsGroup, 0);
        repositoryLabel.setText(Messages.getString("AddMapFileDialog.Label.Repository"));
        gd = new GridData(1, 0x1000000, false, false);
        gd.horizontalIndent = 10;
        repositoryLabel.setLayoutData((Object)gd);
        this.repositoryList = new Combo((Composite)this.libsGroup, 8);
        int i2 = 0;
        while (i2 < this.spmconstantsext.getRepositories().length) {
            this.repositoryList.setData(String.valueOf(i2), (Object)this.spmconstantsext.getRepositories()[i2]);
            this.repositoryList.add(this.spmconstantsext.getRepositoryLabels()[i2]);
            ++i2;
        }
        this.setRepositorySelect();
        gd = new GridData(1, 0x1000000, false, false, 2, 1);
        this.repositoryList.setLayoutData((Object)gd);
        Label datasetLabel = new Label((Composite)this.libsGroup, 64);
        datasetLabel.setText(Messages.getString("AddMapFileDialog.Label.DatasetName"));
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        if (this.spmconstantsext.getIncludeAaserver()) {
            datasetLabel.setText(Messages.getString("AddMapFileDialog.Label.DatasetNameAaserver"));
            gd.widthHint = 125;
        }
        datasetLabel.setLayoutData((Object)gd);
        this.datasetText = new Text((Composite)this.libsGroup, 2048);
        this.datasetText.setText(this.defaultDataset);
        gd = new GridData(1, 0x1000000, true, false, 4, 1);
        gd.widthHint = 350;
        this.datasetText.setLayoutData((Object)gd);
        this.datasetText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.datasetText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AddMapFileDialog.this.datasetText.setText(AddMapFileDialog.this.datasetText.getText().trim().toUpperCase());
            }
        });
    }

    private void createDirsGroup() {
        String dirsGroupText = Messages.getString("AddMapFileDialog.GroupLabel.Dirs");
        dirsGroupText = dirsGroupText.replace("#stc", CorePlugin.getDefault().activeStc);
        this.dirsGroup = new Group(this.mappingComp, 0);
        this.dirsGroup.setText(dirsGroupText);
        GridData gd = new GridData(4, 128, true, false, 1, 1);
        gd.exclude = true;
        this.dirsGroup.setLayoutData((Object)gd);
        this.dirsGroup.setLayout((Layout)new GridLayout(5, false));
        Label pathInstructionsLabel = new Label((Composite)this.dirsGroup, 64);
        pathInstructionsLabel.setText(Messages.getString("AddMapFileDialog.Label.DirsInstructions"));
        gd = new GridData(1, 128, false, false, 5, 1);
        gd.minimumHeight = 2;
        pathInstructionsLabel.setLayoutData((Object)gd);
        Label listSourceLabel = new Label((Composite)this.dirsGroup, 64);
        listSourceLabel.setText(Messages.getString("AddMapFileDialog.Label.DirsListSource"));
        gd = new GridData(1, 128, false, false, 1, 1);
        listSourceLabel.setLayoutData((Object)gd);
        this.measurementDirsRadio = new Button((Composite)this.dirsGroup, 16);
        this.measurementDirsRadio.setText(Messages.getString("AddMapFileDialog.Radio.MeasurementDirs"));
        if (!this.defaultIdReqnum.endsWith(CorePlugin.getDefault().constants.reqdefault)) {
            this.measurementDirsRadio.setSelection(true);
        }
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        gd.horizontalIndent = 10;
        this.measurementDirsRadio.setLayoutData((Object)gd);
        this.measurementDirsRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.globalDirsRadio = new Button((Composite)this.dirsGroup, 16);
        this.globalDirsRadio.setText(Messages.getString("AddMapFileDialog.Radio.GlobalDirs"));
        if (this.defaultIdReqnum.endsWith(CorePlugin.getDefault().constants.reqdefault)) {
            this.globalDirsRadio.setSelection(true);
        }
        gd = new GridData(1, 0x1000000, false, false, 3, 1);
        gd.horizontalIndent = 10;
        this.globalDirsRadio.setLayoutData((Object)gd);
        this.globalDirsRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.dirText = new Text((Composite)this.dirsGroup, 2112);
        this.dirText.setText(this.defaultDir);
        this.dirText.setTextLimit(150);
        this.dirText.setFocus();
        gd = new GridData(4, 0x1000000, true, false, 5, 1);
        Rectangle trim = this.dirText.computeTrim(0, 0, 0, 25);
        gd.heightHint = trim.height;
        this.dirText.setLayoutData((Object)gd);
        this.dirText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                String cnt = Integer.toString(AddMapFileDialog.this.dirText.getCharCount());
                AddMapFileDialog.this.charCount.setText(cnt);
            }
        });
        this.dirText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
            }
        });
        Label charCountLabel = new Label((Composite)this.dirsGroup, 0);
        charCountLabel.setText(Messages.getString("AddMapFileDialog.Label.Chars"));
        gd = new GridData(0x1000008, 0x1000000, true, false, 4, 1);
        charCountLabel.setLayoutData((Object)gd);
        this.charCount = new Text((Composite)this.dirsGroup, 2048);
        this.charCount.setText("");
        this.charCount.setEditable(false);
        gd = new GridData(0x1000008, 0x1000000, false, false, 1, 1);
        gd.widthHint = 25;
        this.charCount.setLayoutData((Object)gd);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite client = new Composite(this.content, 0);
        GridLayout layout = new GridLayout(2, false);
        GridData gd = new GridData(131072, 0x1000000, true, false, 2, 1);
        client.setLayoutData((Object)gd);
        client.setLayout((Layout)layout);
        this.okButton = this.createButton(client, 0, Messages.getString("AddMapFileDialog.Button.Text.Ok"), true);
        this.createButton(client, 1, Messages.getString("AddMapFileDialog.Button.Text.Cancel"), false);
        this.buttonclicked = false;
    }

    public void okPressed() {
        this.addPersonalList = this.a04LibsRadio.getSelection();
        this.addFileType = (String)this.fileTypeList.getData(String.valueOf(this.fileTypeList.getSelectionIndex()));
        this.addRepository = (String)this.repositoryList.getData(String.valueOf(this.repositoryList.getSelectionIndex()));
        this.addDataset = this.datasetText.getText();
        this.addGlobalDirs = this.globalDirsRadio.getSelection();
        this.addDir = this.dirText.getText();
        this.chkComplete();
    }

    public void cancelPressed() {
        this.setReturnCode(1);
        this.close();
    }

    public boolean chkComplete() {
        boolean isComplete = true;
        this.errmsg = "";
        if (this.spmListType.equals(this.spmconstants.SPMLISTTYPE_DIRS)) {
            if (!this.chkA03()) {
                isComplete = false;
            }
        } else if (!this.chkA04A05()) {
            isComplete = false;
        }
        if (this.errmsg.length() > 0) {
            this.showMessage("error", Messages.getString("AddMapFileDialog.ShellTitle"), this.errmsg);
        }
        return isComplete;
    }

    private boolean chkA03() {
        boolean isValid = true;
        this.addDir = this.addDir.replace("\r", "").trim();
        this.addDir = this.addDir.replace("\n", "").trim();
        this.addDir = this.addDir.replace("'", "").trim();
        this.errmsg = this.chkMandatory(this.addDir, Messages.getString("AddMapFileDialog.Label.Directory"));
        if (this.errmsg.length() > 0) {
            return false;
        }
        ObservationsModel obs = CorePlugin.getDefault().selobs;
        String idReqNum = String.valueOf(CorePlugin.getDefault().activeStc) + "-";
        idReqNum = this.addGlobalDirs ? String.valueOf(idReqNum) + CorePlugin.getDefault().constants.reqdefault : String.valueOf(idReqNum) + CorePlugin.getDefault().constants.reqdecfmt.format(obs.getReqnum());
        int i = 0;
        while (i < this.spmList.size()) {
            String[] spmitem = this.spmList.get(i).split(",");
            String spmidReqNum = spmitem[0];
            String spmdir = spmitem[2];
            if (idReqNum.equals(spmidReqNum) && this.addDir.equals(spmdir)) {
                this.errmsg = Messages.getString("AddMapFileDialog.errorMessage.DuplicateDirectory");
                break;
            }
            ++i;
        }
        if (this.errmsg.length() > 0) {
            isValid = false;
            return isValid;
        }
        this.dirsLibsData = this.addDir;
        this.dirsLibsCommand = this.constants.ZOSMESSAGE_VALIDATE_HFSDIRS;
        this.runValidateDirsLibsJob();
        return isValid;
    }

    private boolean chkA04A05() {
        boolean isValid = true;
        this.addDataset = this.addDataset.toUpperCase();
        this.addDataset = this.addDataset.replace("\r", "").trim();
        this.addDataset = this.addDataset.replace("\n", "").trim();
        this.errmsg = this.chkMandatory(this.addDataset, Messages.getString("AddMapFileDialog.Label.DatasetName"));
        if (this.errmsg.length() > 0) {
            return false;
        }
        if (this.addDataset.indexOf("\"") >= 0) {
            this.errmsg = Messages.getString("AddMapFileDialog.chkLib.InvalidDsn");
            return false;
        }
        if (this.addDataset.endsWith(".") || this.addDataset.indexOf("..") > 0) {
            this.errmsg = Messages.getString("AddMapFileDialog.chkLib.InvalidDsn");
            return false;
        }
        this.addDataset = this.addDataset.replace("'", "").trim();
        String tok = ".";
        String zosDatasetType = SpmConstants.ZOSDATASETTYPE_DIRSLIBS;
        String dirDataset = this.addDataset;
        if (this.addDataset.contains(" ")) {
            tok = " ";
            zosDatasetType = SpmConstants.ZOSDATASETTYPE_VPAM;
            dirDataset = dirDataset.replaceFirst(" ", "/");
            dirDataset = dirDataset.replace(" ", "");
        } else {
            dirDataset = "'" + dirDataset + "'";
        }
        StringTokenizer st = new StringTokenizer(this.addDataset, tok);
        String libext = "";
        while (st.hasMoreTokens()) {
            libext = st.nextToken();
            if (libext.length() > 8) {
                this.errmsg = Messages.getString("AddMapFileDialog.chkLib.InvalidDsn");
                return false;
            }
            this.errmsg = this.chkIbmName(libext, Messages.getString("AddMapFileDialog.Label.DatasetName"));
            if (this.errmsg.length() <= 0) continue;
            this.errmsg = Messages.getString("AddMapFileDialog.chkLib.InvalidDsn");
            return false;
        }
        int i = 0;
        while (i < this.spmList.size()) {
            String[] spmitem = this.spmList.get(i).split(",");
            String fileType = spmitem[0];
            String repository = spmitem[1];
            String dataset = spmitem[2];
            if (this.addFileType.equals(fileType) && this.addRepository.equals(repository) && this.addDataset.equals(dataset)) {
                this.errmsg = Messages.getString("AddMapFileDialog.errorMessage.DuplicateDataset");
                return false;
            }
            ++i;
        }
        this.dirsLibsData = " " + zosDatasetType + "=" + dirDataset + " ";
        this.dirsLibsCommand = this.constants.ZOSMESSAGE_VALIDATE_SPM;
        this.runValidateDirsLibsJob();
        if (this.errmsg.length() > 0) {
            isValid = false;
        }
        return isValid;
    }

    private String chkIbmName(String val, String varname) {
        String errmsg = "";
        char[] chars = val.toCharArray();
        int x = 0;
        while (x < chars.length) {
            char c = chars[x];
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                if (c >= '0' && c <= '9') {
                    if (x <= 0) {
                        errmsg = String.valueOf(Messages.getString("AddMapFileDialog.chkIbmName.Invalid")) + varname;
                        return errmsg;
                    }
                } else if (c != '$' && c != '#' && c != '@') {
                    errmsg = String.valueOf(Messages.getString("AddMapFileDialog.chkIbmName.Invalid")) + varname;
                    return errmsg;
                }
            }
            ++x;
        }
        return errmsg;
    }

    private String chkMandatory(String val, String varname) {
        if (val.length() <= 0) {
            this.errmsg = String.valueOf(Messages.getString("AddMapFileDialog.errorMessage.Mandatory")) + varname;
        }
        return this.errmsg;
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
        }
    }

    public int getShellStyle() {
        return 134384;
    }

    private void logMessage(char loglevel, String logstr) {
        System.out.println("AddMapFileDialog - " + logstr);
        switch (loglevel) {
            case 'E': {
                CorePlugin.getDefault().log.error(logstr);
                break;
            }
            case 'I': {
                CorePlugin.getDefault().log.info(logstr);
                break;
            }
            case 'W': {
                CorePlugin.getDefault().log.warn(logstr);
                break;
            }
            default: {
                CorePlugin.getDefault().log.debug(logstr);
            }
        }
    }

    private void setFileTypeSelect() {
        int i = 0;
        while (i < this.fileTypeList.getItemCount()) {
            if (this.fileType.equals((String)this.fileTypeList.getData(String.valueOf(i)))) {
                this.fileTypeList.select(i);
            }
            ++i;
        }
    }

    private void setRepositorySelect() {
        int i = 0;
        while (i < this.repositoryList.getItemCount()) {
            if (this.repository.equals((String)this.repositoryList.getData(String.valueOf(i)))) {
                this.repositoryList.select(i);
            }
            ++i;
        }
    }

    public void runValidateDirsLibsJob() {
        Job job0 = new Job(Messages.getString("AddMapFileDialog.Job.Title.ValidateDirsLibs")){

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString("AddMapFileDialog.Job.Task.DirsLIbs"), 100);
                if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("local") == 0) {
                    return Status.CANCEL_STATUS;
                }
                monitor.subTask(Messages.getString("AddMapFileDialog.Job.SubTask.Ping"));
                AddMapFileDialog.this.zosconnect.pingZos(monitor);
                if (AddMapFileDialog.this.zosconnect.getConnectRc() != 0) {
                    return Status.CANCEL_STATUS;
                }
                monitor.subTask(Messages.getString("AddMapFileDialog.Job.SubTask.ValidateDirsLibs"));
                try {
                    String[] commandarr = new String[]{String.valueOf(AddMapFileDialog.this.dirsLibsCommand) + ",|" + AddMapFileDialog.this.dirsLibsData + "|"};
                    System.out.println("Running " + commandarr[0]);
                    byte[] bRespBuffer = CorePlugin.getDefault().session.doCmdResp(commandarr[0], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
                    ByteBuffer.wrap(bRespBuffer);
                    CorePlugin.getDefault().session.checkResponse();
                }
                catch (Exception ex) {
                    System.out.println("Directories/Libraries Validate Exception: " + ex);
                }
                monitor.worked(100);
                monitor.done();
                if (CorePlugin.getDefault().session.getReturnCode() == 0) {
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        job0.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("Job completed successfully");
                } else {
                    System.out.println("Job did not complete successfully");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("SPM Validate rc is " + (this).AddMapFileDialog.this.zosconnect.getConnectRc());
                        if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("local") == 0 | (this).AddMapFileDialog.this.zosconnect.getConnectRc() != 0) {
                            AddMapFileDialog.this.showMessage("info", Messages.getString("AddMapFileDialog.MessageDialog.infoTitle.AddMapFile"), String.valueOf(Messages.getString("SpmRepository.MessageDialog.infoMessage.RemoteConnectionLost")) + Messages.getString("SpmRepository.MessageDialog.infoMessage.ReConnect"));
                            (this).AddMapFileDialog.this.zosconnect.setConnectLocal();
                        } else if (CorePlugin.getDefault().session.getReturnCode() == 0) {
                            AddMapFileDialog.this.setReturnCode(0);
                            AddMapFileDialog.this.close();
                        } else {
                            String msgstr = CorePlugin.getDefault().session.getReason().substring(0, CorePlugin.getDefault().session.getReason().indexOf("\n"));
                            int linebrkidx = CorePlugin.getDefault().session.getReason().indexOf("\n");
                            if (linebrkidx > 0) {
                                msgstr = msgstr.substring(0, linebrkidx);
                            }
                            AddMapFileDialog.this.showMessage("error", Messages.getString("AddMapFileDialog.MessageDialog.infoTitle.AddMapFile"), msgstr);
                        }
                    }
                });
            }
        });
        job0.schedule();
    }
}

