/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs.reports;

import com.banknet.core.CorePlugin;
import com.banknet.core.data.reports.ReportHtmlBuilder;
import com.banknet.core.dialogs.reports.FindTextDialog;
import com.banknet.core.dialogs.reports.Messages;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.Utilities;
import com.banknet.core.internal.pvmlExpandCollapse;
import com.banknet.core.internal.pvmlReader;
import com.banknet.core.internal.pvmlSort;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ReportViewerDialog
extends Dialog {
    public pvmlReader pv;
    public pvmlExpandCollapse pvec;
    public pvmlSort pvsort;
    private Utilities util = new Utilities();
    Constants constants = new Constants();
    FindTextDialog finddialog;
    ReportViewerDialog rvd = this;
    Composite content;
    Shell shell;
    Composite client;
    Composite checkboxgroup;
    Composite combogroup;
    Composite textgroup;
    StyledText testStyler;
    StyledText textViewer;
    StyledText reportLabel;
    StyledText printText;
    public Text findText;
    public Button optionCheck;
    public Button upRadio;
    public Button downRadio;
    public Combo optionCombo;
    public Text optionText;
    public String finddir = "down";
    boolean initialSetup = false;
    public String[] optionsarr = null;
    public String options = "";
    Label rpttitle;
    Composite toolbarComp;
    Label statusline;
    private Action localPullDown;
    private Action saveAction;
    private Action printAction;
    private Action copyAction;
    private Action findAction;
    private Action selectAllAction;
    private Action spmSettingsAction;
    private Action emailReportAction;
    private Action launchHtmlAction;
    ToolBarManager toolBarMgr;
    String reportLocation = "";
    public String stcid = "";
    public String rptid = "";
    public String selectedRptid = "";
    public String reportTitle = "";
    public Integer reqnum = 0;
    String sreqnum = "";
    String reportPath = "";
    String htmlsuffix = "-detail";
    String printTitle = "";
    Cursor arrowCursor;
    Cursor handCursor;
    List<String> colorStyles = new ArrayList<String>();
    List<Color> colorCodes = new ArrayList<Color>();
    public int searchloc = 0;
    public String searchtxt = "";
    String reporttext = "";
    FontData displayFont10 = new FontData(Display.getCurrent().getSystemFont().getFontData()[0].getName(), 10, 0);
    FontData displayFont9 = new FontData(Display.getCurrent().getSystemFont().getFontData()[0].getName(), 9, 0);
    FontData defaultFont = new FontData("Lucida Console", 10, 0);
    int underlineStyle = 0;
    public List<StyleRange> listPrintStyles;
    public List<StyleRange> listHeaderStyles;
    public List<StyleRange> listBodyStyles;
    public StyleRange stylerange;
    public StyleRange printstylerange;
    String activelink = "";
    public String printPVML = new String();
    String[] stra;
    String[] activelinksHeader;
    String[] activelinksBody;
    StringBuilder stylingHeader;
    StringBuilder stylingBody;
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);
    StringBuilder detailList = new StringBuilder();
    String[] detailOffsets;
    char extRptLinkType = (char)69;
    int seloffset = 0;
    String errorTitle = "";
    String errorMsg = "";
    String errmsg = "";
    int linenum = 0;
    boolean doubleclicked = false;
    public String rptline = "";
    public StyleRange[] rptlinestyles;
    String lcmdopt = "";
    final String LCMD_SPM = "P";
    boolean isJavaReport = false;
    String explainsql = "";
    String contextheaderlink = "";
    String contextbodylink = "";
    String sortactivelink = "";
    String sortvalue = "";
    String sortpi = "";
    String[] sorts;
    String rptfile = "";
    private MouseListener reportLabelMouseListener;
    private Listener reportLabelMouseMoveListener;
    private MouseListener textViewerMouseListener;
    private Listener textViewerMouseMoveListener;
    private Listener textViewerKeyDownListener;
    private FocusAdapter textViewerFocusListener;
    private SelectionListener textViewerSelectionListener;
    private IPartListener2 partListener;
    Font viewerFont;
    Image imgRptGreen = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/msGreen.gif").createImage();
    private final IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals("findText") && ReportViewerDialog.this.finddialog.rvd != null) {
                ReportViewerDialog.this.findText();
            }
        }
    };
    private IMenuCreator connectMenuCreator = new IMenuCreator(){
        private Menu menu;

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            this.menu = new Menu(parent);
            MenuItem item = new MenuItem(this.menu, 0);
            item.setText(Messages.getString("ReportDetailDialog.Action.EmailReport"));
            item.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/email.gif").createImage());
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReportViewerDialog.this.emailReportAction.run();
                }
            });
            item = new MenuItem(this.menu, 0);
            item.setText(Messages.getString("ReportDetailDialog.Action.LaunchHtml"));
            item.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/obj/generic_element.gif").createImage());
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReportViewerDialog.this.launchHtmlAction.run();
                }
            });
            item = new MenuItem(this.menu, 0);
            item.setText(Messages.getString("ReportDetailDialog.Action.Print"));
            item.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/print_edit.gif").createImage());
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReportViewerDialog.this.printAction.run();
                }
            });
            item = new MenuItem(this.menu, 0);
            item.setText(Messages.getString("ReportDetailDialog.Action.SaveAs"));
            item.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/saveas_edit.gif").createImage());
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReportViewerDialog.this.saveAction.run();
                }
            });
            item = new MenuItem(this.menu, 0);
            item.setText(Messages.getString("ReportDetailDialog.Action.Find"));
            item.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/search_src.gif").createImage());
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReportViewerDialog.this.findAction.run();
                }
            });
            item = new MenuItem(this.menu, 0);
            item.setText(Messages.getString("ReportDetailDialog.Action.SelectAll"));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReportViewerDialog.this.selectAllAction.run();
                }
            });
            item = new MenuItem(this.menu, 0);
            item.setText(Messages.getString("ReportDetailDialog.Action.Copy"));
            item.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/copy_edit.gif").createImage());
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReportViewerDialog.this.copyAction.run();
                }
            });
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            return this.menu;
        }
    };

    public ReportViewerDialog(Shell parentShell, String rptfile) {
        super(parentShell);
        this.shell = parentShell;
        this.rptfile = rptfile;
        String OSenv = System.getProperty("os.name").toLowerCase();
        String fontName = Messages.getString("ReportDetailDialog.FontName");
        if (OSenv.startsWith("linux")) {
            fontName = Messages.getString("ReportDetailDialog.FontName.Linux");
        } else if (OSenv.startsWith("mac")) {
            fontName = Messages.getString("ReportDetailDialog.FontName.Mac");
        }
        int fontHeight = new Integer(Messages.getString("ReportDetailDialog.FontHeight"));
        this.defaultFont = new FontData(fontName, fontHeight, 0);
        this.underlineStyle = new Integer(Messages.getString("ReportDetailDialog.UnderlineStyle"));
        this.viewerFont = new Font((Device)Display.getCurrent(), this.defaultFont);
        this.loadColors();
        IEclipsePreferences preferencesI = InstanceScope.INSTANCE.getNode("com.banknet.core");
        preferencesI.addPreferenceChangeListener(this.preferenceChangeListener);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("ReportViewerDialog.ShellTitle"));
        newShell.setImage(this.imgRptGreen);
        newShell.setSize(750, 450);
        this.sreqnum = CorePlugin.getDefault().constants.reqdecfmt.format(this.reqnum);
        this.buildMenubar(newShell);
        this.makeActions();
    }

    protected Control createDialogArea(Composite parent) {
        this.arrowCursor = new Cursor((Device)parent.getDisplay(), 0);
        this.handCursor = new Cursor((Device)parent.getDisplay(), 21);
        this.toolbarComp = new Composite(parent, 0);
        GridData gd = new GridData(4, 128, true, false);
        this.toolbarComp.setLayoutData((Object)gd);
        this.toolbarComp.setLayout((Layout)new GridLayout(1, false));
        if (!CorePlugin.getDefault().getPreferenceStore().getBoolean("colorMonochrome")) {
            this.toolbarComp.setBackground(this.constants.COLOR_ALT_ROW_GREEN);
        }
        this.rpttitle = new Label(this.toolbarComp, 64);
        this.rpttitle.setText(this.reportTitle);
        GridData gd2 = new GridData(4, 0x1000000, true, false, 1, 1);
        gd2.widthHint = 700;
        this.rpttitle.setLayoutData((Object)gd2);
        if (!CorePlugin.getDefault().getPreferenceStore().getBoolean("colorMonochrome")) {
            this.rpttitle.setBackground(this.constants.COLOR_ALT_ROW_GREEN);
        }
        this.client = new Composite(parent, 4);
        GridLayout layout = new GridLayout(1, false);
        this.client.setLayout((Layout)layout);
        gd = new GridData(4, 4, true, true);
        this.client.setLayoutData((Object)gd);
        this.client.setLayout((Layout)new GridLayout(1, false));
        this.client.setFont(new Font((Device)Display.getCurrent(), this.defaultFont));
        if (!CorePlugin.getDefault().getPreferenceStore().getBoolean("colorMonochrome")) {
            this.client.setBackground(Display.getCurrent().getSystemColor(1));
        }
        this.reportLabel = new StyledText(this.client, 0);
        this.reportLabel.setText("");
        if (!CorePlugin.getDefault().getPreferenceStore().getBoolean("colorMonochrome")) {
            this.reportLabel.setForeground(Display.getCurrent().getSystemColor(10));
        }
        this.reportLabel.setEditable(false);
        Color bg2 = Display.getDefault().getSystemColor(1);
        this.reportLabel.setBackground(bg2);
        this.reportLabel.setFont(new Font((Device)Display.getCurrent(), this.defaultFont));
        GridData spec2 = new GridData();
        spec2.horizontalAlignment = 4;
        spec2.grabExcessHorizontalSpace = true;
        this.reportLabel.setLayoutData((Object)spec2);
        this.reportLabel.setVisible(false);
        this.textViewer = new StyledText(this.client, 834);
        this.textViewer.setCursor(this.arrowCursor);
        GridData spec = new GridData();
        spec.horizontalAlignment = 4;
        spec.grabExcessHorizontalSpace = true;
        spec.verticalAlignment = 4;
        spec.grabExcessVerticalSpace = true;
        this.textViewer.setLayoutData((Object)spec);
        this.textViewer.setEditable(false);
        Color bg = Display.getDefault().getSystemColor(1);
        this.textViewer.setBackground(bg);
        this.textViewer.setFont(new Font((Device)Display.getCurrent(), this.defaultFont));
        this.statusline = new Label(parent, 0);
        this.statusline.setText("");
        gd2 = new GridData(4, 0x1000000, true, false, 1, 1);
        gd2.horizontalIndent = 5;
        this.statusline.setLayoutData((Object)gd2);
        this.addReportListeners();
        this.doOpenReport();
        return parent;
    }

    private void addReportListeners() {
        this.reportLabelMouseListener = new MouseListener(){

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                try {
                    int offset = ReportViewerDialog.this.reportLabel.getOffsetAtLocation(new Point(e.x, e.y));
                    if (ReportViewerDialog.this.doubleclicked) {
                        ReportViewerDialog.this.doubleclicked = false;
                    } else if (ReportViewerDialog.this.reportLabel.getStyleRangeAtOffset(offset) != null && ReportViewerDialog.this.reportLabel.getStyleRangeAtOffset((int)offset).underline) {
                        ReportViewerDialog.this.activelink = ReportViewerDialog.this.getActiveLink(offset, ReportViewerDialog.this.activelinksHeader);
                        ReportViewerDialog.this.contextbodylink = "";
                        if (ReportViewerDialog.this.activelink.length() > 0 && e.button == 3) {
                            ReportViewerDialog.this.contextheaderlink = ReportViewerDialog.this.activelink;
                        }
                    }
                }
                catch (Exception exception) {}
            }

            public void mouseDoubleClick(MouseEvent e) {
                ReportViewerDialog.this.doubleclicked = true;
            }

            public void mouseClick(MouseEvent e) {
            }
        };
        this.reportLabel.addMouseListener(this.reportLabelMouseListener);
        this.reportLabelMouseMoveListener = new Listener(){

            public void handleEvent(Event e) {
                try {
                    ReportViewerDialog.this.activelink = "";
                    ReportViewerDialog.this.contextbodylink = "";
                    if (e.stateMask == 0) {
                        ReportViewerDialog.this.reportLabel.setCursor(ReportViewerDialog.this.arrowCursor);
                        ReportViewerDialog.this.reportLabel.getSelection();
                        int offset = ReportViewerDialog.this.reportLabel.getOffsetAtLocation(new Point(e.x, e.y));
                        if (ReportViewerDialog.this.reportLabel.getStyleRangeAtOffset(offset) != null && ReportViewerDialog.this.reportLabel.getStyleRangeAtOffset((int)offset).underline) {
                            ReportViewerDialog.this.activelink = ReportViewerDialog.this.getActiveLink(offset, ReportViewerDialog.this.activelinksHeader);
                            if (ReportViewerDialog.this.activelink.length() > 0) {
                                ReportViewerDialog.this.reportLabel.setCursor(ReportViewerDialog.this.handCursor);
                            }
                        }
                    }
                }
                catch (Exception exception) {}
            }
        };
        this.reportLabel.addListener(5, this.reportLabelMouseMoveListener);
        this.textViewerMouseListener = new MouseListener(){

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                int offset = 0;
                try {
                    offset = ReportViewerDialog.this.textViewer.getOffsetAtLocation(new Point(e.x, e.y));
                }
                catch (Exception exception) {
                    offset = -1;
                }
                if (ReportViewerDialog.this.doubleclicked) {
                    ReportViewerDialog.this.doubleclicked = false;
                } else if (offset != -1 && ReportViewerDialog.this.textViewer.getStyleRangeAtOffset(offset) != null && ReportViewerDialog.this.textViewer.getStyleRangeAtOffset((int)offset).underline) {
                    ReportViewerDialog.this.activelink = ReportViewerDialog.this.getActiveLink(offset, ReportViewerDialog.this.activelinksBody);
                    ReportViewerDialog.this.contextheaderlink = "";
                    if (ReportViewerDialog.this.activelink.length() > 0) {
                        if (e.button != 3) {
                            ReportViewerDialog.this.runActiveLink(ReportViewerDialog.this.activelink);
                        } else {
                            ReportViewerDialog.this.contextbodylink = ReportViewerDialog.this.activelink;
                        }
                    }
                }
                ReportViewerDialog.this.getLineColumn();
            }

            public void mouseDoubleClick(MouseEvent e) {
                ReportViewerDialog.this.doubleclicked = true;
            }
        };
        this.textViewer.addMouseListener(this.textViewerMouseListener);
        this.textViewerMouseMoveListener = new Listener(){

            public void handleEvent(Event e) {
                try {
                    ReportViewerDialog.this.activelink = "";
                    ReportViewerDialog.this.contextheaderlink = "";
                    if (e.stateMask == 0) {
                        ReportViewerDialog.this.textViewer.setCursor(ReportViewerDialog.this.arrowCursor);
                        ReportViewerDialog.this.textViewer.getSelection();
                        int offset = ReportViewerDialog.this.textViewer.getOffsetAtLocation(new Point(e.x, e.y));
                        if (ReportViewerDialog.this.textViewer.getStyleRangeAtOffset(offset) != null && ReportViewerDialog.this.textViewer.getStyleRangeAtOffset((int)offset).underline) {
                            ReportViewerDialog.this.activelink = ReportViewerDialog.this.getActiveLink(offset, ReportViewerDialog.this.activelinksBody);
                            if (ReportViewerDialog.this.activelink.length() > 0) {
                                ReportViewerDialog.this.textViewer.setCursor(ReportViewerDialog.this.handCursor);
                            }
                        }
                    }
                }
                catch (Exception exception) {}
            }
        };
        this.textViewer.addListener(5, this.textViewerMouseMoveListener);
        this.textViewerKeyDownListener = new Listener(){

            public void handleEvent(Event e) {
                ReportViewerDialog.this.getLineColumn();
            }
        };
        this.textViewer.addListener(1, this.textViewerKeyDownListener);
        this.textViewerFocusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ReportViewerDialog.this.getLineColumn();
            }
        };
        this.textViewer.addFocusListener((FocusListener)this.textViewerFocusListener);
    }

    private String getActiveLink(int selectionOffset, String[] stra) {
        String activelink = "";
        int stylestart = 0;
        int stylelen = 0;
        int styleend = 0;
        if (stra == null) {
            return "";
        }
        int i = 0;
        while (i < stra.length) {
            String[] styleArray = this.s1.split(stra[i], -1);
            stylestart = new Integer(styleArray[0]);
            stylelen = new Integer(styleArray[1]);
            styleend = stylestart + stylelen;
            if (selectionOffset >= stylestart && selectionOffset <= styleend) {
                activelink = styleArray[2];
                return activelink;
            }
            ++i;
        }
        return activelink;
    }

    protected Composite createButtonBar(Composite parent) {
        return null;
    }

    private void makeActions() {
        this.saveAction = new Action(){

            public void run() {
                try {
                    File file = ReportViewerDialog.this.getSaveReport();
                    if (file != null) {
                        String savefile = file.getName().toLowerCase();
                        if (savefile.contains(".htm")) {
                            ReportViewerDialog.this.saveasHtmlFile(file);
                        } else {
                            ReportViewerDialog.this.saveasTextFile(file);
                        }
                        file = null;
                    }
                }
                catch (Exception e) {
                    String logstr = "saveAction:  exception " + e;
                    System.out.println("ReportViewerDialog " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                    MessageDialog.openError((Shell)ReportViewerDialog.this.textViewer.getShell(), (String)Messages.getString("ReportDetailDialog.MessageDialog.errorTitle.SaveError"), (String)e.getLocalizedMessage());
                }
            }
        };
        this.saveAction.setText(Messages.getString("ReportDetailDialog.Action.SaveAs"));
        this.saveAction.setEnabled(true);
        this.saveAction.setAccelerator(262227);
        this.saveAction.setToolTipText(Messages.getString("ReportDetailDialog.Tooltip.SaveAs"));
        this.saveAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/saveas_edit.gif"));
        this.printAction = new Action(){

            public void run() {
                try {
                    PrintDialog printdialog = new PrintDialog(ReportViewerDialog.this.textViewer.getShell(), 0);
                    PrinterData printdata = printdialog.open();
                    StyledTextPrintOptions printoptions = new StyledTextPrintOptions();
                    printoptions.footer = "\t\t<page>";
                    SimpleDateFormat dtfmt = new SimpleDateFormat("MMM dd yyyy HH:mm:ss");
                    String dt = dtfmt.format(new Date());
                    printoptions.header = String.valueOf(Messages.getString("ReportDetailDialog.PrintHeader.Apa")) + "\n" + ReportViewerDialog.this.reportTitle + "\t" + dt;
                    printoptions.printTextFontStyle = true;
                    printoptions.printTextForeground = true;
                    printoptions.printTextBackground = true;
                    printoptions.printLineBackground = true;
                    printoptions.jobName = ReportViewerDialog.this.reportTitle;
                    printoptions.printLineBackground = true;
                    if (printdata != null) {
                        Printer printer = new Printer(printdata);
                        Runnable runnable = ReportViewerDialog.this.textViewer.print(printer, printoptions);
                        runnable.run();
                        runnable = null;
                        printer = null;
                    }
                    printdialog = null;
                    printdata = null;
                    Object var3_7 = null;
                }
                catch (OutOfMemoryError oem) {
                    String logstr = "printAction:  out of memory exception " + oem;
                    System.out.println("ReportViewerDialog " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                    MessageDialog.openError((Shell)ReportViewerDialog.this.textViewer.getShell(), (String)Messages.getString("ReportDetailDialog.MessageDialog.errorTitle.OEM"), (String)(String.valueOf(Messages.getString("ReportDetailDialog.MessageDialog.errorMessage.PrintReportOEM")) + ReportViewerDialog.this.reportTitle));
                    ReportViewerDialog.this.clearObjs();
                }
                catch (Exception e) {
                    String logstr = "printAction:  exception " + e;
                    System.out.println("ReportViewerDialog " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                    MessageDialog.openError((Shell)ReportViewerDialog.this.textViewer.getShell(), (String)Messages.getString("ReportDetailDialog.MessageDialog.errorTitle.PrintError"), (String)e.getLocalizedMessage());
                }
            }
        };
        this.printAction.setText(Messages.getString("ReportDetailDialog.Action.Print"));
        this.printAction.setAccelerator(262224);
        this.printAction.setToolTipText(Messages.getString("ReportDetailDialog.Tooltip.Print"));
        this.printAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/print_edit.gif"));
        this.copyAction = new Action(){

            public void run() {
                ReportViewerDialog.this.textViewer.copy();
            }
        };
        this.copyAction.setText(Messages.getString("ReportDetailDialog.Action.Copy"));
        this.copyAction.setAccelerator(262211);
        this.copyAction.setToolTipText(Messages.getString("ReportDetailDialog.Tooltip.Copy"));
        this.copyAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/copy_edit.gif"));
        this.selectAllAction = new Action(){

            public void run() {
                int linelimit = 200000;
                if (ReportViewerDialog.this.textViewer.getLineCount() > linelimit) {
                    ReportViewerDialog.this.showErrorMessage(Messages.getString("ReportDetailDialog.MessageDialog.errorTitle.SelectAll"), String.valueOf(Messages.getString("ReportDetailDialog.MessageDialog.errorMessage.TooManyLines")) + linelimit + ".");
                } else {
                    ReportViewerDialog.this.textViewer.selectAll();
                }
            }
        };
        this.selectAllAction.setText(Messages.getString("ReportDetailDialog.Action.SelectAll"));
        this.selectAllAction.setActionDefinitionId("selectall");
        this.selectAllAction.setAccelerator(262209);
        this.selectAllAction.setToolTipText(Messages.getString("ReportDetailDialog.Tooltip.SelectAll"));
        this.findAction = new Action(){

            public void run() {
                ReportViewerDialog.this.searchtxt = "";
                ReportViewerDialog.this.searchloc = 0;
                ReportViewerDialog.this.finddialog = new FindTextDialog(ReportViewerDialog.this.textViewer.getShell(), ReportViewerDialog.this.rvd);
                ReportViewerDialog.this.finddialog.open();
                ReportViewerDialog.this.finddialog = null;
            }
        };
        this.findAction.setText(Messages.getString("ReportDetailDialog.Action.Find"));
        this.findAction.setAccelerator(262214);
        this.findAction.setToolTipText(Messages.getString("ReportDetailDialog.Tooltip.Find"));
        this.findAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/search_src.gif"));
        this.launchHtmlAction = new Action(){

            public void run() {
                if (ReportViewerDialog.this.buildHtml() >= 0) {
                    ReportViewerDialog.this.launchHtmlJob();
                }
            }
        };
        this.launchHtmlAction.setText(Messages.getString("ReportDetailDialog.Action.LaunchHtml"));
        this.launchHtmlAction.setToolTipText(Messages.getString("ReportDetailDialog.Tooltip.LaunchHtml"));
        this.launchHtmlAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/obj/generic_element.gif"));
        this.localPullDown = new Action(){

            public void run() {
            }
        };
        this.localPullDown.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/blankicon2x2.gif"));
        this.localPullDown.setEnabled(true);
        this.localPullDown.setMenuCreator(this.connectMenuCreator);
    }

    private void getLineColumn() {
        int caretoffset = this.textViewer.getCaretOffset();
        int linenum = this.textViewer.getLineAtOffset(caretoffset);
        int colnum = this.textViewer.getOffsetAtLine(linenum) - caretoffset;
        colnum = Math.abs(colnum);
        this.statusline.setText(String.valueOf(linenum) + " : " + colnum);
    }

    private void runActiveLink(String activelink) {
        String rptlink = activelink;
        if (rptlink.charAt(0) == 'E') {
            CorePlugin.getDefault().getPreferenceStore().setValue("activeLink", activelink.substring(1, 4));
        } else if (rptlink.charAt(0) != 'S') {
            this.loadReportJob();
        }
    }

    private void loadPrintText() {
        this.printText = new StyledText((Composite)this.textViewer.getShell(), 770);
        GridData spec = new GridData();
        spec.horizontalAlignment = 4;
        spec.grabExcessHorizontalSpace = true;
        spec.verticalAlignment = 4;
        spec.grabExcessVerticalSpace = true;
        this.printText.setLayoutData((Object)spec);
        this.printText.setEditable(false);
        Color bg = Display.getDefault().getSystemColor(1);
        this.printText.setBackground(bg);
        this.printText.setFont(new Font((Device)Display.getCurrent(), this.defaultFont));
        this.printText.setVisible(false);
        this.printText.setText(this.printPVML);
        this.printText.setStyleRanges(this.listPrintStyles.toArray(new StyleRange[this.listPrintStyles.size()]));
    }

    private void loadColors() {
        this.colorStyles.add("gr");
        this.colorCodes.add(new Color(null, 181, 181, 181));
        this.colorStyles.add("r");
        this.colorCodes.add(new Color(null, 238, 99, 99));
        this.colorStyles.add("t");
        this.colorCodes.add(new Color(null, 0, 160, 168));
        this.colorStyles.add("g");
        this.colorCodes.add(new Color(null, 34, 139, 34));
        this.colorStyles.add("y");
        this.colorCodes.add(new Color(null, 255, 185, 15));
        this.colorStyles.add("b");
        this.colorCodes.add(new Color(null, 0, 0, 205));
        this.colorStyles.add("lb");
        this.colorCodes.add(new Color(null, 110, 187, 255));
        this.colorStyles.add("p");
        this.colorCodes.add(new Color(null, 255, 182, 193));
        this.colorStyles.add("lp");
        this.colorCodes.add(new Color(null, 255, 160, 160));
        this.colorStyles.add("red");
        this.colorCodes.add(new Color(null, 255, 0, 0));
        this.colorStyles.add("green");
        this.colorCodes.add(Display.getCurrent().getSystemColor(5));
        this.colorStyles.add("yellow");
        this.colorCodes.add(Display.getCurrent().getSystemColor(7));
        this.colorStyles.add("blue");
        this.colorCodes.add(Display.getCurrent().getSystemColor(9));
        this.colorStyles.add("turquoise");
        this.colorCodes.add(new Color(null, 0, 160, 168));
        this.colorStyles.add("pink");
        this.colorCodes.add(Display.getCurrent().getSystemColor(11));
        this.colorStyles.add("gray");
        this.colorCodes.add(Display.getCurrent().getSystemColor(15));
        this.colorStyles.add("bl");
        this.colorCodes.add(Display.getCurrent().getSystemColor(2));
    }

    private Color getColorCode(String style) {
        int i = 0;
        while (i < this.colorStyles.size()) {
            if (this.colorStyles.get(i).equals(style)) {
                return this.colorCodes.get(i);
            }
            ++i;
        }
        return this.colorCodes.get(this.colorStyles.size() - 1);
    }

    public void loadReportJob() {
        Job jobA = new Job(Messages.getString("ReportDetailDialog.Job.Title.LoadingReport")){

            public IStatus run(IProgressMonitor monitor) {
                ReportViewerDialog.this.errorTitle = "";
                ReportViewerDialog.this.errorMsg = "";
                ReportViewerDialog.this.listPrintStyles = new ArrayList<StyleRange>();
                ReportViewerDialog.this.listHeaderStyles = new ArrayList<StyleRange>();
                ReportViewerDialog.this.listBodyStyles = new ArrayList<StyleRange>();
                ReportViewerDialog.this.stylingHeader = new StringBuilder();
                ReportViewerDialog.this.stylingBody = new StringBuilder();
                String reportLocation = "";
                String reportName = "";
                if (ReportViewerDialog.this.rptfile.length() > 0) {
                    reportLocation = new File(ReportViewerDialog.this.rptfile).getAbsolutePath();
                } else {
                    IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
                    CorePlugin.getDefault();
                    reportLocation = new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + ReportViewerDialog.this.stcid + File.separator + ReportViewerDialog.this.reqnum + File.separator + Platform.getNL() + File.separator + ReportViewerDialog.this.rptid + "-base.txt").getAbsolutePath();
                    reportName = ReportViewerDialog.this.rptid;
                    String cfr_ignored_0 = String.valueOf(reportLocation) + reportName;
                }
                ReportViewerDialog.this.pv = new pvmlReader();
                ReportViewerDialog.this.pv.rvd = ReportViewerDialog.this.rvd;
                ReportViewerDialog.this.pv.monitor = monitor;
                try {
                    if (ReportViewerDialog.this.sortactivelink.length() > 0) {
                        monitor.beginTask(String.valueOf(Messages.getString("ReportDetailDialog.Job.Task.Sorting")) + ReportViewerDialog.this.rptid + Messages.getString("ReportDetailDialog.Job.Task.Report"), 100);
                        ReportViewerDialog.this.pvsort = new pvmlSort();
                        ReportViewerDialog.this.pvsort.monitor = monitor;
                        ReportViewerDialog.this.pvsort.sortPvml(ReportViewerDialog.this.reqnum, ReportViewerDialog.this.rptid, new Integer(ReportViewerDialog.this.sortactivelink), ReportViewerDialog.this.sortvalue, ReportViewerDialog.this.sortpi, ReportViewerDialog.this.stcid);
                        ReportViewerDialog.this.activelink = ReportViewerDialog.this.contextbodylink;
                        if (ReportViewerDialog.this.contextheaderlink.length() > 0) {
                            ReportViewerDialog.this.activelink = "0";
                        }
                        ReportViewerDialog.this.contextheaderlink = "";
                        ReportViewerDialog.this.contextbodylink = "";
                        ReportViewerDialog.this.sortactivelink = "";
                        ReportViewerDialog.this.sortvalue = "";
                        ReportViewerDialog.this.sortpi = "";
                        ReportViewerDialog.this.pvsort = null;
                        System.gc();
                    } else if (ReportViewerDialog.this.activelink.length() > 0) {
                        ReportViewerDialog.this.pvec = new pvmlExpandCollapse();
                        ReportViewerDialog.this.pvec.pvmlExpand(ReportViewerDialog.this.reqnum, ReportViewerDialog.this.rptid, new Integer(ReportViewerDialog.this.activelink));
                        ReportViewerDialog.this.pvec = null;
                    }
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    monitor.beginTask(String.valueOf(Messages.getString("ReportDetailDialog.Job.Task.Loading")) + ReportViewerDialog.this.rptid + Messages.getString("ReportDetailDialog.Job.Task.Report"), 100);
                    ReportViewerDialog.this.pv.processReport(reportLocation, " " + ReportViewerDialog.this.printTitle, false);
                    if (ReportViewerDialog.this.pv.errmsg.length() > 0) {
                        ReportViewerDialog.this.errorTitle = Messages.getString("ReportDetailDialog.MessageDialog.errorTitle.Exception");
                        ReportViewerDialog.this.errorMsg = String.valueOf(Messages.getString("ReportDetailDialog.MessageDialog.errorMessage.ParsingError")) + ReportViewerDialog.this.pv.errmsg;
                        return Status.CANCEL_STATUS;
                    }
                }
                catch (OutOfMemoryError oem) {
                    String logstr = "loadReportJob:  pvmlReader processReport out of memory exception " + oem;
                    System.out.println("ReportViewerDialog " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                    ReportViewerDialog.this.errorTitle = Messages.getString("ReportDetailDialog.MessageDialog.errorTitle.OEM");
                    ReportViewerDialog.this.errorMsg = String.valueOf(Messages.getString("ReportDetailDialog.MessageDialog.errorMessage.LoadReportOEM")) + ReportViewerDialog.this.printTitle;
                    return Status.CANCEL_STATUS;
                }
                catch (Exception ex) {
                    String logstr = "loadReportJob:  pvmlReader processReport exception " + ex;
                    System.out.println("ReportViewerDialog " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                    ReportViewerDialog.this.errorTitle = Messages.getString("ReportDetailDialog.MessageDialog.errorTitle.Exception");
                    ReportViewerDialog.this.errorMsg = String.valueOf(Messages.getString("ReportDetailDialog.MessageDialog.errorMessage.ParsingError")) + ex;
                    return Status.CANCEL_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        jobA.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("Loading Report Job completed successfully");
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ReportViewerDialog.this.loadReportData();
                        }
                    });
                } else {
                    System.out.println("Loading Report Job did not complete successfully");
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).ReportViewerDialog.this.errorMsg.length() > 0) {
                                MessageDialog.openError((Shell)(this).ReportViewerDialog.this.textViewer.getShell(), (String)(this).ReportViewerDialog.this.errorTitle, (String)(this).ReportViewerDialog.this.errorMsg);
                                ReportViewerDialog.this.clearObjs();
                            }
                        }
                    });
                }
            }
        });
        jobA.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        jobA.setUser(true);
        jobA.schedule();
    }

    private void loadReportData() {
        try {
            this.reportLabel.setText(this.pv.PVMLHeader.toString());
            if (this.activelink.length() > 0) {
                this.reportLabel.replaceStyleRanges(0, this.reportLabel.getText().length(), this.listHeaderStyles.toArray(new StyleRange[this.listHeaderStyles.size()]));
            } else {
                this.reportLabel.setStyleRanges(this.listHeaderStyles.toArray(new StyleRange[this.listHeaderStyles.size()]));
            }
            this.activelinksHeader = this.stylingHeader.toString().split(",");
            this.listHeaderStyles = null;
            this.pv.PVMLHeader = null;
            this.stylingHeader = null;
            String pvmlBody = this.pv.PVMLBody.toString();
            this.pv.PVMLBody = null;
            this.textViewer.setText(pvmlBody);
            if (this.activelink.length() > 0) {
                this.textViewer.replaceStyleRanges(0, this.textViewer.getText().length(), this.listBodyStyles.toArray(new StyleRange[this.listBodyStyles.size()]));
            } else {
                this.textViewer.setStyleRanges(this.listBodyStyles.toArray(new StyleRange[this.listBodyStyles.size()]));
            }
            this.activelinksBody = this.stylingBody.toString().split(",");
            this.listBodyStyles = null;
            this.stylingBody = null;
            this.printPVML = this.pv.PVMLPrint.toString();
            this.pv.PVMLPrint = null;
            if (this.detailList.length() > 0) {
                String detailListStr = this.detailList.toString();
                this.detailOffsets = detailListStr.split(",");
                this.detailList = null;
                this.detailList = new StringBuilder();
            }
            this.clearObjs();
            this.scrollLine();
            this.reportLabel.setVisible(true);
            this.textViewer.setVisible(true);
            this.textViewer.setFocus();
            this.rpttitle.setText(this.reportTitle);
            this.toolbarComp.layout(true);
            this.client.layout(true);
        }
        catch (OutOfMemoryError oem) {
            String logstr = "loadReportData:  out of memory exception " + oem;
            System.out.println("ReportViewerDialog " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            MessageDialog.openError((Shell)this.textViewer.getShell(), (String)Messages.getString("ReportDetailDialog.MessageDialog.errorTitle.OEM"), (String)(String.valueOf(Messages.getString("ReportDetailDialog.MessageDialog.errorMessage.LoadReportOEM")) + this.printTitle));
            this.clearObjs();
        }
        catch (Exception ex) {
            String logstr = "loadReportData:  report load exception " + ex;
            System.out.println("ReportViewerDialog " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            this.clearObjs();
        }
    }

    public void setReportStyle(String listtype) throws Exception, OutOfMemoryError {
        if (listtype.equalsIgnoreCase("body")) {
            this.listBodyStyles.add(this.stylerange);
        } else if (listtype.equalsIgnoreCase("header")) {
            this.listHeaderStyles.add(this.stylerange);
        } else {
            this.listPrintStyles.add(this.printstylerange);
        }
    }

    public void setNewReportStyleRange() throws Exception, OutOfMemoryError {
        this.stylerange = new StyleRange();
    }

    public void setNewPrintStyleRange() throws Exception, OutOfMemoryError {
        this.printstylerange = new StyleRange();
    }

    public void setReportStyleRange(String fred, String sectiontype, int pageOffset, int printPageOffset, String detailOffset) throws Exception, OutOfMemoryError {
        String[] styleArray = this.s1.split(fred, -1);
        try {
            this.setNewReportStyleRange();
            this.setNewPrintStyleRange();
        }
        catch (OutOfMemoryError oem) {
            String logstr = "setReportStyleRange:  setNewReportStyleRange, setNewPrintStyleRange out of memory exception " + oem;
            System.out.println("ReportViewerDialog " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            throw oem;
        }
        catch (Exception e) {
            String logstr = "setReportStyleRange:  setNewReportStyleRange, setNewPrintStyleRange exception " + e;
            System.out.println("ReportViewerDialog " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            throw e;
        }
        this.stylerange.start = new Integer(styleArray[0]) + pageOffset;
        this.printstylerange.start = new Integer(styleArray[0]) + printPageOffset;
        this.stylerange.length = new Integer(styleArray[1]);
        this.printstylerange.length = new Integer(styleArray[1]);
        if (!CorePlugin.getDefault().getPreferenceStore().getBoolean("colorMonochrome")) {
            this.stylerange.foreground = this.getColorCode(styleArray[2]);
            this.printstylerange.foreground = this.getColorCode(styleArray[2]);
            if (styleArray[3].length() > 0) {
                this.stylerange.background = this.getColorCode(styleArray[3]);
                this.printstylerange.background = this.getColorCode(styleArray[3]);
            }
        }
        if (styleArray[4].equals("true")) {
            this.stylerange.underline = true;
            this.stylerange.underlineStyle = this.underlineStyle;
            this.printstylerange.underline = true;
            this.printstylerange.underlineStyle = this.underlineStyle;
        }
        if (styleArray[5].equals("true")) {
            this.stylerange.fontStyle = 1;
            this.printstylerange.fontStyle = 1;
        }
        if (styleArray[6].length() > 0) {
            if (sectiontype.equals("S")) {
                if (this.stylingHeader.length() > 0) {
                    this.stylingHeader.append(",");
                }
                this.stylingHeader.append(String.valueOf(this.stylerange.start) + "|" + this.stylerange.length + "|" + styleArray[6]);
            } else {
                if (this.stylingBody.length() > 0) {
                    this.stylingBody.append(",");
                }
                this.stylingBody.append(String.valueOf(this.stylerange.start) + "|" + this.stylerange.length + "|" + styleArray[6]);
                if (styleArray[6].equals(this.activelink)) {
                    this.linenum = this.stylerange.start;
                }
                if (detailOffset.length() > 0) {
                    this.detailList = this.detailList.append(String.valueOf(styleArray[6]) + "|" + detailOffset + ",");
                }
            }
        }
        try {
            if (sectiontype.equals("S")) {
                this.setReportStyle("header");
            } else {
                this.setReportStyle("body");
            }
            this.setReportStyle("print");
        }
        catch (OutOfMemoryError oem) {
            String logstr = "setReportStyleRange:  setReportStyleRange out of memory exception " + oem;
            System.out.println("ReportViewerDialog " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            throw oem;
        }
        catch (Exception e) {
            String logstr = "setReportStyleRange:  setReportStyle exception " + e;
            System.out.println("ReportViewerDialog " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            throw e;
        }
    }

    public void clearObjs() {
        this.pv = null;
        this.listHeaderStyles = null;
        this.listBodyStyles = null;
        this.contextheaderlink = "";
        this.contextbodylink = "";
        this.sortactivelink = "";
        this.sortvalue = "";
        System.gc();
    }

    private void scrollLine() {
        int incr = Math.abs(this.textViewer.getClientArea().height / this.textViewer.getVerticalBar().getIncrement() / 2);
        int curline = this.textViewer.getLineAtOffset(this.linenum);
        int scrollline = curline + incr;
        if (this.textViewer.getLineCount() <= scrollline) {
            scrollline = this.textViewer.getLineCount() - 1;
        }
        if (scrollline < 0) {
            scrollline = 0;
        }
        this.textViewer.setSelection(this.textViewer.getOffsetAtLine(scrollline));
        this.textViewer.setSelection(new Integer(this.linenum).intValue());
        this.getLineColumn();
    }

    private void showMessage(String title, String message) {
        MessageDialog.openInformation((Shell)this.textViewer.getShell(), (String)title, (String)message);
    }

    private void showErrorMessage(String title, String message) {
        MessageDialog.openError((Shell)this.textViewer.getShell(), (String)title, (String)message);
    }

    private File getSaveReport() {
        boolean runSaveDialog = true;
        String filename = String.valueOf(CorePlugin.getDefault().productextension.getProductPrefix()) + "_" + this.stcid + "_" + this.sreqnum + "_" + this.rptid + "_Detail";
        File file = null;
        FileDialog dialog = null;
        while (runSaveDialog) {
            dialog = new FileDialog(this.textViewer.getShell(), 8192);
            dialog.setFilterNames(new String[]{"Text Documents (*.txt)", "Html Documents (*.html)", "All Files (*.*)"});
            dialog.setFilterExtensions(new String[]{"*.txt", "*.html", "*.*"});
            dialog.setFilterPath(CorePlugin.getDefault().getPreferenceStore().getString("saveReportPath"));
            dialog.setFileName(filename);
            dialog.setText(Messages.getString("ReportDetailDialog.Dialog.Text.SaveReport"));
            filename = dialog.open();
            if (filename != null) {
                file = new File(filename);
                if (file.exists()) {
                    if (MessageDialog.openConfirm((Shell)this.textViewer.getShell(), (String)Messages.getString("ReportDetailDialog.ConfirmDialog.ConfirmTitle.ReplaceFile"), (String)(String.valueOf(Messages.getString("ReportDetailDialog.ConfirmDialog.ConfirmMessage.Replace")) + filename + "?"))) {
                        runSaveDialog = false;
                        continue;
                    }
                    file = null;
                    dialog = null;
                    continue;
                }
                runSaveDialog = false;
                continue;
            }
            runSaveDialog = false;
        }
        dialog = null;
        return file;
    }

    private void findText() {
        String st = this.finddialog.rvd.textViewer.getText();
        if (!this.finddialog.caseCheck.getSelection()) {
            st = st.toLowerCase();
        }
        int startloc = 0;
        if (this.finddialog.finddir.equals("up")) {
            startloc = st.length();
        }
        int newloc = startloc;
        if (CorePlugin.getDefault().getPreferenceStore().getString("findText").length() <= 0) {
            return;
        }
        String findtext = this.finddialog.findText.getText().trim();
        if (!this.finddialog.caseCheck.getSelection()) {
            if (!findtext.equalsIgnoreCase(this.finddialog.rvd.searchtxt)) {
                this.finddialog.rvd.searchloc = startloc;
            }
        } else if (!findtext.equals(this.finddialog.rvd.searchtxt)) {
            this.finddialog.rvd.searchloc = startloc;
        }
        String dialogsearchtxt = this.finddialog.rvd.searchtxt = CorePlugin.getDefault().getPreferenceStore().getString("findText");
        if (!this.finddialog.caseCheck.getSelection()) {
            dialogsearchtxt = dialogsearchtxt.toLowerCase();
        }
        String searchtxtlc = this.finddialog.rvd.searchtxt;
        if (!this.finddialog.caseCheck.getSelection()) {
            searchtxtlc = searchtxtlc.toLowerCase();
        }
        if (this.finddialog.rvd.searchloc == startloc) {
            newloc = this.finddialog.finddir.equals("up") ? st.lastIndexOf(searchtxtlc, this.finddialog.rvd.searchloc) : st.indexOf(searchtxtlc, this.finddialog.rvd.searchloc);
            if (newloc < 0) {
                this.showMessage(Messages.getString("ReportDetailDialog.MessageDialog.infoTitle.FindResults"), String.valueOf(Messages.getString("ReportDetailDialog.MessageDialog.infoMessage.CannotFind")) + this.finddialog.rvd.searchtxt + "\"");
                this.finddialog.rvd.textViewer.setSelection(0);
                return;
            }
            this.finddialog.rvd.searchloc = newloc;
        } else {
            newloc = this.finddialog.finddir.equals("up") ? st.lastIndexOf(searchtxtlc, this.finddialog.rvd.searchloc - 1) : st.indexOf(searchtxtlc, this.finddialog.rvd.searchloc + 1);
            if (newloc < 0) {
                this.showMessage(Messages.getString("ReportDetailDialog.MessageDialog.infoTitle.FindResults"), String.valueOf(Messages.getString("ReportDetailDialog.MessageDialog.infoMessage.CannotFind")) + this.finddialog.rvd.searchtxt + "\"");
                newloc = this.finddialog.rvd.searchloc;
            }
            this.finddialog.rvd.searchloc = newloc;
        }
        this.finddialog.rvd.searchloc = newloc;
        this.finddialog.rvd.textViewer.setSelection(this.finddialog.rvd.searchloc, this.finddialog.rvd.searchloc + this.finddialog.rvd.searchtxt.length());
        this.finddialog.rvd.textViewer.setFocus();
        this.getLineColumn();
        CorePlugin.getDefault().getPreferenceStore().setValue("findText", "");
    }

    public int getShellStyle() {
        return 3312;
    }

    private void saveasHtmlFile(File fileto) {
        if (this.buildHtml() < 0) {
            return;
        }
        try {
            File filefrom = new File(String.valueOf(this.reportPath) + this.rptid + this.htmlsuffix + ".html");
            FileChannel srcChannel = new FileInputStream(filefrom).getChannel();
            FileChannel dstChannel = new FileOutputStream(fileto).getChannel();
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            srcChannel.close();
            dstChannel.close();
            this.activelink = "";
            this.linenum = 0;
        }
        catch (IOException e) {
            String logstr = "saveasHtml:  from " + this.reportPath + this.rptid + this.htmlsuffix + ".html" + " to " + fileto.getAbsolutePath() + " IOException " + e;
            System.out.println("ReportViewerDialog " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    private void saveasTextFile(File file) {
        try {
            FileOutputStream outputStream2 = new FileOutputStream(file);
            PrintStream sysout = new PrintStream((OutputStream)outputStream2, true, "UTF-8");
            sysout.print(this.textViewer.getText().replace("\n", "\r\n"));
            outputStream2.close();
            outputStream2 = null;
            sysout = null;
        }
        catch (OutOfMemoryError oem) {
            String logstr = "saveAction:  out of memory exception " + oem;
            System.out.println("ReportViewerDialog " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            MessageDialog.openError((Shell)this.textViewer.getShell(), (String)Messages.getString("ReportDetailDialog.MessageDialog.errorTitle.OEM"), (String)(String.valueOf(Messages.getString("ReportDetailDialog.MessageDialog.errorMessage.SaveReportOEM")) + this.printTitle));
            this.clearObjs();
        }
        catch (Exception e) {
            String logstr = "saveAction:  exception " + e;
            System.out.println("ReportViewerDialog " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            MessageDialog.openError((Shell)this.textViewer.getShell(), (String)Messages.getString("ReportDetailDialog.MessageDialog.errorTitle.SaveError"), (String)e.getLocalizedMessage());
        }
    }

    private int buildHtml() {
        int rc = 0;
        String errmsg = "";
        ReportHtmlBuilder htmlbuilder = new ReportHtmlBuilder();
        try {
            htmlbuilder.buildHtmlFile(this.reportPath, this.rptid, "-base", String.valueOf(this.rptid) + this.htmlsuffix + ".html", String.valueOf(this.printTitle) + "\n\n");
        }
        catch (OutOfMemoryError oem) {
            String logstr = "buildHtml:  Out of Memory exception building html: " + this.reportPath + this.rptid + ". " + oem;
            System.out.println("ReportViewerDialog - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            errmsg = oem.getLocalizedMessage();
            rc = -1;
        }
        catch (IOException e) {
            String logstr = "buildHtml:  IO exception building html: " + this.reportPath + this.rptid + ". " + e;
            System.out.println("ReportViewerDialog - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            errmsg = e.getLocalizedMessage();
            rc = -1;
        }
        catch (Exception e) {
            String logstr = "buildHtml:  Exception building html: " + this.reportPath + this.rptid + ". " + e;
            System.out.println("ReportViewerDialog - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            errmsg = e.getLocalizedMessage();
            rc = -1;
        }
        if (rc < 0) {
            MessageDialog.openError((Shell)this.textViewer.getShell(), (String)Messages.getString("ReportDetailDialog.MessageDialog.errorTitle.ReportError"), (String)errmsg);
        }
        return rc;
    }

    public void launchHtmlJob() {
        Job jobA = new Job(Messages.getString("ReportDetailDialog.Job.Title.LoadingHtmlReport")){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    String logstr = "launchHtmlJob:  launching html report " + ReportViewerDialog.this.reportPath + ReportViewerDialog.this.rptid + ReportViewerDialog.this.htmlsuffix + ".html";
                    System.out.println("ReportViewerDialog " + logstr);
                    CorePlugin.getDefault().log.debug(logstr);
                    File htmlFile = new File(String.valueOf(ReportViewerDialog.this.reportPath) + ReportViewerDialog.this.rptid + ReportViewerDialog.this.htmlsuffix + ".html");
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(htmlFile.toURI().toURL());
                }
                catch (Exception ex) {
                    String logstr = "launchHtmlJob: Error launching html file " + ReportViewerDialog.this.reportPath + ReportViewerDialog.this.rptid + ReportViewerDialog.this.htmlsuffix + ".html" + ", Exception - " + ex;
                    System.out.println("ReportViewerDialog - " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                }
                return Status.OK_STATUS;
            }
        };
        jobA.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("Launch Html Job completed successfully");
                } else {
                    System.out.println("Launch Html Job did not complete successfully");
                }
            }
        });
        jobA.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        jobA.setUser(true);
        jobA.schedule();
    }

    private void doOpenReport() {
        this.rptfile = this.openReportFile();
        if (this.rptfile.length() > 0) {
            this.reportTitle = this.rptfile = this.rptfile;
            this.loadReportJob();
        }
    }

    public String openReportFile() {
        boolean runOpenReportDialog = true;
        String filename = "";
        FileDialog dialog = null;
        while (runOpenReportDialog) {
            dialog = new FileDialog(this.shell, 4096);
            dialog.setFilterPath(CorePlugin.getDefault().getPreferenceStore().getString("saveReportPath"));
            dialog.setFilterNames(new String[]{"Text Documents (*.txt)", "All Files (*.*)"});
            dialog.setFilterExtensions(new String[]{"*.txt", "*.*"});
            File file = new File(this.rptfile);
            if (file.exists()) {
                dialog.setFileName(file.getName());
                dialog.setFilterPath(file.getAbsolutePath());
            }
            dialog.setText(Messages.getString("ReportViewerDialog.Text.OpenReportFile"));
            filename = dialog.open();
            if (filename != null) {
                file = new File(filename);
                runOpenReportDialog = false;
                continue;
            }
            runOpenReportDialog = false;
            this.rptfile = "";
        }
        dialog = null;
        return filename;
    }

    private void buildMenubar(Shell newShell) {
        Menu bar = new Menu((Decorations)newShell, 2);
        newShell.setMenuBar(bar);
        MenuItem fileItem = new MenuItem(bar, 64);
        fileItem.setText(Messages.getString("ReportViewerDialog.Menu.File"));
        Menu submenu = new Menu((Decorations)newShell, 4);
        fileItem.setMenu(submenu);
        MenuItem item = new MenuItem(submenu, 8);
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ReportViewerDialog.this.doOpenReport();
            }
        });
        item.setText(Messages.getString("ReportViewerDialog.Action.OpenReport"));
        item = new MenuItem(submenu, 2);
        MenuItem saveitem = new MenuItem(submenu, 8);
        saveitem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ReportViewerDialog.this.saveAction.run();
            }
        });
        saveitem.setText(Messages.getString("ReportViewerDialog.Action.SaveAs"));
        saveitem.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/saveas_edit.gif").createImage());
        saveitem.setAccelerator(262227);
        item = new MenuItem(submenu, 2);
        MenuItem printitem = new MenuItem(submenu, 8);
        printitem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ReportViewerDialog.this.printAction.run();
            }
        });
        printitem.setText(Messages.getString("ReportViewerDialog.Action.Print"));
        printitem.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/print_edit.gif").createImage());
        printitem.setAccelerator(262224);
        item = new MenuItem(submenu, 2);
        MenuItem exititem = new MenuItem(submenu, 8);
        exititem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ReportViewerDialog.this.close();
            }
        });
        exititem.setText(Messages.getString("ReportViewerDialog.Action.Exit"));
        MenuItem editItem = new MenuItem(bar, 64);
        editItem.setText(Messages.getString("ReportViewerDialog.Menu.Edit"));
        submenu = new Menu((Decorations)newShell, 4);
        editItem.setMenu(submenu);
        MenuItem copyitem = new MenuItem(submenu, 8);
        copyitem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ReportViewerDialog.this.copyAction.run();
            }
        });
        copyitem.setText(Messages.getString("ReportDetailDialog.Action.Copy"));
        copyitem.setAccelerator(262211);
        copyitem.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/copy_edit.gif").createImage());
        item = new MenuItem(submenu, 2);
        MenuItem selectallitem = new MenuItem(submenu, 8);
        selectallitem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ReportViewerDialog.this.selectAllAction.run();
            }
        });
        selectallitem.setText(Messages.getString("ReportDetailDialog.Action.SelectAll"));
        selectallitem.setAccelerator(262209);
        item = new MenuItem(submenu, 2);
        MenuItem finditem = new MenuItem(submenu, 8);
        finditem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ReportViewerDialog.this.findAction.run();
            }
        });
        finditem.setText(Messages.getString("ReportViewerDialog.Action.Find"));
        finditem.setAccelerator(262214);
        finditem.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/search_src.gif").createImage());
    }

    public boolean close() {
        this.dispose();
        super.close();
        return true;
    }

    public void dispose() {
        this.viewerFont.dispose();
        this.imgRptGreen.dispose();
    }
}

