/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs.reports;

import com.banknet.core.CorePlugin;
import com.banknet.core.dialogs.reports.Messages;
import com.banknet.core.dialogs.reports.OptionEditorDialog;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.VersionCompatibilityExtension;
import com.banknet.core.models.ReportsModel;
import java.util.regex.Pattern;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.w3c.dom.Document;

public class ReportOptionsDialog
extends TrayDialog {
    private VersionCompatibilityExtension compat = new VersionCompatibilityExtension();
    private Constants constants = new Constants();
    Shell shell;
    private TableViewer table;
    public String optionprefs = "";
    public String rptid = "";
    String reportCategory = "";
    ReportsModel report;
    Document reportsdoc;
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);
    String rptformat = "";
    Composite content;
    Composite content1;
    private Button editOptionButton;
    private Action doubleClickAction;
    String errmsg = "";
    Image imgRptGreen = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/msGreen.gif").createImage();

    public ReportOptionsDialog(Shell parentShell) {
        super(parentShell);
        this.shell = parentShell;
        this.reportsdoc = CorePlugin.getDefault().reportsdoc;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.valueOf(this.rptid) + " " + Messages.getString("ReportOptionsDialog.ShellTitle"));
        newShell.setImage(this.imgRptGreen);
        this.report = CorePlugin.getDefault().reports.get(CorePlugin.getDefault().reportId.indexOf(this.rptid));
        this.reportCategory = this.report.parent.reportid;
        this.optionprefs = this.report.optionprefs;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".dialogs_ReportOptionsContext");
    }

    protected Control createDialogArea(Composite parent) {
        this.content = new Composite(parent, 0);
        GridLayout layout1 = new GridLayout(1, false);
        this.content.setLayout((Layout)layout1);
        GridData gd3 = new GridData(4, 4, true, true, 1, 1);
        this.content.setLayoutData((Object)gd3);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.content, String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".dialogs_ReportOptionsContext");
        this.content1 = this.content;
        ((GridLayout)this.content1.getLayout()).numColumns = 1;
        GridData gd2 = new GridData(4, 4, true, true, 2, 1);
        this.content1.setLayoutData((Object)gd2);
        Composite g2 = new Composite(this.content1, 0);
        g2.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        g2.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(4, 4, true, true);
        this.table = new TableViewer(g2, 66306);
        this.table.getTable().setHeaderVisible(true);
        this.table.getTable().setLinesVisible(true);
        this.table.getTable().setLayoutData((Object)gd);
        this.table.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.table.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (ReportOptionsDialog.this.table.getTable().getItem(new Point(e.x, e.y)) == null) {
                    ReportOptionsDialog.this.table.getTable().deselectAll();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] items;
                if (!(ReportOptionsDialog.this.reportCategory.equals(((ReportOptionsDialog)ReportOptionsDialog.this).constants.REPORT_CATEGORY_VARIANCE) | CorePlugin.getDefault().versionextension.chkIsMultiAddr(ReportOptionsDialog.this.rptid, ReportOptionsDialog.this.reportCategory)) && (items = ReportOptionsDialog.this.table.getTable().getSelection()).length > 0) {
                    String opt = ReportOptionsDialog.this.getOptionLabel("getvalue", items[0].getText(0));
                    String val = items[0].getText(1);
                    if (opt.equalsIgnoreCase("sequence")) {
                        val = ReportOptionsDialog.this.getSortLabel("getvalue", val);
                    }
                    ReportOptionsDialog.this.editOption(opt, val);
                }
            }
        });
        TableColumn column = new TableColumn(this.table.getTable(), 16384);
        column.setToolTipText(Messages.getString("ReportOptionsDialog.OptionsColumn.Tooltip.Option"));
        column.setText(Messages.getString("ReportOptionsDialog.OptionsColumn.Option"));
        column = new TableColumn(this.table.getTable(), 16384);
        column.setToolTipText(Messages.getString("ReportOptionsDialog.OptionsColumn.Tooltip.Value"));
        column.setText(Messages.getString("ReportOptionsDialog.OptionsColumn.Value"));
        TableColumnLayout tableLayout = new TableColumnLayout();
        g2.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)this.table.getTable().getColumn(0), (ColumnLayoutData)new ColumnWeightData(40));
        tableLayout.setColumnData((Widget)this.table.getTable().getColumn(1), (ColumnLayoutData)new ColumnWeightData(60));
        g2.layout(false);
        this.editOptionButton = new Button(this.content1, 8);
        this.editOptionButton.setText(Messages.getString("ReportOptionsDialog.Button.Edit"));
        GridData gdb = new GridData(1, 1, true, false);
        gdb.horizontalIndent = 5;
        gdb.widthHint = 85;
        this.editOptionButton.setLayoutData((Object)gdb);
        this.editOptionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = ReportOptionsDialog.this.table.getTable().getSelection();
                if (items.length > 0) {
                    String opt = ReportOptionsDialog.this.getOptionLabel("getvalue", items[0].getText(0));
                    String val = items[0].getText(1);
                    if (opt.equalsIgnoreCase("sequence")) {
                        val = ReportOptionsDialog.this.getSortLabel("getvalue", val);
                    }
                    ReportOptionsDialog.this.editOption(opt, val);
                }
            }
        });
        this.loadOptionPreferences();
        this.makeActions();
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        GridData gd = new GridData(1, 0, false, false, 1, 1);
        client.setLayoutData((Object)gd);
        client.setLayout((Layout)layout);
        Composite tbclient = new Composite(client, 0);
        layout = new GridLayout(3, false);
        gd = new GridData(131072, 1024, true, true, 1, 1);
        tbclient.setLayoutData((Object)gd);
        tbclient.setLayout((Layout)layout);
        ToolBar toolBar = new ToolBar(tbclient, 0x880000);
        ++((GridLayout)parent.getLayout()).numColumns;
        GridData gd2 = new GridData(1, 0, true, false, 1, 1);
        toolBar.setLayoutData((Object)gd2);
        final Cursor cursor = new Cursor((Device)parent.getDisplay(), 21);
        toolBar.setCursor(cursor);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                cursor.dispose();
            }
        });
        this.createButton(tbclient, 0, "OK", false);
        this.createButton(tbclient, 1, "Cancel", false);
    }

    public void okPressed() {
        this.report.optionprefs = this.optionprefs;
        this.dispose();
        this.setReturnCode(0);
        this.close();
    }

    public void cancelPressed() {
        this.dispose();
        this.setReturnCode(1);
        this.close();
    }

    public void dispose() {
        this.imgRptGreen.dispose();
    }

    private void makeActions() {
        this.doubleClickAction = new Action(){

            public void run() {
            }
        };
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
        }
    }

    public int getShellStyle() {
        return 134384;
    }

    private void editOption(String optid, String optval) {
        OptionEditorDialog editopt;
        boolean exitedit = false;
        String selrptid = this.rptid;
        String seloptid = optid;
        String seloptval = optval;
        this.optionprefs = this.optionprefs;
        while (!exitedit) {
            editopt = new OptionEditorDialog(this.table.getTable().getShell());
            OptionEditorDialog.doc = this.reportsdoc;
            editopt.rptid = selrptid;
            editopt.optid = seloptid;
            editopt.optval = seloptval;
            editopt.options = this.optionprefs;
            editopt.optionslabels = this.report.optionslabels;
            int editoptrc = editopt.open();
            if (editoptrc == 0) {
                this.optionprefs = editopt.options;
                this.loadOptionPreferences();
                this.setOptionSelected(editopt.optid);
                exitedit = true;
                continue;
            }
            if (editoptrc == 1) {
                exitedit = true;
                continue;
            }
            this.optionprefs = editopt.options;
            seloptid = editopt.nextoptid;
            seloptval = editopt.nextoptval;
            this.setOptionSelected(seloptid);
            editopt = null;
        }
        editopt = null;
    }

    private void setOptionSelected(String optid) {
        TableItem[] items = this.table.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getText(0).equals(optid)) {
                this.table.getTable().setSelection(i);
                break;
            }
            ++i;
        }
    }

    private void loadOptionPreferences() {
        String opt = "";
        String enopt = "";
        String val = "";
        String[] options = this.optionprefs.split(",");
        try {
            if (!this.table.getTable().isDisposed()) {
                this.table.getTable().setRedraw(false);
                this.table.getTable().removeAll();
                if (options.length <= 0) {
                    this.table = null;
                } else {
                    int i = 0;
                    while (i < options.length) {
                        if (options[i].length() > 0) {
                            enopt = options[i].substring(0, options[i].indexOf("="));
                            opt = this.getOptionLabel("getlabel", enopt);
                            val = options[i].substring(options[i].indexOf("=") + 1, options[i].length());
                            if (enopt.equalsIgnoreCase("sequence")) {
                                val = this.getSortLabel("getlabel", val);
                            }
                            TableItem tableItem = new TableItem(this.table.getTable(), 0);
                            tableItem.setText(0, opt);
                            tableItem.setText(1, val);
                        }
                        ++i;
                    }
                }
                this.table.getTable().setRedraw(true);
            }
            if (this.table.getTable().getItemCount() > 0) {
                this.table.getTable().setSelection(0);
            }
        }
        catch (Exception ex) {
            System.out.println("loadOptionPreferences exception: " + ex);
        }
    }

    private String getOptionLabel(String req, String val) {
        String optionlabel = val;
        String[] optionslabels = this.report.optionslabels.split(",");
        int i = 0;
        while (i < optionslabels.length) {
            String[] optionslabel = this.s1.split(optionslabels[i], -1);
            if (req.equals("getlabel")) {
                if (val.equals(optionslabel[0])) {
                    return optionslabel[1];
                }
            } else if (val.equals(optionslabel[1])) {
                return optionslabel[0];
            }
            ++i;
        }
        return optionlabel;
    }

    private String getSortLabel(String req, String val) {
        String styleDelimiter1 = "[|]";
        Pattern s1 = Pattern.compile(styleDelimiter1);
        String sortlabel = val;
        String[] sorts = this.report.sortlabels.split(",");
        int i = 0;
        while (i < sorts.length) {
            String[] sortoptions = s1.split(sorts[i], -1);
            if (req.equals("getlabel")) {
                if (val.equals(sortoptions[0])) {
                    return sortoptions[1];
                }
            } else if (val.equals(sortoptions[1])) {
                return sortoptions[0];
            }
            ++i;
        }
        return sortlabel;
    }

    private void showMessage(String title, String message) {
        MessageDialog.openInformation((Shell)this.table.getTable().getShell(), (String)title, (String)message);
    }
}

