/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs.reports;

import com.banknet.core.CorePlugin;
import com.banknet.core.data.reports.ReportHtmlBuilder;
import com.banknet.core.dialogs.reports.FindTextDialog;
import com.banknet.core.dialogs.reports.Messages;
import com.banknet.core.dialogs.spm.SpmSettingsDialog;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.pvmlReader;
import com.banknet.core.models.ReportsModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ReportDetailDialog
extends Dialog {
    public pvmlReader pv;
    Constants constants = new Constants();
    Composite content;
    Shell shell;
    Composite client;
    Composite checkboxgroup;
    Composite combogroup;
    Composite textgroup;
    StyledText textViewer;
    StyledText testStyler;
    public Text findText;
    public Button optionCheck;
    public Button upRadio;
    public Button downRadio;
    public Combo optionCombo;
    public Text optionText;
    public String finddir = "down";
    boolean initialSetup = false;
    public String[] optionsarr = null;
    public String options = "";
    private Action localPullDown;
    private Action saveAction;
    private Action printAction;
    private Action copyAction;
    private Action findAction;
    private Action selectAllAction;
    private Action spmSettingsAction;
    private Action launchHtmlAction;
    ToolBarManager toolBarMgr;
    String reportLocation = "";
    public String stcid = "";
    public String rptid = "";
    public String selectedRptid = "";
    public String reportTitle = "";
    public Integer reqnum = 0;
    String sreqnum = "";
    String reportPath = "";
    String htmlsuffix = "-detail";
    String printTitle = "";
    Cursor arrowCursor;
    List<String> colorStyles = new ArrayList<String>();
    List<Color> colorCodes = new ArrayList<Color>();
    public int searchloc = 0;
    public String searchtxt = "";
    FindTextDialog finddialog;
    ReportDetailDialog rdd = this;
    String reporttext = "";
    FontData displayFont10 = new FontData(Display.getCurrent().getSystemFont().getFontData()[0].getName(), 10, 0);
    FontData displayFont9 = new FontData(Display.getCurrent().getSystemFont().getFontData()[0].getName(), 9, 0);
    FontData defaultFont = new FontData("Lucida Console", 10, 0);
    int underlineStyle = 0;
    public List<StyleRange> listBodyStyles;
    public StyleRange stylerange;
    String activelink = "";
    String[] stra;
    String[] activelinksBody;
    StringBuilder stylingBody;
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);
    String errorTitle = "";
    String errorMsg = "";
    String errmsg = "";
    int linenum = 0;
    boolean doubleclicked = false;
    public String rptline = "";
    public StyleRange[] rptlinestyles;
    String lcmdopt = "";
    final String LCMD_SPM = "P";
    boolean isJavaReport = false;
    Font viewerFont;
    Image imgRptGreen = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/msGreen.gif").createImage();
    private final IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals("findText") && ReportDetailDialog.this.finddialog.rdd != null) {
                ReportDetailDialog.this.findText();
            }
        }
    };
    private IMenuCreator connectMenuCreator = new IMenuCreator(){
        private Menu menu;

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            this.menu = new Menu(parent);
            MenuItem item = new MenuItem(this.menu, 0);
            item.setText(Messages.getString("ReportDetailDialog.Action.LaunchHtml"));
            item.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/obj/generic_element.gif").createImage());
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReportDetailDialog.this.launchHtmlAction.run();
                }
            });
            item = new MenuItem(this.menu, 0);
            item.setText(Messages.getString("ReportDetailDialog.Action.Print"));
            item.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/print_edit.gif").createImage());
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReportDetailDialog.this.printAction.run();
                }
            });
            item = new MenuItem(this.menu, 0);
            item.setText(Messages.getString("ReportDetailDialog.Action.SaveAs"));
            item.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/saveas_edit.gif").createImage());
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReportDetailDialog.this.saveAction.run();
                }
            });
            item = new MenuItem(this.menu, 0);
            item.setText(Messages.getString("ReportDetailDialog.Action.Find"));
            item.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/search_src.gif").createImage());
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReportDetailDialog.this.findAction.run();
                }
            });
            item = new MenuItem(this.menu, 0);
            item.setText(Messages.getString("ReportDetailDialog.Action.SelectAll"));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReportDetailDialog.this.selectAllAction.run();
                }
            });
            item = new MenuItem(this.menu, 0);
            item.setText(Messages.getString("ReportDetailDialog.Action.Copy"));
            item.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/copy_edit.gif").createImage());
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReportDetailDialog.this.copyAction.run();
                }
            });
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            return this.menu;
        }
    };

    public ReportDetailDialog(Shell parentShell, String stcid, String rptid, Integer reqnum, String reportTitle, String lcmdopt, boolean isJavaReport) {
        super(parentShell);
        this.shell = parentShell;
        this.stcid = stcid;
        this.rptid = rptid;
        this.reqnum = reqnum;
        this.reportTitle = reportTitle;
        this.lcmdopt = lcmdopt;
        this.isJavaReport = isJavaReport;
        IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
        CorePlugin.getDefault();
        this.reportPath = String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + stcid + File.separator + reqnum + File.separator + Platform.getNL() + File.separator;
        this.printTitle = reportTitle.replace("(", "(" + stcid + "/");
        String OSenv = System.getProperty("os.name").toLowerCase();
        String fontName = Messages.getString("ReportDetailDialog.FontName");
        if (OSenv.startsWith("linux")) {
            fontName = Messages.getString("ReportDetailDialog.FontName.Linux");
        } else if (OSenv.startsWith("mac")) {
            fontName = Messages.getString("ReportDetailDialog.FontName.Mac");
        }
        int fontHeight = new Integer(Messages.getString("ReportDetailDialog.FontHeight"));
        this.defaultFont = new FontData(fontName, fontHeight, 0);
        this.underlineStyle = new Integer(Messages.getString("ReportDetailDialog.UnderlineStyle"));
        this.viewerFont = new Font((Device)Display.getCurrent(), this.defaultFont);
        this.loadColors();
        IEclipsePreferences preferencesI = InstanceScope.INSTANCE.getNode("com.banknet.core");
        preferencesI.addPreferenceChangeListener(this.preferenceChangeListener);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.reportTitle);
        newShell.setImage(this.imgRptGreen);
        this.sreqnum = CorePlugin.getDefault().constants.reqdecfmt.format(this.reqnum);
        this.makeActions();
    }

    protected Control createDialogArea(Composite parent) {
        this.arrowCursor = new Cursor((Device)parent.getDisplay(), 0);
        this.client = new Composite(parent, 4);
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumWidth = this.lcmdopt.equals("P") ? 750 : 650;
        gd.heightHint = 400;
        this.client.setLayoutData((Object)gd);
        this.client.setLayout((Layout)new GridLayout(1, false));
        this.client.setFont(this.viewerFont);
        this.client.setBackground(Display.getCurrent().getSystemColor(1));
        Composite toolbarComp = new Composite(this.client, 0);
        gd = new GridData(4, 128, true, false);
        toolbarComp.setLayoutData((Object)gd);
        toolbarComp.setLayout((Layout)new GridLayout(1, false));
        if (!CorePlugin.getDefault().getPreferenceStore().getBoolean("colorMonochrome")) {
            toolbarComp.setBackground(this.constants.COLOR_ALT_ROW_GREEN);
        }
        ToolBar toolBar = new ToolBar(toolbarComp, 256);
        this.toolBarMgr = new ToolBarManager(toolBar);
        if (!CorePlugin.getDefault().getPreferenceStore().getBoolean("colorMonochrome")) {
            toolBar.setBackground(this.constants.COLOR_ALT_ROW_GREEN);
        }
        this.toolBarMgr.add((IAction)this.launchHtmlAction);
        this.toolBarMgr.add((IContributionItem)new Separator());
        this.toolBarMgr.add((IAction)this.printAction);
        this.toolBarMgr.add((IAction)this.saveAction);
        this.toolBarMgr.add((IContributionItem)new Separator());
        this.toolBarMgr.add((IAction)this.findAction);
        this.toolBarMgr.add((IAction)this.copyAction);
        this.toolBarMgr.update(true);
        GridData gdb3 = new GridData(131072, 1, true, false, 1, 1);
        toolBar.setLayoutData((Object)gdb3);
        this.textViewer = new StyledText(this.client, 770);
        this.textViewer.setCursor(this.arrowCursor);
        GridData spec = new GridData();
        spec.horizontalAlignment = 4;
        spec.grabExcessHorizontalSpace = true;
        spec.verticalAlignment = 4;
        spec.grabExcessVerticalSpace = true;
        this.textViewer.setLayoutData((Object)spec);
        this.textViewer.setEditable(false);
        Color bg = Display.getDefault().getSystemColor(1);
        this.textViewer.setBackground(bg);
        this.textViewer.setFont(this.viewerFont);
        this.loadReportJob();
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    private void makeActions() {
        this.saveAction = new Action(){

            public void run() {
                try {
                    File file = ReportDetailDialog.this.getSaveReport();
                    if (file != null) {
                        String savefile = file.getName().toLowerCase();
                        if (savefile.contains(".htm")) {
                            ReportDetailDialog.this.saveasHtmlFile(file);
                        } else {
                            ReportDetailDialog.this.saveasTextFile(file);
                        }
                        file = null;
                    }
                }
                catch (Exception e) {
                    String logstr = "saveAction:  exception " + e;
                    System.out.println("ReportTextView " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                    MessageDialog.openError((Shell)ReportDetailDialog.this.textViewer.getShell(), (String)Messages.getString("ReportDetailDialog.MessageDialog.errorTitle.SaveError"), (String)e.getLocalizedMessage());
                }
            }
        };
        this.saveAction.setText(Messages.getString("ReportDetailDialog.Action.SaveAs"));
        this.saveAction.setEnabled(true);
        this.saveAction.setAccelerator(262227);
        this.saveAction.setToolTipText(Messages.getString("ReportDetailDialog.Tooltip.SaveAs"));
        this.saveAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/saveas_edit.gif"));
        this.printAction = new Action(){

            public void run() {
                try {
                    PrintDialog printdialog = new PrintDialog(ReportDetailDialog.this.textViewer.getShell(), 0);
                    PrinterData printdata = printdialog.open();
                    StyledTextPrintOptions printoptions = new StyledTextPrintOptions();
                    printoptions.footer = "\t\t<page>";
                    SimpleDateFormat dtfmt = new SimpleDateFormat("MMM dd yyyy HH:mm:ss");
                    String dt = dtfmt.format(new Date());
                    printoptions.header = String.valueOf(CorePlugin.getDefault().productextension.getPrintHeader()) + "\t\n" + ReportDetailDialog.this.reportTitle + "\t" + dt;
                    printoptions.printTextFontStyle = true;
                    printoptions.printTextForeground = true;
                    printoptions.printTextBackground = true;
                    printoptions.printLineBackground = true;
                    printoptions.jobName = ReportDetailDialog.this.reportTitle;
                    printoptions.printLineBackground = true;
                    if (printdata != null) {
                        Printer printer = new Printer(printdata);
                        Runnable runnable = ReportDetailDialog.this.textViewer.print(printer, printoptions);
                        runnable.run();
                        runnable = null;
                        printer = null;
                    }
                    printdialog = null;
                    printdata = null;
                    Object var3_7 = null;
                }
                catch (OutOfMemoryError oem) {
                    String logstr = "printAction:  out of memory exception " + oem;
                    System.out.println("ReportDetailDialog " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                    MessageDialog.openError((Shell)ReportDetailDialog.this.textViewer.getShell(), (String)Messages.getString("ReportDetailDialog.MessageDialog.errorTitle.OEM"), (String)(String.valueOf(Messages.getString("ReportDetailDialog.MessageDialog.errorMessage.PrintReportOEM")) + ReportDetailDialog.this.reportTitle));
                    ReportDetailDialog.this.clearObjs();
                }
                catch (Exception e) {
                    String logstr = "printAction:  exception " + e;
                    System.out.println("ReportDetailDialog " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                    MessageDialog.openError((Shell)ReportDetailDialog.this.textViewer.getShell(), (String)Messages.getString("ReportDetailDialog.MessageDialog.errorTitle.PrintError"), (String)e.getLocalizedMessage());
                }
            }
        };
        this.printAction.setText(Messages.getString("ReportDetailDialog.Action.Print"));
        this.printAction.setAccelerator(262224);
        this.printAction.setToolTipText(Messages.getString("ReportDetailDialog.Tooltip.Print"));
        this.printAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/print_edit.gif"));
        this.copyAction = new Action(){

            public void run() {
                ReportDetailDialog.this.textViewer.copy();
            }
        };
        this.copyAction.setText(Messages.getString("ReportDetailDialog.Action.Copy"));
        this.copyAction.setAccelerator(262211);
        this.copyAction.setToolTipText(Messages.getString("ReportDetailDialog.Tooltip.Copy"));
        this.copyAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/copy_edit.gif"));
        this.selectAllAction = new Action(){

            public void run() {
                int linelimit = 200000;
                if (ReportDetailDialog.this.textViewer.getLineCount() > linelimit) {
                    ReportDetailDialog.this.showErrorMessage(Messages.getString("ReportDetailDialog.MessageDialog.errorTitle.SelectAll"), String.valueOf(Messages.getString("ReportDetailDialog.MessageDialog.errorMessage.TooManyLines")) + linelimit + ".");
                } else {
                    ReportDetailDialog.this.textViewer.selectAll();
                }
            }
        };
        this.selectAllAction.setText(Messages.getString("ReportDetailDialog.Action.SelectAll"));
        this.selectAllAction.setActionDefinitionId("selectall");
        this.selectAllAction.setAccelerator(262209);
        this.selectAllAction.setToolTipText(Messages.getString("ReportDetailDialog.Tooltip.SelectAll"));
        this.findAction = new Action(){

            public void run() {
                ReportDetailDialog.this.searchtxt = "";
                ReportDetailDialog.this.searchloc = 0;
                ReportDetailDialog.this.finddialog = new FindTextDialog(ReportDetailDialog.this.textViewer.getShell(), ReportDetailDialog.this.rdd);
                ReportDetailDialog.this.finddialog.open();
                ReportDetailDialog.this.finddialog = null;
            }
        };
        this.findAction.setText(Messages.getString("ReportDetailDialog.Action.Find"));
        this.findAction.setAccelerator(262214);
        this.findAction.setToolTipText(Messages.getString("ReportDetailDialog.Tooltip.Find"));
        this.findAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/search_src.gif"));
        this.spmSettingsAction = new Action(){

            public void run() {
                SpmSettingsDialog spmdialog = new SpmSettingsDialog(ReportDetailDialog.this.textViewer.getShell());
                spmdialog.open();
                spmdialog = null;
            }
        };
        this.spmSettingsAction.setText(Messages.getString("ReportDetailDialog.Action.SpmSettings"));
        this.spmSettingsAction.setToolTipText(Messages.getString("ReportDetailDialog.Tooltip.SpmSettings"));
        this.spmSettingsAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/obj/layout_co.gif"));
        this.launchHtmlAction = new Action(){

            public void run() {
                if (ReportDetailDialog.this.buildHtml() >= 0) {
                    ReportDetailDialog.this.launchHtmlJob();
                }
            }
        };
        this.launchHtmlAction.setText(Messages.getString("ReportDetailDialog.Action.LaunchHtml"));
        this.launchHtmlAction.setToolTipText(Messages.getString("ReportDetailDialog.Tooltip.LaunchHtml"));
        this.launchHtmlAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/preview.gif"));
        this.localPullDown = new Action(){

            public void run() {
            }
        };
        this.localPullDown.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/blankicon2x2.gif"));
        this.localPullDown.setEnabled(true);
        this.localPullDown.setMenuCreator(this.connectMenuCreator);
    }

    private void getLineColumn() {
        int caretoffset = this.textViewer.getCaretOffset();
        int linenum = this.textViewer.getLineAtOffset(caretoffset);
        int colnum = this.textViewer.getOffsetAtLine(linenum) - caretoffset;
        colnum = Math.abs(colnum);
    }

    private void loadColors() {
        this.colorStyles.add("gr");
        this.colorCodes.add(new Color(null, 181, 181, 181));
        this.colorStyles.add("r");
        this.colorCodes.add(new Color(null, 238, 99, 99));
        this.colorStyles.add("t");
        this.colorCodes.add(new Color(null, 0, 160, 168));
        this.colorStyles.add("g");
        this.colorCodes.add(new Color(null, 34, 139, 34));
        this.colorStyles.add("y");
        this.colorCodes.add(new Color(null, 255, 185, 15));
        this.colorStyles.add("b");
        this.colorCodes.add(new Color(null, 0, 0, 205));
        this.colorStyles.add("lb");
        this.colorCodes.add(new Color(null, 110, 187, 255));
        this.colorStyles.add("p");
        this.colorCodes.add(new Color(null, 255, 182, 193));
        this.colorStyles.add("lp");
        this.colorCodes.add(new Color(null, 255, 160, 160));
        this.colorStyles.add("red");
        this.colorCodes.add(new Color(null, 255, 0, 0));
        this.colorStyles.add("green");
        this.colorCodes.add(Display.getCurrent().getSystemColor(5));
        this.colorStyles.add("yellow");
        this.colorCodes.add(Display.getCurrent().getSystemColor(7));
        this.colorStyles.add("blue");
        this.colorCodes.add(Display.getCurrent().getSystemColor(9));
        this.colorStyles.add("turquoise");
        this.colorCodes.add(new Color(null, 0, 160, 168));
        this.colorStyles.add("pink");
        this.colorCodes.add(Display.getCurrent().getSystemColor(11));
        this.colorStyles.add("gray");
        this.colorCodes.add(Display.getCurrent().getSystemColor(15));
        this.colorStyles.add("bl");
        this.colorCodes.add(Display.getCurrent().getSystemColor(2));
    }

    private Color getColorCode(String style) {
        int i = 0;
        while (i < this.colorStyles.size()) {
            if (this.colorStyles.get(i).equals(style)) {
                return this.colorCodes.get(i);
            }
            ++i;
        }
        return this.colorCodes.get(this.colorStyles.size() - 1);
    }

    public void loadReportJob() {
        Job jobA = new Job(Messages.getString("ReportDetailDialog.Job.Title.LoadingReport")){

            public IStatus run(IProgressMonitor monitor) {
                ReportDetailDialog.this.errorTitle = "";
                ReportDetailDialog.this.errorMsg = "";
                ReportDetailDialog.this.listBodyStyles = new ArrayList<StyleRange>();
                ReportDetailDialog.this.stylingBody = new StringBuilder();
                IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
                CorePlugin.getDefault();
                String reportLocation = new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + ReportDetailDialog.this.stcid + File.separator + ReportDetailDialog.this.reqnum + File.separator + Platform.getNL() + File.separator + ReportDetailDialog.this.rptid + "-detailbase.txt").getAbsolutePath();
                String reportName = ReportDetailDialog.this.rptid;
                String cfr_ignored_0 = String.valueOf(reportLocation) + reportName;
                ReportDetailDialog.this.pv = new pvmlReader();
                ReportDetailDialog.this.pv.rdd = ReportDetailDialog.this.rdd;
                ReportDetailDialog.this.pv.monitor = monitor;
                try {
                    monitor.beginTask(String.valueOf(Messages.getString("ReportDetailDialog.Job.Task.Loading")) + ReportDetailDialog.this.rptid + Messages.getString("ReportDetailDialog.Job.Task.Report"), 100);
                    ReportDetailDialog.this.pv.processReport(reportLocation, " " + ReportDetailDialog.this.reportTitle, false);
                }
                catch (OutOfMemoryError oem) {
                    ReportDetailDialog.this.errorTitle = "Out of Memory Error";
                    ReportDetailDialog.this.errorMsg = "Insufficient memory to load report  " + ReportDetailDialog.this.reportTitle;
                    String logstr = "loadReportJob:  pvmlReader processReport out of memory exception " + oem;
                    System.out.println("ReportDetailDialog " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                    return Status.CANCEL_STATUS;
                }
                catch (Exception ex) {
                    ReportDetailDialog.this.errorTitle = "Exception Error";
                    ReportDetailDialog.this.errorMsg = "Exception error parsing report: \n" + ex;
                    String logstr = "loadReportJob:  pvmlReader processReport exception " + ex;
                    System.out.println("ReportDetailDialog " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                    return Status.CANCEL_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        jobA.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("Loading Report Job completed successfully");
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ReportDetailDialog.this.loadReportData();
                        }
                    });
                } else {
                    System.out.println("Loading Report Job did not complete successfully");
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).ReportDetailDialog.this.errorMsg.length() > 0) {
                                MessageDialog.openError((Shell)(this).ReportDetailDialog.this.textViewer.getShell(), (String)(this).ReportDetailDialog.this.errorTitle, (String)(this).ReportDetailDialog.this.errorMsg);
                                ReportDetailDialog.this.clearObjs();
                                ReportDetailDialog.this.close();
                            }
                        }
                    });
                }
            }
        });
        jobA.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        jobA.setUser(true);
        jobA.schedule();
    }

    private void loadReportData() {
        try {
            String pvmlBody = this.pv.PVMLBody.toString();
            boolean bl = this.lcmdopt.equals(this.constants.REPORT_LCMD_SPM);
            this.constants.getClass();
            if (bl | this.lcmdopt.equals("++")) {
                this.getSpmHeader();
                String[] spmSettings = this.s1.split(CorePlugin.getDefault().getPreferenceStore().getString("spmSettings"), -1);
                String[] spmSetting = spmSettings[4].split(",");
                if (!spmSetting[4].equals("/")) {
                    this.stripSpmHeader();
                }
            }
            this.pv.PVMLBody = null;
            this.textViewer.setText(pvmlBody);
            if (this.activelink.length() > 0) {
                this.textViewer.replaceStyleRanges(0, this.textViewer.getText().length(), this.listBodyStyles.toArray(new StyleRange[this.listBodyStyles.size()]));
            } else {
                this.textViewer.setStyleRanges(this.listBodyStyles.toArray(new StyleRange[this.listBodyStyles.size()]));
            }
            this.activelinksBody = this.stylingBody.toString().split(",");
            this.listBodyStyles = null;
            this.stylingBody = null;
            this.clearObjs();
            this.scrollLine();
            this.textViewer.setVisible(true);
            this.textViewer.setFocus();
            this.client.layout(true);
        }
        catch (OutOfMemoryError oem) {
            String logstr = "loadReportData:  out of memory exception " + oem;
            System.out.println("ReportDetailDialog " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            MessageDialog.openError((Shell)this.textViewer.getShell(), (String)Messages.getString("ReportDetailDialog.MessageDialog.errorTitle.OEM"), (String)(String.valueOf(Messages.getString("ReportDetailDialog.MessageDialog.errorMessage.LoadReportOEM")) + this.reportTitle));
            this.clearObjs();
            this.close();
        }
        catch (Exception ex) {
            String logstr = "loadReportData:  report load exception " + ex;
            System.out.println("ReportDetailDialog " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            this.clearObjs();
        }
    }

    public void setReportStyle(String listtype) throws Exception, OutOfMemoryError {
        if (listtype.equalsIgnoreCase("body")) {
            this.listBodyStyles.add(this.stylerange);
        }
    }

    public void setNewReportStyleRange() throws Exception, OutOfMemoryError {
        this.stylerange = new StyleRange();
    }

    public void setReportStyleRange(String fred, String sectiontype, int pageOffset, int printPageOffset) throws Exception, OutOfMemoryError {
        String[] styleArray = this.s1.split(fred, -1);
        try {
            this.setNewReportStyleRange();
        }
        catch (OutOfMemoryError oem) {
            String logstr = "setReportStyleRange:  setNewReportStyleRange, setNewPrintStyleRange out of memory exception " + oem;
            System.out.println("ReportDetailDialog " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            throw oem;
        }
        catch (Exception e) {
            String logstr = "setReportStyleRange:  setNewReportStyleRange, setNewPrintStyleRange exception " + e;
            System.out.println("ReportDetailDialog " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            throw e;
        }
        this.stylerange.start = new Integer(styleArray[0]) + pageOffset;
        this.stylerange.length = new Integer(styleArray[1]);
        if (!CorePlugin.getDefault().getPreferenceStore().getBoolean("colorMonochrome")) {
            this.stylerange.foreground = this.getColorCode(styleArray[2]);
            if (styleArray[3].length() > 0) {
                this.stylerange.background = this.getColorCode(styleArray[3]);
            }
        }
        if (styleArray[4].equals("true")) {
            this.stylerange.underline = true;
            this.stylerange.underlineStyle = this.underlineStyle;
        }
        if (styleArray[5].equals("true")) {
            this.stylerange.fontStyle = 1;
        }
        styleArray[6].length();
        try {
            this.setReportStyle("body");
        }
        catch (OutOfMemoryError oem) {
            String logstr = "setReportStyleRange:  setReportStyleRange, setNewPrintStyleRange out of memory exception " + oem;
            System.out.println(logstr);
            CorePlugin.getDefault().log.error(logstr);
            throw oem;
        }
        catch (Exception e) {
            String logstr = "setReportStyleRange:  setReportStyleRange, setPrintStyleRange exception " + e;
            System.out.println(logstr);
            CorePlugin.getDefault().log.error(logstr);
            throw e;
        }
        if (this.isJavaReport && styleArray[0].equals("1") && styleArray[1].equals("6") && styleArray[2].equals("r")) {
            this.linenum = this.stylerange.start;
        }
    }

    public void clearObjs() {
        this.pv = null;
        this.listBodyStyles = null;
    }

    private void scrollLine() {
        int incr = Math.abs(this.textViewer.getClientArea().height / this.textViewer.getVerticalBar().getIncrement() / 2);
        int curline = this.textViewer.getLineAtOffset(this.linenum);
        int scrollline = curline + incr;
        if (this.textViewer.getLineCount() <= scrollline) {
            scrollline = this.textViewer.getLineCount() - 1;
        }
        if (scrollline < 0) {
            scrollline = 0;
        }
        this.textViewer.setSelection(this.textViewer.getOffsetAtLine(scrollline));
        this.textViewer.setSelection(new Integer(this.linenum).intValue());
        this.getLineColumn();
    }

    private void showMessage(String title, String message) {
        MessageDialog.openInformation((Shell)this.textViewer.getShell(), (String)title, (String)message);
    }

    private void showErrorMessage(String title, String message) {
        MessageDialog.openError((Shell)this.textViewer.getShell(), (String)title, (String)message);
    }

    private File getSaveReport() {
        boolean runSaveDialog = true;
        String filename = String.valueOf(CorePlugin.getDefault().productextension.getProductPrefix()) + "_" + this.stcid + "_" + this.sreqnum + "_" + this.rptid + "_Detail";
        File file = null;
        FileDialog dialog = null;
        while (runSaveDialog) {
            dialog = new FileDialog(this.textViewer.getShell(), 8192);
            dialog.setFilterNames(new String[]{"Text Documents (*.txt)", "Html Documents (*.html)", "All Files (*.*)"});
            dialog.setFilterExtensions(new String[]{"*.txt", "*.html", "*.*"});
            dialog.setFilterPath(CorePlugin.getDefault().getPreferenceStore().getString("saveReportPath"));
            dialog.setFileName(filename);
            dialog.setText(Messages.getString("ReportDetailDialog.Dialog.Text.SaveReport"));
            filename = dialog.open();
            if (filename != null) {
                file = new File(filename);
                if (file.exists()) {
                    if (MessageDialog.openConfirm((Shell)this.textViewer.getShell(), (String)Messages.getString("ReportDetailDialog.ConfirmDialog.ConfirmTitle.ReplaceFile"), (String)(String.valueOf(Messages.getString("ReportDetailDialog.ConfirmDialog.ConfirmMessage.Replace")) + filename + "?"))) {
                        runSaveDialog = false;
                        continue;
                    }
                    file = null;
                    dialog = null;
                    continue;
                }
                runSaveDialog = false;
                continue;
            }
            runSaveDialog = false;
        }
        dialog = null;
        return file;
    }

    private void findText() {
        String st = this.finddialog.rdd.textViewer.getText();
        if (!this.finddialog.caseCheck.getSelection()) {
            st = st.toLowerCase();
        }
        int startloc = 0;
        if (this.finddialog.finddir.equals("up")) {
            startloc = st.length();
        }
        int newloc = startloc;
        if (CorePlugin.getDefault().getPreferenceStore().getString("findText").length() <= 0) {
            return;
        }
        String findtext = this.finddialog.findText.getText().trim();
        if (!this.finddialog.caseCheck.getSelection()) {
            if (!findtext.equalsIgnoreCase(this.finddialog.rdd.searchtxt)) {
                this.finddialog.rdd.searchloc = startloc;
            }
        } else if (!findtext.equals(this.finddialog.rdd.searchtxt)) {
            this.finddialog.rdd.searchloc = startloc;
        }
        String dialogsearchtxt = this.finddialog.rdd.searchtxt = CorePlugin.getDefault().getPreferenceStore().getString("findText");
        if (!this.finddialog.caseCheck.getSelection()) {
            dialogsearchtxt = dialogsearchtxt.toLowerCase();
        }
        String searchtxtlc = this.finddialog.rdd.searchtxt;
        if (!this.finddialog.caseCheck.getSelection()) {
            searchtxtlc = searchtxtlc.toLowerCase();
        }
        if (this.finddialog.rdd.searchloc == startloc) {
            newloc = this.finddialog.finddir.equals("up") ? st.lastIndexOf(searchtxtlc, this.finddialog.rdd.searchloc) : st.indexOf(searchtxtlc, this.finddialog.rdd.searchloc);
            if (newloc < 0) {
                this.showMessage(Messages.getString("ReportDetailDialog.MessageDialog.infoTitle.FindResults"), String.valueOf(Messages.getString("ReportDetailDialog.MessageDialog.infoMessage.CannotFind")) + this.finddialog.rdd.searchtxt + "\"");
                this.finddialog.rdd.textViewer.setSelection(0);
                return;
            }
            this.finddialog.rdd.searchloc = newloc;
        } else {
            newloc = this.finddialog.finddir.equals("up") ? st.lastIndexOf(searchtxtlc, this.finddialog.rdd.searchloc - 1) : st.indexOf(searchtxtlc, this.finddialog.rdd.searchloc + 1);
            if (newloc < 0) {
                this.showMessage(Messages.getString("ReportDetailDialog.MessageDialog.infoTitle.FindResults"), String.valueOf(Messages.getString("ReportDetailDialog.MessageDialog.infoMessage.CannotFind")) + this.finddialog.rdd.searchtxt + "\"");
                newloc = this.finddialog.rdd.searchloc;
            }
            this.finddialog.rdd.searchloc = newloc;
        }
        this.finddialog.rdd.searchloc = newloc;
        this.finddialog.rdd.textViewer.setSelection(this.finddialog.rdd.searchloc, this.finddialog.rdd.searchloc + this.finddialog.rdd.searchtxt.length());
        this.finddialog.rdd.textViewer.setFocus();
        this.getLineColumn();
        CorePlugin.getDefault().getPreferenceStore().setValue("findText", "");
    }

    public boolean close() {
        this.dispose();
        super.close();
        return true;
    }

    public void dispose() {
        this.viewerFont.dispose();
        this.imgRptGreen.dispose();
    }

    public int getShellStyle() {
        return 3312;
    }

    private void saveasHtmlFile(File fileto) {
        if (this.buildHtml() < 0) {
            return;
        }
        try {
            File filefrom = new File(String.valueOf(this.reportPath) + this.rptid + this.htmlsuffix + ".html");
            FileChannel srcChannel = new FileInputStream(filefrom).getChannel();
            FileChannel dstChannel = new FileOutputStream(fileto).getChannel();
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            srcChannel.close();
            dstChannel.close();
            this.activelink = "";
            this.linenum = 0;
        }
        catch (IOException e) {
            String logstr = "saveasHtml:  from " + this.reportPath + this.rptid + this.htmlsuffix + ".html" + " to " + fileto.getAbsolutePath() + " IOException " + e;
            System.out.println("ReportDetailDialog " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    private void saveasTextFile(File file) {
        try {
            FileOutputStream outputStream2 = new FileOutputStream(file);
            PrintStream sysout = new PrintStream((OutputStream)outputStream2, true, "UTF-8");
            sysout.print(this.textViewer.getText().replace("\n", "\r\n"));
            outputStream2.close();
            outputStream2 = null;
            sysout = null;
        }
        catch (OutOfMemoryError oem) {
            String logstr = "saveAction:  out of memory exception " + oem;
            System.out.println("ReportDetailDialog " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            MessageDialog.openError((Shell)this.textViewer.getShell(), (String)Messages.getString("ReportDetailDialog.MessageDialog.errorTitle.OEM"), (String)(String.valueOf(Messages.getString("ReportDetailDialog.MessageDialog.errorMessage.SaveReportOEM")) + this.printTitle));
            this.clearObjs();
        }
        catch (Exception e) {
            String logstr = "saveAction:  exception " + e;
            System.out.println("ReportDetailDialog " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            MessageDialog.openError((Shell)this.textViewer.getShell(), (String)Messages.getString("ReportDetailDialog.MessageDialog.errorTitle.SaveError"), (String)e.getLocalizedMessage());
        }
    }

    private int buildHtml() {
        int rc = 0;
        String errmsg = "";
        ReportHtmlBuilder htmlbuilder = new ReportHtmlBuilder();
        try {
            htmlbuilder.buildHtmlFile(this.reportPath, this.rptid, "-detailbase", String.valueOf(this.rptid) + this.htmlsuffix + ".html", String.valueOf(this.printTitle) + "\n\n");
        }
        catch (OutOfMemoryError oem) {
            String logstr = "buildHtml:  Out of Memory exception building html: " + this.reportPath + this.rptid + ". " + oem;
            System.out.println("ReportDetailDialog - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            errmsg = oem.getLocalizedMessage();
            rc = -1;
        }
        catch (IOException e) {
            String logstr = "buildHtml:  IO exception building html: " + this.reportPath + this.rptid + ". " + e;
            System.out.println("ReportDetailDialog - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            errmsg = e.getLocalizedMessage();
            rc = -1;
        }
        catch (Exception e) {
            String logstr = "buildHtml:  Exception building html: " + this.reportPath + this.rptid + ". " + e;
            System.out.println("ReportDetailDialog - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            errmsg = e.getLocalizedMessage();
            rc = -1;
        }
        if (rc < 0) {
            MessageDialog.openError((Shell)this.textViewer.getShell(), (String)Messages.getString("ReportDetailDialog.MessageDialog.errorTitle.ReportError"), (String)errmsg);
        }
        return rc;
    }

    public void launchHtmlJob() {
        try {
            String logstr = "launchHtmlJob:  launching html report " + this.reportPath + this.rptid + this.htmlsuffix + ".html";
            System.out.println("ReportDetailDialog " + logstr);
            CorePlugin.getDefault().log.debug(logstr);
            File htmlFile = new File(String.valueOf(this.reportPath) + this.rptid + this.htmlsuffix + ".html");
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(htmlFile.toURI().toURL());
        }
        catch (Exception ex) {
            String logstr = "launchHtmlJob: Error launching html file " + this.reportPath + this.rptid + this.htmlsuffix + ".html" + ", Exception - " + ex;
            System.out.println("ReportDetailDialog - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    private void getSpmHeader() {
        String spmModule = "";
        String spmLibrary = "";
        String loadLibrary = "";
        String pvmlBody = this.pv.PVMLBody.toString();
        String begStr = "CSECT:";
        String endStr = "";
        int begIdx = pvmlBody.indexOf(begStr) + begStr.length();
        int endIdx = pvmlBody.indexOf("\n", begIdx);
        if (pvmlBody.contains(begStr)) {
            spmModule = pvmlBody.substring(begIdx, endIdx).trim();
        } else {
            begStr = "Load Module:";
            endStr = " LIB:";
            begIdx = pvmlBody.indexOf(begStr) + begStr.length();
            endIdx = pvmlBody.indexOf(endStr, begIdx);
            if (!pvmlBody.contains(begStr)) {
                return;
            }
            spmModule = pvmlBody.substring(begIdx, endIdx).trim();
        }
        begStr = " LIB: ";
        endStr = " ";
        begIdx = pvmlBody.indexOf(begStr) + begStr.length();
        endIdx = pvmlBody.indexOf(endStr, begIdx);
        if (!pvmlBody.contains(begStr)) {
            return;
        }
        loadLibrary = pvmlBody.substring(begIdx, endIdx).trim();
        System.out.println("extracted load library String: '" + loadLibrary + "'");
        begStr = "Mapped by:";
        endStr = " (";
        begIdx = pvmlBody.indexOf(begStr) + begStr.length();
        endIdx = pvmlBody.indexOf(endStr, begIdx);
        String pdsLibrary = pvmlBody.substring(begIdx, endIdx).trim();
        System.out.println("extracted SPM library String: '" + pdsLibrary + "'");
        spmLibrary = pdsLibrary;
        String reportid = "P01";
        this.addSpmReportNode(reportid, spmModule, spmLibrary, loadLibrary);
    }

    private String stripSpmHeader() {
        String pvmlBody = this.pv.PVMLBody.toString();
        String begStr = "Load Module:";
        String spmHeader = "";
        int begIdx = pvmlBody.indexOf(begStr);
        int endIdx = pvmlBody.indexOf("\n", pvmlBody.indexOf("Compiler:"));
        if (pvmlBody.contains(begStr)) {
            spmHeader = pvmlBody.substring(begIdx, endIdx).trim();
        }
        return spmHeader;
    }

    private void addSpmReportNode(String reportid, String spmModule, String spmLibrary, String loadLibrary) {
        ReportsModel reports = CorePlugin.getDefault().getReportsModel();
        int numcategories = reports.getChildren().size();
        boolean pnodeFound = false;
        boolean spmnodeFound = false;
        ReportsModel pnode = new ReportsModel(numcategories + 1, "category", CorePlugin.getDefault().constants.REPORT_CATEGORY_SPM, Messages.getString("ReportDetailDialog.ReportsModel.SPMcategory"), "", "", "", "", false, reports.parent);
        if (reports != null) {
            int j = 0;
            while (j < reports.getChildren().size()) {
                ReportsModel categoryitem = reports.getChildren().get(j);
                if (categoryitem.reportid.equals(CorePlugin.getDefault().constants.REPORT_CATEGORY_SPM)) {
                    pnode = categoryitem;
                    pnodeFound = true;
                    break;
                }
                ++j;
            }
        }
        if (!pnodeFound) {
            reports.child.add(pnode);
        }
        int numpnodes = pnode.getChildren().size();
        String reportname = Messages.getString("ReportDetailDialog.ReportsModel.SPMreport");
        reportname = reportname.replace("#spmModule", spmModule);
        ReportsModel spmnode = new ReportsModel(numpnodes + 1, "report", reportid, reportname, "", "", "", "", false, pnode);
        spmnode.spmModule = spmModule;
        spmnode.spmLibrary = spmLibrary;
        spmnode.loadLibrary = loadLibrary;
        int i = 0;
        while (i < pnode.getChildren().size()) {
            ReportsModel spmitem = pnode.getChildren().get(i);
            if (spmitem.reportid.equals(reportid) & spmitem.spmModule.equals(spmModule)) {
                spmnodeFound = true;
                break;
            }
            ++i;
        }
        if (!spmnodeFound) {
            pnode.child.add(spmnode);
        }
        CorePlugin.getDefault().getPreferenceStore().setValue("reportsRefresh", true);
    }
}

