/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs.reports;

import com.banknet.core.CorePlugin;
import com.banknet.core.dialogs.reports.Messages;
import com.banknet.core.internal.Constants;
import java.util.regex.Pattern;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OptionEditorDialog
extends Dialog {
    Constants constants = new Constants();
    Composite content;
    Shell shell;
    Composite checkboxgroup;
    Composite combogroup;
    Composite textgroup;
    public Text findText;
    public Button optionCheck;
    public Button upRadio;
    public Button downRadio;
    public Combo optionCombo;
    public Text optionText;
    public Button okButton;
    Button nextButton;
    public String finddir = "down";
    boolean initialSetup = false;
    public String[] optionsarr = null;
    public String options = "";
    public static Document doc;
    public String rptid = "";
    public String optid = "";
    public String optval = "";
    public String nextoptid = "";
    public String nextoptval = "";
    public String navaction = "";
    private int optidx = 0;
    private String dfltval = "";
    private String dfltlabelval = "";
    private String opttype = "";
    private String optdatatype = "";
    private int opttextlimit = 0;
    private String optdecpos = "";
    private String optminval = "";
    private String optmaxval = "";
    private String optvalues = "";
    private String optlabels = "";
    private Action backwardAction;
    private Action forwardAction;
    ToolBarManager toolBarMgr;
    String errmsg = "";
    public String[] optionslabelsarr = null;
    public String optionslabels = "";
    public String optionlabel = "";
    private int optlabelidx = 0;
    private String optlabel = "";
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);
    private Integer fontSize;
    private long fontDataHeight;
    int shellw = 255;
    int shellh = 200;
    String OSenv = "";
    private IMenuCreator backwardMenuCreator = new IMenuCreator(){
        private Menu menu;

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu(parent);
            int sidx = 0;
            int eidx = OptionEditorDialog.this.optidx;
            int i = sidx;
            while (i < eidx) {
                if (OptionEditorDialog.this.optionsarr[i].length() > 0) {
                    String option = OptionEditorDialog.this.optionsarr[i].substring(0, OptionEditorDialog.this.optionsarr[i].indexOf("="));
                    MenuItem item = new MenuItem(this.menu, 32);
                    item.setText(OptionEditorDialog.this.getOptionLabelIndex(option));
                    item.setData((Object)i);
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            OptionEditorDialog.this.doNextOption(new Integer(e.widget.getData().toString()));
                        }
                    });
                }
                ++i;
            }
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            return this.menu;
        }
    };
    private IMenuCreator forwardMenuCreator = new IMenuCreator(){
        private Menu menu;

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu(parent);
            int sidx = OptionEditorDialog.this.optidx + 1;
            int eidx = OptionEditorDialog.this.optionsarr.length - 1;
            int i = sidx;
            while (i <= eidx) {
                if (OptionEditorDialog.this.optionsarr[i].length() > 0) {
                    String option = OptionEditorDialog.this.optionsarr[i].substring(0, OptionEditorDialog.this.optionsarr[i].indexOf("="));
                    MenuItem item = new MenuItem(this.menu, 32);
                    item.setText(OptionEditorDialog.this.getOptionLabelIndex(option));
                    item.setData((Object)i);
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            OptionEditorDialog.this.doNextOption(new Integer(e.widget.getData().toString()));
                        }
                    });
                }
                ++i;
            }
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            return this.menu;
        }
    };

    public OptionEditorDialog(Shell parentShell) {
        super(parentShell);
        this.shell = parentShell;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setImage(CorePlugin.getDefault().productextension.getDialogShellImage());
        this.OSenv = System.getProperty("os.name").toLowerCase();
        if (this.OSenv.startsWith("windows")) {
            this.fontSize = newShell.getFont().getFontData()[0].getHeight();
            if (this.fontSize > this.constants.FONT_NORMAL) {
                this.setLargeFontSizes();
            }
        }
        newShell.setText(Messages.getString("OptionEditorDialog.Title"));
        this.optionsarr = this.options.split(",");
        this.optionslabelsarr = this.optionslabels.split(",");
        this.getOptionPreferenceIndex();
        this.optionlabel = this.getOptionLabelIndex(this.optid);
        this.getOptionPreferenceIndex();
        this.getReportOptionDefault();
        this.backwardAction = new Action("Back", 4){

            public void run() {
                OptionEditorDialog.this.navaction = "backward";
                OptionEditorDialog.this.doNextOption(OptionEditorDialog.this.optidx - 1);
            }
        };
        this.backwardAction.setText(Messages.getString("OptionEditorDialog.Action.Text.Back"));
        this.backwardAction.setToolTipText(Messages.getString("OptionEditorDialog.Action.ToolTip.Back"));
        this.backwardAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/elcl16/nav_backward.gif"));
        this.backwardAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/dlcl16/nav_backward.gif"));
        this.backwardAction.setEnabled(true);
        if (this.optidx == 0) {
            this.backwardAction.setEnabled(false);
        }
        this.backwardAction.setMenuCreator(this.backwardMenuCreator);
        this.forwardAction = new Action(){

            public void run() {
                OptionEditorDialog.this.navaction = "forward";
                OptionEditorDialog.this.doNextOption(OptionEditorDialog.this.optidx + 1);
            }
        };
        this.forwardAction.setText(Messages.getString("OptionEditorDialog.Action.Text.Forward"));
        this.forwardAction.setToolTipText(Messages.getString("OptionEditorDialog.Action.ToolTip.Forward"));
        this.forwardAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/elcl16/nav_forward.gif"));
        this.forwardAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/dlcl16/nav_forward.gif"));
        this.forwardAction.setEnabled(true);
        if (this.optidx == this.optionsarr.length - 1) {
            this.forwardAction.setEnabled(false);
        }
        this.forwardAction.setMenuCreator(this.forwardMenuCreator);
    }

    private void setLargeFontSizes() {
        double lgsize = 0.0;
        double sizemult = 1.25;
        if (this.fontSize > this.constants.FONT_LARGE | this.fontDataHeight < this.constants.FONTDATA_LARGE) {
            sizemult = 1.4;
        }
        lgsize = (double)this.shellw * sizemult;
        this.shellw = (int)lgsize;
        lgsize = (double)this.shellh * sizemult;
        this.shellh = (int)lgsize;
    }

    protected Control createDialogArea(Composite parent) {
        this.content = parent;
        ((GridLayout)this.content.getLayout()).numColumns = 1;
        GridData gd2 = new GridData(1, 0x1000000, true, false);
        this.content.setLayoutData((Object)gd2);
        ToolBar toolBar = new ToolBar(this.content, 256);
        this.toolBarMgr = new ToolBarManager(toolBar);
        this.toolBarMgr.add((IAction)this.backwardAction);
        this.toolBarMgr.add((IAction)this.forwardAction);
        this.toolBarMgr.update(true);
        GridData gdb3 = new GridData(131072, 1, true, false, 1, 1);
        toolBar.setLayoutData((Object)gdb3);
        if (this.opttype.equalsIgnoreCase("checkbox")) {
            this.createCheckbox();
        } else if (this.opttype.equalsIgnoreCase("combo")) {
            this.createCombo();
        } else if (this.opttype.equalsIgnoreCase("text")) {
            this.createText();
        }
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite client = new Composite(this.content, 4);
        GridLayout layout = new GridLayout(2, false);
        GridData gd = new GridData(131072, 4, true, false, 1, 1);
        client.setLayoutData((Object)gd);
        client.setLayout((Layout)layout);
        this.createButton(client, 0, Messages.getString("OptionEditorDialog.Button.Text.Ok"), false);
        this.createButton(client, 1, Messages.getString("OptionEditorDialog.Button.Text.Cancel"), false);
    }

    public void okPressed() {
        this.updateOptionPreferences();
        this.setReturnCode(0);
        this.close();
        super.okPressed();
    }

    public void cancelPressed() {
        this.setReturnCode(1);
        this.close();
        super.cancelPressed();
    }

    private void createCheckbox() {
        this.checkboxgroup = new Group(this.content, 0);
        ((Group)this.checkboxgroup).setText("");
        this.checkboxgroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.checkboxgroup.setLayout((Layout)new GridLayout(2, false));
        Label spacer1 = new Label(this.checkboxgroup, 0);
        spacer1.setText(" ");
        GridData gd2 = new GridData(1, 0x1000000, false, false, 1, 1);
        gd2.widthHint = 50;
        spacer1.setLayoutData((Object)gd2);
        this.optionCheck = new Button(this.checkboxgroup, 32);
        this.optionCheck.setText(this.optionlabel);
        this.optionCheck.setSelection(this.optval.equalsIgnoreCase("Y"));
        GridData gd = new GridData(1, 0x1000000, false, false, 1, 1);
        gd.horizontalIndent = 10;
        gd.heightHint = 30;
        this.optionCheck.setLayoutData((Object)gd);
        this.optionCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionEditorDialog.this.optval = OptionEditorDialog.this.optionCheck.getSelection() ? "Y" : "N";
            }
        });
        Label spacer = new Label(this.checkboxgroup, 0);
        spacer.setText(" ");
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        gd2.widthHint = 50;
        spacer.setLayoutData((Object)gd2);
        Button defaultsButton = new Button(this.checkboxgroup, 8);
        defaultsButton.setText(Messages.getString("OptionEditorDialog.Checkbox.Button.Text.RestoreDefault"));
        gd = new GridData(1, 0x1000000, true, false, 1, 1);
        defaultsButton.setLayoutData((Object)gd);
        defaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionEditorDialog.this.optionCheck.setSelection(OptionEditorDialog.this.dfltval.equalsIgnoreCase("Y"));
                OptionEditorDialog.this.checkboxgroup.layout(false);
                OptionEditorDialog.this.optval = OptionEditorDialog.this.dfltval;
            }
        });
    }

    private void createCombo() {
        this.combogroup = new Group(this.content, 0);
        ((Group)this.combogroup).setText("");
        this.combogroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.combogroup.setLayout((Layout)new GridLayout(2, false));
        Label comboLabel = new Label(this.combogroup, 0);
        comboLabel.setText(String.valueOf(this.optionlabel) + " : ");
        GridData gd = new GridData(1, 0x1000000, false, false);
        gd.horizontalIndent = 10;
        gd.minimumWidth = 50;
        comboLabel.setLayoutData((Object)gd);
        this.optionCombo = new Combo(this.combogroup, 8);
        String[] valuesarr = this.optvalues.split(",");
        String[] labelsarr = this.optlabels.split(",");
        int i = 0;
        while (i < valuesarr.length) {
            this.optionCombo.add(labelsarr[i]);
            this.optionCombo.setData(labelsarr[i], (Object)valuesarr[i]);
            if (valuesarr[i].equals(this.optval)) {
                this.optionCombo.select(i);
            }
            ++i;
        }
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        gd.heightHint = 30;
        this.optionCombo.setLayoutData((Object)gd);
        this.optionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionEditorDialog.this.optval = (String)OptionEditorDialog.this.optionCombo.getData(OptionEditorDialog.this.optionCombo.getText());
            }
        });
        Label spacer = new Label(this.combogroup, 0);
        spacer.setText(" ");
        gd = new GridData(1, 0x1000000, false, false);
        spacer.setLayoutData((Object)gd);
        Button defaultsButton = new Button(this.combogroup, 8);
        defaultsButton.setText(Messages.getString("OptionEditorDialog.Combo.Button.Text.RestoreDefault"));
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        defaultsButton.setLayoutData((Object)gd);
        defaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < OptionEditorDialog.this.optionCombo.getItemCount()) {
                    if (OptionEditorDialog.this.optionCombo.getItem(i).equals(OptionEditorDialog.this.dfltlabelval)) {
                        OptionEditorDialog.this.optionCombo.select(i);
                    }
                    ++i;
                }
                OptionEditorDialog.this.combogroup.layout(false);
                OptionEditorDialog.this.optval = OptionEditorDialog.this.dfltval;
            }
        });
    }

    private void createText() {
        this.textgroup = new Group(this.content, 0);
        ((Group)this.textgroup).setText("");
        this.textgroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.textgroup.setLayout((Layout)new GridLayout(2, false));
        Label textLabel = new Label(this.textgroup, 0);
        textLabel.setText(String.valueOf(this.optionlabel) + " : ");
        GridData gd = new GridData(1, 0x1000000, false, false);
        gd.horizontalIndent = 10;
        textLabel.setLayoutData((Object)gd);
        this.optionText = new Text(this.textgroup, 2048);
        this.optionText.setText(this.optval);
        if (this.opttextlimit > 0) {
            this.optionText.setTextLimit(this.opttextlimit);
        }
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        gd.widthHint = 50;
        this.optionText.setLayoutData((Object)gd);
        this.optionText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionEditorDialog.this.optval = OptionEditorDialog.this.optionText.getText();
            }
        });
        this.optionText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                OptionEditorDialog.this.optval = OptionEditorDialog.this.optionText.getText();
                OptionEditorDialog.this.errmsg = "";
                if (OptionEditorDialog.this.optdatatype.equalsIgnoreCase("int")) {
                    OptionEditorDialog.this.errmsg = OptionEditorDialog.this.chkInteger(OptionEditorDialog.this.optval, OptionEditorDialog.this.optid);
                } else if (OptionEditorDialog.this.optdatatype.equalsIgnoreCase("long")) {
                    OptionEditorDialog.this.errmsg = OptionEditorDialog.this.chkLong(OptionEditorDialog.this.optval, OptionEditorDialog.this.optid);
                } else if (OptionEditorDialog.this.optdatatype.equalsIgnoreCase("pct")) {
                    OptionEditorDialog.this.errmsg = OptionEditorDialog.this.chkPercent(OptionEditorDialog.this.optval, OptionEditorDialog.this.optid, OptionEditorDialog.this.optdecpos);
                }
                if (OptionEditorDialog.this.errmsg.length() > 0) {
                    OptionEditorDialog.this.showMessage("error", Messages.getString("OptionEditorDialog.MessageDialog.Title.EditError"), OptionEditorDialog.this.errmsg);
                }
            }
        });
        Label spacer = new Label(this.textgroup, 0);
        spacer.setText(" ");
        gd = new GridData(1, 0x1000000, false, false);
        spacer.setLayoutData((Object)gd);
        Button defaultsButton = new Button(this.textgroup, 8);
        defaultsButton.setText(Messages.getString("OptionEditorDialog.Textbox.Button.Text.RestoreDefault"));
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        defaultsButton.setLayoutData((Object)gd);
        defaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionEditorDialog.this.optionText.setText(OptionEditorDialog.this.dfltval);
                OptionEditorDialog.this.textgroup.layout(false);
                OptionEditorDialog.this.optval = OptionEditorDialog.this.dfltval;
            }
        });
    }

    private void getOptionPreferenceIndex() {
        String option = "";
        int i = 0;
        while (i < this.optionsarr.length) {
            if (this.optionsarr[i].length() > 0 && (option = this.optionsarr[i].substring(0, this.optionsarr[i].indexOf("="))).equals(this.optid)) {
                this.optidx = i;
                break;
            }
            ++i;
        }
    }

    private String getOptionLabelIndex(String option) {
        String optionlabel = "";
        int i = 0;
        while (i < this.optionslabelsarr.length) {
            String[] optionslabel = this.s1.split(this.optionslabelsarr[i], -1);
            if (optionslabel[0].equals(option)) {
                optionlabel = optionslabel[1];
                break;
            }
            ++i;
        }
        return optionlabel;
    }

    private void getReportOptionDefault() {
        NodeList childNodes2 = doc.getElementsByTagName("report");
        int ii = 0;
        while (ii < childNodes2.getLength()) {
            NamedNodeMap atrs;
            Node item2 = childNodes2.item(ii);
            String nodeName2 = item2.getNodeName();
            if (nodeName2.equals("report") && this.rptid.equals(((Attr)(atrs = item2.getAttributes()).item(0)).getNodeValue())) {
                this.getReportOption(item2);
            }
            ++ii;
        }
    }

    private void getReportOption(Node node) {
        String option = "";
        NodeList childNodes2 = node.getChildNodes();
        int ii = 0;
        while (ii < childNodes2.getLength()) {
            Node item2 = childNodes2.item(ii);
            String nodeName2 = item2.getNodeName();
            if (nodeName2.equals("reportOption")) {
                NamedNodeMap atrs = item2.getAttributes();
                int jj = 0;
                while (jj < atrs.getLength()) {
                    if (((Attr)atrs.item(jj)).getNodeName().equals("type")) {
                        this.opttype = ((Attr)atrs.item(jj)).getNodeValue();
                    } else if (((Attr)atrs.item(jj)).getNodeName().equals("datatype")) {
                        this.optdatatype = ((Attr)atrs.item(jj)).getNodeValue();
                    } else if (((Attr)atrs.item(jj)).getNodeName().equals("decpos")) {
                        this.optdecpos = ((Attr)atrs.item(jj)).getNodeValue();
                    } else if (((Attr)atrs.item(jj)).getNodeName().equals("textlimit")) {
                        this.opttextlimit = new Integer(((Attr)atrs.item(jj)).getNodeValue());
                    } else if (((Attr)atrs.item(jj)).getNodeName().equals("minval")) {
                        this.optminval = ((Attr)atrs.item(jj)).getNodeValue();
                    } else if (((Attr)atrs.item(jj)).getNodeName().equals("maxval")) {
                        this.optmaxval = ((Attr)atrs.item(jj)).getNodeValue();
                    } else if (((Attr)atrs.item(jj)).getNodeName().equals("label")) {
                        this.dfltval = this.getOptionValue(item2);
                    } else if (((Attr)atrs.item(jj)).getNodeName().equals("value")) {
                        option = ((Attr)atrs.item(jj)).getNodeValue();
                    }
                    ++jj;
                }
            }
            if (option.equals(this.optid)) {
                return;
            }
            ++ii;
        }
    }

    private String getOptionValue(Node node) {
        String val = "";
        String labelval = "";
        String dfltval = "";
        this.dfltlabelval = "";
        NodeList childNodes2 = node.getChildNodes();
        this.optvalues = "";
        this.optlabels = "";
        int ii = 0;
        while (ii < childNodes2.getLength()) {
            Node item2 = childNodes2.item(ii);
            String nodeName2 = item2.getNodeName();
            if (nodeName2.equals("optionValue")) {
                NamedNodeMap atrs = item2.getAttributes();
                Node valatr = atrs.getNamedItem("value");
                Node labelatr = atrs.getNamedItem("label");
                Node dfltatr = atrs.getNamedItem("default");
                Node sorthdrpi = atrs.getNamedItem("sorthdrpi");
                val = valatr.getNodeValue();
                labelval = labelatr.getNodeValue();
                if (labelval.length() <= 0) {
                    labelval = val;
                }
                if (sorthdrpi != null && sorthdrpi.getNodeValue().length() <= 0) {
                    val = "";
                    labelval = "";
                }
                if (val.length() > 0) {
                    this.optvalues = String.valueOf(this.optvalues) + val + ",";
                    this.optlabels = String.valueOf(this.optlabels) + labelval + ",";
                }
                if (dfltatr.getNodeValue().equals("1")) {
                    dfltval = val;
                    this.dfltlabelval = labelval;
                }
            }
            ++ii;
        }
        this.optvalues = this.optvalues.substring(0, this.optvalues.length() - 1);
        this.optlabels = this.optlabels.substring(0, this.optlabels.length() - 1);
        return dfltval;
    }

    private void updateOptionPreferences() {
        String optionprefs = "";
        String option = "";
        int i = 0;
        while (i < this.optionsarr.length) {
            if (this.optionsarr[i].length() > 0) {
                option = this.optionsarr[i].substring(0, this.optionsarr[i].indexOf("="));
                optionprefs = this.optid.equals(option) ? String.valueOf(optionprefs) + option + "=" + this.optval : String.valueOf(optionprefs) + this.optionsarr[i];
                optionprefs = String.valueOf(optionprefs) + ",";
            }
            ++i;
        }
        this.options = optionprefs;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
    }

    private String chkInteger(String val, String varname) {
        Integer ival = 0;
        String errmsg = "";
        try {
            ival = new Integer(val);
        }
        catch (NumberFormatException numberFormatException) {
            errmsg = String.valueOf(varname) + Messages.getString("OptionEditorDialog.errorMessage.MustBeNumeric");
            return errmsg;
        }
        if (ival <= 0) {
            errmsg = String.valueOf(varname) + Messages.getString("OptionEditorDialog.errorMessage.GreaterThanZero");
            return errmsg;
        }
        return errmsg;
    }

    private String chkPercent(String val, String varname, String decpos) {
        String errmsg = "";
        errmsg = this.chkFloat(val, varname);
        if (errmsg.length() > 0) {
            return errmsg;
        }
        errmsg = this.chkDecPos(val, varname, decpos);
        if (errmsg.length() > 0) {
            return errmsg;
        }
        try {
            float lpct = new Float(val).floatValue();
            float minpct = new Float("00.00").floatValue();
            float maxpct = new Float("100.00").floatValue();
            if (this.optminval.length() > 0) {
                minpct = new Float(this.optminval).floatValue();
            }
            if (this.optmaxval.length() > 0) {
                maxpct = new Float(this.optmaxval).floatValue();
            }
            if (lpct > maxpct || lpct < minpct) {
                errmsg = String.valueOf(varname) + Messages.getString("OptionEditorDialog.chkPercent.ErrorMessage.MustBeBetween") + this.optminval + Messages.getString("OptionEditorDialog.chkPercent.ErrorMessage.And") + this.optmaxval;
                return errmsg;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return errmsg;
    }

    private String chkDecPos(String val, String varname, String decpos) {
        String errmsg = "";
        if (val.indexOf(".") < 0) {
            errmsg = String.valueOf(varname) + Messages.getString("OptionEditorDialog.errorMessage.MustBeFormatted") + decpos + Messages.getString("OptionEditorDialog.errorMessage.DecimalPos");
            return errmsg;
        }
        String valdecpos = val.substring(val.indexOf(".") + 1, val.length());
        int idecpos = new Integer(decpos);
        if (idecpos != valdecpos.length()) {
            errmsg = String.valueOf(varname) + Messages.getString("OptionEditorDialog.errorMessage.MustBeFormatted") + decpos + Messages.getString("OptionEditorDialog.errorMessage.DecimalPos");
            return errmsg;
        }
        return errmsg;
    }

    private String chkLong(String val, String varname) {
        long lval = 0L;
        String errmsg = "";
        try {
            lval = new Long(val);
        }
        catch (NumberFormatException numberFormatException) {
            errmsg = String.valueOf(varname) + Messages.getString("OptionEditorDialog.errorMessage.MustBeNumeric");
            return errmsg;
        }
        if (lval <= 0L) {
            errmsg = String.valueOf(varname) + Messages.getString("OptionEditorDialog.errorMessage.GreaterThanZero");
            return errmsg;
        }
        return errmsg;
    }

    private String chkFloat(String val, String varname) {
        String errmsg = "";
        try {
            new Float(val).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            errmsg = String.valueOf(varname) + Messages.getString("OptionEditorDialog.errorMessage.MustBeNumeric");
            return errmsg;
        }
        return errmsg;
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            CorePlugin.getDefault().getWorkbench().getDisplay();
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
        } else {
            CorePlugin.getDefault().getWorkbench().getDisplay();
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
        }
    }

    private void doNextOption(int optionidx) {
        this.updateOptionPreferences();
        String option = this.optionsarr[optionidx];
        this.nextoptid = option.substring(0, option.indexOf("="));
        this.nextoptval = option.substring(option.indexOf("=") + 1, option.length());
        this.setReturnCode(3);
        this.close();
    }

    public int getShellStyle() {
        return 134384;
    }
}

