/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs.reports;

import com.banknet.core.CorePlugin;
import com.banknet.core.dialogs.reports.Messages;
import com.banknet.core.internal.Constants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class Db2ExplainDialog
extends TitleAreaDialog {
    Constants constants = new Constants();
    Composite content;
    Shell shell;
    Composite client;
    private final String Ti1_TITLE = Messages.getString("Db2ExplainDialog.TabTitle.T1.SqlInfo");
    private final String Ti2_TITLE = Messages.getString("Db2ExplainDialog.TabTitle.T2.SqlText");
    private CTabFolder tf;
    private CTabItem items;
    private CTabItem ti1;
    private CTabItem ti2;
    private Composite ti1client;
    Button db2V8CompatButton;
    Button storedProcSqlButton;
    Button stmtInPkgButton;
    Button sqlTextOutputButton;
    Button stmtOpenFetchCloseButton;
    private Composite ti2client;
    Text textViewerSql;
    String reportLocation = "";
    public String stcid = "";
    public String rptid = "";
    public String reportTitle = "";
    public Integer reqnum = 0;
    String sreqnum = "";
    Cursor arrowCursor;
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);
    String errorTitle = "";
    String errorMsg = "";
    String errmsg = "";
    StringBuilder sql = new StringBuilder();
    String tag = "";
    public List<String> sqltags = new ArrayList<String>();
    public List<String> sqlvalues = new ArrayList<String>();
    Image imgRptGreen = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/msGreen.gif").createImage();

    public Db2ExplainDialog(Shell parentShell, String stcid, int reqnum, String rptid, String rpttitle) {
        super(parentShell);
        this.shell = parentShell;
        this.stcid = stcid;
        this.reqnum = reqnum;
        this.sreqnum = CorePlugin.getDefault().constants.reqdecfmt.format(reqnum);
        this.rptid = rptid;
        this.reportTitle = Messages.getString("Db2ExplainDialog.ShellTitle");
        this.reportTitle = this.reportTitle.replace("#rptid", rpttitle);
        this.getSqlData();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.reportTitle);
        newShell.setImage(this.imgRptGreen);
        newShell.setSize(600, 500);
        newShell.setLocation(125, 50);
        this.makeActions();
    }

    protected Control createDialogArea(Composite parent) {
        this.content = parent;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.content, String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".dialogs_Db2ExplainContext");
        ((GridLayout)this.content.getLayout()).numColumns = 1;
        this.tf = new CTabFolder(this.content, 0x1000800);
        this.tf.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.ti1 = new CTabItem(this.tf, 2048);
        this.ti1.setText(this.Ti1_TITLE);
        this.ti1.setControl((Control)new SqlInformation((Composite)this.tf, 0));
        this.ti2 = new CTabItem(this.tf, 2048);
        this.ti2.setText(this.Ti2_TITLE);
        this.ti2.setControl((Control)new SqlText((Composite)this.tf, 0));
        this.setTitle(Messages.getString("Db2ExplainDialog.Title"));
        this.setMessage(Messages.getString("Db2ExplainDialog.ShellMessage"), 1);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    private void makeActions() {
    }

    public int getShellStyle() {
        return 3312;
    }

    public void getSqlData() {
        String sqlLine = "";
        BufferedReader sqlrdr = null;
        IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
        CorePlugin.getDefault();
        File sqlFile = new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + this.stcid + File.separator + this.reqnum + File.separator + Platform.getNL() + File.separator + this.rptid + "-db2.txt");
        if (sqlFile.exists()) {
            try {
                sqlrdr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sqlFile.getAbsolutePath()), "UTF-8"));
                while ((sqlLine = sqlrdr.readLine()) != null) {
                    if (sqlLine.length() <= 0) continue;
                    this.extractSql(sqlLine);
                }
                sqlrdr.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void extractSql(String sqlLine) {
        String stag = "";
        String etag = "";
        if (this.tag.length() <= 0) {
            this.tag = sqlLine.substring(1, sqlLine.indexOf(">"));
        }
        if (this.tag.length() <= 0) {
            return;
        }
        stag = "<" + this.tag + ">";
        etag = "</" + this.tag + ">";
        if (sqlLine.indexOf(stag) >= 0) {
            sqlLine = sqlLine.replaceAll(stag, "");
        }
        System.out.println(sqlLine);
        if (sqlLine.indexOf(etag) >= 0) {
            sqlLine = sqlLine.replaceAll(etag, "");
            this.sql.append(sqlLine);
            this.sqltags.add(this.tag);
            this.sqlvalues.add(this.sql.toString());
            this.sql = null;
            this.sql = new StringBuilder();
            this.tag = "";
        } else {
            this.sql.append(sqlLine);
        }
    }

    public boolean close() {
        this.dispose();
        super.close();
        return true;
    }

    public void dispose() {
        this.imgRptGreen.dispose();
    }

    class SqlInformation
    extends Composite {
        public SqlInformation(Composite c, int style) {
            super(c, 262144);
            this.setLayout((Layout)new FillLayout());
            Db2ExplainDialog.this.ti1client = new Composite((Composite)this, 4);
            GridLayout layout = new GridLayout(4, false);
            GridData gd4 = new GridData(4, 4, true, true);
            gd4.minimumWidth = 0;
            Db2ExplainDialog.this.ti1client.setLayout((Layout)layout);
            Label targetSystemLabel = new Label(Db2ExplainDialog.this.ti1client, 0);
            targetSystemLabel.setText(Messages.getString("Db2ExplainDialog.Label.TargetSystem"));
            GridData gd = new GridData(1, 128, false, false, 1, 1);
            targetSystemLabel.setLayoutData((Object)gd);
            Text targetSystemText = new Text(Db2ExplainDialog.this.ti1client, 0);
            targetSystemText.setText(Db2ExplainDialog.this.sqlvalues.get(Db2ExplainDialog.this.sqltags.indexOf("TARGET_SYSTEM")));
            targetSystemText.setEditable(false);
            gd = new GridData(4, 128, true, false, 3, 1);
            targetSystemText.setLayoutData((Object)gd);
            Label db2SubsystemLabel = new Label(Db2ExplainDialog.this.ti1client, 0);
            db2SubsystemLabel.setText(Messages.getString("Db2ExplainDialog.Label.Db2Subsystem"));
            gd = new GridData(1, 128, false, false, 1, 1);
            targetSystemLabel.setLayoutData((Object)gd);
            Text db2SubsystemText = new Text(Db2ExplainDialog.this.ti1client, 0);
            db2SubsystemText.setText(Db2ExplainDialog.this.sqlvalues.get(Db2ExplainDialog.this.sqltags.indexOf("DB2_SUBSYSTEM")));
            db2SubsystemText.setEditable(false);
            gd = new GridData(4, 128, true, false, 1, 1);
            db2SubsystemText.setLayoutData((Object)gd);
            Label db2VersionLabel = new Label(Db2ExplainDialog.this.ti1client, 0);
            db2VersionLabel.setText(Messages.getString("Db2ExplainDialog.Label.Db2Version"));
            gd = new GridData(1, 128, false, false, 1, 1);
            gd.horizontalIndent = 10;
            db2VersionLabel.setLayoutData((Object)gd);
            Text db2VersionText = new Text(Db2ExplainDialog.this.ti1client, 0);
            db2VersionText.setText(Db2ExplainDialog.this.sqlvalues.get(Db2ExplainDialog.this.sqltags.indexOf("DB2_VERSION")));
            db2VersionText.setEditable(false);
            gd = new GridData(4, 128, true, false, 1, 1);
            db2VersionText.setLayoutData((Object)gd);
            Label planNameLabel = new Label(Db2ExplainDialog.this.ti1client, 0);
            planNameLabel.setText(Messages.getString("Db2ExplainDialog.Label.PlanName"));
            gd = new GridData(1, 128, false, false, 1, 1);
            planNameLabel.setLayoutData((Object)gd);
            Text planNameText = new Text(Db2ExplainDialog.this.ti1client, 0);
            planNameText.setText(Db2ExplainDialog.this.sqlvalues.get(Db2ExplainDialog.this.sqltags.indexOf("PLAN_NAME")));
            planNameText.setEditable(false);
            gd = new GridData(4, 128, true, false, 3, 1);
            planNameText.setLayoutData((Object)gd);
            Label dbrmNameLabel = new Label(Db2ExplainDialog.this.ti1client, 0);
            dbrmNameLabel.setText(Messages.getString("Db2ExplainDialog.Label.DbrmName"));
            gd = new GridData(1, 128, false, false, 1, 1);
            dbrmNameLabel.setLayoutData((Object)gd);
            Text dbrmNameText = new Text(Db2ExplainDialog.this.ti1client, 0);
            dbrmNameText.setText(Db2ExplainDialog.this.sqlvalues.get(Db2ExplainDialog.this.sqltags.indexOf("DBRM")));
            dbrmNameText.setEditable(false);
            gd = new GridData(4, 128, true, false, 1, 1);
            dbrmNameText.setLayoutData((Object)gd);
            Label consistencyTokenLabel = new Label(Db2ExplainDialog.this.ti1client, 0);
            consistencyTokenLabel.setText(Messages.getString("Db2ExplainDialog.Label.ConsistencyToken"));
            gd = new GridData(1, 128, false, false, 1, 1);
            gd.horizontalIndent = 10;
            consistencyTokenLabel.setLayoutData((Object)gd);
            Text consistencyTokenText = new Text(Db2ExplainDialog.this.ti1client, 0);
            consistencyTokenText.setText(Db2ExplainDialog.this.sqlvalues.get(Db2ExplainDialog.this.sqltags.indexOf("CONSISTENCY_TOKEN")));
            consistencyTokenText.setEditable(false);
            gd = new GridData(4, 128, true, false, 1, 1);
            consistencyTokenText.setLayoutData((Object)gd);
            Label collIdLabel = new Label(Db2ExplainDialog.this.ti1client, 0);
            collIdLabel.setText(Messages.getString("Db2ExplainDialog.Label.Collid"));
            gd = new GridData(1, 128, false, false, 1, 1);
            collIdLabel.setLayoutData((Object)gd);
            Text collIdText = new Text(Db2ExplainDialog.this.ti1client, 0);
            collIdText.setText(Db2ExplainDialog.this.sqlvalues.get(Db2ExplainDialog.this.sqltags.indexOf("COLLID")));
            collIdText.setEditable(false);
            gd = new GridData(4, 128, true, false, 3, 1);
            collIdText.setLayoutData((Object)gd);
            Label spacer2 = new Label(Db2ExplainDialog.this.ti1client, 0);
            spacer2.setText("");
            gd = new GridData(1, 128, false, false, 4, 1);
            gd.heightHint = 5;
            spacer2.setLayoutData((Object)gd);
            Label staticDynamicLabel = new Label(Db2ExplainDialog.this.ti1client, 0);
            staticDynamicLabel.setText(Messages.getString("Db2ExplainDialog.Label.StaticDynamic"));
            gd = new GridData(1, 128, false, false, 1, 1);
            staticDynamicLabel.setLayoutData((Object)gd);
            Text staticDynamicText = new Text(Db2ExplainDialog.this.ti1client, 0);
            staticDynamicText.setText(Messages.getString("Db2ExplainDialog.Text.StaticDynamic.Static"));
            if (Db2ExplainDialog.this.sqlvalues.get(Db2ExplainDialog.this.sqltags.indexOf("DYNAMIC_SQL")).equalsIgnoreCase("true")) {
                staticDynamicText.setText(Messages.getString("Db2ExplainDialog.Text.StaticDynamic.Dynamic"));
            }
            staticDynamicText.setEditable(false);
            gd = new GridData(4, 128, true, false, 1, 1);
            staticDynamicText.setLayoutData((Object)gd);
            Label dynamicRuleLabel = new Label(Db2ExplainDialog.this.ti1client, 0);
            dynamicRuleLabel.setText(Messages.getString("Db2ExplainDialog.Label.DynamicRule"));
            gd = new GridData(1, 128, false, false, 1, 1);
            gd.horizontalIndent = 10;
            dynamicRuleLabel.setLayoutData((Object)gd);
            Text dynamicRuleText = new Text(Db2ExplainDialog.this.ti1client, 0);
            dynamicRuleText.setText(Db2ExplainDialog.this.sqlvalues.get(Db2ExplainDialog.this.sqltags.indexOf("DYNAMIC_RULES")));
            dynamicRuleText.setEditable(false);
            gd = new GridData(4, 128, true, false, 1, 1);
            dynamicRuleText.setLayoutData((Object)gd);
            Label stmtNumberLabel = new Label(Db2ExplainDialog.this.ti1client, 0);
            stmtNumberLabel.setText(Messages.getString("Db2ExplainDialog.Label.PrecompilerStmtNumber"));
            gd = new GridData(1, 128, false, false, 1, 1);
            stmtNumberLabel.setLayoutData((Object)gd);
            Text stmtNumberText = new Text(Db2ExplainDialog.this.ti1client, 0);
            stmtNumberText.setText(Db2ExplainDialog.this.sqlvalues.get(Db2ExplainDialog.this.sqltags.indexOf("STATEMENT_NUMBER")));
            stmtNumberText.setEditable(false);
            gd = new GridData(4, 128, true, false, 1, 1);
            stmtNumberText.setLayoutData((Object)gd);
            Label sectNumberLabel = new Label(Db2ExplainDialog.this.ti1client, 0);
            sectNumberLabel.setText(Messages.getString("Db2ExplainDialog.Label.DbrmSectionNumber"));
            gd = new GridData(1, 128, false, false, 1, 1);
            gd.horizontalIndent = 10;
            sectNumberLabel.setLayoutData((Object)gd);
            Text sectNumberText = new Text(Db2ExplainDialog.this.ti1client, 0);
            sectNumberText.setText(Db2ExplainDialog.this.sqlvalues.get(Db2ExplainDialog.this.sqltags.indexOf("SECTION_NUMBER")));
            sectNumberText.setEditable(false);
            gd = new GridData(4, 128, true, false, 1, 1);
            sectNumberText.setLayoutData((Object)gd);
            Label qualifierLabel = new Label(Db2ExplainDialog.this.ti1client, 0);
            qualifierLabel.setText(Messages.getString("Db2ExplainDialog.Label.Qualifer"));
            gd = new GridData(1, 128, false, false, 1, 1);
            qualifierLabel.setLayoutData((Object)gd);
            Text qualifierText = new Text(Db2ExplainDialog.this.ti1client, 0);
            qualifierText.setText(Db2ExplainDialog.this.sqlvalues.get(Db2ExplainDialog.this.sqltags.indexOf("QUALIFIER")));
            qualifierText.setEditable(false);
            gd = new GridData(4, 128, true, false, 1, 1);
            qualifierText.setLayoutData((Object)gd);
            Label delimiterLabel = new Label(Db2ExplainDialog.this.ti1client, 0);
            delimiterLabel.setText(Messages.getString("Db2ExplainDialog.Label.StringDelimiter"));
            gd = new GridData(1, 128, false, false, 1, 1);
            gd.horizontalIndent = 10;
            delimiterLabel.setLayoutData((Object)gd);
            Text delimiterText = new Text(Db2ExplainDialog.this.ti1client, 0);
            delimiterText.setText(Db2ExplainDialog.this.sqlvalues.get(Db2ExplainDialog.this.sqltags.indexOf("STRING_DELIM")));
            delimiterText.setEditable(false);
            gd = new GridData(4, 128, true, false, 1, 1);
            delimiterText.setLayoutData((Object)gd);
            Label pathLabel = new Label(Db2ExplainDialog.this.ti1client, 0);
            pathLabel.setText(Messages.getString("Db2ExplainDialog.Label.Path"));
            gd = new GridData(1, 128, false, false, 1, 1);
            pathLabel.setLayoutData((Object)gd);
            Text pathText = new Text(Db2ExplainDialog.this.ti1client, 0);
            pathText.setText(Db2ExplainDialog.this.sqlvalues.get(Db2ExplainDialog.this.sqltags.indexOf("PATH")));
            pathText.setEditable(false);
            gd = new GridData(4, 128, true, false, 3, 1);
            pathText.setLayoutData((Object)gd);
            Label spacer3 = new Label(Db2ExplainDialog.this.ti1client, 0);
            spacer3.setText("");
            gd = new GridData(1, 128, false, false, 4, 1);
            gd.heightHint = 5;
            spacer3.setLayoutData((Object)gd);
            Db2ExplainDialog.this.db2V8CompatButton = new Button(Db2ExplainDialog.this.ti1client, 32);
            Db2ExplainDialog.this.db2V8CompatButton.setText(Messages.getString("Db2ExplainDialog.Text.Db2V8Compat"));
            if (Db2ExplainDialog.this.sqlvalues.get(Db2ExplainDialog.this.sqltags.indexOf("DB2_V8_COMPAT")).equalsIgnoreCase("true")) {
                Db2ExplainDialog.this.db2V8CompatButton.setSelection(true);
            }
            gd = new GridData(4, 128, true, false, 2, 1);
            Db2ExplainDialog.this.db2V8CompatButton.setLayoutData((Object)gd);
            Db2ExplainDialog.this.db2V8CompatButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((SqlInformation)SqlInformation.this).Db2ExplainDialog.this.db2V8CompatButton.getSelection()) {
                        ((SqlInformation)SqlInformation.this).Db2ExplainDialog.this.db2V8CompatButton.setSelection(false);
                    } else {
                        ((SqlInformation)SqlInformation.this).Db2ExplainDialog.this.db2V8CompatButton.setSelection(true);
                    }
                }
            });
            Db2ExplainDialog.this.storedProcSqlButton = new Button(Db2ExplainDialog.this.ti1client, 32);
            Db2ExplainDialog.this.storedProcSqlButton.setText(Messages.getString("Db2ExplainDialog.Text.StoredProcSql"));
            if (Db2ExplainDialog.this.sqlvalues.get(Db2ExplainDialog.this.sqltags.indexOf("STORED_PROC_SQL")).equalsIgnoreCase("true")) {
                Db2ExplainDialog.this.storedProcSqlButton.setSelection(true);
            }
            gd = new GridData(4, 128, true, false, 2, 1);
            gd.horizontalIndent = 10;
            Db2ExplainDialog.this.storedProcSqlButton.setLayoutData((Object)gd);
            Db2ExplainDialog.this.storedProcSqlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((SqlInformation)SqlInformation.this).Db2ExplainDialog.this.storedProcSqlButton.getSelection()) {
                        ((SqlInformation)SqlInformation.this).Db2ExplainDialog.this.storedProcSqlButton.setSelection(false);
                    } else {
                        ((SqlInformation)SqlInformation.this).Db2ExplainDialog.this.storedProcSqlButton.setSelection(true);
                    }
                }
            });
            Db2ExplainDialog.this.stmtInPkgButton = new Button(Db2ExplainDialog.this.ti1client, 32);
            Db2ExplainDialog.this.stmtInPkgButton.setText(Messages.getString("Db2ExplainDialog.Text.StmtInPkg"));
            if (Db2ExplainDialog.this.sqlvalues.get(Db2ExplainDialog.this.sqltags.indexOf("STMT_IN_PKG")).equalsIgnoreCase("true")) {
                Db2ExplainDialog.this.stmtInPkgButton.setSelection(true);
            }
            gd = new GridData(4, 128, true, false, 2, 1);
            Db2ExplainDialog.this.stmtInPkgButton.setLayoutData((Object)gd);
            Db2ExplainDialog.this.stmtInPkgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((SqlInformation)SqlInformation.this).Db2ExplainDialog.this.stmtInPkgButton.getSelection()) {
                        ((SqlInformation)SqlInformation.this).Db2ExplainDialog.this.stmtInPkgButton.setSelection(false);
                    } else {
                        ((SqlInformation)SqlInformation.this).Db2ExplainDialog.this.stmtInPkgButton.setSelection(true);
                    }
                }
            });
            Db2ExplainDialog.this.sqlTextOutputButton = new Button(Db2ExplainDialog.this.ti1client, 32);
            Db2ExplainDialog.this.sqlTextOutputButton.setText(Messages.getString("Db2ExplainDialog.Text.SqlTextOutput"));
            if (Db2ExplainDialog.this.sqlvalues.get(Db2ExplainDialog.this.sqltags.indexOf("SQL_TEXT_OUTPUT")).equalsIgnoreCase("true")) {
                Db2ExplainDialog.this.sqlTextOutputButton.setSelection(true);
            }
            gd = new GridData(4, 128, true, false, 2, 1);
            gd.horizontalIndent = 10;
            Db2ExplainDialog.this.sqlTextOutputButton.setLayoutData((Object)gd);
            Db2ExplainDialog.this.sqlTextOutputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((SqlInformation)SqlInformation.this).Db2ExplainDialog.this.sqlTextOutputButton.getSelection()) {
                        ((SqlInformation)SqlInformation.this).Db2ExplainDialog.this.sqlTextOutputButton.setSelection(false);
                    } else {
                        ((SqlInformation)SqlInformation.this).Db2ExplainDialog.this.sqlTextOutputButton.setSelection(true);
                    }
                }
            });
            Db2ExplainDialog.this.stmtOpenFetchCloseButton = new Button(Db2ExplainDialog.this.ti1client, 32);
            Db2ExplainDialog.this.stmtOpenFetchCloseButton.setText(Messages.getString("Db2ExplainDialog.Text.StmtOpenFetchClose"));
            if (Db2ExplainDialog.this.sqlvalues.get(Db2ExplainDialog.this.sqltags.indexOf("STMT_OFC")).equalsIgnoreCase("true")) {
                Db2ExplainDialog.this.stmtOpenFetchCloseButton.setSelection(true);
            }
            gd = new GridData(4, 128, true, false, 4, 1);
            Db2ExplainDialog.this.stmtOpenFetchCloseButton.setLayoutData((Object)gd);
            Db2ExplainDialog.this.stmtOpenFetchCloseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((SqlInformation)SqlInformation.this).Db2ExplainDialog.this.stmtOpenFetchCloseButton.getSelection()) {
                        ((SqlInformation)SqlInformation.this).Db2ExplainDialog.this.stmtOpenFetchCloseButton.setSelection(false);
                    } else {
                        ((SqlInformation)SqlInformation.this).Db2ExplainDialog.this.stmtOpenFetchCloseButton.setSelection(true);
                    }
                }
            });
        }
    }

    class SqlText
    extends Composite {
        public SqlText(Composite c, int style) {
            super(c, 262144);
            this.setLayout((Layout)new FillLayout());
            Db2ExplainDialog.this.ti2client = new Composite((Composite)this, 4);
            GridLayout layout = new GridLayout(1, false);
            GridData gd4 = new GridData(4, 4, false, true);
            gd4.minimumWidth = 0;
            Db2ExplainDialog.this.ti2client.setLayout((Layout)layout);
            Db2ExplainDialog.this.textViewerSql = new Text(Db2ExplainDialog.this.ti2client, 834);
            Db2ExplainDialog.this.textViewerSql.setText(Db2ExplainDialog.this.sqlvalues.get(Db2ExplainDialog.this.sqltags.indexOf("SQLTEXT")));
            GridData spec = new GridData();
            spec.horizontalAlignment = 4;
            spec.grabExcessHorizontalSpace = true;
            spec.verticalAlignment = 4;
            spec.grabExcessVerticalSpace = true;
            Db2ExplainDialog.this.textViewerSql.setLayoutData((Object)spec);
            Db2ExplainDialog.this.textViewerSql.setEditable(false);
            Color bg = Display.getDefault().getSystemColor(1);
            Db2ExplainDialog.this.textViewerSql.setBackground(bg);
        }
    }
}

