/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs.newobservation;

import com.banknet.core.CorePlugin;
import com.banknet.core.data.ObservationDetail;
import com.banknet.core.data.ScheduleList;
import com.banknet.core.dialogs.newobservation.Messages;
import com.banknet.core.dialogs.newobservation.NewObservationDialog;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.Utilities;
import com.banknet.core.models.CicsTermModel;
import com.banknet.core.models.CicsTranModel;
import com.banknet.core.models.LibsModel;
import com.banknet.core.models.StepsModel;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;

public class NewObservationDialogMapper {
    Constants constants = new Constants();
    Utilities utilities = new Utilities();
    ObservationDetail obsdetail;
    public String pme_reqnbr = "";
    public String pme_jobname = "";
    public String pme_systems = "";
    public String pme_activejob = "";
    public String pme_stepnbr = "";
    public String pme_progname = "";
    public String pme_stepname = "";
    public String pme_procstep = "";
    public String pme_desc = "";
    public String pme_samples = "";
    public String pme_duration = "";
    public boolean pme_flags_eos = false;
    public String pme_delay = "";
    public String pme_notify = "";
    public String pme_expdays = "";
    public String pme_ussmaxobs = "";
    public String pme_notes1 = "";
    public String pme_notes2 = "";
    public String pme_notes3 = "";
    public boolean cicsSelected = false;
    public List<String> selectedextractors = new ArrayList<String>();
    public String pme_db2imax = "";
    public String pme_imsimax = "";
    public String pme_mqimax = "";
    public String pme_arg_dsn = "";
    public String pme_arg_mem = "";
    public boolean pme_flags_dirs;
    public boolean new_libs_radio;
    public String pme_dirs = "";
    public LibsModel[] libsmodel;
    public StepsModel[] stepsmodel;
    public boolean new_cics_radio;
    public CicsTranModel[] cicstranmodel;
    public CicsTermModel[] cicstermmodel;
    public boolean buildCICSY;
    public boolean noncterm;
    public String pme_cics_tran = "";
    public String pme_cics_term = "";
    public String pme_cics_prog = "";
    public boolean new_ims_radio;
    public String pme_ims_txncode = "";
    public String pme_ims_progname = "";
    public String pme_ims_userid = "";
    public String pme_imsmass_txncode = "";
    public String pme_ims_subsystem = "";
    public String pme_ims_jobnames = "";
    public boolean pme_imssubsystem_radio = true;
    public boolean pme_imsplex_radio = false;
    public String pme_imsplex_group = "";
    public boolean new_db2_radio;
    public boolean pme_db2_subsystem_radio = true;
    public boolean pme_db2_group_radio = false;
    public String pme_db2_subsystem = "";
    public String pme_db2_schema = "";
    public boolean pme_db2_program = true;
    public boolean pme_db2_function = false;
    public String pme_db2_name = "";
    public boolean new_ddf_radio;
    public String pme_db2_corrid = "";
    public String pme_db2_enduserid = "";
    public String pme_db2_wkstnid = "";
    public boolean pme_db2_corrid_isnull;
    public boolean pme_db2_enduserid_isnull;
    public boolean pme_db2_wkstnid_isnull;
    public boolean new_was_radio;
    public String pme_was_req = "";
    public String pme_was_app = "";
    public String pme_was_orig = "";
    public String pme_was_fex = "";
    public boolean pme_was_img;
    public boolean pme_was_origIpadr;
    public boolean pme_was_origHost;
    public boolean pme_was_origJob;
    public boolean new_wlp_radio;
    public String pme_wlp_req = "";
    public String pme_wlp_orig = "";
    public boolean pme_wlp_origIpadr;
    public boolean pme_wlp_origHost;
    public ScheduleList schedulelist = new ScheduleList();
    public String pme_m_schdspan = "";
    public String pme_runagainmins = "";
    public String pme_runagaindays = "";
    public String pme_runagainweeks = "";
    public String pme_runagainfor = "";
    public String tm_sel_cpu = "";
    public String tm_sel_elapsedtime = "";
    public String tm_sel_excp = "";
    public static String jobActive = "Active";
    public static String jobInactive = "Inactive";
    public DecimalFormat decfmt1 = new DecimalFormat("#######");
    DecimalFormat df = new DecimalFormat("#0");
    DecimalFormat df2 = new DecimalFormat("00");

    public NewObservationDialogMapper(ObservationDetail obsdetail) {
        this.obsdetail = obsdetail;
    }

    public void loadNewObservationDetails() {
        if (this.obsdetail.pme_reqnbr > 0) {
            this.pme_reqnbr = CorePlugin.getDefault().constants.reqdecfmt.format(this.obsdetail.pme_reqnbr);
        }
        this.loadT1JobInformationDetails();
        this.loadT2OptionsDetails();
        this.loadT3MultiStepDetails();
        this.loadT5CicsIms();
        if (NewObservationDialog.reqAction.equals(this.constants.ACTION_NEW) | NewObservationDialog.reqAction.equals(this.constants.ACTION_MODIFY)) {
            this.loadT7Schedule();
            this.loadT8ScheduleOptions();
        }
        if (NewObservationDialog.reqAction.equals(this.constants.ACTION_TNEW) | NewObservationDialog.reqAction.equals(this.constants.ACTION_TMODIFY)) {
            this.loadT9Criteria();
        }
    }

    private void loadT1JobInformationDetails() {
        if (!NewObservationDialog.reqAction.equals(this.constants.ACTION_TRIGGER)) {
            this.pme_jobname = this.obsdetail.pme_jobname;
        }
        this.pme_systems = this.obsdetail.pme_systems;
        if (this.pme_systems.equals("*")) {
            this.pme_systems = "ALL";
        }
        if (this.pme_systems.length() <= 0) {
            this.pme_systems = !NewObservationDialog.stcproperties.PABENT_FLAGS_DefLocSys ? "ALL" : CorePlugin.getDefault().hostproperties.sSystemName;
        }
        this.pme_activejob = jobInactive;
        this.pme_desc = this.obsdetail.pme_desc;
        if (this.obsdetail.pme_samples > 0) {
            this.pme_samples = this.decfmt1.format(this.obsdetail.pme_samples);
        } else if (NewObservationDialog.stcproperties.PABENT_FLAGS3_FillDefaults) {
            this.pme_samples = NewObservationDialog.stcproperties.nsamples;
        }
        if (this.obsdetail.pme_duration > 0) {
            this.pme_duration = NewObservationDialog.editor.fmtMinsSecs(0, this.obsdetail.pme_duration);
        } else if (NewObservationDialog.stcproperties.PABENT_FLAGS3_FillDefaults) {
            this.pme_duration = NewObservationDialog.editor.fmtMinsSecs(0, new Integer(NewObservationDialog.stcproperties.sampledur));
        }
        this.pme_flags_eos = this.obsdetail.pme_flags_eos;
        if (this.obsdetail.pme_delay > 0) {
            this.pme_delay = this.decfmt1.format(this.obsdetail.pme_delay);
        }
        this.pme_notify = CorePlugin.getDefault().getPreferenceStore().getString("credentialUid");
        this.pme_expdays = this.obsdetail.pme_reqnbr == 0 & this.obsdetail.pme_expdays == 0 ? NewObservationDialog.stcproperties.expirydays : (this.obsdetail.pme_expdays >= 0 ? this.decfmt1.format(this.obsdetail.pme_expdays) : NewObservationDialog.stcproperties.expirydays);
        if (this.obsdetail.pme_ussmaxobs > 0) {
            this.pme_ussmaxobs = this.decfmt1.format(this.obsdetail.pme_ussmaxobs);
        } else if (this.obsdetail.pme_reqnbr > 0 & this.obsdetail.pme_ussmaxobs == 0) {
            this.pme_ussmaxobs = this.decfmt1.format(this.obsdetail.pme_ussmaxobs);
        }
        if (this.obsdetail.pme_ussmaxobs == 0) {
            this.pme_ussmaxobs = "";
        }
        this.pme_notes1 = this.obsdetail.pme_notes1;
        this.pme_notes2 = this.obsdetail.pme_notes2;
        this.pme_notes3 = this.obsdetail.pme_notes3;
    }

    private void loadT2OptionsDetails() {
        if (!NewObservationDialog.reqAction.equals(this.constants.ACTION_TRIGGER)) {
            this.setSelectedExtractors();
            if (this.pme_reqnbr.length() <= 0 && this.selectedextractors.size() <= 0 && NewObservationDialog.reqAction.equalsIgnoreCase(this.constants.ACTION_NEW) | NewObservationDialog.reqAction.equalsIgnoreCase(this.constants.ACTION_TNEW)) {
                this.setDefaultExtractors();
            }
            this.pme_flags_dirs = this.obsdetail.pme_flags_dirs;
            if (this.pme_flags_dirs) {
                this.pme_dirs = this.obsdetail.pme_dirs;
            } else {
                this.new_libs_radio = true;
                this.libsmodel = this.createLibsModel();
            }
        } else {
            this.setDefaultExtractors();
            this.new_libs_radio = true;
            this.libsmodel = this.createLibsModel();
        }
        if (this.obsdetail.pme_reqnbr > 0) {
            this.pme_db2imax = this.constants.decfmt4.format(this.obsdetail.pme_DB2IMaxTraceSize);
            this.pme_imsimax = this.constants.decfmt4.format(this.obsdetail.pme_IMSIMaxTraceSize);
            this.pme_mqimax = this.constants.decfmt4.format(this.obsdetail.pme_MQIMaxTraceSize);
        } else {
            this.pme_db2imax = NewObservationDialog.stcproperties.db2imax;
            this.pme_imsimax = NewObservationDialog.stcproperties.imsimax;
            this.pme_mqimax = NewObservationDialog.stcproperties.mqimax;
        }
        this.pme_arg_dsn = this.obsdetail.pme_ARGDSN;
        this.pme_arg_mem = this.obsdetail.pme_ARGMem;
    }

    private void loadT3MultiStepDetails() {
        this.stepsmodel = this.createStepsModel();
        if (!NewObservationDialog.reqAction.equals(this.constants.ACTION_TRIGGER)) {
            this.pme_stepnbr = NewObservationDialog.stepselements[0].getStepno();
            this.pme_progname = NewObservationDialog.stepselements[0].getProgram();
            this.pme_stepname = NewObservationDialog.stepselements[0].getStepname();
            this.pme_procstep = NewObservationDialog.stepselements[0].getProcstep();
        }
    }

    private void loadT5CicsIms() {
        this.buildCICSY = this.obsdetail.buildCICSY;
        this.noncterm = this.obsdetail.noncterm;
        if (!NewObservationDialog.reqAction.equals(this.constants.ACTION_TRIGGER)) {
            this.pme_ims_txncode = this.obsdetail.pme_ims_txncode;
            this.pme_ims_progname = this.obsdetail.pme_ims_progname;
            this.pme_ims_userid = this.obsdetail.pme_ims_userid;
            this.pme_imsmass_txncode = this.obsdetail.pme_imsmass_txncode;
            this.pme_ims_subsystem = this.obsdetail.pme_ims_subsystem;
            this.pme_imsplex_group = this.obsdetail.pme_imsplex_group;
            if (this.pme_imsplex_group.length() > 0) {
                this.pme_imsplex_radio = true;
                this.pme_imssubsystem_radio = false;
            }
            this.new_ddf_radio = this.obsdetail.ddfsel;
            this.pme_db2_corrid = this.obsdetail.pme_db2_corrid;
            this.pme_db2_enduserid = this.obsdetail.pme_db2_enduserid;
            this.pme_db2_wkstnid = this.obsdetail.pme_db2_wkstnid;
            this.pme_db2_corrid_isnull = this.obsdetail.pme_db2_corrid_isnull;
            this.pme_db2_enduserid_isnull = this.obsdetail.pme_db2_enduserid_isnull;
            this.pme_db2_wkstnid_isnull = this.obsdetail.pme_db2_wkstnid_isnull;
            this.new_was_radio = this.obsdetail.wasFilterSel;
            this.pme_was_req = this.obsdetail.pme_was_req;
            this.pme_was_app = this.obsdetail.pme_was_app;
            this.pme_was_orig = this.obsdetail.pme_was_orig;
            this.pme_was_img = this.obsdetail.pme_was_img;
            this.pme_was_origIpadr = this.obsdetail.pme_was_origIpadr;
            this.pme_was_origHost = this.obsdetail.pme_was_origHost;
            this.pme_was_origJob = this.obsdetail.pme_was_origJob;
            this.pme_was_fex = this.obsdetail.pme_was_fex;
            this.new_wlp_radio = this.obsdetail.wlpFilterSel;
            this.pme_wlp_req = this.obsdetail.pme_wlp_req;
            this.pme_wlp_orig = this.obsdetail.pme_wlp_orig;
            this.pme_wlp_origIpadr = this.obsdetail.pme_wlp_origIpadr;
            this.pme_wlp_origHost = this.obsdetail.pme_wlp_origHost;
            if (this.pme_ims_txncode.length() > 0 || this.pme_ims_progname.length() > 0 || this.pme_ims_userid.length() > 0 || this.pme_ims_subsystem.length() > 0 || this.pme_imsplex_group.length() > 0) {
                this.new_ims_radio = true;
                this.pme_ims_jobnames = this.obsdetail.pme_ims_jobnames;
            } else if (!this.new_ddf_radio && !this.new_was_radio && this.cicsSelected) {
                this.pme_cics_tran = this.obsdetail.pme_cics_trans;
                this.pme_cics_term = this.obsdetail.pme_cics_termids;
                this.pme_cics_prog = this.obsdetail.pme_cics_progs;
                this.new_cics_radio = true;
            }
            if (this.pme_jobname.equals("-")) {
                if (this.obsdetail.pme_sspr_type.equalsIgnoreCase("F")) {
                    this.pme_db2_function = true;
                    this.pme_db2_program = false;
                    this.new_db2_radio = true;
                } else if (this.obsdetail.pme_sspr_type.equalsIgnoreCase("P")) {
                    this.pme_db2_function = false;
                    this.pme_db2_program = true;
                    this.new_db2_radio = true;
                }
                if (this.obsdetail.pme_ssrp_isGroupName) {
                    this.pme_db2_group_radio = true;
                    this.pme_db2_subsystem_radio = false;
                } else {
                    this.pme_db2_group_radio = false;
                    this.pme_db2_subsystem_radio = true;
                }
                this.pme_db2_subsystem = this.obsdetail.pme_sspr_subsys;
                this.pme_db2_schema = this.obsdetail.pme_sspr_schema;
                this.pme_db2_name = this.obsdetail.pme_sspr_name;
            }
        }
        if (this.new_cics_radio && this.cicsSelected && this.pme_reqnbr.length() <= 0 && NewObservationDialog.reqAction.equalsIgnoreCase(this.constants.ACTION_NEW) | NewObservationDialog.reqAction.equalsIgnoreCase(this.constants.ACTION_TNEW) | NewObservationDialog.reqAction.equalsIgnoreCase(this.constants.ACTION_TRIGGER)) {
            this.pme_cics_tran = "*";
            this.pme_cics_term = "*";
            this.pme_cics_prog = "*";
        }
    }

    private void loadT7Schedule() {
        try {
            Calendar currDate = Calendar.getInstance();
            String scurrDate = this.constants.yyyymmddhhmm2.format(new Date());
            Date dcurrDate = this.constants.yyyymmddhhmm2.parse(scurrDate);
            currDate.setTime(dcurrDate);
            Calendar schdDate = Calendar.getInstance();
            int i = 0;
            while (i < this.obsdetail.listSchdDate.size()) {
                schdDate.setTime(this.obsdetail.listSchdDate.get(i));
                long diffMillis = schdDate.getTimeInMillis() - currDate.getTimeInMillis();
                if (diffMillis > 0L) {
                    this.schedulelist.addItem(this.obsdetail.listSchdDate.get(i), Messages.getString("NewObservationDialogMapper.T7.MeasurementScheduled"));
                }
                ++i;
            }
        }
        catch (ParseException ex) {
            System.out.println("loadT7Schedule: Error Parsing Date " + ex);
        }
    }

    private void loadT8ScheduleOptions() {
        if (this.obsdetail.pme_m_schdspan > 0) {
            this.pme_m_schdspan = this.decfmt1.format(this.obsdetail.pme_m_schdspan);
        }
        if (!this.obsdetail.activeJob) {
            if (this.obsdetail.pme_runagainmins > 0) {
                if (this.obsdetail.pme_runagainmins <= 999) {
                    this.pme_runagainmins = this.decfmt1.format(this.obsdetail.pme_runagainmins);
                    this.pme_runagaindays = "";
                    this.pme_runagainweeks = "";
                } else if (this.obsdetail.pme_runagainmins == 10080 | this.obsdetail.pme_runagainmins == 20180 | this.obsdetail.pme_runagainmins == 30240) {
                    int runagainweeks = this.obsdetail.pme_runagainmins / 10080;
                    this.pme_runagainweeks = this.decfmt1.format(runagainweeks);
                    this.pme_runagainmins = "";
                    this.pme_runagaindays = "";
                } else {
                    int runagaindays = this.obsdetail.pme_runagainmins / 1440;
                    this.pme_runagaindays = this.decfmt1.format(runagaindays);
                    this.pme_runagainmins = "";
                    this.pme_runagainweeks = "";
                }
            }
            if (this.obsdetail.pme_runagainfor > 0) {
                this.pme_runagainfor = this.decfmt1.format(this.obsdetail.pme_runagainfor);
            }
        } else {
            if (this.obsdetail.pme_retryafter > 0) {
                this.pme_runagainmins = this.decfmt1.format(this.obsdetail.pme_retryafter);
            }
            if (this.obsdetail.pme_retrytimes > 0) {
                this.pme_runagainfor = this.decfmt1.format(this.obsdetail.pme_retrytimes);
            }
        }
    }

    private void loadT9Criteria() {
        this.tm_sel_cpu = this.obsdetail.tm_sel_cpu;
        this.tm_sel_elapsedtime = this.obsdetail.tm_sel_elapsedtime;
        this.tm_sel_excp = this.obsdetail.tm_sel_excp;
    }

    public void extractNewObservationContents() {
    }

    private StepsModel[] createStepsModel() {
        int i = 0;
        if (!NewObservationDialog.reqAction.equals(this.constants.ACTION_TRIGGER)) {
            i = 0;
            while (i < this.obsdetail.listSteps.size()) {
                StringTokenizer st = new StringTokenizer(this.obsdetail.listSteps.get(i), ",");
                String stepNum = st.nextToken().replace("^", "");
                String stepProgName = st.nextToken().replace("^", "");
                String stepStepName = st.nextToken().replace("^", "");
                String stepProcName = st.nextToken().replace("^", "");
                NewObservationDialog.stepselements[i] = new StepsModel(i, stepNum, stepProgName, stepStepName, stepProcName);
                ++i;
            }
        }
        String stepNum = "";
        if (i == 0 && this.obsdetail.pme_tm_allsteps) {
            stepNum = "*";
        }
        NewObservationDialog.stepselements[i] = new StepsModel(i, stepNum, "", "", "");
        int j = ++i;
        while (j < 20) {
            NewObservationDialog.stepselements[j] = new StepsModel(i, "", "", "", "");
            ++j;
        }
        return NewObservationDialog.stepselements;
    }

    private LibsModel[] createLibsModel() {
        int i = 0;
        if (!NewObservationDialog.reqAction.equals(this.constants.ACTION_TRIGGER)) {
            i = 0;
            while (i < this.obsdetail.listLibs.size()) {
                NewObservationDialog.libselements[i] = new LibsModel(i, "'" + this.obsdetail.listLibs.get(i) + "'");
                ++i;
            }
        }
        int j = i;
        while (j < 10) {
            NewObservationDialog.libselements[j] = new LibsModel(j, "");
            ++j;
        }
        return NewObservationDialog.libselements;
    }

    private void setSelectedExtractors() {
        if (this.obsdetail.cicsExtractor) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_CICS);
            this.cicsSelected = true;
        }
        if (this.obsdetail.cicsiExtractor) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_CICSI);
        }
        if (this.obsdetail.imsExtractor) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_IMS);
        }
        if (this.obsdetail.imsiExtractor) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_IMSI);
        }
        if (this.obsdetail.db2Extractor) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_DB2);
        }
        if (this.obsdetail.db2iExtractor) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_DB2I);
        }
        if (this.obsdetail.db2vExtractor) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_DB2V);
        }
        if (this.obsdetail.db2xExtractor) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_DB2X);
        }
        if (this.obsdetail.cdb2Extractor) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_CDB2);
        }
        if (this.obsdetail.mqsExtractor) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_MQSERIES);
        }
        if (this.obsdetail.mqiExtractor) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_MQI);
        }
        if (this.obsdetail.javaExtractor) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_JAVA);
        }
        if (this.obsdetail.adabasExtractor) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_ADABAS);
        }
        if (this.obsdetail.naturalExtractor) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_NATURAL);
        }
        if (this.obsdetail.wasExtractor & !NewObservationDialog.reqAction.equals(this.constants.ACTION_TNEW) & !NewObservationDialog.reqAction.equals(this.constants.ACTION_TMODIFY)) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_WAS);
        }
        if (this.obsdetail.srbExtractor) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_SRB);
        }
        if (this.obsdetail.sysExtractor) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_SYS);
        }
        if (this.obsdetail.wlpExtractor) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_WLP);
        }
    }

    private void setDefaultExtractors() {
        if (NewObservationDialog.stcproperties.PABENT_CICS) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_CICS);
            this.cicsSelected = true;
        }
        if (NewObservationDialog.stcproperties.PABENT_CICSI) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_CICSI);
            if (!NewObservationDialog.stcproperties.PABENT_CICS) {
                this.selectedextractors.add(this.constants.EXTRACTORTYPE_CICS);
            }
        }
        if (NewObservationDialog.stcproperties.PABENT_IMS) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_IMS);
        }
        if (NewObservationDialog.stcproperties.PABENT_IMSI) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_IMSI);
        }
        if (NewObservationDialog.stcproperties.PABENT_DB2) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_DB2);
        }
        if (NewObservationDialog.stcproperties.PABENT_DB2I) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_DB2I);
        }
        if (NewObservationDialog.stcproperties.PABENT_DB2V) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_DB2V);
        }
        if (NewObservationDialog.stcproperties.PABENT_DB2X) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_DB2X);
        }
        if (NewObservationDialog.stcproperties.PABENT_CDB2) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_CDB2);
        }
        if (NewObservationDialog.stcproperties.PABENT_MQ) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_MQSERIES);
        }
        if (NewObservationDialog.stcproperties.PABENT_MQI) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_MQI);
        }
        if (NewObservationDialog.stcproperties.PABENT_JAVA) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_JAVA);
        }
        if (NewObservationDialog.stcproperties.PABENT_ADA) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_ADABAS);
        }
        if (NewObservationDialog.stcproperties.PABENT_NAT) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_NATURAL);
        }
        if (NewObservationDialog.stcproperties.PABENT_SRB) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_SRB);
        }
        if (NewObservationDialog.stcproperties.PABENT_SYS) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_SYS);
        }
        if (NewObservationDialog.stcproperties.PABENT_WAS & !NewObservationDialog.reqAction.equals(this.constants.ACTION_TNEW) & !NewObservationDialog.reqAction.equals(this.constants.ACTION_TMODIFY)) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_WAS);
        } else if (NewObservationDialog.stcproperties.PABENT_WLP & !NewObservationDialog.reqAction.equals(this.constants.ACTION_TNEW) & !NewObservationDialog.reqAction.equals(this.constants.ACTION_TMODIFY)) {
            this.selectedextractors.add(this.constants.EXTRACTORTYPE_WLP);
        }
    }
}

