/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs.connection;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.dialogs.connection.ConnectionDialog;
import com.banknet.core.dialogs.connection.Messages;
import com.banknet.core.internal.Constants;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;

public class LogonDialog
extends TitleAreaDialog {
    Constants constants = new Constants();
    ZosConnect zosconnect = new ZosConnect();
    Composite content;
    Composite credentialcomp;
    Group logingroup;
    Group connectgroup;
    Shell shell;
    Shell dialogshell;
    Button okButton;
    private Combo credentialsCombo;
    public Text credentialId;
    public Text connectionPsw;
    String errmsg = "";
    private static String CONNECTIONID_LABEL = Messages.getString("CredentialSettings.Label.Userid");
    private static String CONNECTIONPSW_LABEL = Messages.getString("CredentialSettings.Label.Password");
    private static String CREDENTIAL_LABEL = Messages.getString("ConnectionSettingsDialog.Label.Credential");
    public String sconnName = "";
    public String shostAddress = "";
    public String scpuPort = "";
    String decodedPsw = "";
    boolean sslConnect = false;
    String credentialUid = "";
    String encodedPsw = "";
    boolean bsavePsw = false;
    public String connectionid = "";
    public String credentialName = "";
    public String sSslConnect = "false";
    public String credential = "";
    public String scredentialid = "";
    boolean buttonclicked = false;
    Job jobLogon;
    String compatgui_version = "";
    String compatgui_build = "";
    String dlgui_version = "";
    String dlgui_fixpack = "";
    String zOS_dlgui = "";
    String OSenv = "";
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);
    List<String> credentialskeys = new ArrayList<String>();
    Hashtable credentialsdata = new Hashtable();

    public LogonDialog(Shell parentShell, String connectionid) {
        super(parentShell);
        this.shell = parentShell;
        this.connectionid = connectionid;
        try {
            StringBuilder stringBuilder = new StringBuilder("/instance/");
            CorePlugin.getDefault();
            IEclipsePreferences credprefs = InstanceScope.INSTANCE.getNode(stringBuilder.append("com.banknet.core").append("/credentials").toString());
            int i = 0;
            while (i < credprefs.keys().length) {
                this.credentialskeys.add(credprefs.keys()[i]);
                this.credentialsdata.put(credprefs.keys()[i], credprefs.get(credprefs.keys()[i], ""));
                ++i;
            }
        }
        catch (Exception exception) {}
        if (connectionid.length() > 0) {
            this.getConnectionPrefs(connectionid);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("LogonDialog.ShellTitle"));
        newShell.setLocation(385, 235);
        newShell.setImage(CorePlugin.getDefault().productextension.getDialogShellImage());
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        String dialogTitle = Messages.getString("LogonDialog.DialogTitle");
        if (this.credentialName.length() > 0) {
            dialogTitle = this.credentialName;
        }
        this.setTitle(dialogTitle);
        String msg = String.valueOf(this.sconnName) + " - " + this.shostAddress + ":" + this.scpuPort;
        this.setMessage(msg, 1);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        this.dialogshell = parent.getShell();
        this.content = parent;
        ((GridLayout)this.content.getLayout()).numColumns = 2;
        this.credentialcomp = new Composite(this.content, 0);
        GridData gd3 = new GridData(4, 128, true, true, 2, 1);
        this.credentialcomp.setLayoutData((Object)gd3);
        this.credentialcomp.setLayout((Layout)new GridLayout(2, false));
        Label credentialLabel = new Label(this.credentialcomp, 0);
        credentialLabel.setText(String.valueOf(CREDENTIAL_LABEL) + ": ");
        GridData gd = new GridData(1, 0x1000000, false, false);
        credentialLabel.setLayoutData((Object)gd);
        this.credentialsCombo = new Combo(this.credentialcomp, 8);
        this.loadCredentialsCombo();
        gd = new GridData(1, 0x1000000, true, false, 1, 1);
        this.credentialsCombo.setLayoutData((Object)gd);
        this.credentialsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selcredential = "";
                try {
                    selcredential = LogonDialog.this.credentialskeys.get(LogonDialog.this.credentialsCombo.getSelectionIndex());
                }
                catch (Exception exception) {}
                LogonDialog.this.setSelectedCredential(selcredential);
            }
        });
        Label credentialIdLabel = new Label(this.credentialcomp, 0);
        credentialIdLabel.setText(String.valueOf(CONNECTIONID_LABEL) + ": ");
        gd = new GridData(1, 128, false, false);
        credentialIdLabel.setLayoutData((Object)gd);
        this.credentialId = new Text(this.credentialcomp, 2048);
        this.credentialId.setTextLimit(8);
        gd = new GridData(1, 128, true, false);
        gd.minimumWidth = 100;
        this.credentialId.setLayoutData((Object)gd);
        this.credentialId.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                LogonDialog.this.credentialId.setText(LogonDialog.this.credentialId.getText());
                String addr = LogonDialog.this.shostAddress;
                if (LogonDialog.this.shostAddress.indexOf(".") >= 0) {
                    addr = LogonDialog.this.shostAddress.substring(0, LogonDialog.this.shostAddress.indexOf("."));
                }
                LogonDialog.this.credentialName = String.valueOf(LogonDialog.this.credentialId.getText()) + "@" + addr + LogonDialog.this.scpuPort;
                LogonDialog.this.setTitle(LogonDialog.this.credentialName);
            }
        });
        this.credentialId.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        Label connectionPswLabel = new Label(this.credentialcomp, 0);
        connectionPswLabel.setText(String.valueOf(CONNECTIONPSW_LABEL) + ": ");
        gd = new GridData(1, 128, false, false);
        connectionPswLabel.setLayoutData((Object)gd);
        this.connectionPsw = new Text(this.credentialcomp, 2048);
        this.connectionPsw.setEchoChar('*');
        gd = new GridData(4, 128, true, false);
        this.connectionPsw.setLayoutData((Object)gd);
        this.connectionPsw.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                LogonDialog.this.connectionPsw.setText(LogonDialog.this.connectionPsw.getText());
            }
        });
        this.connectionPsw.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        Label spacer = new Label(this.credentialcomp, 0);
        gd = new GridData(1, 128, false, false, 1, 1);
        gd.horizontalIndent = 5;
        spacer.setLayoutData((Object)gd);
        Button editConnectionButton = new Button(this.credentialcomp, 8);
        editConnectionButton.setText(Messages.getString("LogonDialog.Button.Text.EditConnection"));
        gd = new GridData(131072, 4, true, true, 1, 1);
        editConnectionButton.setLayoutData((Object)gd);
        editConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionDialog cd = new ConnectionDialog(LogonDialog.this.shell.getShell(), LogonDialog.this.connectionid);
                int cdrc = cd.open();
                if (cdrc == 0) {
                    LogonDialog.this.getConnectionPrefs(LogonDialog.this.connectionid);
                }
                cd = null;
            }
        });
        this.setSelectedCredential(this.scredentialid);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite client = new Composite(this.content, 0);
        GridLayout layout = new GridLayout(1, false);
        client.setLayoutData((Object)new GridData(131072, 1024, true, false, 1, 1));
        client.setLayout((Layout)layout);
        this.okButton = this.createButton(client, 0, Messages.getString("CredentialSettings.Button.Text.Ok"), true);
        this.createButton(client, 1, Messages.getString("CredentialSettings.Button.Text.Cancel"), false);
        this.buttonclicked = false;
        this.content.layout(false);
    }

    public void okPressed() {
        if (this.chkComplete()) {
            this.setCredentialVars();
            this.runLogonZosJob();
        }
    }

    public void cancelPressed() {
        this.setReturnCode(1);
        if (this.jobLogon != null) {
            this.jobLogon.cancel();
            this.jobLogon = null;
        }
        this.close();
        super.cancelPressed();
    }

    public boolean chkComplete() {
        boolean isComplete = true;
        this.errmsg = "";
        if (!this.chkConnectionId()) {
            isComplete = false;
        } else if (!this.chkConnectionPsw()) {
            isComplete = false;
        }
        if (this.errmsg.length() > 0) {
            this.showMessage("error", Messages.getString("LogonDialog.MessageDialog.errorTitle.ZosLogon"), this.errmsg);
        }
        return isComplete;
    }

    private boolean chkConnectionId() {
        boolean isValid = true;
        this.errmsg = this.chkMandatory(this.credentialId.getText().trim(), CONNECTIONID_LABEL);
        if (this.errmsg.length() > 0) {
            isValid = false;
        }
        return isValid;
    }

    private boolean chkConnectionPsw() {
        boolean isValid = true;
        this.errmsg = this.chkMandatory(this.connectionPsw.getText(), CONNECTIONPSW_LABEL);
        if (this.errmsg.length() > 0) {
            isValid = false;
        }
        return isValid;
    }

    private String chkMandatory(String val, String varname) {
        if (val.length() <= 0) {
            this.errmsg = String.valueOf(Messages.getString("LogonDialog.errorMessage.Mandatory")) + varname;
        }
        return this.errmsg;
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
        }
    }

    public int getShellStyle() {
        return 134384;
    }

    public void runLogonZosJob() {
        this.jobLogon = null;
        this.jobLogon = new Job(Messages.getString("LogonDialog.Job.Title.ZosLogon")){
            int jobrc;
            {
                this.jobrc = 0;
            }

            public IStatus run(IProgressMonitor monitor) {
                LogonDialog.this.zosconnect.shostAddress = LogonDialog.this.shostAddress;
                LogonDialog.this.zosconnect.scpuPort = LogonDialog.this.scpuPort;
                LogonDialog.this.zosconnect.decodedPsw = LogonDialog.this.decodedPsw;
                LogonDialog.this.zosconnect.sslConnect = LogonDialog.this.sslConnect;
                LogonDialog.this.zosconnect.banknetConnect();
                if (LogonDialog.this.zosconnect.connrc < 0) {
                    return Status.CANCEL_STATUS;
                }
                CorePlugin.getDefault().monitor = monitor;
                LogonDialog.this.zosconnect.logonZos();
                if (LogonDialog.this.zosconnect.connrc < 0) {
                    return Status.CANCEL_STATUS;
                }
                this.setName("");
                return Status.OK_STATUS;
            }
        };
        this.jobLogon.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("Logon Job completed successfully");
                } else {
                    System.out.println("Logon Job cancelled");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).LogonDialog.this.buttonclicked = false;
                        if ((this).LogonDialog.this.zosconnect.connrc == 0) {
                            CorePlugin.getDefault().getPreferenceStore().setValue("activeConnectionId", (this).LogonDialog.this.connectionid);
                            CorePlugin.getDefault().getPreferenceStore().setValue("coreConnected", true);
                            if ((this).LogonDialog.this.zosconnect.getAHostById((this).LogonDialog.this.connectionid) == null) {
                                CorePlugin.getDefault().connectedHosts.add((this).LogonDialog.this.connectionid);
                            }
                            LogonDialog.this.insertCredentialPrefs();
                            (this).LogonDialog.this.zosconnect.chkUpdatesAvailable();
                            LogonDialog.this.setReturnCode(0);
                            LogonDialog.this.close();
                        } else {
                            LogonDialog.this.showMessage("error", Messages.getString("LogonDialog.MessageDialog.errorTitle.ConnectionFailed"), (this).LogonDialog.this.zosconnect.errmsg);
                            (this).LogonDialog.this.connectionPsw.setFocus();
                        }
                    }
                });
            }
        });
        this.jobLogon.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        this.jobLogon.schedule();
    }

    private void logMessage(char loglevel, String logstr) {
        System.out.println("LogonDialog - " + logstr);
        switch (loglevel) {
            case 'E': {
                CorePlugin.getDefault().log.error(logstr);
                break;
            }
            case 'I': {
                CorePlugin.getDefault().log.info(logstr);
                break;
            }
            case 'W': {
                CorePlugin.getDefault().log.warn(logstr);
                break;
            }
            default: {
                CorePlugin.getDefault().log.debug(logstr);
            }
        }
    }

    public String stripChar(String val, char stripchar) {
        String strippedval = "";
        if (val.indexOf(stripchar) < 0) {
            return val;
        }
        int i = 0;
        while (i < val.length()) {
            if (val.charAt(i) != stripchar) {
                strippedval = val.substring(i, val.length());
                break;
            }
            ++i;
        }
        if (strippedval.length() <= 0) {
            strippedval = val.substring(val.length() - 1);
        }
        return strippedval;
    }

    private void getConnectionPrefs(String connectionid) {
        this.connectionid = connectionid;
        StringBuilder stringBuilder = new StringBuilder("/instance/");
        CorePlugin.getDefault();
        IEclipsePreferences connpref = InstanceScope.INSTANCE.getNode(stringBuilder.append("com.banknet.core").append("/connections/").append(connectionid).toString());
        try {
            if (connpref.keys().length <= 0) {
                StringBuilder stringBuilder2 = new StringBuilder("/instance/");
                CorePlugin.getDefault();
                IEclipsePreferences connprefs = InstanceScope.INSTANCE.getNode(stringBuilder2.append("com.banknet.core").append("/connections").toString());
                connectionid = connprefs.childrenNames()[0];
                StringBuilder stringBuilder3 = new StringBuilder("/instance/");
                CorePlugin.getDefault();
                connpref = InstanceScope.INSTANCE.getNode(stringBuilder3.append("com.banknet.core").append("/connections/").append(connectionid).toString());
            }
        }
        catch (Exception exception) {}
        this.sconnName = connpref.get(this.constants.CONNPREF_CONN_NAME, "");
        this.shostAddress = connpref.get(this.constants.CONNPREF_SERVER_NAME, "");
        this.scpuPort = connpref.get(this.constants.CONNPREF_PORT_NAME, "");
        String sSslConnect = connpref.get(this.constants.CONNPREF_OVERRIDE_SSL, "");
        if (sSslConnect.equalsIgnoreCase("true")) {
            this.sslConnect = true;
        }
        this.scredentialid = connpref.get(this.constants.CONNPREF_CREDENTIAL_ID, "");
    }

    private void setCredentialVars() {
        CorePlugin.getDefault().tsoid = this.credentialId.getText().trim();
        this.credentialUid = this.credentialId.getText().trim();
        this.decodedPsw = this.connectionPsw.getText();
        if (this.scredentialid.length() > 0) {
            System.out.println("credential id: " + this.scredentialid + ":" + this.credential);
        } else {
            String cred;
            int hc = ((Object)((Object)this)).hashCode();
            int cnt = 0;
            this.scredentialid = cred = String.valueOf(Math.abs(hc)) + "_" + ++cnt;
            System.out.println("credential id: " + this.scredentialid + ":" + this.credential);
            String addr = this.shostAddress;
            if (this.shostAddress.indexOf(".") >= 0) {
                addr = this.shostAddress.substring(0, this.shostAddress.indexOf("."));
            }
            this.credentialName = String.valueOf(this.credentialUid) + "@" + addr + this.scpuPort;
        }
        this.credential = String.valueOf(this.credentialName) + "|" + this.credentialUid + "|" + this.bsavePsw + "|" + this.encodedPsw;
    }

    private void insertCredentialPrefs() {
        try {
            StringBuilder stringBuilder = new StringBuilder("/instance/");
            CorePlugin.getDefault();
            IEclipsePreferences credpref = InstanceScope.INSTANCE.getNode(stringBuilder.append("com.banknet.core").append("/credentials/").append(this.scredentialid).toString());
            StringBuilder stringBuilder2 = new StringBuilder("/instance/");
            CorePlugin.getDefault();
            IEclipsePreferences credprefs = InstanceScope.INSTANCE.getNode(stringBuilder2.append("com.banknet.core").append("/credentials").toString());
            credpref.removeNode();
            credprefs.flush();
            credprefs.put(this.scredentialid, this.credential);
            StringBuilder stringBuilder3 = new StringBuilder("/instance/");
            CorePlugin.getDefault();
            IEclipsePreferences connpref = InstanceScope.INSTANCE.getNode(stringBuilder3.append("com.banknet.core").append("/connections/").append(this.connectionid).toString());
            connpref.get(this.constants.CONNPREF_CREDENTIAL_ID, "");
            connpref.put(CorePlugin.getDefault().constants.CONNPREF_CREDENTIAL_ID, this.scredentialid);
            credprefs.flush();
            connpref.flush();
        }
        catch (BackingStoreException backingStoreException) {
        }
        catch (Exception exception) {}
    }

    private void loadCredentialsCombo() {
        this.credentialsCombo.setRedraw(false);
        this.credentialsCombo.removeAll();
        int i = 0;
        while (i < this.credentialskeys.size()) {
            String[] credentialArr = this.s1.split((String)this.credentialsdata.get(this.credentialskeys.get(i)), -1);
            this.credentialsCombo.setData(credentialArr[0], (Object)this.credentialskeys.get(i));
            this.credentialsCombo.add(credentialArr[0]);
            if (this.scredentialid.length() <= 0 && i == 0) {
                this.credentialsCombo.select(i);
                this.scredentialid = this.credentialskeys.get(i);
            } else if (this.scredentialid.equalsIgnoreCase(this.credentialskeys.get(i))) {
                this.credentialsCombo.select(i);
            }
            ++i;
        }
        this.credentialsCombo.setData(Messages.getString("LogonDialog.Combo.NewCredential"), (Object)"");
        this.credentialsCombo.add(Messages.getString("LogonDialog.Combo.NewCredential"));
        if (this.scredentialid.length() <= 0) {
            this.credentialsCombo.select(this.credentialskeys.size());
        }
        this.credentialsCombo.setRedraw(true);
        this.credentialsCombo.redraw();
    }

    private void setSelectedCredential(String selcredential) {
        this.scredentialid = selcredential;
        this.credentialName = "";
        this.credentialUid = "";
        this.bsavePsw = false;
        this.encodedPsw = "";
        try {
            if (selcredential.length() > 0) {
                String[] credentialArr = this.s1.split((String)this.credentialsdata.get(this.scredentialid), -1);
                this.credentialName = credentialArr[0];
                this.credentialUid = credentialArr[1];
                this.encodedPsw = credentialArr[2];
                if (credentialArr[2].equalsIgnoreCase("true")) {
                    this.bsavePsw = true;
                }
                String tmppsw = "";
                int i = 3;
                while (i < credentialArr.length) {
                    if (tmppsw.length() > 0) {
                        tmppsw = String.valueOf(tmppsw) + "|";
                    }
                    tmppsw = String.valueOf(tmppsw) + credentialArr[i];
                    ++i;
                }
                this.encodedPsw = tmppsw;
            }
        }
        catch (Exception exception) {}
        this.credentialId.setText(this.credentialUid);
        this.connectionPsw.setText("");
        String dialogTitle = Messages.getString("LogonDialog.DialogTitle");
        if (this.credentialName.length() > 0) {
            dialogTitle = this.credentialName;
        }
        this.setTitle(dialogTitle);
    }
}

