/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs.connection;

import com.banknet.core.CorePlugin;
import com.banknet.core.dialogs.connection.Messages;
import com.banknet.core.internal.Constants;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CredentialSettingsDialog
extends Dialog {
    Constants constants = new Constants();
    Composite content;
    Composite credentialcomp;
    Group logingroup;
    Group connectgroup;
    Shell shell;
    Shell dialogshell;
    Button okButton;
    public Text credentialNameText;
    public Text userIdText;
    public Text passwordText;
    String errmsg = "";
    private static String CREDENTIALNAME_LABEL = Messages.getString("CredentialSettings.Label.CredentialName");
    private static String USERID_LABEL = Messages.getString("CredentialSettings.Label.Userid");
    private static String PASSWORD_LABEL = Messages.getString("CredentialSettings.Label.Password");
    public String credentialName = "";
    public String userId = "";
    public String decodedPsw = "";
    public String encodedPsw = "";
    public String credentialid = "";
    public boolean savePsw = false;
    public String credential = "";
    public boolean showPsw = true;
    boolean buttonclicked = false;
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);

    public CredentialSettingsDialog(Shell parentShell) {
        super(parentShell);
        this.shell = parentShell;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("CredentialSettingsDialog.ShellTitle"));
        newShell.setLocation(385, 235);
        newShell.setImage(CorePlugin.getDefault().productextension.getDialogShellImage());
    }

    protected Control createDialogArea(Composite parent) {
        this.dialogshell = parent.getShell();
        this.content = parent;
        ((GridLayout)this.content.getLayout()).numColumns = 2;
        GridData gd2 = new GridData(1, 4, true, true, 2, 1);
        gd2.widthHint = 340;
        this.content.setLayoutData((Object)gd2);
        this.credentialcomp = new Composite(this.content, 0);
        this.credentialcomp.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.credentialcomp.setLayout((Layout)new GridLayout(2, false));
        Label instr = new Label(this.credentialcomp, 64);
        instr.setText(Messages.getString("CredentialSettingsDialog.Label.Instructions"));
        gd2 = new GridData(4, 128, true, false, 2, 1);
        gd2.heightHint = 40;
        gd2.widthHint = 340;
        instr.setLayoutData((Object)gd2);
        Label credentialNameLabel = new Label(this.credentialcomp, 0);
        credentialNameLabel.setText(String.valueOf(CREDENTIALNAME_LABEL) + ": ");
        GridData gd = new GridData(1, 0x1000000, false, false);
        gd.horizontalIndent = 5;
        credentialNameLabel.setLayoutData((Object)gd);
        this.credentialNameText = new Text(this.credentialcomp, 2048);
        this.credentialNameText.setText(this.credentialName);
        gd = new GridData(4, 0x1000000, true, false, 1, 1);
        this.credentialNameText.setLayoutData((Object)gd);
        this.credentialNameText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.credentialNameText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CredentialSettingsDialog.this.credentialNameText.setText(CredentialSettingsDialog.this.credentialNameText.getText());
            }
        });
        Label userIdLabel = new Label(this.credentialcomp, 0);
        userIdLabel.setText(String.valueOf(USERID_LABEL) + ": ");
        gd = new GridData(1, 128, false, false);
        gd.horizontalIndent = 5;
        userIdLabel.setLayoutData((Object)gd);
        this.userIdText = new Text(this.credentialcomp, 2048);
        this.userIdText.setText(this.userId);
        this.userIdText.setTextLimit(8);
        gd = new GridData(1, 128, true, false);
        gd.minimumWidth = 100;
        this.userIdText.setLayoutData((Object)gd);
        this.userIdText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CredentialSettingsDialog.this.userIdText.setText(CredentialSettingsDialog.this.userIdText.getText().trim());
            }
        });
        this.userIdText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                CredentialSettingsDialog.this.credentialNameText.setText(CredentialSettingsDialog.this.userIdText.getText());
            }
        });
        Label connectionPswLabel = new Label(this.credentialcomp, 0);
        connectionPswLabel.setText(String.valueOf(PASSWORD_LABEL) + ": ");
        gd = new GridData(1, 128, false, false);
        gd.horizontalIndent = 5;
        connectionPswLabel.setLayoutData((Object)gd);
        this.passwordText = new Text(this.credentialcomp, 2048);
        this.passwordText.setEchoChar('*');
        gd = new GridData(4, 0x1000000, true, false, 1, 1);
        this.passwordText.setLayoutData((Object)gd);
        this.passwordText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CredentialSettingsDialog.this.passwordText.setText(CredentialSettingsDialog.this.passwordText.getText());
            }
        });
        this.passwordText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.userIdText.setFocus();
        this.content.layout(false);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite client = new Composite(this.content, 0);
        GridLayout layout = new GridLayout(2, false);
        GridData gd = new GridData(131072, 1024, true, true, 2, 1);
        client.setLayoutData((Object)gd);
        client.setLayout((Layout)layout);
        this.okButton = this.createButton(client, 0, Messages.getString("CredentialSettings.Button.Text.Ok"), true);
        this.createButton(client, 1, Messages.getString("CredentialSettings.Button.Text.Cancel"), false);
        this.buttonclicked = false;
        this.content.layout(false);
    }

    public void okPressed() {
        if (this.chkComplete()) {
            this.setCredentialVars();
            this.setReturnCode(0);
            this.close();
        }
    }

    public void cancelPressed() {
        this.setReturnCode(1);
        this.close();
        super.cancelPressed();
    }

    private void setCredentialVars() {
        this.credentialName = this.credentialNameText.getText().trim();
        this.userId = this.userIdText.getText().trim();
        this.decodedPsw = this.passwordText.getText();
        this.credential = String.valueOf(this.credentialName) + "|" + this.userId + "|" + this.savePsw + "|";
        if (this.credentialid.length() > 0) {
            System.out.println("credential id: " + this.credentialid + ":" + this.credential);
        } else {
            String cred;
            int hc = ((Object)((Object)this)).hashCode();
            int cnt = 0;
            this.credentialid = cred = String.valueOf(Math.abs(hc)) + "_" + ++cnt;
            System.out.println("credential id: " + this.credentialid + ":" + this.credential);
        }
    }

    public boolean chkComplete() {
        boolean isComplete = true;
        this.errmsg = "";
        if (!this.chkCredentialName()) {
            isComplete = false;
        } else if (!this.chkConnectionId()) {
            isComplete = false;
        } else if (!this.chkConnectionPsw()) {
            isComplete = false;
        }
        if (this.errmsg.length() > 0) {
            this.showMessage("error", Messages.getString("CredentialSettingsDialog.MessageDialog.errorTitle"), this.errmsg);
        }
        return isComplete;
    }

    private boolean chkCredentialName() {
        boolean isValid = true;
        this.errmsg = this.chkMandatory(this.credentialNameText.getText().trim(), CREDENTIALNAME_LABEL);
        if (this.errmsg.length() <= 0) {
            this.errmsg = this.chkWindowsName(this.credentialNameText.getText().trim(), CREDENTIALNAME_LABEL);
        }
        if (this.errmsg.length() > 0) {
            isValid = false;
        }
        return isValid;
    }

    private boolean chkConnectionId() {
        boolean isValid = true;
        this.errmsg = this.chkMandatory(this.userIdText.getText().trim(), USERID_LABEL);
        if (this.errmsg.length() > 0) {
            isValid = false;
        }
        return isValid;
    }

    private boolean chkConnectionPsw() {
        boolean isValid = true;
        if (this.errmsg.length() > 0) {
            isValid = false;
        }
        return isValid;
    }

    private String chkMandatory(String val, String varname) {
        if (val.length() <= 0) {
            this.errmsg = String.valueOf(Messages.getString("LogonDialog.errorMessage.Mandatory")) + varname;
        }
        return this.errmsg;
    }

    private String chkInteger(String val, String varname) {
        Integer ival = 0;
        String errmsg = "";
        try {
            ival = new Integer(val);
        }
        catch (NumberFormatException numberFormatException) {
            errmsg = String.valueOf(varname) + Messages.getString("LogonDialog.chkInteger.NotNumeric");
            return errmsg;
        }
        if (ival <= 0) {
            errmsg = String.valueOf(varname) + Messages.getString("LogonDialog.chkInteger.ValueTooSmall");
            return errmsg;
        }
        return errmsg;
    }

    private String chkWindowsName(String val, String varname) {
        String errmsg = "";
        char[] chars = val.toCharArray();
        int x = 0;
        while (x < chars.length) {
            char c = chars[x];
            if (c == '\\' || c == '/' || c == ':' || c == '*' || c == '?' || c == '\"' || c == '<' || c == '>' || c == '|') {
                errmsg = String.valueOf(varname) + Messages.getString("CredentialSettingsDialog.chkWindowsName.Invalid");
                return errmsg;
            }
            ++x;
        }
        return errmsg;
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
        }
    }

    public int getShellStyle() {
        return 134384;
    }

    private void logMessage(char loglevel, String logstr) {
        System.out.println("CredentialSettingsDialog - " + logstr);
        switch (loglevel) {
            case 'E': {
                CorePlugin.getDefault().log.error(logstr);
                break;
            }
            case 'I': {
                CorePlugin.getDefault().log.info(logstr);
                break;
            }
            case 'W': {
                CorePlugin.getDefault().log.warn(logstr);
                break;
            }
            default: {
                CorePlugin.getDefault().log.debug(logstr);
            }
        }
    }
}

