/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs.connection;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.dialogs.connection.CredentialSettingsDialog;
import com.banknet.core.dialogs.connection.Messages;
import com.banknet.core.internal.Constants;
import com.banknet.core.preferences.PreferencesUtilities;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConnectionSettingsDialog
extends Dialog {
    Constants constants = new Constants();
    ZosConnect zosconnect = new ZosConnect();
    PreferencesUtilities prefutils;
    Composite content;
    Group credentialcomp;
    Group logingroup;
    Group connectgroup;
    Shell shell;
    Shell dialogshell;
    Button okButton;
    public Text credentialId;
    public Text connectionPsw;
    private Text cpuPort;
    private Text connName;
    private Text hostAddress;
    private Button sslConnection;
    private Combo credentialsCombo;
    private Button addCredentialButton;
    String errmsg = "";
    private static String HOSTNAME_LABEL = Messages.getString("ConnectionSettings.Label.HostName");
    private static String HOSTADDRESS_LABEL = Messages.getString("ConnectionSettings.Label.HostAddress");
    private static String CPUPORT_LABEL = Messages.getString("ConnectionSettings.Label.HostPort");
    private static String CONNECTIONID_LABEL = Messages.getString("CredentialSettings.Label.Userid");
    private static String CREDENTIAL_LABEL = Messages.getString("ConnectionSettingsDialog.Label.Credential");
    public String sconnName = "";
    public String shostAddress = "";
    public String scpuPort = "";
    public String sSslConnect = "false";
    public boolean sslConnect = false;
    public String scredentialid = "";
    public String credential = "";
    String decodedPsw = "";
    boolean buttonclicked = false;
    Job jobTestConnection;
    public String connectionid = "";
    public List<String> credentialskeys = new ArrayList<String>();
    public Hashtable credentialsdata = new Hashtable();
    boolean autofillName = true;
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);

    public ConnectionSettingsDialog(Shell parentShell) {
        super(parentShell);
        this.shell = parentShell;
        this.prefutils = new PreferencesUtilities(this.shell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("ConnectionSettingsDialog.ShellTitle"));
        newShell.setLocation(420, 235);
        newShell.setImage(CorePlugin.getDefault().productextension.getDialogShellImage());
    }

    protected Control createDialogArea(Composite parent) {
        this.dialogshell = parent.getShell();
        this.content = parent;
        ((GridLayout)this.content.getLayout()).numColumns = 2;
        GridData gd2 = new GridData(1, 4, true, true, 2, 1);
        gd2.widthHint = 400;
        this.content.setLayoutData((Object)gd2);
        Composite connectioncomp = new Composite(this.content, 0);
        connectioncomp.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        connectioncomp.setLayout((Layout)new GridLayout(2, false));
        Label connNameLabel = new Label(connectioncomp, 0);
        connNameLabel.setText(String.valueOf(HOSTNAME_LABEL) + ": ");
        GridData gd = new GridData(1, 128, false, false);
        gd.horizontalIndent = 5;
        connNameLabel.setLayoutData((Object)gd);
        this.connName = new Text(connectioncomp, 2048);
        this.connName.setText(this.sconnName);
        gd = new GridData(4, 128, true, false, 1, 1);
        this.connName.setLayoutData((Object)gd);
        this.connName.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                ConnectionSettingsDialog.this.autofillName = false;
            }
        });
        this.connName.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ConnectionSettingsDialog.this.connName.setText(ConnectionSettingsDialog.this.connName.getText());
            }
        });
        if (this.connName.getText().trim().length() > 0) {
            this.autofillName = false;
        }
        this.connectgroup = new Group(connectioncomp, 0);
        this.connectgroup.setText(Messages.getString("ConnectionSettings.GroupLabel.LocationSettings"));
        this.connectgroup.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.connectgroup.setLayout((Layout)new GridLayout(3, false));
        Label hostAddressLabel = new Label((Composite)this.connectgroup, 0);
        hostAddressLabel.setText(String.valueOf(HOSTADDRESS_LABEL) + ": ");
        gd = new GridData(1, 128, false, false);
        hostAddressLabel.setLayoutData((Object)gd);
        this.hostAddress = new Text((Composite)this.connectgroup, 2048);
        this.hostAddress.setText(this.shostAddress);
        gd = new GridData(4, 128, true, false, 2, 1);
        this.hostAddress.setLayoutData((Object)gd);
        this.hostAddress.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                ConnectionSettingsDialog.this.autofillName = true;
                if (true) {
                    ConnectionSettingsDialog.this.autofillConnName();
                }
            }
        });
        this.hostAddress.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
            }
        });
        Label cpuPortLabel = new Label((Composite)this.connectgroup, 0);
        cpuPortLabel.setText(String.valueOf(CPUPORT_LABEL) + ": ");
        gd = new GridData(1, 128, false, false);
        cpuPortLabel.setLayoutData((Object)gd);
        this.cpuPort = new Text((Composite)this.connectgroup, 2052);
        this.cpuPort.setText(this.scpuPort);
        this.cpuPort.setTextLimit(5);
        this.cpuPort.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                ConnectionSettingsDialog.this.autofillName = true;
                if (true) {
                    ConnectionSettingsDialog.this.autofillConnName();
                }
            }
        });
        this.cpuPort.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ConnectionSettingsDialog.this.cpuPort.setText(ConnectionSettingsDialog.this.cpuPort.getText());
            }
        });
        gd = new GridData(1, 128, false, false, 2, 1);
        gd.widthHint = 60;
        this.cpuPort.setLayoutData((Object)gd);
        Group sslgroup = new Group(connectioncomp, 0);
        sslgroup.setText(Messages.getString("ConnectionSettings.GroupLabel.SSLSettings"));
        sslgroup.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        sslgroup.setLayout((Layout)new GridLayout(3, false));
        this.sslConnection = new Button((Composite)sslgroup, 32);
        this.sslConnection.setText(Messages.getString("ConnectionSettings.Checkbox.SslConnection"));
        if (this.sSslConnect.equalsIgnoreCase("true")) {
            this.sslConnection.setSelection(true);
        }
        gd = new GridData(1, 0x1000000, false, false, 3, 1);
        this.sslConnection.setLayoutData((Object)gd);
        this.sslConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.credentialcomp = new Group(connectioncomp, 0);
        this.credentialcomp.setText(Messages.getString("ConnectionSettingsDialog.GroupLabel.CredentialSettings"));
        this.credentialcomp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.credentialcomp.setLayout((Layout)new GridLayout(3, false));
        Label credentialLabel = new Label((Composite)this.credentialcomp, 0);
        credentialLabel.setText(String.valueOf(CREDENTIAL_LABEL) + ": ");
        gd = new GridData(1, 0x1000000, false, false);
        credentialLabel.setLayoutData((Object)gd);
        this.credentialsCombo = new Combo((Composite)this.credentialcomp, 8);
        this.loadCredentialsCombo();
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        this.credentialsCombo.setLayoutData((Object)gd);
        this.credentialsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selcredential;
                ConnectionSettingsDialog.this.scredentialid = selcredential = ConnectionSettingsDialog.this.credentialskeys.get(ConnectionSettingsDialog.this.credentialsCombo.getSelectionIndex());
            }
        });
        this.addCredentialButton = new Button((Composite)this.credentialcomp, 8);
        this.addCredentialButton.setText(Messages.getString("ConnectionSettingsDialog.Button.AddCredential"));
        GridData gdb = new GridData(1, 0x1000000, true, false, 1, 1);
        gdb.horizontalIndent = 10;
        this.addCredentialButton.setLayoutData((Object)gdb);
        this.addCredentialButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionSettingsDialog.this.launchCredentialDialog("");
                ConnectionSettingsDialog.this.loadCredentialsCombo();
            }
        });
        Composite testcomp = new Composite(this.content, 0);
        testcomp.setLayoutData((Object)new GridData(1, 128, true, false, 2, 1));
        testcomp.setLayout((Layout)new GridLayout(1, false));
        Button testButton = new Button(testcomp, 8);
        testButton.setText(Messages.getString("ConnectionSettingsDialog.Button.Text.TestConnection"));
        gdb = new GridData(131072, 0x1000000, false, false, 1, 1);
        gdb.minimumWidth = 75;
        testButton.setLayoutData((Object)gdb);
        testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0) {
                    ConnectionSettingsDialog.this.showMessage("error", Messages.getString("ConnectionSettingsDialog.Job.Title.TestConnection"), Messages.getString("ConnectionSettingsDialog.MessageDialog.errorMessage.DisconnectRemote"));
                } else {
                    ConnectionSettingsDialog.this.setConnectionVars();
                    int credrc = ConnectionSettingsDialog.this.launchCredentialDialog(ConnectionSettingsDialog.this.scredentialid);
                    if (credrc == 0) {
                        ConnectionSettingsDialog.this.runTestConnection();
                    }
                }
            }
        });
        this.hostAddress.setFocus();
        return parent;
    }

    private void autofillConnName() {
        String addr = this.hostAddress.getText().trim();
        if (this.hostAddress.getText().trim().length() > 0 && this.hostAddress.getText().indexOf(".") >= 0) {
            addr = this.hostAddress.getText().substring(0, this.hostAddress.getText().indexOf("."));
        }
        if (this.cpuPort.getText().trim().length() > 0) {
            this.connName.setText(String.valueOf(addr) + ":" + this.cpuPort.getText().trim());
        } else {
            this.connName.setText(addr);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite client = new Composite(this.content, 0);
        GridLayout layout = new GridLayout(2, false);
        GridData gd = new GridData(131072, 1024, true, true, 2, 1);
        client.setLayoutData((Object)gd);
        client.setLayout((Layout)layout);
        this.okButton = this.createButton(client, 0, Messages.getString("ConnectionSettings.Button.Text.Ok"), true);
        this.createButton(client, 1, Messages.getString("ConnectionSettings.Button.Text.Cancel"), false);
        this.buttonclicked = false;
        this.content.layout(false);
    }

    public void okPressed() {
        if (this.chkComplete()) {
            this.setConnectionVars();
            if (this.connectionid.length() <= 0) {
                String conn;
                int hc = ((Object)((Object)this)).hashCode();
                int cnt = 0;
                this.connectionid = conn = String.valueOf(Math.abs(hc)) + "_" + ++cnt;
                System.out.println("connection id: " + this.connectionid);
            }
            this.setReturnCode(0);
            this.close();
            super.okPressed();
        }
    }

    public void cancelPressed() {
        if (this.buttonclicked) {
            this.buttonclicked = false;
        } else {
            this.buttonclicked = true;
            this.setReturnCode(1);
            if (this.jobTestConnection != null) {
                this.jobTestConnection.cancel();
                this.jobTestConnection = null;
            }
            this.close();
            super.cancelPressed();
        }
    }

    private void setConnectionVars() {
        this.sconnName = this.connName.getText().trim();
        this.shostAddress = this.hostAddress.getText();
        this.scpuPort = this.cpuPort.getText();
        this.sslConnect = this.sslConnection.getSelection();
        this.sSslConnect = this.sslConnect ? "true" : "false";
    }

    public boolean chkComplete() {
        boolean isComplete = true;
        this.errmsg = "";
        if (!this.chkHostAddress()) {
            isComplete = false;
        } else if (!this.chkCpuPort()) {
            isComplete = false;
        } else if (!this.chkCredentialId()) {
            isComplete = false;
        }
        if (this.errmsg.length() > 0) {
            this.showMessage("error", Messages.getString("ConnectionSettingsDialog.MessageDialog.MessageTitle.ConnectionSettings"), this.errmsg);
        }
        return isComplete;
    }

    private boolean chkHostAddress() {
        boolean isValid = true;
        this.errmsg = this.chkMandatory(this.hostAddress.getText().trim(), HOSTADDRESS_LABEL);
        if (this.errmsg.length() > 0) {
            isValid = false;
        }
        return isValid;
    }

    private boolean chkCpuPort() {
        boolean isValid = true;
        String cpuport = this.cpuPort.getText().trim();
        this.errmsg = this.chkMandatory(cpuport, CPUPORT_LABEL);
        if (this.errmsg.length() <= 0) {
            this.errmsg = this.chkInteger(cpuport, CPUPORT_LABEL);
        }
        if (this.errmsg.length() > 0) {
            isValid = false;
        }
        return isValid;
    }

    private boolean chkCredentialId() {
        boolean isValid = true;
        if (this.scredentialid.length() <= 0) {
            this.errmsg = String.valueOf(Messages.getString("LogonDialog.errorMessage.Mandatory")) + CONNECTIONID_LABEL;
        }
        if (this.errmsg.length() > 0) {
            isValid = false;
        }
        return isValid;
    }

    private String chkMandatory(String val, String varname) {
        if (val.length() <= 0) {
            this.errmsg = String.valueOf(Messages.getString("LogonDialog.errorMessage.Mandatory")) + varname;
        }
        return this.errmsg;
    }

    private String chkInteger(String val, String varname) {
        Integer ival = 0;
        String errmsg = "";
        try {
            ival = new Integer(val);
        }
        catch (NumberFormatException numberFormatException) {
            errmsg = String.valueOf(varname) + Messages.getString("LogonDialog.chkInteger.NotNumeric");
            return errmsg;
        }
        if (ival <= 0) {
            errmsg = String.valueOf(varname) + Messages.getString("LogonDialog.chkInteger.ValueTooSmall");
            return errmsg;
        }
        return errmsg;
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
        }
    }

    public int getShellStyle() {
        return 134384;
    }

    public void runTestConnection() {
        this.jobTestConnection = null;
        this.jobTestConnection = new Job(Messages.getString("ConnectionSettingsDialog.Job.Title.TestConnection")){
            int jobrc;
            {
                this.jobrc = 0;
            }

            public IStatus run(IProgressMonitor monitor) {
                ConnectionSettingsDialog.this.zosconnect.shostAddress = ConnectionSettingsDialog.this.shostAddress;
                ConnectionSettingsDialog.this.zosconnect.scpuPort = ConnectionSettingsDialog.this.scpuPort;
                ConnectionSettingsDialog.this.zosconnect.decodedPsw = ConnectionSettingsDialog.this.decodedPsw;
                ConnectionSettingsDialog.this.zosconnect.sslConnect = ConnectionSettingsDialog.this.sslConnect;
                ConnectionSettingsDialog.this.zosconnect.banknetConnect();
                if (ConnectionSettingsDialog.this.zosconnect.connrc < 0) {
                    return Status.CANCEL_STATUS;
                }
                CorePlugin.getDefault().monitor = monitor;
                ConnectionSettingsDialog.this.zosconnect.logonZos();
                if (ConnectionSettingsDialog.this.zosconnect.connrc < 0) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        this.jobTestConnection.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("Test Connection Job completed successfully");
                } else {
                    System.out.println("Test Connection Job cancelled");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).ConnectionSettingsDialog.this.buttonclicked = false;
                        if ((this).ConnectionSettingsDialog.this.zosconnect.connrc == 0) {
                            ConnectionSettingsDialog.this.showMessage("info", Messages.getString("ConnectionSettingsDialog.Job.Title.TestConnection"), Messages.getString("ConnectionSettingsDialog.MessageDialog.infoMessage.TestConnection"));
                        } else {
                            ConnectionSettingsDialog.this.showMessage("error", Messages.getString("ConnectionSettingsDialog.Job.Title.TestConnection"), (this).ConnectionSettingsDialog.this.zosconnect.errmsg);
                        }
                        CorePlugin.getDefault().connectionextension.disconnectZosJob();
                        (this).ConnectionSettingsDialog.this.zosconnect.setConnectLocal();
                    }
                });
            }
        });
        this.jobTestConnection.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        this.jobTestConnection.schedule();
    }

    private void logMessage(char loglevel, String logstr) {
        System.out.println("ConnectionSettingsDialog - " + logstr);
        switch (loglevel) {
            case 'E': {
                CorePlugin.getDefault().log.error(logstr);
                break;
            }
            case 'I': {
                CorePlugin.getDefault().log.info(logstr);
                break;
            }
            case 'W': {
                CorePlugin.getDefault().log.warn(logstr);
                break;
            }
            default: {
                CorePlugin.getDefault().log.debug(logstr);
            }
        }
    }

    public String stripChar(String val, char stripchar) {
        String strippedval = "";
        if (val.indexOf(stripchar) < 0) {
            return val;
        }
        int i = 0;
        while (i < val.length()) {
            if (val.charAt(i) != stripchar) {
                strippedval = val.substring(i, val.length());
                break;
            }
            ++i;
        }
        if (strippedval.length() <= 0) {
            strippedval = val.substring(val.length() - 1);
        }
        return strippedval;
    }

    private void loadCredentialsCombo() {
        this.credentialsCombo.setRedraw(false);
        this.credentialsCombo.removeAll();
        int i = 0;
        while (i < this.credentialskeys.size()) {
            String[] credentialArr = this.s1.split((String)this.credentialsdata.get(this.credentialskeys.get(i)), -1);
            this.credentialsCombo.setData(credentialArr[0], (Object)this.credentialskeys.get(i));
            this.credentialsCombo.add(credentialArr[0]);
            if (this.scredentialid.length() <= 0 && i == 0) {
                this.credentialsCombo.select(i);
                this.scredentialid = this.credentialskeys.get(i);
            } else if (this.scredentialid.equalsIgnoreCase(this.credentialskeys.get(i))) {
                this.credentialsCombo.select(i);
            }
            ++i;
        }
        this.credentialsCombo.setRedraw(true);
        this.credentialsCombo.redraw();
    }

    private int launchCredentialDialog(String selcredentialid) {
        int credrc;
        CredentialSettingsDialog csd = new CredentialSettingsDialog(this.shell);
        csd.credentialid = selcredentialid;
        if (selcredentialid.length() > 0) {
            String[] credentialArr = this.s1.split((String)this.credentialsdata.get(selcredentialid), -1);
            csd.credentialName = credentialArr[0];
            csd.userId = credentialArr[1];
            if (credentialArr[2].equalsIgnoreCase("true")) {
                csd.savePsw = true;
            }
            String tmppsw = "";
            int i = 3;
            while (i < credentialArr.length) {
                if (tmppsw.length() > 0) {
                    tmppsw = String.valueOf(tmppsw) + "|";
                }
                tmppsw = String.valueOf(tmppsw) + credentialArr[i];
                ++i;
            }
            csd.encodedPsw = tmppsw;
        }
        if ((credrc = csd.open()) == 0) {
            if (selcredentialid.length() <= 0) {
                this.scredentialid = csd.credentialid;
                this.credential = csd.credential;
                this.credentialskeys.add(this.scredentialid);
                this.credentialsdata.put(this.scredentialid, this.credential);
            } else {
                CorePlugin.getDefault().tsoid = csd.userId;
                this.decodedPsw = csd.decodedPsw;
            }
        }
        csd = null;
        return credrc;
    }
}

