/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs.connection;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.dialogs.connection.Messages;
import com.banknet.core.internal.Constants;
import com.banknet.core.preferences.PreferencesUtilities;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class ConnectionDialog
extends TitleAreaDialog {
    Constants constants = new Constants();
    ZosConnect zosconnect = new ZosConnect();
    PreferencesUtilities prefutils;
    Composite content;
    Group credentialcomp;
    Group logingroup;
    Group connectgroup;
    Shell shell;
    Shell dialogshell;
    Button okButton;
    public Text credentialId;
    public Text connectionPsw;
    private Text cpuPort;
    private Text connName;
    private Text hostAddress;
    public Button hideConnect;
    private Button sslConnection;
    String errmsg = "";
    private static String HOSTNAME_LABEL = Messages.getString("ConnectionSettings.Label.HostName");
    private static String HOSTADDRESS_LABEL = Messages.getString("ConnectionSettings.Label.HostAddress");
    private static String CPUPORT_LABEL = Messages.getString("ConnectionSettings.Label.HostPort");
    String sconnName = "";
    String shostAddress = "";
    String scpuPort = "";
    String sSslConnect = "false";
    boolean sslConnect = false;
    boolean autofillName = true;
    public String connectionid = "";
    public List<String> credentialskeys = new ArrayList<String>();
    public Hashtable credentialsdata = new Hashtable();
    boolean newConnection = false;
    String scredentialid = "";
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);

    public ConnectionDialog(Shell parentShell, String connectionid) {
        super(parentShell);
        this.shell = parentShell;
        this.connectionid = connectionid;
        if (connectionid.length() > 0) {
            this.getConnectionPrefs(connectionid);
        } else {
            this.newConnection = true;
        }
        this.prefutils = new PreferencesUtilities(this.shell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String titletxt = Messages.getString("ConnectionDialog.ShellTitle");
        if (!this.newConnection) {
            titletxt = Messages.getString("ConnectionDialog.ShellTitleEdit");
        }
        newShell.setText(titletxt);
        newShell.setLocation(420, 235);
        newShell.setImage(CorePlugin.getDefault().productextension.getDialogShellImage());
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        String dialogTitle = Messages.getString("ConnectionDialog.DialogTitle");
        if (!this.newConnection) {
            dialogTitle = Messages.getString("ConnectionDialog.DialogTitleEdit");
        }
        this.setTitle(dialogTitle);
        String msg = Messages.getString("ConnectionDialog.DialogMessage");
        this.setMessage(msg, 1);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        this.dialogshell = parent.getShell();
        this.content = parent;
        ((GridLayout)this.content.getLayout()).numColumns = 2;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.content, String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".dialogs_NewConnectionContext");
        Composite connectioncomp = new Composite(this.content, 0);
        GridData gd3 = new GridData(4, 128, true, true, 2, 1);
        connectioncomp.setLayoutData((Object)gd3);
        connectioncomp.setLayout((Layout)new GridLayout(2, false));
        Label connNameLabel = new Label(connectioncomp, 0);
        connNameLabel.setText(String.valueOf(HOSTNAME_LABEL) + ": ");
        GridData gd = new GridData(1, 128, false, false);
        gd.horizontalIndent = 5;
        connNameLabel.setLayoutData((Object)gd);
        this.connName = new Text(connectioncomp, 2048);
        this.connName.setText(this.sconnName);
        gd = new GridData(4, 128, true, false, 1, 1);
        this.connName.setLayoutData((Object)gd);
        this.connName.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                ConnectionDialog.this.autofillName = false;
            }
        });
        this.connName.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ConnectionDialog.this.connName.setText(ConnectionDialog.this.connName.getText());
            }
        });
        this.connectgroup = new Group(connectioncomp, 0);
        this.connectgroup.setText(Messages.getString("ConnectionSettings.GroupLabel.LocationSettings"));
        this.connectgroup.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.connectgroup.setLayout((Layout)new GridLayout(3, false));
        Label hostAddressLabel = new Label((Composite)this.connectgroup, 0);
        hostAddressLabel.setText(String.valueOf(HOSTADDRESS_LABEL) + ": ");
        gd = new GridData(1, 128, false, false);
        hostAddressLabel.setLayoutData((Object)gd);
        this.hostAddress = new Text((Composite)this.connectgroup, 2048);
        this.hostAddress.setText(this.shostAddress);
        gd = new GridData(4, 128, true, false, 2, 1);
        this.hostAddress.setLayoutData((Object)gd);
        this.hostAddress.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                ConnectionDialog.this.autofillName = true;
                if (true) {
                    ConnectionDialog.this.autofillConnName();
                }
            }
        });
        this.hostAddress.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ConnectionDialog.this.hostAddress.setText(ConnectionDialog.this.hostAddress.getText().trim());
                ConnectionDialog.this.autofillName = true;
                if (true) {
                    ConnectionDialog.this.autofillConnName();
                }
            }
        });
        Label cpuPortLabel = new Label((Composite)this.connectgroup, 0);
        cpuPortLabel.setText(String.valueOf(CPUPORT_LABEL) + ": ");
        gd = new GridData(1, 128, false, false);
        cpuPortLabel.setLayoutData((Object)gd);
        this.cpuPort = new Text((Composite)this.connectgroup, 2052);
        this.cpuPort.setText(this.scpuPort);
        this.cpuPort.setTextLimit(5);
        this.cpuPort.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                ConnectionDialog.this.autofillName = true;
                if (true) {
                    ConnectionDialog.this.autofillConnName();
                }
            }
        });
        this.cpuPort.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ConnectionDialog.this.cpuPort.setText(ConnectionDialog.this.cpuPort.getText());
            }
        });
        gd = new GridData(1, 128, false, false, 2, 1);
        gd.widthHint = 100;
        this.cpuPort.setLayoutData((Object)gd);
        Group sslgroup = new Group(connectioncomp, 0);
        sslgroup.setText(Messages.getString("ConnectionSettings.GroupLabel.SSLSettings"));
        sslgroup.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        sslgroup.setLayout((Layout)new GridLayout(3, false));
        this.sslConnection = new Button((Composite)sslgroup, 32);
        this.sslConnection.setText(Messages.getString("ConnectionSettings.Checkbox.SslConnection"));
        if (this.sSslConnect.equalsIgnoreCase("true")) {
            this.sslConnection.setSelection(true);
        }
        gd = new GridData(1, 0x1000000, false, false, 3, 1);
        this.sslConnection.setLayoutData((Object)gd);
        this.sslConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.hostAddress.setFocus();
        return parent;
    }

    private void autofillConnName() {
        String addr = this.hostAddress.getText().trim();
        if (this.hostAddress.getText().trim().length() > 0 && this.hostAddress.getText().indexOf(".") >= 0) {
            addr = this.hostAddress.getText().substring(0, this.hostAddress.getText().indexOf("."));
        }
        if (this.cpuPort.getText().trim().length() > 0) {
            this.connName.setText(String.valueOf(addr) + ":" + this.cpuPort.getText().trim());
        } else {
            this.connName.setText(addr);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite client = new Composite(this.content, 0);
        GridLayout layout = new GridLayout(1, false);
        client.setLayoutData((Object)new GridData(131072, 1024, true, true, 1, 1));
        client.setLayout((Layout)layout);
        this.okButton = this.createButton(client, 0, Messages.getString("ConnectionSettings.Button.Text.Ok"), true);
        this.createButton(client, 1, Messages.getString("ConnectionSettings.Button.Text.Cancel"), false);
        this.content.layout(false);
    }

    public void okPressed() {
        if (this.chkComplete()) {
            this.setConnectionVars();
            this.insertConnectionPrefs();
            this.setReturnCode(0);
            this.close();
            super.okPressed();
        }
    }

    public void cancelPressed() {
        this.setReturnCode(1);
        this.close();
        super.cancelPressed();
    }

    public boolean chkComplete() {
        boolean isComplete = true;
        this.errmsg = "";
        if (!this.chkConnectionName()) {
            isComplete = false;
        } else if (!this.chkHostAddress()) {
            isComplete = false;
        } else if (!this.chkCpuPort()) {
            isComplete = false;
        }
        if (this.errmsg.length() > 0) {
            String titletxt = Messages.getString("ConnectionDialog.MessageDialog.errorTitle.NewConnection");
            if (!this.newConnection) {
                titletxt = Messages.getString("ConnectionDialog.MessageDialog.errorTitle.EditConnection");
            }
            this.showMessage("error", titletxt, this.errmsg);
        }
        return isComplete;
    }

    private boolean chkConnectionName() {
        boolean isValid = true;
        this.errmsg = this.chkMandatory(this.connName.getText().trim(), HOSTNAME_LABEL);
        if (this.errmsg.length() > 0) {
            isValid = false;
        }
        return isValid;
    }

    private boolean chkHostAddress() {
        boolean isValid = true;
        this.errmsg = this.chkMandatory(this.hostAddress.getText().trim(), HOSTADDRESS_LABEL);
        if (this.errmsg.length() > 0) {
            isValid = false;
        }
        return isValid;
    }

    private boolean chkCpuPort() {
        boolean isValid = true;
        String cpuport = this.cpuPort.getText().trim();
        this.errmsg = this.chkMandatory(cpuport, CPUPORT_LABEL);
        if (this.errmsg.length() <= 0) {
            this.errmsg = this.chkInteger(cpuport, CPUPORT_LABEL);
        }
        if (this.errmsg.length() > 0) {
            isValid = false;
        }
        return isValid;
    }

    private String chkMandatory(String val, String varname) {
        if (val.length() <= 0) {
            this.errmsg = String.valueOf(Messages.getString("LogonDialog.errorMessage.Mandatory")) + varname;
        }
        return this.errmsg;
    }

    private String chkInteger(String val, String varname) {
        Integer ival = 0;
        String errmsg = "";
        try {
            ival = new Integer(val);
        }
        catch (NumberFormatException numberFormatException) {
            errmsg = String.valueOf(varname) + Messages.getString("LogonDialog.chkInteger.NotNumeric");
            return errmsg;
        }
        if (ival <= 0) {
            errmsg = String.valueOf(varname) + Messages.getString("LogonDialog.chkInteger.ValueTooSmall");
            return errmsg;
        }
        return errmsg;
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
        }
    }

    public int getShellStyle() {
        return 134384;
    }

    private void logMessage(char loglevel, String logstr) {
        System.out.println("ConnectionDialog - " + logstr);
        switch (loglevel) {
            case 'E': {
                CorePlugin.getDefault().log.error(logstr);
                break;
            }
            case 'I': {
                CorePlugin.getDefault().log.info(logstr);
                break;
            }
            case 'W': {
                CorePlugin.getDefault().log.warn(logstr);
                break;
            }
            default: {
                CorePlugin.getDefault().log.debug(logstr);
            }
        }
    }

    public String stripChar(String val, char stripchar) {
        String strippedval = "";
        if (val.indexOf(stripchar) < 0) {
            return val;
        }
        int i = 0;
        while (i < val.length()) {
            if (val.charAt(i) != stripchar) {
                strippedval = val.substring(i, val.length());
                break;
            }
            ++i;
        }
        if (strippedval.length() <= 0) {
            strippedval = val.substring(val.length() - 1);
        }
        return strippedval;
    }

    private void setConnectionVars() {
        this.sconnName = this.connName.getText().trim();
        this.shostAddress = this.hostAddress.getText();
        this.scpuPort = this.cpuPort.getText();
        this.sslConnect = this.sslConnection.getSelection();
        this.sSslConnect = this.sslConnect ? "true" : "false";
        if (this.connectionid.length() <= 0) {
            String conn;
            int hc = ((Object)((Object)this)).hashCode();
            int cnt = 0;
            this.connectionid = conn = String.valueOf(Math.abs(hc)) + "_" + ++cnt;
            System.out.println("connection id: " + this.connectionid);
        }
    }

    private void insertConnectionPrefs() {
        try {
            StringBuilder stringBuilder = new StringBuilder("/instance/");
            CorePlugin.getDefault();
            IEclipsePreferences connprefs = InstanceScope.INSTANCE.getNode(stringBuilder.append("com.banknet.core").append("/connections").toString());
            StringBuilder stringBuilder2 = new StringBuilder("/instance/");
            CorePlugin.getDefault();
            IEclipsePreferences connpref = InstanceScope.INSTANCE.getNode(stringBuilder2.append("com.banknet.core").append("/connections/").append(this.connectionid).toString());
            connpref.put(CorePlugin.getDefault().constants.CONNPREF_CONN_NAME, this.sconnName);
            connpref.put(CorePlugin.getDefault().constants.CONNPREF_CREDENTIAL_ID, this.scredentialid);
            connpref.put(CorePlugin.getDefault().constants.CONNPREF_SERVER_NAME, this.shostAddress);
            connpref.put(CorePlugin.getDefault().constants.CONNPREF_PORT_NAME, this.scpuPort);
            connpref.put(CorePlugin.getDefault().constants.CONNPREF_OVERRIDE_SSL, this.sSslConnect);
            connpref.flush();
            connprefs.flush();
            if (CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId").length() <= 0) {
                CorePlugin.getDefault().getPreferenceStore().setValue("activeConnectionId", this.connectionid);
            }
        }
        catch (BackingStoreException backingStoreException) {
        }
        catch (Exception exception) {}
    }

    private void getConnectionPrefs(String connectionid) {
        this.connectionid = connectionid;
        StringBuilder stringBuilder = new StringBuilder("/instance/");
        CorePlugin.getDefault();
        IEclipsePreferences connpref = InstanceScope.INSTANCE.getNode(stringBuilder.append("com.banknet.core").append("/connections/").append(connectionid).toString());
        try {
            if (connpref.keys().length <= 0) {
                StringBuilder stringBuilder2 = new StringBuilder("/instance/");
                CorePlugin.getDefault();
                IEclipsePreferences connprefs = InstanceScope.INSTANCE.getNode(stringBuilder2.append("com.banknet.core").append("/connections").toString());
                connectionid = connprefs.childrenNames()[0];
                StringBuilder stringBuilder3 = new StringBuilder("/instance/");
                CorePlugin.getDefault();
                connpref = InstanceScope.INSTANCE.getNode(stringBuilder3.append("com.banknet.core").append("/connections/").append(connectionid).toString());
            }
        }
        catch (Exception exception) {}
        this.sconnName = connpref.get(this.constants.CONNPREF_CONN_NAME, "");
        this.shostAddress = connpref.get(this.constants.CONNPREF_SERVER_NAME, "");
        this.scpuPort = connpref.get(this.constants.CONNPREF_PORT_NAME, "");
        this.sSslConnect = connpref.get(this.constants.CONNPREF_OVERRIDE_SSL, "");
        if (this.sSslConnect.equalsIgnoreCase("true")) {
            this.sslConnect = true;
        }
        this.scredentialid = connpref.get(this.constants.CONNPREF_CREDENTIAL_ID, "");
    }
}

