/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs;

import com.banknet.core.CorePlugin;
import com.banknet.core.dialogs.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class UpdatesAvailableDialog
extends Dialog {
    Composite content;
    Shell shell;
    Button okButton;
    public Button noMessageButton;
    String errmsg = "";
    String dlgui_version = "";
    String dlgui_fixpack = "";

    public UpdatesAvailableDialog(Shell parentShell, String dlgui_version, String dlgui_fixpack) {
        super(parentShell);
        this.shell = parentShell;
        this.dlgui_version = dlgui_version;
        this.dlgui_fixpack = dlgui_fixpack;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("UpdatesAvailableDialog.ShellTitle"));
    }

    protected Control createDialogArea(Composite parent) {
        this.content = parent;
        ((GridLayout)this.content.getLayout()).numColumns = 2;
        GridData gd2 = new GridData(0x1000000, 0x1000000, true, false, 2, 1);
        gd2.widthHint = 450;
        this.content.setLayoutData((Object)gd2);
        Label spacer2 = new Label(parent, 64);
        spacer2.setText("");
        gd2 = new GridData(1, 0x1000000, false, false, 2, 1);
        gd2.minimumHeight = 50;
        spacer2.setLayoutData((Object)gd2);
        Image image = this.getInfoImage();
        Label imageLabel = new Label(parent, 0);
        image.setBackground(imageLabel.getBackground());
        imageLabel.setImage(image);
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)imageLabel);
        gd2 = new GridData(0x1000000, 1, true, true, 1, 3);
        gd2.minimumWidth = 55;
        gd2.horizontalIndent = 10;
        imageLabel.setLayoutData((Object)gd2);
        Label messageLabel = new Label(parent, 64);
        messageLabel.setText(this.getInfoMessage());
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)messageLabel);
        Label spacer = new Label(parent, 64);
        spacer.setText("");
        gd2 = new GridData(1, 0x1000000, false, false, 1, 1);
        gd2.minimumHeight = 60;
        spacer.setLayoutData((Object)gd2);
        this.noMessageButton = new Button(parent, 32);
        this.noMessageButton.setText(Messages.getString("UpdatesAvailableDialog.Checkbox.HideMessage"));
        gd2 = new GridData(1, 1024, false, true, 1, 1);
        this.noMessageButton.setLayoutData((Object)gd2);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite client = new Composite(this.content, 0);
        GridLayout layout = new GridLayout(2, false);
        GridData gd = new GridData(131072, 0x1000000, true, false, 2, 1);
        client.setLayoutData((Object)gd);
        client.setLayout((Layout)layout);
        this.okButton = this.createButton(client, 0, Messages.getString("UpdatesAvailableDialog.Button.Text.Ok"), true);
    }

    private String getInfoMessage() {
        String message = Messages.getString("UpdatesAvailableDialog.Label.Text.Message");
        String version = this.stripChar(this.dlgui_version.substring(0, 3), '0');
        String release = this.stripChar(this.dlgui_version.substring(3, 6), '0');
        String modlevel = this.stripChar(this.dlgui_version.substring(6, 9), '0');
        String fixpack = this.stripChar(this.dlgui_fixpack.substring(0, 5), '0');
        String.format("%s.%s.%s.%s", version, release, modlevel, fixpack);
        return message;
    }

    public String stripChar(String val, char stripchar) {
        String strippedval = "";
        if (val.indexOf(stripchar) < 0) {
            return val;
        }
        int i = 0;
        while (i < val.length()) {
            if (val.charAt(i) != stripchar) {
                strippedval = val.substring(i, val.length());
                break;
            }
            ++i;
        }
        if (strippedval.length() <= 0) {
            strippedval = val.substring(val.length() - 1);
        }
        return strippedval;
    }

    public void okPressed() {
        if (this.noMessageButton.getSelection()) {
            CorePlugin.getDefault().getPreferenceStore().setValue("dlGui", String.valueOf(this.dlgui_version) + "." + this.dlgui_fixpack);
        }
        this.setReturnCode(0);
        this.close();
    }

    public int getShellStyle() {
        return 134384;
    }

    public Image getInfoImage() {
        Image[] image = new Image[]{this.shell.getDisplay().getSystemImage(2)};
        return image[0];
    }
}

