/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs;

import com.banknet.core.CorePlugin;
import com.banknet.core.dialogs.Messages;
import com.banknet.core.internal.Constants;
import com.banknet.core.models.ReportsModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class StickyNotesDialog
extends Dialog {
    Constants constants = new Constants();
    Shell shell;
    Composite content1;
    SimpleDateFormat dtfmt = new SimpleDateFormat("MMM dd yyyy HH:mm:ss");
    String errmsg = "";
    Color darkYellow = new Color(null, 248, 247, 182);
    StyledText printText;
    Text stickyNotes;
    Text lastUpdate;
    ToolBarManager toolBarMgr;
    private Action saveAction;
    private Action deleteAction;
    private Action printAction;
    private Action copyAction;
    String reportTitle = "";
    public String notesPath = "";
    public String rptid = "";
    public String rpttitle = "";
    public String lastupd = "";
    Image imgStickyNotes = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/stickyNote.gif").createImage();

    public StickyNotesDialog(Shell parentShell) {
        super(parentShell);
        this.shell = parentShell;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.reportTitle = Messages.getString("StickyNotesDialog.ShellTitle");
        this.reportTitle = this.reportTitle.replace("#reportname", this.rpttitle);
        this.notesPath = String.valueOf(this.notesPath) + this.rptid + "-stickyNotes.txt";
        newShell.setText(this.reportTitle);
        newShell.setImage(this.imgStickyNotes);
        newShell.setBackground(this.darkYellow);
        newShell.setSize(350, 250);
        newShell.setLocation(385, 150);
        this.makeActions();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setBackground(this.darkYellow);
        this.content1 = new Composite(parent, 0);
        this.content1.setBackground(this.darkYellow);
        GridLayout layout1 = new GridLayout(2, false);
        this.content1.setLayout((Layout)layout1);
        GridData gd3 = new GridData(0x1000000, 128, true, true, 1, 1);
        this.content1.setLayoutData((Object)gd3);
        this.lastUpdate = new Text(this.content1, 0);
        File notesFile = new File(this.notesPath);
        if (notesFile.exists()) {
            this.lastupd = this.constants.yyyymmddhhmmss.format(notesFile.lastModified());
        }
        this.lastUpdate.setText(this.lastupd);
        this.lastUpdate.setBackground(this.darkYellow);
        this.lastUpdate.setEditable(false);
        this.lastUpdate.setEnabled(false);
        GridData gd1 = new GridData(4, 0x1000000, true, false);
        this.lastUpdate.setLayoutData((Object)gd1);
        ToolBar toolBar = new ToolBar(this.content1, 256);
        this.toolBarMgr = new ToolBarManager(toolBar);
        toolBar.setBackground(this.darkYellow);
        this.toolBarMgr.add((IAction)this.saveAction);
        this.toolBarMgr.add((IAction)this.printAction);
        this.toolBarMgr.add((IContributionItem)new Separator());
        this.toolBarMgr.add((IAction)this.deleteAction);
        this.toolBarMgr.update(true);
        GridData gdb3 = new GridData(131072, 128, true, false, 1, 1);
        toolBar.setLayoutData((Object)gdb3);
        this.stickyNotes = new Text(this.content1, 832);
        this.stickyNotes.setText(this.loadStickyNotes());
        GridData gdxx = new GridData(4, 4, true, true, 2, 1);
        gdxx.widthHint = 750;
        gdxx.heightHint = 550;
        this.stickyNotes.setLayoutData((Object)gdxx);
        this.stickyNotes.setBackground(new Color(null, 253, 253, 203));
        this.stickyNotes.setFocus();
        return parent;
    }

    protected Composite createButtonBar(Composite parent) {
        return null;
    }

    private void makeActions() {
        this.saveAction = new Action(){

            public void run() {
                StickyNotesDialog.this.saveStickyNotes();
            }
        };
        this.saveAction.setText(Messages.getString("StickyNotesDialog.Action.Save"));
        this.saveAction.setToolTipText(Messages.getString("StickyNotesDialog.Tooltip.Save"));
        this.saveAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/save_edit.gif"));
        this.copyAction = new Action(){

            public void run() {
                StickyNotesDialog.this.loadPrintText();
                StickyNotesDialog.this.printText.selectAll();
                StickyNotesDialog.this.printText.copy();
                StickyNotesDialog.this.printText.dispose();
            }
        };
        this.copyAction.setText(Messages.getString("StickyNotesDialog.Action.Copy"));
        this.copyAction.setToolTipText(Messages.getString("StickyNotesDialog.Tooltip.Copy"));
        this.copyAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/copy_edit.gif"));
        this.deleteAction = new Action(){

            public void run() {
                File notesFile = new File(StickyNotesDialog.this.notesPath);
                if (CorePlugin.getDefault().getPreferenceStore().getBoolean("confirmNotesDelete") & notesFile.exists()) {
                    String msg = Messages.getString("StickyNotesDialog.ConfirmDialog.ConfirmMessage.Delete");
                    msg = msg.replace("#reportname", StickyNotesDialog.this.rptid);
                    if (MessageDialog.openConfirm((Shell)StickyNotesDialog.this.shell, (String)Messages.getString("StickyNotesDialog.Action.Delete"), (String)msg)) {
                        StickyNotesDialog.this.deleteStickyNotes();
                    }
                } else {
                    StickyNotesDialog.this.deleteStickyNotes();
                }
            }
        };
        this.deleteAction.setText(Messages.getString("StickyNotesDialog.Action.Delete"));
        this.deleteAction.setToolTipText(Messages.getString("StickyNotesDialog.Tooltip.Delete"));
        this.deleteAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.printAction = new Action(){

            public void run() {
                StickyNotesDialog.this.printStickyNote();
            }
        };
        this.printAction.setText(Messages.getString("StickyNotesDialog.Action.Print"));
        this.printAction.setToolTipText(Messages.getString("StickyNotesDialog.Tooltip.Print"));
        this.printAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/print_edit.gif"));
    }

    private String loadStickyNotes() {
        String notesStr = "";
        StringBuilder notes = new StringBuilder();
        String notesLine = "";
        File notesFile = new File(this.notesPath);
        if (notesFile.exists()) {
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try (BufferedReader notesrdr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(notesFile.getAbsolutePath()), "UTF-8"));){
                    while ((notesLine = notesrdr.readLine()) != null) {
                        notes.append(notesLine);
                        notes.append("\n");
                    }
                    notesrdr.close();
                    if (notes.length() > 0) {
                        notesStr = notes.toString();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
        return notesStr;
    }

    private void saveStickyNotes() {
        try {
            File notesFile = new File(this.notesPath);
            notesFile.getParentFile().mkdirs();
            FileOutputStream outputStream2 = new FileOutputStream(notesFile);
            PrintStream sysout = new PrintStream((OutputStream)outputStream2, true, "UTF-8");
            sysout.print(this.stickyNotes.getText());
            outputStream2.close();
            outputStream2 = null;
            this.lastUpdate.setText(this.constants.yyyymmddhhmmss.format(notesFile.lastModified()));
            this.content1.layout(false);
            notesFile = null;
            sysout = null;
            try {
                ReportsModel report = CorePlugin.getDefault().reports.get(CorePlugin.getDefault().reportId.indexOf(this.rptid));
                report.stickyNotes = true;
                report.parent.stickyNotes = true;
                CorePlugin.getDefault().getPreferenceStore().setValue("reportsRefresh", true);
            }
            catch (Exception exception) {}
        }
        catch (OutOfMemoryError oem) {
            String logstr = "saveAction:  out of memory exception " + oem;
            System.out.println("StickyNotesDialog " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        catch (Exception e) {
            String logstr = "saveAction:  exception " + e;
            System.out.println("StickyNotesDialog " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            MessageDialog.openError((Shell)this.shell, (String)Messages.getString("StickyNotesDialog.MessageDialog.errorTitle.SaveError"), (String)e.getLocalizedMessage());
        }
    }

    private void deleteStickyNotes() {
        try {
            File notesFile = new File(this.notesPath);
            notesFile.delete();
            try {
                ReportsModel report = CorePlugin.getDefault().reports.get(CorePlugin.getDefault().reportId.indexOf(this.rptid));
                report.stickyNotes = false;
                ReportsModel parent = report.parent;
                parent.stickyNotes = false;
                int ii = 0;
                while (ii < parent.child.size()) {
                    if (((ReportsModel)parent.child.get((int)ii)).stickyNotes) {
                        parent.stickyNotes = true;
                        break;
                    }
                    ++ii;
                }
            }
            catch (Exception exception) {}
            CorePlugin.getDefault().getPreferenceStore().setValue("reportsRefresh", true);
            this.dispose();
            this.setReturnCode(0);
            this.close();
        }
        catch (Exception e) {
            String logstr = "deleteAction:  exception " + e;
            System.out.println("StickyNotesDialog " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    public void dispose() {
        this.imgStickyNotes.dispose();
    }

    private void printStickyNote() {
        try {
            this.loadPrintText();
            PrintDialog printdialog = new PrintDialog(this.shell, 0);
            PrinterData printdata = printdialog.open();
            StyledTextPrintOptions printoptions = new StyledTextPrintOptions();
            String dt = this.dtfmt.format(new Date());
            printoptions.footer = "\t" + dt + "\t";
            printoptions.header = String.valueOf(this.reportTitle) + "\t";
            printoptions.printTextFontStyle = true;
            printoptions.printTextForeground = true;
            printoptions.jobName = this.reportTitle;
            printoptions.printLineBackground = true;
            if (printdata != null) {
                Printer printer = new Printer(printdata);
                Runnable runnable = this.printText.print(printer, printoptions);
                runnable.run();
                runnable = null;
                printer = null;
            }
            printdialog = null;
            printdata = null;
            printoptions = null;
            this.printText.dispose();
            System.gc();
        }
        catch (Exception e) {
            String logstr = "printAction:  exception " + e;
            System.out.println("StickyNotesDialog " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            MessageDialog.openError((Shell)this.shell, (String)Messages.getString("StickyNotesDialog.MessageDialog.errorTitle.PrintError"), (String)e.getLocalizedMessage());
        }
    }

    private void loadPrintText() {
        this.printText = new StyledText((Composite)this.shell, 770);
        GridData spec = new GridData();
        spec.horizontalAlignment = 4;
        spec.grabExcessHorizontalSpace = true;
        spec.verticalAlignment = 4;
        spec.grabExcessVerticalSpace = true;
        this.printText.setLayoutData((Object)spec);
        this.printText.setEditable(false);
        Color bg = Display.getDefault().getSystemColor(1);
        this.printText.setBackground(bg);
        this.printText.setVisible(false);
        this.printText.setText(this.stickyNotes.getText());
    }

    private String chkMandatory(String val, String varname) {
        if (val.length() <= 0) {
            this.errmsg = String.valueOf(Messages.getString("StickyNotesDiaCorePlugin.getDefault().log.errorMessage.Mandatory")) + varname;
        }
        return this.errmsg;
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
        }
    }

    public int getShellStyle() {
        return 134384;
    }
}

