/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs;

import com.banknet.core.CorePlugin;
import com.banknet.core.dialogs.Messages;
import com.banknet.core.internal.Constants;
import com.banknet.core.models.ObservationsSearchItems;
import com.banknet.core.views.ObservationsSearchView;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ObservationsSearchDialog
extends TitleAreaDialog {
    Constants constants = new Constants();
    protected IViewPart view;
    private Text jobnameText;
    private Text searchtextText;
    private Combo searchforCombo;
    private ExpandItem itemdatecheck;
    private ExpandItem itemreqnumcheck;
    private ExpandItem itemsamplescheck;
    Composite content;
    Shell shell;
    Text fromdateText;
    Text todateText;
    Button caseCheck;
    Button reqnumCheck;
    Button samplesCheck;
    Button daterangeCheck;
    Text fromreqnumText;
    Text toreqnumText;
    Text fromsamplesText;
    Text tosamplesText;
    Label fromreqnumLabel;
    Label toreqnumLabel;
    Label fromsamplesLabel;
    Label tosamplesLabel;
    Label fromdateLabel;
    Label todateLabel;
    final SimpleDateFormat yyyymmddhhmm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    final SimpleDateFormat mmmddyyyyhhmm = new SimpleDateFormat("MMM-dd-yyyy HH:mm");
    final SimpleDateFormat yyyymmddhhmm2 = new SimpleDateFormat("yyyy-MM-dd 00:00");
    final SimpleDateFormat mmmddyyyyhhmm2 = new SimpleDateFormat("MMM-dd-yyyy 00:00");
    public String fromdate;
    public String todate = this.mmmddyyyyhhmm.format(new Date());
    Date widgetdate;
    public Date dfromdate;
    public Date dtodate;
    Calendar tocaldate = Calendar.getInstance();
    Calendar fromcaldate = Calendar.getInstance();
    Image imgSearch = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/search_src.gif").createImage();

    public ObservationsSearchDialog(Shell parentShell) {
        super(parentShell);
    }

    public ObservationsSearchDialog(IViewPart view) {
        super(view.getViewSite().getShell());
        this.view = view;
    }

    protected void configureShell(Shell dialogShell) {
        super.configureShell(dialogShell);
        dialogShell.setText(Messages.getString("ObservationsSearchDialog.ShellTitle"));
        this.shell = dialogShell;
        dialogShell.setImage(this.imgSearch);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialogShell, String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".dialogs_ObservationsSearchContext");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(Messages.getString("ObservationsSearchDialog.Title"));
        this.setMessage(Messages.getString("ObservationsSearchDialog.Instructions"), 1);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        this.content = parent;
        ((GridLayout)this.content.getLayout()).numColumns = 3;
        Label searchtextLabel = new Label(this.content, 0);
        searchtextLabel.setText(Messages.getString("ObservationsSearchDialog.Label.Text.SearchString"));
        GridData gd = new GridData(4, 128, true, true, 3, 1);
        gd.horizontalIndent = 15;
        gd.widthHint = 100;
        searchtextLabel.setLayoutData((Object)gd);
        this.searchtextText = new Text(this.content, 2048);
        this.searchtextText.setText("");
        gd = new GridData(4, 128, false, true, 2, 1);
        gd.horizontalIndent = 20;
        gd.widthHint = 350;
        this.searchtextText.setLayoutData((Object)gd);
        this.caseCheck = new Button(this.content, 32);
        this.caseCheck.setText(Messages.getString("ObservationsSearchDialog.Button.Text.CaseSensitive"));
        gd = new GridData(1, 0x1000000, true, false);
        this.caseCheck.setLayoutData((Object)gd);
        Label searchforLabel = new Label(this.content, 0);
        searchforLabel.setText(Messages.getString("ObservationsSearchDialog.Label.Text.SearchFor"));
        gd = new GridData(1, 0x1000000, false, false);
        gd.horizontalIndent = 15;
        searchforLabel.setLayoutData((Object)gd);
        this.searchforCombo = new Combo(this.content, 8);
        this.searchforCombo.add(Messages.getString("ObservationsSearchDialog.All"));
        this.searchforCombo.add(Messages.getString("ObservationsSearchDialog.ReqNum"));
        this.searchforCombo.add(Messages.getString("ObservationsSearchDialog.OwnedBy"));
        this.searchforCombo.add(Messages.getString("ObservationsSearchDialog.Description"));
        this.searchforCombo.add(Messages.getString("ObservationsSearchDialog.JobName"));
        this.searchforCombo.add(Messages.getString("ObservationsSearchDialog.DateTime"));
        this.searchforCombo.add(Messages.getString("ObservationsSearchDialog.Samples"));
        this.searchforCombo.add(Messages.getString("ObservationsSearchDialog.Status"));
        this.searchforCombo.select(0);
        gd = new GridData(1, 0x1000000, true, false, 2, 1);
        gd.horizontalIndent = 20;
        gd.widthHint = 75;
        this.searchforCombo.setLayoutData((Object)gd);
        this.searchforCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ObservationsSearchDialog.this.searchforCombo.getText().equalsIgnoreCase(Messages.getString("ObservationsSearchDialog.DateTime"))) {
                    ObservationsSearchDialog.this.daterangeCheck.setSelection(true);
                    ObservationsSearchDialog.this.fromdateLabel.setEnabled(true);
                    ObservationsSearchDialog.this.fromdateText.setEnabled(true);
                    ObservationsSearchDialog.this.todateLabel.setEnabled(true);
                    ObservationsSearchDialog.this.todateText.setEnabled(true);
                    ObservationsSearchDialog.this.itemdatecheck.setExpanded(true);
                    ObservationsSearchDialog.this.itemreqnumcheck.setExpanded(false);
                    ObservationsSearchDialog.this.itemsamplescheck.setExpanded(false);
                } else if (ObservationsSearchDialog.this.searchforCombo.getText().equalsIgnoreCase(Messages.getString("ObservationsSearchDialog.ReqNum"))) {
                    ObservationsSearchDialog.this.reqnumCheck.setSelection(true);
                    ObservationsSearchDialog.this.fromreqnumLabel.setEnabled(true);
                    ObservationsSearchDialog.this.fromreqnumText.setEnabled(true);
                    ObservationsSearchDialog.this.toreqnumLabel.setEnabled(true);
                    ObservationsSearchDialog.this.toreqnumText.setEnabled(true);
                    ObservationsSearchDialog.this.itemdatecheck.setExpanded(false);
                    ObservationsSearchDialog.this.itemreqnumcheck.setExpanded(true);
                    ObservationsSearchDialog.this.itemsamplescheck.setExpanded(false);
                } else if (ObservationsSearchDialog.this.searchforCombo.getText().equalsIgnoreCase(Messages.getString("ObservationsSearchDialog.Samples"))) {
                    ObservationsSearchDialog.this.samplesCheck.setSelection(true);
                    ObservationsSearchDialog.this.fromsamplesLabel.setEnabled(true);
                    ObservationsSearchDialog.this.fromsamplesText.setEnabled(true);
                    ObservationsSearchDialog.this.tosamplesLabel.setEnabled(true);
                    ObservationsSearchDialog.this.tosamplesText.setEnabled(true);
                    ObservationsSearchDialog.this.itemdatecheck.setExpanded(false);
                    ObservationsSearchDialog.this.itemreqnumcheck.setExpanded(false);
                    ObservationsSearchDialog.this.itemsamplescheck.setExpanded(true);
                }
            }
        });
        ExpandBar bar = new ExpandBar(this.content, 512);
        bar.setLayoutData((Object)new GridData(4, 128, true, true, 3, 1));
        Image image = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/eclipse.png").createImage();
        Composite composite = new Composite((Composite)bar, 0);
        GridLayout layout = new GridLayout();
        layout.marginBottom = 10;
        layout.marginRight = 10;
        layout.marginTop = 10;
        layout.marginLeft = 10;
        layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        this.daterangeCheck = new Button(composite, 32);
        this.daterangeCheck.setText(Messages.getString("ObservationsSearchDialog.Button.Text.LimitDateTime"));
        gd = new GridData(4, 128, true, true, 3, 1);
        gd.horizontalIndent = 10;
        this.daterangeCheck.setLayoutData((Object)gd);
        this.daterangeCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ObservationsSearchDialog.this.daterangeCheck.getSelection()) {
                    ObservationsSearchDialog.this.fromdateLabel.setEnabled(true);
                    ObservationsSearchDialog.this.fromdateText.setEnabled(true);
                    ObservationsSearchDialog.this.todateLabel.setEnabled(true);
                    ObservationsSearchDialog.this.todateText.setEnabled(true);
                } else {
                    ObservationsSearchDialog.this.fromdateLabel.setEnabled(false);
                    ObservationsSearchDialog.this.fromdateText.setEnabled(false);
                    ObservationsSearchDialog.this.todateLabel.setEnabled(false);
                    ObservationsSearchDialog.this.todateText.setEnabled(false);
                }
            }
        });
        this.fromdateLabel = new Label(composite, 0);
        this.fromdateLabel.setText(Messages.getString("ObservationsSearchDialog.Label.Text.From"));
        gd = new GridData(1, 0x1000000, false, false);
        gd.horizontalIndent = 20;
        gd.widthHint = 25;
        this.fromdateLabel.setLayoutData((Object)gd);
        this.fromdateLabel.setEnabled(false);
        this.fromdateText = new Text(composite, 2048);
        this.fromcaldate.add(6, -1);
        this.fromcaldate.set(10, 0);
        this.fromcaldate.set(12, 0);
        this.fromcaldate.set(13, 0);
        this.fromdate = this.mmmddyyyyhhmm.format(this.fromcaldate.getTime());
        try {
            this.dfromdate = this.yyyymmddhhmm.parse(this.yyyymmddhhmm.format(this.fromcaldate.getTime()));
        }
        catch (ParseException ex) {
            String logstr = "createDialog: fromDate " + this.fromdate + "  parse exception: " + ex;
            System.out.println("ObservationsSearchDialog - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        this.fromdateText.setText(this.fromdate);
        gd = new GridData(1, 0x1000000, false, false);
        gd.widthHint = 75;
        this.fromdateText.setLayoutData((Object)gd);
        this.fromdateText.setEnabled(false);
        this.fromdateText.setEditable(false);
        Button fromdateButton = new Button(composite, 8);
        Image image3 = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/calendar.gif").createImage();
        fromdateButton.setImage(image3);
        gd = new GridData(1, 16384, true, false);
        fromdateButton.setLayoutData((Object)gd);
        fromdateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Shell dialog = new Shell(ObservationsSearchDialog.this.shell, 2144);
                dialog.setLayout((Layout)new GridLayout(1, false));
                dialog.setLocation(350, 180);
                final DateTime calendar = new DateTime((Composite)dialog, 3072);
                final DateTime time = new DateTime((Composite)dialog, 0x10000080);
                calendar.setYear(ObservationsSearchDialog.this.fromcaldate.get(1));
                calendar.setMonth(ObservationsSearchDialog.this.fromcaldate.get(2));
                calendar.setDay(ObservationsSearchDialog.this.fromcaldate.get(5));
                time.setHours(ObservationsSearchDialog.this.fromcaldate.get(11));
                time.setMinutes(ObservationsSearchDialog.this.fromcaldate.get(12));
                time.setSeconds(ObservationsSearchDialog.this.fromcaldate.get(13));
                new Label((Composite)dialog, 0);
                Button ok = new Button((Composite)dialog, 8);
                ok.setText(Messages.getString("ObservationsSearchDialog.Button.Text.Ok"));
                ok.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String logstr = "createDialog: fromDate button,  Calendar date selected (MM/DD/YYYY) = " + (calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear();
                        System.out.println("ObservationsSearchDialog - " + logstr);
                        CorePlugin.getDefault().log.debug(logstr);
                        logstr = "createDialog: fromDate button,  Time selected (HH:MM) = " + time.getHours() + ":" + time.getMinutes();
                        System.out.println("ObservationsSearchDialog - " + logstr);
                        CorePlugin.getDefault().log.debug(logstr);
                        try {
                            (this).ObservationsSearchDialog.this.dfromdate = (this).ObservationsSearchDialog.this.yyyymmddhhmm.parse(String.valueOf((this).ObservationsSearchDialog.this.constants.decfmt2.format(calendar.getYear())) + "-" + (this).ObservationsSearchDialog.this.constants.decfmt2.format(calendar.getMonth() + 1) + "-" + (this).ObservationsSearchDialog.this.constants.decfmt2.format(calendar.getDay()) + " " + (this).ObservationsSearchDialog.this.constants.decfmt2.format(time.getHours()) + ":" + (this).ObservationsSearchDialog.this.constants.decfmt2.format(time.getMinutes()));
                            (this).ObservationsSearchDialog.this.fromdate = (this).ObservationsSearchDialog.this.mmmddyyyyhhmm.format((this).ObservationsSearchDialog.this.dfromdate);
                            (this).ObservationsSearchDialog.this.fromdateText.setText((this).ObservationsSearchDialog.this.fromdate);
                            (this).ObservationsSearchDialog.this.fromcaldate.setTime((this).ObservationsSearchDialog.this.dfromdate);
                        }
                        catch (ParseException ex) {
                            logstr = "createDialog: fromDate button,  " + (calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear() + "  parse exception: " + ex;
                            System.out.println("ObservationsSearchDialog - " + logstr);
                            CorePlugin.getDefault().log.error(logstr);
                        }
                        dialog.close();
                    }
                });
                dialog.setDefaultButton(ok);
                dialog.pack();
                dialog.open();
            }
        });
        this.todateLabel = new Label(composite, 0);
        this.todateLabel.setText(Messages.getString("ObservationsSearchDialog.Label.Text.ToColon"));
        gd = new GridData(1, 0x1000000, false, false);
        gd.horizontalIndent = 20;
        gd.widthHint = 57;
        this.todateLabel.setLayoutData((Object)gd);
        this.todateLabel.setEnabled(false);
        this.todateText = new Text(composite, 2048);
        this.todate = this.mmmddyyyyhhmm.format(this.tocaldate.getTime());
        try {
            this.dtodate = this.yyyymmddhhmm.parse(this.yyyymmddhhmm.format(this.tocaldate.getTime()));
        }
        catch (ParseException ex) {
            String logstr = "createDialog: toDate " + this.todate + "  parse exception: " + ex;
            System.out.println("ObservationsSearchDialog - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        this.todateText.setText(this.todate);
        gd = new GridData(1, 0x1000000, false, false);
        gd.widthHint = 75;
        this.todateText.setLayoutData((Object)gd);
        this.todateText.setEnabled(false);
        this.todateText.setEditable(false);
        Button todateButton = new Button(composite, 8);
        todateButton.setImage(image3);
        gd = new GridData(1, 16384, true, false);
        todateButton.setLayoutData((Object)gd);
        todateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Shell dialog = new Shell(ObservationsSearchDialog.this.shell, 2144);
                dialog.setLayout((Layout)new GridLayout(1, false));
                dialog.setLocation(350, 180);
                final DateTime calendar = new DateTime((Composite)dialog, 3072);
                final DateTime time = new DateTime((Composite)dialog, 0x10000080);
                calendar.setYear(ObservationsSearchDialog.this.tocaldate.get(1));
                calendar.setMonth(ObservationsSearchDialog.this.tocaldate.get(2));
                calendar.setDay(ObservationsSearchDialog.this.tocaldate.get(5));
                time.setHours(ObservationsSearchDialog.this.tocaldate.get(11));
                time.setMinutes(ObservationsSearchDialog.this.tocaldate.get(12));
                time.setSeconds(ObservationsSearchDialog.this.tocaldate.get(13));
                new Label((Composite)dialog, 0);
                Button ok = new Button((Composite)dialog, 8);
                ok.setText(Messages.getString("ObservationsSearchDialog.Button.Text.Ok"));
                ok.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String logstr = "createDialog: toDate button, Calendar date selected (MM/DD/YYYY) = " + (calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear();
                        System.out.println("ObservationsSearchDialog - " + logstr);
                        CorePlugin.getDefault().log.debug(logstr);
                        logstr = "createDialog: toDate button, Time selected (HH:MM) = " + time.getHours() + ":" + time.getMinutes();
                        System.out.println("ObservationsSearchDialog - " + logstr);
                        CorePlugin.getDefault().log.debug(logstr);
                        try {
                            (this).ObservationsSearchDialog.this.dtodate = (this).ObservationsSearchDialog.this.yyyymmddhhmm.parse(String.valueOf((this).ObservationsSearchDialog.this.constants.decfmt2.format(calendar.getYear())) + "-" + (this).ObservationsSearchDialog.this.constants.decfmt2.format(calendar.getMonth() + 1) + "-" + (this).ObservationsSearchDialog.this.constants.decfmt2.format(calendar.getDay()) + " " + (this).ObservationsSearchDialog.this.constants.decfmt2.format(time.getHours()) + ":" + (this).ObservationsSearchDialog.this.constants.decfmt2.format(time.getMinutes()));
                            (this).ObservationsSearchDialog.this.todate = (this).ObservationsSearchDialog.this.mmmddyyyyhhmm.format((this).ObservationsSearchDialog.this.dtodate);
                            (this).ObservationsSearchDialog.this.todateText.setText((this).ObservationsSearchDialog.this.todate);
                            (this).ObservationsSearchDialog.this.tocaldate.setTime((this).ObservationsSearchDialog.this.dtodate);
                        }
                        catch (ParseException ex) {
                            logstr = "createDialog: toDate button,  " + (calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear() + "  parse exception: " + ex;
                            System.out.println("ObservationsSearchDialog - " + logstr);
                            CorePlugin.getDefault().log.error(logstr);
                        }
                        dialog.close();
                    }
                });
                dialog.setDefaultButton(ok);
                dialog.pack();
                dialog.open();
            }
        });
        this.itemdatecheck = new ExpandItem(bar, 0, 0);
        this.itemdatecheck.setText(Messages.getString("ObservationsSearchDialog.ExpandItem.Text.RequestDateTime"));
        this.itemdatecheck.setHeight(composite.computeSize((int)-1, (int)-1).y);
        this.itemdatecheck.setControl((Control)composite);
        this.itemdatecheck.setImage(image);
        composite = new Composite((Composite)bar, 0);
        layout = new GridLayout(2, false);
        layout.marginBottom = 10;
        layout.marginRight = 10;
        layout.marginTop = 10;
        layout.marginLeft = 10;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.samplesCheck = new Button(composite, 32);
        this.samplesCheck.setText(Messages.getString("ObservationsSearchDialog.Button.Text.LimitSampleSizeRange"));
        gd = new GridData(1, 0x1000000, true, false);
        gd.horizontalIndent = 10;
        this.samplesCheck.setLayoutData((Object)new GridData(4, 128, true, true, 2, 1));
        this.samplesCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ObservationsSearchDialog.this.samplesCheck.getSelection()) {
                    ObservationsSearchDialog.this.fromsamplesLabel.setEnabled(true);
                    ObservationsSearchDialog.this.fromsamplesText.setEnabled(true);
                    ObservationsSearchDialog.this.tosamplesLabel.setEnabled(true);
                    ObservationsSearchDialog.this.tosamplesText.setEnabled(true);
                } else {
                    ObservationsSearchDialog.this.fromsamplesLabel.setEnabled(false);
                    ObservationsSearchDialog.this.fromsamplesText.setEnabled(false);
                    ObservationsSearchDialog.this.tosamplesLabel.setEnabled(false);
                    ObservationsSearchDialog.this.tosamplesText.setEnabled(false);
                }
            }
        });
        this.fromsamplesLabel = new Label(composite, 0);
        this.fromsamplesLabel.setText(Messages.getString("ObservationsSearchDialog.Label.Text.From"));
        gd = new GridData(1, 0x1000000, false, false);
        gd.horizontalIndent = 10;
        gd.widthHint = 57;
        this.fromsamplesLabel.setEnabled(false);
        this.fromsamplesLabel.setLayoutData((Object)gd);
        this.fromsamplesText = new Text(composite, 2048);
        this.fromsamplesText.setText("0");
        gd = new GridData(1, 0x1000000, true, false);
        gd.widthHint = 50;
        this.fromsamplesText.setEnabled(false);
        this.fromsamplesText.setLayoutData((Object)gd);
        this.tosamplesLabel = new Label(composite, 0);
        this.tosamplesLabel.setText(Messages.getString("ObservationsSearchDialog.Label.Text.To"));
        gd = new GridData(1, 0x1000000, false, false);
        gd.horizontalIndent = 10;
        gd.widthHint = 25;
        this.tosamplesLabel.setEnabled(false);
        this.tosamplesLabel.setLayoutData((Object)gd);
        this.tosamplesText = new Text(composite, 2048);
        this.tosamplesText.setText("0");
        gd = new GridData(1, 0x1000000, true, false);
        gd.widthHint = 50;
        this.tosamplesText.setEnabled(false);
        this.tosamplesText.setLayoutData((Object)gd);
        this.itemsamplescheck = new ExpandItem(bar, 0, 1);
        this.itemsamplescheck.setText(Messages.getString("ObservationsSearchDialog.ExpandItem.Text.LimitSampleSize"));
        this.itemsamplescheck.setHeight(composite.computeSize((int)-1, (int)-1).y);
        this.itemsamplescheck.setControl((Control)composite);
        this.itemsamplescheck.setImage(image);
        composite = new Composite((Composite)bar, 0);
        layout = new GridLayout(2, false);
        layout.marginBottom = 10;
        layout.marginRight = 10;
        layout.marginTop = 10;
        layout.marginLeft = 10;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.reqnumCheck = new Button(composite, 32);
        this.reqnumCheck.setText(Messages.getString("ObservationsSearchDialog.Button.Text.LimitRequestNumberRange"));
        gd = new GridData(1, 0x1000000, true, false);
        gd.horizontalIndent = 10;
        this.reqnumCheck.setLayoutData((Object)new GridData(4, 128, true, true, 2, 1));
        this.reqnumCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ObservationsSearchDialog.this.reqnumCheck.getSelection()) {
                    ObservationsSearchDialog.this.fromreqnumLabel.setEnabled(true);
                    ObservationsSearchDialog.this.fromreqnumText.setEnabled(true);
                    ObservationsSearchDialog.this.toreqnumLabel.setEnabled(true);
                    ObservationsSearchDialog.this.toreqnumText.setEnabled(true);
                } else {
                    ObservationsSearchDialog.this.fromreqnumLabel.setEnabled(false);
                    ObservationsSearchDialog.this.fromreqnumText.setEnabled(false);
                    ObservationsSearchDialog.this.toreqnumLabel.setEnabled(false);
                    ObservationsSearchDialog.this.toreqnumText.setEnabled(false);
                }
            }
        });
        this.fromreqnumLabel = new Label(composite, 0);
        this.fromreqnumLabel.setText(Messages.getString("ObservationsSearchDialog.Label.Text.From"));
        gd = new GridData(1, 0x1000000, false, false);
        gd.horizontalIndent = 10;
        gd.widthHint = 57;
        this.fromreqnumLabel.setEnabled(false);
        this.fromreqnumLabel.setLayoutData((Object)gd);
        this.fromreqnumText = new Text(composite, 2048);
        this.fromreqnumText.setText(CorePlugin.getDefault().constants.reqdefault);
        gd = new GridData(1, 0x1000000, true, false);
        gd.widthHint = 50;
        this.fromreqnumText.setEnabled(false);
        this.fromreqnumText.setLayoutData((Object)gd);
        this.toreqnumLabel = new Label(composite, 0);
        this.toreqnumLabel.setText(Messages.getString("ObservationsSearchDialog.Label.Text.To"));
        gd = new GridData(1, 0x1000000, false, false);
        gd.horizontalIndent = 10;
        gd.widthHint = 25;
        this.toreqnumLabel.setEnabled(false);
        this.toreqnumLabel.setLayoutData((Object)gd);
        this.toreqnumText = new Text(composite, 2048);
        this.toreqnumText.setText("99999");
        gd = new GridData(1, 0x1000000, true, false);
        gd.widthHint = 50;
        this.toreqnumText.setEnabled(false);
        this.toreqnumText.setLayoutData((Object)gd);
        this.itemreqnumcheck = new ExpandItem(bar, 0, 1);
        this.itemreqnumcheck.setText(Messages.getString("ObservationsSearchDialog.ExpandItem.Title.LimitRequestNumber"));
        this.itemreqnumcheck.setHeight(composite.computeSize((int)-1, (int)-1).y);
        this.itemreqnumcheck.setControl((Control)composite);
        this.itemreqnumcheck.setImage(image);
        this.itemdatecheck.setExpanded(true);
        bar.setSpacing(8);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite client = new Composite(this.content, 0);
        GridLayout layout = new GridLayout(1, true);
        client.setLayoutData((Object)new GridData(131072, 4, true, true, 2, 2));
        client.setLayout((Layout)layout);
        this.createButton(client, 0, Messages.getString("ObservationsSearchDialog.Button.Text.Ok"), true);
        this.createButton(client, 1, Messages.getString("ObservationsSearchDialog.Button.Text.Cancel"), false);
    }

    public void okPressed() {
        if (this.searchtextText.getText().length() <= 0 & !this.daterangeCheck.getSelection() & !this.reqnumCheck.getSelection() & !this.samplesCheck.getSelection()) {
            this.setErrorMessage(Messages.getString("ObservationsSearchDiaCorePlugin.getDefault().log.errorMessage.ReqnumCheck"));
        } else {
            ObservationsSearchItems items = new ObservationsSearchItems();
            items.setSearchText(this.searchtextText.getText());
            CorePlugin.getDefault().getPreferenceStore().setValue("SEARCHTEXT", this.searchtextText.getText());
            CorePlugin.getDefault().getPreferenceStore().setValue("SEARCHFOR", this.searchforCombo.getText());
            CorePlugin.getDefault().getPreferenceStore().setValue("DATERANGECHECK", this.daterangeCheck.getSelection());
            CorePlugin.getDefault().getPreferenceStore().setValue("REQNUMCHECK", this.reqnumCheck.getSelection());
            CorePlugin.getDefault().getPreferenceStore().setValue("SAMPLESCHECK", this.samplesCheck.getSelection());
            CorePlugin.getDefault().getPreferenceStore().setValue("CASESENSITIVE", this.caseCheck.getSelection());
            if (this.daterangeCheck.getSelection()) {
                CorePlugin.getDefault().getPreferenceStore().setValue("FROMDATE", this.yyyymmddhhmm.format(this.dfromdate));
                CorePlugin.getDefault().getPreferenceStore().setValue("TODATE", this.yyyymmddhhmm.format(this.dtodate));
            }
            if (this.reqnumCheck.getSelection()) {
                CorePlugin.getDefault().getPreferenceStore().setValue("FROMREQNUM", this.fromreqnumText.getText());
                CorePlugin.getDefault().getPreferenceStore().setValue("TOREQNUM", this.toreqnumText.getText());
            }
            if (this.samplesCheck.getSelection()) {
                CorePlugin.getDefault().getPreferenceStore().setValue("FROMSAMPLES", this.fromsamplesText.getText());
                CorePlugin.getDefault().getPreferenceStore().setValue("TOSAMPLES", this.tosamplesText.getText());
            }
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            try {
                ObservationsSearchView view = (ObservationsSearchView)page.showView("com.banknet.core.ObservationsSearchView");
                view.addPage();
            }
            catch (Exception e) {
                String logstr = "okPressed:  exception in ObservationsSearchDialog: " + e;
                System.out.println("ObservationsSearchDialog - " + logstr);
                CorePlugin.getDefault().log.error(logstr);
            }
            this.dispose();
            this.setReturnCode(0);
            this.close();
            super.okPressed();
        }
    }

    public void cancelPressed() {
        this.dispose();
        this.setReturnCode(1);
        this.close();
        super.cancelPressed();
    }

    public int getShellStyle() {
        return 134384;
    }

    public void dispose() {
        this.imgSearch.dispose();
    }
}

