/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs;

import com.banknet.core.CorePlugin;
import com.banknet.core.dialogs.Messages;
import com.banknet.core.internal.Constants;
import com.banknet.core.preferences.PreferencesConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ObservationsFilterDialog
extends TitleAreaDialog {
    PreferencesConstants pconstants = new PreferencesConstants();
    Constants constants = new Constants();
    private Text jobnameText;
    private Text ownedbyText;
    private Combo sortSeq;
    Composite content;
    private Integer fontSize;
    private long fontDataHeight;
    int labelw = 100;
    String OSenv = "";
    Image imgFilter = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/elcl16/filter_ps.gif").createImage();

    public ObservationsFilterDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell dialogShell) {
        super.configureShell(dialogShell);
        dialogShell.setText(Messages.getString("ObservationsFilterDialog.ShellTitle"));
        dialogShell.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/elcl16/filter_ps.gif").createImage());
        this.OSenv = System.getProperty("os.name").toLowerCase();
        if (this.OSenv.startsWith("windows")) {
            this.fontSize = dialogShell.getFont().getFontData()[0].getHeight();
            if (this.fontSize > this.constants.FONT_NORMAL) {
                this.setLargeFontSizes();
            }
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialogShell, String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".dialogs_ObservationsFilterContext");
    }

    private void setLargeFontSizes() {
        double lgsize = 0.0;
        double sizemult = 1.25;
        if (this.fontSize > this.constants.FONT_LARGE | this.fontDataHeight < this.constants.FONTDATA_LARGE) {
            sizemult = 1.4;
        }
        lgsize = (double)this.labelw * sizemult;
        this.labelw = (int)lgsize;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(Messages.getString("ObservationsFilterDialog.Title"));
        this.setMessage(Messages.getString("ObservationsFilterDialog.Instruction"), 1);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        this.content = parent;
        ((GridLayout)this.content.getLayout()).numColumns = 2;
        Label ownedbyLabel = new Label(this.content, 0);
        ownedbyLabel.setText(Messages.getString("ObservationsFilterDialog.Label.Text.OwnedBy"));
        GridData gd = new GridData(1, 0x1000000, false, false);
        gd.horizontalIndent = 20;
        gd.widthHint = this.labelw;
        ownedbyLabel.setLayoutData((Object)gd);
        this.ownedbyText = new Text(this.content, 2048);
        this.ownedbyText.setText(CorePlugin.getDefault().getPreferenceStore().getString("filterOwnedby"));
        gd = new GridData(1, 0x1000000, true, false);
        gd.horizontalIndent = 20;
        gd.widthHint = 50;
        this.ownedbyText.setLayoutData((Object)gd);
        Label jobnameLabel = new Label(this.content, 0);
        jobnameLabel.setText(Messages.getString("ObservationsFilterDialog.Label.Text.JobName"));
        gd = new GridData(1, 0x1000000, false, false);
        gd.horizontalIndent = 20;
        gd.widthHint = this.labelw;
        jobnameLabel.setLayoutData((Object)gd);
        this.jobnameText = new Text(this.content, 2048);
        this.jobnameText.setText(CorePlugin.getDefault().getPreferenceStore().getString("filterJobname"));
        gd = new GridData(1, 0x1000000, true, false);
        gd.horizontalIndent = 20;
        this.jobnameText.setTextLimit(8);
        gd.widthHint = 75;
        this.jobnameText.setLayoutData((Object)gd);
        Label sortseqLabel = new Label(this.content, 0);
        sortseqLabel.setText(Messages.getString("ObservationsFilterDialog.Label.Text.SortSequence"));
        gd = new GridData(1, 0x1000000, false, false);
        gd.horizontalIndent = 20;
        gd.widthHint = this.labelw;
        sortseqLabel.setLayoutData((Object)gd);
        this.sortSeq = new Combo(this.content, 8);
        this.sortSeq.setData(String.valueOf(this.sortSeq.getItemCount()), (Object)this.pconstants.SORTSEQ_REQNUM);
        this.sortSeq.add(Messages.getString("ObservationsFilterDialog.ReqNum"));
        this.sortSeq.setData(String.valueOf(this.sortSeq.getItemCount()), (Object)this.pconstants.SORTSEQ_OWNEDBY);
        this.sortSeq.add(Messages.getString("ObservationsFilterDialog.OwnedBy"));
        this.sortSeq.setData(String.valueOf(this.sortSeq.getItemCount()), (Object)this.pconstants.SORTSEQ_DESCRIPTION);
        this.sortSeq.add(Messages.getString("ObservationsFilterDialog.Description"));
        this.sortSeq.setData(String.valueOf(this.sortSeq.getItemCount()), (Object)this.pconstants.SORTSEQ_JOBNAME);
        this.sortSeq.add(Messages.getString("ObservationsFilterDialog.JobName"));
        this.sortSeq.setData(String.valueOf(this.sortSeq.getItemCount()), (Object)this.pconstants.SORTSEQ_DATETIME);
        this.sortSeq.add(Messages.getString("ObservationsFilterDialog.DateTime"));
        this.sortSeq.setData(String.valueOf(this.sortSeq.getItemCount()), (Object)this.pconstants.SORTSEQ_SAMPLES);
        this.sortSeq.add(Messages.getString("ObservationsFilterDialog.Samples"));
        this.sortSeq.setData(String.valueOf(this.sortSeq.getItemCount()), (Object)this.pconstants.SORTSEQ_STATUS);
        this.sortSeq.add(Messages.getString("ObservationsFilterDialog.Status"));
        this.setSortSeq(CorePlugin.getDefault().getPreferenceStore().getString("sortSeq").toLowerCase());
        gd = new GridData(1, 0x1000000, true, false);
        gd.horizontalIndent = 20;
        gd.widthHint = 75;
        this.sortSeq.setLayoutData((Object)gd);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite client = new Composite(this.content, 0);
        GridLayout layout = new GridLayout(1, false);
        client.setLayoutData((Object)new GridData(131072, 0x1000000, false, true, 1, 1));
        client.setLayout((Layout)layout);
        this.createButton(client, 0, Messages.getString("ObservationsFilterDialog.Button.Text.Ok"), true);
        this.createButton(client, 1, Messages.getString("ObservationsFilterDialog.Button.Text.Cancel"), false);
    }

    public void okPressed() {
        int rc = this.validateInput(this.jobnameText.getText());
        switch (rc) {
            case 1: {
                this.setErrorMessage(Messages.getString("ObservationsFilterDialog.errorMessage.JobNameFilterMissing"));
                break;
            }
            case 2: {
                this.setErrorMessage(Messages.getString("ObservationsFilterDialog.errorMessage.JobNameInvalidPatternFirstChar"));
                break;
            }
            case 3: {
                this.setErrorMessage(Messages.getString("ObservationsFilterDialog.errorMessage.JobNameInvalidPattern"));
                break;
            }
            case 4: {
                this.setErrorMessage(Messages.getString("ObservationsFilterDialog.errorMessage.JobNameInvalidPatternLastChar"));
                break;
            }
            case 5: {
                this.setErrorMessage(Messages.getString("ObservationsFilterDialog.errorMessage.JobNameInvalidPatternWildCard"));
                break;
            }
        }
        if (rc == 0) {
            rc = this.validateInput(this.ownedbyText.getText());
            switch (rc) {
                case 1: {
                    this.setErrorMessage(Messages.getString("ObservationsFilterDialog.errorMessage.OwnedByFilterMissing"));
                    break;
                }
                case 2: {
                    this.setErrorMessage(Messages.getString("ObservationsFilterDialog.errorMessage.OwnedByInvalidPatternFirstChar"));
                    break;
                }
                case 3: {
                    this.setErrorMessage(Messages.getString("ObservationsFilterDialog.errorMessage.OwnedByInvalidPattern"));
                    break;
                }
                case 4: {
                    this.setErrorMessage(Messages.getString("ObservationsFilterDialog.errorMessage.OwnedByInvalidPatternLastChar"));
                    break;
                }
                case 5: {
                    this.setErrorMessage(Messages.getString("ObservationsFilterDialog.errorMessage.OwnedByInvalidPatternWildCard"));
                    break;
                }
            }
        }
        if (rc == 0) {
            CorePlugin.getDefault().getPreferenceStore().setValue("filterJobname", this.jobnameText.getText().toUpperCase());
            CorePlugin.getDefault().getPreferenceStore().setValue("filterOwnedby", this.ownedbyText.getText().toUpperCase());
            CorePlugin.getDefault().getPreferenceStore().setValue("sortSeq", (String)this.sortSeq.getData(String.valueOf(this.sortSeq.getSelectionIndex())));
            this.dispose();
            this.setReturnCode(0);
            this.close();
            super.okPressed();
        }
    }

    public void cancelPressed() {
        this.dispose();
        this.setReturnCode(1);
        this.close();
        super.cancelPressed();
    }

    private void setSortSeq(String sortseq) {
        if (sortseq != null) {
            int i = 0;
            while (i < this.sortSeq.getItemCount()) {
                if (sortseq.indexOf((String)this.sortSeq.getData(String.valueOf(i))) != -1) {
                    this.sortSeq.select(i);
                }
                ++i;
            }
        }
    }

    public void dispose() {
        this.imgFilter.dispose();
    }

    public int getShellStyle() {
        return 134384;
    }

    public int validateInput(String fieldValue) {
        if (fieldValue.length() <= 0) {
            return 1;
        }
        if (fieldValue.matches("[^A-Za-z*%@#]+$")) {
            return 2;
        }
        if (fieldValue.length() > 1 && fieldValue.matches("^.[^A-Za-z0-9*%@#]+$")) {
            return 3;
        }
        if (fieldValue.indexOf("*") > 0) {
            int testLen = fieldValue.length();
            int testPos = fieldValue.indexOf("*") + 1;
            if (testPos < testLen) {
                return 4;
            }
        }
        if (fieldValue.indexOf("*") >= 0 && fieldValue.indexOf("%") >= 0) {
            return 5;
        }
        return 0;
    }
}

