/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs;

import com.banknet.core.CorePlugin;
import com.banknet.core.dialogs.Messages;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.ObservationRequestJob;
import com.banknet.core.models.ObservationsModel;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ModifyDescriptionDialog
extends Dialog {
    Constants constants = new Constants();
    Composite content;
    Composite descriptioncomp;
    Shell shell;
    Shell dialogshell;
    Button okButton;
    private int reqnum;
    String sreqnum = "";
    ObservationsModel observation;
    public Text obsDescription;
    public Text obsNotes1;
    public Text obsNotes2;
    public Text obsNotes3;
    String errmsg = "";
    private static String DESCRIPTION_LABEL = Messages.getString("ModifyDescriptionDialog.Label.Description");

    public ModifyDescriptionDialog(Shell parentShell, int reqnum) {
        super(parentShell);
        this.shell = parentShell;
        this.reqnum = reqnum;
        this.sreqnum = this.constants.reqdecfmt.format(reqnum);
        this.observation = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(reqnum));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String msg = Messages.getString("ModifyDescriptionDialog.ShellTitle");
        msg = msg.replace("#reqnum", this.sreqnum);
        newShell.setText(msg);
        newShell.setImage(CorePlugin.getDefault().productextension.getDialogShellImage());
    }

    protected Control createDialogArea(Composite parent) {
        this.dialogshell = parent.getShell();
        this.content = parent;
        ((GridLayout)this.content.getLayout()).numColumns = 2;
        Composite labelcomp = new Composite(this.content, 0);
        GridData gd3 = new GridData(4, 128, true, false, 2, 1);
        labelcomp.setLayoutData((Object)gd3);
        labelcomp.setLayout((Layout)new GridLayout(1, false));
        Label instructionLabel = new Label(labelcomp, 0);
        instructionLabel.setText(Messages.getString("ModifyDescriptionDialog.TitleMessage"));
        GridData gd = new GridData(1, 128, true, false, 1, 1);
        gd.horizontalIndent = 5;
        instructionLabel.setLayoutData((Object)gd);
        this.descriptioncomp = new Group(this.content, 0);
        ((Group)this.descriptioncomp).setText("");
        this.descriptioncomp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 9, 1));
        this.descriptioncomp.setLayout((Layout)new GridLayout(2, false));
        Label obsDescriptionLabel = new Label(this.descriptioncomp, 0);
        obsDescriptionLabel.setText(DESCRIPTION_LABEL);
        gd = new GridData(1, 128, false, false);
        gd.heightHint = 35;
        obsDescriptionLabel.setLayoutData((Object)gd);
        this.obsDescription = new Text(this.descriptioncomp, 2048);
        this.obsDescription.setText(this.observation.description);
        this.obsDescription.setTextLimit(48);
        gd = new GridData(4, 128, true, false);
        gd.widthHint = 400;
        this.obsDescription.setLayoutData((Object)gd);
        Label notes1Label = new Label(this.descriptioncomp, 0);
        notes1Label.setText(Messages.getString("ModifyDescriptionDialog.Label.Notes"));
        gd = new GridData(1, 128, false, false);
        notes1Label.setLayoutData((Object)gd);
        this.obsNotes1 = new Text(this.descriptioncomp, 2048);
        this.obsNotes1.setText(this.observation.notes1);
        this.obsNotes1.setTextLimit(48);
        gd = new GridData(4, 128, true, false);
        gd.widthHint = 400;
        this.obsNotes1.setLayoutData((Object)gd);
        Label notes2Label = new Label(this.descriptioncomp, 0);
        gd = new GridData(1, 128, false, false);
        notes2Label.setLayoutData((Object)gd);
        this.obsNotes2 = new Text(this.descriptioncomp, 2048);
        this.obsNotes2.setText(this.observation.notes2);
        this.obsNotes2.setTextLimit(48);
        gd = new GridData(4, 128, true, false);
        gd.widthHint = 400;
        this.obsNotes2.setLayoutData((Object)gd);
        Label notes3Label = new Label(this.descriptioncomp, 0);
        gd = new GridData(1, 128, false, false);
        notes3Label.setLayoutData((Object)gd);
        this.obsNotes3 = new Text(this.descriptioncomp, 2048);
        this.obsNotes3.setText(this.observation.notes3);
        this.obsNotes3.setTextLimit(48);
        gd = new GridData(4, 128, true, false);
        gd.widthHint = 400;
        this.obsNotes3.setLayoutData((Object)gd);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite client = new Composite(this.content, 0);
        GridLayout layout = new GridLayout(1, false);
        client.setLayoutData((Object)new GridData(131072, 1024, true, false, 1, 1));
        client.setLayout((Layout)layout);
        this.okButton = this.createButton(client, 0, Messages.getString("ModifyDescriptionDialog.Button.Text.Ok"), true);
        this.createButton(client, 1, Messages.getString("ModifyDescriptionDialog.Button.Text.Cancel"), false);
        this.content.layout(false);
    }

    public void okPressed() {
        if (this.chkComplete()) {
            this.updateDescription();
            this.setReturnCode(0);
            this.close();
        }
    }

    public void cancelPressed() {
        this.setReturnCode(1);
        this.close();
        super.cancelPressed();
    }

    public boolean chkComplete() {
        boolean isComplete = true;
        this.errmsg = "";
        if (!this.chkObsDescription()) {
            isComplete = false;
        }
        if (this.errmsg.length() > 0) {
            this.showMessage("error", Messages.getString("ModifyDescriptionDialog.DialogTitle"), this.errmsg);
        }
        return isComplete;
    }

    private boolean chkObsDescription() {
        boolean isValid = true;
        if (!this.obsDescription.getText().isEmpty()) {
            this.obsDescription.setText(this.obsDescription.getText().replaceAll("\"", "'"));
            if (CorePlugin.getDefault().getStcProperties().PABENT_FLAGS3_DescReqd & this.obsDescription.getText().length() < 8) {
                this.errmsg = Messages.getString("ModifyDescriptionDialog.chkDescr.TooSmall");
            }
        } else if (!this.observation.jobname.isEmpty() && CorePlugin.getDefault().getStcProperties().PABENT_FLAGS3_DescReqd) {
            this.errmsg = Messages.getString("ModifyDescriptionDialog.chkDescr.DescrRequired");
        }
        if (this.errmsg.length() > 0) {
            isValid = false;
        }
        return isValid;
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
        }
    }

    private void logMessage(char loglevel, String logstr) {
        System.out.println("ModifyDescriptionDialog - " + logstr);
        switch (loglevel) {
            case 'E': {
                CorePlugin.getDefault().log.error(logstr);
                break;
            }
            case 'I': {
                CorePlugin.getDefault().log.info(logstr);
                break;
            }
            case 'W': {
                CorePlugin.getDefault().log.warn(logstr);
                break;
            }
            default: {
                CorePlugin.getDefault().log.debug(logstr);
            }
        }
    }

    public String stripChar(String val, char stripchar) {
        String strippedval = "";
        if (val.indexOf(stripchar) < 0) {
            return val;
        }
        int i = 0;
        while (i < val.length()) {
            if (val.charAt(i) != stripchar) {
                strippedval = val.substring(i, val.length());
                break;
            }
            ++i;
        }
        if (strippedval.length() <= 0) {
            strippedval = val.substring(val.length() - 1);
        }
        return strippedval;
    }

    private void updateDescription() {
        String sreqnum = this.constants.reqdecfmt.format(CorePlugin.getDefault().selobs.reqnum);
        String jobname = this.observation.jobname;
        String ownedby = this.observation.ownedby;
        String valsystem = this.observation.system;
        CorePlugin.getDefault().session.commandLine = "";
        System.out.println("buildMessage: Reqnum " + sreqnum);
        CorePlugin.getDefault().session.buildCommandParm("REQNUM", sreqnum);
        System.out.println("buildMessage: Jobname " + jobname);
        CorePlugin.getDefault().session.buildCommandParm("JOBNAME", jobname);
        System.out.println("buildMessage: Description " + this.obsDescription.getText().trim());
        String descr = this.obsDescription.getText().trim();
        CorePlugin.getDefault().session.buildCommandParm("DESCR", descr);
        System.out.println("buildMessage: Notes1 " + this.obsNotes1.getText().trim());
        String notes1 = this.obsNotes1.getText().trim();
        CorePlugin.getDefault().session.buildCommandParm("NOTES1", notes1);
        System.out.println("buildMessage: Notes2 " + this.obsNotes2.getText().trim());
        String notes2 = this.obsNotes2.getText().trim();
        CorePlugin.getDefault().session.buildCommandParm("NOTES2", notes2);
        System.out.println("buildMessage: Notes3 " + this.obsNotes3.getText().trim());
        String notes3 = this.obsNotes3.getText().trim();
        CorePlugin.getDefault().session.buildCommandParm("NOTES3", notes3);
        String commandParms = CorePlugin.getDefault().session.commandLine;
        ObservationRequestJob zosrequestjob = new ObservationRequestJob(this.shell);
        zosrequestjob.reqnum = this.reqnum;
        zosrequestjob.apaParms = commandParms;
        zosrequestjob.apaRequest = this.constants.ACTION_MODIFY;
        zosrequestjob.apaRequestTitle = Messages.getString("ModifyDescriptionDialog.Mod.Action.Text");
        zosrequestjob.ownedby = ownedby;
        zosrequestjob.validateSystem = valsystem;
        zosrequestjob.runObservationRequestJob();
    }
}

