/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.data.StcProperties;
import com.banknet.core.dialogs.DatasetListDialog;
import com.banknet.core.dialogs.ImportedObservationDialog;
import com.banknet.core.dialogs.Messages;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.ZosSession;
import java.io.File;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class ImportObservationDialog
extends TrayDialog {
    Constants constants = new Constants();
    ZosConnect zosconnect = new ZosConnect();
    StcProperties stcproperties = CorePlugin.getDefault().getStcProperties();
    Shell shell;
    private Label importDsnLabel;
    private Label dsnDescriptionLabel;
    private Text importDsnText;
    private Text dsnDescriptionText;
    private Button getDatasetListButton;
    private Button deleteDsnCheckbox;
    Composite content;
    Composite content1;
    int reqnum;
    String sreqnum;
    String errmsg = "";
    String importDsn = "";
    String dsnDescription = "";
    boolean deleteDsn = false;
    String importedReqnum = "";
    ByteBuffer bbRespBuffer;

    public ImportObservationDialog(Shell parentShell) {
        super(parentShell);
        this.shell = parentShell;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("ImportObservationDialog.ShellTitle"));
        newShell.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/import_wiz.gif").createImage());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".dialogs_ImportObservationContext");
    }

    protected Control createDialogArea(Composite parent) {
        this.content1 = new Composite(parent, 0);
        GridLayout layout1 = new GridLayout(1, false);
        this.content1.setLayout((Layout)layout1);
        GridData gd3 = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        this.content1.setLayoutData((Object)gd3);
        Composite importContent = new Composite(this.content1, 0);
        GridLayout layout = new GridLayout(1, false);
        importContent.setLayout((Layout)layout);
        gd3 = new GridData(4, 128, false, false);
        gd3.widthHint = 450;
        importContent.setLayoutData((Object)gd3);
        Label instructionsLabel1 = new Label(importContent, 64);
        instructionsLabel1.setText(Messages.getString("ImportObservationDialog.Label.Instructions"));
        GridData gd = new GridData(4, 0x1000000, true, false, 1, 1);
        gd.horizontalIndent = 5;
        instructionsLabel1.setLayoutData((Object)gd);
        this.content = new Composite(this.content1, 4);
        GridLayout layout2 = new GridLayout(3, false);
        this.content.setLayout((Layout)layout2);
        gd3 = new GridData(1, 128, false, true, 1, 1);
        this.content.setLayoutData((Object)gd3);
        this.importDsnLabel = new Label(this.content, 0);
        this.importDsnLabel.setText(Messages.getString("ImportObservationDialog.Label.Text.ImportDsn"));
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        gd.horizontalIndent = 5;
        this.importDsnLabel.setLayoutData((Object)gd);
        this.importDsnText = new Text(this.content, 2048);
        this.importDsnText.setText(String.valueOf(CorePlugin.getDefault().tsoid.toUpperCase()) + ".*.XMIT");
        this.importDsnText.setTextLimit(44);
        gd = new GridData(4, 0x1000000, true, false, 1, 1);
        gd.widthHint = 250;
        this.importDsnText.setLayoutData((Object)gd);
        this.importDsnText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ImportObservationDialog.this.importDsnText.setText(ImportObservationDialog.this.importDsnText.getText().trim().toUpperCase());
            }
        });
        this.getDatasetListButton = new Button(this.content, 8);
        this.getDatasetListButton.setText(Messages.getString("ImportObservationDialog.Button.Text.GetDatasetList"));
        gd = new GridData(1, 128, true, false, 1, 1);
        gd.minimumWidth = 75;
        this.getDatasetListButton.setLayoutData((Object)gd);
        this.getDatasetListButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatasetListDialog dld = new DatasetListDialog(ImportObservationDialog.this.shell);
                dld.searchDsn = ImportObservationDialog.this.importDsnText.getText();
                int dldrc = dld.open();
                if (dldrc == 0) {
                    ImportObservationDialog.this.importDsnText.setText(dld.selectedDsn);
                }
                dld = null;
            }
        });
        this.dsnDescriptionLabel = new Label(this.content, 0);
        this.dsnDescriptionLabel.setText(Messages.getString("ImportObservationDialog.Label.Text.DsnDescription"));
        gd = new GridData(1, 0x1000000, false, false);
        gd.horizontalIndent = 5;
        this.dsnDescriptionLabel.setLayoutData((Object)gd);
        this.dsnDescriptionText = new Text(this.content, 2048);
        this.dsnDescriptionText.setText("");
        this.dsnDescriptionText.setTextLimit(48);
        gd = new GridData(4, 0x1000000, true, false, 2, 1);
        this.dsnDescriptionText.setLayoutData((Object)gd);
        this.dsnDescriptionText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ImportObservationDialog.this.dsnDescriptionText.setText(ImportObservationDialog.this.dsnDescriptionText.getText().trim());
            }
        });
        this.deleteDsnCheckbox = new Button(this.content, 32);
        this.deleteDsnCheckbox.setText(Messages.getString("ImportObservationDialog.Button.Text.DeleteImportDsn"));
        gd = new GridData(1, 0x1000000, false, false, 3, 1);
        gd.horizontalIndent = 5;
        gd.heightHint = 20;
        this.deleteDsnCheckbox.setLayoutData((Object)gd);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        GridData gd = new GridData(4, 0, true, false, 1, 1);
        client.setLayoutData((Object)gd);
        client.setLayout((Layout)layout);
        Composite tbclient = new Composite(client, 0);
        layout = new GridLayout(1, false);
        gd = new GridData(4, 0, true, false, 1, 1);
        tbclient.setLayoutData((Object)gd);
        tbclient.setLayout((Layout)layout);
        ToolBar toolBar = new ToolBar(tbclient, 0x880000);
        ++((GridLayout)parent.getLayout()).numColumns;
        GridData gd2 = new GridData(1, 0, true, false, 1, 1);
        toolBar.setLayoutData((Object)gd2);
        Cursor cursor = new Cursor((Device)parent.getDisplay(), 21);
        toolBar.setCursor(cursor);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
            }
        });
        Composite buttonclient = new Composite(client, 0);
        layout = new GridLayout(2, false);
        gd = new GridData(131072, 0, true, false, 1, 1);
        buttonclient.setLayoutData((Object)gd);
        buttonclient.setLayout((Layout)layout);
        this.createButton(client, 0, Messages.getString("ImportObservationDialog.Button.Text.Ok"), false);
        this.createButton(client, 1, Messages.getString("ImportObservationDialog.Button.Text.Cancel"), false);
    }

    public void okPressed() {
        this.importDsn = this.importDsnText.getText();
        this.deleteDsn = this.deleteDsnCheckbox.getSelection();
        this.dsnDescription = this.dsnDescriptionText.getText();
        boolean isComplete = this.chkComplete();
        if (isComplete) {
            this.runImportObservationJob();
        }
    }

    public void cancelPressed() {
        this.setReturnCode(1);
        this.close();
    }

    public boolean chkComplete() {
        boolean isComplete = true;
        this.errmsg = "";
        this.chkImportDsn();
        if (this.errmsg.length() <= 0) {
            this.chkDsnDescription();
        }
        if (this.errmsg.length() > 0) {
            isComplete = false;
            this.showMessage("error", Messages.getString("ImportObservationDialog.ShellTitle"), this.errmsg);
        }
        return isComplete;
    }

    private boolean chkImportDsn() {
        boolean isValid = true;
        this.importDsn = this.importDsn.toUpperCase();
        this.errmsg = this.chkMandatory(this.importDsn, Messages.getString("ImportObservationDialog.Label.Text.ImportDsn"));
        if (this.errmsg.length() > 0) {
            return false;
        }
        if (this.importDsn.indexOf("\"") >= 0) {
            this.errmsg = Messages.getString("ImportObservationDialog.chkDsn.InvalidDsn");
            return false;
        }
        if (this.importDsn.endsWith(".") || this.importDsn.indexOf("..") > 0) {
            this.errmsg = Messages.getString("ImportObservationDialog.chkDsn.InvalidDsn");
            return false;
        }
        this.importDsn = this.importDsn.replace("'", "").trim();
        StringTokenizer st = new StringTokenizer(this.importDsn, ".");
        String libext = "";
        while (st.hasMoreTokens()) {
            libext = st.nextToken();
            if (libext.length() > 8) {
                this.errmsg = Messages.getString("ImportObservationDialog.chkDsn.InvalidDsn");
                return false;
            }
            this.errmsg = this.chkIbmName(libext, Messages.getString("ImportObservationDialog.Label.Text.ImportDsn"));
            if (this.errmsg.length() <= 0) continue;
            this.errmsg = Messages.getString("ImportObservationDialog.chkDsn.InvalidDsn");
            return false;
        }
        if (this.errmsg.length() > 0) {
            isValid = false;
        }
        return isValid;
    }

    private boolean chkDsnDescription() {
        boolean isValid = true;
        if (this.dsnDescription.length() <= 0) {
            return isValid;
        }
        this.dsnDescription.replaceAll("\"", "'");
        if (this.stcproperties.PABENT_FLAGS3_DescReqd & this.dsnDescription.length() < 8) {
            this.errmsg = Messages.getString("ImportObservationDialog.chkDsnDescription.TooSmall");
            return false;
        }
        return isValid;
    }

    private String chkIbmName(String val, String varname) {
        String errmsg = "";
        char[] chars = val.toCharArray();
        int x = 0;
        while (x < chars.length) {
            char c = chars[x];
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                if (c >= '0' && c <= '9') {
                    if (x <= 0) {
                        errmsg = String.valueOf(Messages.getString("ImportObservationDialog.chkIbmName.Invalid")) + varname;
                        return errmsg;
                    }
                } else if (c != '$' && c != '#' && c != '@') {
                    errmsg = String.valueOf(Messages.getString("ImportObservationDialog.chkIbmName.Invalid")) + varname;
                    return errmsg;
                }
            }
            ++x;
        }
        return errmsg;
    }

    private String chkMandatory(String val, String varname) {
        if (val.length() <= 0) {
            this.errmsg = String.valueOf(Messages.getString("ImportObservationDiaCorePlugin.getDefault().log.errorMessage.Mandatory")) + varname;
        }
        return this.errmsg;
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
        }
    }

    public int getShellStyle() {
        return 3312;
    }

    public void runImportObservationJob() {
        Job job0 = new Job(Messages.getString("ImportObservationDialog.Job.Task.Dsn")){

            public IStatus run(IProgressMonitor monitor) {
                String logstr;
                monitor.beginTask(Messages.getString("ImportObservationDialog.Job.Title.ImportDsn"), 100);
                if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("local") == 0) {
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(10);
                monitor.subTask(Messages.getString("ImportObservationDialog.Job.SubTask.Ping"));
                ImportObservationDialog.this.zosconnect.pingZos(monitor);
                if (ImportObservationDialog.this.zosconnect.getConnectRc() != 0) {
                    return Status.CANCEL_STATUS;
                }
                String submsg = Messages.getString("ImportObservationDialog.Job.SubTask.ImportDsn");
                submsg = submsg.replace("#dsn", ImportObservationDialog.this.importDsn);
                monitor.subTask(submsg);
                try {
                    String delcmd = "";
                    if (ImportObservationDialog.this.deleteDsn) {
                        delcmd = "DELETE";
                    }
                    delcmd = String.valueOf(delcmd) + ",";
                    String[] commandarr = new String[]{String.valueOf(ImportObservationDialog.this.constants.ZOSMESSAGE_IMPORTOBS) + " SF" + "," + ImportObservationDialog.this.importDsn + "," + delcmd + "|" + ImportObservationDialog.this.dsnDescription + "|"};
                    System.out.println("Running " + commandarr[0]);
                    byte[] bRespBuffer = CorePlugin.getDefault().session.doCmdResp(commandarr[0], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
                    ImportObservationDialog.this.bbRespBuffer = ByteBuffer.wrap(bRespBuffer);
                    CorePlugin.getDefault().session.checkResponse();
                }
                catch (Exception ex) {
                    logstr = "runImportObservationJob: Exception - " + ex;
                    System.out.println("ImportObservationDialog - " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                }
                monitor.worked(100);
                monitor.done();
                if (CorePlugin.getDefault().session.getReturnCode() == 0) {
                    try {
                        ZosSession cfr_ignored_0 = CorePlugin.getDefault().session;
                        ZosSession cfr_ignored_1 = CorePlugin.getDefault().session;
                        int offset = ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset;
                        ImportObservationDialog.this.importedReqnum = ImportObservationDialog.this.byteBufToString(offset + Integer.parseInt("C", 16), CorePlugin.getDefault().constants.reqbytebufsize, 'A').trim();
                    }
                    catch (Exception ex) {
                        logstr = "runImportObservationJob: Error extracting imported request number, exception - " + ex;
                        System.out.println("ImportObservationDialog - " + logstr);
                        CorePlugin.getDefault().log.error(logstr);
                    }
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        job0.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("Import Observation job completed successfully");
                } else {
                    System.out.println("Import Observation job did not complete successfully");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("Import Observation rc is " + (this).ImportObservationDialog.this.zosconnect.getConnectRc());
                        if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("local") == 0 | (this).ImportObservationDialog.this.zosconnect.getConnectRc() != 0) {
                            ImportObservationDialog.this.showMessage("info", Messages.getString("ImportObservationDialog.MessageDialog.infoTitle.ImportDsn"), String.valueOf(Messages.getString("ImportObservationDialog.MessageDialog.infoMessage.RemoteConnectionLost")) + Messages.getString("ImportObservationDialog.MessageDialog.infoMessage.ReConnect"));
                            (this).ImportObservationDialog.this.zosconnect.setConnectLocal();
                        } else if (CorePlugin.getDefault().session.getReturnCode() == 0) {
                            String importmsg = Messages.getString("ImportObservationDialog.MessageDialog.infoMessage.ImportSuccess");
                            importmsg = importmsg.replace("#importreq", (this).ImportObservationDialog.this.importedReqnum);
                            ImportedObservationDialog impdlg = new ImportedObservationDialog((this).ImportObservationDialog.this.shell, importmsg);
                            impdlg.open();
                            ImportObservationDialog.this.setReturnCode(0);
                            ImportObservationDialog.this.close();
                        } else {
                            String msgstr = CorePlugin.getDefault().session.getReason();
                            ImportObservationDialog.this.showMessage("error", Messages.getString("ImportObservationDialog.MessageDialog.infoTitle.ImportDsn"), msgstr);
                        }
                    }
                });
            }
        });
        job0.setUser(true);
        job0.schedule();
    }

    private String getHtmlUrl(String fname) {
        String htmlUrl = "";
        try {
            HashMap<String, String> map = new HashMap<String, String>(1);
            map.put("$nl$", Platform.getNL());
            Path path = new Path("$nl$/html/" + fname);
            URL locationUrl = FileLocator.find((Bundle)CorePlugin.getDefault().getBundle(), (IPath)path, map);
            URL fileUrl = FileLocator.toFileURL((URL)locationUrl);
            File in = new File(fileUrl.getFile());
            htmlUrl = in.getAbsolutePath();
        }
        catch (Exception ex) {
            String logstr = "getHtmlUrl: Error accessing file " + fname + ", Exception - " + ex;
            System.out.println("ImportObservationDialog - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        return htmlUrl;
    }

    public String byteBufToString(int offset, int length, char codepage) {
        byte[] ba = new byte[length];
        String sValue = null;
        int j = 0;
        while (j < length) {
            ba[j] = this.bbRespBuffer.get(offset + j);
            ++j;
        }
        try {
            sValue = codepage == 'E' ? new String(ba, CorePlugin.getDefault().getPreferenceStore().getString("codePage")) : new String(ba);
        }
        catch (Exception e) {
            String logstr = "byteBufToString: offset: " + offset + ", length: " + length + ", codepage: " + codepage + " : Exception " + e;
            System.out.println("byteBufToString - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        return sValue;
    }
}

