/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.dialogs.ExportedObservationDialog;
import com.banknet.core.dialogs.Messages;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.ZosSession;
import com.banknet.core.models.ObservationsModel;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExportObservationDialog
extends Dialog {
    Constants constants = new Constants();
    ZosConnect zosconnect = new ZosConnect();
    Shell shell;
    Composite content;
    int reqnum;
    int ireqnum;
    String sreqnum;
    String errmsg = "";
    String exportedDsn = "";
    String dsnname = "";
    String dsnDescription = "";
    Image image0;
    boolean exportable = false;
    boolean exportableTree = false;
    boolean enableDependantSelection = false;
    private String exportlist = "";
    private DecimalFormat leveldecfmt = new DecimalFormat("00");
    public ByteBuffer bbRespBuffer;
    Image imgExport = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/export_wiz.gif").createImage();

    public ExportObservationDialog(Shell parentShell, int reqnum) {
        super(parentShell);
        this.shell = parentShell;
        this.sreqnum = CorePlugin.getDefault().constants.reqdecfmt.format(reqnum);
        this.ireqnum = reqnum;
        ObservationsModel obs = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(reqnum));
        int numberOfChildren = obs.getChildren().size();
        String saveDSN = this.dsnname = obs.dsname.trim();
        this.exportable = false;
        if (numberOfChildren == 0) {
            this.exportable = this.dsnname.length() > 0;
        } else {
            this.exportableTree = this.checkExportableTree(reqnum);
            if (this.exportableTree) {
                this.exportable = true;
                this.enableDependantSelection = saveDSN.length() > 0;
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.valueOf(Messages.getString("ExportObservationDialog.ShellTitle")) + this.sreqnum);
        newShell.setImage(this.imgExport);
    }

    protected Control createDialogArea(Composite parent) {
        this.content = parent;
        ((GridLayout)this.content.getLayout()).numColumns = 2;
        GridData gd2 = new GridData(1, 4, true, true, 2, 1);
        this.content.setLayoutData((Object)gd2);
        Label infoLabel = new Label(this.content, 0);
        final Display display = this.shell.getDisplay();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ExportObservationDialog.this.image0 = display.getSystemImage(2);
            }
        });
        infoLabel.setImage(this.image0);
        gd2 = new GridData(1, 128, false, false, 1, 1);
        gd2.horizontalIndent = 10;
        gd2.verticalIndent = 5;
        infoLabel.setLayoutData((Object)gd2);
        Composite exportContent = new Composite(this.content, 0);
        GridLayout layout = new GridLayout(1, false);
        exportContent.setLayout((Layout)layout);
        GridData gd3 = new GridData(4, 128, true, false, 1, 1);
        exportContent.setLayoutData((Object)gd3);
        String exportText = "";
        exportText = this.exportable ? (this.exportableTree ? (this.enableDependantSelection ? Messages.getString("ExportObservationDialog.Label.SingleorExportableTree") : Messages.getString("ExportObservationDialog.Label.ExportableTree")) : Messages.getString("ExportObservationDialog.Label.SimpleExport")) : Messages.getString("ExportObservationDialog.Label.notExportable");
        exportText = exportText.replace("#reqnum", this.sreqnum);
        Label labelText = new Label(exportContent, 64);
        labelText.setText(exportText);
        GridData gridData = new GridData(4, 0x1000000, true, true, 1, 1);
        gridData.widthHint = 400;
        gridData.horizontalIndent = 5;
        labelText.setLayoutData((Object)gridData);
        if (this.enableDependantSelection) {
            final Button check = new Button(exportContent, 32);
            check.setText(Messages.getString("ExportObservationDialog.Checkbox.ExportDependants"));
            check.setSelection(false);
            check.setEnabled(true);
            gridData = new GridData(4, 128, true, false, 1, 1);
            gridData.horizontalIndent = 5;
            gridData.verticalIndent = 10;
            check.setLayoutData((Object)gridData);
            this.exportableTree = false;
            check.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (check.getSelection()) {
                        ExportObservationDialog.this.exportableTree = true;
                        ExportObservationDialog.this.enableDependantSelection = false;
                    }
                }
            });
        }
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite client = new Composite(this.content, 0);
        GridLayout layout = new GridLayout(2, false);
        GridData gd = new GridData(131072, 1024, true, true, 2, 1);
        client.setLayoutData((Object)gd);
        client.setLayout((Layout)layout);
        this.createButton(client, 0, Messages.getString("ExportObservationDialog.Button.Text.Ok"), false);
        if (this.exportable) {
            this.createButton(client, 1, Messages.getString("ExportObservationDialog.Button.Text.Cancel"), false);
        }
    }

    public void okPressed() {
        if (this.exportable) {
            this.runObsExportJob();
        } else {
            this.dispose();
            this.setReturnCode(0);
            this.close();
        }
    }

    public void cancelPressed() {
        this.dispose();
        this.setReturnCode(1);
        this.close();
    }

    public void dispose() {
        this.imgExport.dispose();
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
        }
    }

    public int getShellStyle() {
        return 134384;
    }

    public void runObsExportJob() {
        this.reqnum = this.ireqnum;
        this.sreqnum = CorePlugin.getDefault().constants.reqdecfmt.format(this.reqnum);
        ObservationsModel obs = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(this.reqnum));
        this.exportlist = String.valueOf(CorePlugin.getDefault().constants.reqdecfmt.format(this.reqnum)) + "-" + this.leveldecfmt.format(obs.treeLevel);
        if (this.exportableTree) {
            this.walkTree(this.reqnum);
        }
        Job job0 = new Job(String.valueOf(Messages.getString("ExportObservationDialog.Title")) + " " + this.sreqnum + Messages.getString("ExportObservationDialog.Job.Title.ActionRequest")){

            public IStatus run(IProgressMonitor monitor) {
                monitor.subTask(String.valueOf(Messages.getString("ExportObservationDialog.Title")) + " " + ExportObservationDialog.this.sreqnum + Messages.getString("ExportObservationDialog.Job.SubTask.RequestInProgress"));
                try {
                    String command = "";
                    command = ExportObservationDialog.this.exportableTree ? String.valueOf(ExportObservationDialog.this.constants.ZOSMESSAGE_EXPORTHOBS) + "," + ExportObservationDialog.this.exportlist : String.valueOf(ExportObservationDialog.this.constants.ZOSMESSAGE_EXPORTOBS) + "," + ExportObservationDialog.this.dsnname + "," + ExportObservationDialog.this.sreqnum;
                    String logstr = "runObsExportJob:  Running " + command;
                    System.out.println("ObservationRequestJob - " + logstr);
                    CorePlugin.getDefault().log.debug(logstr);
                    byte[] bRespBuffer = CorePlugin.getDefault().session.doCmdResp(command, CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
                    CorePlugin.getDefault().session.checkResponse();
                    if (CorePlugin.getDefault().session.getReturnCode() != 0) {
                        return Status.CANCEL_STATUS;
                    }
                    ExportObservationDialog.this.bbRespBuffer = ByteBuffer.wrap(bRespBuffer);
                    ExportObservationDialog.this.bbRespBuffer.clear();
                    ZosSession cfr_ignored_0 = CorePlugin.getDefault().session;
                    ZosSession cfr_ignored_1 = CorePlugin.getDefault().session;
                    int offset = ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset;
                    ExportObservationDialog.this.exportedDsn = ExportObservationDialog.this.byteBufToString(offset + Integer.parseInt("C", 16), 44, 'A').trim();
                }
                catch (Exception ex) {
                    String logstr = "runObsExportJob:  Job exception. " + ex;
                    System.out.println("ObservationRequestJob - " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                }
                monitor.worked(100);
                monitor.done();
                if (CorePlugin.getDefault().session.getReturnCode() == 0) {
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        job0.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("Export request completed successfully");
                } else {
                    System.out.println("Export request failed");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String reqactionmsg = String.valueOf(Messages.getString("ExportObservationDialog.Title")) + Messages.getString("ExportObservationDialog.MessageDialog.errorTitle.Action");
                        String msg = String.valueOf(Messages.getString("ExportObservationDialog.Title")) + Messages.getString("ExportObservationDialog.MessageDialog.errorMessage.Action");
                        msg = String.valueOf(msg) + Messages.getString("ExportObservationDialog.MessageDialog.errorMessage.For") + (this).ExportObservationDialog.this.sreqnum;
                        if (CorePlugin.getDefault().session.getReturnCode() == 0) {
                            ExportedObservationDialog expdlg = new ExportedObservationDialog((this).ExportObservationDialog.this.shell, (this).ExportObservationDialog.this.reqnum, (this).ExportObservationDialog.this.exportedDsn);
                            expdlg.open();
                            ExportObservationDialog.this.dispose();
                            ExportObservationDialog.this.setReturnCode(0);
                            ExportObservationDialog.this.close();
                        } else {
                            ExportObservationDialog.this.showMessage("error", reqactionmsg, String.valueOf(msg) + Messages.getString("ExportObservationDialog.MessageDialog.errorMessage.Failed") + CorePlugin.getDefault().session.getReason());
                            String logstr = "runObsExportJob: job failed, error RC - " + CorePlugin.getDefault().session.getReturnCode();
                            System.out.println("ExportObservationDialog - " + logstr);
                            CorePlugin.getDefault().log.error(logstr);
                        }
                    }
                });
            }
        });
        job0.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job0.schedule();
    }

    private void walkTree(int req) {
        ObservationsModel obs = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(req));
        List<ObservationsModel> obschildren = obs.getChildren();
        int i = 0;
        while (i < obschildren.size()) {
            ObservationsModel obschild = obschildren.get(i);
            System.out.println("child is : " + obschild.reqnum + ", link is " + obschild.reqlink + ", level is " + obschild.treeLevel);
            this.exportlist = String.valueOf(this.exportlist) + "," + CorePlugin.getDefault().constants.reqdecfmt.format(obschild.reqnum) + "-" + this.leveldecfmt.format(obschild.treeLevel);
            if (obschild.getChildren().size() > 0) {
                this.walkTree(obschild.reqnum);
            }
            ++i;
        }
    }

    private boolean checkExportableTree(int req) {
        this.exportableTree = false;
        ObservationsModel obs = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(req));
        List<ObservationsModel> obschildren = obs.getChildren();
        int i = 0;
        while (i < obschildren.size()) {
            ObservationsModel obschild = obschildren.get(i);
            if (obschild.dsname.length() > 0) {
                this.exportableTree = true;
                break;
            }
            if (obschild.getChildren().size() > 0) {
                this.exportableTree = this.checkExportableTree(obschild.reqnum);
                if (this.exportableTree) break;
            }
            ++i;
        }
        return this.exportableTree;
    }

    public String byteBufToString(int offset, int length, char codepage) {
        byte[] ba = new byte[length];
        String sValue = null;
        int j = 0;
        while (j < length) {
            ba[j] = this.bbRespBuffer.get(offset + j);
            ++j;
        }
        try {
            sValue = codepage == 'E' ? new String(ba, CorePlugin.getDefault().getPreferenceStore().getString("codePage")) : new String(ba);
        }
        catch (Exception e) {
            String logstr = "byteBufToString: offset: " + offset + ", length: " + length + ", codepage: " + codepage + " : Exception " + e;
            System.out.println("byteBufToString - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        return sValue;
    }
}

