/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.dialogs;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.data.DatasetList;
import com.banknet.core.dialogs.Messages;
import com.banknet.core.internal.ColumnSorter;
import com.banknet.core.internal.Constants;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class DatasetListDialog
extends TrayDialog {
    Constants constants = new Constants();
    ZosConnect zosconnect = new ZosConnect();
    DatasetList datasetList = new DatasetList();
    Shell shell;
    private Label searchDsnLabel;
    private Label dsnListSizeLabel;
    private Text searchDsnText;
    private Button getDatasetListButton;
    private Group datasetListGroup;
    private Table datasetListTable;
    public TableViewer datasetListViewer;
    private ColumnSorter datasetNameSorter;
    Composite content;
    Composite content1;
    public static final int ASC = 1;
    String errmsg = "";
    public String searchDsn = "";
    public String selectedDsn = "";
    Image image0;
    private Integer fontSize;
    private long fontDataHeight;
    int shellw = 725;
    int shellh = 675;
    int shellx = 125;
    int shelly = 50;
    int checkedcolw = 23;
    int datasetnamecolw = 250;
    int datasetnamew = 250;
    int datasetListrows = 10;
    double datasetListTableh = 1.0;

    public DatasetListDialog(Shell parentShell) {
        super(parentShell);
        this.shell = parentShell;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("DatasetListDialog.ShellTitle"));
        newShell.setImage(CorePlugin.getDefault().productextension.getDialogShellImage());
    }

    protected Control createDialogArea(Composite parent) {
        this.content1 = new Composite(parent, 0);
        GridLayout layout1 = new GridLayout(1, false);
        this.content1.setLayout((Layout)layout1);
        GridData gd3 = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        this.content1.setLayoutData((Object)gd3);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.content1, String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".dialogs_DatasetListContext");
        Composite importContent = new Composite(this.content1, 0);
        GridLayout layout = new GridLayout(1, false);
        importContent.setLayout((Layout)layout);
        gd3 = new GridData(4, 128, false, false);
        gd3.widthHint = 450;
        importContent.setLayoutData((Object)gd3);
        Label instructionsLabel1 = new Label(importContent, 64);
        instructionsLabel1.setText(Messages.getString("DatasetListDialog.Label.Instructions"));
        GridData gd = new GridData(4, 0x1000000, true, false, 1, 1);
        gd.horizontalIndent = 5;
        instructionsLabel1.setLayoutData((Object)gd);
        this.content = new Composite(this.content1, 4);
        GridLayout layout2 = new GridLayout(3, false);
        this.content.setLayout((Layout)layout2);
        gd3 = new GridData(1, 128, false, true, 1, 1);
        this.content.setLayoutData((Object)gd3);
        this.searchDsnLabel = new Label(this.content, 0);
        this.searchDsnLabel.setText(Messages.getString("DatasetListDialog.Label.Text.DatasetName"));
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        gd.horizontalIndent = 5;
        this.searchDsnLabel.setLayoutData((Object)gd);
        this.searchDsnText = new Text(this.content, 2048);
        this.searchDsnText.setText(this.searchDsn);
        this.searchDsnText.setTextLimit(44);
        gd = new GridData(4, 0x1000000, true, false, 1, 1);
        gd.widthHint = this.datasetnamew;
        this.searchDsnText.setLayoutData((Object)gd);
        this.searchDsnText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DatasetListDialog.this.searchDsnText.setText(DatasetListDialog.this.searchDsnText.getText().trim().toUpperCase());
            }
        });
        this.getDatasetListButton = new Button(this.content, 8);
        this.getDatasetListButton.setText(Messages.getString("DatasetListDialog.Button.Text.GetDatasetList"));
        gd = new GridData(1, 128, true, false, 1, 1);
        gd.minimumWidth = 75;
        this.getDatasetListButton.setLayoutData((Object)gd);
        this.getDatasetListButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatasetListDialog.this.searchDsn = DatasetListDialog.this.searchDsnText.getText();
                boolean isComplete = DatasetListDialog.this.chkComplete();
                if (isComplete) {
                    DatasetListDialog.this.runGetDatasetListJob();
                }
            }
        });
        this.datasetListGroup = new Group(this.content1, 0);
        this.datasetListGroup.setText(Messages.getString("DatasetListDialog.GroupLabel.DatasetList"));
        gd = new GridData(4, 128, true, false, 4, 1);
        this.datasetListGroup.setLayoutData((Object)gd);
        this.datasetListGroup.setLayout((Layout)new GridLayout(1, false));
        this.dsnListSizeLabel = new Label((Composite)this.datasetListGroup, 0);
        this.dsnListSizeLabel.setText("");
        gd = new GridData(4, 0x1000000, true, false, 1, 1);
        this.dsnListSizeLabel.setLayoutData((Object)gd);
        this.datasetListTable = new Table((Composite)this.datasetListGroup, 68384);
        this.datasetListTable.setHeaderVisible(true);
        this.datasetListViewer = new TableViewer(this.datasetListTable);
        TableColumn column = new TableColumn(this.datasetListTable, 0);
        column.setText("");
        column.setWidth(this.checkedcolw);
        column = new TableColumn(this.datasetListTable, 0);
        column.setText(Messages.getString("DatasetListDialog.DatasetsColumn.DatasetName"));
        column.setToolTipText(Messages.getString("DatasetListDialog.DatasetsColumn.DatasetName"));
        column.setWidth(this.datasetnamecolw);
        this.datasetListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                try {
                    Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (obj != null) {
                        String xx = (String)obj;
                        TableItem[] items = DatasetListDialog.this.datasetListTable.getItems();
                        int i = 0;
                        while (i < items.length) {
                            if (((String)items[i].getData()).equals(xx)) {
                                items[i].setChecked(true);
                                return;
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception exception) {}
            }
        });
        this.datasetListTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem tabitem = (TableItem)e.item;
                TableItem[] items = DatasetListDialog.this.datasetListTable.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].setChecked(false);
                    ++i;
                }
                tabitem.setChecked(true);
                DatasetListDialog.this.selectedDsn = (String)tabitem.getData();
            }
        });
        this.datasetListViewer.setUseHashlookup(true);
        GridData gd4 = new GridData(4, 4, true, false, 4, 1);
        this.datasetListTable.setLayoutData((Object)gd4);
        int listHeight = this.datasetListTable.getItemHeight() * this.datasetListrows;
        Rectangle trim2 = this.datasetListTable.computeTrim(0, 0, 0, listHeight);
        gd4 = (GridData)this.datasetListTable.getLayoutData();
        double tmph = (double)trim2.height / this.datasetListTableh;
        gd4.heightHint = (int)tmph;
        if (this.searchDsn.length() > 0) {
            this.runGetDatasetListJob();
        }
        this.datasetListTable.setLayoutData((Object)gd4);
        this.datasetListGroup.layout(false);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        GridData gd = new GridData(4, 0, true, false, 1, 1);
        client.setLayoutData((Object)gd);
        client.setLayout((Layout)layout);
        Composite tbclient = new Composite(client, 0);
        layout = new GridLayout(1, false);
        gd = new GridData(4, 0, true, false, 1, 1);
        tbclient.setLayoutData((Object)gd);
        tbclient.setLayout((Layout)layout);
        ToolBar toolBar = new ToolBar(tbclient, 0x880000);
        ++((GridLayout)parent.getLayout()).numColumns;
        GridData gd2 = new GridData(1, 0, true, false, 1, 1);
        toolBar.setLayoutData((Object)gd2);
        final Cursor cursor = new Cursor((Device)parent.getDisplay(), 21);
        toolBar.setCursor(cursor);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                cursor.dispose();
            }
        });
        Composite buttonclient = new Composite(client, 0);
        layout = new GridLayout(2, false);
        gd = new GridData(131072, 0, true, false, 1, 1);
        buttonclient.setLayoutData((Object)gd);
        buttonclient.setLayout((Layout)layout);
        this.createButton(buttonclient, 0, Messages.getString("ImportObservationDialog.Button.Text.Ok"), false);
        this.createButton(buttonclient, 1, Messages.getString("ImportObservationDialog.Button.Text.Cancel"), false);
    }

    public void okPressed() {
        this.setReturnCode(0);
        this.close();
    }

    public void cancelPressed() {
        this.setReturnCode(1);
        this.close();
    }

    public boolean chkComplete() {
        boolean isComplete = true;
        this.errmsg = "";
        this.chkSearchDsn();
        if (this.errmsg.length() > 0) {
            isComplete = false;
            this.showMessage("error", Messages.getString("DatasetListDialog.ShellTitle"), this.errmsg);
        }
        return isComplete;
    }

    private boolean chkSearchDsn() {
        boolean isValid = true;
        this.searchDsn = this.searchDsn.toUpperCase();
        this.errmsg = this.chkMandatory(this.searchDsn, Messages.getString("DatasetListDialog.Label.Text.DatasetName"));
        if (this.errmsg.length() > 0) {
            return false;
        }
        if (this.searchDsn.equals("*") || this.searchDsn.indexOf("*") == 0) {
            this.errmsg = Messages.getString("DatasetListDialog.chkDsn.InvalidSearch");
            return false;
        }
        if (this.searchDsn.indexOf("\"") >= 0) {
            this.errmsg = Messages.getString("DatasetListDialog.chkDsn.InvalidDsn");
            return false;
        }
        if (this.searchDsn.endsWith(".") || this.searchDsn.indexOf("..") > 0) {
            this.errmsg = Messages.getString("DatasetListDialog.chkDsn.InvalidDsn");
            return false;
        }
        this.searchDsn = this.searchDsn.replace("'", "").trim();
        String wrkdsn = this.searchDsn.replace("*", "");
        StringTokenizer st = new StringTokenizer(wrkdsn, ".");
        String libext = "";
        while (st.hasMoreTokens()) {
            libext = st.nextToken();
            if (libext.length() > 8) {
                this.errmsg = Messages.getString("DatasetListDialog.chkDsn.InvalidDsn");
                return false;
            }
            this.errmsg = this.chkIbmName(libext, Messages.getString("DatasetListDialog.Label.Text.DatasetName"));
            if (this.errmsg.length() <= 0) continue;
            this.errmsg = Messages.getString("DatasetListDialog.chkDsn.InvalidDsn");
            return false;
        }
        if (this.errmsg.length() > 0) {
            isValid = false;
        }
        return isValid;
    }

    private String chkIbmName(String val, String varname) {
        String errmsg = "";
        char[] chars = val.toCharArray();
        int x = 0;
        while (x < chars.length) {
            char c = chars[x];
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                if (c >= '0' && c <= '9') {
                    if (x <= 0) {
                        errmsg = String.valueOf(Messages.getString("DatasetListDialog.chkIbmName.Invalid")) + varname;
                        return errmsg;
                    }
                } else if (c != '$' && c != '#' && c != '@' && c != '%') {
                    errmsg = String.valueOf(Messages.getString("DatasetListDialog.chkIbmName.Invalid")) + varname;
                    return errmsg;
                }
            }
            ++x;
        }
        return errmsg;
    }

    private String chkMandatory(String val, String varname) {
        if (val.length() <= 0) {
            this.errmsg = String.valueOf(Messages.getString("DatasetListDialog.errorMessage.Mandatory")) + varname;
        }
        return this.errmsg;
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
        }
    }

    public int getShellStyle() {
        return 3312;
    }

    public void runGetDatasetListJob() {
        Job job0 = new Job(Messages.getString("DatasetListDialog.Job.Title.SearchDsn")){

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString("DatasetListDialog.Job.Task.Dsn"), 100);
                if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("local") == 0) {
                    return Status.CANCEL_STATUS;
                }
                monitor.subTask(Messages.getString("DatasetListDialog.Job.SubTask.Ping"));
                DatasetListDialog.this.zosconnect.pingZos(monitor);
                if (DatasetListDialog.this.zosconnect.getConnectRc() != 0) {
                    return Status.CANCEL_STATUS;
                }
                monitor.subTask(Messages.getString("DatasetListDialog.Job.SubTask.SearchDsn"));
                try {
                    DatasetListDialog.this.datasetList.getDatasetList(monitor, DatasetListDialog.this.searchDsn);
                }
                catch (Exception ex) {
                    String logstr = "runGetDatasetList Exception: " + ex;
                    System.out.println("DatasetListDialog - " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(100);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job0.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("Get Dataset List job completed successfully");
                } else {
                    System.out.println("Get Dataset List job did not complete successfully");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("Get Dataset List rc is " + (this).DatasetListDialog.this.zosconnect.getConnectRc());
                        if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("local") == 0 | (this).DatasetListDialog.this.zosconnect.getConnectRc() != 0) {
                            DatasetListDialog.this.showMessage("info", Messages.getString("DatasetListDialog.MessageDiaCorePlugin.getDefault().log.infoTitle.SearchDsn"), String.valueOf(Messages.getString("DatasetListDialog.MessageDiaCorePlugin.getDefault().log.infoMessage.RemoteConnectionLost")) + Messages.getString("DatasetListDialog.MessageDiaCorePlugin.getDefault().log.infoMessage.ReConnect"));
                            (this).DatasetListDialog.this.zosconnect.setConnectLocal();
                        } else if (CorePlugin.getDefault().session.getReturnCode() == 0) {
                            DatasetListDialog.this.loadDatasetList();
                        } else {
                            String msgstr = CorePlugin.getDefault().session.getReason();
                            DatasetListDialog.this.showMessage("error", Messages.getString("DatasetListDialog.MessageDiaCorePlugin.getDefault().log.infoTitle.SearchDsn"), msgstr);
                        }
                    }
                });
            }
        });
        job0.schedule();
    }

    private void loadDatasetList() {
        this.dsnListSizeLabel.setText(String.valueOf(this.datasetList.dsnList.size()) + Messages.getString("DatasetListDialog.Label.Text.DsnListSize"));
        this.datasetListTable.setRedraw(false);
        this.datasetListTable.removeAll();
        int i = 0;
        while (i < this.datasetList.dsnList.size()) {
            TableItem datasetListTableItem = new TableItem(this.datasetListTable, 0);
            datasetListTableItem.setText(1, this.datasetList.dsnList.get(i));
            datasetListTableItem.setData((Object)this.datasetList.dsnList.get(i));
            ++i;
        }
        this.datasetListTable.setRedraw(true);
        i = 1;
        while (i < this.datasetListTable.getColumnCount()) {
            this.datasetListTable.getColumn(i).pack();
            ++i;
        }
        this.datasetListGroup.layout(false);
        this.content1.layout(false);
    }

    private String getHtmlUrl(String fname) {
        String htmlUrl = "";
        try {
            HashMap<String, String> map = new HashMap<String, String>(1);
            map.put("$nl$", Platform.getNL());
            Path path = new Path("$nl$/html/" + fname);
            URL locationUrl = FileLocator.find((Bundle)CorePlugin.getDefault().getBundle(), (IPath)path, map);
            URL fileUrl = FileLocator.toFileURL((URL)locationUrl);
            File in = new File(fileUrl.getFile());
            htmlUrl = in.getAbsolutePath();
        }
        catch (Exception ex) {
            String logstr = "getHtmlUrl: Error accessing file " + fname + ", Exception - " + ex;
            System.out.println("DatasetListDialog - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        return htmlUrl;
    }
}

