/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.data.reports;

import com.banknet.core.CorePlugin;
import com.banknet.core.data.reports.Messages;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.ZosSession;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.eclipse.core.runtime.IProgressMonitor;

public class ReportXmlParser {
    public ByteBuffer bbRespBuffer;
    public String xmlfname = "";
    Constants constants = new Constants();
    String sXML;
    Writer outXML = null;
    int SectBlkDSPO = 0;
    int blobOffset = 0;
    long recordOffset = 0L;
    Long lRecordOffset = null;
    boolean section1 = true;

    public void parseReports(IProgressMonitor monitor) throws OutOfMemoryError {
        ZosSession cfr_ignored_0 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_1 = CorePlugin.getDefault().session;
        int offset = ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset;
        int headerOffset = offset + 16 + 4;
        int NumSectBlk = this.bbRespBuffer.getInt(offset + 8);
        int SectBlkLen = this.bbRespBuffer.getInt(offset + 12);
        this.SectBlkDSPO = this.bbRespBuffer.getInt(offset + 16);
        int blobStart = NumSectBlk * SectBlkLen + headerOffset;
        int sectBlkOffset = 0;
        int sbkFirstLine = 0;
        int sbkLastLine = 0;
        int monincr = 10;
        int pctincr = Math.abs(NumSectBlk / monincr);
        int moncnt = 0;
        File reportFile = new File(this.xmlfname);
        try {
            this.outXML = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(reportFile), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {}
        NumSectBlk = 1;
        int i = 1;
        while (i <= NumSectBlk) {
            sbkFirstLine = this.bbRespBuffer.getInt(headerOffset + sectBlkOffset);
            sbkLastLine = this.bbRespBuffer.getInt(headerOffset + sectBlkOffset + 4);
            String rawData = this.byteBufToString(headerOffset + sectBlkOffset + 8, 100, 'E');
            String reportName = rawData.substring(0, 3);
            String reportTitle = rawData.substring(0, 100).trim();
            String logstr = "Parse XML :  " + rawData.trim() + " ... " + sbkFirstLine + " - " + sbkLastLine;
            System.out.println("ReportXmlParser - " + logstr);
            CorePlugin.getDefault().log.debug(logstr);
            monitor.subTask(String.valueOf(Messages.getString("ObservationReports.Job.Monitor.Step3of3")) + i + Messages.getString("ObservationReports.Job.Monitor.Step3of3Of") + NumSectBlk + " " + reportTitle);
            monitor.worked(0);
            if (sbkFirstLine > 0) {
                this.getReport(reportName, blobStart, sbkFirstLine);
                System.gc();
            }
            this.section1 = true;
            sectBlkOffset += SectBlkLen;
            if (++moncnt >= pctincr) {
                monitor.worked(5);
                moncnt = 0;
            }
            ++i;
        }
        try {
            this.outXML.flush();
            this.outXML.close();
        }
        catch (Exception exception) {}
    }

    private String byteBufToString(int offset, int length, char codepage) {
        byte[] ba = new byte[length];
        ByteBuffer miniBuffer = ByteBuffer.wrap(ba);
        String sValue = new String();
        int j = 0;
        while (j < length) {
            ba[j] = this.bbRespBuffer.get(offset + j);
            ++j;
        }
        Charset charset = Charset.forName(CorePlugin.getDefault().getPreferenceStore().getString("codePage"));
        CharsetDecoder decoder = charset.newDecoder();
        CharBuffer cbuf = null;
        try {
            cbuf = decoder.decode(miniBuffer);
            sValue = cbuf.toString();
        }
        catch (Exception e) {
            System.out.println("codepage error: " + e);
        }
        return sValue;
    }

    private void getReport(String reportId, int blobStart, int sbkFirstLine) {
        int reportStart = blobStart + sbkFirstLine;
        int pgTxtHeader = 12;
        int dataStart = reportStart + pgTxtHeader;
        short lineLength = this.bbRespBuffer.getShort(reportStart + 10);
        this.sXML = this.byteBufToString(dataStart, lineLength, 'E');
        int pgt_next = this.bbRespBuffer.getInt(reportStart + 4);
        byte pgt_flags1 = this.bbRespBuffer.get(reportStart + 8);
        boolean invisble = this.processPGT_Flags1(pgt_flags1);
        if (this.sXML.length() > 0 && !invisble) {
            try {
                this.sXML = this.sXML.replace("ebcdic-cp-us", "UTF-8");
                this.outXML.write(String.valueOf(this.sXML) + "\r\n");
                this.outXML.flush();
            }
            catch (Exception exception) {}
        }
        lineLength = this.bbRespBuffer.getShort(blobStart + pgt_next + 10);
        while (pgt_next > 0) {
            this.sXML = this.byteBufToString(blobStart + pgt_next + 12, lineLength, 'E');
            try {
                if (!invisble) {
                    this.outXML.write(String.valueOf(this.sXML) + "\r\n");
                    this.outXML.flush();
                }
            }
            catch (Exception exception) {}
            pgt_next = this.bbRespBuffer.getInt(blobStart + pgt_next + 4);
            pgt_flags1 = this.bbRespBuffer.get(blobStart + pgt_next + 8);
            invisble = this.processPGT_Flags1(pgt_flags1);
            lineLength = this.bbRespBuffer.getShort(blobStart + pgt_next + 10);
        }
    }

    private Boolean processPGT_Flags1(byte pgt_byte1) {
        boolean return_result = false;
        int result = 0x40 & pgt_byte1;
        if (result == 64) {
            return_result = true;
        }
        return return_result;
    }
}

