/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.data.reports;

import com.banknet.core.CorePlugin;
import com.banknet.core.data.reports.Messages;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.ZosSession;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.eclipse.core.runtime.IProgressMonitor;

public class ReportSqlParser {
    public ByteBuffer bbRespBuffer;
    public String sqlfname = "";
    Constants constants = new Constants();
    String targetSystem = "";
    String db2Id = "";
    String db2Version = "";
    String stringDelim = "";
    String dynamicRules = "";
    String planName = "";
    String sConToken = "";
    String stmtNum = "";
    String sectNum = "";
    String dbrmName = "";
    String collIdText = "";
    String qualText = "";
    String pathText = "";
    String sqlText = "";
    String explainSql = "";
    boolean db2V8Compat = false;
    boolean stmtInPkg = false;
    boolean sqlTextOutput = false;
    boolean stmtOpenFetchClose = false;
    boolean storedProcSql = false;
    boolean dynamicSql = false;

    public void parseReports(IProgressMonitor monitor) throws OutOfMemoryError {
        String sqlstr = "";
        File sqlFile = new File(this.sqlfname);
        BufferedWriter outSQL = null;
        try {
            outSQL = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(sqlFile), "UTF-8"));
            ZosSession cfr_ignored_0 = CorePlugin.getDefault().session;
            int offset2Header = ZosSession.tcpipHeaderOffset;
            int offset2Data = 65;
            this.bbRespBuffer.getShort(offset2Header + 10);
            this.targetSystem = this.byteBufToString(offset2Data + 17, 8, 'E').trim();
            sqlstr = "<TARGET_SYSTEM>" + this.targetSystem + "</TARGET_SYSTEM>";
            outSQL.write(String.valueOf(sqlstr) + "\r\n");
            ((Writer)outSQL).flush();
            this.db2Id = this.byteBufToString(offset2Data + 25, 4, 'E').trim();
            sqlstr = "<DB2_SUBSYSTEM>" + this.db2Id + "</DB2_SUBSYSTEM>";
            outSQL.write(String.valueOf(sqlstr) + "\r\n");
            ((Writer)outSQL).flush();
            this.db2Version = this.byteBufToString(offset2Data + 29, 3, 'E').trim();
            sqlstr = "<DB2_VERSION>" + this.db2Version + "</DB2_VERSION>";
            outSQL.write(String.valueOf(sqlstr) + "\r\n");
            ((Writer)outSQL).flush();
            int dynamicSQL = 128;
            int storeProc = 64;
            int stmtTypeOFC = 32;
            int sqlTextoutput = 16;
            int DB2V8Compat = 2;
            byte stmtInPackage = 1;
            byte[] sqlOutFlags = new byte[]{this.bbRespBuffer.get(offset2Data + 32)};
            int result = stmtInPackage & sqlOutFlags[0];
            if (result == 1) {
                this.stmtInPkg = true;
            }
            if ((result = DB2V8Compat & sqlOutFlags[0]) == 2) {
                this.db2V8Compat = true;
            }
            if ((result = sqlTextoutput & sqlOutFlags[0]) == 16) {
                this.sqlTextOutput = true;
            }
            if ((result = stmtTypeOFC & sqlOutFlags[0]) == 32) {
                this.stmtOpenFetchClose = true;
            }
            if ((result = storeProc & sqlOutFlags[0]) == 64) {
                this.storedProcSql = true;
            }
            if ((result = dynamicSQL & sqlOutFlags[0]) == 128) {
                this.dynamicSql = true;
            }
            sqlstr = "<STMT_IN_PKG>" + this.stmtInPkg + "</STMT_IN_PKG>";
            outSQL.write(String.valueOf(sqlstr) + "\r\n");
            ((Writer)outSQL).flush();
            sqlstr = "<DB2_V8_COMPAT>" + this.db2V8Compat + "</DB2_V8_COMPAT>";
            outSQL.write(String.valueOf(sqlstr) + "\r\n");
            ((Writer)outSQL).flush();
            sqlstr = "<SQL_TEXT_OUTPUT>" + this.sqlTextOutput + "</SQL_TEXT_OUTPUT>";
            outSQL.write(String.valueOf(sqlstr) + "\r\n");
            ((Writer)outSQL).flush();
            sqlstr = "<STMT_OFC>" + this.stmtOpenFetchClose + "</STMT_OFC>";
            outSQL.write(String.valueOf(sqlstr) + "\r\n");
            ((Writer)outSQL).flush();
            sqlstr = "<STORED_PROC_SQL>" + this.storedProcSql + "</STORED_PROC_SQL>";
            outSQL.write(String.valueOf(sqlstr) + "\r\n");
            ((Writer)outSQL).flush();
            sqlstr = "<DYNAMIC_SQL>" + this.dynamicSql + "</DYNAMIC_SQL>";
            outSQL.write(String.valueOf(sqlstr) + "\r\n");
            ((Writer)outSQL).flush();
            this.stringDelim = Messages.getString("ReportSqlParser.StringDelimiter.Apos");
            String quote = this.byteBufToString(offset2Data + 33, 1, 'E');
            if (quote.equalsIgnoreCase("Y")) {
                this.stringDelim = Messages.getString("ReportSqlParser.StringDelimiter.Quote");
            }
            sqlstr = "<STRING_DELIM>" + this.stringDelim + "</STRING_DELIM>";
            outSQL.write(String.valueOf(sqlstr) + "\r\n");
            ((Writer)outSQL).flush();
            String workDynamicRules = this.byteBufToString(offset2Data + 34, 1, 'E').toUpperCase();
            this.dynamicRules = null;
            char dynamicRulesIndicator = workDynamicRules.charAt(0);
            switch (dynamicRulesIndicator) {
                case ' ': {
                    this.dynamicRules = Messages.getString("ReportSqlParser.DynamicRules.Default");
                    break;
                }
                case 'B': {
                    this.dynamicRules = Messages.getString("ReportSqlParser.DynamicRules.Bind");
                    break;
                }
                case 'D': {
                    this.dynamicRules = Messages.getString("ReportSqlParser.DynamicRules.DefineBind");
                    break;
                }
                case 'E': {
                    this.dynamicRules = Messages.getString("ReportSqlParser.DynamicRules.DefineRun");
                    break;
                }
                case 'H': {
                    this.dynamicRules = Messages.getString("ReportSqlParser.DynamicRules.InvokeBind");
                    break;
                }
                case 'I': {
                    this.dynamicRules = Messages.getString("ReportSqlParser.DynamicRules.InvokeRun");
                    break;
                }
                default: {
                    this.dynamicRules = "";
                }
            }
            sqlstr = "<DYNAMIC_RULES>" + this.dynamicRules + "</DYNAMIC_RULES>";
            outSQL.write(String.valueOf(sqlstr) + "\r\n");
            ((Writer)outSQL).flush();
            this.planName = this.byteBufToString(offset2Data + 36, 24, 'E').trim();
            sqlstr = "<PLAN_NAME>" + this.planName + "</PLAN_NAME>";
            outSQL.write(String.valueOf(sqlstr) + "\r\n");
            ((Writer)outSQL).flush();
            byte[] conToken = new byte[8];
            int i = 0;
            while (i < conToken.length) {
                conToken[i] = this.bbRespBuffer.get(offset2Data + 60 + i);
                ++i;
            }
            StringBuffer sbConToken = new StringBuffer(conToken.length * 2);
            int i2 = 0;
            while (i2 < conToken.length) {
                int v = conToken[i2] & 0xFF;
                if (v < 16) {
                    sbConToken.append('0');
                }
                sbConToken.append(Integer.toHexString(v));
                ++i2;
            }
            sbConToken.insert(8, ' ');
            this.sConToken = sbConToken.toString().toUpperCase().trim();
            sqlstr = "<CONSISTENCY_TOKEN>" + this.sConToken + "</CONSISTENCY_TOKEN>";
            outSQL.write(String.valueOf(sqlstr) + "\r\n");
            ((Writer)outSQL).flush();
            int iStmtNum = 0;
            iStmtNum = this.bbRespBuffer.getInt(offset2Data + 68);
            this.stmtNum = this.constants.decfmt4.format(iStmtNum);
            sqlstr = "<STATEMENT_NUMBER>" + this.stmtNum + "</STATEMENT_NUMBER>";
            outSQL.write(String.valueOf(sqlstr) + "\r\n");
            ((Writer)outSQL).flush();
            short iSectNum = 0;
            iSectNum = this.bbRespBuffer.getShort(offset2Data + 72);
            this.sectNum = this.constants.decfmt4.format(iSectNum);
            sqlstr = "<SECTION_NUMBER>" + this.sectNum + "</SECTION_NUMBER>";
            outSQL.write(String.valueOf(sqlstr) + "\r\n");
            ((Writer)outSQL).flush();
            int dbrmOffset = this.bbRespBuffer.getInt(offset2Data + 108);
            if (dbrmOffset > 0) {
                int dbrmLength = this.bbRespBuffer.getInt(offset2Data + dbrmOffset);
                this.dbrmName = this.byteBufToString(offset2Data + dbrmOffset + 4, dbrmLength, 'E').trim();
            }
            sqlstr = "<DBRM>" + this.dbrmName + "</DBRM>";
            outSQL.write(String.valueOf(sqlstr) + "\r\n");
            ((Writer)outSQL).flush();
            int collIdOffset = this.bbRespBuffer.getInt(offset2Data + 112);
            if (collIdOffset > 0) {
                int collIdLength = this.bbRespBuffer.getInt(offset2Data + collIdOffset);
                this.collIdText = this.byteBufToString(offset2Data + collIdOffset + 4, collIdLength, 'E').trim();
            }
            sqlstr = "<COLLID>" + this.collIdText + "</COLLID>";
            outSQL.write(String.valueOf(sqlstr) + "\r\n");
            ((Writer)outSQL).flush();
            int qualOffset = this.bbRespBuffer.getInt(offset2Data + 116);
            if (qualOffset > 0) {
                int qualLength = this.bbRespBuffer.getInt(offset2Data + qualOffset);
                this.qualText = this.byteBufToString(offset2Data + qualOffset + 4, qualLength, 'E').trim();
            }
            sqlstr = "<QUALIFIER>" + this.qualText + "</QUALIFIER>";
            outSQL.write(String.valueOf(sqlstr) + "\r\n");
            ((Writer)outSQL).flush();
            int pathOffset = this.bbRespBuffer.getInt(offset2Data + 120);
            if (pathOffset > 0) {
                int pathLength = this.bbRespBuffer.getInt(offset2Data + pathOffset);
                this.pathText = this.byteBufToString(offset2Data + pathOffset + 4, pathLength, 'E').trim();
            }
            sqlstr = "<PATH>" + this.pathText + "</PATH>";
            outSQL.write(String.valueOf(sqlstr) + "\r\n");
            ((Writer)outSQL).flush();
            int sqlTextOffset = this.bbRespBuffer.getInt(offset2Data + 124);
            if (sqlTextOffset > 0) {
                int sqlTextLength = this.bbRespBuffer.getInt(offset2Data + sqlTextOffset);
                this.sqlText = this.byteBufToString(offset2Data + sqlTextOffset + 4, sqlTextLength, 'E').trim();
            }
            sqlstr = "<SQLTEXT>" + this.sqlText + "</SQLTEXT>";
            outSQL.write(String.valueOf(sqlstr) + "\r\n");
            ((Writer)outSQL).flush();
            ((Writer)outSQL).close();
        }
        catch (IOException iOException) {}
    }

    private String byteBufToString(int offset, int length, char codepage) {
        byte[] ba = new byte[length];
        ByteBuffer miniBuffer = ByteBuffer.wrap(ba);
        String sValue = new String();
        int j = 0;
        while (j < length) {
            ba[j] = this.bbRespBuffer.get(offset + j);
            ++j;
        }
        Charset charset = Charset.forName(CorePlugin.getDefault().getPreferenceStore().getString("codePage"));
        CharsetDecoder decoder = charset.newDecoder();
        CharBuffer cbuf = null;
        try {
            cbuf = decoder.decode(miniBuffer);
            sValue = cbuf.toString();
        }
        catch (Exception e) {
            System.out.println("codepage error: " + e);
        }
        return sValue;
    }

    private String formatSql(String sqlText) {
        String sqlstr = sqlText.toLowerCase();
        return sqlstr;
    }

    private void prepExplain(String sqlString) {
        String[] sqlWord = sqlString.split("\\s+");
        boolean declareCursor = false;
        int declarePosition = -1;
        int forPosition = -1;
        int i = 0;
        while (i < sqlWord.length - 1) {
            if (sqlWord[i].equalsIgnoreCase("DECLARE")) {
                declarePosition = i;
            }
            ++i;
        }
        if (declarePosition >= 0) {
            i = 0;
            while (i < sqlWord.length - 1) {
                if (sqlWord[i].equalsIgnoreCase("FOR") && i > declarePosition) {
                    declareCursor = true;
                }
                ++i;
            }
        }
        if (declareCursor) {
            i = 0;
            while (i < sqlWord.length - 1) {
                if (sqlWord[i].equalsIgnoreCase("FOR")) {
                    forPosition = i;
                }
                ++i;
            }
            i = declarePosition;
            while (i <= forPosition) {
                sqlWord[i] = "";
                ++i;
            }
        }
        boolean selectInto = false;
        int selectPosition = -1;
        int intoPosition = -1;
        int fromPosition = -1;
        int i2 = 0;
        while (i2 < sqlWord.length - 1) {
            if (sqlWord[i2].equalsIgnoreCase("SELECT")) {
                selectPosition = i2;
            }
            ++i2;
        }
        if (selectPosition >= 0) {
            i2 = 0;
            while (i2 < sqlWord.length - 1) {
                if (sqlWord[i2].equalsIgnoreCase("INTO") && i2 > selectPosition) {
                    selectInto = true;
                    intoPosition = i2;
                }
                ++i2;
            }
        }
        if (selectInto) {
            i2 = 0;
            while (i2 < sqlWord.length - 1) {
                if (sqlWord[i2].equalsIgnoreCase("FROM")) {
                    fromPosition = i2;
                }
                ++i2;
            }
            i2 = intoPosition;
            while (i2 <= fromPosition - 1) {
                sqlWord[i2] = "";
                ++i2;
            }
        }
        boolean isNumeric = false;
        int i3 = 0;
        while (i3 < sqlWord.length - 1) {
            if (sqlWord[i3].equalsIgnoreCase("QUERYNO")) {
                try {
                    Integer.parseInt(sqlWord[i3 + 1]);
                    isNumeric = true;
                }
                catch (Exception exception) {
                    isNumeric = false;
                }
                if (isNumeric) {
                    sqlWord[i3] = "";
                    sqlWord[i3 + 1] = "";
                }
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < sqlWord.length - 1) {
            if (sqlWord[i3].equalsIgnoreCase(":H") || sqlWord[i3].equalsIgnoreCase(":H:H")) {
                sqlWord[i3] = "?";
            }
            if (sqlWord[i3].equalsIgnoreCase(":") || sqlWord[i3 + 1].equalsIgnoreCase("H")) {
                sqlWord[i3] = "?";
                sqlWord[i3 + 1] = "";
            }
            ++i3;
        }
        StringBuffer explainStatement = new StringBuffer();
        int i4 = 0;
        while (i4 < sqlWord.length) {
            if (sqlWord[i4].length() > 0) {
                explainStatement = explainStatement.append(String.valueOf(sqlWord[i4]) + " ");
            }
            ++i4;
        }
        this.explainSql = explainStatement.toString();
    }
}

