/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.data.reports;

import com.banknet.core.CorePlugin;
import com.banknet.core.data.reports.Messages;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.ZosSession;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;

public class ReportPvmlParser {
    Constants constants = new Constants();
    public int reqnum = 0;
    public ByteBuffer bbRespBuffer;
    public String spmrptid = "";
    public boolean spmReport = false;
    public boolean detailReport = false;
    Writer outPVML = null;
    Writer outPVML0 = null;
    String internationalCodePage = "";
    String doubleByteCodePage = "false";
    boolean db2Report = false;
    char rightArrow = (char)8594;
    char[][] graphicChars = new char[][]{{' ', ' '}, {'E', '\u250c'}, {'N', '\u2510'}, {'D', '\u2514'}, {'M', '\u2518'}, {'\u00d7', '\u2502'}, {'s', '\u2500'}, {'F', '\u251c'}, {'P', '\u252c'}, {'O', '\u2524'}, {'G', '\u2534'}, {'L', '\u253c'}, {'l', '\u2580'}, {'m', '\u2584'}, {'j', '\u258c'}, {'\u00b1', this.rightArrow}};
    char dbcsHline = (char)45;
    private static final char PLUSMINUS = '\u00b1';
    private static final char INPLUSMINUS = '\u00f1';
    private static final char BADCHAR = '\u00ac';
    private static final char LOWVALUES = '\u0000';
    private String sPVML = new String();
    private String sStylingString = new String();
    private String sStylingStringPrint = new String();
    boolean pvmlHeader = false;
    String iTag = "";
    boolean section1 = true;
    int SectBlkDSPO = 0;
    int blobOffset = 0;
    String saveActiveLink = "";
    String prevActiveLink = "";
    String outString = "";
    String outStringPrint = "";
    String pi = "1";
    String prevPI = "1";
    int printBlobOffset = 0;
    boolean blankLine = false;
    long recordOffset = 0L;
    Long lRecordOffset = null;
    boolean sTagOn = false;
    boolean firstTime = true;

    public ReportPvmlParser() {
        this.internationalCodePage = Messages.getString("ObservationReports.CodePage");
        this.doubleByteCodePage = Messages.getString("ObservationReports.DoubleByte");
        if (this.doubleByteCodePage.equalsIgnoreCase("true")) {
            this.rightArrow = (char)9658;
            int i = 0;
            while (i < this.graphicChars.length) {
                if (this.graphicChars[i][0] == '\u00b1') {
                    this.graphicChars[i][1] = this.rightArrow;
                }
                ++i;
            }
        }
    }

    public void parseReports(IProgressMonitor monitor) throws OutOfMemoryError {
        ZosSession cfr_ignored_0 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_1 = CorePlugin.getDefault().session;
        int offset = ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset;
        int headerOffset = offset + 16 + 4;
        int NumSectBlk = this.bbRespBuffer.getInt(offset + 8);
        int SectBlkLen = this.bbRespBuffer.getInt(offset + 12);
        this.SectBlkDSPO = this.bbRespBuffer.getInt(offset + 16);
        int blobStart = NumSectBlk * SectBlkLen + headerOffset;
        int sectBlkOffset = 0;
        int sbkFirstLine = 0;
        int sbkLastLine = 0;
        int monincr = 10;
        Math.abs(NumSectBlk / monincr);
        int moncnt = 0;
        int firstDigitComplete = 0;
        if (NumSectBlk < 1) {
            CorePlugin.getDefault().session.doCmdResp_rc = 1010;
            CorePlugin.getDefault().session.checkResponse();
            return;
        }
        int i = 1;
        while (i <= NumSectBlk) {
            int saveFirstDigit;
            float fNumSectBlk;
            float fmoncnt;
            int percentComplete;
            sbkFirstLine = this.bbRespBuffer.getInt(headerOffset + sectBlkOffset);
            sbkLastLine = this.bbRespBuffer.getInt(headerOffset + sectBlkOffset + 4);
            String rawData = this.byteBufToString(headerOffset + sectBlkOffset + 8, 100, 'E');
            String reportName = rawData.substring(0, 3);
            if (rawData.contains("- DETAIL Window")) {
                this.spmReport = true;
            }
            if (reportName.equalsIgnoreCase("P01") || reportName.equalsIgnoreCase("P03")) {
                this.spmReport = true;
                reportName = this.spmrptid;
            }
            String reportTitle = rawData.substring(0, 100).trim();
            int dTagStart = rawData.indexOf("[D]");
            if (dTagStart >= 0) {
                reportTitle = this.parseDBCS(rawData);
            }
            String logstr = "parseReports:  " + rawData.trim() + " ... " + sbkFirstLine + " - " + sbkLastLine;
            System.out.println("ReportPvmlParser - " + logstr);
            CorePlugin.getDefault().log.debug(logstr);
            monitor.subTask(String.valueOf(Messages.getString("ObservationReports.Job.Monitor.Step3of3")) + i + Messages.getString("ObservationReports.Job.Monitor.Step3of3Of") + NumSectBlk + " " + reportTitle);
            if (sbkFirstLine > 0) {
                this.getReport(reportName, blobStart, sbkFirstLine);
                System.gc();
            }
            this.section1 = false;
            sectBlkOffset += SectBlkLen;
            if ((firstDigitComplete = (percentComplete = (int)((fmoncnt = new Float(++moncnt).floatValue()) / (fNumSectBlk = new Float(NumSectBlk).floatValue()) * 100.0f)) / 10) != (saveFirstDigit = firstDigitComplete) && monitor != null) {
                monitor.worked(5);
            }
            ++i;
        }
    }

    private void getReport(String reportId, int blobStart, int sbkFirstLine) {
        String expandCollapse = "-";
        String rptsuffix = "-base";
        if (this.detailReport) {
            rptsuffix = "-detailbase";
        }
        IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
        CorePlugin.getDefault();
        File reportFile = new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + this.reqnum + File.separator + Platform.getNL() + File.separator + reportId + rptsuffix + ".txt");
        reportFile.getParentFile().mkdirs();
        try {
            this.outPVML = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(reportFile), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {}
        rptsuffix = "-base0";
        if (this.detailReport) {
            rptsuffix = "-detailbase0";
        }
        IPreferenceStore iPreferenceStore2 = CorePlugin.getDefault().getPreferenceStore();
        CorePlugin.getDefault();
        File reportFile0 = new File(String.valueOf(iPreferenceStore2.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + this.reqnum + File.separator + Platform.getNL() + File.separator + reportId + rptsuffix + ".txt");
        try {
            this.outPVML0 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(reportFile0), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {}
        long activeOffset = 0L;
        this.recordOffset = 0L;
        int reportStart = blobStart + sbkFirstLine;
        int pgTxtHeader = 12;
        int dataStart = reportStart + pgTxtHeader;
        String plusplusOffset = null;
        String plusplusPointer = null;
        this.saveActiveLink = "";
        this.prevActiveLink = "";
        int saveLevel = 0;
        this.pi = "0";
        this.prevPI = "0";
        this.blankLine = false;
        short lineLength = this.bbRespBuffer.getShort(reportStart + 10);
        String dataLine = this.byteBufToString(dataStart, lineLength, 'E');
        String.format("%04d", lineLength);
        this.sPVML = "";
        this.db2Report = reportId.charAt(0) == 'F' || reportId.equalsIgnoreCase("B12") || reportId.equalsIgnoreCase("X05");
        dataLine = dataLine.replaceAll("[\\t\\r\\n]", " ");
        this.formatRawData(dataLine);
        dataLine = null;
        int count = 1;
        int level = 0;
        plusplusPointer = String.valueOf(this.iTag) + ";" + plusplusOffset;
        plusplusOffset = this.section1 ? Integer.toHexString(reportStart + this.SectBlkDSPO).toUpperCase() : Integer.toHexString(reportStart + this.SectBlkDSPO - sbkFirstLine).toUpperCase();
        plusplusOffset = ReportPvmlParser.padString(plusplusOffset, 8, '0', true);
        if (this.sPVML.length() > 0) {
            try {
                level = (this.sPVML.indexOf(this.rightArrow) + 1) / 2;
                if (this.saveActiveLink.equals(this.prevActiveLink)) {
                    level = saveLevel;
                } else {
                    this.prevActiveLink = this.saveActiveLink;
                    saveLevel = level;
                }
                if (this.db2Report && this.pi.charAt(0) == 'A' && this.sPVML.indexOf(this.rightArrow) == -1) {
                    level = (this.sPVML.indexOf(62) + 1) / 2;
                }
                expandCollapse = "-";
                this.outString = "\t" + level + "\t" + this.pi + "\t" + (this.sPVML.length() + 1) + "\t" + this.sStylingStringPrint + "\t" + this.sPVML;
                this.outPVML.write(String.valueOf(expandCollapse) + this.outString + "\t" + this.recordOffset + "\t" + plusplusPointer + "\n");
                this.outPVML.flush();
                if (level == 0) {
                    expandCollapse = "+";
                    this.outPVML0.write(String.valueOf(expandCollapse) + this.outString + "\t" + activeOffset + "\t" + plusplusPointer + "\n");
                    this.outPVML0.flush();
                }
                ++count;
                this.recordOffset = reportFile.length();
                activeOffset = reportFile0.length();
                this.outString = null;
            }
            catch (Exception exception) {}
        }
        int pgt_next = this.bbRespBuffer.getInt(reportStart + 4);
        lineLength = this.bbRespBuffer.getShort(blobStart + pgt_next + 10);
        while (pgt_next > 0) {
            dataLine = this.byteBufToString(blobStart + pgt_next + 12, lineLength, 'E');
            this.sPVML = "";
            if ((reportId.equals("S02") || reportId.equals("D04")) && count == 2) {
                dataLine = " ";
            }
            if (dataLine.indexOf(10) >= 0) {
                dataLine = dataLine.replace('\n', '.');
            }
            dataLine = dataLine.replaceAll("[\\t\\r\\n]", " ");
            this.formatRawData(dataLine);
            dataLine = null;
            if (this.sPVML.length() > 0) {
                plusplusOffset = this.section1 ? Integer.toHexString(pgt_next).toUpperCase() : Integer.toHexString(pgt_next - sbkFirstLine + this.SectBlkDSPO).toUpperCase();
                plusplusOffset = ReportPvmlParser.padString(plusplusOffset, 8, '0', true);
                plusplusPointer = String.valueOf(this.iTag) + ";" + plusplusOffset;
                try {
                    level = (this.sPVML.indexOf(this.rightArrow) + 1) / 2;
                    if (this.saveActiveLink.equals(this.prevActiveLink)) {
                        level = saveLevel;
                    } else {
                        this.prevActiveLink = this.saveActiveLink;
                        saveLevel = level;
                    }
                    if (this.db2Report && this.pi.charAt(0) == 'A' && this.sPVML.indexOf(this.rightArrow) == -1) {
                        level = (this.sPVML.indexOf(62) + 1) / 2;
                        if (this.blankLine && level == 0) {
                            level = saveLevel;
                        }
                    }
                    if (this.sTagOn) {
                        this.pi = "S";
                    }
                    if (this.blankLine && level == 0) {
                        level = 1;
                    }
                    if (reportId.equals("S10")) {
                        if (level > 0 && this.pi.equals("0")) {
                            level = 4;
                            this.pi = "A";
                        }
                        if (this.blankLine) {
                            level = 4;
                        }
                    }
                    if (reportId.equals("J03") && this.sPVML.contains("Note:")) {
                        level = 0;
                        this.pi = "A";
                    }
                    if (reportId.equals("C09") || reportId.equals("K02")) {
                        if (this.sPVML.contains("Alternate Disassembly")) {
                            level = 1;
                            this.pi = "A";
                        } else {
                            saveLevel = level = (this.sPVML.indexOf(this.rightArrow) + 1) / 2;
                        }
                        if (this.blankLine && level == 0) {
                            level = 1;
                        }
                        if (this.sPVML.indexOf(this.rightArrow) != -1) {
                            level = 1;
                            this.pi = "A";
                        }
                    }
                    this.blankLine = false;
                    this.prevPI = this.pi;
                    this.outString = "\t" + level + "\t" + this.pi + "\t" + (this.sPVML.length() + 1) + "\t" + this.sStylingStringPrint + "\t" + this.sPVML;
                    expandCollapse = "-";
                    this.outPVML.write(String.valueOf(expandCollapse) + this.outString + "\t" + this.recordOffset + "\t" + plusplusPointer + "\n");
                    this.outPVML.flush();
                    if (level == 0) {
                        expandCollapse = "+";
                        this.outPVML0.write(String.valueOf(expandCollapse) + this.outString + "\t" + activeOffset + "\t" + plusplusPointer + "\n");
                        this.outPVML0.flush();
                    }
                    ++count;
                }
                catch (Exception exception) {}
                activeOffset = reportFile0.length();
                this.recordOffset = reportFile.length();
                this.outString = null;
            }
            this.sPVML = null;
            pgt_next = this.bbRespBuffer.getInt(blobStart + pgt_next + 4);
            lineLength = this.bbRespBuffer.getShort(blobStart + pgt_next + 10);
        }
        try {
            this.outPVML.close();
            this.outPVML0.close();
        }
        catch (Exception exception) {}
    }

    private int formatRawData(String pvmlInput) {
        char tagVal;
        StringBuffer stylingStringBuffer = new StringBuffer();
        StringBuffer stylingStringBufferPrint = new StringBuffer();
        boolean skipIt = false;
        boolean graphicStringFound = false;
        String tempDataLine = pvmlInput.trim();
        String lineFormat = "";
        String tag = "";
        int retCode = 0;
        this.pi = "0";
        if (pvmlInput.indexOf("[/I ") > 0) {
            pvmlInput = pvmlInput.replace("[/I ", "[/I]");
        }
        if (this.db2Report && pvmlInput.indexOf("[/H] Seqno [HW]") > 0) {
            pvmlInput = pvmlInput.replace("[/H] Seqno ", "[HR] Seqno ");
            pvmlInput = pvmlInput.replace("[/H])", "[HR])");
        }
        if (pvmlInput.indexOf("[S]") > -1) {
            this.sTagOn = true;
            skipIt = true;
            this.pvmlHeader = true;
            this.pi = "S";
        }
        if (this.firstTime) {
            if (!this.sTagOn) {
                this.blobOffset = 0;
                this.firstTime = false;
            } else {
                this.firstTime = false;
            }
        }
        if (pvmlInput.indexOf("[/S]") > -1) {
            this.pvmlHeader = false;
            this.sTagOn = false;
            this.pi = "";
            skipIt = true;
            this.printBlobOffset += this.blobOffset;
            this.blobOffset = 0;
        }
        this.printBlobOffset = 0;
        this.blobOffset = 0;
        if (skipIt) {
            skipIt = false;
            return 0;
        }
        int dTagStart = pvmlInput.indexOf("[D]");
        if (dTagStart >= 0) {
            pvmlInput = this.parseDBCS(pvmlInput);
        }
        StringBuffer pvml = new StringBuffer(pvmlInput);
        pvml.trimToSize();
        if (pvmlInput.equals("[K]")) {
            pvml.append(" ");
        }
        pvml.append("[/H]");
        int startPosition = 0;
        int stringLength = 0;
        int openTag = pvml.indexOf("[", 0);
        int closeTag = pvml.indexOf("]", 0) + 1;
        String setHAttribute = "";
        String tempAttribute = "";
        String saveAttribute = "";
        String activeLink = "";
        String saveColor = "foreground=bl";
        boolean iTagFound = false;
        while (openTag != -1) {
            tagVal = pvml.charAt(openTag + 1);
            if (tagVal >= '0' && tagVal <= '9') {
                pvml.delete(openTag, closeTag);
            }
            openTag = pvml.indexOf("[", openTag + 1);
            closeTag = pvml.indexOf("]", openTag + 1) + 1;
        }
        openTag = pvml.indexOf("[", 0);
        closeTag = pvml.indexOf("]", 0) + 1;
        while (openTag != -1) {
            tag = pvml.substring(openTag + 1, closeTag - 1);
            tagVal = pvml.charAt(openTag + 1);
            if (pvml.charAt(openTag + 1) == '/') {
                tagVal = pvml.charAt(openTag + 2);
            }
            boolean printOn = false;
            setHAttribute = "";
            tempAttribute = "";
            String setPipe = "|";
            iTagFound = false;
            switch (tagVal) {
                case 'H': {
                    if (pvml.charAt(openTag + 1) == '/') {
                        graphicStringFound = false;
                        break;
                    }
                    int i = 1;
                    while (i < tag.length()) {
                        int multiTag = tag.length();
                        char tagAttribute = tag.charAt(i);
                        printOn = true;
                        setHAttribute = "";
                        switch (tagAttribute) {
                            case 'B': {
                                saveColor = setHAttribute = "foreground=b";
                                break;
                            }
                            case 'G': {
                                saveColor = setHAttribute = "foreground=g";
                                break;
                            }
                            case 'P': {
                                saveColor = setHAttribute = "foreground=p";
                                break;
                            }
                            case 'R': {
                                saveColor = setHAttribute = "foreground=r";
                                break;
                            }
                            case 'T': {
                                saveColor = setHAttribute = "foreground=t";
                                break;
                            }
                            case 'W': {
                                saveColor = setHAttribute = "foreground=bl";
                                break;
                            }
                            case 'Y': {
                                saveColor = setHAttribute = "foreground=y";
                                break;
                            }
                            case 'U': {
                                setHAttribute = "underline=true";
                                break;
                            }
                            case 'I': {
                                tempAttribute = tempAttribute.replace("fore", "back");
                                --multiTag;
                                setPipe = "";
                                break;
                            }
                            case 'X': {
                                tempAttribute = tempAttribute.replace("fore", "back");
                                --multiTag;
                                setPipe = "";
                                break;
                            }
                            case '+': {
                                if (saveColor.contains("=bl")) {
                                    saveColor = saveColor.replace("=bl", "=gr");
                                }
                                graphicStringFound = true;
                                --multiTag;
                                setPipe = "";
                                break;
                            }
                        }
                        if (multiTag > 1) {
                            tempAttribute = String.valueOf(tempAttribute) + setPipe + setHAttribute;
                            --multiTag;
                        } else {
                            tempAttribute = setHAttribute;
                        }
                        ++i;
                    }
                    break;
                }
                case 'I': {
                    iTagFound = true;
                    if (pvml.charAt(openTag + 1) == '/') break;
                    if (pvml.charAt(openTag + 2) == '.') {
                        activeLink = pvml.substring(openTag + 3, closeTag - 1);
                        this.saveActiveLink = activeLink = "E" + activeLink.substring(activeLink.length() - 3);
                        tempAttribute = String.valueOf(tempAttribute) + "|foreground=t|underline=true|activelink=" + activeLink;
                        printOn = true;
                    }
                    if (pvml.charAt(openTag + 2) != '-' && pvml.charAt(openTag + 2) != '_') break;
                    if (this.sTagOn) {
                        this.lRecordOffset = this.recordOffset;
                        activeLink = this.lRecordOffset.toString();
                    } else {
                        this.iTag = activeLink = pvml.substring(openTag + 3, closeTag - 1);
                        if (activeLink.toUpperCase().contains("SORT")) {
                            activeLink = "S" + activeLink;
                        } else {
                            this.lRecordOffset = this.recordOffset;
                            activeLink = this.lRecordOffset.toString();
                            this.pi = "A";
                        }
                    }
                    tempAttribute = String.valueOf(tempAttribute) + "|activelink=" + activeLink;
                    this.saveActiveLink = activeLink;
                    printOn = true;
                    break;
                }
                case 'K': {
                    break;
                }
                case 'S': {
                    break;
                }
            }
            pvml.delete(openTag, closeTag);
            startPosition = closeTag - tag.length() - 1;
            if (iTagFound) {
                pvml.insert(openTag, ' ');
                startPosition = closeTag - tag.length();
                iTagFound = false;
            }
            openTag = pvml.indexOf("[", 0);
            closeTag = pvml.indexOf("]", openTag) + 1;
            stringLength = openTag - startPosition + 1;
            if (graphicStringFound) {
                String rawGraphicString = "";
                String formattedGraphicString = "";
                rawGraphicString = pvml.substring(startPosition - 1, startPosition + stringLength - 1);
                formattedGraphicString = this.printGraphics(rawGraphicString);
                pvml.replace(startPosition - 1, startPosition + stringLength - 1, formattedGraphicString);
                if (tempAttribute.indexOf("bl") >= 0) {
                    tempAttribute = tempAttribute.replace("bl", "gr");
                }
                graphicStringFound = false;
            }
            lineFormat = new String();
            if (this.db2Report && tempDataLine.startsWith("[HW]> ", 0)) {
                this.lRecordOffset = this.recordOffset;
                activeLink = this.lRecordOffset.toString();
                this.pi = "A";
                if (pvmlInput.equals(" ")) {
                    this.blankLine = true;
                }
            }
            if (this.prevPI.equals("A") && pvmlInput.equals(" ")) {
                this.blankLine = true;
                this.lRecordOffset = this.recordOffset;
                activeLink = this.lRecordOffset.toString();
                this.pi = "A";
            }
            if (!printOn) continue;
            if (saveAttribute.length() > 0) {
                tempAttribute = String.valueOf(tempAttribute) + saveAttribute;
            }
            if (tempAttribute.length() == 0) {
                tempAttribute = saveAttribute;
            }
            startPosition = startPosition - 1 + this.blobOffset;
            if (tempAttribute.indexOf("ground") < 1) {
                tempAttribute = String.valueOf(tempAttribute) + "|" + saveColor;
            }
            if (stringLength > 0) {
                lineFormat = "start=" + startPosition + "|len=" + stringLength + tempAttribute;
                if (activeLink.length() > 0) {
                    lineFormat = String.valueOf(lineFormat) + "|activelink=" + activeLink;
                }
                lineFormat = this.makePositional(lineFormat);
                stylingStringBuffer = stylingStringBuffer.append(lineFormat);
                stylingStringBuffer = stylingStringBuffer.append(",");
                int startPositionP = startPosition + this.printBlobOffset;
                lineFormat = "start=" + startPositionP + "|len=" + stringLength + tempAttribute;
                if (activeLink.length() > 0) {
                    lineFormat = String.valueOf(lineFormat) + "|activelink=" + activeLink;
                }
                activeLink = "";
                lineFormat = this.makePositional(lineFormat);
                stylingStringBufferPrint = stylingStringBufferPrint.append(lineFormat);
                stylingStringBufferPrint = stylingStringBufferPrint.append(",");
            }
            saveAttribute = "";
        }
        this.blobOffset = pvml.length() + this.blobOffset + 1;
        this.sPVML = pvml.toString();
        if (this.spmReport) {
            if (this.sPVML.contains("\u0001")) {
                this.sPVML = this.sPVML.replaceAll("\u0001", "[");
            }
            System.out.println(this.sPVML);
        }
        this.sPVML = this.sPVML.replace('\u00f1', '\u00b1');
        this.sPVML = this.sPVML.replace('\u00ac', ' ');
        this.sPVML = this.sPVML.replace('\u0000', ' ');
        this.sStylingString = stylingStringBuffer.toString();
        this.sStylingStringPrint = stylingStringBufferPrint.toString();
        int stylingLength = this.sStylingString.length();
        int lastStylingcomma = this.sStylingString.lastIndexOf(",") + 1;
        if (lastStylingcomma == stylingLength && stylingLength > 0) {
            this.sStylingString = this.sStylingString.substring(0, lastStylingcomma - 1);
        }
        if (this.sStylingString.length() == 0) {
            this.sStylingString = String.valueOf(this.sStylingString) + " ";
        }
        retCode = this.sTagOn ? 1 : 2;
        return retCode;
    }

    private String printGraphics(String graphicString) {
        StringBuffer graphicStringBuffer = new StringBuffer();
        int i = 0;
        while (i < graphicString.length()) {
            char graphicCharacter = graphicString.charAt(i);
            graphicStringBuffer.append(this.getGraphicCode(graphicCharacter));
            ++i;
        }
        return graphicStringBuffer.toString();
    }

    private char getGraphicCode(char pvmlchar) {
        if (pvmlchar == 's' && this.doubleByteCodePage.equalsIgnoreCase("true")) {
            return this.dbcsHline;
        }
        int i = 0;
        while (i < this.graphicChars.length) {
            if (this.graphicChars[i][0] == pvmlchar) {
                return this.graphicChars[i][1];
            }
            ++i;
        }
        return this.graphicChars[0][1];
    }

    private String parseDBCS(String dbcsInput) {
        StringBuffer dbcsString = new StringBuffer(dbcsInput);
        int dTagStart = dbcsString.indexOf("[D]");
        if (dTagStart >= 0) {
            int dTagEnd = dbcsString.indexOf("[/D]");
            String rawDBCSString = "";
            String formattedDBCSString = "";
            while (dTagStart > 0 && dTagEnd > 0) {
                rawDBCSString = dbcsString.substring(dTagStart + 3, dTagEnd);
                int cfr_ignored_0 = rawDBCSString.length() / 4;
                formattedDBCSString = " " + this.fromDBCS(rawDBCSString) + " ";
                dbcsString.delete(dTagStart, dTagEnd + 4);
                dbcsString.insert(dTagStart, formattedDBCSString);
                dTagStart = dbcsString.indexOf("[D]");
                dTagEnd = dbcsString.indexOf("[/D]");
            }
        }
        return dbcsString.toString();
    }

    private String fromDBCS(String dbcsString) {
        String internationalString = "0E" + dbcsString + "0F";
        byte[] internationalBytes = new BigInteger(internationalString, 16).toByteArray();
        ByteBuffer dbcsBuffer = ByteBuffer.wrap(internationalBytes);
        String decodedString = null;
        try {
            Charset charset = Charset.forName(this.internationalCodePage);
            CharsetDecoder decoder = charset.newDecoder();
            CharBuffer decodedBuffer = decoder.decode(dbcsBuffer);
            decodedString = decodedBuffer.toString();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return decodedString;
    }

    private String toXML(String pvmlString, String activeLink, String rawPVML) {
        String xmlString = "";
        String pvmlValue = "";
        String pvmlName = "";
        int level = pvmlString.indexOf(this.rightArrow);
        if (level > 0) {
            System.out.println("Found indent " + level);
        }
        if (pvmlString.length() > 1) {
            pvmlName = pvmlString.length() > 10 ? pvmlString.substring(1 + level, 10 + level).trim() : " ";
            pvmlValue = pvmlString.length() > 34 ? pvmlString.substring(34, 39).trim() : " ";
            xmlString = "id=\"I" + activeLink + "\" " + "pvmlName=\"" + pvmlName + "\" " + "pvmlValue=\"" + pvmlValue + "\" " + "pvmlText=\"" + rawPVML + "\"";
            xmlString = "<section1 " + xmlString + "/>";
        }
        if (this.pvmlHeader) {
            xmlString = "id=\"header\" pvmlText=\"" + rawPVML + "\"";
            xmlString = "<header " + xmlString + "/>";
        }
        return xmlString;
    }

    private String getIndexValues(String pvmlString, String activeLink, String rawPVML) {
        String xmlString = "";
        String pvmlValue = "";
        String pvmlName = "";
        int level = pvmlString.indexOf(this.rightArrow);
        if (level > 0) {
            System.out.println("Found indent " + level);
        }
        if (pvmlString.length() > 1) {
            pvmlName = pvmlString.length() > 10 ? pvmlString.substring(1 + level, 10 + level).trim() : " ";
            pvmlValue = pvmlString.length() > 34 ? pvmlString.substring(34, 39).trim() : " ";
            xmlString = "id=\"I" + activeLink + "\" " + "pvmlName=\"" + pvmlName + "\" " + "pvmlValue=\"" + pvmlValue + "\" " + "pvmlText=\"" + rawPVML + "\"";
            xmlString = "<section1 " + xmlString + "/>";
        }
        if (this.pvmlHeader) {
            xmlString = "id=\"header\" pvmlText=\"" + rawPVML + "\"";
            xmlString = "<header " + xmlString + "/>";
        }
        return activeLink;
    }

    private String makePositional(String longFormat) {
        StringBuffer shortFormat = new StringBuffer();
        String[] styleElement = null;
        String[] pvmlAttribute = null;
        String stylelabel = null;
        String styleDelimiter1 = "[|]";
        Pattern s1 = Pattern.compile(styleDelimiter1);
        String styleDelimiter2 = "[=]";
        Pattern s2 = Pattern.compile(styleDelimiter2);
        String parm1 = "0";
        String parm2 = "0";
        String parm3 = "";
        String parm4 = "";
        String parm5 = "";
        String parm6 = "";
        String parm7 = "";
        styleElement = s1.split(longFormat);
        int j = 0;
        while (j < styleElement.length) {
            pvmlAttribute = s2.split(styleElement[j]);
            stylelabel = pvmlAttribute[0];
            if (stylelabel.equalsIgnoreCase("start")) {
                parm1 = pvmlAttribute[1];
            }
            if (stylelabel.equalsIgnoreCase("len")) {
                parm2 = pvmlAttribute[1];
            }
            if (stylelabel.equalsIgnoreCase("foreground")) {
                parm3 = pvmlAttribute[1];
            }
            if (stylelabel.equalsIgnoreCase("background")) {
                parm4 = pvmlAttribute[1];
                if (parm4.equals("b")) {
                    parm4 = "lb";
                }
                if (parm4.equals("p")) {
                    parm4 = "lp";
                }
            }
            if (stylelabel.equalsIgnoreCase("underline")) {
                parm5 = pvmlAttribute[1];
            }
            if (stylelabel.equalsIgnoreCase("bold")) {
                parm6 = pvmlAttribute[1];
            }
            if (stylelabel.equalsIgnoreCase("activelink")) {
                parm7 = pvmlAttribute[1];
            }
            ++j;
        }
        shortFormat.append(parm1);
        shortFormat.append("|");
        shortFormat.append(parm2);
        shortFormat.append("|");
        shortFormat.append(parm3);
        shortFormat.append("|");
        shortFormat.append(parm4);
        shortFormat.append("|");
        shortFormat.append(parm5);
        shortFormat.append("|");
        shortFormat.append(parm6);
        shortFormat.append("|");
        shortFormat.append(parm7);
        return shortFormat.toString();
    }

    private String byteBufToString(int offset, int length, char codepage) {
        byte[] ba = new byte[length];
        ByteBuffer miniBuffer = ByteBuffer.wrap(ba);
        String sValue = new String();
        int j = 0;
        while (j < length) {
            ba[j] = this.bbRespBuffer.get(offset + j);
            ++j;
        }
        Charset charset = Charset.forName(CorePlugin.getDefault().getPreferenceStore().getString("codePage"));
        CharsetDecoder decoder = charset.newDecoder();
        CharBuffer cbuf = null;
        try {
            cbuf = decoder.decode(miniBuffer);
            sValue = cbuf.toString();
        }
        catch (Exception e) {
            System.out.println("codepage error: " + e);
        }
        return sValue;
    }

    public static String padString(String s, int n, char c, boolean paddingLeft) {
        int add = n - s.length();
        if (add <= 0) {
            return s;
        }
        StringBuffer str = new StringBuffer(s);
        char[] ch = new char[add];
        Arrays.fill(ch, c);
        if (paddingLeft) {
            str.insert(0, ch);
        } else {
            str.append(ch);
        }
        return str.toString();
    }
}

