/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.data.reports;

import com.banknet.core.CorePlugin;
import com.banknet.core.data.reports.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.regex.Pattern;

public class ReportHtmlBuilder {
    File fOutputFile;
    PrintStream work;
    public String[] tokens;
    String tabDelimiter = "[\t]";
    String styleStringDelimiter = "[,]";
    String styleElementDelimiter = "[|]";
    Pattern t1 = Pattern.compile(this.tabDelimiter);
    Pattern s1 = Pattern.compile(this.styleStringDelimiter);
    Pattern s2 = Pattern.compile(this.styleElementDelimiter);
    StringBuilder htmlreport = new StringBuilder();
    String buildtype = "";
    String BUILDTYPE_STRING = "string";
    String BUILDTYPE_FILE = "file";
    String reportPath = "";
    String rptid = "";
    String rpttitle = "";
    String rptsuffix = "-active";
    String htmlfname = "";

    public static void main(String[] args) {
        try {
            ReportHtmlBuilder htmlgen = new ReportHtmlBuilder();
            htmlgen.rptsuffix = "-base0";
            htmlgen.buildHtmlFile("C:\\eclipseApaWorkspace3.5\\runtime-apasandbox.product\\apaReports\\SST\\5684\\en_US\\", "s01", "-active", "s01.html", "S01 Report");
        }
        catch (OutOfMemoryError oem) {
            System.out.println("ReportHtmlBuilder main processReport out of memory exception " + oem);
        }
        catch (Exception ex) {
            System.out.println("ReportHtmlBuilder main processReport exception xx " + ex);
        }
    }

    public String buildHtmlString(String reportPath, String rptid, String rptsuffix, String htmlfname, String rpttitle) {
        this.reportPath = reportPath;
        this.rptid = rptid;
        this.rptsuffix = rptsuffix;
        this.htmlfname = htmlfname;
        this.rpttitle = rpttitle;
        this.buildtype = this.BUILDTYPE_STRING;
        try {
            this.processReport();
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {}
        return this.htmlreport.toString();
    }

    public void buildHtmlFile(String reportPath, String rptid, String rptsuffix, String htmlfname, String rpttitle) throws Exception, IOException, OutOfMemoryError {
        this.reportPath = reportPath;
        this.rptid = rptid;
        this.rptsuffix = rptsuffix;
        this.htmlfname = htmlfname;
        this.rpttitle = rpttitle;
        this.buildtype = this.BUILDTYPE_FILE;
        this.work = null;
        this.fOutputFile = new File(String.valueOf(reportPath) + htmlfname);
        String fOutputPath = this.fOutputFile.getAbsolutePath();
        try {
            this.work = new PrintStream((OutputStream)new FileOutputStream(fOutputPath), true, "UTF-8");
        }
        catch (IOException iOException) {}
        try {
            this.processReport();
        }
        catch (OutOfMemoryError oem) {
            throw oem;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        try {
            this.work.flush();
            this.work.close();
        }
        catch (Exception exception) {}
    }

    private void processReport() throws Exception, IOException, OutOfMemoryError {
        String inputLine = null;
        try {
            File fInputFile = new File(String.valueOf(this.reportPath) + this.rptid + this.rptsuffix + ".txt");
            BufferedReader brStyle = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fInputFile), "UTF-8"));
            this.writeHTMLStart();
            while ((inputLine = brStyle.readLine()) != null) {
                this.parseLine(inputLine);
            }
            this.writeHTMLEnd();
            brStyle.close();
            fInputFile = null;
        }
        catch (OutOfMemoryError oem) {
            String logstr = "ReportHtmlBuilder - processReport:  Out of Memory exception. inputLine: " + inputLine + ". " + oem;
            System.out.println("ReportHtmlBuilder - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            throw oem;
        }
        catch (IOException e) {
            String logstr = "ReportHtmlBuilder - processReport:  IO exception. inputLine: " + inputLine + ". " + e;
            System.out.println("ReportHtmlBuilder - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            throw e;
        }
        catch (Exception e) {
            String logstr = "ReportHtmlBuilder - processReport:  Exception. inputLine: " + inputLine + ". " + e;
            System.out.println("ReportHtmlBuilder - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            throw e;
        }
    }

    private void parseLine(String inputLine) throws Exception, OutOfMemoryError {
        this.tokens = this.t1.split(inputLine);
        String content = this.tokens[5];
        String style = this.tokens[4];
        String[] styleElement = null;
        Integer[] start = new Integer[100];
        Integer[] end = new Integer[100];
        String[] color = new String[100];
        String[] backgroundColor = new String[100];
        String[] underLine = new String[100];
        String[] styleArray = this.s1.split(style);
        int k = 0;
        int numberOfTags = 0;
        int i = 0;
        while (i < styleArray.length) {
            this.s1.split(styleArray[i]);
            if (styleArray[i].indexOf("|") > 0) {
                styleElement = this.s2.split(styleArray[i], -1);
                start[k] = Integer.parseInt(styleElement[0]);
                end[k] = Integer.parseInt(styleElement[1]);
                color[k] = styleElement[2];
                backgroundColor[k] = styleElement[3];
                underLine[k] = styleElement[4];
                numberOfTags = ++k;
            }
            ++i;
        }
        StringBuffer strbuf = new StringBuffer(content);
        String startTag = "";
        String endTag = "\u0001/span\u0002";
        String newClass = "";
        int modLength = 0;
        if (numberOfTags > 0) {
            int w = 0;
            while (w < numberOfTags) {
                newClass = underLine[w].equals("true") ? String.valueOf(color[w]) + "UL" : (color[w].equals("") ? String.valueOf(backgroundColor[w]) + "BK" : color[w]);
                startTag = "\u0001span class=\"" + newClass + "\"" + "\u0002";
                strbuf.insert(start[w] + modLength, startTag);
                strbuf.insert(start[w] + end[w] + (modLength += startTag.length()), endTag);
                modLength += endTag.length();
                ++w;
            }
        }
        String htmlString = strbuf.toString();
        htmlString = htmlString.replaceAll("<", "&lt");
        htmlString = htmlString.replaceAll(">", "&gt");
        htmlString = htmlString.replaceAll("\u0001", "<");
        htmlString = htmlString.replaceAll("\u0002", ">");
        this.writeHTMLDetail(htmlString);
    }

    public void writeHTMLStart() {
        Messages.getString("ObservationReports.Html.FontName");
        Messages.getString("ObservationReports.Html.FontHeight");
        if (System.getProperty("os.name").toLowerCase().startsWith("linux")) {
            Messages.getString("ObservationReports.Html.FontName.Linux");
            Messages.getString("ObservationReports.Html.FontHeight.Linux");
        } else if (System.getProperty("os.name").toLowerCase().startsWith("mac")) {
            Messages.getString("ObservationReports.Html.FontName.Mac");
            Messages.getString("ObservationReports.Html.FontHeight.Mac");
        }
        String outputLine = "";
        outputLine = String.valueOf(outputLine) + "<html>";
        outputLine = String.valueOf(outputLine) + "<head>";
        outputLine = String.valueOf(outputLine) + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">";
        outputLine = String.valueOf(outputLine) + "<title>" + this.rpttitle + "</title>";
        outputLine = String.valueOf(outputLine) + "<style>" + '\n';
        outputLine = String.valueOf(outputLine) + "body {";
        outputLine = String.valueOf(outputLine) + "\tfont-family: Lucida Console, Courier, monospace; font-size:13px;";
        outputLine = String.valueOf(outputLine) + "}";
        outputLine = String.valueOf(outputLine) + ".g {color: #228B22}";
        outputLine = String.valueOf(outputLine) + ".b {color: #0000E1}";
        outputLine = String.valueOf(outputLine) + ".gr  {color: #E0E0E0}";
        outputLine = String.valueOf(outputLine) + ".t {color: #00A0A8}";
        outputLine = String.valueOf(outputLine) + ".bl {color: #000000}";
        outputLine = String.valueOf(outputLine) + ".y {color: #FFB90F}";
        outputLine = String.valueOf(outputLine) + ".r {color: #EE6363}";
        outputLine = String.valueOf(outputLine) + ".p {color: #FFB6C1}";
        outputLine = String.valueOf(outputLine) + ".gUL {color: #228B22; text-decoration:underline}";
        outputLine = String.valueOf(outputLine) + ".bUL {color: #0000E1; text-decoration:underline}";
        outputLine = String.valueOf(outputLine) + ".grUL  {color: #E0E0E0; text-decoration:underline}";
        outputLine = String.valueOf(outputLine) + ".tUL {color: #00A0A8; text-decoration:underline}";
        outputLine = String.valueOf(outputLine) + ".blUL {color: #000000; text-decoration:underline}";
        outputLine = String.valueOf(outputLine) + ".yUL {color: #FFB90F; text-decoration:underline}";
        outputLine = String.valueOf(outputLine) + ".rUL {color: #EE6363; text-decoration:underline}";
        outputLine = String.valueOf(outputLine) + ".pUL {color: #FFB6C1; text-decoration:underline}";
        outputLine = String.valueOf(outputLine) + ".gBK {background-color: #228B22}";
        outputLine = String.valueOf(outputLine) + ".tBK {background-color: #00A0A8}";
        outputLine = String.valueOf(outputLine) + ".lpBK {background-color: #FFB6C1}";
        outputLine = String.valueOf(outputLine) + ".rpttitle { font-family:verdana,geneva,sans-serif; font-size:12px; font-weight:bold; color: #000000;}";
        outputLine = String.valueOf(outputLine) + ".rpttitle:after {";
        outputLine = String.valueOf(outputLine) + "\t\tcontent:\"\\a\";";
        outputLine = String.valueOf(outputLine) + "\t\twhite-space: pre;";
        outputLine = String.valueOf(outputLine) + "}";
        outputLine = String.valueOf(outputLine) + "</style>";
        outputLine = String.valueOf(outputLine) + "<meta http-equiv=\"Content-Security-Policy\" content=\"default-src 'none'; form-action 'none'; style-src 'self' https://fonts.googleapis.com 'sha256-47DEQpj8HBSa+/TImW+5JCeuQeRkm5NMpJWZG3hSuFU=' 'sha256-9LTcPK/vtLgxRT3EGBma6w6V7uokBZDoa5QUOxUSYCo='; img-src 'self'; script-src-elem 'self';connect-src 'self';manifest-src 'self'; font-src https://fonts.gstatic.com;\">";
        outputLine = String.valueOf(outputLine) + "</head>";
        outputLine = String.valueOf(outputLine) + "<body>";
        outputLine = String.valueOf(outputLine) + "<pre>";
        outputLine = String.valueOf(outputLine) + "<span class=rpttitle>" + this.rpttitle + "</span>";
        if (this.buildtype.equals(this.BUILDTYPE_FILE)) {
            this.work.print(outputLine);
            this.work.flush();
        } else {
            this.htmlreport.append(outputLine);
        }
        outputLine = "";
    }

    public void writeHTMLDetail(String outputLine) {
        if (outputLine.isEmpty()) {
            outputLine = " ";
        }
        if (this.buildtype.equals(this.BUILDTYPE_FILE)) {
            this.work.println(outputLine);
            this.work.flush();
        } else {
            this.htmlreport.append(String.valueOf(outputLine) + "\n");
        }
        outputLine = "";
    }

    public void writeHTMLEnd() {
        String outputLine = "";
        outputLine = String.valueOf(outputLine) + "</pre>" + '\n';
        outputLine = String.valueOf(outputLine) + "</body>" + '\n';
        outputLine = String.valueOf(outputLine) + "</html>" + '\n';
        if (this.buildtype.equals(this.BUILDTYPE_FILE)) {
            this.work.print(outputLine);
            this.work.flush();
        } else {
            this.htmlreport.append(outputLine);
        }
        outputLine = "";
    }
}

