/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.data.reports;

import com.banknet.core.CorePlugin;
import com.banknet.core.data.reports.Messages;
import com.banknet.core.internal.Constants;
import com.banknet.core.models.ObservationsModel;
import com.banknet.core.models.ReportsModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReportControlCards {
    private Constants constants = new Constants();
    public int obsReqnum = 0;
    public String obsDsname = "";
    public String lcmdopt = "";
    public String rptformat = "";
    public List<String> multiaddrdsns = new ArrayList<String>();
    public List<String> variancedsns = new ArrayList<String>();
    public List<ReportsModel> selreports = new ArrayList<ReportsModel>();
    public String cazctl = "";
    public Integer cazctlcnt = 0;
    public boolean wasServantSampling = false;
    public String wasServantObsDsname = "";
    public boolean importedObservation = false;
    String cazctlLang = "";
    public String cookieDefault = "00000000";
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);
    public ObservationsModel obs;
    List<String> excludedRpts = new ArrayList<String>();

    public ReportControlCards() {
        this.cazctlLang = Messages.getString("ObservationReports.CazctlLang");
    }

    public void buildControlCards(String rptid, String detailoffset, String cookie) {
        block26: {
            String dspoffset;
            String itag;
            block28: {
                block27: {
                    itag = "";
                    dspoffset = "";
                    this.cazctlcnt = 0;
                    this.cazctl = "";
                    if (detailoffset.length() > 0) {
                        String[] offsetArr = detailoffset.split(";");
                        itag = offsetArr[0];
                        dspoffset = offsetArr[1];
                    }
                    if (this.variancedsns.size() > 0) {
                        int i = 0;
                        while (i < this.variancedsns.size()) {
                            this.cazctl = String.valueOf(this.cazctl) + "PROFILE 01 INPUTDSN=" + this.variancedsns.get(i) + " TYPE=TAGGED\r";
                            this.cazctlcnt = this.cazctlcnt + 1;
                            ++i;
                        }
                    }
                    if (cookie.equals(this.cookieDefault)) {
                        this.cazctl = String.valueOf(this.cazctl) + "PROFILE 01 INPUTDSN=" + this.obsDsname + "\r";
                        this.cazctlcnt = this.cazctlcnt + 1;
                    }
                    if (this.multiaddrdsns.size() > 0) {
                        String taggedval = "TAGGED";
                        if (this.obs.imsExtractor) {
                            taggedval = "IMASS";
                        }
                        int i = 0;
                        while (i < this.multiaddrdsns.size()) {
                            this.cazctl = String.valueOf(this.cazctl) + "PROFILE 01 INPUTDSN=" + this.multiaddrdsns.get(i) + " TYPE=" + taggedval + "\r";
                            this.cazctlcnt = this.cazctlcnt + 1;
                            ++i;
                        }
                    }
                    if (this.wasServantSampling && cookie.equals(this.cookieDefault) && this.wasServantObsDsname.length() > 0) {
                        this.cazctl = String.valueOf(this.cazctl) + "TYPE=(TAGGED,WASS)\r";
                        this.cazctlcnt = this.cazctlcnt + 1;
                        this.cazctl = String.valueOf(this.cazctl) + "PROFILE 01 INPUTDSN=" + this.wasServantObsDsname + "\r";
                        this.cazctlcnt = this.cazctlcnt + 1;
                    }
                    if (CorePlugin.getDefault().versionextension.chkNewField("Notes")) {
                        this.cazctl = String.valueOf(this.cazctl) + "DESC=\"" + this.obs.description + "\"\r";
                        this.cazctlcnt = this.cazctlcnt + 1;
                        this.cazctl = String.valueOf(this.cazctl) + "NOTES1=\"" + this.obs.notes1.trim() + "\"\r";
                        this.cazctlcnt = this.cazctlcnt + 1;
                        this.cazctl = String.valueOf(this.cazctl) + "NOTES2=\"" + this.obs.notes2.trim() + "\"\r";
                        this.cazctlcnt = this.cazctlcnt + 1;
                        this.cazctl = String.valueOf(this.cazctl) + "NOTES3=\"" + this.obs.notes3.trim() + "\"\r";
                        this.cazctlcnt = this.cazctlcnt + 1;
                    }
                    if (rptid.length() > 0) {
                        String section = "";
                        try {
                            XPathFactory factory = XPathFactory.newInstance();
                            XPath xpath = factory.newXPath();
                            String expression = "//reports/category/report[@code='" + rptid + "']";
                            NodeList nodeList2 = (NodeList)xpath.evaluate(expression, CorePlugin.getDefault().reportsdoc, XPathConstants.NODESET);
                            if (nodeList2.getLength() > 0) {
                                NamedNodeMap atrs2 = nodeList2.item(0).getParentNode().getAttributes();
                                section = ((Attr)atrs2.getNamedItem("id")).getNodeValue();
                                ((Attr)atrs2.getNamedItem("description")).getNodeValue();
                            }
                        }
                        catch (Exception e) {
                            System.out.println("buildControlCards Exception: " + e);
                        }
                        this.buildModelReportCards(section, rptid);
                    } else if (this.selreports.size() > 0) {
                        int i = 0;
                        while (i < this.selreports.size()) {
                            if (this.selreports.get((int)i).parent.reportid.equals(CorePlugin.getDefault().constants.REPORT_CATEGORY_SPM)) {
                                this.formatSpmCards(this.selreports.get((int)i).reportid, this.selreports.get((int)i).spmModule, this.selreports.get((int)i).spmLibrary, this.selreports.get((int)i).loadLibrary);
                            } else {
                                this.buildModelReportCards(this.selreports.get((int)i).parent.reportid, this.selreports.get((int)i).reportid);
                            }
                            ++i;
                        }
                    } else {
                        this.loadExcludedRptsList();
                        this.buildReportCards();
                    }
                    if (itag.length() <= 0) break block26;
                    if (this.lcmdopt.equals(this.constants.REPORT_LCMD_SPM)) break block27;
                    this.constants.getClass();
                    if (!this.lcmdopt.equals("++")) break block28;
                }
                this.buildIVars();
            }
            this.cazctl = String.valueOf(this.cazctl) + "SECTDETL ITAG=" + itag + " DSPOFF=" + dspoffset;
            if (this.lcmdopt.length() > 0) {
                this.cazctl = String.valueOf(this.cazctl) + " LCMD=" + this.lcmdopt;
            }
            this.cazctl = String.valueOf(this.cazctl) + " \r";
            this.cazctlcnt = this.cazctlcnt + 1;
        }
        String ctlLang = this.cazctlLang;
        if (this.rptformat.equals(this.constants.REPORT_FORMAT_XML) || this.rptformat.equals(this.constants.REPORT_FORMAT_JSON)) {
            ctlLang = this.constants.REPORT_CAZCTLLANG_ENU;
        }
        this.cazctl = String.valueOf(this.cazctl) + "CONVERT Format=" + this.rptformat + " DDNAME=$ LANG=" + ctlLang + " \r";
        this.cazctlcnt = this.cazctlcnt + 1;
    }

    private void buildIVars() {
        String ivar = " VAR=(";
        String spmSetting = "";
        String spmDwarfSetting = "";
        String[] spmSettings = this.s1.split(CorePlugin.getDefault().getPreferenceStore().getString("spmSettings"), -1);
        this.cazctl = String.valueOf(this.cazctl) + "SETIVAR" + ivar + spmSettings[0] + ")" + " \r";
        this.cazctlcnt = this.cazctlcnt + 1;
        int i = 1;
        while (i < spmSettings.length) {
            spmSetting = spmSettings[i].replace(" ", "''");
            if (spmSetting.indexOf("P01SW04") >= 0) {
                String[] spmSettingVars = spmSetting.split(",");
                spmSettingVars[4] = "/";
                spmSetting = String.valueOf(spmSettingVars[0]) + "," + spmSettingVars[1] + "," + spmSettingVars[2] + "," + spmSettingVars[3] + "," + spmSettingVars[4];
            }
            this.cazctl = String.valueOf(this.cazctl) + ivar + spmSetting + ")" + " \r";
            this.cazctlcnt = this.cazctlcnt + 1;
            if (spmSetting.indexOf("P01SW03") >= 0 || spmSetting.indexOf("P01SW04") >= 0 || spmSetting.indexOf("P01SW06") >= 0) {
                spmDwarfSetting = spmSetting.replace("P01SW", "P03SW");
                this.cazctl = String.valueOf(this.cazctl) + ivar + spmDwarfSetting + ")" + " \r";
                this.cazctlcnt = this.cazctlcnt + 1;
            }
            ++i;
        }
    }

    private void testControlCardsSPM() {
        String[] spmArgs = CorePlugin.getDefault().getPreferenceStore().getString("spmP01Args").split(",");
        this.cazctl = String.valueOf(this.cazctl) + "MAP TYPE=L FILE=ACS01.COMPILE.LISTING MEMBER=COBSAM01\r";
        this.cazctl = String.valueOf(this.cazctl) + "SECTION P01 Program=COBSAM01\r";
        this.cazctlcnt = this.cazctlcnt + 2;
        this.cazctlcnt = this.cazctlcnt + 8;
        int i = 0;
        while (i < spmArgs.length) {
            this.cazctl = String.valueOf(this.cazctl) + spmArgs[i] + "\r";
            ++i;
        }
        this.cazctlcnt = this.cazctlcnt + spmArgs.length;
    }

    private void formatSpmCards(String reportid, String module, String library, String loadlib) {
        String[] spmSettings = this.s1.split(CorePlugin.getDefault().getPreferenceStore().getString("spmSettings"), -1);
        int memIdx = library.indexOf("(");
        String tmpspmlib = library;
        if (memIdx > 0) {
            tmpspmlib = library.substring(0, memIdx).trim();
        }
        if (!loadlib.equalsIgnoreCase(tmpspmlib)) {
            if (memIdx >= 0) {
                String pdsLib = library.substring(0, memIdx).trim();
                int endIdx = library.indexOf(")");
                String pdsMem = library.substring(memIdx + 1, endIdx).trim();
                String[] libarr = pdsLib.split("\\s+");
                this.cazctl = libarr.length >= 2 ? String.valueOf(this.cazctl) + "MAP TYPE=L SERVER=" + libarr[0] + " SCHEME=" + libarr[1] + " MEMBER=" + pdsMem + "\r" : String.valueOf(this.cazctl) + "MAP TYPE=L FILE=" + pdsLib + " MEMBER=" + pdsMem + "\r";
                this.cazctlcnt = this.cazctlcnt + 1;
            } else {
                String[] libarr = library.split("\\s+");
                this.cazctl = libarr.length == 1 ? String.valueOf(this.cazctl) + "MAP TYPE=L SERVER=" + libarr[0] + " SCHEME=" + libarr[1] + "\r" : String.valueOf(this.cazctl) + "MAP TYPE=L FILE=" + library + "\r";
                this.cazctlcnt = this.cazctlcnt + 1;
            }
        }
        this.cazctl = String.valueOf(this.cazctl) + "SECTION " + reportid + " Program=" + module + "\r";
        this.cazctlcnt = this.cazctlcnt + 1;
        String[] spmSetting = spmSettings[0].split(",");
        this.cazctl = String.valueOf(this.cazctl) + "AdjLines=" + spmSetting[4] + "\r";
        spmSetting = spmSettings[1].split(",");
        String ArgAllSource = spmSetting[4].equals("/") ? "Y" : "N";
        this.cazctl = String.valueOf(this.cazctl) + "AllSource=" + ArgAllSource + "\r";
        spmSetting = spmSettings[2].split(",");
        String ArgAsmObj = spmSetting[4].equals("/") ? "Y" : "N";
        this.cazctl = String.valueOf(this.cazctl) + "AsmObj=" + ArgAsmObj + "\r";
        spmSetting = spmSettings[4].split(",");
        String ArgHeader = spmSetting[4].equals("/") ? "Y" : "N";
        this.cazctl = String.valueOf(this.cazctl) + "Header=" + ArgHeader + "\r";
        spmSetting = spmSettings[6].split(",");
        String ArgPercent = spmSetting[4].equals("/") ? "Y" : "N";
        this.cazctl = String.valueOf(this.cazctl) + "Percent=" + ArgPercent + "\r";
        spmSetting = spmSettings[5].split(",");
        String ArgPseudo = spmSetting[4].equals("/") ? "Y" : "N";
        this.cazctl = String.valueOf(this.cazctl) + "Pseudo=" + ArgPseudo + "\r";
        this.cazctlcnt = this.cazctlcnt + 6;
    }

    private void loadExcludedRptsList() {
        String[] rpts = CorePlugin.getDefault().getPreferenceStore().getString("excludedRpts").split(",");
        int i = 0;
        while (i < rpts.length) {
            this.excludedRpts.add(rpts[i]);
            ++i;
        }
    }

    private void buildReportCards() {
        String section = "";
        NodeList childNodes2 = CorePlugin.getDefault().reportsdoc.getElementsByTagName("report");
        int ii = 0;
        while (ii < childNodes2.getLength()) {
            Node item2 = childNodes2.item(ii);
            String nodeName2 = item2.getNodeName();
            NamedNodeMap atrs = item2.getParentNode().getAttributes();
            int jj = 0;
            while (jj < atrs.getLength()) {
                if (((Attr)atrs.item(jj)).getNodeName().equals("id")) {
                    section = ((Attr)atrs.item(jj)).getNodeValue();
                    break;
                }
                ++jj;
            }
            if (nodeName2.equals("report")) {
                atrs = item2.getAttributes();
                String rptid = ((Attr)atrs.item(0)).getNodeValue();
                if (CorePlugin.getDefault().versionextension.chkReportControlCards(rptid, section) && (!rptid.equals("X05") || this.obs.imsiExtractor || this.obs.db2iExtractor || this.obs.mqiExtractor) && this.excludedRpts.indexOf(rptid) < 0 && this.excludedRpts.indexOf(section) < 0) {
                    if (this.variancedsns.size() <= 0 && this.multiaddrdsns.size() <= 0) {
                        if (!section.equalsIgnoreCase(this.constants.REPORT_CATEGORY_VARIANCE) && !CorePlugin.getDefault().versionextension.chkIsMultiAddr(rptid, section)) {
                            this.buildOptionsCards(section, rptid);
                        }
                    } else if (this.variancedsns.size() > 0 && section.equalsIgnoreCase(this.constants.REPORT_CATEGORY_VARIANCE)) {
                        this.buildOptionsCards(section, rptid);
                    } else if (this.multiaddrdsns.size() > 0 && CorePlugin.getDefault().versionextension.chkIsMultiAddr(rptid, section)) {
                        this.buildOptionsCards(section, rptid);
                    }
                }
                this.persistReportOptions(rptid, "properties");
            }
            ++ii;
        }
    }

    private void buildOptionsCards(String section, String rptid) {
        String blanksection = "           ";
        String rptsection = "SECTION " + rptid;
        if (CorePlugin.getDefault().getPreferenceStore().getString(rptid).length() > 0) {
            String[] options = CorePlugin.getDefault().getPreferenceStore().getString(rptid).split(",");
            int i = 0;
            while (i < options.length) {
                if (CorePlugin.getDefault().versionextension.chkReportOptions(section, rptid, options[i])) {
                    this.cazctl = String.valueOf(this.cazctl) + rptsection + " " + options[i] + "\r";
                    this.cazctlcnt = this.cazctlcnt + 1;
                    rptsection = blanksection;
                }
                ++i;
            }
        } else {
            this.cazctl = String.valueOf(this.cazctl) + rptsection + " \r";
            this.cazctlcnt = this.cazctlcnt + 1;
        }
    }

    private void buildModelReportCards(String section, String rptid) {
        ReportsModel report = CorePlugin.getDefault().reports.get(CorePlugin.getDefault().reportId.indexOf(rptid));
        String blanksection = "           ";
        String rptsection = "SECTION " + rptid;
        String[] options = report.optionprefs.split(",");
        int i = 0;
        while (i < options.length) {
            if (options[i].length() > 0) {
                if (CorePlugin.getDefault().versionextension.chkReportOptions(section, rptid, options[i])) {
                    this.cazctl = String.valueOf(this.cazctl) + rptsection + " " + options[i] + "\r";
                    this.cazctlcnt = this.cazctlcnt + 1;
                    rptsection = blanksection;
                }
            } else {
                this.cazctl = String.valueOf(this.cazctl) + rptsection + " \r";
                this.cazctlcnt = this.cazctlcnt + 1;
            }
            ++i;
        }
    }

    public void persistReportOptions(String rptid, String src) {
        String optionsFName = "";
        String rptoptions = "";
        ReportsModel report = null;
        try {
            optionsFName = String.valueOf(CorePlugin.getDefault().productextension.getReportsFolder()) + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + this.obsReqnum + File.separator + Platform.getNL() + File.separator + rptid + "-options.txt";
            IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
            CorePlugin.getDefault();
            File optionsFile = new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + optionsFName);
            optionsFile.getParentFile().mkdirs();
            try {
                report = CorePlugin.getDefault().reports.get(CorePlugin.getDefault().reportId.indexOf(rptid));
            }
            catch (Exception exception) {
                return;
            }
            BufferedWriter outOptions = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(optionsFile), "UTF-8"));
            if (src.equals("model")) {
                rptoptions = report.optionprefs;
                if (rptoptions.length() > 0) {
                    rptoptions = rptoptions.substring(0, rptoptions.length());
                }
                report = null;
            } else {
                rptoptions = CorePlugin.getDefault().getPreferenceStore().getString(rptid);
            }
            outOptions.write(rptoptions);
            ((Writer)outOptions).flush();
            ((Writer)outOptions).close();
            optionsFile = null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException e) {
            String logstr = "persistReportOptions: Exception persisting z/OS dataspace " + optionsFName + ". " + e;
            System.out.println("ReportControlCards " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }
}

