/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.data.reports;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.data.ObservationDetail;
import com.banknet.core.data.StcProperties;
import com.banknet.core.data.TokensList;
import com.banknet.core.data.reports.Messages;
import com.banknet.core.data.reports.ReportControlCards;
import com.banknet.core.data.reports.ReportPdfParser;
import com.banknet.core.data.reports.ReportPvmlParser;
import com.banknet.core.data.reports.ReportSqlParser;
import com.banknet.core.data.reports.ReportXmlParser;
import com.banknet.core.internal.Constants;
import com.banknet.core.models.ObservationsModel;
import com.banknet.core.models.ReportsModel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ObservationReports {
    Constants constants = new Constants();
    ZosConnect zosconnect = new ZosConnect();
    StcProperties stcproperties;
    TokensList tokenslist = new TokensList();
    public ReportControlCards ccards = new ReportControlCards();
    ByteBuffer bbRespBuffer;
    byte[] bRespBuffer;
    public ObservationsModel obs;
    public List<String> reqnums;
    PrintStream sysout = null;
    int zosOffset = 0;
    boolean db2Report = false;
    public boolean detailReport = false;
    String rpttyp = "";
    public String lcmdopt = "";
    public String spmrptid = "";
    String cookieDefault = "00000000";
    String closereqnum = "";
    String closereqcookie = "";
    int maxCookies = 1;
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);
    String errmsg = "";
    public List<String> multiaddrdsns = new ArrayList<String>();
    public List<String> variancedsns = new ArrayList<String>();
    int reqcnt = 0;
    int curreq = 0;
    String[] reqarr;
    public String rptid = "";
    int reqnum = 0;
    public String rptformat = "";
    String sreqnum = "";
    public String detailoffset = "";
    public String cookie = "";
    String rptcat = "";
    String fcname = "";
    String dataspacefname = "";
    public List<String> saveReportFnames;
    public String saveReportFname = "";
    public int getobsrc = 0;
    public String getobsrsn = "";

    public ObservationReports() {
        this.stcproperties = CorePlugin.getDefault().getStcProperties();
        if (CorePlugin.getDefault().session.maxCookies > 0) {
            this.maxCookies = CorePlugin.getDefault().session.maxCookies;
        }
    }

    public void getObsReports(String rptformat, List reqnums) {
        this.reqnums = reqnums;
        this.rptformat = rptformat;
        if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") < 0) {
            this.showMessage("info", Messages.getString("ObservationReports.MessageDialog.infoTitle.DownloadReports"), Messages.getString("ObservationReports.MessageDialog.infoMessage.RemoteConnectionReqd"));
        } else if (!CorePlugin.getDefault().versionextension.chkDownloadReports()) {
            this.showMessage("error", Messages.getString("ObservationReports.MessageDialog.infoTitle.DownloadReports"), CorePlugin.getDefault().versionextension.getMessageText());
        } else {
            this.runPingObsReports();
        }
    }

    public void runPingObsReports() {
        Job job0 = new Job(Messages.getString("ObservationReports.Job.Title.PingApa")){

            public IStatus run(IProgressMonitor monitor) {
                System.out.println("Ping GetObsReports");
                CorePlugin.getDefault().session.monitor = monitor;
                monitor.beginTask(Messages.getString("ObservationReports.Job.Monitor.Ping"), 100);
                ObservationReports.this.zosconnect.pingZos(monitor);
                if (ObservationReports.this.zosconnect.getConnectRc() != 0) {
                    return Status.CANCEL_STATUS;
                }
                String[] reqarr = ObservationReports.this.reqnums.get(0).split(",");
                int reqnum = new Integer(reqarr[0]);
                try {
                    ObservationDetail obsdetail = new ObservationDetail();
                    obsdetail.getObservationDetail(reqnum, monitor);
                    if (CorePlugin.getDefault().session.getReturnCode() != 0) {
                        return Status.CANCEL_STATUS;
                    }
                }
                catch (Exception ex) {
                    System.out.println("ObservationReports Ping runObservationDetail Exception: " + ex);
                    return Status.CANCEL_STATUS;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job0.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("Job completed successfully");
                } else {
                    System.out.println("Job did not complete successfully");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("Request ping rc is " + (this).ObservationReports.this.zosconnect.getConnectRc());
                        if (CorePlugin.getDefault().session.getReturnCode() != 0) {
                            ObservationReports.this.showMessage("info", Messages.getString("ObservationReports.MessageDialog.infoTitle.ReportsDownload"), String.valueOf(Messages.getString("ObservationReports.MessageDialog.errorMessage.DownloadFailed")) + CorePlugin.getDefault().session.getReason());
                        } else if ((this).ObservationReports.this.zosconnect.getConnectRc() == 0) {
                            ObservationReports.this.runGetObsReports();
                        } else {
                            ObservationReports.this.showMessage("info", String.valueOf(Messages.getString("ObservationReports.MessageDialog.infoTitle.Zos")) + CorePlugin.getDefault().productextension.getProductName() + Messages.getString("ObservationReports.MessageDialog.infoTitle.ConnectionLost"), String.valueOf(Messages.getString("ObservationReports.MessageDialog.infoMessage.RemoteConnectionLost")) + Messages.getString("ObservationReports.Messaging.ReConnect"));
                            (this).ObservationReports.this.zosconnect.setConnectLocal();
                        }
                    }
                });
            }
        });
        job0.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job0.schedule();
    }

    public void runGetObsReports() {
        Job downloadJob = new Job(Messages.getString("ObservationReports.Job.Title.DownloadingReports")){

            public IStatus run(IProgressMonitor monitor) {
                ObservationReports.this.reqcnt = ObservationReports.this.reqnums.size();
                ObservationReports.this.curreq = 0;
                ObservationReports.this.rptid = "";
                ObservationReports.this.reqnum = 0;
                ObservationReports.this.sreqnum = "";
                ObservationReports.this.detailoffset = "";
                CorePlugin.getDefault().session.monitor = monitor;
                int i = 0;
                while (i < ObservationReports.this.reqcnt) {
                    ObservationReports.this.initObsReports(monitor, i);
                    ObservationReports.this.ccards.obs = ObservationReports.this.obs;
                    ObservationReports.this.ccards.obsReqnum = ObservationReports.this.reqnum;
                    ObservationReports.this.ccards.obsDsname = ObservationReports.this.obs.dsname;
                    ObservationReports.this.ccards.lcmdopt = ObservationReports.this.lcmdopt;
                    ObservationReports.this.ccards.rptformat = ObservationReports.this.rptformat;
                    ObservationReports.this.ccards.multiaddrdsns = ObservationReports.this.multiaddrdsns;
                    ObservationReports.this.ccards.variancedsns = ObservationReports.this.variancedsns;
                    ObservationReports.this.ccards.wasServantSampling = ObservationReports.this.obs.wasServantSampling;
                    ObservationReports.this.ccards.wasServantObsDsname = ObservationReports.this.obs.wasServantObsDsname;
                    ObservationReports.this.ccards.importedObservation = ObservationReports.this.obs.importedObservation;
                    ObservationReports.this.ccards.buildControlCards(ObservationReports.this.rptid, ObservationReports.this.detailoffset, ObservationReports.this.cookie);
                    ObservationReports.this.parseRemoteReports(monitor, ObservationReports.this.sreqnum);
                    if (CorePlugin.getDefault().session.getReturnCode() != 0) {
                        this.setName("");
                        if (ObservationReports.this.rptid.length() > 0) {
                            CorePlugin.getDefault().getPreferenceStore().setValue("reportDetail", ObservationReports.this.reqnums.get(i));
                        } else {
                            CorePlugin.getDefault().getPreferenceStore().setValue("obsReports", ObservationReports.this.reqnums.get(i));
                        }
                        ObservationReports.this.getobsrc = CorePlugin.getDefault().session.getReturnCode();
                        ObservationReports.this.getobsrsn = CorePlugin.getDefault().session.getReason();
                        if (ObservationReports.this.getobsrsn.startsWith(CorePlugin.getDefault().productextension.getZosProductId())) {
                            ObservationReports.this.getobsrsn = ObservationReports.this.getobsrsn.substring(ObservationReports.this.getobsrsn.indexOf(" ") + 1, ObservationReports.this.getobsrsn.length());
                        }
                        ObservationReports.this.runCloseObsReports(ObservationReports.this.sreqnum, monitor);
                        return Status.CANCEL_STATUS;
                    }
                    ObservationReports.this.setObsReports(monitor, i);
                    monitor.worked(100);
                    if (monitor.isCanceled()) {
                        this.setName("");
                        return Status.CANCEL_STATUS;
                    }
                    ++i;
                }
                monitor.done();
                this.setName("");
                return Status.OK_STATUS;
            }
        };
        downloadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                event.getResult().isOK();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).ObservationReports.this.getobsrc == 0 || (this).ObservationReports.this.getobsrc == -98) {
                            if (((this).ObservationReports.this.rptformat.equals((this).ObservationReports.this.constants.REPORT_FORMAT_JSON) | (this).ObservationReports.this.rptformat.equals((this).ObservationReports.this.constants.REPORT_FORMAT_XML)) & CorePlugin.getDefault().getPreferenceStore().getBoolean("launchXml")) {
                                ObservationReports.this.runLaunchProgram();
                            } else if ((this).ObservationReports.this.rptformat.equals((this).ObservationReports.this.constants.REPORT_FORMAT_PDF) & CorePlugin.getDefault().getPreferenceStore().getBoolean("launchPdf")) {
                                ObservationReports.this.runLaunchProgram();
                            }
                        } else if ((this).ObservationReports.this.getobsrc == -99) {
                            ObservationReports.this.showMessage("info", Messages.getString("ObservationReports.MessageDialog.infoTitle.DownloadReports"), String.valueOf(Messages.getString("ObservationReports.MessageDialog.infoMessage.RemoteConnectionClosed")) + Messages.getString("ObservationReports.Messaging.ReConnect"));
                            (this).ObservationReports.this.zosconnect.setConnectLocal();
                        } else if ((this).ObservationReports.this.getobsrc == 13) {
                            ObservationReports.this.showMessage("error", Messages.getString("ObservationReports.MessageDialog.errorTitle.DownloadReports"), String.valueOf(Messages.getString("ObservationReports.MessageDialog.errorMessage.ReportsDownloadFor")) + (this).ObservationReports.this.obs.reqnum + Messages.getString("ObservationReports.MessageDialog.errorMessage.FailedCheckApa") + (this).ObservationReports.this.getobsrsn);
                        } else {
                            ObservationReports.this.showMessage("error", Messages.getString("ObservationReports.MessageDialog.errorTitle.DownloadReports"), String.valueOf(Messages.getString("ObservationReports.MessageDialog.errorMessage.ReportsDownloadFor2")) + (this).ObservationReports.this.obs.reqnum + Messages.getString("ObservationReports.MessageDialog.errorMessage.Failed") + (this).ObservationReports.this.getobsrsn);
                        }
                    }
                });
            }
        });
        downloadJob.setRule(CorePlugin.getDefault().schedrule);
        downloadJob.setUser(true);
        downloadJob.setPriority(20);
        downloadJob.schedule();
    }

    private void initObsReports(IProgressMonitor monitor, int obsidx) {
        ++this.curreq;
        this.reqarr = this.reqnums.get(obsidx).split(",");
        this.reqnum = new Integer(this.reqarr[0]);
        this.sreqnum = this.reqarr[0];
        this.rptid = "";
        if (this.saveReportFnames != null && this.saveReportFnames.size() > 0) {
            this.saveReportFname = this.saveReportFnames.get(obsidx);
        }
        this.getobsrc = 0;
        this.getobsrsn = "";
        this.lcmdopt = "";
        if (this.reqarr.length > 1) {
            this.rptid = this.reqarr[1];
        }
        if (this.reqarr.length > 2) {
            this.detailoffset = this.reqarr[2];
            this.detailReport = true;
        }
        if (this.reqarr.length > 3) {
            this.lcmdopt = this.reqarr[3];
            this.spmrptid = this.rptid;
        }
        if (this.detailReport) {
            CorePlugin.getDefault().getPreferenceStore().setValue("reportDetail", "");
            IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
            CorePlugin.getDefault();
            File tmpfile = new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + this.reqnum + File.separator + Platform.getNL() + File.separator + this.rptid + "-detail.txt");
            if (tmpfile.exists()) {
                tmpfile.delete();
            }
            IPreferenceStore iPreferenceStore2 = CorePlugin.getDefault().getPreferenceStore();
            CorePlugin.getDefault();
            tmpfile = new File(String.valueOf(iPreferenceStore2.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + this.reqnum + File.separator + Platform.getNL() + File.separator + this.rptid + "-detailbase.txt");
            if (tmpfile.exists()) {
                tmpfile.delete();
            }
            if (this.lcmdopt.equals(this.constants.REPORT_LCMD_DB2EXPLAIN)) {
                IPreferenceStore iPreferenceStore3 = CorePlugin.getDefault().getPreferenceStore();
                CorePlugin.getDefault();
                this.saveReportFname = String.valueOf(iPreferenceStore3.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + this.reqnum + File.separator + Platform.getNL() + File.separator + this.rptid + "-db2.txt";
                tmpfile = new File(this.saveReportFname);
                if (tmpfile.exists()) {
                    tmpfile.delete();
                }
            }
        } else {
            CorePlugin.getDefault().getPreferenceStore().setValue("obsReports", "");
        }
        this.obs = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(this.reqnum));
        monitor.beginTask(String.valueOf(Messages.getString("ObservationReports.Job.Monitor.Downloading")) + this.curreq + Messages.getString("ObservationReports.Job.Monitor.Of") + this.reqcnt + Messages.getString("ObservationReports.Job.Monitor.ReportsForObservation") + this.sreqnum + " ...", 100);
        if (this.variancedsns.size() > 0) {
            this.runCloseObsReports(this.sreqnum, monitor);
        }
        this.cookie = this.getCookie(CorePlugin.getDefault().constants.reqdecfmt.format(this.obs.reqnum), monitor);
        this.rptcat = "";
        if (this.rptid.length() > 0) {
            this.rptcat = this.rptid.substring(0, 1);
        }
        if (this.rptcat.equalsIgnoreCase(this.constants.REPORT_CATEGORY_MULTIADDR) | this.multiaddrdsns.size() > 0) {
            this.cookie = this.getDsns(this.cookie, this.sreqnum, "multiaddrdsns", monitor);
        }
    }

    public void parseRemoteReports(IProgressMonitor monitor, String sreqnum) {
        monitor.subTask(Messages.getString("ObservationReports.Job.Monitor.Step1of3"));
        String systemName = this.obs.validateSystem;
        boolean secureImport = this.stcproperties.PABENT_FLAGS3_SecImp;
        boolean importedObservation = this.obs.importedObservation;
        if (importedObservation && !secureImport) {
            systemName = CorePlugin.getDefault().hostproperties.sSystemName;
        }
        System.out.println("System Name : " + systemName);
        System.out.println("Secure Import : " + secureImport);
        System.out.println("ImportedObservation : " + importedObservation);
        String[] commandarr = new String[]{String.valueOf(this.constants.ZOSMESSAGE_GETOBSREPORTS) + " " + this.cookie + "," + this.obs.ownedby + "," + systemName + "," + CorePlugin.getDefault().activeStc + "," + sreqnum + ",," + "," + this.ccards.cazctlcnt + "," + "|" + this.ccards.cazctl + "|"};
        String logstr = "parseRemoteReports:  Running " + commandarr[0];
        System.out.println("ObservationReports - " + logstr);
        CorePlugin.getDefault().log.debug(logstr);
        monitor.worked(1);
        CorePlugin.getDefault().session.monitor = monitor;
        CorePlugin.getDefault().session.runGetObsReports(commandarr[0]);
        CorePlugin.getDefault().session.checkResponse();
        if (CorePlugin.getDefault().session.getReturnCode() == 13) {
            return;
        }
        if (CorePlugin.getDefault().session.getReturnCode() == -98 | CorePlugin.getDefault().session.getReturnCode() == -99) {
            return;
        }
        if (CorePlugin.getDefault().session.getReturnCode() != 0) {
            return;
        }
        if (this.bbRespBuffer != null) {
            this.bbRespBuffer.clear();
        }
        IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
        CorePlugin.getDefault();
        this.fcname = String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getProductFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + "GETOBSREPORTS.txt";
        if (CorePlugin.getDefault().session.getDescriptor() == 20) {
            this.parseSql(monitor);
        } else if (this.rptformat.equals(this.constants.REPORT_FORMAT_PVML)) {
            this.parsePvml(monitor);
        } else if (this.rptformat.equals(this.constants.REPORT_FORMAT_XML)) {
            this.parseXml(monitor);
        } else if (this.rptformat.equals(this.constants.REPORT_FORMAT_JSON)) {
            this.parseXml(monitor);
        } else if (this.rptformat.equals(this.constants.REPORT_FORMAT_PDF)) {
            this.parsePdf(monitor);
        }
        this.bbRespBuffer = null;
        System.gc();
        System.runFinalization();
    }

    private void parsePvml(IProgressMonitor monitor) {
        String logstr;
        FileChannel fc = null;
        ReportPvmlParser pvmlparser = new ReportPvmlParser();
        pvmlparser.reqnum = this.obs.reqnum;
        pvmlparser.spmrptid = this.spmrptid;
        pvmlparser.detailReport = this.detailReport;
        try {
            fc = new FileInputStream(new File(this.fcname)).getChannel();
            if (pvmlparser.bbRespBuffer != null) {
                pvmlparser.bbRespBuffer.clear();
            }
            pvmlparser.bbRespBuffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
        }
        catch (OutOfMemoryError oem) {
            logstr = "parsePvml: parsePvml out of memory exception mapping file " + this.fcname + " error: " + oem;
            System.out.println("ObservationReports " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        catch (Exception exception) {}
        if (CorePlugin.getDefault().getPreferenceStore().getBoolean("saveZosDataspace")) {
            this.persistDataspace();
        }
        try {
            fc.close();
            fc = null;
        }
        catch (Exception e) {
            logstr = "parsePvml: Exception closing file " + this.fcname + ". " + e;
            System.out.println("ObservationReports " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        try {
            pvmlparser.parseReports(monitor);
        }
        catch (OutOfMemoryError oem) {
            logstr = "parsePvml: parsePvml out of memory exception in parseReports. " + oem;
            System.out.println("ObservationReports " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (Exception ex) {
            logstr = "parsePvml: parsePvml exception in parseReports. " + ex;
            System.out.println("ObservationReports " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        pvmlparser = null;
    }

    private void parseXml(IProgressMonitor monitor) {
        String logstr;
        FileChannel fc = null;
        ReportXmlParser xmlparser = new ReportXmlParser();
        xmlparser.xmlfname = this.saveReportFname;
        try {
            fc = new FileInputStream(new File(this.fcname)).getChannel();
            if (xmlparser.bbRespBuffer != null) {
                xmlparser.bbRespBuffer.clear();
            }
            xmlparser.bbRespBuffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
        }
        catch (OutOfMemoryError oem) {
            logstr = "parseXml: parseXml out of memory exception mapping file " + this.fcname + " error: " + oem;
            System.out.println("ObservationReports " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        catch (Exception exception) {}
        if (CorePlugin.getDefault().getPreferenceStore().getBoolean("saveZosDataspace")) {
            this.persistDataspace();
        }
        try {
            fc.close();
            fc = null;
        }
        catch (Exception e) {
            logstr = "parseXml: Exception closing file " + this.fcname + ". " + e;
            System.out.println("ObservationReports " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        try {
            xmlparser.parseReports(monitor);
        }
        catch (OutOfMemoryError oem) {
            logstr = "parseXml: parseXml out of memory exception in parseReports. " + oem;
            System.out.println("ObservationReports " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        catch (Exception ex) {
            logstr = "parseXml: parseXml exception in parseReports. " + ex;
            System.out.println("ObservationReports " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        xmlparser = null;
    }

    private void parsePdf(IProgressMonitor monitor) {
        String logstr;
        FileChannel fc = null;
        ReportPdfParser pdfparser = new ReportPdfParser();
        pdfparser.pdffname = this.saveReportFname;
        try {
            fc = new FileInputStream(new File(this.fcname)).getChannel();
            if (pdfparser.bbRespBuffer != null) {
                pdfparser.bbRespBuffer.clear();
            }
            pdfparser.bbRespBuffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
        }
        catch (OutOfMemoryError oem) {
            logstr = "parsePdf: parsePdf out of memory exception mapping file " + this.fcname + " error: " + oem;
            System.out.println("ObservationReports " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        catch (Exception exception) {}
        if (CorePlugin.getDefault().getPreferenceStore().getBoolean("saveZosDataspace")) {
            this.persistDataspace();
        }
        try {
            fc.close();
            fc = null;
        }
        catch (Exception e) {
            logstr = "parsePdf: Exception closing file " + this.fcname + ". " + e;
            System.out.println("ObservationReports " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        try {
            pdfparser.parseReports(monitor);
        }
        catch (OutOfMemoryError oem) {
            logstr = "parsePdf: parsePdf out of memory exception in parseReports. " + oem;
            System.out.println("ObservationReports " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        catch (Exception ex) {
            logstr = "parsePdf: parsePdf exception in parseReports. " + ex;
            System.out.println("ObservationReports " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        pdfparser = null;
    }

    private void parseSql(IProgressMonitor monitor) {
        String logstr;
        FileChannel fc = null;
        ReportSqlParser sqlparser = new ReportSqlParser();
        sqlparser.sqlfname = this.saveReportFname;
        try {
            fc = new FileInputStream(new File(this.fcname)).getChannel();
            if (sqlparser.bbRespBuffer != null) {
                sqlparser.bbRespBuffer.clear();
            }
            sqlparser.bbRespBuffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
        }
        catch (OutOfMemoryError oem) {
            logstr = "parseSql: parseSql out of memory exception mapping file " + this.fcname + " error: " + oem;
            System.out.println("ObservationReports " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        catch (Exception exception) {}
        if (CorePlugin.getDefault().getPreferenceStore().getBoolean("saveZosDataspace")) {
            this.persistDataspace();
        }
        try {
            fc.close();
            fc = null;
        }
        catch (Exception e) {
            logstr = "parseSql: Exception closing file " + this.fcname + ". " + e;
            System.out.println("ObservationReports " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        try {
            sqlparser.parseReports(monitor);
        }
        catch (OutOfMemoryError oem) {
            logstr = "parseSql: parseSql out of memory exception in parseReports. " + oem;
            System.out.println("ObservationReports " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            sqlparser = null;
        }
        catch (Exception ex) {
            logstr = "parseSql: parseSql exception in parseReports. " + ex;
            System.out.println("ObservationReports " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            sqlparser = null;
        }
    }

    private void persistDataspace() {
        String fullFName = String.valueOf(CorePlugin.getDefault().productextension.getReportsFolder()) + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + this.obs.reqnum + File.separator + this.obs.reqnum + "-zosDataspace.txt";
        try {
            IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
            CorePlugin.getDefault();
            File filefrom = new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getProductFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + "GETOBSREPORTS.txt");
            FileChannel srcChannel = new FileInputStream(filefrom).getChannel();
            IPreferenceStore iPreferenceStore2 = CorePlugin.getDefault().getPreferenceStore();
            CorePlugin.getDefault();
            File fileto = new File(String.valueOf(iPreferenceStore2.getString("coreDataPath")) + fullFName);
            fileto.getParentFile().mkdirs();
            FileChannel dstChannel = new FileOutputStream(fileto).getChannel();
            int maxCount = 67076096;
            long size = srcChannel.size();
            long position = 0L;
            while (position < size) {
                position += srcChannel.transferTo(position, maxCount, dstChannel);
            }
            srcChannel.close();
            dstChannel.close();
        }
        catch (IOException e) {
            String logstr = "persistDataspace: Exception persisting z/OS dataspace " + fullFName + ". " + e;
            System.out.println("ObservationReports " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    private void setObsReports(IProgressMonitor monitor, int obsidx) {
        if (this.rptid.length() > 0) {
            this.ccards.persistReportOptions(this.rptid, "model");
        } else if (this.multiaddrdsns.size() > 0) {
            this.persistDsns("multiaddrdsns");
        }
        if (this.rptformat.equals(this.constants.REPORT_FORMAT_PVML)) {
            this.obs.setReportsAvail(true);
        }
        if (this.detailoffset.length() > 0) {
            CorePlugin.getDefault().getPreferenceStore().setValue("reportDetail", this.reqnums.get(obsidx));
        } else {
            CorePlugin.getDefault().getPreferenceStore().setValue("obsReports", this.reqnums.get(obsidx));
        }
        if (this.variancedsns.size() > 0 || this.rptformat.equals(this.constants.REPORT_FORMAT_XML) || this.rptformat.equals(this.constants.REPORT_FORMAT_JSON) || this.rptformat.equals(this.constants.REPORT_FORMAT_PDF)) {
            this.runCloseObsReports(this.sreqnum, monitor);
        }
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            CorePlugin.getDefault().getWorkbench().getDisplay();
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
        } else {
            CorePlugin.getDefault().getWorkbench().getDisplay();
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
        }
    }

    public void runDeleteObsReports() {
        CorePlugin.getDefault().getPreferenceStore().setValue("obsReports", "");
        Job deleteJob = new Job(Messages.getString("ObservationReports.Job.Title.DeletingReports")){

            public IStatus run(IProgressMonitor monitor) {
                int reqcnt = ObservationReports.this.reqnums.size();
                int curreq = 0;
                int reqnum = 0;
                CorePlugin.getDefault().session.monitor = monitor;
                int i = 0;
                while (i < reqcnt) {
                    reqnum = new Integer(ObservationReports.this.reqnums.get(i));
                    monitor.beginTask(String.valueOf(Messages.getString("ObservationReports.Job.Monitor.Deleting")) + ++curreq + Messages.getString("ObservationReports.Job.Monitor.Of") + reqcnt + Messages.getString("ObservationReports.Job.Monitor.ReportsForObservation") + ObservationReports.this.reqnums.get(i) + " ...", 100);
                    try {
                        IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
                        CorePlugin.getDefault();
                        File dir = new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + ObservationReports.this.reqnums.get(i) + File.separator + Platform.getNL() + File.separator);
                        File[] files = dir.listFiles();
                        if (files != null) {
                            int ii = 0;
                            while (ii < files.length) {
                                files[ii].delete();
                                ++ii;
                            }
                            dir.delete();
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.toString());
                    }
                    if (CorePlugin.getDefault().observationId.indexOf(reqnum) >= 0) {
                        try {
                            ObservationReports.this.obs = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(reqnum));
                            ObservationReports.this.obs.setReportsAvail(false);
                        }
                        catch (Exception exception) {}
                    }
                    CorePlugin.getDefault().getPreferenceStore().setValue("obsReports", ObservationReports.this.reqnums.get(i));
                    monitor.worked(100);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    ++i;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        deleteJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                event.getResult().isOK();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(CorePlugin.getDefault().session.getReturnCode() == 0 | CorePlugin.getDefault().session.getReturnCode() == -99)) {
                            ObservationReports.this.showMessage("error", Messages.getString("ObservationReports.MessageDialog.errorTitle.DeleteReports"), String.valueOf(Messages.getString("ObservationReports.MessageDialog.errorMessage.ReportsDeleteFor")) + (this).ObservationReports.this.obs.reqnum + Messages.getString("ObservationReports.MessageDialog.errorMessage.ReportsDeleteFailed") + CorePlugin.getDefault().session.getReason());
                            String logstr = "runDeleteObsReports:  Reports Delete for " + (this).ObservationReports.this.obs.reqnum + " failed.  " + CorePlugin.getDefault().session.getReason();
                            System.out.println("ObservationReports - " + logstr);
                            CorePlugin.getDefault().log.debug(logstr);
                        }
                    }
                });
            }
        });
        deleteJob.schedule();
    }

    public String getCookie(String reqnum, IProgressMonitor monitor) {
        String[] cookieArr;
        List<Object> tokens = new ArrayList();
        try {
            this.tokenslist.getTokensList(monitor);
            tokens = this.tokenslist.tokensList;
        }
        catch (Exception e) {
            String logstr = "getCookie Exception: " + e;
            System.out.println("ObservationReports - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        int i = 0;
        while (i < tokens.size()) {
            cookieArr = ((String)tokens.get(i)).split(";");
            if (cookieArr[1].equals(CorePlugin.getDefault().activeStc) & cookieArr[2].equals(reqnum)) {
                return cookieArr[3];
            }
            ++i;
        }
        if (tokens.size() >= this.maxCookies) {
            cookieArr = ((String)tokens.get(0)).split(";");
            this.runCloseObsReports(cookieArr[2], monitor);
        }
        return this.cookieDefault;
    }

    public void runCloseObsReports(String sreqnum, IProgressMonitor monitor) {
        List<Object> tokens = new ArrayList();
        String reqnum = sreqnum;
        this.closereqnum = "";
        int curreq = 0;
        String logstr = "runCloseObsReports:  Start ";
        System.out.println("ObservationReports - " + logstr);
        CorePlugin.getDefault().log.debug(logstr);
        try {
            this.tokenslist.getTokensList(monitor);
            tokens = this.tokenslist.tokensList;
        }
        catch (Exception e) {
            logstr = "runCloseObsReports Exception: " + e;
            System.out.println("ObservationReports - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            return;
        }
        int i = 0;
        while (i < tokens.size()) {
            ++curreq;
            String[] cookieArr = ((String)tokens.get(i)).split(";");
            this.closereqnum = cookieArr[2];
            this.closereqcookie = cookieArr[3];
            if (reqnum.equals("*") || reqnum.equals(this.closereqnum)) {
                monitor.subTask(String.valueOf(Messages.getString("ObservationReports.Job.Monitor.Closing")) + curreq + Messages.getString("ObservationReports.Job.Monitor.Of") + tokens.size() + Messages.getString("ObservationReports.Job.Monitor.ReportsForObservation") + this.closereqnum + " ...");
                String[] commandarr = new String[]{String.valueOf(this.constants.ZOSMESSAGE_CLOSEOBSREPORTS) + " " + this.closereqcookie};
                logstr = "runCloseObsReports:  Running " + commandarr[0] + " for reqnum " + this.closereqnum + ", cookie " + this.closereqcookie;
                System.out.println("ObservationReports - " + logstr);
                CorePlugin.getDefault().log.debug(logstr);
                CorePlugin.getDefault().session.doCmdResp(commandarr[0], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
                if (CorePlugin.getDefault().session.getReturnCode() < 1000 && CorePlugin.getDefault().session.getReturnCode() != 0) {
                    logstr = "runCloseObsReports:  error RC - " + CorePlugin.getDefault().session.getReturnCode();
                    System.out.println("ObservationReports - " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                    return;
                }
                CorePlugin.getDefault().session.checkResponse();
                if (CorePlugin.getDefault().session.getReturnCode() != 0) {
                    logstr = "runCloseObsReports:  error RC - " + CorePlugin.getDefault().session.getReturnCode();
                    System.out.println("ObservationReports - " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                    return;
                }
                if (reqnum.equals(this.closereqnum)) break;
            }
            ++i;
        }
    }

    public void persistDsns(String dsnstype) {
        String dsnsFName = "";
        String dsns = "";
        try {
            dsnsFName = String.valueOf(CorePlugin.getDefault().productextension.getReportsFolder()) + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + this.obs.reqnum + File.separator + Platform.getNL() + File.separator + dsnstype + ".txt";
            IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
            CorePlugin.getDefault();
            File dsnsFile = new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + dsnsFName);
            dsnsFile.getParentFile().mkdirs();
            BufferedWriter outDsns = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dsnsFile), "UTF-8"));
            if (dsnstype.equalsIgnoreCase("multiaddrdsns") && this.multiaddrdsns.size() > 0) {
                dsns = this.multiaddrdsns.toString();
            } else if (dsnstype.equalsIgnoreCase("variancedsns") && this.variancedsns.size() > 0) {
                dsns = this.variancedsns.toString();
            }
            if (dsns.length() > 0) {
                dsns = dsns.replace("[", "");
                dsns = dsns.replace("]", "");
            }
            outDsns.write(dsns);
            ((Writer)outDsns).flush();
            ((Writer)outDsns).close();
            dsnsFile = null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException e) {
            String logstr = "persistDsns: Exception persisting Dsns " + dsnsFName + ". " + e;
            System.out.println("ObservationReports " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    public String getDsns(String cookie, String sreqnum, String dsnstype, IProgressMonitor monitor) {
        ArrayList<String> dsnslist = new ArrayList<String>();
        String dsns = "";
        String dsnsFName = String.valueOf(CorePlugin.getDefault().productextension.getReportsFolder()) + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + this.obs.reqnum + File.separator + Platform.getNL() + File.separator + dsnstype + ".txt";
        IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
        CorePlugin.getDefault();
        File dsnsFile = new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + dsnsFName);
        if (dsnsFile.exists()) {
            BufferedReader rddsns = null;
            try {
                rddsns = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dsnsFile.getAbsolutePath()), "UTF-8"));
                dsns = rddsns.readLine();
                if (dsns.length() > 0) {
                    String[] dsnsarr = dsns.split(",");
                    int i = 0;
                    while (i < dsnsarr.length) {
                        dsnslist.add(dsnsarr[i]);
                        ++i;
                    }
                }
                rddsns.close();
                dsnsFile = null;
            }
            catch (IOException iOException) {}
        }
        if (!cookie.equals(this.cookieDefault)) {
            this.runCloseObsReports(sreqnum, monitor);
            cookie = this.cookieDefault;
        }
        if (dsnstype.equalsIgnoreCase("multiaddrdsns")) {
            this.multiaddrdsns = dsnslist;
        } else if (dsnstype.equalsIgnoreCase("variancedsns")) {
            this.variancedsns = dsnslist;
        }
        return cookie;
    }

    public void runLaunchProgram() {
        Job job0 = new Job(Messages.getString("ObservationReports.Job.Title.OpenFile")){

            public IStatus run(IProgressMonitor monitor) {
                System.out.println("Launching default file viewer");
                monitor.beginTask(Messages.getString("ObservationReports.Job.Monitor.OpenFile"), 100);
                monitor.subTask(Messages.getString("ObservationReports.Job.Monitor.OpenFile"));
                try {
                    String launchext = ObservationReports.this.saveReportFname.substring(ObservationReports.this.saveReportFname.lastIndexOf(".") + 1).toLowerCase();
                    if (launchext.contains("htm")) {
                        File launchFile = new File(ObservationReports.this.saveReportFname);
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(launchFile.toURI().toURL());
                    } else {
                        Program.launch((String)ObservationReports.this.saveReportFname);
                    }
                }
                catch (Exception exception) {}
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job0.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
            }
        });
        job0.setUser(true);
        job0.schedule();
    }

    public void buildControlCards(List<ReportsModel> selreports) {
        String rptid = "";
        String detailoffset = "";
        this.ccards.obs = this.obs;
        this.ccards.obsReqnum = this.obs.reqnum;
        this.ccards.obsDsname = this.obs.dsname;
        this.ccards.lcmdopt = this.lcmdopt;
        this.ccards.rptformat = this.rptformat;
        this.ccards.multiaddrdsns = this.multiaddrdsns;
        this.ccards.variancedsns = this.variancedsns;
        this.ccards.wasServantSampling = this.obs.wasServantSampling;
        this.ccards.wasServantObsDsname = this.obs.wasServantObsDsname;
        this.ccards.importedObservation = this.obs.importedObservation;
        if (selreports.size() > 0) {
            this.ccards.selreports = selreports;
        }
        this.ccards.buildControlCards(rptid, detailoffset, this.cookie);
    }
}

