/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.data;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.data.ParseUtilities;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.ZosSession;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class TokensList {
    public List<String> tokensList;
    public byte[] bRespBuffer;
    public ByteBuffer bbRespBuffer;
    Constants constants = new Constants();
    ZosConnect zosconnect = new ZosConnect();
    ParseUtilities parseUtilities = new ParseUtilities();

    public void getTokensList(IProgressMonitor monitor) throws Exception {
        this.tokensList = new ArrayList<String>();
        this.getRemoteTokensList(monitor);
    }

    public void getRemoteTokensList(IProgressMonitor monitor) throws Exception {
        String[] commandarr = new String[]{this.constants.ZOSMESSAGE_GETOBSREPTOKNS};
        String logstr = "getRemoteTokensList:  Running " + commandarr[0];
        System.out.println("TokensList - " + logstr);
        CorePlugin.getDefault().log.debug(logstr);
        this.bRespBuffer = CorePlugin.getDefault().session.doCmdResp(commandarr[0], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
        CorePlugin.getDefault().session.checkResponse();
        if (CorePlugin.getDefault().session.getReturnCode() >= 1000) {
            logstr = "getRemoteTokensList:  Connect error " + CorePlugin.getDefault().session.getReturnCode() + ", set connect local";
            System.out.println("TokensList - " + logstr);
            CorePlugin.getDefault().log.debug(logstr);
            return;
        }
        if (CorePlugin.getDefault().session.getReturnCode() != 0) {
            logstr = "getRemoteTokensList: error RC - " + CorePlugin.getDefault().session.getReturnCode();
            System.out.println("TokensList - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            return;
        }
        this.bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        if (this.bbRespBuffer.limit() <= 0) {
            return;
        }
        this.parseTokensList();
    }

    public void parseTokensList() throws Exception {
        ZosSession cfr_ignored_0 = CorePlugin.getDefault().session;
        short payloadDescriptor = this.bbRespBuffer.getShort(ZosSession.tcpipHeaderOffset + 10);
        System.out.println("Payload Descriptor is : " + payloadDescriptor);
        this.bbRespBuffer.clear();
        ZosSession cfr_ignored_1 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_2 = CorePlugin.getDefault().session;
        int iNumber = this.bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset + 2);
        ZosSession cfr_ignored_3 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_4 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_5 = CorePlugin.getDefault().session;
        int iLen = this.bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset + ZosSession.lseHeaderOffset_len);
        System.out.println("Number of tokens : " + iNumber);
        ZosSession cfr_ignored_6 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_7 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_8 = CorePlugin.getDefault().session;
        int offset = ZosSession.bnetHeaderOffset + ZosSession.lseHeaderOffset + ZosSession.tcpipHeaderOffset;
        if (payloadDescriptor == 16) {
            int i = 0;
            while (i < iNumber) {
                String slort_token = this.byteBufToString(offset + Integer.parseInt("0", 16), 8, 'A');
                String slort_stc = this.byteBufToString(offset + Integer.parseInt("8", 16), 4, 'A');
                String slort_reqno = this.byteBufToString(offset + Integer.parseInt("C", 16), this.constants.reqbytebufsize, 'A');
                int slort_seqno = this.bbRespBuffer.getInt(offset + Integer.parseInt("10", 16));
                this.tokensList.add(String.valueOf(slort_seqno) + ";" + slort_stc.trim() + ";" + slort_reqno.trim() + ";" + slort_token);
                String logstr = "getRemoteTokensList:  " + slort_seqno + " " + slort_stc + " " + slort_reqno + " " + slort_token;
                System.out.println("TokensList - " + logstr);
                CorePlugin.getDefault().log.debug(logstr);
                offset += iLen;
                ++i;
            }
        }
        Collections.sort(this.tokensList);
    }

    public String byteBufToString(int offset, int length, char codepage) {
        byte[] ba = new byte[length];
        String sValue = null;
        int j = 0;
        while (j < length) {
            ba[j] = this.bbRespBuffer.get(offset + j);
            ++j;
        }
        try {
            sValue = codepage == 'E' ? new String(ba, CorePlugin.getDefault().getPreferenceStore().getString("codePage")) : new String(ba);
        }
        catch (Exception e) {
            String logstr = "byteBufToString: offset: " + offset + ", length: " + length + ", codepage: " + codepage + " : Exception " + e;
            System.out.println("byteBufToString - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        return sValue;
    }
}

