/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.data;

import com.banknet.core.CorePlugin;
import com.banknet.core.data.ParseUtilities;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.ZosSession;
import com.banknet.core.models.TemplateModel;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class TemplateList {
    Constants constants = new Constants();
    ParseUtilities parseutils = new ParseUtilities();
    public final String STATUS_FORMAT_LONG = "long";
    public final String STATUS_FORMAT_SHORT = "short";
    boolean displayField;
    byte[] bRespBuffer;
    int lrecl = 2048;
    SimpleDateFormat dtfmt = new SimpleDateFormat("yyyyMMddHHmmssSS");
    SimpleDateFormat dtfmtlist = new SimpleDateFormat("EEEE MMM dd yyyy HH:mm:00.00");
    TemplateModel parent;
    TemplateModel templatemodel;
    TemplateModel templatemodels;
    TemplateModel root = new TemplateModel(null);
    public List<TemplateModel> templates;
    public List<Integer> templateId;
    public int totalTemplates = 0;
    String templateScope = "";
    String userId = "";
    Date tmpdate;
    Date requestDate;
    byte[] pmex_h_type = new byte[1];
    int reqnum;
    byte[] pme_flagse = new byte[1];
    boolean errMsgStatus = false;
    int itemplateId = 0;

    public TemplateModel getTemplateList(String scope, String user, IProgressMonitor monitor) throws Exception {
        if (CorePlugin.getDefault().activeStc.length() <= 0) {
            return this.templatemodels;
        }
        this.templateScope = scope;
        this.userId = user;
        this.getRemoteTemplateList(monitor);
        this.templatemodels = this.root;
        this.totalTemplates = this.templateId.size() - 1;
        return this.templatemodels;
    }

    public void getRemoteTemplateList(IProgressMonitor monitor) throws Exception {
        String[] commandarr = new String[2];
        this.templates = Collections.synchronizedList(new ArrayList());
        this.templateId = new ArrayList<Integer>();
        commandarr[0] = String.valueOf(this.constants.ZOSMESSAGE_CONNSTC) + " " + CorePlugin.getDefault().activeStc;
        commandarr[1] = String.valueOf(this.constants.ZOSMESSAGE_GETTEMPLATELIST) + " " + this.templateScope;
        String logstr = "getRemoteTemplateList:  Running " + commandarr[0];
        System.out.println("TemplateList - " + logstr);
        CorePlugin.getDefault().log.debug(logstr);
        CorePlugin.getDefault().session.doCmdResp(commandarr[0], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
        CorePlugin.getDefault().session.checkResponse();
        if (CorePlugin.getDefault().session.getReturnCode() >= 1000) {
            return;
        }
        if (CorePlugin.getDefault().session.getReturnCode() != 0) {
            logstr = "getRemoteTemplateList:  error RC - " + CorePlugin.getDefault().session.getReturnCode();
            System.out.println("TemplateList - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            return;
        }
        logstr = "getRemoteTemplateList:  Running " + commandarr[1];
        System.out.println("TemplateList - " + logstr);
        CorePlugin.getDefault().log.debug(logstr);
        this.bRespBuffer = CorePlugin.getDefault().session.doCmdResp(commandarr[1], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        CorePlugin.getDefault().session.checkResponse();
        if (CorePlugin.getDefault().session.getReturnCode() >= 1000) {
            return;
        }
        if (CorePlugin.getDefault().session.getReturnCode() != 0) {
            logstr = "getRemoteTemplateList:  error RC - " + CorePlugin.getDefault().session.getReturnCode();
            System.out.println("TemplateList - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            return;
        }
        this.parseutils.setBbRespBuffer(bbRespBuffer);
        short newLen = 0;
        bbRespBuffer.clear();
        ZosSession cfr_ignored_0 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_1 = CorePlugin.getDefault().session;
        int iNumber = bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset + 2);
        ZosSession cfr_ignored_2 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_3 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_4 = CorePlugin.getDefault().session;
        int iLen = bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset + ZosSession.lseHeaderOffset_len);
        int cfr_ignored_5 = iNumber / 4;
        ZosSession cfr_ignored_6 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_7 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_8 = CorePlugin.getDefault().session;
        int offset = ZosSession.bnetHeaderOffset + ZosSession.lseHeaderOffset + ZosSession.tcpipHeaderOffset;
        Byte[] bSSLOE_version = new Byte[]{bbRespBuffer.get(offset + Integer.parseInt("2", 16))};
        int ssloe_version = bSSLOE_version[0].intValue();
        System.out.println("**THE PME VERSION for TEMPLATELIST IS " + ssloe_version);
        int i = 0;
        while (i < iNumber) {
            this.templatemodel = null;
            try {
                if (iLen == 0) {
                    newLen = bbRespBuffer.getShort(offset + 0);
                    ZosSession cfr_ignored_9 = CorePlugin.getDefault().session;
                    offset += ZosSession.ssloeOffset;
                }
                this.parsePME(offset, ssloe_version);
            }
            catch (Exception e) {
                try {
                    logstr = "getRemoteTemplateList:  skipped template id " + this.itemplateId + ", error exception: " + e;
                    System.out.println("TemplateList - " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                    this.templatemodel = null;
                }
                catch (Exception exception) {}
            }
            if (this.templatemodel != null) {
                this.templatemodels = this.root;
                this.templatemodels.child.add(this.templatemodel);
                this.templates.add(this.templatemodel);
                this.templateId.add(this.itemplateId);
            }
            if (iLen == 0) {
                ZosSession cfr_ignored_10 = CorePlugin.getDefault().session;
                offset = offset + newLen - ZosSession.ssloeOffset;
            } else {
                offset += iLen;
            }
            ++i;
        }
    }

    private void parsePME(int offset, int ssloe_version) {
        String pme_desc;
        String pme_userid;
        String pme_variant;
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        int overlay_offset = 0;
        if (ssloe_version == 2) {
            overlay_offset = 4;
        }
        if (ssloe_version >= 3) {
            overlay_offset = 28;
            overlay_offset += 128;
        }
        ++this.itemplateId;
        this.parent = this.root;
        this.templatemodel = new TemplateModel(this.parent);
        Date pme_stck_req = null;
        long lSTCK = bbRespBuffer.getLong(offset + Integer.parseInt("8", 16));
        this.templatemodel.reqdate = pme_stck_req = this.parseutils.parseSTCK(lSTCK);
        this.tmpdate = pme_stck_req;
        this.requestDate = pme_stck_req;
        this.templatemodel.variant = pme_variant = this.byteBufToString(offset + Integer.parseInt("18", 16), 1);
        this.templatemodel.ownedby = pme_userid = this.byteBufToString(offset + Integer.parseInt("1A", 16), 8);
        String pme_jobname = this.byteBufToString(offset + Integer.parseInt("22", 16), 8);
        if (pme_jobname.length() == 8 && pme_variant.equals("J") && !pme_jobname.contains("%")) {
            pme_jobname = pme_jobname.concat("%");
        }
        this.templatemodel.jobname = pme_jobname;
        this.templatemodel.description = pme_desc = this.byteBufToString(offset + Integer.parseInt("66", 16), 48);
        String pme_templateName = this.byteBufToString(offset + Integer.parseInt("17F", 16), 17);
        this.templatemodel.templateName = new String(pme_templateName);
    }

    private String byteBufToString(int offset, int length) {
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        byte[] ba = new byte[length];
        int j = 0;
        while (j < length) {
            ba[j] = bbRespBuffer.get(offset + j);
            ++j;
        }
        String sValue = new String(ba).trim();
        return sValue;
    }
}

