/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.data;

import com.banknet.core.CorePlugin;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.VersionCompatibilityExtension;
import com.banknet.core.internal.ZosSession;
import java.nio.ByteBuffer;
import org.eclipse.core.runtime.IProgressMonitor;

public class StcProperties {
    Constants constants = new Constants();
    VersionCompatibilityExtension compat = new VersionCompatibilityExtension();
    byte[] bRespBuffer;
    public String maxsamplerate;
    public String maxsamplesize;
    public String sampledur;
    public String nsamples;
    public String expirydays;
    public String expiryprot;
    public String ussmaxobs;
    public String db2imax;
    public String imsimax;
    public String mqimax = "";
    public Integer imaxsamplesize;
    public Integer imaxsamplerate;
    public boolean ussobsallowed;
    public boolean imsiEnabled;
    public boolean db2iEnabled;
    public boolean cicsiEnabled;
    public boolean mqiEnabled;
    public boolean adabasEnabled;
    public boolean naturalEnabled;
    public boolean wasEnabled;
    public boolean db2xEnabled;
    public boolean sysEnabled;
    public boolean wlpEnabled;
    public boolean PABENT_FLAGS3_DescReqd;
    public boolean PABENT_FLAGS3_FillDefaults;
    public boolean PABENT_FLAGS3_DB2IDisp;
    public boolean PABENT_FLAGS3_IMSIDisp;
    public boolean PABENT_FLAGS5_MQIDisp;
    public boolean PABENT_FLAGS3_CICSIEna;
    public boolean PABENT_FLAGS3_SecImp;
    public boolean PABENT_CICS;
    public boolean PABENT_CICSI;
    public boolean PABENT_DB2;
    public boolean PABENT_DB2I;
    public boolean PABENT_DB2V;
    public boolean PABENT_DB2X;
    public boolean PABENT_IMS;
    public boolean PABENT_IMSI;
    public boolean PABENT_MQ;
    public boolean PABENT_MQI;
    public boolean PABENT_JAVA;
    public boolean PABENT_ADA;
    public boolean PABENT_NAT;
    public boolean PABENT_CDB2;
    public boolean PABENT_WAS;
    public boolean PABENT_SRB;
    public boolean PABENT_SYS;
    public boolean PABENT_WLP;
    public boolean PABENT_FLAGS_DefLocSys;
    public Integer imultijoblimit;

    public void getStcProperties(IProgressMonitor monitor) throws Exception {
        if (CorePlugin.getDefault().activeStc.length() > 0) {
            this.getRemoteStcProperties(monitor);
        }
    }

    public void getLocalStcProperties(IProgressMonitor monitor) throws Exception {
        try {
            String smaxsamplerate = "099999";
            this.imaxsamplerate = new Integer(smaxsamplerate);
            this.maxsamplerate = this.constants.decfmt4.format(this.imaxsamplerate);
            String smaxsamplesize = "150000";
            this.imaxsamplesize = new Integer(smaxsamplesize);
            this.maxsamplesize = this.constants.decfmt4.format(this.imaxsamplesize);
            String ssampledur = "0030";
            Integer isampledur = new Integer(ssampledur);
            this.sampledur = this.constants.decfmt4.format(isampledur);
            String snsamples = "00001000";
            Integer insamples = new Integer(snsamples);
            this.nsamples = this.constants.decfmt4.format(insamples);
            String sexpirydays = "0180";
            Integer iexpirydays = new Integer(sexpirydays);
            this.expirydays = this.constants.decfmt4.format(iexpirydays);
            this.expiryprot = "Y";
            String sussmaxobs = "20";
            Integer iussmaxobs = new Integer(sussmaxobs);
            this.ussmaxobs = this.constants.decfmt4.format(iussmaxobs);
            this.ussobsallowed = true;
        }
        catch (NumberFormatException ex) {
            System.out.println("StcProperties Number format exception " + ex);
        }
    }

    public void getRemoteStcProperties(IProgressMonitor monitor) throws Exception {
        String[] commandarr = new String[]{String.valueOf(this.constants.ZOSMESSAGE_GETSTCPROPERTIES) + " " + CorePlugin.getDefault().activeStc};
        String logstr = "getRemoteStcProperties:  Running " + commandarr[0];
        System.out.println("StcProperties - " + logstr);
        CorePlugin.getDefault().log.debug(logstr);
        this.bRespBuffer = CorePlugin.getDefault().session.doCmdResp(commandarr[0], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
        if (this.bRespBuffer == null) {
            logstr = "getRemoteStcProperties:  null response buffer";
            System.out.println("StcProperties - " + logstr);
            CorePlugin.getDefault().log.debug(logstr);
            return;
        }
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        CorePlugin.getDefault().session.checkResponse();
        if (CorePlugin.getDefault().session.getReturnCode() >= 1000) {
            logstr = "getRemoteStcProperties:  Connect error " + CorePlugin.getDefault().session.getReturnCode() + ", set connect local";
            System.out.println("StcProperties - " + logstr);
            CorePlugin.getDefault().log.debug(logstr);
            return;
        }
        if (CorePlugin.getDefault().session.getReturnCode() != 0) {
            logstr = "getRemoteStcProperties: error RC - " + CorePlugin.getDefault().session.getReturnCode();
            System.out.println("StcProperties - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            return;
        }
        if (bbRespBuffer.limit() <= 0) {
            return;
        }
        ZosSession cfr_ignored_0 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_1 = CorePlugin.getDefault().session;
        int offset = ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset;
        try {
            String pabent_hlq = this.byteBufToString(offset + Integer.parseInt("16", 16), 17);
            System.out.println("pabent_hlq " + pabent_hlq);
            String smaxsamplerate = this.byteBufToString(offset + Integer.parseInt("31", 16), 6);
            this.imaxsamplerate = new Integer(smaxsamplerate);
            this.maxsamplerate = this.constants.decfmt4.format(this.imaxsamplerate);
            String smaxsamplesize = this.byteBufToString(offset + Integer.parseInt("37", 16), 6);
            this.imaxsamplesize = new Integer(smaxsamplesize);
            this.maxsamplesize = this.constants.decfmt4.format(this.imaxsamplesize);
            String ssampledur = this.byteBufToString(offset + Integer.parseInt("3D", 16), 4);
            Integer isampledur = new Integer(ssampledur);
            this.sampledur = this.constants.decfmt4.format(isampledur);
            String snsamples = this.byteBufToString(offset + Integer.parseInt("41", 16), 8);
            Integer insamples = new Integer(snsamples);
            this.nsamples = this.constants.decfmt4.format(insamples);
            this.imsiEnabled = false;
            this.db2iEnabled = false;
            this.PABENT_FLAGS_DefLocSys = false;
            byte[] pabent_flags = new byte[1];
            int pabent_flags_result = 0;
            pabent_flags[0] = bbRespBuffer.get(offset + Integer.parseInt("4D", 16));
            pabent_flags_result = 0x10 & pabent_flags[0];
            if (pabent_flags_result == 16) {
                this.PABENT_FLAGS_DefLocSys = true;
                System.out.println("DefLocSys is enabled");
            }
            if ((pabent_flags_result = 8 & pabent_flags[0]) == 8) {
                this.db2iEnabled = true;
                System.out.println("DB2 Intercept is enabled");
            }
            if ((pabent_flags_result = 2 & pabent_flags[0]) == 2) {
                this.imsiEnabled = true;
                System.out.println("IMS Intercept is enabled");
            }
            short pabent_DB2IMax = bbRespBuffer.getShort(offset + Integer.parseInt("52", 16));
            this.db2imax = this.constants.decfmt4.format(pabent_DB2IMax);
            short pabent_IMSIMax = bbRespBuffer.getShort(offset + Integer.parseInt("54", 16));
            this.imsimax = this.constants.decfmt4.format(pabent_IMSIMax);
            String sexpirydays = this.byteBufToString(offset + Integer.parseInt("56", 16), 4);
            Integer iexpirydays = new Integer(sexpirydays);
            this.expirydays = this.constants.decfmt4.format(iexpirydays);
            this.expiryprot = this.byteBufToString(offset + Integer.parseInt("5A", 16), 1);
            this.byteBufToString(offset + Integer.parseInt("5B", 16), 1);
            Short hussmaxobs = bbRespBuffer.getShort(offset + Integer.parseInt("5C", 16));
            this.ussmaxobs = this.constants.decfmt4.format(hussmaxobs);
            System.out.println("USSMaxObs " + this.ussmaxobs);
            String pabent_mjlimit = "";
            this.imultijoblimit = 0;
            try {
                pabent_mjlimit = this.byteBufToString(offset + Integer.parseInt("5E", 16), 2);
                this.imultijoblimit = new Integer(pabent_mjlimit);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (Exception exception) {}
            if (this.imultijoblimit <= 0) {
                this.imultijoblimit = 20;
            }
            System.out.println("imultijoblimit " + this.imultijoblimit);
            ZosSession cfr_ignored_2 = CorePlugin.getDefault().session;
            byte stcPropertiesVersion = bbRespBuffer.get(ZosSession.tcpipHeaderOffset + 12);
            System.out.println("Version is " + stcPropertiesVersion);
            CorePlugin.getDefault().expWarnDays = 255;
            if (stcPropertiesVersion > 1) {
                byte temp_expWarnDays = bbRespBuffer.get(offset + Integer.parseInt("60", 16));
                int pabent_expWarnDays = this.twosComplement(temp_expWarnDays);
                CorePlugin.getDefault().expWarnDays = pabent_expWarnDays;
            }
            System.out.println("Expiry Warn Days : " + CorePlugin.getDefault().expWarnDays);
            this.wasEnabled = false;
            this.db2xEnabled = false;
            if (bbRespBuffer.limit() > offset + Integer.parseInt("62", 16)) {
                int pabent_flags4_result = 0;
                byte[] pabent_flags4 = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("62", 16))};
                pabent_flags4_result = 0x10 & pabent_flags4[0];
                if (pabent_flags4_result == 16) {
                    this.wasEnabled = true;
                }
                System.out.println("WAS Enabled : " + this.wasEnabled);
                pabent_flags4_result = 2 & pabent_flags4[0];
                if (pabent_flags4_result == 2) {
                    this.db2xEnabled = true;
                }
                System.out.println("DB2X Enabled : " + this.db2xEnabled);
            }
            this.mqiEnabled = false;
            this.sysEnabled = false;
            this.wlpEnabled = false;
            boolean mqiActive = false;
            this.PABENT_WLP = false;
            if (bbRespBuffer.limit() > offset + Integer.parseInt("63", 16)) {
                int pabent_flags5_result = 0;
                byte[] pabent_flags5 = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("63", 16))};
                pabent_flags5_result = 0x80 & pabent_flags5[0];
                if (pabent_flags5_result == 128) {
                    this.mqiEnabled = true;
                }
                System.out.println("MQI Enabled : " + this.mqiEnabled);
                pabent_flags5_result = 0x10 & pabent_flags5[0];
                if (pabent_flags5_result == 16) {
                    this.wlpEnabled = true;
                }
                System.out.println("WLP Extractor enabled : " + this.wlpEnabled);
                pabent_flags5_result = 8 & pabent_flags5[0];
                if (pabent_flags5_result == 8) {
                    this.sysEnabled = true;
                }
                System.out.println("SYS Extractor enabled : " + this.sysEnabled);
                pabent_flags5_result = 0x40 & pabent_flags5[0];
                if (pabent_flags5_result == 64) {
                    mqiActive = true;
                }
                System.out.println("MQI Active : " + mqiActive);
                pabent_flags5_result = 0x20 & pabent_flags5[0];
                if (pabent_flags5_result == 32) {
                    this.PABENT_FLAGS5_MQIDisp = true;
                }
                System.out.println("MQI Display Max Trace : " + this.PABENT_FLAGS5_MQIDisp);
                short pabent_MQIMax = bbRespBuffer.getShort(offset + Integer.parseInt("64", 16));
                this.mqimax = this.constants.decfmt4.format(pabent_MQIMax);
                System.out.println("pabent_MQIMax " + this.mqimax);
            }
            this.PABENT_FLAGS3_DescReqd = false;
            this.PABENT_FLAGS3_FillDefaults = false;
            this.PABENT_FLAGS3_DB2IDisp = false;
            this.PABENT_FLAGS3_IMSIDisp = false;
            this.PABENT_FLAGS3_CICSIEna = false;
            this.PABENT_FLAGS3_SecImp = false;
            int pabentFlags3_result = 0;
            byte[] pabent_flags3 = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("4F", 16))};
            pabentFlags3_result = 0x40 & pabent_flags3[0];
            if (pabentFlags3_result == 64) {
                this.PABENT_FLAGS3_DescReqd = true;
                System.out.println("Description required in NEW");
            }
            if ((pabentFlags3_result = 0x20 & pabent_flags3[0]) == 32) {
                this.PABENT_FLAGS3_FillDefaults = true;
                System.out.println("Fill defaults on NEW");
            }
            if ((pabentFlags3_result = 8 & pabent_flags3[0]) == 8) {
                this.PABENT_FLAGS3_SecImp = true;
            }
            System.out.println("Secure Import " + this.PABENT_FLAGS3_SecImp);
            pabentFlags3_result = 4 & pabent_flags3[0];
            if (pabentFlags3_result == 4) {
                this.PABENT_FLAGS3_DB2IDisp = true;
            }
            System.out.println("DB2IDisp is " + this.PABENT_FLAGS3_DB2IDisp);
            pabentFlags3_result = 2 & pabent_flags3[0];
            if (pabentFlags3_result == 2) {
                this.PABENT_FLAGS3_IMSIDisp = true;
            }
            System.out.println("IMSIDisp is " + this.PABENT_FLAGS3_IMSIDisp);
            pabentFlags3_result = 1 & pabent_flags3[0];
            if (pabentFlags3_result == 1) {
                this.cicsiEnabled = true;
                System.out.println("CICSI Intercept Enabled");
            }
            if ((pabentFlags3_result = 1 & pabent_flags3[0]) == 1) {
                this.PABENT_FLAGS3_CICSIEna = true;
                System.out.println("CICSI Default Selected");
            }
            this.PABENT_CICS = false;
            this.PABENT_DB2 = false;
            this.PABENT_DB2I = false;
            this.PABENT_DB2V = false;
            this.PABENT_DB2X = false;
            this.PABENT_IMS = false;
            this.PABENT_IMSI = false;
            this.PABENT_MQ = false;
            this.PABENT_JAVA = false;
            this.PABENT_SYS = false;
            int pabentExt_result = 0;
            byte[] pabent_exton = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("50", 16))};
            pabentExt_result = 0x80 & pabent_exton[0];
            if (pabentExt_result == 128) {
                this.PABENT_CICS = true;
                System.out.println("CICS Default Selected");
            }
            if ((pabentExt_result = 0x40 & pabent_exton[0]) == 64) {
                this.PABENT_DB2 = true;
                System.out.println("DB2 Default Selected");
            }
            if ((pabentExt_result = 0x20 & pabent_exton[0]) == 32) {
                this.PABENT_DB2I = true;
                System.out.println("DB2I Default Selected");
            }
            if ((pabentExt_result = 0x10 & pabent_exton[0]) == 16) {
                this.PABENT_DB2V = true;
                System.out.println("DB2V Default Selected");
            }
            if ((pabentExt_result = 8 & pabent_exton[0]) == 8) {
                this.PABENT_IMS = true;
                System.out.println("IMS Default Selected");
            }
            if ((pabentExt_result = 4 & pabent_exton[0]) == 4) {
                this.PABENT_IMSI = true;
                System.out.println("IMSI Default Selected");
            }
            if ((pabentExt_result = 2 & pabent_exton[0]) == 2) {
                this.PABENT_MQ = true;
                System.out.println("MQ Default Selected");
            }
            if ((pabentExt_result = 1 & pabent_exton[0]) == 1) {
                this.PABENT_JAVA = true;
                System.out.println("JAVA Default Selected");
            }
            this.PABENT_ADA = false;
            this.PABENT_NAT = false;
            this.PABENT_CDB2 = false;
            this.PABENT_CICSI = false;
            this.PABENT_WAS = false;
            this.PABENT_DB2X = false;
            this.PABENT_SRB = false;
            this.PABENT_MQI = false;
            this.PABENT_WLP = false;
            byte[] pabent_exton2 = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("51", 16))};
            pabentExt_result = 0x80 & pabent_exton2[0];
            if (pabentExt_result == 128) {
                this.PABENT_ADA = true;
                System.out.println("ADA Default Selected");
            }
            if ((pabentExt_result = 0x40 & pabent_exton2[0]) == 64) {
                this.PABENT_NAT = true;
                System.out.println("Natural Default Selected");
            }
            if ((pabentExt_result = 0x20 & pabent_exton2[0]) == 32) {
                this.PABENT_CDB2 = true;
                System.out.println("CDB2 Default Selected");
            }
            if ((pabentExt_result = 0x10 & pabent_exton2[0]) == 16) {
                this.PABENT_CICSI = true;
                System.out.println("CICS+ Default Selected");
            }
            if ((pabentExt_result = 8 & pabent_exton2[0]) == 8) {
                this.PABENT_WAS = true;
                System.out.println("WAS Default Selected");
            }
            if ((pabentExt_result = 4 & pabent_exton2[0]) == 4) {
                this.PABENT_DB2X = true;
                System.out.println("DB2X Default Selected");
            }
            if ((pabentExt_result = 2 & pabent_exton2[0]) == 2) {
                this.PABENT_SRB = true;
                System.out.println("SRB Default Selected");
            }
            if ((pabentExt_result = 1 & pabent_exton2[0]) == 1) {
                this.PABENT_MQI = true;
                System.out.println("MQI Default Extractor Selected");
            }
            int pabentExtOn3_result = 0;
            byte[] pabent_exton3 = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("66", 16))};
            pabentExtOn3_result = 0x80 & pabent_exton3[0];
            if (pabentExtOn3_result == 128) {
                this.PABENT_WLP = true;
                System.out.println("WLP Default Selected");
            }
            byte[] pabent_flags2 = new byte[1];
            this.ussobsallowed = false;
            this.adabasEnabled = false;
            this.naturalEnabled = false;
            pabent_flags2[0] = bbRespBuffer.get(offset + Integer.parseInt("4E", 16));
            int result = 4 & pabent_flags2[0];
            if (result == 4) {
                this.ussobsallowed = true;
            }
            if ((result = 0x80 & pabent_flags2[0]) == 128) {
                this.adabasEnabled = true;
                System.out.println("ADABAS Enabled");
            }
            if ((result = 2 & pabent_flags2[0]) == 2) {
                this.naturalEnabled = true;
                System.out.println("Natural Enabled");
            }
        }
        catch (NumberFormatException ex) {
            System.out.println("StcProperties Number format exception " + ex);
        }
    }

    private String byteBufToString(int offset, int length) {
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        byte[] ba = new byte[length];
        int j = 0;
        while (j < length) {
            ba[j] = bbRespBuffer.get(offset + j);
            ++j;
        }
        String sValue = new String(ba).trim();
        return sValue;
    }

    private int twosComplement(byte expWarnDays) {
        int returnValue = 0;
        returnValue = expWarnDays < 0 ? expWarnDays & 0xFF : expWarnDays;
        return returnValue;
    }
}

