/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.data;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.data.Messages;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.ZosSession;
import com.banknet.core.models.StcModel;
import java.io.File;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class StcList {
    ZosConnect zosconnect = new ZosConnect();
    Constants constants = new Constants();
    SimpleDateFormat dtfmt = new SimpleDateFormat("yyyy-MM-dd");
    SimpleDateFormat tmfmt = new SimpleDateFormat("HH:mm");
    String systemname = "";
    public String stcid = "";
    StcModel parent;
    StcModel stcmodel;
    StcModel stcmodels;
    StcModel root = new StcModel(null);
    ByteBuffer bbRespBuffer;
    byte[] bRespBuffer;
    String defaultStc = "";
    boolean activeStcFound = false;
    String firstStc = "";
    String firstSpx = "";
    IEclipsePreferences connpref;

    public StcModel getStcList(IProgressMonitor monitor) throws Exception {
        String logstr;
        StringBuilder stringBuilder = new StringBuilder("/instance/");
        CorePlugin.getDefault();
        this.connpref = InstanceScope.INSTANCE.getNode(stringBuilder.append("com.banknet.core").append("/connections/").append(CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId")).toString());
        this.defaultStc = this.connpref.get(this.constants.CONNPREF_DEFAULT_STC, "");
        this.getLocalSystemList(monitor);
        this.stcmodels = this.root;
        StcModel parent = this.root;
        try {
            int j = 0;
            while (j < this.stcmodels.child.size()) {
                if (((StcModel)this.stcmodels.child.get((int)j)).modellevel.equals(this.constants.STCLEVEL_SYSTEM) && ((StcModel)this.stcmodels.child.get((int)j)).connectionid.equals(CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId"))) {
                    parent = (StcModel)this.stcmodels.child.get(j);
                }
                ++j;
            }
        }
        catch (Exception exception) {
            parent = this.root;
        }
        this.getRemoteStcList(monitor, parent);
        if (this.stcmodels != null) {
            try {
                Collections.sort(this.stcmodels.getChildren(), new SystemStcComparator());
            }
            catch (Exception e) {
                logstr = "getStcList:  error sorting STC list " + e.getMessage();
                System.out.println("StcList - " + logstr);
                CorePlugin.getDefault().log.error(logstr);
            }
            this.stcmodels = this.root;
        }
        if (!this.activeStcFound) {
            CorePlugin.getDefault().activeStc = this.firstStc;
            CorePlugin.getDefault().activeSpxgname = this.firstSpx;
        }
        if (this.defaultStc.length() <= 0) {
            try {
                this.connpref.put(CorePlugin.getDefault().constants.CONNPREF_DEFAULT_STC, this.firstStc);
                this.connpref.flush();
            }
            catch (BackingStoreException be) {
                logstr = "getStcList:  BackingStoreException saving defaultSTC: " + be.getMessage();
                System.out.println("StcList - " + logstr);
                CorePlugin.getDefault().log.error(logstr);
            }
            catch (Exception ex) {
                System.out.println("Exception saving defaultSTC: " + ex.getMessage());
                logstr = "getStcList:  Exception saving defaultSTC: " + ex.getMessage();
                System.out.println("StcList - " + logstr);
                CorePlugin.getDefault().log.error(logstr);
            }
        }
        return this.stcmodels;
    }

    public void getRemoteStcList(IProgressMonitor monitor, StcModel parent) throws Exception {
        String[] commandarr = new String[]{this.constants.ZOSMESSAGE_GETSTCLIST};
        String logstr = "getRemoteStcList:  Running " + commandarr[0];
        System.out.println("StcList - " + logstr);
        CorePlugin.getDefault().log.debug(logstr);
        this.bRespBuffer = CorePlugin.getDefault().session.doCmdResp(commandarr[0], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
        CorePlugin.getDefault().session.checkResponse();
        if (CorePlugin.getDefault().session.getReturnCode() >= 1000) {
            logstr = "getRemoteStcList:  Connect error " + CorePlugin.getDefault().session.getReturnCode() + ", set connect local";
            System.out.println("StcList - " + logstr);
            CorePlugin.getDefault().log.debug(logstr);
            return;
        }
        if (CorePlugin.getDefault().session.getReturnCode() != 0) {
            logstr = "getRemoteStcList: error RC - " + CorePlugin.getDefault().session.getReturnCode();
            System.out.println("StcList - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            return;
        }
        if (this.bRespBuffer == null) {
            return;
        }
        this.bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        if (this.bbRespBuffer.limit() <= 0) {
            return;
        }
        this.parseStcList(parent);
    }

    public void parseStcList(StcModel parent) throws Exception {
        this.bbRespBuffer.clear();
        ZosSession cfr_ignored_0 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_1 = CorePlugin.getDefault().session;
        Byte bStcPropertiesVersion = this.bbRespBuffer.get(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset);
        int stcPropertiesVersion = bStcPropertiesVersion.intValue();
        System.out.println("STC Properties Version is " + stcPropertiesVersion);
        ZosSession cfr_ignored_2 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_3 = CorePlugin.getDefault().session;
        int iNumber = this.bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset + 2);
        ZosSession cfr_ignored_4 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_5 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_6 = CorePlugin.getDefault().session;
        int iLen = this.bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset + ZosSession.lseHeaderOffset_len);
        ZosSession cfr_ignored_7 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_8 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_9 = CorePlugin.getDefault().session;
        int offset = ZosSession.bnetHeaderOffset + ZosSession.lseHeaderOffset + ZosSession.tcpipHeaderOffset;
        int i = 0;
        while (i < iNumber) {
            this.stcmodel = null;
            try {
                this.parseStc(offset, parent, stcPropertiesVersion);
            }
            catch (Exception e) {
                try {
                    String stcid = this.byteBufToString(offset + Integer.parseInt("0", 16), 4);
                    String logstr = "getRemoteStcList:  skipped stc id " + stcid + ", error exception: " + e;
                    System.out.println("StcList - " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                }
                catch (Exception exception) {}
                this.stcmodel = null;
            }
            offset += iLen;
            ++i;
        }
    }

    private void parseStc(int offset, StcModel parent, int stcPropertiesVersion) throws Exception {
        String sSTCID = this.byteBufToString(offset + Integer.parseInt("0", 16), 4);
        int taskidx = -1;
        try {
            int i = 0;
            while (i < parent.child.size()) {
                if (((StcModel)parent.child.get((int)i)).stcid.equals(sSTCID)) {
                    taskidx = i;
                    this.stcmodel = (StcModel)parent.child.get(i);
                    break;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            String logstr = "parseStc:  stcid " + sSTCID + ", system  " + CorePlugin.getDefault().hostproperties.sSystemName + " not found.";
            System.out.println("ObservationList - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        if (this.stcmodel == null) {
            if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") < 0) {
                return;
            }
            this.stcmodel = new StcModel(parent);
        }
        this.stcmodel.stcid = sSTCID;
        this.stcmodel.systemname = CorePlugin.getDefault().hostproperties.sSystemName;
        this.stcmodel.version = this.byteBufToString(offset + Integer.parseInt("4", 16), 8);
        this.stcmodel.jobname = this.byteBufToString(offset + Integer.parseInt("C", 16), 8);
        int iDtStart = this.bbRespBuffer.getInt(offset + 20);
        String sDtStart = Integer.toHexString(iDtStart).trim();
        Date dtDtStart = new SimpleDateFormat("yyyyMMdd").parse(sDtStart);
        this.stcmodel.dtstart = sDtStart = this.dtfmt.format(dtDtStart);
        int iTmStart = this.bbRespBuffer.getInt(offset + 24);
        String sTmStart = Integer.toHexString(iTmStart);
        this.stcmodel.tmstart = sTmStart = this.rightJustify(sTmStart, 8, '0');
        this.stcmodel.dsnhlq = this.byteBufToString(offset + Integer.parseInt("1C", 16), 17);
        this.stcmodel.spxgname = this.byteBufToString(offset + Integer.parseInt("2D", 16), 8);
        if (stcPropertiesVersion > 1) {
            this.stcmodel.apar = this.byteBufToString(offset + Integer.parseInt("35", 16), 8);
        }
        if (parent.isRemoteStc) {
            this.stcmodel.isRemoteStc = true;
            if (CorePlugin.getDefault().versionextension.filterStc(this.stcmodel.version)) {
                this.stcmodel.isRemoteStc = false;
                this.stcmodel = null;
                return;
            }
        } else {
            this.stcmodel.isRemoteStc = false;
        }
        this.stcmodel.modellevel = this.constants.STCLEVEL_STC;
        this.stcmodel.connectionid = parent.connectionid;
        this.stcmodel.connstcid = String.valueOf(this.stcmodel.connectionid) + "_" + this.stcmodel.stcid;
        if (this.stcmodel.stcid.equals(CorePlugin.getDefault().activeStc)) {
            if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0) {
                this.stcmodel.isRemoteStc = true;
                if (true) {
                    this.activeStcFound = true;
                    CorePlugin.getDefault().activeSpxgname = this.stcmodel.spxgname;
                }
            } else {
                this.activeStcFound = true;
                CorePlugin.getDefault().activeSpxgname = this.stcmodel.spxgname;
            }
        } else if (this.firstStc.length() <= 0 || this.stcmodel.stcid.equalsIgnoreCase(this.defaultStc)) {
            if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0) {
                this.stcmodel.isRemoteStc = true;
                if (true) {
                    this.firstStc = this.stcmodel.stcid;
                    this.firstSpx = this.stcmodel.spxgname;
                }
            } else {
                this.firstStc = this.stcmodel.stcid;
                this.firstSpx = this.stcmodel.spxgname;
            }
        }
        this.stcmodels = parent;
        if (taskidx < 0) {
            this.stcmodels.child.add(this.stcmodel);
        } else {
            this.stcmodels.child.set(taskidx, this.stcmodel);
        }
    }

    public String rightJustify(String s, int length, char pad) {
        StringBuffer buffer = new StringBuffer(s);
        while (buffer.length() < length) {
            buffer.insert(0, pad);
        }
        return buffer.toString();
    }

    private String byteBufToString(int offset, int length) {
        this.bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        byte[] ba = new byte[length];
        int j = 0;
        while (j < length) {
            ba[j] = this.bbRespBuffer.get(offset + j);
            ++j;
        }
        String sValue = new String(ba).trim();
        return sValue;
    }

    public void getLocalSystemList(IProgressMonitor monitor) throws Exception {
        File path = new File(String.valueOf(CorePlugin.getDefault().getPreferenceStore().getString("coreDataPath")) + CorePlugin.getDefault().productextension.getProductFolder() + File.separator);
        File[] folders = path.listFiles();
        int i = 0;
        while (i < folders.length) {
            if (folders[i].isDirectory()) {
                System.out.println(folders[i].getName());
                File[] files = folders[i].listFiles();
                int j = 0;
                while (j < files.length) {
                    StcModel parent;
                    if (files[j].getName().equalsIgnoreCase("GETHOSTPROPERTIES.TXT") && (parent = this.addSystem(folders[i].getName())) != null && CorePlugin.getDefault().getPreferenceStore().getBoolean("showInactiveStcs")) {
                        this.getLocalStcList(folders[i].getName(), parent);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private StcModel addSystem(String connid) {
        this.parent = this.root;
        this.stcmodel = new StcModel(this.parent);
        this.stcmodel.stcid = connid;
        this.stcmodel.connstcid = String.valueOf(connid) + "_" + connid;
        this.stcmodel.jobname = "";
        this.stcmodel.spxgname = "";
        this.stcmodel.systemname = connid;
        this.stcmodel.version = "";
        this.stcmodel.apar = "";
        this.stcmodel.dtstart = "";
        this.stcmodel.tmstart = "";
        this.stcmodel.dsnhlq = "";
        this.stcmodel.modellevel = this.constants.STCLEVEL_SYSTEM;
        if (CorePlugin.getDefault().connectionextension.getConnectionAttrib(connid)) {
            this.stcmodel.connectionid = CorePlugin.getDefault().connectionextension.getConnectionId();
            this.stcmodel.connectionname = CorePlugin.getDefault().connectionextension.getConnectionName();
            this.stcmodel.servername = CorePlugin.getDefault().connectionextension.getServerName();
            this.stcmodel.portname = CorePlugin.getDefault().connectionextension.getPortName();
            this.stcmodel.isRemoteStc = CorePlugin.getDefault().connectionextension.getIsConnectionRemote();
            this.stcmodels = this.parent;
            this.stcmodels.child.add(this.stcmodel);
        } else {
            this.stcmodel = null;
        }
        return this.stcmodel;
    }

    public void getLocalStcList(String systemname, StcModel parent) throws Exception {
        File path = new File(String.valueOf(CorePlugin.getDefault().getPreferenceStore().getString("coreDataPath")) + CorePlugin.getDefault().productextension.getProductFolder() + File.separator + systemname + File.separator);
        if (!path.exists()) {
            path.mkdir();
        }
        File[] folders = path.listFiles();
        int i = 0;
        while (i < folders.length) {
            if (folders[i].isDirectory() && folders[i].getName().length() <= 4) {
                File[] files = folders[i].listFiles();
                int j = 0;
                while (j < files.length) {
                    if (files[j].getName().equalsIgnoreCase("GETSTCPROPERTIES.TXT")) {
                        this.chkAddStc(folders[i].getName(), parent);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void chkAddStc(String stcid, StcModel parent) {
        this.stcmodel = new StcModel(parent);
        this.stcmodel.stcid = stcid;
        this.stcmodel.jobname = Messages.getString("StcList.Jobname.Inactive");
        this.stcmodel.spxgname = "";
        this.stcmodel.systemname = this.systemname;
        this.stcmodel.connectionid = parent.connectionid;
        this.stcmodel.connstcid = String.valueOf(this.stcmodel.connectionid) + "_" + this.stcmodel.stcid;
        this.stcmodel.version = "";
        this.stcmodel.apar = "";
        this.stcmodel.dtstart = "";
        this.stcmodel.tmstart = "";
        this.stcmodel.dsnhlq = "";
        this.stcmodel.isRemoteStc = false;
        this.stcmodel.modellevel = this.constants.STCLEVEL_STC;
        this.stcmodels = parent;
        this.stcmodels.child.add(this.stcmodel);
        if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") < 0 & this.stcmodel.stcid.equals(CorePlugin.getDefault().activeStc)) {
            this.activeStcFound = true;
            CorePlugin.getDefault().activeSpxgname = this.stcmodel.spxgname;
        }
    }

    private void showMessage(String title, String message, String msgtype) {
        if (msgtype.equalsIgnoreCase("error")) {
            PlatformUI.getWorkbench().getDisplay();
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
        } else if (msgtype.equalsIgnoreCase("warning")) {
            PlatformUI.getWorkbench().getDisplay();
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
        } else {
            PlatformUI.getWorkbench().getDisplay();
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
        }
    }

    public StcModel getActiveStc() {
        StcModel stc = CorePlugin.getDefault().getStcModel();
        if (stc != null) {
            int j = 0;
            while (j < stc.getChildren().size()) {
                StcModel systemitem = stc.getChildren().get(j);
                if (systemitem.connectionid.equalsIgnoreCase(CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId"))) {
                    int i = 0;
                    while (i < systemitem.getChildren().size()) {
                        StcModel stcitem = systemitem.getChildren().get(i);
                        if (stcitem.stcid.equalsIgnoreCase(CorePlugin.getDefault().activeStc)) {
                            return stcitem;
                        }
                        ++i;
                    }
                }
                ++j;
            }
        }
        return stc;
    }

    class SystemStcComparator
    implements Comparator<StcModel> {
        SystemStcComparator() {
        }

        @Override
        public int compare(StcModel a, StcModel b) {
            String systemStca = String.valueOf(a.modellevel) + a.stcid;
            String systemStcb = String.valueOf(b.modellevel) + b.stcid;
            return systemStca.compareToIgnoreCase(systemStcb);
        }
    }
}

