/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.data;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.data.ParseUtilities;
import com.banknet.core.dialogs.spm.SpmConstants;
import com.banknet.core.internal.ZosSession;
import java.nio.ByteBuffer;
import org.eclipse.core.runtime.IProgressMonitor;

public class SpmList {
    public String[] spmListArray;
    private String spmListType;
    public byte[] bRespBuffer;
    public ByteBuffer bbRespBuffer;
    ZosConnect zosconnect = new ZosConnect();
    ParseUtilities parseUtilities = new ParseUtilities();
    SpmConstants spmconstants = new SpmConstants();

    public void getSpmList(IProgressMonitor monitor, String spmListType) throws Exception {
        this.spmListType = spmListType;
        this.getRemoteSpmList(monitor);
    }

    public void getRemoteSpmList(IProgressMonitor monitor) throws Exception {
        String[] commandarr = new String[]{String.valueOf(CorePlugin.getDefault().constants.ZOSMESSAGE_GETSPMLIST) + " " + this.spmListType};
        String logstr = "getRemoteSpmList:  Running " + commandarr[0];
        System.out.println("SpmList - " + logstr);
        CorePlugin.getDefault().log.debug(logstr);
        this.bRespBuffer = CorePlugin.getDefault().session.doCmdResp(commandarr[0], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
        CorePlugin.getDefault().session.checkResponse();
        if (CorePlugin.getDefault().session.getReturnCode() >= 1000) {
            logstr = "getRemoteSpmList:  Connect error " + CorePlugin.getDefault().session.getReturnCode() + ", set connect local";
            System.out.println("SpmList - " + logstr);
            CorePlugin.getDefault().log.debug(logstr);
            this.zosconnect.setConnectLocal();
            return;
        }
        if (CorePlugin.getDefault().session.getReturnCode() != 0) {
            logstr = "getRemoteSpmList: error RC - " + CorePlugin.getDefault().session.getReturnCode();
            System.out.println("SpmList - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            return;
        }
        this.bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        if (this.bbRespBuffer.limit() <= 0) {
            return;
        }
        ZosSession cfr_ignored_0 = CorePlugin.getDefault().session;
        short payloadDescriptor = this.bbRespBuffer.getShort(ZosSession.tcpipHeaderOffset + 10);
        System.out.println("Payload Descriptor is : " + payloadDescriptor);
        this.bbRespBuffer.clear();
        ZosSession cfr_ignored_1 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_2 = CorePlugin.getDefault().session;
        int iNumber = this.bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset + 2);
        ZosSession cfr_ignored_3 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_4 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_5 = CorePlugin.getDefault().session;
        this.bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset + ZosSession.lseHeaderOffset_len);
        System.out.println("Number of spm datasets : " + iNumber);
        ZosSession cfr_ignored_6 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_7 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_8 = CorePlugin.getDefault().session;
        int offset = ZosSession.bnetHeaderOffset + ZosSession.lseHeaderOffset + ZosSession.tcpipHeaderOffset;
        int spmarraysize = iNumber;
        this.spmListArray = new String[spmarraysize];
        short spm_EntLen = 0;
        if (payloadDescriptor == 14) {
            spm_EntLen = 0;
            int i = 0;
            while (i < iNumber) {
                spm_EntLen = this.bbRespBuffer.getShort(offset + Integer.parseInt("0", 16));
                String spm_SeqNumber = this.byteBufToString(offset + Integer.parseInt("2", 16), 4, 'E');
                String spm_FileType = this.byteBufToString(offset + Integer.parseInt("6", 16), 1, 'E');
                String spm_Repository = this.byteBufToString(offset + Integer.parseInt("7", 16), 1, 'E');
                byte[] ba1 = new byte[]{this.bbRespBuffer.get(offset + Integer.parseInt("8", 16))};
                byte dsnLength = ba1[0];
                String spm_DSN = this.byteBufToString(offset + Integer.parseInt("9", 16), dsnLength, 'E');
                if (!this.spmListType.equals(this.spmconstants.SPMLISTTYPE_DIRS)) {
                    spm_DSN = spm_DSN.replace("/", " ");
                }
                System.out.println(String.valueOf(spm_SeqNumber) + " " + spm_FileType + " " + spm_Repository + " " + spm_DSN);
                this.spmListArray[i] = String.valueOf(spm_FileType.trim()) + "," + spm_Repository.trim() + "," + spm_DSN.trim();
                offset += spm_EntLen;
                ++i;
            }
        }
        if (payloadDescriptor == 15) {
            spm_EntLen = 0;
            int expanded_reqnum = 1;
            if (CorePlugin.getDefault().constants.reqbytebufsize < 5) {
                expanded_reqnum = 0;
            }
            int i = 0;
            while (i < iNumber) {
                spm_EntLen = this.bbRespBuffer.getShort(offset + Integer.parseInt("0", 16));
                String spm_ReqNumber = this.byteBufToString(offset + Integer.parseInt("2", 16), CorePlugin.getDefault().constants.reqbytebufsize, 'E');
                String spm_SrchSeq = this.byteBufToString(offset + Integer.parseInt("6", 16) + expanded_reqnum, 2, 'E');
                String spm_ReqTime = this.byteBufToString(offset + Integer.parseInt("8", 16) + expanded_reqnum, 16, 'E');
                String spm_ProfId = this.byteBufToString(offset + Integer.parseInt("18", 16) + expanded_reqnum, 4, 'E');
                byte[] ba1 = new byte[]{this.bbRespBuffer.get(offset + Integer.parseInt("1C", 16) + expanded_reqnum)};
                byte pathLength = ba1[0];
                String spm_Path = "";
                spm_Path = this.byteBufToString(offset + Integer.parseInt("1D", 16) + expanded_reqnum, pathLength, 'E');
                System.out.println(String.valueOf(spm_ReqNumber) + " " + spm_SrchSeq + " " + spm_ReqTime + " " + spm_ProfId + " " + spm_Path);
                this.spmListArray[i] = String.valueOf(spm_ProfId.trim()) + "-" + spm_ReqNumber.trim() + "," + spm_SrchSeq.trim() + "," + spm_Path.trim();
                offset += spm_EntLen;
                ++i;
            }
        }
    }

    public boolean getSpmAdminFlag(IProgressMonitor monitor) {
        boolean spmAdminFlag = false;
        this.bRespBuffer = CorePlugin.getDefault().session.doCmdResp("PING", CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
        CorePlugin.getDefault().session.checkResponse();
        if (CorePlugin.getDefault().session.getReturnCode() >= 1000) {
            String logstr = "getRemoteSpmList:  Connect error " + CorePlugin.getDefault().session.getReturnCode() + ", set connect local";
            System.out.println("SpmList - " + logstr);
            CorePlugin.getDefault().log.debug(logstr);
            this.zosconnect.setConnectLocal();
            return spmAdminFlag;
        }
        if (CorePlugin.getDefault().session.getReturnCode() != 0) {
            String logstr = "getRemoteSpmList: error RC - " + CorePlugin.getDefault().session.getReturnCode();
            System.out.println("SpmList - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            return spmAdminFlag;
        }
        this.bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        this.bbRespBuffer.clear();
        System.out.println("Ping Response size is : " + this.bbRespBuffer.limit());
        ZosSession cfr_ignored_0 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_1 = CorePlugin.getDefault().session;
        int pingOffset = ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset;
        int pingResponseLength = this.bbRespBuffer.limit() - pingOffset;
        System.out.println("Ping Response length is : " + pingResponseLength);
        String ping_Response = this.byteBufToString(pingOffset + Integer.parseInt("0", 16), pingResponseLength, 'A');
        System.out.println("Response from Ping is : " + ping_Response);
        String[] pingResponseArray = ping_Response.split(",");
        if (pingResponseArray.length > 0 && pingResponseArray[1].trim().toUpperCase().equals("Y")) {
            spmAdminFlag = true;
        }
        return spmAdminFlag;
    }

    public String byteBufToString(int offset, int length, char codepage) {
        byte[] ba = new byte[length];
        String sValue = null;
        int j = 0;
        while (j < length) {
            ba[j] = this.bbRespBuffer.get(offset + j);
            ++j;
        }
        try {
            sValue = codepage == 'E' ? new String(ba, CorePlugin.getDefault().getPreferenceStore().getString("codePage")) : new String(ba);
        }
        catch (Exception e) {
            String logstr = "byteBufToString: offset: " + offset + ", length: " + length + ", codepage: " + codepage + " : Exception " + e;
            System.out.println("byteBufToString - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        return sValue;
    }

    public String[] getspmListResults() {
        return this.spmListArray;
    }
}

